/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.tools.WideSearchDialog;
import app_util.PopupText;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDevice;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceInfo;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class WideSearchTree
extends JTree
implements TangoConst {
    static ImageIcon tango_icon;
    static ImageIcon class_icon;
    static ImageIcon cmd_icon;
    private DefaultMutableTreeNode root;
    private WideSearchTreePopupMenu menu;
    private JDialog parent;
    private static final Color background;
    private static final int DISPLAY_INFO = 0;
    private static final int HOST_PANEL = 1;
    private static final int OFFSET = 2;
    private static String[] menuLabels;

    public WideSearchTree(JDialog jDialog, String string) throws DevFailed {
        this.parent = jDialog;
        this.setBackground(background);
        this.buildTree(string);
        this.menu = new WideSearchTreePopupMenu(this);
        this.expandChildren(this.root);
        this.setSelectionPath(null);
    }

    private void buildTree(String string) throws DevFailed {
        this.root = new DefaultMutableTreeNode("Objects found for  " + string);
        this.createCollectionClassNodes(string);
        this.getSelectionModel().setSelectionMode(1);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(this.root);
        this.setModel(defaultTreeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        TangoRenderer tangoRenderer = new TangoRenderer();
        this.setCellRenderer(tangoRenderer);
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                WideSearchTree.this.expandedPerfomed(treeExpansionEvent);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                WideSearchTree.this.treeMouseClicked(mouseEvent);
            }
        });
    }

    private void treeMouseClicked(MouseEvent mouseEvent) {
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(treePath.getPathCount() - 1);
        Object object = defaultMutableTreeNode.getUserObject();
        int n = mouseEvent.getModifiers();
        if (!(mouseEvent.getClickCount() == 2 && (n & 0x10) != 0 || (n & 4) == 0 || object instanceof TangoClass)) {
            this.menu.showMenu(mouseEvent, (LeafClass)object);
        }
    }

    public void expandedPerfomed(TreeExpansionEvent treeExpansionEvent) {
    }

    private Vector<CollectionClass> initGlobalObject(String string) throws DevFailed {
        Object object;
        Object object2;
        Vector<CollectionClass> vector = new Vector<CollectionClass>();
        Database database = ApiUtil.get_db_obj();
        String[] stringArray = database.get_class_list(string);
        if (stringArray.length > 0) {
            object2 = new CollectionClass("Classes");
            for (String string2 : stringArray) {
                ((Vector)object2).add(new TangoClass(string2));
            }
            vector.add((CollectionClass)object2);
        }
        if (((String[])(object2 = database.get_server_list(string))).length > 0) {
            object = new CollectionClass("Servers");
            for (String string3 : object2) {
                ((Vector)object).add(new TangoServer(string3));
            }
            vector.add((CollectionClass)object);
        }
        try {
            object = database.get_device_list(string);
            if (((String[])object).length > 0) {
                CollectionClass collectionClass = new CollectionClass("Devices");
                for (Object object3 : object) {
                    collectionClass.add(new TangoDevice((String)object3));
                }
                vector.add(collectionClass);
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            ((WideSearchDialog)this.parent).setWarning();
        }
        catch (DevFailed devFailed) {
            if (devFailed.errors[0].reason.equals("API_CommandNotFound")) {
                ((WideSearchDialog)this.parent).setWarning();
            }
            throw devFailed;
        }
        object = database.get_device_alias_list(string);
        if (((String[])object).length > 0) {
            CollectionClass collectionClass = new CollectionClass("Aliases");
            for (Object object3 : object) {
                collectionClass.add(new TangoAlias((String)object3));
            }
            vector.add(collectionClass);
        }
        return vector;
    }

    private void createCollectionClassNodes(String string) throws DevFailed {
        Vector<CollectionClass> vector = this.initGlobalObject(string);
        if (vector.size() == 0) {
            this.root.setUserObject("No Object Found for  " + string);
        } else {
            for (CollectionClass collectionClass : vector) {
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(collectionClass);
                this.root.add(defaultMutableTreeNode);
                for (Object e : collectionClass) {
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(e));
                }
            }
        }
    }

    private DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
    }

    private Object getSelectedObject() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        if (defaultMutableTreeNode == null) {
            return null;
        }
        return defaultMutableTreeNode.getUserObject();
    }

    private void expandChildren(DefaultMutableTreeNode defaultMutableTreeNode) {
        boolean bl = false;
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (defaultMutableTreeNode2.isLeaf()) {
                if (bl) continue;
                this.expandNode(defaultMutableTreeNode2);
                bl = true;
                continue;
            }
            this.expandChildren(defaultMutableTreeNode2);
        }
    }

    private void expandNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>();
        vector.add(defaultMutableTreeNode);
        while (defaultMutableTreeNode != this.root) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            vector.insertElementAt(defaultMutableTreeNode, 0);
        }
        Object[] objectArray = new DefaultMutableTreeNode[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            objectArray[i] = (TreeNode)vector.get(i);
        }
        TreePath treePath = new TreePath(objectArray);
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
    }

    private DeviceInfo getDevInfo(String string) throws DevFailed {
        DbDevice dbDevice = new DbDevice(string);
        return dbDevice.get_info();
    }

    private String getAliasInfo(TangoAlias tangoAlias) throws DevFailed {
        StringBuffer stringBuffer = new StringBuffer("------------ ");
        stringBuffer.append(tangoAlias.name).append(" Info ------------\n\n");
        String string = ApiUtil.get_db_obj().get_alias_device(tangoAlias.name);
        stringBuffer.append("Alias for device :   ").append(string).append("\n\n");
        stringBuffer.append(this.getDeviceInfo(string));
        return stringBuffer.toString();
    }

    private String getDeviceInfo(TangoDevice tangoDevice) throws DevFailed {
        return this.getDeviceInfo(tangoDevice.name);
    }

    private String getDeviceInfo(String string) throws DevFailed {
        StringBuffer stringBuffer = new StringBuffer("------------ ");
        stringBuffer.append(string).append("  Info ------------\n\n");
        DeviceInfo deviceInfo = this.getDevInfo(string);
        stringBuffer.append(deviceInfo);
        return stringBuffer.toString();
    }

    private String getServerInfo(TangoServer tangoServer) throws DevFailed {
        StringBuffer stringBuffer = new StringBuffer("------------ ");
        stringBuffer.append(tangoServer.name).append("  Info ------------\n\n");
        DeviceInfo deviceInfo = this.getDevInfo("dserver/" + tangoServer.name);
        stringBuffer.append(deviceInfo);
        DbServer dbServer = new DbServer(tangoServer.name);
        String[] stringArray = dbServer.get_class_list();
        stringBuffer.append("\n\n----------- Device(s) Served -----------\n\n");
        for (String string : stringArray) {
            String[] stringArray2;
            stringBuffer.append("\n").append(string).append(":\n");
            for (String string2 : stringArray2 = dbServer.get_device_name(string)) {
                stringBuffer.append("   ").append(string2).append("\n");
            }
        }
        return stringBuffer.toString();
    }

    private void displayInfo() {
        try {
            Object object = this.getSelectedObject();
            if (object instanceof TangoServer) {
                new PopupText(this.parent, true).show(this.getServerInfo((TangoServer)object));
            } else if (object instanceof TangoDevice) {
                new PopupText(this.parent, true).show(this.getDeviceInfo((TangoDevice)object));
            } else if (object instanceof TangoAlias) {
                new PopupText(this.parent, true).show(this.getAliasInfo((TangoAlias)object));
            }
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, (String)"", (DevFailed)devFailed);
        }
    }

    private void displayHostPanel() {
        try {
            Object object = this.getSelectedObject();
            String string = object instanceof TangoServer ? "dserver/" + ((TangoServer)object).name : (object instanceof TangoAlias ? ApiUtil.get_db_obj().get_alias_device(((TangoAlias)object).name) : ((TangoDevice)object).name);
            DeviceInfo deviceInfo = this.getDevInfo(string);
            String string2 = deviceInfo.hostname;
            ((WideSearchDialog)this.parent).displayHostPanel(string2);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, (String)"", (DevFailed)devFailed);
        }
    }

    static {
        background = new Color(240, 240, 240);
        menuLabels = new String[]{"Display Info", "Host Panel"};
    }

    private class WideSearchTreePopupMenu
    extends JPopupMenu {
        private JTree tree;
        private JLabel title;

        private WideSearchTreePopupMenu(JTree jTree) {
            this.tree = jTree;
            this.buildBtnPopupMenu();
        }

        private void buildBtnPopupMenu() {
            this.title = new JLabel();
            this.title.setFont(new Font("Dialog", 1, 16));
            this.add(this.title);
            this.add(new JPopupMenu.Separator());
            for (String string : menuLabels) {
                if (string == null) {
                    this.add(new JPopupMenu.Separator());
                    continue;
                }
                JMenuItem jMenuItem = new JMenuItem(string);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        WideSearchTreePopupMenu.this.hostActionPerformed(actionEvent);
                    }
                });
                this.add(jMenuItem);
            }
        }

        public void showMenu(MouseEvent mouseEvent, LeafClass leafClass) {
            TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            this.tree.setSelectionPath(treePath);
            this.title.setText(leafClass.toString());
            this.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
        }

        private void hostActionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            int n = 0;
            for (int i = 0; i < menuLabels.length; ++i) {
                if (this.getComponent(2 + i) != object) continue;
                n = i;
            }
            switch (n) {
                case 0: {
                    WideSearchTree.this.displayInfo();
                    break;
                }
                case 1: {
                    WideSearchTree.this.displayHostPanel();
                }
            }
        }
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private Font[] fonts;
        private final int TITLE = 0;
        private final int COLLEC = 1;
        private final int LEAF = 2;
        private Cursor dd_cursor = this.getNodeCursor("drg-drp.gif");

        public TangoRenderer() {
            this.fonts = new Font[3];
            this.fonts[0] = new Font("Dialog", 1, 18);
            this.fonts[1] = new Font("Dialog", 1, 12);
            this.fonts[2] = new Font("Dialog", 0, 12);
        }

        Cursor getNodeCursor(DefaultMutableTreeNode defaultMutableTreeNode) {
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof LeafClass) {
                return this.dd_cursor;
            }
            return new Cursor(0);
        }

        Cursor getNodeCursor(String string) {
            URL uRL = this.getClass().getResource("/app_util/img/" + string);
            Image image = Toolkit.getDefaultToolkit().getImage(uRL);
            return Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), string);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.setBackgroundNonSelectionColor(background);
            this.setForeground(Color.black);
            this.setBackgroundSelectionColor(Color.lightGray);
            if (n == 0) {
                this.setFont(this.fonts[0]);
            } else {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                if (defaultMutableTreeNode.getUserObject() instanceof CollectionClass) {
                    this.setFont(this.fonts[1]);
                } else {
                    this.setFont(this.fonts[2]);
                }
            }
            return this;
        }
    }

    private class CollectionClass
    extends Vector {
        String name;

        private CollectionClass(String string) {
            this.name = string;
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    private class TangoAlias
    extends LeafClass {
        private TangoAlias(String string) {
            super(string);
        }
    }

    private class TangoDevice
    extends LeafClass {
        private TangoDevice(String string) {
            super(string);
        }
    }

    private class TangoServer
    extends LeafClass {
        private TangoServer(String string) {
            super(string);
        }
    }

    private class TangoClass
    extends LeafClass {
        private TangoClass(String string) {
            super(string);
        }
    }

    private class LeafClass
    extends Vector {
        String name;

        private LeafClass(String string) {
            this.name = string;
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

