/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.tools.EventsTable;
import com.braju.format.Format;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AsynReplyNotArrived;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.AttributeProxy;
import fr.esrf.TangoApi.CommunicationFailed;
import fr.esrf.TangoApi.ConnectionFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.EventSystemFailed;
import fr.esrf.TangoApi.NonDbDevice;
import fr.esrf.TangoApi.NonSupportedFeature;
import fr.esrf.TangoApi.WrongData;
import fr.esrf.TangoApi.WrongNameSyntax;
import fr.esrf.TangoApi.events.ITangoArchiveListener;
import fr.esrf.TangoApi.events.ITangoChangeListener;
import fr.esrf.TangoApi.events.ITangoPeriodicListener;
import fr.esrf.TangoApi.events.TangoArchiveEvent;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoEventsAdapter;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;

public class SubscribedSignal
implements TangoConst {
    static final String defVal = "-----";
    Exception except = null;
    boolean subscribed = false;
    String name;
    String value = "-----";
    String time = "-----";
    String d_time = "-----";
    String d_value = "-----";
    Vector histo = new Vector();
    String devname;
    String attname;
    int mode;
    int cnt = 0;
    int data_type;
    private double dt_min = Double.MAX_VALUE;
    private double dt_max = 0.0;
    private double dt_average = 0.0;
    private double[] values = null;
    private double[] prev_val = null;
    private long t0;
    private TangoEventsAdapter adapter;
    private ArchiveEventListener arch_listener = null;
    private ChangeEventListener change_listener = null;
    private PeriodicEventListener periodic_listener = null;
    private EventsTable parent;
    private AttributeInfoEx attinfo;

    public SubscribedSignal(String string, int n) {
        this.name = string;
        int n2 = string.lastIndexOf("/");
        this.devname = string.substring(0, n2);
        this.attname = string.substring(n2 + 1);
        this.mode = n;
        try {
            this.attinfo = new AttributeProxy(string).get_info_ex();
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
    }

    void subscribe(EventsTable eventsTable) {
        this.parent = eventsTable;
        new SubscribeThread(this).start();
    }

    String except_str() {
        String string = "";
        if (this.except instanceof ConnectionFailed) {
            string = string + ((ConnectionFailed)this.except).getStack();
        } else if (this.except instanceof CommunicationFailed) {
            string = string + ((CommunicationFailed)this.except).getStack();
        } else if (this.except instanceof WrongNameSyntax) {
            string = string + ((WrongNameSyntax)this.except).getStack();
        } else if (this.except instanceof WrongData) {
            string = string + ((WrongData)this.except).getStack();
        } else if (this.except instanceof NonDbDevice) {
            string = string + ((NonDbDevice)this.except).getStack();
        } else if (this.except instanceof NonSupportedFeature) {
            string = string + ((NonSupportedFeature)this.except).getStack();
        } else if (this.except instanceof EventSystemFailed) {
            string = string + ((EventSystemFailed)this.except).getStack();
        } else if (this.except instanceof AsynReplyNotArrived) {
            string = string + ((AsynReplyNotArrived)this.except).getStack();
        } else if (this.except instanceof DevFailed) {
            DevFailed devFailed = (DevFailed)((Object)this.except);
            for (int i = 0; i < devFailed.errors.length; ++i) {
                string = string + devFailed.toString() + ":\n";
                string = string + "Tango exception\n";
                string = string + "Severity -> ";
                switch (devFailed.errors[i].severity.value()) {
                    case 0: {
                        string = string + "WARNING \n";
                        break;
                    }
                    case 1: {
                        string = string + "ERROR \n";
                        break;
                    }
                    case 2: {
                        string = string + "PANIC \n";
                        break;
                    }
                    default: {
                        string = string + "Unknown severity code";
                    }
                }
                string = string + "Desc -> " + devFailed.errors[i].desc + "\n";
                string = string + "Reason -> " + devFailed.errors[i].reason + "\n";
                string = string + "Origin -> " + devFailed.errors[i].origin + "\n";
                if (i >= devFailed.errors.length - 1) continue;
                string = string + "-------------------------------------------------------------\n";
            }
        } else {
            string = this.except.toString();
        }
        return string;
    }

    void setData(Exception exception) {
        this.value = defVal;
        this.d_time = defVal;
        this.d_value = defVal;
        this.except = exception;
    }

    void setData(DeviceAttribute deviceAttribute) throws DevFailed {
        long l = System.currentTimeMillis();
        double d = (double)(l - this.t0) / 1000.0;
        String string = SubscribedSignal.getStrDate(deviceAttribute.getTimeValMillisSec());
        ++this.cnt;
        this.time = "" + string;
        this.setValue(deviceAttribute);
        if (this.cnt > 1) {
            this.d_time = "" + d + " sec.";
            this.setDeltaValue();
        }
        if (this.cnt > 2) {
            if (d > this.dt_max) {
                this.dt_max = d;
            }
            if (d < this.dt_min) {
                this.dt_min = d;
            }
            this.dt_average = (this.dt_average * (double)(this.cnt - 3) + d) / (double)(this.cnt - 2);
        }
        this.t0 = l;
        if (this.values != null) {
            this.histo.add(new EventHisto(deviceAttribute.getTimeValMillisSec(), this.values, this.d_value, this.d_time));
            this.prev_val = this.values;
        }
        this.except = null;
    }

    private void setDeltaValue() {
        double d = 0.0;
        double d2 = 0.0;
        if (this.values != null && this.prev_val != null) {
            for (int i = 0; i < this.values.length && i < this.prev_val.length; ++i) {
                double d3 = Math.abs(this.values[i] - this.prev_val[i]);
                if (!(d3 > d)) continue;
                d = d3;
                if (this.prev_val[i] == 0.0) continue;
                d2 = d3 / this.prev_val[i];
            }
            this.d_value = SubscribedSignal.formatValue(d);
            d2 = (double)((int)(10000.0 * d2)) / 100.0;
            this.d_value = this.d_value + "  (" + d2 + " %)";
        }
    }

    static String formatValue(double d) {
        String string;
        if (d >= 20.0) {
            string = "" + (int)d;
        } else {
            string = "" + d;
            int n = string.indexOf(".");
            if (d >= 1.0 && n > 0) {
                string = string.substring(0, n + 2);
            } else if (d >= 0.1 && n > 0) {
                string = string.substring(0, n + 3);
            } else if (d >= 0.01 && n > 0) {
                string = string.substring(0, n + 4);
            } else if (d >= 0.001 && n > 0) {
                string = string.substring(0, n + 5);
            } else if (d >= 1.0E-4 && n > 0) {
                string = string.substring(0, n + 6);
            }
        }
        return string;
    }

    void unsubscribe() {
        if (this.subscribed && this.adapter != null) {
            try {
                if (this.arch_listener != null) {
                    this.adapter.removeTangoArchiveListener((ITangoArchiveListener)this.arch_listener, this.attname);
                }
                if (this.change_listener != null) {
                    this.adapter.removeTangoChangeListener((ITangoChangeListener)this.change_listener, this.attname);
                }
                if (this.periodic_listener != null) {
                    this.adapter.removeTangoPeriodicListener((ITangoPeriodicListener)this.periodic_listener, this.attname);
                }
                System.out.println("unsubscribe event for " + this.name);
            }
            catch (DevFailed devFailed) {
                System.out.println("Failed to unsubscribe event for " + this.name);
                Except.print_exception((Exception)((Object)devFailed));
            }
        }
    }

    public String toString() {
        return this.name + "  [" + EventsTable.strMode[this.mode] + "]";
    }

    public String getTimes() {
        if (this.cnt <= 2) {
            return null;
        }
        int n = (int)(1000.0 * this.dt_average);
        return "dt minimum = " + this.dt_min + " sec.\n" + "dt average   = " + (double)n / 1000.0 + " sec.\n" + "dt maximum = " + this.dt_max + " sec.";
    }

    public String status() {
        String string = this.name + ":\n" + Tango_CmdArgTypeName[this.data_type] + "\n\n";
        if (this.subscribed) {
            string = string + "Is  Subscribed On " + EventsTable.strMode[this.mode] + " mode\n";
            string = string + "Value:\n" + this.value + "\n\n";
            string = string + "Receive  " + this.cnt + " event";
            if (this.cnt > 1) {
                string = string + "s";
            }
            string = string + "  at " + SubscribedSignal.getStrDate();
            if (this.cnt > 2) {
                string = string + "\n" + this.getTimes();
            }
        } else if (this.except != null) {
            if (this.except instanceof DevFailed) {
                DevFailed devFailed = (DevFailed)((Object)this.except);
                string = string + devFailed.errors[0].desc;
            } else {
                string = string + this.except.toString();
            }
        } else {
            string = string + "? ? ?";
        }
        return string;
    }

    static String getStrDate(long l) {
        StringTokenizer stringTokenizer = new StringTokenizer(new Date(l).toString());
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        return vector.get(3) + "  " + vector.get(2) + " " + vector.get(1);
    }

    static String getStrDate() {
        return SubscribedSignal.getStrDate(System.currentTimeMillis());
    }

    private void setValue(DeviceAttribute deviceAttribute) throws DevFailed {
        this.value = "";
        String string = null;
        if (this.attinfo != null && !this.attinfo.format.equals("Not specified")) {
            string = this.attinfo.format;
        }
        this.data_type = deviceAttribute.getType();
        switch (this.data_type) {
            case 1: {
                boolean[] blArray = deviceAttribute.extractBooleanArray();
                if (blArray.length == 1) {
                    this.value = "" + blArray[0];
                    break;
                }
                for (int i = 0; i < blArray.length; ++i) {
                    this.value = this.value + (blArray[i] ? "1" : "0");
                    if ((i + 1) % 4 != 0) continue;
                    this.value = this.value + " ";
                }
                break;
            }
            case 22: {
                short[] sArray = deviceAttribute.extractUCharArray();
                for (int i = 0; i < sArray.length; ++i) {
                    this.value = this.value + "" + sArray[i];
                    if (i >= sArray.length - 1) continue;
                    this.value = this.value + "\n";
                }
                break;
            }
            case 2: {
                short[] sArray = deviceAttribute.extractShortArray();
                this.values = new double[sArray.length];
                for (int i = 0; i < sArray.length; ++i) {
                    if (string == null) {
                        this.value = this.value + "" + sArray[i];
                    } else {
                        Object[] objectArray = new Object[]{new Integer(sArray[i])};
                        this.value = this.value + Format.sprintf((String)string, (Object[])objectArray);
                    }
                    if (i < sArray.length - 1) {
                        this.value = this.value + "\n";
                    }
                    this.values[i] = sArray[i];
                }
                break;
            }
            case 6: {
                int[] nArray = deviceAttribute.extractUShortArray();
                this.values = new double[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    if (string == null) {
                        this.value = this.value + "" + nArray[i];
                    } else {
                        Object[] objectArray = new Object[]{new Integer(nArray[i])};
                        this.value = this.value + Format.sprintf((String)string, (Object[])objectArray);
                    }
                    if (i < nArray.length - 1) {
                        this.value = this.value + "\n";
                    }
                    this.values[i] = nArray[i];
                }
                break;
            }
            case 3: {
                int[] nArray = deviceAttribute.extractLongArray();
                this.values = new double[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    if (string == null) {
                        this.value = this.value + "" + nArray[i];
                    } else {
                        Object[] objectArray = new Object[]{new Integer(nArray[i])};
                        this.value = this.value + Format.sprintf((String)string, (Object[])objectArray);
                    }
                    if (i < nArray.length - 1) {
                        this.value = this.value + "\n";
                    }
                    this.values[i] = nArray[i];
                }
                break;
            }
            case 4: {
                float[] fArray = deviceAttribute.extractFloatArray();
                this.values = new double[fArray.length];
                for (int i = 0; i < fArray.length; ++i) {
                    if (string == null) {
                        this.value = this.value + "" + fArray[i];
                    } else {
                        Object[] objectArray = new Object[]{new Float(fArray[i])};
                        this.value = this.value + Format.sprintf((String)string, (Object[])objectArray);
                    }
                    if (i < fArray.length - 1) {
                        this.value = this.value + "\n";
                    }
                    this.values[i] = fArray[i];
                }
                break;
            }
            case 5: {
                double[] dArray = deviceAttribute.extractDoubleArray();
                this.values = new double[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    if (string == null) {
                        this.value = this.value + "" + dArray[i];
                    } else {
                        Object[] objectArray = new Object[]{new Double(dArray[i])};
                        this.value = this.value + Format.sprintf((String)string, (Object[])objectArray);
                    }
                    if (i < dArray.length - 1) {
                        this.value = this.value + "\n";
                    }
                    this.values[i] = dArray[i];
                }
                break;
            }
            case 8: {
                String[] stringArray = deviceAttribute.extractStringArray();
                for (int i = 0; i < stringArray.length; ++i) {
                    this.value = this.value + stringArray[i];
                    if (i >= stringArray.length - 1) continue;
                    this.value = this.value + "\n";
                }
                break;
            }
            case 19: {
                DevState devState = deviceAttribute.extractState();
                this.value = ApiUtil.stateName((DevState)devState);
                break;
            }
            default: {
                this.value = "" + this.data_type + " ?  - Unsuported Type";
            }
        }
    }

    class PeriodicEventListener
    implements ITangoPeriodicListener {
        SubscribedSignal signal;

        PeriodicEventListener(SubscribedSignal subscribedSignal2) {
            this.signal = subscribedSignal2;
        }

        public void periodic(TangoPeriodicEvent tangoPeriodicEvent) {
            try {
                DeviceAttribute deviceAttribute = tangoPeriodicEvent.getValue();
                this.signal.setData(deviceAttribute);
            }
            catch (DevFailed devFailed) {
                this.signal.setData((Exception)((Object)devFailed));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.signal.setData(exception);
            }
            SubscribedSignal.this.parent.updateTable();
        }
    }

    class ArchiveEventListener
    implements ITangoArchiveListener {
        SubscribedSignal signal;

        ArchiveEventListener(SubscribedSignal subscribedSignal2) {
            this.signal = subscribedSignal2;
        }

        public void archive(TangoArchiveEvent tangoArchiveEvent) {
            try {
                DeviceAttribute deviceAttribute = tangoArchiveEvent.getValue();
                this.signal.setData(deviceAttribute);
            }
            catch (DevFailed devFailed) {
                this.signal.setData((Exception)((Object)devFailed));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.signal.setData(exception);
            }
            SubscribedSignal.this.parent.updateTable();
        }
    }

    class ChangeEventListener
    implements ITangoChangeListener {
        SubscribedSignal signal;

        ChangeEventListener(SubscribedSignal subscribedSignal2) {
            this.signal = subscribedSignal2;
        }

        public void change(TangoChangeEvent tangoChangeEvent) {
            try {
                DeviceAttribute deviceAttribute = tangoChangeEvent.getValue();
                this.signal.setData(deviceAttribute);
            }
            catch (DevFailed devFailed) {
                this.signal.setData((Exception)((Object)devFailed));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.signal.setData(exception);
            }
            SubscribedSignal.this.parent.updateTable();
        }
    }

    class SubscribeThread
    extends Thread {
        SubscribedSignal signal;

        SubscribeThread(SubscribedSignal subscribedSignal2) {
            this.signal = subscribedSignal2;
        }

        @Override
        public void run() {
            while (!this.signal.subscribed) {
                System.out.println("Trying to subscribe on " + SubscribedSignal.this.name);
                try {
                    this.signal.adapter = new TangoEventsAdapter(SubscribedSignal.this.devname);
                    if (SubscribedSignal.this.mode == 2) {
                        SubscribedSignal.this.arch_listener = new ArchiveEventListener(this.signal);
                        SubscribedSignal.this.adapter.addTangoArchiveListener((ITangoArchiveListener)SubscribedSignal.this.arch_listener, SubscribedSignal.this.attname, new String[0]);
                    } else if (SubscribedSignal.this.mode == 0) {
                        SubscribedSignal.this.change_listener = new ChangeEventListener(this.signal);
                        SubscribedSignal.this.adapter.addTangoChangeListener((ITangoChangeListener)SubscribedSignal.this.change_listener, SubscribedSignal.this.attname, new String[0]);
                    } else if (SubscribedSignal.this.mode == 1) {
                        SubscribedSignal.this.periodic_listener = new PeriodicEventListener(this.signal);
                        SubscribedSignal.this.adapter.addTangoPeriodicListener((ITangoPeriodicListener)SubscribedSignal.this.periodic_listener, SubscribedSignal.this.attname, new String[0]);
                    } else {
                        Except.throw_exception((String)"", (String)("Unknown event subscribtion mode (" + SubscribedSignal.this.mode + ")"), (String)"SubscribedSignal.SubscribeThread.run()");
                    }
                    SubscribedSignal.this.subscribed = true;
                    System.out.println("subscribeEvent() done for " + SubscribedSignal.this.name);
                    SubscribedSignal.this.except = null;
                }
                catch (DevFailed devFailed) {
                    SubscribedSignal.this.except = devFailed;
                    Except.print_exception((Exception)((Object)devFailed));
                }
                catch (Exception exception) {
                    SubscribedSignal.this.except = exception;
                    exception.printStackTrace();
                }
                try {
                    SubscribeThread.sleep(2000L);
                }
                catch (Exception exception) {}
            }
        }
    }

    class EventHisto {
        long time;
        double[] values;
        String d_value;
        String d_time;
        Exception except;

        EventHisto(long l, double[] dArray, String string, String string2) {
            this.time = l;
            this.values = dArray;
            this.d_value = string;
            this.d_time = string2;
            this.except = null;
        }

        EventHisto(long l, Exception exception) {
            this.time = l;
            this.except = exception;
            this.values = null;
        }
    }
}

