/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.ApiUtil;
import java.util.StringTokenizer;
import java.util.Vector;

public class PolledElement {
    String devname = "unknown";
    String name = "unknown";
    String type;
    int period = -1;
    int buffer_depth = -1;
    double reading_time = -1.0;
    int last_update = -1;
    int[] real_periods = new int[0];
    DevState state;
    String status;
    String last_update_str = "";
    private static final String equal = " = ";
    private static final String since = " since ";
    private static final String externalyStr = "Polling externally triggered";
    boolean polled = true;
    private String[] info;

    public PolledElement(String string, String string2) {
        this.devname = string;
        this.status = string2;
        this.parsePollingStatus(string2);
        this.state = this.period < 0 || this.buffer_depth < 0 || this.reading_time < 0.0 || this.real_periods.length == 0 ? DevState.FAULT : ((double)this.real_periods[0] > 1.5 * (double)this.period || this.reading_time > (double)this.period ? DevState.FAULT : DevState.ON);
    }

    private void parsePeriod(String string) {
        if (string.startsWith(externalyStr)) {
            this.polled = false;
            return;
        }
        int n = string.indexOf(equal);
        if (n > 0) {
            String string2 = string.substring(n + equal.length());
            try {
                this.period = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void parseBufferDepth(String string) {
        int n = string.indexOf(equal);
        if (n > 0) {
            String string2 = string.substring(n + equal.length());
            try {
                this.buffer_depth = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void parseName(String string) {
        int n = string.indexOf(equal);
        if (n > 0) {
            this.name = string.substring(n + equal.length());
        }
        this.type = string.indexOf("attribute") > 0 ? "attribute" : "command";
    }

    private void parseDuration(String string) {
        int n = string.indexOf(equal);
        if (n > 0) {
            String string2 = string.substring(n + equal.length());
            try {
                this.reading_time = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            this.reading_time = 0.0;
        }
    }

    private void parseRealPeriod(String string) {
        int n = string.indexOf(equal);
        if (n > 0) {
            String string2 = string.substring(n + equal.length());
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ");
            Vector<String> vector = new Vector<String>();
            while (stringTokenizer.hasMoreTokens()) {
                vector.add(stringTokenizer.nextToken());
            }
            this.real_periods = new int[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                try {
                    this.real_periods[i] = Integer.parseInt((String)vector.get(i));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private void paseLastUpdate(String string) {
        int n = string.indexOf(since);
        if (n > 0) {
            String string2;
            this.last_update_str = string2 = string.substring(n + since.length());
            string2 = string2.substring(0, string2.indexOf("mS"));
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " S and ");
            Vector<String> vector = new Vector<String>();
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                vector.add(string3);
            }
            switch (vector.size()) {
                case 1: {
                    try {
                        this.last_update = Integer.parseInt((String)vector.get(0));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.last_update = 1000;
                    }
                    break;
                }
                case 2: {
                    try {
                        this.last_update = Integer.parseInt((String)vector.get(1));
                        this.last_update += 1000 * Integer.parseInt((String)vector.get(0));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.last_update += 60000;
                    }
                    break;
                }
                default: {
                    if (vector.size() <= 1) break;
                    try {
                        this.last_update = 60000 * Integer.parseInt((String)vector.get(0));
                        this.last_update += Integer.parseInt((String)vector.get(3));
                        this.last_update += 1000 * Integer.parseInt((String)vector.get(2));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.last_update += 60000;
                    }
                }
            }
        }
    }

    private void parsePollingStatus(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            vector.add(string2);
            switch (n) {
                case 0: {
                    this.parseName(string2);
                    break;
                }
                case 1: {
                    this.parsePeriod(string2);
                    break;
                }
                case 2: {
                    this.parseBufferDepth(string2);
                    break;
                }
                case 3: {
                    this.parseDuration(string2);
                    break;
                }
                case 4: {
                    this.paseLastUpdate(string2);
                    break;
                }
                case 5: {
                    this.parseRealPeriod(string2);
                }
            }
            ++n;
        }
        this.info = new String[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            this.info[n] = (String)vector.get(n);
        }
    }

    public String toString() {
        return this.name;
    }

    public String info() {
        String string = this.type + " " + this.name + ":\t" + this.period + " -> " + this.reading_time;
        string = string + "  (since " + this.last_update + ")\t";
        for (int i = 0; i < this.real_periods.length; ++i) {
            string = string + this.real_periods[i] + ", ";
        }
        string = string + "\t" + ApiUtil.stateName((DevState)this.state);
        return string;
    }

    public String[] getInfo() {
        int n;
        Object object;
        Vector<Object> vector = new Vector<Object>();
        if (this.polled) {
            vector.add(this.type + "  " + this.name);
            vector.add("Polling period = " + this.period + "ms");
            vector.add("Last record takes " + this.reading_time + " ms");
            if (this.info.length > 4) {
                vector.add(this.info[4]);
            }
            if (this.info.length > 5) {
                vector.add(this.info[5]);
            }
            vector.add("");
            object = "Drifts (ms):   ";
            for (n = 0; n < this.real_periods.length; ++n) {
                object = (String)object + "" + (this.real_periods[n] - this.period) + ", ";
            }
            vector.add(object);
        } else {
            object = new StringTokenizer(this.status, "\n");
            while (object.hasMoreTokens()) {
                vector.add(object.nextToken());
            }
        }
        object = new String[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            object[n] = (String)vector.get(n);
        }
        return object;
    }
}

