/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.Astor;
import admin.astor.AstorDefs;
import admin.astor.AstorUtil;
import admin.astor.RemoteLoginThread;
import admin.astor.TangoServer;
import admin.astor.tools.DeviceHierarchyDialog;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceInfo;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DeviceHierarchy
extends JTree
implements AstorDefs {
    private static ImageIcon root_icon;
    private Astor astor = null;
    private boolean running = true;
    private Device[] devices = null;
    private String rootname = null;
    private DefaultMutableTreeNode root;
    private DeviceHierarchyPopupMenu menu;
    private DeviceHierarchyDialog parent;
    private static final Color background;
    private static final String SUB_DEV_PROP_NAME = "__SubDevices";
    private static final boolean CHECK_SUB = true;
    private static final int UPDATE = 0;
    private static final int TEST_DEVICE = 1;
    private static final int HOST_PANEL = 2;
    private static final int REM_LOGIN = 3;
    private static final int OFFSET = 2;
    private static String[] menuLabels;
    private boolean refresh = false;

    public DeviceHierarchy(DeviceHierarchyDialog deviceHierarchyDialog, Astor astor, String string) throws DevFailed {
        this.parent = deviceHierarchyDialog;
        this.astor = astor;
        this.setBackground(background);
        this.initNames(string);
        this.buildTree();
        this.menu = new DeviceHierarchyPopupMenu(this);
        this.expandChildren(this.root);
        this.setSelectionPath(null);
    }

    private void initNames(String string) throws DevFailed {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[]{};
        switch (vector.size()) {
            case 2: {
                this.rootname = vector.get(0) + "/" + vector.get(1);
                String string2 = "dserver/" + this.rootname;
                String[] stringArray2 = new TangoServer(string2).queryDeviceFromDb();
                stringArray = new String[stringArray2.length + 1];
                System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
                stringArray[stringArray2.length] = string2;
                break;
            }
            case 3: {
                this.rootname = "Device";
                stringArray = new String[]{vector.get(0) + "/" + vector.get(1) + "/" + vector.get(2)};
                break;
            }
            default: {
                Except.throw_exception((String)"BAD_PARAMETER", (String)"Bad device or server name", (String)"DeviceHierarchy.initNames()");
            }
        }
        this.devices = new Device[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.devices[i] = new Device(null, stringArray[i], true);
        }
        new Refresher().start();
    }

    private void buildTree() {
        this.root = new DefaultMutableTreeNode(this.rootname);
        this.createDeviceNodes();
        this.getSelectionModel().setSelectionMode(1);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(this.root);
        this.setModel(defaultTreeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        TangoRenderer tangoRenderer = new TangoRenderer();
        this.setCellRenderer(tangoRenderer);
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                DeviceHierarchy.this.expandedPerfomed(treeExpansionEvent);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                DeviceHierarchy.this.treeMouseClicked(mouseEvent);
            }
        });
    }

    private void treeMouseClicked(MouseEvent mouseEvent) {
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(treePath.getPathCount() - 1);
        Object object = defaultMutableTreeNode.getUserObject();
        int n = mouseEvent.getModifiers();
        if (mouseEvent.getClickCount() != 2 || (n & 0x10) == 0) {
            if ((n & 0x10) != 0) {
                this.deviceInfo();
            } else if ((n & 4) != 0) {
                if (defaultMutableTreeNode == this.root) {
                    this.menu.showMenu(mouseEvent, (String)object);
                } else if (object instanceof Device) {
                    this.menu.showMenu(mouseEvent, (Device)object);
                }
            }
        }
    }

    public void expandedPerfomed(TreeExpansionEvent treeExpansionEvent) {
    }

    private void createDeviceNodes(DefaultMutableTreeNode defaultMutableTreeNode, Device device) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(device);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        for (int i = 0; i < device.size(); ++i) {
            this.createDeviceNodes(defaultMutableTreeNode2, device.getDevice(i));
        }
    }

    private void createDeviceNodes() {
        for (Device device : this.devices) {
            this.createDeviceNodes(this.root, device);
        }
    }

    private DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
    }

    Object getSelectedObject() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        if (defaultMutableTreeNode == null) {
            return null;
        }
        return defaultMutableTreeNode.getUserObject();
    }

    private void expandChildren(DefaultMutableTreeNode defaultMutableTreeNode) {
        boolean bl = false;
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (defaultMutableTreeNode2.isLeaf()) {
                if (bl) continue;
                this.expandNode(defaultMutableTreeNode2);
                bl = true;
                continue;
            }
            this.expandChildren(defaultMutableTreeNode2);
        }
    }

    private void expandNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>();
        vector.add(defaultMutableTreeNode);
        while (defaultMutableTreeNode != this.root) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            vector.insertElementAt(defaultMutableTreeNode, 0);
        }
        Object[] objectArray = new DefaultMutableTreeNode[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            objectArray[i] = (TreeNode)vector.get(i);
        }
        TreePath treePath = new TreePath(objectArray);
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
    }

    private void testDevice() {
        Object object = this.getSelectedObject();
        if (object instanceof Device) {
            AstorUtil.testDevice(this.parent, ((Device)object).name);
        }
    }

    private void deviceInfo() {
        Object object = this.getSelectedObject();
        if (object instanceof Device) {
            try {
                String string = ((Device)object).getInfo();
                this.parent.setText(string);
            }
            catch (DevFailed devFailed) {
                this.parent.setText(Except.str_exception((Exception)((Object)devFailed)));
            }
        }
    }

    private void remoteShell() {
        Object object = this.getSelectedObject();
        if (object instanceof Device) {
            try {
                String string = ((Device)object).getHost();
                new RemoteLoginThread(string, this.parent).start();
            }
            catch (DevFailed devFailed) {
                this.parent.setText(Except.str_exception((Exception)((Object)devFailed)));
            }
        }
    }

    private void hostPanel() {
        Object object = this.getSelectedObject();
        if (object instanceof Device) {
            try {
                Device device = (Device)object;
                this.astor.tree.displayHostInfoDialog(device.getHost());
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
            }
        }
    }

    void stopThread() {
        this.running = false;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Device device : this.devices) {
            stringBuffer.append(device.toFullString());
            for (int i = 0; i < device.size(); ++i) {
                stringBuffer.append(device.getDevice(i).toFullString());
            }
        }
        return stringBuffer.toString();
    }

    static {
        background = new Color(240, 240, 240);
        menuLabels = new String[]{"Update Dependencies", "Test Device", "Host Panel", "Remote Login"};
    }

    private class Refresher
    extends Thread {
        private Refresher() {
        }

        @Override
        public void run() {
            while (DeviceHierarchy.this.running) {
                if (DeviceHierarchy.this.refresh) {
                    DeviceHierarchy.this.refresh = false;
                    DeviceHierarchy.this.repaint();
                }
                try {
                    Refresher.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class Device
    extends Vector<Device> {
        String name;
        DeviceProxy proxy;
        DevFailed failed = null;
        boolean too_old = false;
        short state = 0;
        Device parent;

        private Device(Device device, String string, boolean bl) {
            AstorUtil.increaseSplashProgress(5, "checking for " + string);
            try {
                block10: {
                    this.parent = device;
                    this.name = string;
                    this.proxy = new DeviceProxy(string);
                    if (bl) {
                        try {
                            String[] stringArray;
                            DeviceData deviceData = this.proxy.get_adm_dev().command_inout("QuerySubDevice");
                            for (String string2 : stringArray = deviceData.extractStringArray()) {
                                int n = string2.indexOf(32);
                                if (n > 0) {
                                    boolean bl2;
                                    String string3 = string2.substring(0, n).trim();
                                    boolean bl3 = bl2 = device != null && device.alreadyHave(string2.substring(n).trim());
                                    if (!string3.toLowerCase().equals(string.toLowerCase())) continue;
                                    this.add(new Device(this, string2.substring(n).trim(), !bl2));
                                    continue;
                                }
                                if (!string.startsWith("dserver/")) continue;
                                this.add(new Device(this, string2, true));
                            }
                        }
                        catch (DevFailed devFailed) {
                            String[] stringArray;
                            if (devFailed.errors[0].reason.equals("API_CommandNotFound")) {
                                this.too_old = true;
                            }
                            DbDatum dbDatum = this.proxy.get_property(DeviceHierarchy.SUB_DEV_PROP_NAME);
                            if (dbDatum.is_empty()) break block10;
                            for (String string4 : stringArray = dbDatum.extractStringArray()) {
                                if (device == null) {
                                    this.add(new Device(this, string4, true));
                                    continue;
                                }
                                boolean bl4 = device.alreadyHave(string4);
                                this.add(new Device(this, string4, !bl4));
                            }
                        }
                    }
                }
                new StateManager().start();
            }
            catch (DevFailed devFailed) {
                System.err.println(devFailed.errors[0].desc);
                this.failed = devFailed;
            }
        }

        private boolean alreadyHave(String string) {
            if (this.name.equals(string)) {
                return true;
            }
            if (this.parent == null) {
                return false;
            }
            return this.parent.alreadyHave(string);
        }

        private Device getDevice(int n) {
            return (Device)this.get(n);
        }

        private String toFullString() {
            StringBuffer stringBuffer = new StringBuffer(this.name);
            stringBuffer.append('\n');
            for (int i = 0; i < this.size(); ++i) {
                Device device = this.getDevice(i);
                stringBuffer.append('\t').append(device.name).append('\n');
            }
            stringBuffer.append("------------------------------------------------");
            return stringBuffer.toString();
        }

        private String getHost() throws DevFailed {
            DeviceInfo deviceInfo = this.proxy.get_info();
            return deviceInfo.hostname;
        }

        private String getInfo() throws DevFailed {
            if (this.failed != null) {
                return Except.str_exception((Exception)((Object)this.failed));
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (this.too_old) {
                stringBuffer.append("   WARNING:  Too Old TANGO Release \n").append("             To get dependencies !!!\n").append("\n========================================================\n");
            }
            stringBuffer.append(this.proxy.get_info().toString());
            stringBuffer.append("\n========================================================\n");
            try {
                String string = this.proxy.status();
                stringBuffer.append(string);
            }
            catch (DevFailed devFailed) {
                stringBuffer.append(Except.str_exception((Exception)((Object)devFailed)));
            }
            return stringBuffer.toString();
        }

        @Override
        public String toString() {
            return this.name;
        }

        private class StateManager
        extends Thread {
            private StateManager() {
            }

            @Override
            public void run() {
                while (DeviceHierarchy.this.running) {
                    short s = Device.this.state;
                    try {
                        Device.this.proxy.ping();
                        Device.this.state = (short)3;
                    }
                    catch (DevFailed devFailed) {
                        Device.this.state = 1;
                    }
                    if (Device.this.state != s) {
                        DeviceHierarchy.this.refresh = true;
                    }
                    try {
                        StateManager.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    private class DeviceHierarchyPopupMenu
    extends JPopupMenu {
        private JTree tree;
        private JLabel title;

        private DeviceHierarchyPopupMenu(JTree jTree) {
            this.tree = jTree;
            this.buildBtnPopupMenu();
        }

        private void buildBtnPopupMenu() {
            this.title = new JLabel();
            this.title.setFont(new Font("Dialog", 1, 16));
            this.add(this.title);
            this.add(new JPopupMenu.Separator());
            for (String string : menuLabels) {
                if (string == null) {
                    this.add(new JPopupMenu.Separator());
                    continue;
                }
                JMenuItem jMenuItem = new JMenuItem(string);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DeviceHierarchyPopupMenu.this.deviceActionPerformed(actionEvent);
                    }
                });
                this.add(jMenuItem);
            }
        }

        public void showMenu(MouseEvent mouseEvent, String string) {
            TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            this.tree.setSelectionPath(treePath);
            this.title.setText(string);
            for (int i = 0; i < menuLabels.length; ++i) {
                this.getComponent(2 + i).setVisible(false);
            }
            this.getComponent(2).setVisible(true);
            this.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
        }

        public void showMenu(MouseEvent mouseEvent, Device device) {
            TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            this.tree.setSelectionPath(treePath);
            DeviceHierarchy.this.deviceInfo();
            if (device.failed == null) {
                this.title.setText(device.toString());
                this.getComponent(2).setVisible(false);
                for (int i = 3; i < menuLabels.length; ++i) {
                    this.getComponent(2 + i).setEnabled(false);
                }
                this.getComponent(5).setEnabled(AstorUtil.osIsUnix());
                this.getComponent(4).setEnabled(DeviceHierarchy.this.astor != null);
                this.getComponent(3).setEnabled(device.state == 3);
                this.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void deviceActionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            int n = 0;
            for (int i = 0; i < menuLabels.length; ++i) {
                if (this.getComponent(2 + i) != object) continue;
                n = i;
            }
            switch (n) {
                case 0: {
                    DeviceHierarchy.this.parent.update();
                    break;
                }
                case 3: {
                    if (!AstorUtil.osIsUnix()) break;
                    DeviceHierarchy.this.remoteShell();
                    break;
                }
                case 2: {
                    DeviceHierarchy.this.hostPanel();
                    break;
                }
                case 1: {
                    DeviceHierarchy.this.testDevice();
                }
            }
        }
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private Font[] fonts;
        private final int TITLE = 0;
        private final int COLLEC = 1;
        private final int LEAF = 2;

        public TangoRenderer() {
            Utils utils = Utils.getInstance();
            root_icon = utils.getIcon("network5.gif");
            this.fonts = new Font[3];
            this.fonts[0] = new Font("Dialog", 1, 18);
            this.fonts[1] = new Font("Dialog", 1, 12);
            this.fonts[2] = new Font("Dialog", 0, 12);
        }

        Cursor getNodeCursor(String string) {
            URL uRL = this.getClass().getResource("/app_util/img/" + string);
            Image image = Toolkit.getDefaultToolkit().getImage(uRL);
            return Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), string);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.setBackgroundNonSelectionColor(background);
            this.setForeground(Color.black);
            this.setBackgroundSelectionColor(Color.lightGray);
            if (n == 0) {
                this.setFont(this.fonts[0]);
                this.setIcon(root_icon);
            } else {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                if (defaultMutableTreeNode.getUserObject() instanceof Device) {
                    this.setFont(this.fonts[1]);
                    Device device = (Device)defaultMutableTreeNode.getUserObject();
                    this.setIcon(AstorUtil.state_icons[device.state]);
                    if (device.too_old) {
                        this.setBackgroundNonSelectionColor(Color.yellow);
                    }
                }
            }
            return this;
        }
    }
}

