/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorDefs;
import admin.astor.AstorTree;
import admin.astor.AstorUtil;
import admin.astor.DbaseObject;
import admin.astor.RemoteLoginThread;
import admin.astor.ServerCmdThread;
import admin.astor.TangoHost;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class TreePopupMenu
extends JPopupMenu
implements AstorDefs {
    private DefaultMutableTreeNode node_cut = null;
    private Astor astor;
    private AstorTree parent;
    private TangoHost host;
    private String collec_name;
    private TangoHost[] collec_hosts;
    private static String[] menuLabels = new String[]{"Open control Panel", "Disable control", "Enable  control", "Remote Login", "Starter info", "Starter test", "Unexport Starter device", "Branch  info", "Start all Servers", "Stop  all Servers", "Clone", "Cut", "Paste", "Edit Properties", "Remove", "Black Box", "Starter Logs", "Force Update", "Change Name"};
    private static final int OFFSET = 2;
    private static final int OPEN_PANEL = 0;
    private static final int DISABLE = 1;
    private static final int ENABLE = 2;
    private static final int REM_LOGIN = 3;
    private static final int STARTER_INFO = 4;
    private static final int STARTER_TEST = 5;
    private static final int UNEXPORT_STARTER = 6;
    private static final int COLLEC_INFO = 7;
    private static final int START_SERVERS = 8;
    private static final int STOP_SERVERS = 9;
    private static final int CLONE_HOST = 10;
    private static final int CUT_HOST = 11;
    private static final int PASTE_HOST = 12;
    private static final int EDIT_PROP = 13;
    private static final int REMOVE_HOST = 14;
    private static final int BLACK_BOX = 15;
    private static final int STARTER_LOGS = 16;
    private static final int UPDATE = 17;
    private static final int CHANGE_NAME = 18;

    public TreePopupMenu(Astor astor, AstorTree astorTree) {
        this.astor = astor;
        this.parent = astorTree;
        this.buildBtnPopupMenu();
    }

    public TreePopupMenu(AstorTree astorTree) {
        this.astor = null;
        this.parent = astorTree;
        this.buildBtnPopupMenu();
    }

    private void buildBtnPopupMenu() {
        JLabel jLabel = new JLabel("Host Control :");
        jLabel.setFont(new Font("Dialog", 1, 16));
        this.add(jLabel);
        this.add(new JPopupMenu.Separator());
        for (String string : menuLabels) {
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TreePopupMenu.this.hostActionPerformed(actionEvent);
                }
            });
            this.add(jMenuItem);
        }
    }

    private boolean getSelectedObject() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.parent.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return false;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof DbaseObject) {
            return false;
        }
        if (object instanceof TangoHost) {
            this.host = (TangoHost)((Object)object);
            this.collec_name = null;
        } else {
            this.host = null;
            int n = defaultMutableTreeNode.getChildCount();
            this.collec_hosts = new TangoHost[n];
            for (int i = 0; i < n; ++i) {
                Object object2 = (defaultMutableTreeNode = defaultMutableTreeNode.getNextNode()).getUserObject();
                if (!(object2 instanceof TangoHost)) {
                    return false;
                }
                this.collec_hosts[i] = (TangoHost)((Object)object2);
            }
            this.collec_name = (String)object;
        }
        return true;
    }

    public void showMenu(MouseEvent mouseEvent) {
        TreePath treePath = this.parent.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        this.parent.setSelectionPath(treePath);
        if (!this.getSelectedObject()) {
            return;
        }
        for (int i = 3; i < this.getComponentCount(); ++i) {
            this.getComponent(i).setVisible(true);
        }
        if (this.host != null) {
            JLabel jLabel = (JLabel)this.getComponent(0);
            jLabel.setText("  " + this.host.getName() + "  :");
            boolean bl = this.host.do_polling && this.host.state != 1;
            this.getComponent(2).setEnabled(bl);
            if (this.host.use_events || !AstorUtil.getCtrlBtn()) {
                this.getComponent(3).setVisible(false);
                this.getComponent(4).setVisible(false);
            } else {
                this.getComponent(3).setEnabled(this.host.do_polling);
                this.getComponent(4).setEnabled(!this.host.do_polling);
            }
            this.getComponent(9).setVisible(false);
            this.getComponent(10).setVisible(false);
            this.getComponent(11).setVisible(false);
            this.getComponent(20).setVisible(false);
            this.getComponent(13).setEnabled(true);
            this.getComponent(14).setEnabled(false);
            this.getComponent(15).setEnabled(true);
            this.getComponent(12).setEnabled(true);
            boolean bl2 = this.host.state == 3 || this.host.state == 2 || this.host.state == 4;
            this.getComponent(7).setEnabled(bl2);
            this.getComponent(18).setEnabled(bl2);
            this.getComponent(16).setEnabled(!bl2);
            this.getComponent(19).setEnabled(bl2);
            this.getComponent(17).setVisible(this.host.state != 1);
            boolean bl3 = this.host.state == 0;
            this.getComponent(8).setVisible(bl3);
        } else if (this.collec_name != null) {
            JLabel jLabel = (JLabel)this.getComponent(0);
            jLabel.setText("  " + this.collec_name + "  :");
            this.getComponent(2).setEnabled(false);
            this.getComponent(3).setVisible(AstorUtil.getCtrlBtn());
            this.getComponent(4).setVisible(AstorUtil.getCtrlBtn());
            this.getComponent(3).setEnabled(true);
            this.getComponent(4).setEnabled(true);
            this.getComponent(5).setVisible(false);
            this.getComponent(6).setVisible(false);
            this.getComponent(7).setVisible(false);
            this.getComponent(18).setVisible(false);
            this.getComponent(19).setVisible(false);
            this.getComponent(12).setEnabled(false);
            this.getComponent(13).setEnabled(false);
            this.getComponent(15).setEnabled(false);
            this.getComponent(14).setEnabled(this.node_cut != null);
            this.getComponent(16).setEnabled(false);
            this.getComponent(17).setVisible(false);
            this.getComponent(8).setVisible(false);
        }
        if (!AstorUtil.osIsUnix()) {
            this.getComponent(5).setVisible(false);
        }
        this.show(this.parent, mouseEvent.getX(), mouseEvent.getY());
    }

    private void hostActionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = 0;
        for (int i = 0; i < menuLabels.length; ++i) {
            if (this.getComponent(2 + i) != object) continue;
            n = i;
        }
        switch (n) {
            case 0: {
                this.parent.displayHostInfo();
                break;
            }
            case 6: {
                this.host.unexportStarter(this.astor);
                break;
            }
            case 5: {
                this.host.testStarter(this.astor);
                break;
            }
            case 16: {
                this.host.displayLogging(this.astor);
                break;
            }
            case 4: {
                this.host.displayInfo(this.parent);
                break;
            }
            case 3: {
                new RemoteLoginThread(this.host.getName(), this.parent).start();
                break;
            }
            case 2: {
                this.enablePolling(true);
                break;
            }
            case 1: {
                this.enablePolling(false);
                break;
            }
            case 10: {
                this.astor.addNewHost(this.host);
                break;
            }
            case 13: {
                this.astor.editHostProperties(this.host);
                break;
            }
            case 11: {
                this.node_cut = (DefaultMutableTreeNode)this.parent.getLastSelectedPathComponent();
                break;
            }
            case 12: {
                this.parent.moveNode(this.node_cut);
                this.node_cut = null;
                break;
            }
            case 14: {
                this.astor.removeHost(this.host.getName());
                break;
            }
            case 15: {
                this.host.displayBlackBox(this.astor);
                break;
            }
            case 7: {
                this.parent.displayBranchInfo();
                break;
            }
            case 8: {
                new ServerCmdThread(this.astor, this.collec_hosts, 0).start();
                break;
            }
            case 9: {
                new ServerCmdThread(this.astor, this.collec_hosts, 1).start();
                break;
            }
            case 17: {
                this.host.updateServersList(this.astor);
                break;
            }
            case 18: {
                this.parent.changeNodeName();
            }
        }
    }

    private void enablePolling(boolean bl) {
        if (this.host != null) {
            this.host.do_polling = bl;
            if (!bl) {
                this.parent.hostDialogs.close(this.host);
            }
        } else {
            for (TangoHost tangoHost : this.collec_hosts) {
                tangoHost.do_polling = bl;
                if (bl) continue;
                this.parent.hostDialogs.close(tangoHost);
            }
        }
    }
}

