/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorUtil;
import admin.astor.HostInfoDialog;
import admin.astor.HostStateThread;
import admin.astor.TangoServer;
import admin.astor.tools.BlackBoxTable;
import app_util.PopupError;
import app_util.PopupMessage;
import app_util.PopupTable;
import app_util.PopupText;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevInfo;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevExportInfo;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbServInfo;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.IORdump;
import fr.esrf.TangoApi.events.DbEventImportInfo;
import fr.esrf.TangoApi.events.TangoEventsAdapter;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Frame;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class TangoHost
extends DeviceProxy {
    private TangoServer starter = null;
    private String name;
    private Vector<TangoServer> servers;
    public String usage = null;
    public int state;
    public DevFailed except;
    public boolean do_polling = false;
    public boolean poll_serv_lists = false;
    public boolean all_servers = false;
    public String collection = null;
    public HostStateThread thread = null;
    public int notifyd_state;
    public JLabel notifd_label;
    public boolean use_events;
    public boolean check_notifd;
    public HostInfoDialog info_dialog = null;
    public boolean manage_starting = true;
    public TangoEventsAdapter supplier = null;
    public int idl_version = 0;
    private String adm_name;

    public TangoHost(String string, boolean bl) throws DevFailed {
        super("tango/admin/" + string);
        this.adm_name = "dserver/starter/" + string;
        this.set_transparency_reconnection(true);
        this.servers = new Vector();
        this.notifyd_state = 0;
        int n = string.indexOf(".");
        this.name = n < 0 ? string : string.substring(0, n);
        if (bl) {
            DbDatum dbDatum;
            DbDatum dbDatum2 = this.get_property("HostCollection");
            if (!dbDatum2.is_empty()) {
                this.collection = dbDatum2.extractString();
            }
            if (!(dbDatum = this.get_property("HostUsage")).is_empty()) {
                this.usage = dbDatum.extractString();
                if (this.usage.length() == 0) {
                    this.usage = null;
                }
            }
            this.use_events = false;
            try {
                dbDatum2 = this.get_property("UseEvents");
                if (!dbDatum2.is_empty()) {
                    this.use_events = dbDatum2.extractShort() != 0;
                }
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
            this.check_notifd = this.use_events;
        }
    }

    public TangoHost(DbDevImportInfo dbDevImportInfo, DbDevImportInfo dbDevImportInfo2, DbEventImportInfo dbEventImportInfo) throws DevFailed {
        super(dbDevImportInfo);
        try {
            this.import_admin_device(dbDevImportInfo2);
            if (dbEventImportInfo != null) {
                this.getAdm_dev().set_evt_import_info(dbEventImportInfo);
            }
        }
        catch (DevFailed devFailed) {
            Except.print_exception((Exception)((Object)devFailed));
        }
        this.adm_name = dbDevImportInfo2.name;
        this.set_transparency_reconnection(true);
        this.servers = new Vector();
        this.notifyd_state = 0;
        int n = dbDevImportInfo.name.indexOf(".");
        this.name = n < 0 ? dbDevImportInfo.name : dbDevImportInfo.name.substring(0, n);
        int n2 = this.name.indexOf(47);
        if (n2 > 0) {
            n2 = this.name.indexOf(47, n2 + 1);
        }
        if (n2 > 0) {
            this.name = this.name.substring(n2 + 1);
        }
    }

    public void removeAllservers() {
        if (this.servers.size() > 0) {
            this.servers.removeAllElements();
        }
    }

    public void addServer(TangoServer tangoServer) {
        this.servers.addElement(tangoServer);
    }

    public TangoServer getServer(String string) {
        string = string.trim();
        for (int i = 0; i < this.nbServers(); ++i) {
            TangoServer tangoServer = this.getServer(i);
            if (!tangoServer.getName().equals(string)) continue;
            return tangoServer;
        }
        return null;
    }

    public TangoServer getServer(int n) {
        return this.servers.get(n);
    }

    public void removeServer(int n) {
        this.servers.removeElementAt(n);
    }

    public void removeServer(String string) {
        for (int i = 0; i < this.nbServers(); ++i) {
            TangoServer tangoServer = this.getServer(i);
            if (!tangoServer.getName().equals(string)) continue;
            this.removeServer(i);
            return;
        }
    }

    public int nbServers() {
        if (this.servers == null) {
            return 0;
        }
        return this.servers.size();
    }

    public String[] getServerAttribute() {
        try {
            DeviceAttribute deviceAttribute = this.read_attribute("Servers");
            return deviceAttribute.extractStringArray();
        }
        catch (DevFailed devFailed) {
            Except.print_exception((Exception)((Object)devFailed));
            return new String[0];
        }
    }

    public String readLogFile(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout("DevReadLog", deviceData);
        return deviceData2.extractString();
    }

    public void registerServer(String string) throws DevFailed {
        IORdump iORdump;
        String string2 = "dserver/" + string;
        boolean bl = false;
        try {
            DeviceProxy deviceProxy = new DeviceProxy(string2);
            deviceProxy.ping();
            bl = true;
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        if (bl) {
            iORdump = new IORdump(string2);
            Except.throw_exception((String)"StartServerFailed", (String)(string + " is already running on " + iORdump.get_host()), (String)"DevWizard.startServer()");
        }
        iORdump = new DbDevExportInfo(string2, "null", this.name, "null");
        ApiUtil.get_db_obj().export_device((DbDevExportInfo)iORdump);
        ApiUtil.get_db_obj().unexport_device(string2);
    }

    public void startOneServer(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        System.out.println("command_inout(DevStart, " + string + ") on " + this.get_name());
        this.command_inout("DevStart", deviceData);
    }

    public void startServer(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        this.command_inout("DevStart", deviceData);
    }

    public void stopServer(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        this.command_inout("DevStop", deviceData);
    }

    public void hardKillServer(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        this.command_inout("HardKillServer", deviceData);
    }

    public void startServers(int n) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert((short)n);
        this.command_inout("DevStartAll", deviceData);
    }

    public void stopServers(int n) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert((short)n);
        this.command_inout("DevStopAll", deviceData);
    }

    public void displayLogging(JFrame jFrame) {
        this.displayLogging(jFrame, null);
    }

    /*
     * WARNING - void declaration
     */
    public void displayLogging(Component component, String string) {
        try {
            DeviceData deviceData = new DeviceData();
            deviceData.insert("Starter");
            DeviceData deviceData2 = this.command_inout("DevReadLog", deviceData);
            String string2 = deviceData2.extractString();
            String[] stringArray = AstorUtil.string2array(string2, "\n");
            Vector<String[]> vector = new Vector<String[]>();
            String string3 = null;
            String[] object = stringArray;
            int n = object.length;
            for (int i = 0; i < n; ++i) {
                String string4 = object[i];
                String[] stringArray2 = AstorUtil.string2array(string4);
                String string5 = stringArray2[2];
                stringArray2[2] = stringArray2[3];
                stringArray2[3] = string5;
                if (string != null && !string5.equals(string)) continue;
                if (string3 != null && !stringArray2[0].equals(string3)) {
                    vector.add(new String[]{"-", "-", "-", "-"});
                }
                string3 = stringArray2[0];
                vector.add(stringArray2);
            }
            if (vector.size() > 0) {
                String[][] stringArray3 = new String[vector.size()][];
                for (n = 0; n < vector.size(); ++n) {
                    stringArray3[n] = (String[])vector.get(n);
                }
                String[] stringArray4 = new String[]{"Date", "Time", "Action", "Server"};
                PopupTable popupTable = component instanceof JFrame ? new PopupTable((JFrame)component, "Starter on " + this.name, stringArray4, stringArray3) : new PopupTable((JDialog)component, "Starter on " + this.name, stringArray4, stringArray3);
                popupTable.setColumnWidth(new int[]{70, 70, 70, 250});
                popupTable.setSortAvailable(false);
                popupTable.setVisible(true);
            } else {
                void var9_14;
                String string6 = "no record found";
                if (string != null) {
                    String string7 = string6 + "  for  " + string;
                }
                Except.throw_exception((String)"", (String)var9_14, (String)"");
            }
        }
        catch (DevFailed devFailed) {
            PopupError.show(component, devFailed.errors[0].desc);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void displayInfo(Component component) {
        String string = "";
        try {
            String[] stringArray;
            if (this.starter == null) {
                this.starter = new TangoServer(this.adm_name);
            }
            string = string + this.starter.getServerInfo(component, this.state == 3);
            string = string + "\n\n----------- Controlled servers -----------\n";
            Database database = ApiUtil.get_db_obj();
            DeviceData deviceData = new DeviceData();
            deviceData.insert(this.name);
            DeviceData deviceData2 = database.command_inout("DbGetHostServerList", deviceData);
            for (String string2 : stringArray = deviceData2.extractStringArray()) {
                DbServInfo dbServInfo = database.get_server_info(string2);
                if (!dbServInfo.controlled) continue;
                string = string + dbServInfo.name + "\n";
            }
            String string3 = "";
            try {
                String string2;
                DevInfo devInfo = this.info();
                String string4 = devInfo.doc_url;
                string2 = "CVS Tag = ";
                int n = string4.indexOf(string2);
                if (n > 0) {
                    void var7_11;
                    int n2 = string4.indexOf(10, n += string2.length());
                    if (n2 > n) {
                        String string5 = string4.substring(n, n2);
                    }
                    string = string + "\n----------- Tag Release -----------\n        " + (String)var7_11;
                }
            }
            catch (DevFailed devFailed) {}
        }
        catch (DevFailed devFailed) {
            string = string + devFailed.errors[0].desc;
            PopupError.show(component, string, devFailed);
            return;
        }
        string = string + "\n\n";
        PopupMessage.show(component, string);
    }

    public void testStarter(Component component) {
        try {
            if (this.starter == null) {
                this.starter = new TangoServer(this.adm_name);
            }
            this.starter.testDevice(component);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)component, (String)"", (DevFailed)devFailed);
        }
    }

    public void unexportStarter(Component component) {
        try {
            DbDevImportInfo dbDevImportInfo = this.import_device();
            if (!dbDevImportInfo.exported) {
                PopupMessage.show(component, this.get_name() + "  NOT  exported !");
                return;
            }
            this.unexport_device();
            String string = "dserver/Starter/" + this.name;
            new DeviceProxy(string).unexport_device();
            this.do_polling = false;
            PopupMessage.show(component, string + "   and    " + this.get_name() + "\n\n       have been unexported !");
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)component, (String)"", (DevFailed)devFailed);
        }
    }

    public void setCollection(String string) throws DevFailed {
        DbDatum[] dbDatumArray = new DbDatum[]{new DbDatum("HostCollection", string)};
        this.put_property(dbDatumArray);
        this.collection = string;
    }

    public void informStarterForInfo() throws DevFailed {
        this.command_inout("UpdateServersInfo");
    }

    public String getName() {
        return this.name;
    }

    void setPolling(String[] stringArray) {
        if (stringArray == null) {
            this.do_polling = true;
        } else if (stringArray.length > 0 && stringArray[0].equals("none")) {
            this.do_polling = false;
        } else if (stringArray.length > 0 && stringArray[0].equals("all")) {
            this.do_polling = true;
        } else {
            for (String string : stringArray) {
                if (!this.name.equals(string)) continue;
                this.do_polling = true;
            }
        }
    }

    public void startServer(Component component, String string) {
        try {
            this.startServer(string);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)component, (String)"", (DevFailed)devFailed);
        }
    }

    void readStdErrorFile(Frame frame, String string) {
        try {
            String string2 = this.readLogFile(string);
            PopupText popupText = new PopupText(frame, true);
            popupText.show(string2, 700, 500);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)frame, (String)"", (DevFailed)devFailed);
        }
        catch (Exception exception) {
            ErrorPane.showErrorMessage((Component)frame, (String)"", (Exception)exception);
            exception.printStackTrace();
        }
    }

    void updateServersList(JFrame jFrame) {
        try {
            this.command_inout("UpdateServersInfo");
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)jFrame, (String)"", (DevFailed)devFailed);
        }
    }

    void updateData() {
        this.thread.updateData();
    }

    void stopThread() {
        this.thread.stop_it = true;
        this.thread.updateData();
    }

    String[] getPath() {
        String[] stringArray = new String[]{""};
        try {
            DbDatum dbDatum = this.get_property("StartDsPath");
            if (!dbDatum.is_empty()) {
                stringArray = dbDatum.extractStringArray();
            }
        }
        catch (DevFailed devFailed) {
            Except.print_exception((Exception)((Object)devFailed));
        }
        return stringArray;
    }

    String getFamily() {
        String string = "";
        try {
            DbDatum dbDatum = this.get_property("HostCollection");
            if (!dbDatum.is_empty()) {
                string = dbDatum.extractString();
            }
        }
        catch (DevFailed devFailed) {
            Except.print_exception((Exception)((Object)devFailed));
        }
        return string;
    }

    public void displayBlackBox(JFrame jFrame) {
        Object[] objectArray = new String[]{this.get_name(), this.adm_name};
        String string = (String)JOptionPane.showInputDialog(jFrame, "Device selection :", "", 1, null, objectArray, objectArray[0]);
        if (string != null) {
            try {
                new BlackBoxTable(jFrame, string).setVisible(true);
            }
            catch (DevFailed devFailed) {
                PopupError.show((Component)jFrame, devFailed);
            }
        }
    }

    public String hostStatus() {
        String string = this.name + ":";
        try {
            if (this.state == 1) {
                string = string + "     is faulty\n";
            } else {
                DeviceAttribute deviceAttribute = this.read_attribute("Servers");
                if (deviceAttribute.hasFailed()) {
                    string = string + "     " + deviceAttribute.getErrStack()[0].desc + "\n";
                } else {
                    String[] stringArray;
                    string = string + "\n";
                    Vector<String> vector = new Vector<String>();
                    Vector<String> vector2 = new Vector<String>();
                    Vector<String> vector3 = new Vector<String>();
                    for (String string2 : stringArray = deviceAttribute.extractStringArray()) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string2);
                        String string3 = stringTokenizer.nextToken();
                        String string4 = stringTokenizer.nextToken();
                        String string5 = stringTokenizer.nextToken();
                        if (!string5.equals("1")) continue;
                        if (string4.equals("FAULT")) {
                            vector3.add(string3);
                            continue;
                        }
                        if (string4.equals("MOVING")) {
                            vector2.add(string3);
                            continue;
                        }
                        vector.add(string3);
                    }
                    if (vector3.size() > 0) {
                        string = string + "     " + vector3.size() + "  servers stopped\n";
                    }
                    if (vector2.size() > 0) {
                        string = string + "     " + vector2.size() + " servers moving\n";
                    }
                    if (vector.size() > 0) {
                        string = string + "     " + vector.size() + " servers running\n";
                    }
                }
            }
        }
        catch (DevFailed devFailed) {
            string = string + "     " + devFailed.errors[0].desc;
        }
        return string;
    }

    public String toString() {
        if (this.usage == null || this.usage.length() == 0) {
            return this.name;
        }
        return this.name + "  ( " + this.usage + " )";
    }
}

