/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorDefs;
import admin.astor.DbPollPanel;
import admin.astor.HostInfoDialog;
import admin.astor.LevelTree;
import admin.astor.ManagePollingDialog;
import admin.astor.TangoHost;
import admin.astor.TangoServer;
import admin.astor.tools.DeviceHierarchyDialog;
import admin.astor.tools.PollingProfiler;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class ServerPopupMenu
extends JPopupMenu
implements AstorDefs {
    private TangoHost host;
    private TangoServer server;
    private LevelTree tree;
    private JFrame frame;
    private HostInfoDialog parent;
    private int mode;
    static final int SERVERS = 0;
    static final int LEVELS = 1;
    static final int NOTIFD = 2;
    private static String[] serverMenuLabels = new String[]{"Start server", "Restart server", "Set startup level", "Polling Manager", "Polling Profiler", "Pool Threads Manager", "Configure (Wizard)", "DB Attribute Properties", "Server Info", "Class  Info", "Device Dependencies", "Test   Device", "Check  States", "Black Box", "Starter logs", "Standard Error"};
    private static String[] levelMenuLabels = new String[]{"Start servers", "Stop  servers", "Change level number", "Set startup level for each server", "Expand Tree"};
    private static String[] notifdMenuLabels = new String[]{"Start daemon"};
    private static final int OFFSET = 2;
    private static final int START_STOP = 0;
    private static final int RESTART = 1;
    private static final int STARTUP_LEVEL = 2;
    private static final int POLLING_MANAGER = 3;
    private static final int POLLING_PROFILER = 4;
    private static final int POOL_THREAD_MAN = 5;
    private static final int CONFIGURE = 6;
    private static final int DB_ATTRIBUTES = 7;
    private static final int SERVER_INFO = 8;
    private static final int CLASS_INFO = 9;
    private static final int DEPENDENCIES = 10;
    private static final int TEST_DEVICE = 11;
    private static final int CHECK_STATES = 12;
    private static final int BLACK_BOX = 13;
    private static final int STARTER_LOGS = 14;
    private static final int STD_ERROR = 15;
    private static final int START = 0;
    private static final int STOP = 1;
    private static final int CHANGE_LEVEL = 2;
    private static final int SERVER_LEVELS = 3;
    private static final int EXPAND = 4;
    private static final boolean TANGO_7 = true;
    private Point location;

    public ServerPopupMenu(JFrame jFrame, HostInfoDialog hostInfoDialog, TangoHost tangoHost, int n) {
        this.frame = jFrame;
        this.parent = hostInfoDialog;
        this.host = tangoHost;
        this.mode = n;
        this.buildBtnPopupMenu();
    }

    private void buildBtnPopupMenu() {
        String[] stringArray;
        JLabel jLabel = new JLabel("Server Control :");
        jLabel.setFont(new Font("Dialog", 1, 16));
        this.add(jLabel);
        this.add(new JPopupMenu.Separator());
        switch (this.mode) {
            case 0: {
                stringArray = serverMenuLabels;
                break;
            }
            case 1: {
                stringArray = levelMenuLabels;
                break;
            }
            default: {
                jLabel.setText("Event Notify Daemon");
                stringArray = notifdMenuLabels;
            }
        }
        for (String string : stringArray) {
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ServerPopupMenu.this.cmdActionPerformed(actionEvent);
                }
            });
            this.add(jMenuItem);
        }
    }

    public void showMenu(MouseEvent mouseEvent, JTree jTree, TangoServer tangoServer) {
        boolean bl;
        TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        jTree.setSelectionPath(treePath);
        String string = tangoServer.getName();
        JLabel jLabel = (JLabel)this.getComponent(0);
        jLabel.setText("  " + string + "  :");
        this.server = tangoServer;
        JMenuItem jMenuItem = (JMenuItem)this.getComponent(2);
        boolean bl2 = bl = tangoServer.getState() == DevState.ON;
        if (bl || tangoServer.getState() == DevState.MOVING) {
            jMenuItem.setText("Kill  Server");
        } else {
            jMenuItem.setText("Start Server");
        }
        this.getComponent(3).setEnabled(bl);
        this.getComponent(6).setEnabled(bl);
        this.getComponent(13).setEnabled(bl);
        this.getComponent(14).setEnabled(bl);
        this.getComponent(15).setEnabled(bl);
        this.getComponent(8).setEnabled(bl);
        this.getComponent(9).setVisible(!bl);
        this.getComponent(7).setVisible(true);
        this.getComponent(12).setVisible(true);
        this.location = jTree.getLocationOnScreen();
        this.location.x += mouseEvent.getX();
        this.location.y += mouseEvent.getY();
        this.show(jTree, mouseEvent.getX(), mouseEvent.getY());
    }

    public void showMenu(MouseEvent mouseEvent, LevelTree levelTree, boolean bl) {
        this.tree = levelTree;
        JLabel jLabel = (JLabel)this.getComponent(0);
        jLabel.setText("  " + levelTree + "  :");
        JMenuItem jMenuItem = (JMenuItem)this.getComponent(6);
        jMenuItem.setText(bl ? "Collapse Tree" : levelMenuLabels[4]);
        this.getComponent(5).setVisible(false);
        this.location = levelTree.getLocationOnScreen();
        this.location.x += mouseEvent.getX();
        this.location.y += mouseEvent.getY();
        this.show(levelTree, mouseEvent.getX(), mouseEvent.getY());
    }

    public void showMenu(MouseEvent mouseEvent, int n) {
        JLabel jLabel = (JLabel)mouseEvent.getSource();
        boolean bl = this.host.notifyd_state == 3;
        this.getComponent(2).setEnabled(!bl);
        this.location = jLabel.getLocationOnScreen();
        this.show(jLabel, mouseEvent.getX(), mouseEvent.getY());
    }

    private void cmdActionPerformed(ActionEvent actionEvent) {
        switch (this.mode) {
            case 0: {
                this.serverCmdActionPerformed(actionEvent);
                break;
            }
            case 1: {
                this.levelCmdActionPerformed(actionEvent);
                break;
            }
            case 2: {
                this.notifdCmdActionPerformed(actionEvent);
            }
        }
    }

    private void notifdCmdActionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = -1;
        for (int i = 0; i < notifdMenuLabels.length; ++i) {
            if (this.getComponent(2 + i) != object) continue;
            n = i;
        }
        switch (n) {
            case 0: {
                this.host.startServer(this.parent, "notify_daemon/" + this.host.getName());
            }
        }
    }

    private void levelCmdActionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = -1;
        for (int i = 0; i < levelMenuLabels.length; ++i) {
            if (this.getComponent(2 + i) != object) continue;
            n = i;
        }
        switch (n) {
            case 0: {
                this.parent.startLevel(this.tree.getLevelRow());
                break;
            }
            case 1: {
                this.parent.stopLevel(this.tree.getLevelRow());
                break;
            }
            case 2: {
                this.tree.changeChangeLevel(this.tree.getLevelRow());
                break;
            }
            case 3: {
                this.tree.changeServerLevels(this.tree.getLevelRow());
                break;
            }
            case 4: {
                this.tree.toggleExpandCollapse();
            }
        }
    }

    private void serverCmdActionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = -1;
        for (int i = 0; i < serverMenuLabels.length; ++i) {
            if (this.getComponent(2 + i) != object) continue;
            n = i;
        }
        switch (n) {
            case 2: {
                if (!this.server.startupLevel(this.parent, this.host.getName(), this.location)) break;
                this.parent.updateData();
                break;
            }
            case 3: {
                if (this.server.getState() == DevState.ON) {
                    new ManagePollingDialog(this.parent, this.server).setVisible(true);
                    break;
                }
                try {
                    new DbPollPanel(this.parent, this.server.getName()).setVisible(true);
                }
                catch (DevFailed devFailed) {
                    ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
                }
                break;
            }
            case 5: {
                this.server.poolThreadManager(this.parent, this.host);
                break;
            }
            case 4: {
                this.startPollingProfiler();
                break;
            }
            case 11: {
                this.server.testDevice(this.parent);
                break;
            }
            case 12: {
                this.server.checkStates(this.parent);
                break;
            }
            case 13: {
                this.server.displayBlackBox(this.parent);
                break;
            }
            case 14: {
                this.host.displayLogging(this.parent, this.server.toString());
                break;
            }
            case 6: {
                this.server.configureWithWizard(this.parent);
                break;
            }
            case 8: {
                this.server.displayServerInfo(this.parent);
                break;
            }
            case 7: {
                this.server.manageMemorizedAttributes(this.parent);
                break;
            }
            case 9: {
                this.server.displayClassInfo(this.frame);
                break;
            }
            case 10: {
                try {
                    new DeviceHierarchyDialog(this.parent, this.server.getName()).setVisible(true);
                }
                catch (DevFailed devFailed) {
                    ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
                }
                break;
            }
            case 15: {
                if (this.server != null) {
                    this.host.readStdErrorFile(this.frame, this.server.getName());
                    break;
                }
                this.host.readStdErrorFile(this.frame, "notify_daemon/" + this.host.getName());
                break;
            }
            case 1: {
                this.server.restart(this.parent, this.host, true);
                break;
            }
            case 0: {
                if (this.server.getState() == DevState.ON || this.server.getState() == DevState.MOVING) {
                    try {
                        if (JOptionPane.showConfirmDialog(this.parent, "Are you sure to want to kill " + this.server.getName(), "Confirm Dialog", 0) != 0) {
                            return;
                        }
                        this.host.stopServer(this.server.getName());
                    }
                    catch (DevFailed devFailed) {
                        if (devFailed.errors[0].reason.equals("SERVER_NOT_RESPONDING")) {
                            try {
                                if (JOptionPane.showConfirmDialog(this.parent, devFailed.errors[0].desc + "\n" + "Do you even want to kill it ?", "Confirm Dialog", 0) != 0) {
                                    return;
                                }
                                this.host.hardKillServer(this.server.getName());
                            }
                            catch (DevFailed devFailed2) {
                                ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed2);
                            }
                            break;
                        }
                        ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
                    }
                    break;
                }
                this.host.startServer(this.parent, this.server.getName());
            }
        }
    }

    private void startPollingProfiler() {
        try {
            String[] stringArray = this.server.queryDevice();
            new PollingProfiler((JDialog)this.parent, stringArray).setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
        }
    }
}

