/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorCmdLine;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class DbPollPanel
extends JDialog {
    private Component parent;
    private DeviceProxy selected_dev;
    private DeviceProxy[] devices;
    private Vector buttons = new Vector();
    private PolledAttr[] attlist;
    private static final String PollAttProp = "polled_attr";
    private JPanel panel = null;
    private JButton cancelBtn;
    private JComboBox devComboBox;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JButton okBtn;
    private JLabel titleLabel;

    public DbPollPanel(JFrame jFrame, String string) throws DevFailed {
        super((Frame)jFrame, true);
        this.parent = jFrame;
        this.initialize(string);
    }

    public DbPollPanel(JDialog jDialog, String string) throws DevFailed {
        super((Dialog)jDialog, true);
        this.parent = jDialog;
        this.initialize(string);
    }

    private void initialize(String string) throws DevFailed {
        this.parent = this.parent;
        this.initComponents();
        this.titleLabel.setText("Polled Attributes For ");
        this.devices = this.getDeviceList(string);
        if (this.devices.length == 0) {
            Except.throw_exception((String)"NO_DEVICES", (String)("No device found for " + string), (String)("DbPollPanel.initialize(" + string + ")"));
        }
        this.buildPanel(this.devices.length - 1);
        this.okBtn.setText("Apply");
        this.cancelBtn.setText("Dismiss");
    }

    private DeviceProxy[] getDeviceList(String string) {
        try {
            String[] stringArray;
            Vector<String> vector = new Vector<String>();
            DbServer dbServer = new DbServer(string);
            for (String string2 : stringArray = dbServer.get_class_list()) {
                String[] stringArray2;
                for (String string3 : stringArray2 = dbServer.get_device_name(string2)) {
                    vector.add(string3);
                }
            }
            String[] stringArray3 = new DeviceProxy[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                this.devComboBox.addItem(vector.get(i));
                stringArray3[i] = new DeviceProxy((String)vector.get(i));
            }
            this.devComboBox.setSelectedIndex(vector.size() - 1);
            return stringArray3;
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
            return new DeviceProxy[0];
        }
    }

    private void buildPanel(int n) {
        this.selected_dev = this.devices[n];
        if (this.panel != null) {
            this.getContentPane().remove(this.panel);
        }
        try {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            int n2 = 0;
            for (PolledAttr polledAttr : this.attlist = this.getPolledAttributes(this.selected_dev)) {
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = n2;
                gridBagConstraints.fill = 2;
                jPanel.add((Component)polledAttr.btn, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = n2;
                gridBagConstraints.fill = 2;
                jPanel.add((Component)polledAttr.txt, gridBagConstraints);
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = n2++;
                gridBagConstraints.fill = 2;
                jPanel.add((Component)new JLabel("ms"), gridBagConstraints);
            }
            this.getContentPane().add((Component)jPanel, "Center");
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
        }
        this.pack();
    }

    public PolledAttr[] getPolledAttributes(DeviceProxy deviceProxy) throws DevFailed {
        DbDatum dbDatum = deviceProxy.get_property(PollAttProp);
        String[] stringArray = dbDatum.extractStringArray();
        if (stringArray == null) {
            return new PolledAttr[0];
        }
        Vector<PolledAttr> vector = new Vector<PolledAttr>();
        for (int i = 0; i < stringArray.length; i += 2) {
            vector.add(new PolledAttr(stringArray[i], stringArray[i + 1]));
        }
        PolledAttr[] polledAttrArray = new PolledAttr[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            polledAttrArray[i] = (PolledAttr)vector.get(i);
        }
        return polledAttrArray;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okBtn = new JButton();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.devComboBox = new JComboBox();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                DbPollPanel.this.closeDialog(windowEvent);
            }
        });
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DbPollPanel.this.okBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.okBtn);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DbPollPanel.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.jPanel2.add(this.titleLabel);
        this.devComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DbPollPanel.this.devComboBoxActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add(this.devComboBox);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.pack();
    }

    private void devComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this.isVisible()) {
            this.buildPanel(this.devComboBox.getSelectedIndex());
        }
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        String string = "Remove polling for :\n";
        Vector<String> vector = new Vector<String>();
        for (PolledAttr polledAttr : this.attlist) {
            if (polledAttr.btn.getSelectedObjects() == null) {
                string = string + polledAttr.name + "\n";
                continue;
            }
            vector.add(polledAttr.name);
            try {
                polledAttr.period = Integer.parseInt(polledAttr.txt.getText());
                vector.add(polledAttr.txt.getText());
            }
            catch (NumberFormatException numberFormatException) {
                ErrorPane.showErrorMessage((Component)this, (String)("NumberFormatException on  attribute " + polledAttr.name), (Exception)numberFormatException);
                return;
            }
        }
        System.out.println(vector.size());
        if (vector.size() < this.attlist.length * 2 && JOptionPane.showConfirmDialog(this, string, "Question", 0) != 0) {
            return;
        }
        Object[] objectArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            objectArray[i] = (String)vector.get(i);
        }
        try {
            DbDatum dbDatum = new DbDatum(PollAttProp);
            dbDatum.insert((String[])objectArray);
            this.selected_dev.put_property(dbDatum);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
        }
        JOptionPane.showMessageDialog(this, "Database Updated", "", 1);
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void doClose() {
        if (this.parent.getWidth() == 0) {
            System.exit(0);
        }
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] stringArray) {
        String string = null;
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        try {
            if (string == null) {
                Except.throw_exception((String)"NO_SERVER_NAME", (String)"Serrver's name ????", (String)"PollPanel.main()");
            }
            new DbPollPanel(new JFrame(), string).setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)devFailed);
            System.exit(0);
        }
        catch (InternalError internalError) {
            String string2 = "Can't connect to X11 window server";
            if (internalError.toString().indexOf(string2) > 0) {
                System.out.println(string2);
                int n = 0;
                if (stringArray.length > 1 && stringArray[1].equals("-f")) {
                    n = 1;
                }
                new AstorCmdLine(n, string);
                System.exit(0);
            }
            System.exit(0);
        }
    }

    class PolledAttr {
        String name;
        int period;
        JRadioButton btn;
        JTextField txt;

        public PolledAttr(String string, String string2) {
            this.name = string;
            try {
                this.period = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.period = -1;
            }
            this.btn = new JRadioButton(string);
            this.btn.setSelected(true);
            this.txt = new JTextField("" + this.period);
            this.txt.setColumns(6);
        }
    }
}

