/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorUtil;
import admin.astor.Monitor;
import admin.astor.ServersTree;
import admin.astor.TangoHost;
import app_util.PopupError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbServInfo;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoDs.Except;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class CtrlServersDialog
extends JDialog {
    private static final String separator = "___________________________________________________";
    private Astor parent;
    private TangoHost[] hosts;
    private JTextArea dbInfoArea;
    private JTextArea servInfoArea;
    private JPanel buttonPanel;
    private JPanel middlePanel;
    private JButton cancelButton;
    private JScrollPane jScrollPane1;

    public CtrlServersDialog(Astor astor, TangoHost[] tangoHostArray) {
        super((Frame)astor, false);
        this.parent = astor;
        this.hosts = tangoHostArray;
        this.initComponents();
        this.pack();
        new DisplayThread().start();
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.middlePanel = new JPanel();
        this.cancelButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                CtrlServersDialog.this.closeDialog(windowEvent);
            }
        });
        this.buttonPanel.setLayout(new FlowLayout(2, 5, 5));
        this.cancelButton.setText("Dismiss");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtrlServersDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.middlePanel.setLayout(new BorderLayout());
        this.servInfoArea = new JTextArea("Servers Info");
        this.servInfoArea.setBackground(Color.lightGray);
        this.servInfoArea.setEditable(false);
        this.servInfoArea.setFont(new Font("Dialog", 1, 14));
        this.getContentPane().add((Component)this.servInfoArea, "North");
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.dbInfoArea = new JTextArea("DB info.");
        this.dbInfoArea.setBackground(Color.lightGray);
        this.dbInfoArea.setEditable(false);
        this.dbInfoArea.setFont(new Font("Dialog", 1, 10));
        this.middlePanel.add((Component)this.dbInfoArea, "North");
        this.cancelButton.setBackground(Color.lightGray);
        this.buttonPanel.add(this.cancelButton);
        this.buttonPanel.setBackground(Color.lightGray);
        this.middlePanel.add((Component)this.buttonPanel, "South");
        this.getContentPane().add((Component)this.middlePanel, "South");
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public void show(String string, Vector vector, Vector vector2) {
        ServersTree serversTree = new ServersTree(this.parent, "Controlled Servers", vector, vector2);
        this.jScrollPane1.setViewportView(serversTree);
        this.servInfoArea.setText(string);
        this.pack();
        AstorUtil.rightShiftDialog((JDialog)this, this.parent);
        this.setVisible(true);
    }

    class DisplayThread
    extends Thread {
        private Monitor monitor = null;

        private void updateProgressMonitor(String string, int n) {
            if (this.monitor == null) {
                this.monitor = new Monitor(CtrlServersDialog.this.parent, "Browsing TANGO database", "Reading host");
            }
            double d = (double)(n + 1) / (double)CtrlServersDialog.this.hosts.length;
            this.monitor.setProgressValue(d, "Query servers for " + string);
        }

        public DbServInfo[] getControledServers(String string) throws DevFailed {
            Database database = ApiUtil.get_db_obj();
            DeviceData deviceData = new DeviceData();
            deviceData.insert(string);
            DeviceData deviceData2 = database.command_inout("DbGetHostServerList", deviceData);
            String[] stringArray = deviceData2.extractStringArray();
            Vector<DbServInfo> vector = new Vector<DbServInfo>();
            for (int i = 0; i < stringArray.length; ++i) {
                DbServInfo dbServInfo = database.get_server_info(stringArray[i]);
                if (!dbServInfo.controlled) continue;
                vector.add(dbServInfo);
            }
            DbServInfo[] dbServInfoArray = new DbServInfo[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                dbServInfoArray[i] = (DbServInfo)vector.elementAt(i);
            }
            return dbServInfoArray;
        }

        private synchronized void wait_next_loop(long l) {
            try {
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            int n = 0;
            int n2 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            Vector<String[]> vector = new Vector<String[]>();
            Vector<DbServInfo[]> vector2 = new Vector<DbServInfo[]>();
            try {
                int[] nArray = new int[]{4, 5, 6, 7, 9, 10};
                DeviceData deviceData = ApiUtil.get_db_obj().command_inout("DbInfo");
                String[] stringArray = deviceData.extractStringArray();
                String string = "Database Information:\n\n";
                for (int i = 0; i < nArray.length; ++i) {
                    string = string + stringArray[nArray[i]];
                    if (i >= nArray.length - 1) continue;
                    string = string + "\n";
                }
                CtrlServersDialog.this.dbInfoArea.setText(string);
            }
            catch (DevFailed devFailed) {
                PopupError.show((Component)CtrlServersDialog.this.parent, devFailed);
            }
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            for (int i = 0; i < CtrlServersDialog.this.hosts.length; ++i) {
                int n6;
                Object object;
                int n7;
                this.updateProgressMonitor(CtrlServersDialog.this.hosts[i].getName(), i);
                if (((CtrlServersDialog)CtrlServersDialog.this).hosts[i].use_events) {
                    ++n3;
                }
                DbServInfo[] dbServInfoArray = new DbServInfo[]{};
                try {
                    dbServInfoArray = this.getControledServers(CtrlServersDialog.this.hosts[i].getName());
                    for (n7 = 0; n7 < dbServInfoArray.length; ++n7) {
                        DbServer dbServer = new DbServer(dbServInfoArray[n7].name);
                        object = dbServer.get_class_list();
                        n4 += ((String[])object).length;
                        for (n6 = 0; n6 < ((String[])object).length; ++n6) {
                            String[] stringArray = dbServer.get_device_name(object[n6]);
                            n5 += stringArray.length;
                        }
                    }
                }
                catch (DevFailed devFailed) {
                    Except.print_exception((Exception)((Object)devFailed));
                }
                stringBuffer.append(CtrlServersDialog.this.hosts[i].getName() + " (" + dbServInfoArray.length + " server");
                if (dbServInfoArray.length > 1) {
                    stringBuffer.append("s");
                }
                stringBuffer.append("):\n");
                vector2.add(dbServInfoArray);
                for (n7 = 0; n7 < dbServInfoArray.length; ++n7) {
                    ++n2;
                    stringBuffer.append("\t" + dbServInfoArray[n7].name + "\tStartup level: " + dbServInfoArray[n7].startup_level + "\n");
                    int n8 = dbServInfoArray[n7].name.indexOf("/");
                    if (n8 < 0) break;
                    object = dbServInfoArray[n7].name.substring(0, n8);
                    n6 = 0;
                    for (int j = 0; j < vector.size() && n6 == 0; ++j) {
                        String string = (String)vector.elementAt(j);
                        n6 = string.equals(object) ? 1 : 0;
                    }
                    if (n6 != 0) continue;
                    ++n;
                    vector.add((String[])object);
                }
                stringBuffer.append("___________________________________________________\n\n");
                this.wait_next_loop(50L);
            }
            this.monitor.setProgressValue(100.0);
            Collections.sort(vector, AstorUtil.getInstance().compare);
            String string = new String(CtrlServersDialog.this.hosts.length + " hosts in control system");
            if (n3 > 0) {
                string = string + " (" + n3 + " controlled on events)";
            }
            string = string + "\n" + n + " different servers \n" + n2 + " controlled instances\n" + n4 + " classes  -  " + n5 + " devices.";
            CtrlServersDialog.this.show(string, vector, vector2);
        }
    }
}

