/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorCmdLine;
import admin.astor.AstorDefs;
import admin.astor.AstorTree;
import admin.astor.AstorUtil;
import admin.astor.CtrlServersDialog;
import admin.astor.DeviceTreeDialog;
import admin.astor.Monitor;
import admin.astor.NewStarterDialog;
import admin.astor.OneTool;
import admin.astor.PreferenceDialog;
import admin.astor.Selector;
import admin.astor.ServerCmdThread;
import admin.astor.TangoHost;
import admin.astor.access.TangoAccess;
import admin.astor.tools.DevBrowser;
import admin.astor.tools.WideSearchDialog;
import app_util.PopupError;
import app_util.PopupHtml;
import app_util.PopupMessage;
import app_util.PopupTable;
import app_util.PopupText;
import app_util.TangoWindow;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.TangORBversion;
import fr.esrf.TangoDs.Except;
import fr.esrf.logviewer.Main;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.JSmoothProgressBar;
import fr.esrf.tangoatk.widget.util.Splash;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;

public class Astor
extends JFrame
implements AstorDefs {
    private static String revNumber = "Release 5.2.10  -  Fri Oct 08 09:46:00 CEST 2010";
    public AstorTree tree = null;
    private boolean expanded = false;
    private JScrollPane scrowllPane;
    static CtrlServersDialog ctrl_serv_d = null;
    static boolean displayed = false;
    public static DevBrowser dev_browser = null;
    private String tango_host = "";
    static long t0;
    private String[] htmlHelps = null;
    private int nb_def_tools = 1;
    private Vector app_tools = new Vector();
    private Vector tools_al = new Vector();
    private Selector tango_host_selector = null;
    private Main logviewer = null;
    private static String searched_host;
    private WideSearchDialog wide_search_dlg = null;
    private JMenuItem aboutBtn;
    private JMenuItem accessControlBtn;
    private JToggleButton allHostsControledBtn;
    private JPanel bottomPanel;
    private JMenuItem changeTgHostBtn;
    private JMenu cmdMenu;
    private JMenuItem ctrlPreferenceBtn;
    private JMenuItem deviceBrowserBtn;
    private JMenuItem distributionBtn;
    private JMenuItem exitBtn;
    private JMenuItem expandBtn;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenuItem jiveMenuItem;
    private JMenuItem logviewerMenuItem;
    private JMenuItem newBranchBtn;
    private JMenuItem newHostBtn;
    private JMenuItem principleBtn;
    private JMenuItem refreshBtn;
    private JMenuItem releaseNoteBtn;
    private JMenuItem starterEventsItem;
    private JMenuItem starterNoEventsItem;
    private JMenuItem stateIconsBtn;
    private JToggleButton stopHostsControledBtn;
    private JMenuItem tangorbBtn;
    private JMenu toolsMenu;
    private JMenu viewMenu;

    public Astor() throws DevFailed {
        t0 = System.currentTimeMillis();
        this.initComponents();
        AstorUtil.getInstance().initIcons();
        this.customizeMenu();
        this.setTitle("TANGO Manager - " + revNumber);
        this.buildTree();
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/app_util/img/tango_icon.jpg"));
        this.setIconImage(imageIcon.getImage());
        this.bottomPanel.setVisible(AstorUtil.getCtrlBtn());
        this.centerWindow();
        try {
            this.tango_host = ApiUtil.get_db_obj().get_tango_host();
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
    }

    public void centerWindow() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        Dimension dimension2 = this.getSize();
        Point point = new Point();
        point.x = (dimension.width - dimension2.width) / 2;
        point.y = (dimension.height - dimension2.height) / 2;
        this.setLocation(point);
    }

    private void buildTree() throws DevFailed {
        String string = "Astor (TANGO Manager)";
        int n = revNumber.indexOf("-");
        if (n > 0) {
            string = string + " - " + revNumber.substring(0, n).trim();
        }
        JSmoothProgressBar jSmoothProgressBar = new JSmoothProgressBar();
        jSmoothProgressBar.setStringPainted(true);
        jSmoothProgressBar.setBackground(Color.lightGray);
        jSmoothProgressBar.setProgressBarColors(Color.gray, Color.gray, Color.gray);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/app_util/img/TangoCollaboration.jpg"));
        Splash splash = new Splash(imageIcon, Color.black, jSmoothProgressBar);
        splash.setTitle(string);
        splash.setMessage("Starting....");
        splash.setVisible(true);
        try {
            if (this.tree != null) {
                this.tree.stopThreads();
                this.scrowllPane.remove(this.tree);
                this.remove(this.scrowllPane);
            }
            this.tree = new AstorTree(this, true, splash);
            this.scrowllPane = new JScrollPane();
            this.scrowllPane.setPreferredSize(AstorUtil.getPreferredSize());
            this.scrowllPane.setViewportView(this.tree);
            this.getContentPane().add((Component)this.scrowllPane, "Center");
            this.expanded = false;
            this.pack();
        }
        catch (DevFailed devFailed) {
            splash.setVisible(false);
            throw devFailed;
        }
    }

    Dimension getTreeSize() {
        return this.scrowllPane.getPreferredSize();
    }

    void setTreeSize(Dimension dimension) {
        this.scrowllPane.setPreferredSize(dimension);
        this.pack();
    }

    private void customizeMenu() {
        this.fileMenu.setMnemonic('F');
        this.exitBtn.setMnemonic('E');
        this.exitBtn.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.ctrlPreferenceBtn.setMnemonic('P');
        this.ctrlPreferenceBtn.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        String string = System.getProperty("NO_PREF");
        if (string != null && string.toLowerCase().equals("true")) {
            this.ctrlPreferenceBtn.setEnabled(false);
        }
        this.changeTgHostBtn.setMnemonic('T');
        this.changeTgHostBtn.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.viewMenu.setMnemonic('V');
        this.newBranchBtn.setMnemonic('N');
        this.newBranchBtn.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.refreshBtn.setMnemonic('U');
        this.refreshBtn.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        this.deviceBrowserBtn.setMnemonic('B');
        this.deviceBrowserBtn.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.expandBtn.setMnemonic('E');
        this.expandBtn.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.toolsMenu.setMnemonic('T');
        this.jiveMenuItem.setAccelerator(KeyStroke.getKeyStroke(74, 2));
        this.logviewerMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.cmdMenu.setMnemonic('C');
        this.newHostBtn.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        try {
            String[] stringArray = ApiUtil.get_db_obj().getServices("AccessControl", "*");
            if (stringArray.length > 0) {
                this.accessControlBtn.setMnemonic('A');
                this.accessControlBtn.setAccelerator(KeyStroke.getKeyStroke(65, 2));
                this.accessControlBtn.setVisible(true);
                System.out.println("AccessControl is active");
            } else {
                this.accessControlBtn.setVisible(false);
            }
        }
        catch (DevFailed devFailed) {
            this.accessControlBtn.setVisible(false);
        }
        this.nb_def_tools = this.toolsMenu.getItemCount();
        this.buildToolsItems();
        this.buildAdditionnalHelps();
        this.expandBtn.setVisible(false);
    }

    private void buildAdditionnalHelps() {
        this.htmlHelps = AstorUtil.getHtmlHelps();
        if (this.htmlHelps == null) {
            return;
        }
        if (this.htmlHelps.length == 0) {
            return;
        }
        this.helpMenu.add(new JSeparator());
        for (int i = 0; i < this.htmlHelps.length / 2; ++i) {
            JMenuItem jMenuItem = new JMenuItem();
            jMenuItem.setText(this.htmlHelps[2 * i]);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Astor.this.htmlHelpsItemActionPerformed(actionEvent);
                }
            });
            this.helpMenu.add(jMenuItem);
        }
    }

    private void htmlHelpsItemActionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        String string2 = null;
        for (int i = 0; i < this.htmlHelps.length; ++i) {
            if (!string.equals(this.htmlHelps[i]) || i >= this.htmlHelps.length - 1) continue;
            string2 = this.htmlHelps[i + 1];
        }
        if (string2 == null) {
            PopupError.show((Component)this, "No command found for item  '" + string + "'");
        }
        System.out.println(string2);
        AstorUtil.showInHtmBrowser(string2);
    }

    private void buildToolsItems() {
        for (int i = this.toolsMenu.getItemCount(); i > this.nb_def_tools; --i) {
            JMenuItem jMenuItem = this.toolsMenu.getItem(i - 1);
            jMenuItem.removeActionListener((ActionListener)this.tools_al.get(i - this.nb_def_tools - 1));
            this.toolsMenu.remove(i - 1);
        }
        this.app_tools.clear();
        this.tools_al.clear();
        String[] stringArray = AstorUtil.getTools();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; i += 2) {
                OneTool oneTool = new OneTool(stringArray[i], stringArray[i + 1]);
                this.app_tools.add(oneTool);
                JMenuItem jMenuItem = new JMenuItem();
                jMenuItem.setText(oneTool.name);
                ActionListener actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Astor.this.toolsItemActionPerformed(actionEvent);
                    }
                };
                jMenuItem.addActionListener(actionListener);
                this.tools_al.add(actionListener);
                this.toolsMenu.add(jMenuItem);
            }
        }
    }

    private void initComponents() {
        this.bottomPanel = new JPanel();
        JLabel jLabel = new JLabel();
        this.allHostsControledBtn = new JToggleButton();
        this.stopHostsControledBtn = new JToggleButton();
        JMenuBar jMenuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.changeTgHostBtn = new JMenuItem();
        this.ctrlPreferenceBtn = new JMenuItem();
        this.exitBtn = new JMenuItem();
        this.viewMenu = new JMenu();
        this.deviceBrowserBtn = new JMenuItem();
        this.refreshBtn = new JMenuItem();
        this.expandBtn = new JMenuItem();
        JMenuItem jMenuItem = new JMenuItem();
        this.cmdMenu = new JMenu();
        JMenuItem jMenuItem2 = new JMenuItem();
        JMenuItem jMenuItem3 = new JMenuItem();
        this.newHostBtn = new JMenuItem();
        this.newBranchBtn = new JMenuItem();
        this.toolsMenu = new JMenu();
        JMenu jMenu = new JMenu();
        JMenuItem jMenuItem4 = new JMenuItem();
        JMenuItem jMenuItem5 = new JMenuItem();
        JMenuItem jMenuItem6 = new JMenuItem();
        this.jiveMenuItem = new JMenuItem();
        this.accessControlBtn = new JMenuItem();
        this.logviewerMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.principleBtn = new JMenuItem();
        this.distributionBtn = new JMenuItem();
        this.stateIconsBtn = new JMenuItem();
        this.tangorbBtn = new JMenuItem();
        this.starterEventsItem = new JMenuItem();
        this.starterNoEventsItem = new JMenuItem();
        this.releaseNoteBtn = new JMenuItem();
        this.aboutBtn = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Astor.this.exitForm(windowEvent);
            }
        });
        jLabel.setText("Control  :   ");
        this.bottomPanel.add(jLabel);
        this.allHostsControledBtn.setFont(new Font("Dialog", 1, 10));
        this.allHostsControledBtn.setText("  All  hosts  ");
        this.allHostsControledBtn.setToolTipText("Start Control on All Hosts");
        this.allHostsControledBtn.setBorder(BorderFactory.createBevelBorder(0));
        this.allHostsControledBtn.setMargin(new Insets(2, 2, 2, 2));
        this.allHostsControledBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.allHostsControledBtnActionPerformed(actionEvent);
            }
        });
        this.bottomPanel.add(this.allHostsControledBtn);
        this.stopHostsControledBtn.setFont(new Font("Dialog", 1, 10));
        this.stopHostsControledBtn.setText("    None   ");
        this.stopHostsControledBtn.setToolTipText("Stop Control on All Hosts");
        this.stopHostsControledBtn.setBorder(BorderFactory.createBevelBorder(0));
        this.stopHostsControledBtn.setMargin(new Insets(2, 2, 2, 2));
        this.stopHostsControledBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.stopHostsControledBtnActionPerformed(actionEvent);
            }
        });
        this.bottomPanel.add(this.stopHostsControledBtn);
        this.getContentPane().add((Component)this.bottomPanel, "South");
        this.fileMenu.setText("File");
        this.changeTgHostBtn.setText("Change Tango Host");
        this.changeTgHostBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.changeTgHostBtnActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.changeTgHostBtn);
        this.ctrlPreferenceBtn.setText("Ctrl System Preferences");
        this.ctrlPreferenceBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.ctrlPreferenceBtnActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.ctrlPreferenceBtn);
        this.exitBtn.setText("Exit");
        this.exitBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.exitBtnActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.exitBtn);
        jMenuBar.add(this.fileMenu);
        this.viewMenu.setText("View");
        this.deviceBrowserBtn.setText("Event Manager");
        this.deviceBrowserBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.deviceBrowserBtnActionPerformed(actionEvent);
            }
        });
        this.viewMenu.add(this.deviceBrowserBtn);
        this.refreshBtn.setText("Update Tree from database");
        this.refreshBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.refreshBtnActionPerformed(actionEvent);
            }
        });
        this.viewMenu.add(this.refreshBtn);
        this.expandBtn.setText("Expand Tree");
        this.expandBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.expandBtnActionPerformed(actionEvent);
            }
        });
        this.viewMenu.add(this.expandBtn);
        jMenuItem.setText("Startup Errors");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.startupErrorBtnActionPerformed(actionEvent);
            }
        });
        this.viewMenu.add(jMenuItem);
        jMenuBar.add(this.viewMenu);
        this.cmdMenu.setText("Command");
        jMenuItem2.setText("Start All Controlled Servers");
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.startServersBtnActionPerformed(actionEvent);
            }
        });
        this.cmdMenu.add(jMenuItem2);
        jMenuItem3.setText("Stop All Controlled Servers");
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.stopServersBtnActionPerformed(actionEvent);
            }
        });
        this.cmdMenu.add(jMenuItem3);
        this.newHostBtn.setText("Add a New Host");
        this.newHostBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.newHostBtnActionPerformed(actionEvent);
            }
        });
        this.cmdMenu.add(this.newHostBtn);
        this.newBranchBtn.setText("Add a New Branch");
        this.newBranchBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.newBranchBtnActionPerformed(actionEvent);
            }
        });
        this.cmdMenu.add(this.newBranchBtn);
        jMenuBar.add(this.cmdMenu);
        this.toolsMenu.setText("Tools");
        jMenu.setText("Find");
        jMenuItem4.setText("Host by Name");
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.findHostItemActionPerformed(actionEvent);
            }
        });
        jMenu.add(jMenuItem4);
        jMenuItem5.setText("Device/Server/Class by Filter");
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.findObjectByFilterItemActionPerformed(actionEvent);
            }
        });
        jMenu.add(jMenuItem5);
        this.toolsMenu.add(jMenu);
        jMenuItem6.setText("Ctrl System Info");
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.tangoStatBtnActionPerformed(actionEvent);
            }
        });
        this.toolsMenu.add(jMenuItem6);
        this.jiveMenuItem.setText("Jive");
        this.jiveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.jiveMenuItemActionPerformed(actionEvent);
            }
        });
        this.toolsMenu.add(this.jiveMenuItem);
        this.accessControlBtn.setText("Access Control");
        this.accessControlBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.accessControlBtnActionPerformed(actionEvent);
            }
        });
        this.toolsMenu.add(this.accessControlBtn);
        this.logviewerMenuItem.setText("LogViewer");
        this.logviewerMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.logviewerMenuItemActionPerformed(actionEvent);
            }
        });
        this.toolsMenu.add(this.logviewerMenuItem);
        jMenuBar.add(this.toolsMenu);
        this.helpMenu.setText("Help");
        this.principleBtn.setText("Principle");
        this.principleBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.helpActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.principleBtn);
        this.distributionBtn.setText("Servers Distribution");
        this.distributionBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.helpActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.distributionBtn);
        this.stateIconsBtn.setText("State Icons");
        this.stateIconsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.helpActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.stateIconsBtn);
        this.tangorbBtn.setText("TangORB revision");
        this.tangorbBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.helpActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.tangorbBtn);
        this.starterEventsItem.setText("Hosts Controlled on Events");
        this.starterEventsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.helpActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.starterEventsItem);
        this.starterNoEventsItem.setText("Hosts Controlled on Polling");
        this.starterNoEventsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.helpActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.starterNoEventsItem);
        this.releaseNoteBtn.setText("Release Note");
        this.releaseNoteBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.helpActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.releaseNoteBtn);
        this.aboutBtn.setText("About");
        this.aboutBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.helpActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.aboutBtn);
        jMenuBar.add(this.helpMenu);
        this.setJMenuBar(jMenuBar);
        this.pack();
    }

    private void ctrlPreferenceBtnActionPerformed(ActionEvent actionEvent) {
        new PreferenceDialog(this).setVisible(true);
    }

    private void startupErrorBtnActionPerformed(ActionEvent actionEvent) {
        if (this.tree.subscribeErrWindow == null) {
            PopupMessage.show((Component)this, "No error at startup.");
        } else {
            this.tree.subscribeErrWindow.setVisible(true);
        }
    }

    private void accessControlBtnActionPerformed(ActionEvent actionEvent) {
        try {
            new TangoAccess(this).setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, (String)"Cannot start TangoAccess class", (DevFailed)devFailed);
        }
    }

    private void changeTgHostBtnActionPerformed(ActionEvent actionEvent) {
        try {
            String string;
            if (this.tango_host_selector == null) {
                String[] stringArray = AstorUtil.getKnownTangoHosts();
                this.tango_host_selector = new Selector((JFrame)this, "Tango Host  (e.g.  hal:2001)", stringArray, this.tango_host);
                ATKGraphicsUtils.centerDialog((Dialog)this.tango_host_selector);
            }
            if ((string = this.tango_host_selector.showDialog()) == null || string.length() == 0) {
                return;
            }
            String[] stringArray = string.split(":");
            if (stringArray.length != 2) {
                PopupError.show((Component)this, "Input syntax error\n" + string + "\n is not a valid TANGO_HOST");
                return;
            }
            ApiUtil.get_db_obj((String)stringArray[0], (String)stringArray[1]);
            if (this.tango_host.equals(string)) {
                return;
            }
            this.tango_host = string;
            this.tree.hostDialogs.close();
            this.tree.hostDialogs.clear();
            if (dev_browser != null) {
                dev_browser.setVisible(false);
                dev_browser = null;
            }
            AstorUtil.setTangoHost(this.tango_host);
            ApiUtil.change_db_obj((String)stringArray[0], (String)stringArray[1]);
            AstorUtil.readAstorProperties();
            this.buildTree();
            this.buildToolsItems();
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, (String)"Cannot change TANGO_HOST", (DevFailed)devFailed);
        }
    }

    private void logviewerMenuItemActionPerformed(ActionEvent actionEvent) {
        if (this.logviewer == null) {
            this.logviewer = new Main((JFrame)this);
        }
        this.logviewer.setVisible(true);
        this.logviewer.toFront();
    }

    private void jiveMenuItemActionPerformed(ActionEvent actionEvent) {
        this.tree.displayJiveAppli();
    }

    private void findHostItemActionPerformed(ActionEvent actionEvent) {
        String string = (String)JOptionPane.showInputDialog(this, "Host's Name ?", "Input Dialog", 1, null, null, searched_host);
        if (string != null) {
            this.tree.setSelectionPath(string);
            this.tree.displayHostInfo();
            searched_host = string;
        }
    }

    private void tangoStatBtnActionPerformed(ActionEvent actionEvent) {
        if (JOptionPane.showConfirmDialog(this, "The System Information needs to browse Database\n        and it could take a long time !\n\nStart it any way ?", "Confirm Dialog", 0) == 0) {
            new DeviceTreeDialog(this);
        }
    }

    private void toolsItemActionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        for (int i = 0; i < this.app_tools.size(); ++i) {
            OneTool oneTool = (OneTool)this.app_tools.elementAt(i);
            if (!oneTool.name.equals(string)) continue;
            try {
                System.out.println("Starting " + oneTool.classname);
                if (oneTool.jframe == null) {
                    Class<?> clazz = Class.forName(oneTool.classname);
                    Class[] classArray = new Class[]{JFrame.class};
                    Constructor<?> constructor = clazz.getConstructor(classArray);
                    JFrame jFrame = (JFrame)constructor.newInstance(this);
                    oneTool.setJFrame(jFrame);
                }
                oneTool.jframe.setVisible(true);
                continue;
            }
            catch (Exception exception) {
                ErrorPane.showErrorMessage((Component)this, null, (Exception)exception);
            }
        }
    }

    void removeHost(String string) {
        if (JOptionPane.showConfirmDialog(this, "Are you sure to want to remove " + string, "Confirm Dialog", 0) != 0) {
            return;
        }
        String string2 = "Starter/" + string;
        String string3 = "dserver/" + string2;
        String string4 = "tango/admin/" + string;
        try {
            DeviceProxy deviceProxy = new DeviceProxy(string4);
            deviceProxy.delete_property("StarteDsPath");
            deviceProxy.delete_property("HostCollection");
            deviceProxy.delete_property("HostUsage");
            deviceProxy.delete_property("UseEvents");
            Database database = ApiUtil.get_db_obj((String)AstorUtil.getTangoHost());
            database.delete_server(string2);
            database.delete_device(string4);
            database.delete_device(string3);
            JOptionPane.showMessageDialog(this, string + " has been removed !", "Command Done", 1);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, (String)"Cannot remove host", (DevFailed)devFailed);
        }
        try {
            this.buildTree();
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
        }
    }

    private void newHostBtnActionPerformed(ActionEvent actionEvent) {
        this.addNewHost(null);
    }

    void addNewHost(TangoHost tangoHost) {
        NewStarterDialog newStarterDialog = new NewStarterDialog(this, tangoHost, this.tree.getCollectionList(), this.tree.hosts, true);
        newStarterDialog.setVisible(true);
        if (newStarterDialog.getValue() == 0) {
            try {
                this.buildTree();
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
            }
        }
    }

    void editHostProperties(TangoHost tangoHost) {
        NewStarterDialog newStarterDialog = new NewStarterDialog(this, tangoHost, this.tree.getCollectionList(), this.tree.hosts, false);
        newStarterDialog.setVisible(true);
    }

    private void stopServersBtnActionPerformed(ActionEvent actionEvent) {
        new ServerCmdThread(this, this.tree.hosts, 1).start();
    }

    private void startServersBtnActionPerformed(ActionEvent actionEvent) {
        new ServerCmdThread(this, this.tree.hosts, 0).start();
    }

    private void newBranchBtnActionPerformed(ActionEvent actionEvent) {
        String string = (String)JOptionPane.showInputDialog(this, "New Branch Name", "Input Dialog", 1, null, null, "");
        if (string != null) {
            this.tree.addBranch(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void helpActionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(this.principleBtn.getText())) {
            PopupMessage.showImage((Component)this, (String)null, "/app_util/img/principle.gif");
        } else if (string.equals(this.distributionBtn.getText())) {
            new HostsScanThread(this, this.tree.hosts).start();
        } else if (string.equals(this.stateIconsBtn.getText())) {
            PopupMessage.showImage((Component)this, (String)null, "/app_util/img/astor_state_icons.jpg");
        } else if (string.equals(this.releaseNoteBtn.getText())) {
            new PopupHtml(this).show("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n<HTML>\n<HEAD>\n<Title> Release Note </Title>\n</HEAD>\n<BODY TEXT=\"#000000\" BGCOLOR=\"#FFFFFF\" LINK=\"#0000FF\" VLINK=\"#7F00FF\" ALINK=\"#FF0000\">\n<P><!-------TITLE------></P>\n<Center>\t<h2>Astor Release Note</h2>\n\t(Generated Fri Oct 08 09:46:00 CEST 2010)</Center><Br>\n<li><b>Astor-5.2.10 -  08/10/10:</b><Br>\n&nbsp; &nbsp; Change default view in Polling Profiler.<Br>\n<li><b>Astor-5.2.9 -  01/09/10:</b><Br>\n&nbsp; &nbsp; Minor change (traces removed and added).<Br>\n&nbsp; &nbsp; <Br>\n<li><b>Astor-5.2.8 -  17/06/10:</b><Br>\n&nbsp; &nbsp; Pb on display startup level dialog in case of many devices fixed.<Br>\n<li><b>Astor-5.2.7 -  17/06/10:</b><Br>\n&nbsp; &nbsp; Start new server can take several servers (multiple selection).<Br>\n<li><b>Astor-5.2.6 -  04/06/10:</b><Br>\n&nbsp; &nbsp; Global command to change startup level added.<Br>\n<li><b>Astor-5.2.5 -  08/04/10:</b><Br>\n&nbsp; &nbsp; Minor bugs fixed.<Br>\n<li><b>Astor-5.2.4 -  05/01/10:</b><Br>\n&nbsp; &nbsp; Best management of subscribe error window at startup.<Br>\n<li><b>Astor-5.2.3 -  18/08/09:</b><Br>\n&nbsp; &nbsp; Bug in Device Dependencies fixed (infinite loop)<Br>\n<li><b>Astor-5.2.2 -  02/06/09:</b><Br>\n&nbsp; &nbsp; Bug on host.check_notifyd fixed.<Br>\n<li><b>Astor-5.2.1 -  15/05/09:</b><Br>\n&nbsp; &nbsp; Remove serialization between HostStateThread and HostInfoDialogVector.<Br>\n<li><b>Astor-5.2.0 -  18/04/09:</b><Br>\n&nbsp; &nbsp; Tango-7 tools accessible.<Br>\n&nbsp; &nbsp; Device dependencies (sub-devices) tool added.<Br>\n&nbsp; &nbsp; MySqlUtil feature added.<Br>\n<li><b>Astor-5.1.3 -  30/01/09:</b><Br>\n&nbsp; &nbsp; Black box management added for database.<Br>\n&nbsp; &nbsp; Black box management tool improved.<Br>\n&nbsp; &nbsp; Find TANGO object by filter added.<Br>\n<li><b>Astor-5.1.2 -  16/01/09:</b><Br>\n&nbsp; &nbsp; Black box management added for host and Server.<Br>\n&nbsp; &nbsp; Starter logging display added for host and server.<Br>\n&nbsp; &nbsp; Splash screen use ATK one.<Br>\n<li><b>Astor-5.1.1 -  17/12/08:</b><Br>\n&nbsp; &nbsp; Add a scroll pane in HostInfoDialog in case of too big dialog.<Br>\n<li><b>Astor-5.1.0 -  09/10/08:</b><Br>\n&nbsp; &nbsp; Pool thread management added but not accessible.<Br>\n&nbsp; &nbsp; New version and tests for access.<Br>\n<li><b>Astor-5.0.5 -  12/09/08:</b><Br>\n&nbsp; &nbsp; Bug in server info (if not running) fixed.<Br>\n<li><b>Astor-5.0.4 -  16/06/08:</b><Br>\n&nbsp; &nbsp; Level trees are now displayed on 2 rows.<Br>\n<li><b>Astor-5.0.3 -  22/05/08:</b><Br>\n&nbsp; &nbsp; Host info dialog servers are managed in a jtree.<Br>\n<li><b>Astor-5.0.2 -  07/05/08:</b><Br>\n&nbsp; &nbsp; Host info dialog line management changed.<Br>\n&nbsp; &nbsp; Browse Database option added in DB popup menu.<Br>\n<li><b>Astor-5.0.1 -  10/04/08:</b><Br>\n&nbsp; &nbsp; Branch info modified.<Br>\n&nbsp; &nbsp; Table of hosts and servers added.<Br>\n<li><b>Astor-5.0.0 -  27/03/08:</b><Br>\n&nbsp; &nbsp; Compatibility with Starter 4.0 and after only !<Br>\n&nbsp; &nbsp; Better management of server list.<Br>\n&nbsp; &nbsp; Server state MOVING managed.<Br>\n&nbsp; &nbsp; Hard kill added on servers.<Br>\n&nbsp; &nbsp; New features on polling profiler.<Br>\n<li><b>Astor-4.5.7 -  12/12/07:</b><Br>\n&nbsp; &nbsp; Reset buttons added in event configuration panel.<Br>\n<li><b>Astor-4.5.6 -  07/11/07:</b><Br>\n&nbsp; &nbsp; Display host info if OSManage DS  is running on host.<Br>\n&nbsp; &nbsp; Display host's state on HotInfoDialog.<Br>\n<li><b>Astor-4.5.5 -  11/09/07:</b><Br>\n&nbsp; &nbsp; Db attribute polling panel added.<Br>\n&nbsp; &nbsp; Bug on repeate error window when refresh tree fixed.<Br>\n<li><b>Astor-4.5.4  -  04/09/07:</b><Br>\n&nbsp; &nbsp; Set attribute polled names in lower case in new starter creation.<Br>\n<li><b>Astor-4.5.3  -  20/08/07:</b><Br>\n&nbsp; &nbsp; ServStatePanel added on HostInfoDialog (Check states option).<Br>\n<li><b>Astor-4.5.2  -  27/04/07:</b><Br>\n&nbsp; &nbsp; Display host panel available for stopped server from Device Browser.<Br>\n<li><b>Astor-4.5.1  -  04/04/07:</b><Br>\n&nbsp; &nbsp; Database attribute properties editor added.<Br>\n<li><b>Astor-4.5.0  -  27/03/07:</b><Br>\n&nbsp; &nbsp; Preferences dialog added.<Br>\n<li><b>Astor-4.4.4  -  08/03/07:</b><Br>\n&nbsp; &nbsp; LastCollections property is managed.<Br>\n<li><b>Astor-4.4.3  -  22/01/07:</b><Br>\n&nbsp; &nbsp; Remove watch dog on host thread.<Br>\n<li><b>Astor-4.4.2  -  17/01/07:</b><Br>\n&nbsp; &nbsp; Html helps added.<Br>\n&nbsp; &nbsp; Startup error message added in view menu.<Br>\n<li><b>Astor-4.4.1  -  08/01/07:</b><Br>\n&nbsp; &nbsp; Disable Start Server button if Starter is MOVING.<Br>\n<li><b>Astor-4.4.0  -  25/09/06:</b><Br>\n&nbsp; &nbsp; Access control tool added.<Br>\n<li><b>Astor-4.3.2:</b><Br>\n&nbsp; &nbsp; Bug fixed in miscellaneous host collection.<Br>\n<li><b>Astor-4.3.1:</b><Br>\n&nbsp; &nbsp; Moving state added for collectionx.<Br>\n&nbsp; &nbsp; In StartAll command a sleep(500) has been added between two hosts.<Br>\n<li><b>Astor-4.3.0:</b><Br>\n&nbsp; &nbsp; Moving state added for startup phase.<Br>\n<li><b>Astor-4.2.3:</b><Br>\n&nbsp; &nbsp; Host info panel modified to use icons.<Br>\n<li><b>Astor-4.2.2:</b><Br>\n&nbsp; &nbsp; Backward compatibilty for jive fixed.<Br>\n<li><b>Astor-4.2.1:</b><Br>\n&nbsp; &nbsp; Icons have been changed.<Br>\n&nbsp; &nbsp; Some minor changes.<Br>\n<li><b>Astor-4.2.0:</b><Br>\n&nbsp; &nbsp; Polling profiler added.<Br>\n<li><b>Astor-4.1.4:</b><Br>\n&nbsp; &nbsp; Open/Save menu added on event tester window.<Br>\n<li><b>Astor-4.1.3:</b><Br>\n&nbsp; &nbsp; History added on event management.<Br>\n&nbsp; &nbsp; The maximum servers displayed in horizontal on HostInfoDialog<Br>\n&nbsp; &nbsp; window has been set to 5.<Br>\n<li><b>Astor-4.1.2:</b><Br>\n&nbsp; &nbsp; Bug fixed in Device browser in member device name.<Br>\n<li><b>Astor-4.1.1:</b><Br>\n&nbsp; &nbsp; Change TANGO_HOST added (needs TangORB-4.7.7 or later).<Br>\n<li><b>Astor-4.1.0:</b><Br>\n&nbsp; &nbsp; DevBrowser and MkStarter utilities added.<Br>\n<li><b>Astor-4.0.9:</b><Br>\n&nbsp; &nbsp; Minor changes for EventTester compatibility<Br>\n<li><b>Astor-4.0.8:</b><Br>\n&nbsp; &nbsp; Screen position modified for dialogs.<Br>\n<li><b>Astor-4.0.7:</b><Br>\n&nbsp; &nbsp; Search if host already exist before creation.<Br>\n<li><b>Astor-4.0.6:</b><Br>\n&nbsp; &nbsp; Search by host name added.<Br>\n<li><b>Astor-4.0.5:</b><Br>\n&nbsp; &nbsp; Can change memorized attribute value.<Br>\n<li><b>Astor-4.0.4:</b><Br>\n&nbsp; &nbsp; Bug in server architecture fixed.<Br>\n<li><b>Astor-4.0.3:</b><Br>\n&nbsp; &nbsp; Minor changes, RemoteCmd property added.<Br>\n<li><b>Astor-4.0.2:</b><Br>\n&nbsp; &nbsp; Server architecture display addded.<Br>\n<li><b>Astor-4.0.1:</b><Br>\n&nbsp; &nbsp; DevWizard calls addded.<Br>\n<li><b>Astor-4.0.0:</b><Br>\n&nbsp; &nbsp; Possibility to controle two database servers added.<Br>\n</Body>\n</Html>\n");
        } else if (string.equals(this.tangorbBtn.getText())) {
            TangORBversion tangORBversion;
            try {
                tangORBversion = new TangORBversion();
            }
            catch (Exception exception) {
                ErrorPane.showErrorMessage((Component)this, (String)"Cannot check TangORB revision", (Exception)exception);
                return;
            }
            String string2 = tangORBversion.jarfile + ":\n\n" + tangORBversion;
            PopupText popupText = new PopupText((Frame)this, true);
            popupText.setFont(new Font("Courier", 1, 14));
            AstorUtil.centerDialog((JDialog)popupText, this);
            popupText.show(string2);
        } else if (string.equals(this.aboutBtn.getText())) {
            String string3 = "           Astor  (Tango Manager) \n\nThis programme is used to control, start and stop\n           the TANGO device servers. \n\n" + revNumber + "\n\n" + "Pascal Verdier - Software Engineering Group - ESRF";
            PopupMessage.showImage((Component)this, string3, "/app_util/img/tango_icon.jpg");
        } else if (string.equals(this.starterEventsItem.getText())) {
            void var4_13;
            int n;
            Vector<String> vector = new Vector<String>();
            TangoHost[] object = this.tree.hosts;
            int n2 = object.length;
            for (n = 0; n < n2; ++n) {
                TangoHost tangoHost = object[n];
                if (!tangoHost.use_events) continue;
                vector.add(tangoHost.getName());
            }
            String[] stringArray = null;
            if (vector.size() == 0) {
                String object2 = "There is no host controlled on events !";
            } else if (vector.size() == this.tree.hosts.length) {
                String string2 = "All hosts are controlled on events !";
            } else {
                String string3 = "On " + this.tree.hosts.length + " hosts,\n" + vector.size() + "  are controlled on events :";
                stringArray = new String[vector.size()];
                for (n = 0; n < vector.size(); ++n) {
                    stringArray[n] = (String)vector.get(n);
                }
            }
            if (stringArray == null) {
                PopupMessage.show((Component)this, (String)var4_13);
            } else {
                new PopupText((Frame)this, true).show((String)var4_13, stringArray, 300, 400);
            }
        } else if (string.equals(this.starterNoEventsItem.getText())) {
            void var4_18;
            int n;
            Vector<String> vector = new Vector<String>();
            TangoHost[] tangoHostArray = this.tree.hosts;
            int n3 = tangoHostArray.length;
            for (n = 0; n < n3; ++n) {
                TangoHost tangoHost = tangoHostArray[n];
                if (tangoHost.use_events) continue;
                vector.add(tangoHost.getName());
            }
            String[] stringArray = null;
            if (vector.size() == 0) {
                String string4 = "There is no host controlled on polling !";
            } else if (vector.size() == this.tree.hosts.length) {
                String string5 = "All hosts are controlled on polling !";
            } else {
                String string6 = "On " + this.tree.hosts.length + " hosts,\n" + vector.size() + "  are controlled on polling :";
                stringArray = new String[vector.size()];
                for (n = 0; n < vector.size(); ++n) {
                    stringArray[n] = (String)vector.get(n);
                }
            }
            if (stringArray == null) {
                PopupMessage.show((Component)this, (String)var4_18);
            } else {
                new PopupText((Frame)this, true).show((String)var4_18, stringArray, 300, 400);
            }
        } else {
            PopupMessage.show((Component)this, "Not implemented yet !");
        }
    }

    private void stopHostsControledBtnActionPerformed(ActionEvent actionEvent) {
        if (this.tree != null) {
            for (TangoHost tangoHost : this.tree.hosts) {
                tangoHost.do_polling = false;
                this.tree.hostDialogs.close(tangoHost);
            }
            this.stopHostsControledBtn.setSelected(false);
        }
    }

    private void allHostsControledBtnActionPerformed(ActionEvent actionEvent) {
        for (TangoHost tangoHost : this.tree.hosts) {
            tangoHost.do_polling = true;
        }
        this.allHostsControledBtn.setSelected(false);
    }

    private void expandBtnActionPerformed(ActionEvent actionEvent) {
        this.expanded = !this.expanded;
        this.tree.expand(this.expanded);
        if (this.expanded) {
            this.expandBtn.setText("Collapse Tree");
        } else {
            this.expandBtn.setText("Expand Tree");
        }
    }

    private void deviceBrowserBtnActionPerformed(ActionEvent actionEvent) {
        if (dev_browser == null) {
            dev_browser = new DevBrowser(this);
        }
        dev_browser.setVisible(true);
    }

    private void refreshBtnActionPerformed(ActionEvent actionEvent) {
        try {
            this.buildTree();
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
        }
    }

    private void exitBtnActionPerformed(ActionEvent actionEvent) {
        this.doExit();
    }

    private void exitForm(WindowEvent windowEvent) {
        this.doExit();
    }

    private void findObjectByFilterItemActionPerformed(ActionEvent actionEvent) {
        if (this.wide_search_dlg == null) {
            this.wide_search_dlg = new WideSearchDialog(this);
        }
        this.wide_search_dlg.setVisible(true);
    }

    private void stopThreads() {
        System.out.println("Astor exiting....");
        if (this.tree != null && this.tree.hosts != null) {
            for (TangoHost tangoHost : this.tree.hosts) {
                tangoHost.stopThread();
                if (!tangoHost.use_events) continue;
                try {
                    Thread.sleep(20L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        System.out.println(" ");
    }

    public void doExit() {
        if (dev_browser != null && dev_browser.isVisible()) {
            this.setVisible(false);
        } else {
            this.setVisible(false);
            this.stopThreads();
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            try {
                new AstorCmdLine(stringArray);
            }
            catch (DevFailed devFailed) {
                Except.print_exception((Exception)((Object)devFailed));
            }
            catch (Exception exception) {
                System.out.println(exception);
                exception.printStackTrace();
            }
            System.exit(0);
        }
        long l = System.currentTimeMillis();
        TangoWindow tangoWindow = new TangoWindow("ASTOR  Tango Manager");
        try {
            Astor astor = new Astor();
            astor.setVisible(true);
            displayed = true;
        }
        catch (DevFailed devFailed) {
            System.out.println((Object)devFailed);
            tangoWindow.setVisible(false);
            ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)devFailed);
            System.exit(-1);
        }
        catch (InternalError internalError) {
            System.out.println(internalError);
        }
        catch (HeadlessException headlessException) {
            System.out.println(headlessException);
        }
        long l2 = System.currentTimeMillis();
        System.out.println("Build  GUI :" + (l2 - l) + " ms");
    }

    static {
        searched_host = "";
    }

    class HostsScanThread
    extends Thread {
        private JFrame parent;
        private TangoHost[] hosts;

        HostsScanThread(JFrame jFrame, TangoHost[] tangoHostArray) {
            this.parent = jFrame;
            this.hosts = tangoHostArray;
        }

        @Override
        public void run() {
            String[][] stringArray = new String[this.hosts.length][];
            String string = "Scanning hosts...";
            Monitor monitor = new Monitor(this.parent, string);
            double d = 0.01;
            monitor.setProgressValue(d, "Starting...");
            try {
                HostsScanThread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                String[] stringArray2;
                int n = 0;
                for (int i = 0; i < this.hosts.length; ++i) {
                    d = (1.0 + 1.0 * (double)i) / (double)this.hosts.length;
                    monitor.setProgressValue(d, "Reading " + this.hosts[i].getName());
                    stringArray2 = this.hosts[i].getServerAttribute();
                    stringArray[i] = new String[2];
                    stringArray[i][0] = this.hosts[i].getName();
                    stringArray[i][1] = "" + stringArray2.length;
                    n += stringArray2.length;
                }
                String string2 = n + " servers   on " + this.hosts.length + " hosts";
                stringArray2 = new String[]{"Names", "Nb Servers"};
                PopupTable popupTable = new PopupTable(this.parent, string2, stringArray2, stringArray);
                popupTable.setColumnWidth(new int[]{200, 100});
                popupTable.setVisible(true);
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this.parent, (String)"", (DevFailed)devFailed);
            }
        }
    }
}

