/*
 * Decompiled with CFR 0.152.
 */
package tool_panels.servstate;

import app_util.PopupHtml;
import app_util.PopupMessage;
import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import tool_panels.servstate.ServStatePanel;

public class MainPanel
extends JFrame {
    private static String revNumber = "Release 1.1  -  Wed Aug 26 15:33:42 CEST 2009";
    private static JFileChooser chooser = null;
    private JMenuItem aboutItem;
    private JMenuItem exitItem;
    private JMenu fileMenu;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JPanel jPanel1;
    private JMenuItem openItem;
    private JMenuItem releaseNoteItem;

    public MainPanel(String servname) {
        this.initComponents();
        this.openItem.setVisible(false);
        try {
            ServStatePanel panel = new ServStatePanel(servname);
            this.getContentPane().add((Component)panel, "Center");
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
        this.customizeMenus();
        this.setTitle("MainPanelPanel - " + revNumber);
        this.pack();
        ATKGraphicsUtils.centerFrameOnScreen((Frame)this);
    }

    private void customizeMenus() {
        this.fileMenu.setMnemonic('F');
        this.openItem.setMnemonic('O');
        this.openItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.exitItem.setMnemonic('E');
        this.exitItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openItem = new JMenuItem();
        this.exitItem = new JMenuItem();
        this.jMenu1 = new JMenu();
        this.releaseNoteItem = new JMenuItem();
        this.aboutItem = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                MainPanel.this.exitForm(evt);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.fileMenu.setText("File");
        this.openItem.setText("Open");
        this.openItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.openItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openItem);
        this.exitItem.setText("Exit");
        this.exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.exitItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitItem);
        this.jMenuBar1.add(this.fileMenu);
        this.jMenu1.setText("Help");
        this.releaseNoteItem.setText("Release Notes");
        this.releaseNoteItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.releaseNoteItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.releaseNoteItem);
        this.aboutItem.setText("About");
        this.aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.aboutItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.aboutItem);
        this.jMenuBar1.add(this.jMenu1);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void releaseNoteItemActionPerformed(ActionEvent evt) {
        new PopupHtml(this).show("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n<HTML>\n<HEAD>\n<Title> Release Note </Title>\n</HEAD>\n<BODY TEXT=\"#000000\" BGCOLOR=\"#FFFFFF\" LINK=\"#0000FF\" VLINK=\"#7F00FF\" ALINK=\"#FF0000\">\n<P><!-------TITLE------></P>\n<Center>\t<h2>servstate Release Note</h2>\n\t(Generated Wed Aug 26 15:33:42 CEST 2009)</Center><Br>\n<li><b>ServStatePanel-1.1 - 20/12/07:</b><Br>\n&nbsp; &nbsp; Bug in display state as text fixed.<Br>\n<li><b>ServStatePanel-1.0 - 20/08/07:</b><Br>\n&nbsp; &nbsp; Initial Revision<Br>\n</Body>\n</Html>\n");
    }

    private void aboutItemActionPerformed(ActionEvent evt) {
        String message = "MainPanelPanel\n" + revNumber + "\n\n" + "Pascal Verdier - Software Engineering Group - ESRF";
        PopupMessage.showImage((Component)this, message, "/app_util/img/tango_icon.jpg");
    }

    private void openItemActionPerformed(ActionEvent evt) {
        File file;
        int retval;
        if (chooser == null) {
            chooser = new JFileChooser(new File("").getAbsolutePath());
        }
        if ((retval = chooser.showOpenDialog(this)) == 0 && (file = chooser.getSelectedFile()) != null && !file.isDirectory()) {
            String filename = file.getAbsolutePath();
            System.out.println(filename);
        }
    }

    private void exitItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        String servname = "PLCvacuumValve/sr_c05";
        if (args.length > 0) {
            servname = args[0];
        } else {
            System.out.println("Server name ?");
            System.exit(0);
        }
        new MainPanel(servname).setVisible(true);
    }
}

