/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IEnumScalar;
import fr.esrf.tangoatk.core.IEnumScalarListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.EnumScalar;
import java.io.Serializable;

public class EnumScalarHelper
implements Serializable {
    AAttribute enumAtt;
    EventSupport propChanges;

    public EnumScalarHelper(AAttribute aAttribute) {
        this.init(aAttribute);
    }

    void init(AAttribute aAttribute) {
        this.setAttribute(aAttribute);
        this.propChanges = aAttribute.getPropChanges();
    }

    public void setAttribute(AAttribute aAttribute) {
        this.enumAtt = aAttribute;
    }

    public AAttribute getAttribute() {
        return this.enumAtt;
    }

    void insert(String string) throws DevFailed, AttributeSetException {
        DeviceAttribute deviceAttribute = this.enumAtt.getAttribute();
        if (deviceAttribute == null) {
            throw new AttributeSetException("Cannot set enumeration value. DeviceAttribute is null.");
        }
        try {
            short s = this.getShortValueForEnum(string);
            if (this.enumAtt.getTangoDataType() == 6) {
                short s2 = s;
                deviceAttribute.insert_us((int)s2);
            } else {
                deviceAttribute.insert(s);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AttributeSetException("Invalid enumeration value");
        }
    }

    String getEnumScalarValue(DeviceAttribute deviceAttribute) throws DevFailed, AttributeReadException {
        short[] sArray = null;
        sArray = deviceAttribute.extractShortArray();
        if (sArray == null) {
            throw new AttributeReadException("Invalid shortArray");
        }
        if (sArray.length < 1) {
            throw new AttributeReadException("Invalid shortArray");
        }
        try {
            String string = this.getEnumValueFromShort(sArray[0]);
            return string;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AttributeReadException("Invalid enumeration value");
        }
    }

    String getEnumScalarSetPoint(DeviceAttribute deviceAttribute) throws DevFailed, AttributeReadException {
        short[] sArray = null;
        sArray = deviceAttribute.extractShortArray();
        if (sArray == null) {
            throw new AttributeReadException("Invalid shortArray");
        }
        if (sArray.length < 1) {
            throw new AttributeReadException("Invalid shortArray");
        }
        try {
            String string = sArray.length > 1 ? this.getEnumValueFromShort(sArray[1]) : this.getEnumValueFromShort(sArray[0]);
            return string;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AttributeReadException("Invalid enumeration set value");
        }
    }

    private short getShortValueForEnum(String string) throws IllegalArgumentException {
        String[] stringArray = null;
        if (string == null) {
            throw new IllegalArgumentException();
        }
        EnumScalar enumScalar = (EnumScalar)this.enumAtt;
        stringArray = enumScalar.getEnumValues();
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            n = i;
            break;
        }
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        short s = (short)n;
        return s;
    }

    private String getEnumValueFromShort(short s) throws IllegalArgumentException {
        String[] stringArray = null;
        if (s < 0) {
            throw new IllegalArgumentException();
        }
        EnumScalar enumScalar = (EnumScalar)this.enumAtt;
        stringArray = enumScalar.getEnumValues();
        if (s >= stringArray.length) {
            throw new IllegalArgumentException();
        }
        String string = stringArray[s];
        return string;
    }

    public void addEnumScalarListener(IEnumScalarListener iEnumScalarListener) {
        this.propChanges.addEnumScalarListener(iEnumScalarListener);
    }

    public void removeEnumScalarListener(IEnumScalarListener iEnumScalarListener) {
        this.propChanges.removeEnumScalarListener(iEnumScalarListener);
    }

    void fireEnumScalarValueChanged(String string, long l) {
        this.propChanges.fireEnumScalarEvent((IEnumScalar)((Object)this.enumAtt), string, l);
    }

    public String getVersion() {
        return "$Id: EnumScalarHelper.java,v 1.5 2010/09/24 13:11:54 poncet Exp $";
    }
}

