/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IDevStateSpectrum;
import fr.esrf.tangoatk.core.IDevStateSpectrumListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import java.io.Serializable;

class DevStateSpectrumHelper
implements Serializable {
    AAttribute attribute;
    EventSupport propChanges;

    public DevStateSpectrumHelper(AAttribute aAttribute) {
        this.init(aAttribute);
    }

    void init(AAttribute aAttribute) {
        this.setAttribute(aAttribute);
        this.propChanges = aAttribute.getPropChanges();
    }

    public void setAttribute(AAttribute aAttribute) {
        this.attribute = aAttribute;
    }

    public AAttribute getAttribute() {
        return this.attribute;
    }

    protected void setProperty(String string, Number number) {
        this.attribute.setProperty(string, number);
        this.attribute.storeConfig();
    }

    protected void setProperty(String string, Number number, boolean bl) {
        this.attribute.setProperty(string, number, bl);
    }

    void fireDevStateSpectrumValueChanged(String[] stringArray, long l) {
        this.propChanges.fireDevStateSpectrumEvent((IDevStateSpectrum)((Object)this.attribute), stringArray, l);
    }

    void insert(String[] stringArray) {
        DevState[] devStateArray = new DevState[stringArray.length];
        DeviceAttribute deviceAttribute = this.attribute.getAttribute();
        for (int i = 0; i < stringArray.length; ++i) {
            devStateArray[i] = Device.getStateFromString(stringArray[i]);
        }
        deviceAttribute.insert(devStateArray);
    }

    String[] getStateSpectrumValue(DeviceAttribute deviceAttribute) throws DevFailed {
        String[] stringArray = null;
        DevState[] devStateArray = null;
        devStateArray = deviceAttribute.extractDevStateArray();
        int n = deviceAttribute.getNbRead();
        stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = Device.toString(devStateArray[i]);
        }
        return stringArray;
    }

    String[] getStateSpectrumSetPoint(DeviceAttribute deviceAttribute) throws DevFailed {
        int n;
        DevState[] devStateArray = null;
        String[] stringArray = null;
        devStateArray = deviceAttribute.extractDevStateArray();
        int n2 = devStateArray.length - (n = deviceAttribute.getNbRead());
        if (n2 <= 0) {
            return this.getStateSpectrumValue(deviceAttribute);
        }
        stringArray = new String[n2];
        int n3 = 0;
        for (int i = n; i < devStateArray.length; ++i) {
            stringArray[n3] = Device.toString(devStateArray[i]);
            ++n3;
        }
        return stringArray;
    }

    void addDevStateSpectrumListener(IDevStateSpectrumListener iDevStateSpectrumListener) {
        this.propChanges.addDevStateSpectrumListener(iDevStateSpectrumListener);
    }

    void removeDevStateSpectrumListener(IDevStateSpectrumListener iDevStateSpectrumListener) {
        this.propChanges.removeDevStateSpectrumListener(iDevStateSpectrumListener);
    }

    public String getVersion() {
        return "$Id: DevStateSpectrumHelper.java,v 1.5 2010/09/24 13:11:54 poncet Exp $";
    }
}

