/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IDevStateScalarListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import java.io.Serializable;

class DevStateScalarHelper
implements Serializable {
    AAttribute attribute;
    EventSupport propChanges;

    public DevStateScalarHelper(AAttribute aAttribute) {
        this.init(aAttribute);
    }

    void init(AAttribute aAttribute) {
        this.setAttribute(aAttribute);
        this.propChanges = aAttribute.getPropChanges();
    }

    public void setAttribute(AAttribute aAttribute) {
        this.attribute = aAttribute;
    }

    public IAttribute getAttribute() {
        return this.attribute;
    }

    protected void setProperty(String string, Number number) {
        this.attribute.setProperty(string, number);
        this.attribute.storeConfig();
    }

    protected void setProperty(String string, Number number, boolean bl) {
        this.attribute.setProperty(string, number, bl);
    }

    void fireValueChanged(String string, long l) {
        this.propChanges.fireDevStateScalarEvent((IDevStateScalar)((Object)this.attribute), string, l);
    }

    String extract() throws DevFailed {
        return Device.toString(this.attribute.getAttribute().extractState());
    }

    void addDevStateScalarListener(IDevStateScalarListener iDevStateScalarListener) {
        this.propChanges.addDevStateScalarListener(iDevStateScalarListener);
    }

    void removeDevStateScalarListener(IDevStateScalarListener iDevStateScalarListener) {
        this.propChanges.removeDevStateScalarListener(iDevStateScalarListener);
    }

    public String getVersion() {
        return "$Id: DevStateScalarHelper.java,v 1.3 2010/09/24 13:11:54 poncet Exp $";
    }
}

