/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl;

import com.sun.opengl.impl.GLContextImpl;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import javax.media.opengl.GLContext;

public class GLWorkerThread {
    private static volatile boolean started;
    private static volatile Thread thread;
    private static Object lock;
    private static volatile boolean shouldTerminate;
    private static volatile Throwable exception;
    private static volatile Runnable work;
    private static List queue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        if (!started) {
            Class clazz = GLWorkerThread.class;
            synchronized (clazz) {
                if (!started) {
                    lock = new Object();
                    thread = new Thread((Runnable)new WorkerRunnable(), "JOGL GLWorkerThread");
                    thread.setDaemon(true);
                    started = true;
                    Object object = lock;
                    synchronized (object) {
                        thread.start();
                        try {
                            lock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                throw new RuntimeException("Should not start GLWorkerThread twice");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeAndWait(Runnable runnable) throws InvocationTargetException, InterruptedException {
        if (!started) {
            throw new RuntimeException("May not invokeAndWait on worker thread without starting it first");
        }
        Object object = lock;
        if (object == null) {
            return;
        }
        Object object2 = object;
        synchronized (object2) {
            if (thread == null) {
                return;
            }
            work = runnable;
            object.notifyAll();
            object.wait();
            if (exception != null) {
                Throwable throwable = exception;
                exception = null;
                throw new InvocationTargetException(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeLater(Runnable runnable) {
        if (!started) {
            throw new RuntimeException("May not invokeLater on worker thread without starting it first");
        }
        Object object = lock;
        if (object == null) {
            return;
        }
        Object object2 = object;
        synchronized (object2) {
            if (thread == null) {
                return;
            }
            queue.add(runnable);
            object.notifyAll();
        }
    }

    public static boolean isStarted() {
        return started;
    }

    public static boolean isWorkerThread() {
        return Thread.currentThread() == thread;
    }

    static {
        queue = new LinkedList();
    }

    static class WorkerRunnable
    implements Runnable {
        WorkerRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = lock;
            synchronized (object) {
                lock.notifyAll();
            }
            while (!shouldTerminate) {
                object = lock;
                synchronized (object) {
                    GLContextImpl gLContextImpl;
                    Object object2;
                    while (!shouldTerminate && work == null && queue.isEmpty()) {
                        try {
                            lock.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (GLContext.getCurrent() == null) continue;
                    }
                    if (shouldTerminate) {
                        lock.notifyAll();
                        GLWorkerThread.thread = null;
                        lock = null;
                        return;
                    }
                    if (work != null) {
                        try {
                            work.run();
                        }
                        catch (Throwable throwable) {
                            exception = throwable;
                        }
                        finally {
                            work = null;
                            lock.notifyAll();
                        }
                    }
                    while (!queue.isEmpty()) {
                        try {
                            object2 = (Runnable)queue.remove(0);
                            object2.run();
                        }
                        catch (Throwable throwable) {
                            System.out.println("Exception occurred on JOGL OpenGL worker thread:");
                            throwable.printStackTrace();
                        }
                    }
                    object2 = GLContext.getCurrent();
                    if (object2 != null && object2 instanceof GLContextImpl && (gLContextImpl = (GLContextImpl)((Object)object2)).hasWaiters()) {
                        gLContextImpl.release();
                    }
                }
            }
        }
    }
}

