/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.AttributeValue;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarBooleanArrayHelper;
import fr.esrf.Tango.DevVarDoubleArrayHelper;
import fr.esrf.Tango.DevVarFloatArrayHelper;
import fr.esrf.Tango.DevVarLong64ArrayHelper;
import fr.esrf.Tango.DevVarLongArrayHelper;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.Tango.DevVarShortArrayHelper;
import fr.esrf.Tango.DevVarStringArrayHelper;
import fr.esrf.Tango.DeviceHelper;
import fr.esrf.Tango.DeviceOperations;
import fr.esrf.Tango.TimeVal;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoDs.Attribute;
import fr.esrf.TangoDs.DServer;
import fr.esrf.TangoDs.DServerClass;
import fr.esrf.TangoDs.DeviceClass;
import fr.esrf.TangoDs.DeviceImpl;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.Logging;
import fr.esrf.TangoDs.PollObj;
import fr.esrf.TangoDs.PollThCmd;
import fr.esrf.TangoDs.PollThread;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.TangoDs.TangoMonitor;
import fr.esrf.TangoDs.TimedAttrData;
import fr.esrf.TangoDs.UtilPrint;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.log4j.Level;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.IdAssignmentPolicy;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.InvalidPolicy;

public class Util
implements TangoConst {
    private static Util _instance = null;
    private String ds_exec_name;
    private String ds_instance_name;
    private StringBuffer ds_name;
    private String real_server_name;
    private final UtilExt ext;
    static int _tracelevel = 0;
    public static UtilPrint out1;
    public static UtilPrint out2;
    public static UtilPrint out3;
    public static UtilPrint out4;
    public static UtilPrint out5;
    public static boolean _UseDb;
    public static boolean _daemon;
    public static int _sleep_between_connect;
    private String db_host;
    private Database db = null;
    private String hostname;
    private String version_str;
    private String pid_str;
    private Vector class_list;
    private ORB orb;
    private POA _poa;
    private final Vector cmd_line_name_list = new Vector();
    private final Vector class_name_list = new Vector();
    private static int serial_model;
    private static int thread_pool_max;
    private static boolean thread_pool_max_done;
    static int access_counter;

    public static Util instance() {
        if (_instance == null) {
            System.err.println("Util is not initialised !!!");
            System.err.println("Exiting");
            System.exit(-1);
        }
        return _instance;
    }

    public static Util init(String[] stringArray, String string) {
        if (_instance == null) {
            _instance = new Util(stringArray, string);
        }
        return _instance;
    }

    protected Util(String[] stringArray, String string) {
        this.ds_exec_name = string;
        if (stringArray.length < 1) {
            this.print_usage();
            System.exit(-1);
        }
        this.check_args(stringArray);
        out1 = new UtilPrint(Level.INFO);
        out2 = new UtilPrint(Level.INFO);
        out3 = new UtilPrint(Level.DEBUG);
        out4 = new UtilPrint(Level.DEBUG);
        out5 = new UtilPrint(Level.DEBUG);
        if (_UseDb) {
            this.read_env();
        }
        POA pOA = null;
        try {
            ApiUtil.set_in_server(true);
            this.orb = ApiUtil.get_orb();
            pOA = POAHelper.narrow(this.orb.resolve_initial_references("RootPOA"));
        }
        catch (InvalidName invalidName) {
            System.err.println("Can't intialise CORBA ORB !!!");
            System.err.println("Failed when trying to get root POA reference");
            System.exit(-1);
        }
        catch (DevFailed devFailed) {
            System.err.println("Can't intialise CORBA ORB !!!");
            System.err.println("Failed when trying to get root POA reference");
            System.exit(-1);
        }
        POA pOA2 = null;
        try {
            if (!_UseDb) {
                IdAssignmentPolicy idAssignmentPolicy = pOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID);
                Policy[] policyArray = new Policy[]{idAssignmentPolicy, pOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT)};
                POAManager pOAManager = pOA.the_POAManager();
                pOA2 = pOA.create_POA("nodb_poa", pOAManager, policyArray);
            }
        }
        catch (AdapterAlreadyExists adapterAlreadyExists) {
            System.err.println("Can't create CORBA POA !!!");
            System.err.println("POA already exists");
            System.exit(-1);
        }
        catch (InvalidPolicy invalidPolicy) {
            System.err.println("Can't create CORBA POA !!!");
            System.err.println("Invalid policy");
            System.exit(-1);
        }
        this._poa = _UseDb ? pOA : pOA2;
        if (_UseDb) {
            this.connect_db();
        }
        Logging.init(this.ds_name.toString(), _tracelevel, this.db);
        if (_UseDb) {
            this.server_already_running();
        }
        this.ext = new UtilExt();
        this.ext.poll_th = new PollThread(this.ext.shared_data, this.ext.poll_mon);
        this.ext.poll_th.start();
        this.misc_init();
        out4.println("Util object singleton constructed");
    }

    private void check_args(String[] stringArray) {
        if (stringArray[0].charAt(0) == '-') {
            if (stringArray[0].equals("-?")) {
                this.print_usage();
                this.printInstanceNames();
                System.exit(0);
            } else {
                this.print_usage();
                System.exit(-1);
            }
        }
        this.ds_instance_name = stringArray[0];
        if (stringArray.length > 1) {
            int n = 1;
            block7: while (n < stringArray.length) {
                if (stringArray[n].charAt(0) == '-') {
                    switch (stringArray[n].charAt(1)) {
                        case 'v': {
                            if (stringArray[n].length() == 2) {
                                if (stringArray.length - 1 > n) {
                                    if (stringArray[n + 1].charAt(0) == '-') {
                                        this.set_trace_level(4);
                                    } else {
                                        this.print_usage();
                                        System.exit(-1);
                                    }
                                } else {
                                    this.set_trace_level(4);
                                }
                                ++n;
                                continue block7;
                            }
                            String string = stringArray[n].substring(2);
                            int n2 = 0;
                            try {
                                n2 = Integer.parseInt(string);
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.print_usage();
                                System.exit(-1);
                            }
                            this.set_trace_level(n2);
                            ++n;
                            continue block7;
                        }
                        case 'n': {
                            if (!stringArray[n].equals("-nodb")) {
                                this.print_usage();
                                System.exit(-1);
                                continue block7;
                            }
                            _UseDb = false;
                            ++n;
                            continue block7;
                        }
                        case 'd': {
                            int n3;
                            String string;
                            if (!stringArray[n].equals("-dlist")) {
                                this.print_usage();
                                System.exit(-1);
                                continue block7;
                            }
                            if (_UseDb) {
                                this.print_usage();
                                System.exit(-1);
                            }
                            if (++n == stringArray.length) {
                                this.print_usage();
                                System.exit(-1);
                                continue block7;
                            }
                            String string2 = stringArray[n].toLowerCase();
                            int n2 = 0;
                            while ((n3 = string2.indexOf(44, n2)) != -1) {
                                string = string2.substring(n2, n3);
                                n2 = n3 + 1;
                                this.cmd_line_name_list.addElement(string);
                            }
                            if (n2 != string2.length()) {
                                string = string2.substring(n2);
                                this.cmd_line_name_list.addElement(string);
                            }
                            for (int i = 0; i < this.cmd_line_name_list.size(); ++i) {
                                for (int j = 0; j < this.cmd_line_name_list.size(); ++j) {
                                    if (i == j || !this.cmd_line_name_list.elementAt(i).equals(this.cmd_line_name_list.elementAt(j))) continue;
                                    System.err.println("Each device name must have different name");
                                    System.exit(-1);
                                }
                            }
                            continue block7;
                        }
                    }
                    ++n;
                    continue;
                }
                if (stringArray[n - 1].substring(0, 2).equals("-v")) {
                    this.print_usage();
                    System.exit(-1);
                }
                ++n;
            }
        }
        this.real_server_name = this.ds_exec_name + "/" + this.ds_instance_name;
        this.ds_exec_name = this.ds_exec_name.toLowerCase();
        this.ds_instance_name = this.ds_instance_name.toLowerCase();
        this.ds_name = new StringBuffer(this.ds_exec_name);
        this.ds_name.append("/");
        this.ds_name.append(this.ds_instance_name);
        if (this.ds_name.length() > 255) {
            System.err.println("The device server name is too long! Max length is 255 characters.");
            System.exit(-1);
        }
    }

    private void print_usage() {
        System.err.print("usage : java -DTANGO_HOST=$TANGO_HOST " + this.ds_exec_name + " instance_name [-v[trace level]]");
        System.err.println(" [-nodb [-dlist <device name list>]]");
    }

    private void printInstanceNames() {
        try {
            String[] stringArray;
            System.out.println("Instance name defined in database for server PowerSupply :");
            for (String string : stringArray = ApiUtil.get_db_obj().get_instance_name_list(this.ds_exec_name)) {
                System.out.println("\t" + string);
            }
        }
        catch (DevFailed devFailed) {
            Except.print_exception(devFailed);
        }
    }

    private void read_env() {
        try {
            String string = System.getProperty("TANGO_HOST");
            if (string == null && (string = System.getenv("TANGO_HOST")) == null) {
                Except.throw_connection_failed("TangoApi_TANGO_HOST_NOT_SET", "Property \"TANGO_HOST\" not exported", "TangoDs.Util.read_env()");
            }
            assert (string != null);
            if (string.indexOf(":") < 0) {
                Except.throw_connection_failed("TangoApi_TANGO_HOST_NOT_SET", "Unknown \"TANGO_HOST\" property " + string, "TangoDs.Util.read_env()");
            }
            String[] stringArray = ApiUtil.parseTangoHost(string);
            this.db_host = stringArray[0];
        }
        catch (DevFailed devFailed) {
            Except.print_exception(devFailed);
            System.exit(-1);
        }
    }

    private void misc_init() {
        this.pid_str = String.valueOf(0);
        try {
            String string = InetAddress.getLocalHost().toString();
            int n = string.indexOf(47);
            String string2 = string.substring(0, n);
            n = string2.indexOf(46);
            this.hostname = n == -1 ? string2 : string2.substring(0, n);
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Cant retrieve server host name");
            System.exit(1);
        }
        out4.println("Hostname = " + this.hostname);
        this.version_str = String.valueOf(2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void connect_db() {
        if (!_daemon) {
            try {
                this.db = ApiUtil.get_db_obj();
                if (this.db == null) {
                    System.err.println("Can't build connection to TANGO database server, exiting");
                    System.err.println("DB server host = " + this.db_host);
                    System.exit(-1);
                }
            }
            catch (Exception exception) {
                System.err.println("Can't build connection to TANGO database server, exiting");
                System.err.println("DB server host = " + this.db_host);
                System.exit(-1);
            }
        } else {
            boolean bl = false;
            while (!bl) {
                try {
                    this.db = ApiUtil.get_db_obj();
                    if (this.db == null) {
                        out4.println("Can't contact db server, will try later");
                        try {
                            this.wait(_sleep_between_connect * 1000);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    bl = true;
                }
                catch (Exception exception) {
                    out4.println("Can't contact db server, will try later");
                    try {
                        this.wait(_sleep_between_connect * 1000);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        out4.println("Connected to database");
    }

    private synchronized void server_already_running() {
        java.lang.Object object;
        out4.println("Entering Tango::server_already_running method");
        Random random = new Random();
        int n = random.nextInt(1000);
        out4.println("Waiting " + n + " ms....");
        try {
            this.wait(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        StringBuffer stringBuffer = new StringBuffer("dserver");
        stringBuffer.append('/');
        stringBuffer.append(this.ds_name);
        String string = new String(stringBuffer);
        DeviceOperations deviceOperations = null;
        try {
            object = this.db.import_device(string);
            out4.println("db.import_device(" + string + ");    DONE ");
            out4.println("db_dev.exported ==" + ((DbDevImportInfo)object).exported);
            if (!((DbDevImportInfo)object).exported) {
                out4.println("Leaving Tango::server_already_running method");
                return;
            }
            Object object2 = this.orb.string_to_object(((DbDevImportInfo)object).ior);
            out4.println("orb.string_to_object(db_dev.ior);    DONE ");
            deviceOperations = DeviceHelper.narrow(object2);
            out4.println("dev = DeviceHelper.narrow(obj);    DONE ");
        }
        catch (DevFailed devFailed) {
            if (devFailed.errors[0].reason.equals("DB_DeviceNotDefined")) {
                System.err.println("This device server is not defined in database. Exiting!");
                System.exit(-1);
            }
        }
        catch (TIMEOUT tIMEOUT) {
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            System.err.println("Can't pack/unpack data sent to/from database in/to Any object");
            System.exit(-1);
        }
        catch (TRANSIENT tRANSIENT) {
            out4.println("Leaving Tango::server_already_running method");
            return;
        }
        catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
            out4.println("Leaving Tango::server_already_running method");
            return;
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            out4.println("Leaving Tango::server_already_running method");
            return;
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
            System.exit(-1);
        }
        if (deviceOperations == null) {
            out4.println("Leaving Tango::server_already_running method");
            return;
        }
        try {
            object = deviceOperations.name();
            if (((String)object).equals(string)) {
                System.err.println("This server is already running, exiting!");
                System.exit(-1);
            }
        }
        catch (NO_RESPONSE nO_RESPONSE) {
            System.err.println("This server is already running but is blocked!");
            System.exit(-1);
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        out4.println("Leaving Tango::server_already_running method");
    }

    public void server_init() throws DevFailed {
        DServerClass.init();
        this.polling_configure();
    }

    public void server_run() {
        this.orb.run();
    }

    public Vector get_device_list(String string) {
        java.lang.Object object;
        Vector<java.lang.Object> vector = new Vector<java.lang.Object>();
        if (string.indexOf(42) == -1) {
            object = null;
            try {
                object = this.get_device_by_name(string);
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
            if (object != null) {
                vector.add(object);
                return vector;
            }
        }
        object = this.get_class_list();
        if (string.equals("*")) {
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                Vector vector2 = ((DeviceClass)((Vector)object).elementAt(i)).get_device_list();
                for (java.lang.Object e : vector2) {
                    DeviceImpl deviceImpl = (DeviceImpl)e;
                    vector.add(deviceImpl);
                }
            }
            return vector;
        }
        Iterator iterator = ((Vector)object).iterator();
        string = string.replace('*', '.');
        Pattern pattern = Pattern.compile(string);
        while (iterator.hasNext()) {
            Vector vector3 = ((DeviceClass)iterator.next()).get_device_list();
            for (DeviceImpl deviceImpl : vector3) {
                String string2 = deviceImpl.get_name().toLowerCase();
                if (!pattern.matcher(string2).matches()) continue;
                vector.add(deviceImpl);
            }
        }
        return vector;
    }

    public Vector get_device_list_by_class(String string) throws DevFailed {
        int n;
        Vector vector = this.class_list;
        int n2 = vector.size();
        for (n = 0; n < n2 && !((DeviceClass)vector.elementAt(n)).get_name().equals(string); ++n) {
        }
        if (n == n2) {
            StringBuffer stringBuffer = new StringBuffer("Class ");
            stringBuffer.append(string);
            stringBuffer.append(" not found");
            Except.throw_exception("API_ClassNotFound", stringBuffer.toString(), "Util::get_device_list_by_class()");
        }
        return ((DeviceClass)vector.elementAt(n)).get_device_list();
    }

    public DeviceImpl get_device_by_name(String string) throws DevFailed {
        java.lang.Object object;
        String string2;
        int n;
        Vector vector = this.class_list;
        string = string.toLowerCase();
        Vector vector2 = this.get_device_list_by_class(((DeviceClass)vector.elementAt(0)).get_name());
        int n2 = vector.size();
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        for (n = 0; n < n2; ++n) {
            vector2 = this.get_device_list_by_class(((DeviceClass)vector.elementAt(n)).get_name());
            n3 = vector2.size();
            for (n4 = 0; n4 < n3; ++n4) {
                if (!((DeviceImpl)vector2.elementAt(n4)).get_name().toLowerCase().equals(string)) continue;
                bl = true;
                break;
            }
            if (bl) break;
        }
        if (!bl && (string2 = ((DeviceImpl)(vector2 = ((DeviceClass)(object = DServerClass.instance())).get_device_list()).elementAt(0)).get_name()).compareToIgnoreCase(string) == 0) {
            n4 = 0;
        }
        if (n == n2 && n4 == n3) {
            object = new StringBuffer("Device ");
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append(" not found");
            Except.throw_exception("API_DeviceNotFound", ((StringBuffer)object).toString(), "Util::get_device_by_name()");
        }
        return (DeviceImpl)vector2.elementAt(n4);
    }

    public DServer get_dserver_device() {
        return (DServer)DServerClass.instance().get_device_list().elementAt(0);
    }

    public void unregister_server() {
        out4.println("Entering Tango::unregister_server method");
        if (_UseDb) {
            try {
                this.db.unexport_server(this.ds_name.toString());
            }
            catch (SystemException systemException) {
                Except.print_exception(systemException);
                System.exit(-1);
            }
            catch (DevFailed devFailed) {
                Except.print_exception(devFailed);
                System.exit(-1);
            }
            catch (UserException userException) {
                Except.print_exception(userException);
                System.exit(-1);
            }
        }
        out4.println("Leaving Tango::unregister_server method");
    }

    public static Any return_empty_any(String string) throws DevFailed {
        Any any = null;
        try {
            any = Util.instance().get_orb().create_any();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(".execute");
            out3.println("Bad allocation while in " + string + ".execute()");
            Except.throw_exception("API_MemoryAllocation", "Can't allocate memory in server", stringBuffer.toString());
        }
        out4.println("Leaving " + string + ".execute()");
        return any;
    }

    public void set_trace_level(int n) {
        _tracelevel = n;
    }

    public int get_trace_level() {
        return _tracelevel;
    }

    public String get_ds_inst_name() {
        return this.ds_instance_name;
    }

    public String get_ds_exec_name() {
        return this.ds_exec_name;
    }

    public String get_ds_name() {
        return new String(this.ds_name);
    }

    public String get_ds_real_name() {
        return this.real_server_name;
    }

    public String get_host_name() {
        return this.hostname;
    }

    public String get_version_str() {
        return this.version_str;
    }

    public Database get_database() {
        return this.db;
    }

    public ORB get_orb() {
        return this.orb;
    }

    public POA get_poa() {
        return this._poa;
    }

    public String get_pid_str() {
        return this.pid_str;
    }

    public void set_class_list(Vector vector) {
        this.class_list = vector;
    }

    Vector get_class_list() {
        return this.class_list;
    }

    Vector get_cmd_line_name_list() {
        return this.cmd_line_name_list;
    }

    public void add_class(String string) {
        this.class_name_list.addElement(string);
    }

    public Vector get_class_name_list() {
        return this.class_name_list;
    }

    void registerDeviceForJacorb(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        String[] stringArray = new String[3];
        for (int i = 0; i < 3 && stringTokenizer.countTokens() > 0; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        String string2 = "StandardImplName/nodb_poa/" + stringArray[0] + "&%25" + stringArray[1] + "&%25" + stringArray[2];
        org.jacorb.orb.ORB oRB = (org.jacorb.orb.ORB)this.orb;
        oRB.addObjectKey(string, string2);
    }

    public static double fabs(double d) {
        if (d >= 0.0) {
            return d;
        }
        return -1.0 * d;
    }

    void polling_configure() {
        DServer dServer = this.get_dserver_device();
        try {
            dServer.stop_polling();
        }
        catch (DevFailed devFailed) {
            Except.print_exception(devFailed);
        }
        Vector vector = dServer.get_class_list();
        DevVarLongStringArray devVarLongStringArray = new DevVarLongStringArray();
        devVarLongStringArray.lvalue = new int[1];
        devVarLongStringArray.svalue = new String[3];
        for (int i = 0; i < vector.size(); ++i) {
            DeviceClass deviceClass = (DeviceClass)vector.elementAt(i);
            Vector vector2 = deviceClass.get_device_list();
            for (int j = 0; j < vector2.size(); ++j) {
                String string;
                int n;
                int n2;
                DeviceImpl deviceImpl = (DeviceImpl)vector2.elementAt(j);
                Vector vector3 = deviceImpl.get_polled_cmd();
                Vector vector4 = deviceImpl.get_polled_attr();
                for (n2 = 0; n2 < vector3.size(); ++n2) {
                    if (n2 == 0) {
                        devVarLongStringArray.svalue[0] = deviceImpl.get_name();
                        devVarLongStringArray.svalue[1] = "command";
                    }
                    if ((n = Integer.parseInt(string = (String)vector3.elementAt(n2 + 1))) != 0) {
                        devVarLongStringArray.lvalue[0] = n;
                        devVarLongStringArray.svalue[2] = (String)vector3.elementAt(n2);
                        try {
                            dServer.add_obj_polling(devVarLongStringArray, false);
                        }
                        catch (DevFailed devFailed) {
                            // empty catch block
                        }
                    }
                    ++n2;
                }
                for (n2 = 0; n2 < vector4.size(); ++n2) {
                    if (n2 == 0) {
                        devVarLongStringArray.svalue[0] = deviceImpl.get_name();
                        devVarLongStringArray.svalue[1] = "attribute";
                    }
                    if ((n = Integer.parseInt(string = (String)vector4.elementAt(n2 + 1))) != 0) {
                        devVarLongStringArray.lvalue[0] = n;
                        devVarLongStringArray.svalue[2] = (String)vector4.elementAt(n2);
                        try {
                            dServer.add_obj_polling(devVarLongStringArray, false);
                        }
                        catch (DevFailed devFailed) {
                            // empty catch block
                        }
                    }
                    ++n2;
                }
            }
        }
        try {
            dServer.start_polling();
        }
        catch (DevFailed devFailed) {
            Except.print_exception(devFailed);
        }
    }

    PollThCmd get_poll_shared_cmd() {
        return this.ext.shared_data;
    }

    TangoMonitor get_poll_monitor() {
        return this.ext.poll_mon;
    }

    void poll_status(boolean bl) {
        this.ext.poll_on = bl;
    }

    boolean poll_status() {
        return this.ext.poll_on;
    }

    void trigger_attr_polling(DeviceImpl deviceImpl, String string) throws DevFailed {
        String string2;
        PollObj pollObj;
        long l;
        out4.println("Sending trigger to polling thread");
        if (!deviceImpl.is_polled()) {
            Except.throw_exception("API_DeviceNotPolled", "Device " + deviceImpl.get_name() + " is not polled", "Util.trigger_attr_polling");
        }
        if ((l = (long)(pollObj = deviceImpl.get_polled_obj_by_type_name(1, string2 = string.toLowerCase())).get_upd()) != 0L) {
            Except.throw_exception("API_NotSupported", "Polling for attribute " + string + " (device " + deviceImpl.get_name() + ")  is not externally triggered.", "Util.trigger_attr_polling");
        }
        TangoMonitor tangoMonitor = this.get_poll_monitor();
        PollThCmd pollThCmd = this.get_poll_shared_cmd();
        tangoMonitor.get_monitor();
        if (pollThCmd.trigger) {
            try {
                tangoMonitor.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        pollThCmd.trigger = true;
        pollThCmd.dev = deviceImpl;
        pollThCmd.name = string2;
        pollThCmd.type = 1;
        tangoMonitor.signal();
        out4.println("Trigger sent to polling thread");
        deviceImpl.get_dev_monitor();
        while (pollThCmd.trigger) {
            boolean bl = tangoMonitor.wait_it(3000L);
            if (!pollThCmd.trigger || bl) continue;
            out4.println("TIME OUT");
            Except.throw_exception("API_CommandTimedOut", "Polling thread blocked !!!", "Util.trigger_attr_polling");
        }
        tangoMonitor.rel_monitor();
        out4.println("Thread cmd normally executed");
    }

    public void fill_attr_polling_buffer(DeviceImpl deviceImpl, String string, TimedAttrData[] timedAttrDataArray) throws DevFailed {
        java.lang.Object object;
        int n;
        int n2;
        if (!deviceImpl.is_polled()) {
            Except.throw_exception("API_DeviceNotPolled", "Device " + deviceImpl.get_name() + " is not polled", "Util.fill_attr_polling_buffer()");
        }
        String string2 = string.toLowerCase();
        deviceImpl.get_polled_obj_by_type_name(1, string2);
        Attribute attribute = deviceImpl.get_device_attr().get_attr_by_name(string);
        AttrWriteType attrWriteType = attribute.get_writable();
        if (attrWriteType != AttrWriteType.READ) {
            String string3 = "Attribute " + string + " of device " + deviceImpl.get_name() + " is not READ only";
            Except.throw_exception("API_DeviceNotPolled", string3, "Util.fill_attr_polling_buffer()");
        }
        if ((n2 = timedAttrDataArray.length) > (n = deviceImpl.get_poll_ring_depth())) {
            object = "The polling buffer depth for attribute " + string + " for device " + deviceImpl.get_name() + " is only " + n + " which is less than " + n2 + " !";
            Except.throw_exception("API_DeviceNotPolled", (String)object, "Util.fill_attr_polling_buffer()");
        }
        object = null;
        AttributeValue attributeValue = null;
        TimeVal timeVal = new TimeVal(0, 0, 0);
        for (int i = 0; i < n2; ++i) {
            java.lang.Object object2;
            boolean bl = false;
            if (timedAttrDataArray[i].err != null && timedAttrDataArray[i].err.length > 0) {
                bl = true;
                object = new DevFailed(timedAttrDataArray[i].err);
            } else {
                attributeValue = new AttributeValue();
                attributeValue.time = new TimeVal(0, 0, 0);
                attributeValue.time.tv_sec = timedAttrDataArray[i].t_val.tv_sec;
                attributeValue.time.tv_usec = timedAttrDataArray[i].t_val.tv_usec;
                attributeValue.time.tv_nsec = 0;
                attributeValue.quality = timedAttrDataArray[i].qual;
                attributeValue.name = string;
                attributeValue.dim_x = 0;
                attributeValue.dim_y = 0;
                if (timedAttrDataArray[i].qual == AttrQuality.ATTR_VALID || timedAttrDataArray[i].qual == AttrQuality.ATTR_ALARM || timedAttrDataArray[i].qual == AttrQuality.ATTR_CHANGING) {
                    attribute.wanted_date(false);
                    attribute.set_date(timedAttrDataArray[i].t_val);
                    attribute.set_quality(timedAttrDataArray[i].qual);
                    object2 = ApiUtil.get_orb().create_any();
                    switch (attribute.get_data_type()) {
                        case 1: {
                            attribute.set_value(timedAttrDataArray[i].bool_ptr, timedAttrDataArray[i].x, timedAttrDataArray[i].y);
                            DevVarBooleanArrayHelper.insert((Any)object2, attribute.get_boolean_value());
                            break;
                        }
                        case 2: {
                            attribute.set_value(timedAttrDataArray[i].sh_ptr, timedAttrDataArray[i].x, timedAttrDataArray[i].y);
                            DevVarShortArrayHelper.insert((Any)object2, attribute.get_short_value());
                            break;
                        }
                        case 3: {
                            attribute.set_value(timedAttrDataArray[i].lg_ptr, timedAttrDataArray[i].x, timedAttrDataArray[i].y);
                            DevVarLongArrayHelper.insert((Any)object2, attribute.get_long_value());
                            break;
                        }
                        case 23: {
                            attribute.set_value(timedAttrDataArray[i].lg64_ptr, timedAttrDataArray[i].x, timedAttrDataArray[i].y);
                            DevVarLong64ArrayHelper.insert((Any)object2, attribute.get_long64_value());
                            break;
                        }
                        case 4: {
                            attribute.set_value(timedAttrDataArray[i].fl_ptr, timedAttrDataArray[i].x, timedAttrDataArray[i].y);
                            DevVarFloatArrayHelper.insert((Any)object2, attribute.get_float_value());
                            break;
                        }
                        case 5: {
                            attribute.set_value(timedAttrDataArray[i].db_ptr, timedAttrDataArray[i].x, timedAttrDataArray[i].y);
                            DevVarDoubleArrayHelper.insert((Any)object2, attribute.get_double_value());
                            break;
                        }
                        case 8: {
                            attribute.set_value(timedAttrDataArray[i].str_ptr, timedAttrDataArray[i].x, timedAttrDataArray[i].y);
                            DevVarStringArrayHelper.insert((Any)object2, attribute.get_string_value());
                            break;
                        }
                        default: {
                            Except.throw_exception("Api_DataTypeNotSupported", "att.get_data_type() returns " + attribute.get_data_type() + "\nType NOT supported", "Util.fill_attr_polling_buffer()");
                        }
                    }
                    attributeValue.value = object2;
                    attributeValue.dim_x = timedAttrDataArray[i].x;
                    attributeValue.dim_y = timedAttrDataArray[i].y;
                }
            }
            try {
                this.get_poll_monitor().get_monitor();
                object2 = deviceImpl.get_polled_obj_by_type_name(1, string2);
                TimeVal timeVal2 = new TimeVal(0, 0, 0);
                if (!bl) {
                    timeVal2.tv_sec = attributeValue.time.tv_sec - 1002000000;
                    timeVal2.tv_usec = attributeValue.time.tv_usec;
                    ((PollObj)object2).insert_data(attributeValue, timeVal2, timeVal);
                } else {
                    timeVal2.tv_sec = timedAttrDataArray[i].t_val.tv_sec - 1002000000;
                    timeVal2.tv_usec = timedAttrDataArray[i].t_val.tv_usec;
                    ((PollObj)object2).insert_except((DevFailed)object, timeVal2, timeVal);
                }
                this.get_poll_monitor().rel_monitor();
                continue;
            }
            catch (DevFailed devFailed) {
                this.get_poll_monitor().rel_monitor();
            }
        }
    }

    static int getPoaThreadPoolMax() {
        if (!thread_pool_max_done) {
            String string = System.getProperty("jacorb.poa.thread_pool_max");
            try {
                int n = Integer.parseInt(string);
                if (n > 0) {
                    thread_pool_max = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            thread_pool_max_done = true;
        }
        return thread_pool_max;
    }

    public static void set_serial_model(int n) {
        serial_model = n;
    }

    public static int get_serial_model() {
        return serial_model;
    }

    static synchronized void increaseAccessConter() {
        ++access_counter;
    }

    static synchronized void decreaseAccessConter() {
        --access_counter;
    }

    static synchronized int getAccessConter() {
        return access_counter;
    }

    static {
        _UseDb = true;
        _daemon = false;
        _sleep_between_connect = 10;
        serial_model = 0;
        thread_pool_max = 20;
        thread_pool_max_done = false;
        access_counter = 0;
    }

    class UtilExt {
        Vector cmd_line_name_list;
        PollThread poll_th;
        PollThCmd shared_data = new PollThCmd();
        TangoMonitor poll_mon;
        boolean poll_on;

        UtilExt() {
            this.shared_data.cmd_pending = false;
            this.poll_mon = new TangoMonitor();
        }
    }
}

