/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.BlackBoxElt;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

class BlackBox
implements TangoConst {
    private BlackBoxElt[] box;
    private int insert_elt;
    private int nb_elt;
    private int max_elt;
    private StringBuffer elt_str;

    public BlackBox() {
        this.box = new BlackBoxElt[25];
        for (int i = 0; i < 25; ++i) {
            this.box[i] = new BlackBoxElt();
        }
        this.insert_elt = 0;
        this.nb_elt = 0;
        this.max_elt = 25;
    }

    public BlackBox(int n) {
        this.box = new BlackBoxElt[n];
        for (int i = 0; i < n; ++i) {
            this.box[i] = new BlackBoxElt();
        }
        this.insert_elt = 0;
        this.nb_elt = 0;
        this.max_elt = n;
    }

    public synchronized void insert_attr(int n) {
        this.box[this.insert_elt].req_type = 2;
        this.box[this.insert_elt].attr_type = n;
        this.box[this.insert_elt].op_type = 0;
        this.box[this.insert_elt].when = new Date();
        this.get_client_host();
        this.inc_indexes();
    }

    public synchronized void insert_attr(int n, String string) {
        this.box[this.insert_elt].req_type = 2;
        this.box[this.insert_elt].attr_type = n;
        this.box[this.insert_elt].op_type = 0;
        this.box[this.insert_elt].host = string;
        this.box[this.insert_elt].when = new Date();
        this.inc_indexes();
    }

    public synchronized void insert_cmd(String string, int n) {
        this.box[this.insert_elt].req_type = 1;
        this.box[this.insert_elt].attr_type = 0;
        this.box[this.insert_elt].op_type = n == 2 ? 11 : 1;
        this.box[this.insert_elt].cmd_name = string;
        this.box[this.insert_elt].when = new Date();
        this.get_client_host();
        this.inc_indexes();
    }

    public synchronized void insert_cmd(String string, String string2) {
        this.box[this.insert_elt].req_type = 1;
        this.box[this.insert_elt].attr_type = 0;
        this.box[this.insert_elt].op_type = 1;
        this.box[this.insert_elt].cmd_name = string;
        this.box[this.insert_elt].host = string2;
        this.box[this.insert_elt].when = new Date();
        this.inc_indexes();
    }

    public synchronized void insert_op(int n) {
        this.box[this.insert_elt].req_type = 1;
        this.box[this.insert_elt].attr_type = 0;
        this.box[this.insert_elt].op_type = n;
        this.box[this.insert_elt].when = new Date();
        this.get_client_host();
        this.inc_indexes();
    }

    public synchronized void insert_op(int n, String string) {
        this.box[this.insert_elt].req_type = 1;
        this.box[this.insert_elt].attr_type = 0;
        this.box[this.insert_elt].op_type = n;
        this.box[this.insert_elt].host = string;
        this.box[this.insert_elt].when = new Date();
        this.inc_indexes();
    }

    private void inc_indexes() {
        ++this.insert_elt;
        if (this.insert_elt == this.max_elt) {
            this.insert_elt = 0;
        }
        if (this.nb_elt != this.max_elt) {
            ++this.nb_elt;
        }
    }

    private void get_client_host() {
    }

    private void build_info_as_str(int n) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss:SS");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("ECT"));
        String string = simpleDateFormat.format(this.box[n].when);
        this.elt_str = new StringBuffer(string);
        this.elt_str.append(" : ");
        if (this.box[n].req_type == 1) {
            this.elt_str.append("Operation ");
            switch (this.box[n].op_type) {
                case 1: {
                    this.elt_str.append("command_inout (cmd = ");
                    this.elt_str.append(this.box[n].cmd_name);
                    this.elt_str.append(") ");
                    break;
                }
                case 3: {
                    this.elt_str.append("ping ");
                    break;
                }
                case 4: {
                    this.elt_str.append("info ");
                    break;
                }
                case 2: {
                    this.elt_str.append("blackbox ");
                    break;
                }
                case 5: {
                    this.elt_str.append("command_list_query ");
                    break;
                }
                case 6: {
                    this.elt_str.append("command_query ");
                    break;
                }
                case 7: {
                    this.elt_str.append("get_attribute_config ");
                    break;
                }
                case 8: {
                    this.elt_str.append("set_attribute_config ");
                    break;
                }
                case 9: {
                    this.elt_str.append("read_attributes ");
                    break;
                }
                case 10: {
                    this.elt_str.append("write_attributes ");
                    break;
                }
                case 11: {
                    this.elt_str.append("command_inout_2 (cmd = ").append(this.box[n].cmd_name).append(") ");
                    break;
                }
                case 12: {
                    this.elt_str.append("command_list_query_2 ");
                    break;
                }
                case 13: {
                    this.elt_str.append("command_query_2 ");
                    break;
                }
                case 14: {
                    this.elt_str.append("get_attribute_config_2 ");
                    break;
                }
                case 15: {
                    this.elt_str.append("read_attributes_2 ");
                    break;
                }
                case 16: {
                    this.elt_str.append("command_inout_history_2 ");
                    break;
                }
                case 17: {
                    this.elt_str.append("read_attribute_history_2");
                    break;
                }
                case 0: {
                    this.elt_str.append("unknown operation !!!!!");
                    return;
                }
            }
        } else if (this.box[n].req_type == 2) {
            this.elt_str.append("Attribute ");
            switch (this.box[n].attr_type) {
                case 1: {
                    this.elt_str.append("name ");
                    break;
                }
                case 2: {
                    this.elt_str.append("description ");
                    break;
                }
                case 4: {
                    this.elt_str.append("status ");
                    break;
                }
                case 3: {
                    this.elt_str.append("state ");
                    break;
                }
                case 5: {
                    this.elt_str.append("adm_name ");
                    break;
                }
                case 0: {
                    this.elt_str.append("unknown attribute !!!!!");
                    return;
                }
            }
        } else {
            this.elt_str.append("Unknown CORBA request type !!!!!");
            return;
        }
        if (!this.box[n].host.equals("Unknown")) {
            int[] nArray = new int[4];
            for (int i = 0; i < 4; ++i) {
                nArray[i] = this.box[n].host_ip[i] < 0 ? 255 + this.box[n].host_ip[i] + 1 : this.box[n].host_ip[i];
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nArray[0]);
            stringBuffer.append(".");
            stringBuffer.append(nArray[1]);
            stringBuffer.append(".");
            stringBuffer.append(nArray[2]);
            stringBuffer.append(".");
            stringBuffer.append(nArray[3]);
            this.elt_str.append("requested from ");
            try {
                InetAddress inetAddress = InetAddress.getByName(stringBuffer.toString());
                this.elt_str.append(inetAddress.getHostName());
            }
            catch (UnknownHostException unknownHostException) {
                this.elt_str.append(stringBuffer.toString());
            }
        }
    }

    public String[] read(int n) throws DevFailed {
        if (n <= 0) {
            Except.throw_exception("API_BlackBoxArgument", "Argument to read black box out of range", "BlackBox::read");
        }
        if (this.nb_elt == 0) {
            Except.throw_exception("API_BlackBoxEmpty", "Nothing stored yet in black-box", "BlackBox::read");
        }
        if (n > this.max_elt) {
            n = this.max_elt;
        }
        if (n > this.nb_elt) {
            n = this.nb_elt;
        }
        String[] stringArray = new String[n];
        int n2 = this.insert_elt == 0 ? this.max_elt - 1 : this.insert_elt - 1;
        for (int i = 0; i < n; ++i) {
            this.build_info_as_str(n2);
            stringArray[i] = new String(this.elt_str);
            if (--n2 >= 0) continue;
            n2 = this.max_elt - 1;
        }
        return stringArray;
    }
}

