/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.logviewer;

import fr.esrf.logviewer.EventDetails;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JCheckBox;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MyTableModel
extends AbstractTableModel {
    private static double freeMemoryThreshold = 10.0;
    private static double lastFreeMemory = 0.0;
    private static long nEventsThreshold = 50000L;
    private static final int filteredEventsUpdadetTimeThreshold = 100;
    private static final int pendingEventsThreshold = 4096;
    private static final double eventsPercent = 0.5;
    private static final Logger LOG = Logger.getLogger((Class)(class$fr$esrf$logviewer$MyTableModel == null ? (class$fr$esrf$logviewer$MyTableModel = MyTableModel.class$("fr.esrf.logviewer.MyTableModel")) : class$fr$esrf$logviewer$MyTableModel));
    private static final Comparator MY_COMP = new Comparator(){

        public int compare(Object object, Object object2) {
            if (object == null && object2 == null) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            EventDetails eventDetails = (EventDetails)object;
            EventDetails eventDetails2 = (EventDetails)object2;
            if (eventDetails.getTimeStamp() < eventDetails2.getTimeStamp()) {
                return 1;
            }
            return -1;
        }
    };
    private static final String[] COL_NAMES = new String[]{"Trace", "Time", "Level", "Source", "Message"};
    private static final EventDetails[] EMPTY_LIST = new EventDetails[0];
    private final Object mLock = new Object();
    private final SortedSet mAllEvents = new TreeSet(MY_COMP);
    private EventDetails[] mFilteredEvents = EMPTY_LIST;
    private final List mPendingEvents = new ArrayList();
    private boolean mPaused = false;
    private String mTimeStampFilter = "";
    private String mThreadFilter = "";
    private String mMessageFilter = "";
    private String mCategoryFilter = "";
    private Level mLevelFilter = Level.DEBUG;
    private final JCheckBox mTrue = new JCheckBox("", true);
    private final JCheckBox mFalse = new JCheckBox("", false);
    static /* synthetic */ Class class$fr$esrf$logviewer$MyTableModel;
    static /* synthetic */ Class class$java$lang$Object;

    public MyTableModel() {
        Thread thread = new Thread(new Processor());
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mFilteredEvents.length;
        }
    }

    public int getColumnCount() {
        return COL_NAMES.length;
    }

    public String getColumnName(int n) {
        return COL_NAMES[n];
    }

    public Class getColumnClass(int n) {
        return class$java$lang$Object == null ? (class$java$lang$Object = MyTableModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(int n, int n2) {
        Object object = this.mLock;
        synchronized (object) {
            EventDetails eventDetails = this.mFilteredEvents[n];
            if (n2 == 0) {
                return eventDetails.getThrowableStrRep() == null ? Boolean.FALSE : Boolean.TRUE;
            }
            if (n2 == 1) {
                return eventDetails.getRenderedTimeStamp();
            }
            if (n2 == 2) {
                return eventDetails.getLevel();
            }
            if (n2 == 3) {
                return eventDetails.getCategoryName();
            }
            return eventDetails.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLevelFilter(Level level) {
        Object object = this.mLock;
        synchronized (object) {
            this.mLevelFilter = level;
            this.updateFilteredEvents(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadFilter(String string) {
        Object object = this.mLock;
        synchronized (object) {
            this.mThreadFilter = string.trim();
            this.updateFilteredEvents(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageFilter(String string) {
        Object object = this.mLock;
        synchronized (object) {
            this.mMessageFilter = string.trim();
            this.updateFilteredEvents(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeStampFilter(String string) {
        Object object = this.mLock;
        synchronized (object) {
            this.mTimeStampFilter = string.trim();
            this.updateFilteredEvents(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCategoryFilter(String string) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCategoryFilter = string.trim();
            this.updateFilteredEvents(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(EventDetails eventDetails) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPendingEvents.add(eventDetails);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mLock;
        synchronized (object) {
            this.mAllEvents.clear();
            this.mFilteredEvents = new EventDetails[0];
            this.mPendingEvents.clear();
            this.fireTableDataChanged();
        }
    }

    public void clearOldEvents() {
        int n;
        int n2 = this.mAllEvents.size();
        LOG.debug((Object)("In clearOldEvents: #before:" + n2));
        int n3 = (int)((double)n2 * 0.5);
        if (n3 <= 0) {
            return;
        }
        int n4 = (int)(0.5 * (double)n2);
        LOG.debug((Object)("In clearOldEvents: #to-clear:" + n3));
        Iterator iterator = this.mAllEvents.iterator();
        int n5 = n2 - n3;
        for (n = 0; n < n5 && iterator.hasNext(); ++n) {
            iterator.next();
        }
        for (n = 0; n < n3 && iterator.hasNext(); ++n) {
            EventDetails eventDetails = (EventDetails)iterator.next();
            if (eventDetails.getLevel().isGreaterOrEqual((Priority)Level.WARN)) continue;
            iterator.remove();
        }
        LOG.debug((Object)("In clearOldEvents: #after:" + this.mAllEvents.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggle() {
        Object object = this.mLock;
        synchronized (object) {
            this.mPaused = !this.mPaused;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPaused() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPaused;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventDetails getEventDetails(int n) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mFilteredEvents[n];
        }
    }

    private long updateFilteredEvents(boolean bl) {
        EventDetails eventDetails;
        long l = System.currentTimeMillis();
        ArrayList<EventDetails> arrayList = new ArrayList<EventDetails>();
        int n = this.mAllEvents.size();
        Iterator iterator = this.mAllEvents.iterator();
        while (iterator.hasNext()) {
            eventDetails = (EventDetails)iterator.next();
            if (!this.matchFilter(eventDetails)) continue;
            arrayList.add(eventDetails);
        }
        eventDetails = this.mFilteredEvents.length == 0 ? null : this.mFilteredEvents[0];
        this.mFilteredEvents = arrayList.toArray(EMPTY_LIST);
        if (bl && eventDetails != null) {
            int n2 = arrayList.indexOf(eventDetails);
            if (n2 < 1) {
                LOG.warn((Object)"In strange state");
                this.fireTableDataChanged();
            } else {
                this.fireTableRowsInserted(0, n2 - 1);
            }
        } else {
            this.fireTableDataChanged();
        }
        long l2 = System.currentTimeMillis();
        LOG.debug((Object)("# logs: " + n));
        LOG.debug((Object)("Update time [ms]: " + (l2 - l)));
        return l2 - l;
    }

    private boolean matchFilter(EventDetails eventDetails) {
        if (eventDetails.getLevel().isGreaterOrEqual((Priority)this.mLevelFilter) && eventDetails.getCategoryName().indexOf(this.mCategoryFilter) >= 0 && eventDetails.getRenderedTimeStamp().indexOf(this.mTimeStampFilter) >= 0 && eventDetails.getThreadName().indexOf(this.mThreadFilter) >= 0) {
            String string = eventDetails.getMessage();
            if (string == null) {
                return this.mMessageFilter.length() == 0;
            }
            return string.indexOf(this.mMessageFilter) >= 0;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ EventDetails[] access$802(MyTableModel myTableModel, EventDetails[] eventDetailsArray) {
        myTableModel.mFilteredEvents = eventDetailsArray;
        return eventDetailsArray;
    }

    private class Processor
    implements Runnable {
        private long lastUpdateTime = 0L;

        private Processor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Object object = MyTableModel.this.mLock;
                synchronized (object) {
                    if (MyTableModel.this.mPaused && MyTableModel.this.mPendingEvents.size() < 4096) {
                        continue;
                    }
                    boolean bl = false;
                    Runtime runtime = Runtime.getRuntime();
                    double d = 100.0 * (double)runtime.freeMemory() / (double)runtime.totalMemory();
                    LOG.debug((Object)("Last free memory    [%]: " + lastFreeMemory));
                    LOG.debug((Object)("Current free memory [%]: " + d));
                    if (this.lastUpdateTime > 100L && (long)MyTableModel.this.mAllEvents.size() > nEventsThreshold || d - lastFreeMemory > 5.0 && d < freeMemoryThreshold) {
                        MyTableModel.this.clearOldEvents();
                        MyTableModel.access$802(MyTableModel.this, new EventDetails[0]);
                        Runtime.getRuntime().gc();
                        lastFreeMemory = 100.0 * (double)runtime.freeMemory() / (double)runtime.totalMemory();
                        bl = true;
                    } else {
                        lastFreeMemory = d;
                    }
                    Iterator iterator = MyTableModel.this.mPendingEvents.iterator();
                    boolean bl2 = true;
                    while (iterator.hasNext()) {
                        EventDetails eventDetails = (EventDetails)iterator.next();
                        MyTableModel.this.mAllEvents.add(eventDetails);
                        bl2 = bl2 && eventDetails == MyTableModel.this.mAllEvents.first();
                        bl = bl || MyTableModel.this.matchFilter(eventDetails);
                    }
                    MyTableModel.this.mPendingEvents.clear();
                    if (bl) {
                        this.lastUpdateTime = MyTableModel.this.updateFilteredEvents(bl2);
                    }
                }
            }
        }
    }
}

