/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDEllipse;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class JDEllipsePanel
extends JPanel
implements ActionListener,
ChangeListener {
    private JLabel startLabel;
    private JSpinner startSpinner;
    private JLabel extentLabel;
    private JSpinner extentSpinner;
    private JLabel stepLabel;
    private JSpinner stepSpinner;
    private JLabel arcTypeLabel;
    private JComboBox arcTypeCombo;
    private JDEllipse[] allObjects = null;
    private JDrawEditor invoker;
    private Rectangle oldRect;
    private boolean isUpdating = false;

    public JDEllipsePanel(JDEllipse[] jDEllipseArray, JDrawEditor jDrawEditor) {
        this.invoker = jDrawEditor;
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPreferredSize(new Dimension(380, 290));
        JPanel jPanel = new JPanel(null);
        jPanel.setBorder(JDUtils.createTitleBorder("Ellipse"));
        jPanel.setBounds(5, 5, 370, 120);
        this.startLabel = new JLabel("Angle start");
        this.startLabel.setFont(JDUtils.labelFont);
        this.startLabel.setForeground(JDUtils.labelColor);
        this.startLabel.setBounds(10, 20, 100, 25);
        jPanel.add(this.startLabel);
        this.startSpinner = new JSpinner();
        this.startSpinner.addChangeListener(this);
        this.startSpinner.setBounds(115, 20, 60, 25);
        jPanel.add(this.startSpinner);
        this.extentLabel = new JLabel("Angle extent");
        this.extentLabel.setFont(JDUtils.labelFont);
        this.extentLabel.setForeground(JDUtils.labelColor);
        this.extentLabel.setBounds(190, 20, 100, 25);
        jPanel.add(this.extentLabel);
        this.extentSpinner = new JSpinner();
        this.extentSpinner.addChangeListener(this);
        this.extentSpinner.setBounds(295, 20, 60, 25);
        jPanel.add(this.extentSpinner);
        this.stepLabel = new JLabel("Interpolation step");
        this.stepLabel.setFont(JDUtils.labelFont);
        this.stepLabel.setForeground(JDUtils.labelColor);
        this.stepLabel.setBounds(10, 50, 100, 25);
        jPanel.add(this.stepLabel);
        this.stepSpinner = new JSpinner();
        this.stepSpinner.addChangeListener(this);
        this.stepSpinner.setBounds(115, 50, 60, 25);
        jPanel.add(this.stepSpinner);
        this.arcTypeLabel = JDUtils.createLabel("Arc Type");
        this.arcTypeLabel.setBounds(10, 80, 90, 20);
        jPanel.add(this.arcTypeLabel);
        this.arcTypeCombo = new JComboBox();
        this.arcTypeCombo.setFont(JDUtils.labelFont);
        this.arcTypeCombo.addItem("Open");
        this.arcTypeCombo.addItem("Closed");
        this.arcTypeCombo.addItem("Pie");
        this.arcTypeCombo.addActionListener(this);
        this.arcTypeCombo.setBounds(115, 80, 60, 25);
        jPanel.add(this.arcTypeCombo);
        this.add(jPanel);
        this.updatePanel(jDEllipseArray);
    }

    public void updatePanel(JDEllipse[] jDEllipseArray) {
        this.allObjects = jDEllipseArray;
        this.isUpdating = true;
        if (jDEllipseArray == null || jDEllipseArray.length <= 0) {
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(0, 0, 0, 0);
            this.startSpinner.setModel(spinnerNumberModel);
            this.extentSpinner.setModel(spinnerNumberModel);
            this.stepSpinner.setModel(spinnerNumberModel);
            this.arcTypeCombo.setSelectedIndex(-1);
        } else {
            JDEllipse jDEllipse = jDEllipseArray[0];
            Integer n = new Integer(jDEllipse.getAngleStart());
            Integer n2 = new Integer(-360);
            Integer n3 = new Integer(360);
            Integer n4 = new Integer(1);
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(n, n2, n3, n4);
            this.startSpinner.setModel(spinnerNumberModel);
            n = new Integer(jDEllipse.getAngleExtent());
            n2 = new Integer(0);
            n3 = new Integer(360);
            n4 = new Integer(1);
            spinnerNumberModel = new SpinnerNumberModel(n, n2, n3, n4);
            this.extentSpinner.setModel(spinnerNumberModel);
            n = new Integer(jDEllipse.getStep());
            n2 = new Integer(1);
            n3 = new Integer(256);
            n4 = new Integer(1);
            spinnerNumberModel = new SpinnerNumberModel(n, n2, n3, n4);
            this.stepSpinner.setModel(spinnerNumberModel);
            this.arcTypeCombo.setSelectedIndex(jDEllipse.getArcType());
        }
        this.isUpdating = false;
    }

    private void initRepaint() {
        if (this.allObjects == null) {
            return;
        }
        this.oldRect = this.allObjects[0].getRepaintRect();
        for (int i = 1; i < this.allObjects.length; ++i) {
            this.oldRect = this.oldRect.union(this.allObjects[i].getRepaintRect());
        }
    }

    private void repaintObjects() {
        if (this.allObjects == null) {
            return;
        }
        Rectangle rectangle = this.allObjects[0].getRepaintRect();
        for (int i = 1; i < this.allObjects.length; ++i) {
            rectangle = rectangle.union(this.allObjects[i].getRepaintRect());
        }
        this.invoker.repaint(rectangle.union(this.oldRect));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.allObjects == null || this.isUpdating) {
            return;
        }
        this.initRepaint();
        Object object = actionEvent.getSource();
        if (object == this.arcTypeCombo) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setArcType(this.arcTypeCombo.getSelectedIndex());
            }
            this.invoker.setNeedToSave(true, "Change arc type");
        }
        this.repaintObjects();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.allObjects == null || this.isUpdating) {
            return;
        }
        this.initRepaint();
        Object object = changeEvent.getSource();
        if (object == this.stepSpinner) {
            Integer n = (Integer)this.stepSpinner.getValue();
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setStep(n);
            }
            this.invoker.setNeedToSave(true, "Change arc step");
        } else if (object == this.startSpinner) {
            Integer n = (Integer)this.startSpinner.getValue();
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setAngleStart(n);
            }
            this.invoker.setNeedToSave(true, "Change arc angle");
        } else if (object == this.extentSpinner) {
            Integer n = (Integer)this.extentSpinner.getValue();
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setAngleExtent(n);
            }
            this.invoker.setNeedToSave(true, "Change arc angle");
        }
        this.repaintObjects();
    }
}

