/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart;

import fr.esrf.tangoatk.widget.util.chart.GraphicsUtils;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AxisPanel
extends JPanel
implements ActionListener,
KeyListener {
    private JLAxis pAxis;
    private JLChart pChart;
    int type;
    private JPanel scalePanel;
    private JPanel settingPanel;
    private JLabel MinLabel;
    private JTextField MinText;
    private JLabel MaxLabel;
    private JTextField MaxText;
    private JCheckBox AutoScaleCheck;
    private JLabel ScaleLabel;
    private JComboBox ScaleCombo;
    private JCheckBox SubGridCheck;
    private JCheckBox VisibleCheck;
    private JCheckBox OppositeCheck;
    private JComboBox FormatCombo;
    private JLabel FormatLabel;
    private JLabel TitleLabel;
    private JTextField TitleText;
    private JLabel ColorLabel;
    private JLabel ColorView;
    private JButton ColorBtn;
    private JLabel PositionLabel;
    private JComboBox PositionCombo;
    public static final int Y1_TYPE = 1;
    public static final int Y2_TYPE = 2;
    public static final int X_TYPE = 3;

    public AxisPanel(JLAxis jLAxis, int n, JLChart jLChart) {
        this.pAxis = jLAxis;
        this.pChart = jLChart;
        this.type = n;
        this.setLayout(null);
        this.scalePanel = new JPanel();
        this.scalePanel.setLayout(null);
        this.scalePanel.setBorder(GraphicsUtils.createTitleBorder("Scale"));
        this.settingPanel = new JPanel();
        this.settingPanel.setLayout(null);
        this.settingPanel.setBorder(GraphicsUtils.createTitleBorder("Axis settings"));
        this.MinLabel = new JLabel("Min");
        this.MinLabel.setFont(GraphicsUtils.labelFont);
        this.MinText = new JTextField();
        this.MinLabel.setForeground(GraphicsUtils.fColor);
        this.MinLabel.setEnabled(!jLAxis.isAutoScale());
        this.MinText.setText(Double.toString(jLAxis.getMinimum()));
        this.MinText.setEditable(true);
        this.MinText.setEnabled(!jLAxis.isAutoScale());
        this.MinText.setMargin(GraphicsUtils.zInset);
        this.MinText.addKeyListener(this);
        this.MaxLabel = new JLabel("Max");
        this.MaxLabel.setFont(GraphicsUtils.labelFont);
        this.MaxText = new JTextField();
        this.MaxLabel.setForeground(GraphicsUtils.fColor);
        this.MaxLabel.setHorizontalAlignment(4);
        this.MaxLabel.setEnabled(!jLAxis.isAutoScale());
        this.MaxText.setText(Double.toString(jLAxis.getMaximum()));
        this.MaxText.setEditable(true);
        this.MaxText.setEnabled(!jLAxis.isAutoScale());
        this.MaxText.setMargin(GraphicsUtils.zInset);
        this.MaxText.addKeyListener(this);
        this.AutoScaleCheck = new JCheckBox("Auto scale");
        this.AutoScaleCheck.setFont(GraphicsUtils.labelFont);
        this.AutoScaleCheck.setForeground(GraphicsUtils.fColor);
        this.AutoScaleCheck.setSelected(jLAxis.isAutoScale());
        this.AutoScaleCheck.addActionListener(this);
        this.ScaleLabel = new JLabel("Mode");
        this.ScaleLabel.setFont(GraphicsUtils.labelFont);
        this.ScaleLabel.setForeground(GraphicsUtils.fColor);
        this.ScaleCombo = new JComboBox();
        this.ScaleCombo.setFont(GraphicsUtils.labelFont);
        this.ScaleCombo.addItem("Linear");
        this.ScaleCombo.addItem("Logarithmic");
        this.ScaleCombo.setSelectedIndex(jLAxis.getScale());
        this.ScaleCombo.addActionListener(this);
        this.SubGridCheck = new JCheckBox("Show sub grid");
        this.SubGridCheck.setFont(GraphicsUtils.labelFont);
        this.SubGridCheck.setForeground(GraphicsUtils.fColor);
        this.SubGridCheck.setSelected(jLAxis.isSubGridVisible());
        this.SubGridCheck.setToolTipText("You have to select the grid in the general option panel");
        this.SubGridCheck.addActionListener(this);
        this.VisibleCheck = new JCheckBox("Visible");
        this.VisibleCheck.setFont(GraphicsUtils.labelFont);
        this.VisibleCheck.setForeground(GraphicsUtils.fColor);
        this.VisibleCheck.setSelected(jLAxis.isVisible());
        this.VisibleCheck.setToolTipText("Display/Hide the axis");
        this.VisibleCheck.addActionListener(this);
        this.OppositeCheck = new JCheckBox("Draw opposite");
        this.OppositeCheck.setFont(GraphicsUtils.labelFont);
        this.OppositeCheck.setForeground(GraphicsUtils.fColor);
        this.OppositeCheck.setSelected(jLAxis.isDrawOpposite());
        this.OppositeCheck.setToolTipText("Dupplicate the axis at the opposite side");
        this.OppositeCheck.addActionListener(this);
        this.FormatCombo = new JComboBox();
        this.FormatCombo.setFont(GraphicsUtils.labelFont);
        this.FormatCombo.addItem("Automatic");
        this.FormatCombo.addItem("Scientific");
        this.FormatCombo.addItem("Time (hh:mm:ss)");
        this.FormatCombo.addItem("Decimal int");
        this.FormatCombo.addItem("Hexadecimal int");
        this.FormatCombo.addItem("Binary int");
        this.FormatCombo.addItem("Scientific int");
        this.FormatCombo.addItem("Date");
        this.FormatCombo.setSelectedIndex(jLAxis.getLabelFormat());
        this.FormatCombo.addActionListener(this);
        this.FormatLabel = new JLabel("Label format");
        this.FormatLabel.setFont(GraphicsUtils.labelFont);
        this.FormatLabel.setForeground(GraphicsUtils.fColor);
        this.TitleLabel = new JLabel("Title");
        this.TitleLabel.setFont(GraphicsUtils.labelFont);
        this.TitleLabel.setForeground(GraphicsUtils.fColor);
        this.TitleText = new JTextField();
        this.TitleText.setEditable(true);
        this.TitleText.setText(jLAxis.getName());
        this.TitleText.setMargin(GraphicsUtils.zInset);
        this.TitleText.addKeyListener(this);
        this.ColorLabel = new JLabel("Color");
        this.ColorLabel.setFont(GraphicsUtils.labelFont);
        this.ColorLabel.setForeground(GraphicsUtils.fColor);
        this.ColorView = new JLabel("");
        this.ColorView.setOpaque(true);
        this.ColorView.setBorder(BorderFactory.createLineBorder(Color.black));
        this.ColorView.setBackground(jLAxis.getAxisColor());
        this.ColorBtn = new JButton("...");
        this.ColorBtn.addActionListener(this);
        this.ColorBtn.setMargin(GraphicsUtils.zInset);
        this.PositionLabel = new JLabel("Position");
        this.PositionLabel.setFont(GraphicsUtils.labelFont);
        this.PositionLabel.setForeground(GraphicsUtils.fColor);
        this.PositionCombo = new JComboBox();
        this.PositionCombo.setFont(GraphicsUtils.labelFont);
        switch (this.type) {
            case 3: {
                this.PositionCombo.addItem("Down");
                this.PositionCombo.addItem("Up");
                this.PositionCombo.addItem("Y1 Origin");
                this.PositionCombo.addItem("Y2 Origin");
                this.PositionCombo.setSelectedIndex(jLAxis.getPosition() - 1);
                break;
            }
            case 1: {
                this.PositionCombo.addItem("Left");
                this.PositionCombo.addItem("X Origin");
                this.PositionCombo.setSelectedIndex(jLAxis.getPosition() == 7 ? 1 : 0);
                break;
            }
            case 2: {
                this.PositionCombo.addItem("Right");
                this.PositionCombo.addItem("X Origin");
                this.PositionCombo.setSelectedIndex(jLAxis.getPosition() == 7 ? 1 : 0);
            }
        }
        this.PositionCombo.addActionListener(this);
        this.scalePanel.add(this.MinLabel);
        this.scalePanel.add(this.MinText);
        this.scalePanel.add(this.MaxLabel);
        this.scalePanel.add(this.MaxText);
        this.scalePanel.add(this.AutoScaleCheck);
        this.scalePanel.add(this.ScaleLabel);
        this.scalePanel.add(this.ScaleCombo);
        this.add(this.scalePanel);
        this.settingPanel.add(this.SubGridCheck);
        this.settingPanel.add(this.OppositeCheck);
        this.settingPanel.add(this.VisibleCheck);
        this.settingPanel.add(this.FormatCombo);
        this.settingPanel.add(this.FormatLabel);
        this.settingPanel.add(this.TitleLabel);
        this.settingPanel.add(this.TitleText);
        this.settingPanel.add(this.ColorLabel);
        this.settingPanel.add(this.ColorView);
        this.settingPanel.add(this.ColorBtn);
        this.settingPanel.add(this.PositionLabel);
        this.settingPanel.add(this.PositionCombo);
        this.add(this.settingPanel);
        this.MinLabel.setBounds(10, 20, 35, 25);
        this.MinText.setBounds(50, 20, 90, 25);
        this.MaxLabel.setBounds(145, 20, 40, 25);
        this.MaxText.setBounds(190, 20, 90, 25);
        this.ScaleLabel.setBounds(10, 50, 100, 25);
        this.ScaleCombo.setBounds(115, 50, 165, 25);
        this.AutoScaleCheck.setBounds(5, 80, 275, 25);
        this.scalePanel.setBounds(5, 10, 290, 115);
        this.FormatLabel.setBounds(10, 20, 100, 25);
        this.FormatCombo.setBounds(115, 20, 165, 25);
        this.TitleLabel.setBounds(10, 50, 100, 25);
        this.TitleText.setBounds(115, 50, 165, 25);
        this.ColorLabel.setBounds(10, 80, 100, 25);
        this.ColorView.setBounds(115, 80, 130, 25);
        this.ColorBtn.setBounds(250, 80, 30, 25);
        this.PositionLabel.setBounds(10, 110, 100, 25);
        this.PositionCombo.setBounds(115, 110, 165, 25);
        this.SubGridCheck.setBounds(5, 140, 130, 25);
        this.OppositeCheck.setBounds(140, 140, 130, 25);
        this.VisibleCheck.setBounds(5, 170, 280, 25);
        this.settingPanel.setBounds(5, 130, 290, 205);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Color color;
        if (actionEvent.getSource() == this.AutoScaleCheck) {
            boolean bl = this.AutoScaleCheck.isSelected();
            this.pAxis.setAutoScale(bl);
            if (!bl) {
                try {
                    double d = Double.parseDouble(this.MinText.getText());
                    double d2 = Double.parseDouble(this.MaxText.getText());
                    if (d2 > d) {
                        this.pAxis.setMinimum(d);
                        this.pAxis.setMaximum(d2);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.MinLabel.setEnabled(!bl);
            this.MinText.setEnabled(!bl);
            this.MaxLabel.setEnabled(!bl);
            this.MaxText.setEnabled(!bl);
            this.Commit();
        } else if (actionEvent.getSource() == this.FormatCombo) {
            int n = this.FormatCombo.getSelectedIndex();
            this.pAxis.setLabelFormat(n);
            this.Commit();
        } else if (actionEvent.getSource() == this.PositionCombo) {
            int n = this.PositionCombo.getSelectedIndex();
            block1 : switch (this.type) {
                case 3: {
                    this.pAxis.setPosition(n + 1);
                    break;
                }
                case 1: {
                    switch (n) {
                        case 0: {
                            this.pAxis.setPosition(6);
                            break;
                        }
                        case 1: {
                            this.pAxis.setPosition(7);
                        }
                    }
                    break;
                }
                case 2: {
                    switch (n) {
                        case 0: {
                            this.pAxis.setPosition(5);
                            break block1;
                        }
                        case 1: {
                            this.pAxis.setPosition(7);
                        }
                    }
                }
            }
            this.Commit();
        } else if (actionEvent.getSource() == this.ScaleCombo) {
            int n = this.ScaleCombo.getSelectedIndex();
            this.pAxis.setScale(n);
            this.Commit();
        } else if (actionEvent.getSource() == this.SubGridCheck) {
            this.pAxis.setSubGridVisible(this.SubGridCheck.isSelected());
            this.Commit();
        } else if (actionEvent.getSource() == this.OppositeCheck) {
            this.pAxis.setDrawOpposite(this.OppositeCheck.isSelected());
            this.Commit();
        } else if (actionEvent.getSource() == this.VisibleCheck) {
            this.pAxis.setVisible(this.VisibleCheck.isSelected());
            this.Commit();
        } else if (actionEvent.getSource() == this.ColorBtn && (color = JColorChooser.showDialog(this, "Choose axis Color", this.pAxis.getAxisColor())) != null) {
            this.pAxis.setAxisColor(color);
            this.ColorView.setBackground(color);
            this.Commit();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (!(keyEvent.getSource() != this.MinText && keyEvent.getSource() != this.MaxText || this.pAxis.isAutoScale())) {
            if (keyEvent.getKeyCode() == 10) {
                try {
                    double d = Double.parseDouble(this.MinText.getText());
                    double d2 = Double.parseDouble(this.MaxText.getText());
                    if (d2 <= d) {
                        this.error("Min must be strictly lower than max.");
                        return;
                    }
                    if (this.pAxis.getScale() == 1 && (d <= 0.0 || d2 <= 0.0)) {
                        this.error("Min and max must be strictly positive with logarithmic scale.");
                        return;
                    }
                    this.pAxis.setMinimum(d);
                    this.pAxis.setMaximum(d2);
                    this.Commit();
                }
                catch (NumberFormatException numberFormatException) {
                    this.error("Min or Max: malformed number.");
                }
            }
        } else if (keyEvent.getSource() == this.TitleText && keyEvent.getKeyCode() == 10) {
            this.pAxis.setName(this.TitleText.getText());
            this.Commit();
        }
    }

    private void Commit() {
        if (this.pChart != null) {
            this.pChart.repaint();
        }
    }

    private void error(String string) {
        JOptionPane.showMessageDialog(this, string, "Chart options error", 0);
    }
}

