/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IStringSpectrum;
import fr.esrf.tangoatk.core.IStringSpectrumListener;
import fr.esrf.tangoatk.core.StringSpectrumEvent;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class SimpleStringSpectrumViewer
extends JPanel
implements IStringSpectrumListener {
    private JScrollPane jScrollPane1;
    private JTextArea strSpectText;
    private boolean viewEnd = false;
    IStringSpectrum model;

    public SimpleStringSpectrumViewer() {
        this.initComponents();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.strSpectText = new JTextArea();
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder("StringSpectrum"));
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.strSpectText.setLineWrap(false);
        this.strSpectText.setEditable(false);
        this.strSpectText.setColumns(50);
        this.strSpectText.setRows(10);
        this.strSpectText.setText("Unknown");
        this.strSpectText.setBackground(new Color(204, 204, 204));
        this.jScrollPane1.setViewportView(this.strSpectText);
        this.add((Component)this.jScrollPane1, "Center");
    }

    public void setModel(IStringSpectrum iStringSpectrum) {
        if (this.model != null) {
            this.model.removeListener((IStringSpectrumListener)this);
        }
        this.strSpectText.setText("");
        this.model = iStringSpectrum;
        if (this.model != null) {
            this.setBorder(new TitledBorder(this.model.getNameSansDevice()));
            this.model.addListener((IStringSpectrumListener)this);
            this.model.refresh();
        }
    }

    public IStringSpectrum getModel() {
        return this.model;
    }

    public int getRows() {
        return this.strSpectText.getRows();
    }

    public void setRows(int n) {
        this.strSpectText.setRows(n);
    }

    public int getColumns() {
        return this.strSpectText.getColumns();
    }

    public void setColumns(int n) {
        this.strSpectText.setColumns(n);
    }

    public JTextArea getText() {
        return this.strSpectText;
    }

    public void setStrTextArea(String string) {
        if (string.equals(this.strSpectText.getText())) {
            return;
        }
        this.strSpectText.setText(string);
        if (this.isViewEnd()) {
            this.placeTextToEnd();
        }
    }

    public void stringSpectrumChange(StringSpectrumEvent stringSpectrumEvent) {
        String string;
        if (stringSpectrumEvent.getValue() == null) {
            string = "StringSpectrumAttribute is null.\n";
        } else {
            String[] stringArray = null;
            stringArray = stringSpectrumEvent.getValue();
            int n = stringArray.length;
            StringBuffer stringBuffer = new StringBuffer(n);
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(stringArray[i]);
                stringBuffer.append("\n");
            }
            string = stringBuffer.toString();
        }
        this.setStrTextArea(string);
    }

    public void errorChange(ErrorEvent errorEvent) {
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
        if ("VALID".equals(attributeStateEvent.getState())) {
            this.strSpectText.setBackground(this.getBackground());
            return;
        }
        this.strSpectText.setBackground(ATKConstant.getColor4Quality(attributeStateEvent.getState()));
    }

    public boolean isViewEnd() {
        return this.viewEnd;
    }

    public void setViewEnd(boolean bl) {
        this.viewEnd = bl;
        if (this.isViewEnd()) {
            this.placeTextToEnd();
        }
    }

    private void placeTextToEnd() {
        this.strSpectText.setCaretPosition(this.strSpectText.getDocument().getLength());
    }

    public static void main(String[] stringArray) {
        IStringSpectrum iStringSpectrum;
        AttributeList attributeList = new AttributeList();
        SimpleStringSpectrumViewer simpleStringSpectrumViewer = new SimpleStringSpectrumViewer();
        simpleStringSpectrumViewer.setViewEnd(true);
        try {
            iStringSpectrum = (IStringSpectrum)attributeList.add("sy/rf-cavi/cav12/SequenceHistory");
            simpleStringSpectrumViewer.setModel(iStringSpectrum);
            attributeList.startRefresher();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        iStringSpectrum = null;
        iStringSpectrum = attributeList.get("sy/rf-cavi/cav12/SequenceHistory");
        if (iStringSpectrum == null) {
            System.out.println("Cannot retreive the attribute from the list.");
        } else if (iStringSpectrum instanceof IStringSpectrum) {
            System.out.println("the attribute retreived from the list.");
        } else {
            System.out.println("the attribute retreived is not IStringSpectrum");
        }
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jFrame.getContentPane().add((Component)simpleStringSpectrumViewer, gridBagConstraints);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

