static const char *RcsId = "$Header: /cvsroot/tango-cs/tango/cppserver/TangoTest/TangoTest.cpp,v 1.18 2009/04/04 17:42:36 taurel Exp $";
//+=============================================================================
//
// file :         TangoTest.cpp
//
// description :  C++ source for the TangoTest and its commands. 
//                The class is derived from Device. It represents the
//                CORBA servant object which will be accessed from the
//                network. All commands which can be executed on the
//                TangoTest are implemented in this file.
//
// project :      $TANGO Device Server for testing generic clients
//
// $Author: taurel $     $N.Leclercq - SOLEIL
//
// $Revision: 1.18 $ 
// 
// $Log: TangoTest.cpp,v $
// Revision 1.18  2009/04/04 17:42:36  taurel
// Device now inherits from Device_4Impl.
// Environment variable got from Tango library (To manage tangorc files)
//
// Revision 1.17  2009/03/02 08:14:34  jensmeyer
// Corrected writing of String spectrum and image attributes.
//
// Revision 1.16  2008/05/23 14:50:27  jensmeyer
// Set the default data generation time from 250ms to 2000ms
// to avoid overloading on slow CPUs.
//
// Revision 1.15  2008/05/15 06:27:24  jensmeyer
// Corrected compiler warnings for Windows VC8
//
// Revision 1.14  2008/02/20 16:00:33  pierrejoseph
// Add a property (UShort_image_ro_size) which determines the size of the ushort_image_ro attribute.
//
// Revision 1.13  2007/12/11 19:07:52  nleclercq
// added a "no_value" and a "throw_exception" attribute
//
// Revision 1.12  2007/12/04 11:30:39  nleclercq
// Added string spectrum and image attributes
//
// Revision 1.11  2006/08/22 08:28:16  jensmeyer
// Corrections to support gcc version 4.1.1
//
// Revision 1.10  2006/05/17 10:56:24  nleclercq
// Minor modif
//
// Revision 1.9  2006/03/27 07:29:11  jensmeyer
// Corrected float image attribute.
//
// Revision 1.8  2006/03/20 15:21:51  jensmeyer
// Added some castings for porting to VC8
//
// Revision 1.7  2006/02/08 16:14:28  nleclercq
// Minor modifs in RW spectrum and image attributes
//
// Revision 1.3  2005/01/17 10:06:42  pascal_verdier
// Command method signatures compatible with POGO.
//
// Revision 1.2  2005/01/14 13:45:08  taurel
// - Ported to Tango V5
//
// Revision 1.1.1.1  2004/05/07 12:43:44  taurel
// Initial import
//
//
// copyleft :     European Synchrotron Radiation Facility
//                BP 220, Grenoble 38043
//                FRANCE
// 
//-=============================================================================
//
//  		This file is generated by POGO
//	(Program Obviously used to Generate tango Object)
//
//         (c) - Software Engineering Group - ESRF
//=============================================================================


//===================================================================
//
//	The following table gives the correspondance
//	between commands and method's name.
//
//  Command's name           |  Method's name
//	----------------------------------------
//  State                    |  dev_state()
//  Status                   |  dev_status()
//  DevVoid                  |  dev_void()
//  DevBoolean               |  dev_boolean()
//  DevShort                 |  dev_short()
//  DevUShort                |  dev_ushort()
//  DevLong                  |  dev_long()
//  DevULong                 |  dev_ulong()
//  DevFloat                 |  dev_float()
//  DevDouble                |  dev_double()
//  DevString                |  dev_string()
//  DevVarCharArray          |  dev_var_char_array()
//  DevVarShortArray         |  dev_var_short_array()
//  DevVarUShortArray        |  dev_var_ushort_array()
//  DevVarLongArray          |  dev_var_long_array()
//  DevVarULongArray         |  dev_var_ulong_array()
//  DevVarFloatArray         |  dev_var_float_array()
//  DevVarDoubleArray        |  dev_var_double_array()
//  DevVarStringArray        |  dev_var_string_array()
//  DevVarLongStringArray    |  dev_var_long_string_array()
//  DevVarDoubleStringArray  |  dev_var_double_string_array()
//  SwitchStates             |  switch_states()
//
//===================================================================
#include <math.h>
#include <tango.h>
#include <TangoTest.h>
#include <TangoTestClass.h>

static const long kSpecLen = 256;
static const long kImagLen = 251;

namespace TangoTest_ns
{

//=============================================================================
// Standalone template function: generates a random <T> in the range [0, max]
//=============================================================================
template<typename T> inline T randomize (T max)
{
  if (max > 0) {
	int r = ((r = ::rand()) < 0) ? -r : r;
	return (T)(r % (int)max);
  }
  return 0;
}

//=============================================================================
// Standalone template function: generates a random image
//=============================================================================
template<typename T> 
void generate_full_image (T* buffer, long max_xy, long max_value)
{
	// For each pixel, we need to generate a random value between [0, max_value]
	for(long i=0; i<max_xy; i++)
	{
		for(long j=0; j<max_xy; j++)
		{
			int r = ((r = ::rand()) < 0) ? -r : r;
			buffer[i * max_xy + j] = (long)(r % (int)max_value);
		}
	}
}

//=============================================================================
// Standalone template function: generates a dummy beam image
//=============================================================================
template <typename T>
void generate_image (T* buffer, long max_xy)
{
	long bimg_center_x = ::rand() % (int)(max_xy * 0.05);
  if (::rand() % 2) {
    bimg_center_x *= -1;
  }
	long bimg_center_y = ::rand() % (int)(max_xy * 0.05);
  if (::rand() % 2) {
    bimg_center_y *= -1;
  }
	long bimg_offset_to_zero = (max_xy - 1) / 2;
	long bimg_x_offset_to_zero = bimg_offset_to_zero + bimg_center_x;
	long bimg_y_offset_to_zero = bimg_offset_to_zero + bimg_center_y;  
  long limit = max_xy / 8;
  long noise = ::rand() % (int)(limit * 0.2);
  if (::rand() % 2) {
    noise *= -1; 
  }
  limit += noise;
  // Reset image content
  ::memset(buffer, 0, max_xy * max_xy * sizeof(T));
  // Fill image buffer 
  long i, j, x, y, value;
  for (i = -limit; i < limit; i++) {
    y = i + bimg_y_offset_to_zero;
    if (y >= 0 && y < max_xy) {
      for (j = -limit; j < limit; j++) {
	      x = j + bimg_x_offset_to_zero;
        if (x >= 0 && x < max_xy) { 
          value = (long)::sqrt((double)(i * i + j * j));
          buffer[x * max_xy + y] = (T) ((value < limit) ? limit - value : 0);	 		
        }	
      }
    }
  }
}

//=============================================================================
// Class: DataGenerator (thread)  
//=============================================================================
class DataGenerator : public omni_thread, public Tango::LogAdapter
{ 
public:
  DataGenerator (TangoTest& dev, long sleep_time)
    : omni_thread(), 
      Tango::LogAdapter(&dev), 
      dev_(dev), 
      sleep_time_(sleep_time), 
      go_on_(1) 
  {
    // noop ctor
  }

  void go (void) 
  {
    DEBUG_STREAM << "DataGenerator::go" << endl;
    start_undetached();
  }  

  virtual void* run_undetached (void *) 
  {
    DEBUG_STREAM << "DataGenerator::run_undetached" << endl;
    do 
    {
      { //- enter critical section
        omni_mutex_lock guard(dev_.lock);
        if (!go_on_) break;
        	DEBUG_STREAM << "DataGenerator::generating data" << endl;
        dev_.gen_data();
      } //- leave critical section
      sleep(0, sleep_time_ * 1000000);
    }
    while (go_on_);
    return 0; 
  }

  void abort (void) 
  {
    DEBUG_STREAM << "DataGenerator::abort" << endl;
    go_on_ = 0;
  }  

protected:
  virtual ~DataGenerator (void)
  {
    // noop dtor
  }

private:  
  int go_on_;
  TangoTest& dev_;
  long sleep_time_;  
};

//=============================================================================
// TangoTest::gen_data
//=============================================================================
void TangoTest::gen_data ()
{
  // Generate data for all attributes
  static long k = 0;
  static const double kpi_deg = 3.14159 / 180.0;
  static const int boolean_generation_max_value = 2;
  static const int int_generation_max_value = 256;

  *attr_short_scalar_rww_read = 
			randomize(attr_short_scalar_w_write); 

  *attr_long_scalar_rww_read =
     	randomize(attr_long_scalar_w_write);

  *attr_double_scalar_rww_read = 
       attr_double_scalar_w_write * ::sin(kpi_deg * (k%360));

  *attr_short_scalar_ro_read =     
     randomize(attr_short_scalar_write);

  *attr_short_scalar_read =     
     randomize(attr_short_scalar_write);

 	*attr_long_scalar_read =
     randomize(attr_long_scalar_write);

 	*attr_double_scalar_read =
     attr_double_scalar_write * ::sin(kpi_deg * (k%360));

 	*attr_ushort_scalar_read =
     randomize(attr_ushort_scalar_write);

  *attr_uchar_scalar_read =
     randomize(attr_uchar_scalar_write);

  *attr_float_scalar_read =
     randomize(attr_float_scalar_write);

 	size_t i, j;

	for (i = 0; i < kSpecLen; i++)
		attr_short_spectrum_ro_read[i] = randomize(int_generation_max_value);

	for (i = 0; i < kSpecLen; i++)
		attr_long_spectrum_ro_read[i] = randomize(int_generation_max_value);

	for (i = 0; i < kSpecLen; i++)
		attr_double_spectrum_ro_read[i] = randomize(int_generation_max_value);

	for (i = 0; i < kSpecLen; i++)
     attr_wave_read[i] = attr_ampli_write * ::sin(kpi_deg * (i + (k%360)));

	for (i = 0; i < kSpecLen; i++)
	{
		attr_boolean_spectrum_ro_read[i] = 
            randomize(boolean_generation_max_value) ? true : false;
	}

	for (i = 0; i < kSpecLen; i++)
	{
		attr_ushort_spectrum_ro_read[i] = randomize(int_generation_max_value);
	}

	for (i = 0; i < kSpecLen; i++)
	{
		attr_uchar_spectrum_ro_read[i] = randomize(int_generation_max_value);
	}

	for (i = 0; i < kSpecLen; i++)
	{
		attr_float_spectrum_ro_read[i] = (float) randomize(int_generation_max_value);
	}

  generate_image(attr_short_image_ro_read,  kImagLen);

  generate_image(attr_long_image_ro_read,  kImagLen);

  generate_image(attr_float_image_ro_read, kImagLen);

  generate_image(attr_double_image_ro_read,  kImagLen);

  generate_full_image(attr_boolean_image_ro_read, kImagLen, boolean_generation_max_value);

  generate_full_image(attr_uchar_image_ro_read, kImagLen, int_generation_max_value);

  generate_full_image(attr_ushort_image_ro_read, uShort_image_ro_size, int_generation_max_value);

  for (i = 0; i < kSpecLen; i++)
    ::sprintf(attr_string_spectrum_ro_read[i],"[%.2d]::hello-world-%.4d", i, randomize(int_generation_max_value));

  for (j = 0; j < kImagLen; j++)
    for (i = 0; i < kImagLen; i++)
      ::sprintf(attr_string_image_ro_read[ i + j * kImagLen],"[%.2d][%.2d]::hello world::%.4d", i, j, randomize(int_generation_max_value));

  k++;
}

//=============================================================================
// TangoTest::TangoTest
//=============================================================================
TangoTest::TangoTest(Tango::DeviceClass *cl,string &s)
  : Tango::Device_4Impl (cl, s.c_str())
{
	init_device();
} 

//=============================================================================
// TangoTest::TangoTest
//=============================================================================
TangoTest::TangoTest(Tango::DeviceClass *cl,const char *s)
  : Tango::Device_4Impl (cl, s)
{
	init_device();
}

//=============================================================================
// TangoTest::TangoTest
//=============================================================================
TangoTest::TangoTest(Tango::DeviceClass *cl,const char *s,const char *d)
  : Tango::Device_4Impl (cl,s,d)
{
	init_device();
}

//=============================================================================
// TangoTest::~TangoTest
//=============================================================================
TangoTest::~TangoTest() 
{
  DEBUG_STREAM << "TangoTest::~TangoTest::destroy device " << get_name() << std::endl;
  delete_device();
}

//=============================================================================
// TangoTest::init_device
//=============================================================================
void TangoTest::init_device()
{
  LOG_INFO(("TangoTest::init_device::init device %s", device_name.c_str()));

  omni_mutex_lock guard(lock);

	// Initialise variables to default values
	//-------------------------------------------------------

    // Get device property from database
  get_device_property();
  // Allocate/initialize read part for each readable attribute
  // Initialize write part for each writable attribute

  //- Scalar
  attr_short_scalar_ro_read = new Tango::DevShort;
	*attr_short_scalar_ro_read = 0;

	attr_short_scalar_read = new Tango::DevShort;
	*attr_short_scalar_read = 0;
  attr_short_scalar_write = 256; 
  
  attr_short_scalar_w_write = 256;
  attr_short_scalar_rww_read = new Tango::DevShort;
  *attr_short_scalar_rww_read = 0;

	attr_long_scalar_read = new Tango::DevLong;
	*attr_long_scalar_read = 0; 
  attr_long_scalar_write = 256; 

  attr_long_scalar_w_write = 256;
  attr_long_scalar_rww_read = new Tango::DevLong;
  *attr_long_scalar_rww_read = 0;

	attr_double_scalar_read = new Tango::DevDouble;
	*attr_double_scalar_read = 0;
  attr_double_scalar_write = 256;

  attr_double_scalar_w_write = 256;
  attr_double_scalar_rww_read = new Tango::DevDouble;
  *attr_double_scalar_rww_read = 0;

	attr_string_scalar_read = new char*;
	*attr_string_scalar_read = new char[256];
  ::strcpy(*attr_string_scalar_read, "Default string");
  attr_string_scalar_write = 0;

  attr_boolean_scalar_read = new Tango::DevBoolean;
	*attr_boolean_scalar_read = true;
	attr_boolean_scalar_write = false;

  attr_float_scalar_read = new Tango::DevFloat;
	*attr_float_scalar_read = 0;
	attr_float_scalar_write = 0;

	attr_uchar_scalar_read = new Tango::DevUChar;
	*attr_uchar_scalar_read = 0;
	attr_uchar_scalar_write = 0;

	attr_ushort_scalar_read = new Tango::DevUShort;
	*attr_ushort_scalar_read = 0;
	attr_ushort_scalar_write = 0;

  //- Spectrum
	attr_short_spectrum_ro_read = new Tango::DevShort[kSpecLen];
	::memset(attr_short_spectrum_ro_read, 0, kSpecLen * sizeof(Tango::DevShort));

  attr_short_spectrum_read = new Tango::DevShort[kSpecLen];
	::memset(attr_short_spectrum_read, 0, kSpecLen * sizeof(Tango::DevShort));

  dimShortSpectrum = kSpecLen;

  attr_long_spectrum_ro_read = new Tango::DevLong[kSpecLen];
	::memset(attr_long_spectrum_ro_read, 0, kSpecLen * sizeof(Tango::DevLong));

	attr_long_spectrum_read = new Tango::DevLong[kSpecLen];
	::memset(attr_long_spectrum_read, 0, kSpecLen * sizeof(Tango::DevLong));

  dimLongSpectrum = kSpecLen;

  attr_double_spectrum_ro_read = new Tango::DevDouble[kSpecLen];
	::memset(attr_double_spectrum_ro_read, 0, kSpecLen * sizeof(Tango::DevDouble));

	attr_double_spectrum_read = new Tango::DevDouble[kSpecLen];
	::memset(attr_double_spectrum_read, 0, kSpecLen * sizeof(Tango::DevDouble));

  dimDoubleSpectrum = kSpecLen;

  attr_string_spectrum_ro_read = new Tango::DevString[kSpecLen];
  size_t s;
  for (s = 0; s < kSpecLen; s++)
  {
    attr_string_spectrum_ro_read[s] = CORBA::string_alloc(kSpecLen);
    ::memset(attr_string_spectrum_ro_read[s], 0, kSpecLen * sizeof(char));
  }

  attr_string_spectrum_read = new Tango::DevString[kSpecLen];
  for (s = 0; s < kSpecLen; s++)
  {
    attr_string_spectrum_read[s] = CORBA::string_alloc(kSpecLen);
    ::memset(attr_string_spectrum_read[s], 0, kSpecLen * sizeof(char));
  }
  attr_string_spectrum_write = 0;

  dimStringSpectrum = kSpecLen;

	attr_wave_read = new Tango::DevDouble[kSpecLen];
	::memset(attr_wave_read, 0, kSpecLen * sizeof(Tango::DevDouble));
	attr_ampli_write= 1;

  attr_boolean_spectrum_ro_read = new Tango::DevBoolean[kSpecLen];
	::memset(attr_boolean_spectrum_ro_read, 0, kSpecLen * sizeof(Tango::DevBoolean));

	attr_boolean_spectrum_read = new Tango::DevBoolean[kSpecLen];
	::memset(attr_boolean_spectrum_read, 0, kSpecLen * sizeof(Tango::DevBoolean));

  dimBooleanSpectrum = kSpecLen;

  attr_ushort_spectrum_ro_read = new Tango::DevUShort[kSpecLen];
	::memset(attr_ushort_spectrum_ro_read, 0, kSpecLen * sizeof(Tango::DevUShort));

  attr_ushort_spectrum_read = new Tango::DevUShort[kSpecLen];
	::memset(attr_ushort_spectrum_read, 0, kSpecLen * sizeof(Tango::DevUShort));

  dimUshortSpectrum = kSpecLen;

  attr_uchar_spectrum_ro_read = new Tango::DevUChar[kSpecLen];
	::memset(attr_uchar_spectrum_ro_read, 0, kSpecLen * sizeof(Tango::DevUChar));

	attr_uchar_spectrum_read = new Tango::DevUChar[kSpecLen];
	::memset(attr_uchar_spectrum_read, 0, kSpecLen * sizeof(Tango::DevUChar));

  dimUcharSpectrum = kSpecLen;

  attr_float_spectrum_ro_read = new Tango::DevFloat[kSpecLen];
	::memset(attr_float_spectrum_ro_read, 0, kSpecLen * sizeof(Tango::DevFloat));

	attr_float_spectrum_read = new Tango::DevFloat[kSpecLen];
	::memset(attr_float_spectrum_read, 0, kSpecLen * sizeof(Tango::DevFloat));

  dimFloatSpectrum = kSpecLen;

  //- Images
	attr_short_image_read = new Tango::DevShort[kImagLen * kImagLen];
	::memset(attr_short_image_read, 0, kImagLen * kImagLen * sizeof(Tango::DevShort));

  dimXShortImage = kImagLen;
  dimYShortImage = kImagLen;

	attr_long_image_read = new Tango::DevLong[kImagLen * kImagLen];
	::memset(attr_long_image_read, 0, kImagLen * kImagLen * sizeof(Tango::DevLong));

  dimXLongImage = kImagLen;
  dimYLongImage = kImagLen;

	attr_double_image_read = new Tango::DevDouble[kImagLen * kImagLen];
	::memset(attr_double_image_read, 0, kImagLen * kImagLen * sizeof(Tango::DevDouble));

  dimXDoubleImage = kImagLen;
  dimYDoubleImage = kImagLen;

	attr_uchar_image_read = new Tango::DevUChar[kImagLen * kImagLen];
	::memset(attr_uchar_image_read, 0, kImagLen * kImagLen * sizeof(Tango::DevUChar));

  dimXUcharImage = kImagLen;
  dimYUcharImage = kImagLen;
	
	attr_ushort_image_read = new Tango::DevUShort[kImagLen * kImagLen];
	::memset(attr_ushort_image_read, 0, kImagLen * kImagLen * sizeof(Tango::DevUShort));

  dimXUshortImage = kImagLen;
  dimYUshortImage = kImagLen;

	attr_float_image_read = new Tango::DevFloat[kImagLen * kImagLen];
	::memset(attr_float_image_read, 0, kImagLen * kImagLen * sizeof(Tango::DevFloat));

  dimXFloatImage = kImagLen;
  dimYFloatImage = kImagLen;

  	attr_boolean_image_read = new Tango::DevBoolean[kImagLen * kImagLen];
	::memset(attr_boolean_image_read, 0, kImagLen * kImagLen * sizeof(Tango::DevBoolean));

  dimXBooleanImage = kImagLen;
  dimYBooleanImage = kImagLen;

  attr_short_image_ro_read = new Tango::DevShort[kImagLen * kImagLen];
	::memset(attr_short_image_ro_read, 0, kImagLen * kImagLen * sizeof(Tango::DevShort));

	attr_long_image_ro_read = new Tango::DevLong[kImagLen * kImagLen];
	::memset(attr_long_image_ro_read, 0, kImagLen * kImagLen * sizeof(Tango::DevLong));

	attr_double_image_ro_read = new Tango::DevDouble[kImagLen * kImagLen];
	::memset(attr_double_image_ro_read, 0, kImagLen * kImagLen * sizeof(Tango::DevDouble));

	attr_uchar_image_ro_read = new Tango::DevUChar[kImagLen * kImagLen];
	::memset(attr_uchar_image_ro_read, 0, kImagLen * kImagLen * sizeof(Tango::DevUChar));
	
	attr_ushort_image_ro_read = new Tango::DevUShort[uShort_image_ro_size * uShort_image_ro_size];
	::memset(attr_ushort_image_ro_read, 0, uShort_image_ro_size * uShort_image_ro_size * sizeof(Tango::DevUShort));

	attr_float_image_ro_read = new Tango::DevFloat[kImagLen * kImagLen];
	::memset(attr_float_image_ro_read, 0, kImagLen * kImagLen * sizeof(Tango::DevFloat));

  attr_boolean_image_ro_read = new Tango::DevBoolean[kImagLen * kImagLen];
	::memset(attr_boolean_image_ro_read, 0, kImagLen * kImagLen * sizeof(Tango::DevBoolean));

  attr_string_image_ro_read = new char*[kImagLen * kImagLen];
  for (s = 0; s < kImagLen * kImagLen; s++)
  {
    attr_string_image_ro_read[s] = CORBA::string_alloc(kSpecLen);
    ::memset(attr_string_image_ro_read[s], 0, kSpecLen * sizeof(char));
  }

  attr_string_image_read = new char*[kImagLen * kImagLen];
  for (s = 0; s < kImagLen * kImagLen; s++)
  {
    attr_string_image_read[s] = CORBA::string_alloc(kSpecLen);
    ::memset(attr_string_image_read[s], 0, kSpecLen * sizeof(char));
  }
  attr_string_image_write = 0;

  dimXStringImage = kImagLen;
  dimYStringImage = kImagLen;


  // Multithreaded implementation stuffs
  if (mthreaded_impl == 0) {
   data_gen = 0;
   return; 
  }
  data_gen = new DataGenerator(*this, sleep_period);
  data_gen->go();

  set_state(Tango::RUNNING);
}


//+----------------------------------------------------------------------------
//
// method : 		TangoTest::readDeviceProperies()
// 
// description : 	Read the device properties from database.
//
//-----------------------------------------------------------------------------
void TangoTest::get_device_property()
{
	//	Initialize your default values here.
	//------------------------------------------

	mthreaded_impl = 1;
	sleep_period = 2000;
	uShort_image_ro_size = kImagLen;

	//	Read device properties from database.(Automatic code generation)
	//-------------------------------------------------------------
	Tango::DbData	dev_prop;
	dev_prop.push_back(Tango::DbDatum("Mthreaded_impl"));
	dev_prop.push_back(Tango::DbDatum("Sleep_period"));
	dev_prop.push_back(Tango::DbDatum("UShort_image_ro_size"));

	//	Call database and extract values
	//--------------------------------------------
	if (Tango::Util::instance()->_UseDb==true)
		get_db_device()->get_property(dev_prop);
	Tango::DbDatum	def_prop, cl_prop;
	TangoTestClass	*ds_class =
		(static_cast<TangoTestClass *>(get_device_class()));
	int	i = -1;

	//	Try to initialize Mthreaded_impl from class property
	cl_prop = ds_class->get_class_property(dev_prop[++i].name);
	if (cl_prop.is_empty()==false)	cl_prop  >>  mthreaded_impl;
	//	Try to initialize Mthreaded_impl from default device value
	def_prop = ds_class->get_default_device_property(dev_prop[i].name);
	if (def_prop.is_empty()==false)	def_prop  >>  mthreaded_impl;
	//	And try to extract Mthreaded_impl value from database
	if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  mthreaded_impl;

	//	Try to initialize Sleep_period from class property
	cl_prop = ds_class->get_class_property(dev_prop[++i].name);
	if (cl_prop.is_empty()==false)	cl_prop  >>  sleep_period;
	//	Try to initialize Sleep_period from default device value
	def_prop = ds_class->get_default_device_property(dev_prop[i].name);
	if (def_prop.is_empty()==false)	def_prop  >>  sleep_period;
	//	And try to extract Sleep_period value from database
	if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  sleep_period;

	//	Try to initialize UShort_image_ro_size from class property
	cl_prop = ds_class->get_class_property(dev_prop[++i].name);
	if (cl_prop.is_empty()==false)	cl_prop  >>  uShort_image_ro_size;
	//	Try to initialize UShort_image_ro_size from default device value
	def_prop = ds_class->get_default_device_property(dev_prop[i].name);
	if (def_prop.is_empty()==false)	def_prop  >>  uShort_image_ro_size;
	//	And try to extract UShort_image_ro_size value from database
	if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  uShort_image_ro_size;



	//	End of Automatic code generation
	//-------------------------------------------------------------

	DEBUG_STREAM << "sleep_period=" << sleep_period << endl;
	DEBUG_STREAM << "mthreaded_impl=" << mthreaded_impl << endl;
	DEBUG_STREAM << "uShort_image_ro_size=" << uShort_image_ro_size << endl;

}
//=============================================================================
// TangoTest::delete_device
//=============================================================================
void TangoTest::delete_device()
{
  DEBUG_STREAM << "In TangoTest::delete_device for " << this->get_name() << endl;

  omni_mutex_lock guard(lock);

  if (mthreaded_impl && data_gen) {
    data_gen->abort();
    data_gen->join(0);
    data_gen = 0;
  }

  if (attr_short_scalar_ro_read) {
    delete attr_short_scalar_ro_read;
    attr_short_scalar_ro_read = 0;
  }

  if (attr_short_scalar_read) {
    delete attr_short_scalar_read;
    attr_short_scalar_read = 0;
  }

  
  if (attr_short_scalar_rww_read) {
	  delete attr_short_scalar_rww_read;
    attr_short_scalar_rww_read = 0;
  }

  if (attr_long_scalar_read) {
    delete attr_long_scalar_read;
    attr_long_scalar_read = 0;
  }

  if (attr_long_scalar_rww_read) {
	  delete attr_long_scalar_rww_read;
    attr_long_scalar_rww_read = 0;
  }

  if (attr_double_scalar_read) {
	  delete attr_double_scalar_read;
    attr_double_scalar_read = 0;
  }

  if (attr_double_scalar_rww_read) {
	  delete attr_double_scalar_rww_read;
    attr_double_scalar_rww_read = 0;
  }

  if (*attr_string_scalar_read) {
    delete *attr_string_scalar_read;
  }

  if (attr_string_scalar_read) {
	  delete[] attr_string_scalar_read;
    attr_string_scalar_read = 0;
  }
    
  if (attr_boolean_scalar_read) {
    delete attr_boolean_scalar_read;
    attr_boolean_scalar_read = 0;
  }

  if (attr_float_scalar_read) {
    delete attr_float_scalar_read;
    attr_float_scalar_read = 0;
  }

  if (attr_uchar_scalar_read) {
    delete attr_uchar_scalar_read;
    attr_uchar_scalar_read = 0;
  }
 
  if (attr_ushort_scalar_read) {
    delete attr_ushort_scalar_read;
    attr_ushort_scalar_read = 0;
  }

  //- spectrum
  if (attr_short_spectrum_read) {
    delete[] attr_short_spectrum_read;
    attr_short_spectrum_read = 0;
  }

  if (attr_short_spectrum_ro_read) {
    delete[] attr_short_spectrum_ro_read;
    attr_short_spectrum_ro_read = 0;
  }

  if (attr_long_spectrum_read) {
    delete[] attr_long_spectrum_read;
    attr_long_spectrum_read = 0;
  }

  if (attr_long_spectrum_ro_read) {
    delete[] attr_long_spectrum_ro_read;
    attr_long_spectrum_ro_read = 0;
  }

  if (attr_double_spectrum_read) {
    delete[] attr_double_spectrum_read;
    attr_double_spectrum_read = 0;
  }

  if (attr_double_spectrum_ro_read) {
    delete[] attr_double_spectrum_ro_read;
    attr_double_spectrum_ro_read = 0;
  }

  if (attr_boolean_spectrum_read) {
    delete[] attr_boolean_spectrum_read;
    attr_boolean_spectrum_read = 0;
  }

  if (attr_boolean_spectrum_ro_read) {
    delete[] attr_boolean_spectrum_ro_read;
    attr_boolean_spectrum_ro_read = 0;
  }

  if (attr_uchar_spectrum_read) {
    delete[] attr_uchar_spectrum_read;
    attr_uchar_spectrum_read = 0;
  }
 
  if (attr_uchar_spectrum_ro_read) {
    delete[] attr_uchar_spectrum_ro_read;
    attr_uchar_spectrum_ro_read = 0;
  }

  if (attr_ushort_spectrum_read) {
    delete[] attr_ushort_spectrum_read;
    attr_ushort_spectrum_read = 0;
  }

  if (attr_ushort_spectrum_ro_read) {
    delete[] attr_ushort_spectrum_ro_read;
    attr_ushort_spectrum_ro_read = 0;
  }

   if (attr_float_spectrum_read) {
    delete[] attr_float_spectrum_read;
    attr_float_spectrum_read = 0;
  }

  if (attr_float_spectrum_ro_read) {
    delete[] attr_float_spectrum_ro_read;
    attr_float_spectrum_ro_read = 0;
  }

  size_t s = 0;
  if (attr_string_spectrum_ro_read) {
    for (; s < kSpecLen; s++)
      CORBA::string_free(attr_string_spectrum_ro_read[s]);
    delete[] attr_string_spectrum_ro_read;
    attr_string_spectrum_ro_read = 0;
  }

  if (attr_string_spectrum_read) {
    for (; s < kSpecLen; s++)
      CORBA::string_free(attr_string_spectrum_read[s]);
    delete[] attr_string_spectrum_read;
    attr_string_spectrum_read = 0;
  }


  //- image
  if (attr_short_image_read) {
    delete[] attr_short_image_read;
    attr_short_image_read = 0;
  }

  if (attr_long_image_read) {
    delete[] attr_long_image_read;
    attr_long_image_read = 0;
  }

  if (attr_double_image_read) {
    delete[] attr_double_image_read;
    attr_double_image_read = 0;
  }

  if (attr_boolean_image_read) {
    delete[] attr_boolean_image_read;
    attr_boolean_image_read = 0;
  }

  if (attr_uchar_image_read) {
    delete[] attr_uchar_image_read;
    attr_uchar_image_read = 0;
  }

  if (attr_ushort_image_read) {
    delete[] attr_ushort_image_read;
    attr_ushort_image_read = 0;
  }

  if (attr_float_image_read) {
    delete[] attr_float_image_read;
    attr_float_image_read = 0;
  }

  //

  if (attr_short_image_ro_read) {
    delete[] attr_short_image_ro_read;
    attr_short_image_ro_read = 0;
  }

  if (attr_long_image_ro_read) {
    delete[] attr_long_image_ro_read;
    attr_long_image_ro_read = 0;
  }

  if (attr_double_image_ro_read) {
    delete[] attr_double_image_ro_read;
    attr_double_image_ro_read = 0;
  }

  if (attr_boolean_image_ro_read) {
    delete[] attr_boolean_image_ro_read;
    attr_boolean_image_ro_read = 0;
  }

  if (attr_uchar_image_ro_read) {
    delete[] attr_uchar_image_ro_read;
    attr_uchar_image_ro_read = 0;
  }

  if (attr_ushort_image_ro_read) {
    delete[] attr_ushort_image_ro_read;
    attr_ushort_image_ro_read = 0;
  }

  if (attr_float_image_ro_read) {
    delete[] attr_float_image_ro_read;
    attr_float_image_ro_read = 0;
  }

  if (attr_string_image_ro_read) {
    for (; s < kImagLen * kImagLen; s++)
      CORBA::string_free(attr_string_image_ro_read[s]);
    delete[] attr_string_image_ro_read;
    attr_string_image_ro_read = 0;
  }

  if (attr_string_image_read) {
    for (; s < kImagLen * kImagLen; s++)
      CORBA::string_free(attr_string_image_read[s]);
    delete[] attr_string_image_read;
    attr_string_image_read = 0;
  }

  if (attr_wave_read) {
    delete[] attr_wave_read;
    attr_wave_read = 0;
  }

}


//=============================================================================
// TangoTest::always_executed_hook
//=============================================================================
void TangoTest::always_executed_hook()
{
	DEBUG_STREAM << "In always_executed_hook method" << endl;
}

//=============================================================================
// TangoTest::read_attr_hardware
//=============================================================================
void TangoTest::read_attr_hardware(vector<long> &attr_list)
{
  LOG_DEBUG(("In read_attr_hardware for %d attributes",attr_list.size()));

  // Generate data for all attributes
  if (mthreaded_impl == 0) { 
 	  gen_data();
  }
} 
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_no_value
// 
// description : 	Extract real attribute values for no_value acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_no_value(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_no_value(Tango::Attribute &attr) entering... "<< endl;
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_throw_exception
// 
// description : 	Extract real attribute values for throw_exception acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_throw_exception(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_throw_exception(Tango::Attribute &attr) entering... "<< endl;
  
  Tango::Except::throw_exception((const char *)"exception test",
						                     (const char *)"here is the exception you requested",
						                     (const char *)"TangoTest::read_throw_exception");
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_string_spectrum
// 
// description : 	Extract real attribute values for string_spectrum acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_string_spectrum(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_string_spectrum(Tango::Attribute &attr) entering... "<< endl;
  attr.set_value(attr_string_spectrum_read, kSpecLen);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::write_string_spectrum
// 
// description : 	Write string_spectrum attribute values to hardware.
//
//-----------------------------------------------------------------------------
void TangoTest::write_string_spectrum(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_string_spectrum(Tango::WAttribute &attr) entering... "<< endl;

  const Tango::ConstDevString *p=NULL;
  attr.get_write_value(p);

  size_t len = attr.get_w_dim_x();
  if (len > kSpecLen)
    len = kSpecLen;

  for (size_t i = 0; i < len; i++)
  {
    CORBA::string_free(attr_string_spectrum_read[i]);
    attr_string_spectrum_read[i] = CORBA::string_dup(p[i]);
  }
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_string_image
// 
// description : 	Extract real attribute values for string_image acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_string_image(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_string_image(Tango::Attribute &attr) entering... "<< endl;
  attr.set_value(attr_string_image_read, dimXStringImage, dimYStringImage);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::write_string_image
// 
// description : 	Write string_image attribute values to hardware.
//
//-----------------------------------------------------------------------------
void TangoTest::write_string_image(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_string_image(Tango::WAttribute &attr) entering... "<< endl;

  const Tango::ConstDevString *p=NULL;
  attr.get_write_value(p);

  dimXStringImage = attr.get_w_dim_x();
  if (dimXStringImage > kImagLen)
    dimXStringImage = kImagLen;
  DEBUG_STREAM << "X :" << dimXStringImage << endl;

  dimYStringImage = attr.get_w_dim_y();
  if (dimYStringImage > kImagLen)
    dimYStringImage = kImagLen;
  DEBUG_STREAM << "Y :" << dimYStringImage << endl;

  size_t i ,j, str_index;
  for (j = 0; j < dimYStringImage; j++)
  {
    for (i = 0; i < dimXStringImage; i++)
    {
      str_index = i + j * dimYStringImage;
      CORBA::string_free(attr_string_image_read[str_index]);
      attr_string_image_read[str_index] = CORBA::string_dup(p[str_index]);
    }
  }
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_string_spectrum_ro
// 
// description : 	Extract real attribute values for string_spectrum_ro acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_string_spectrum_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_string_spectrum_ro(Tango::Attribute &attr) entering... "<< endl;
  attr.set_value(attr_string_spectrum_ro_read, kSpecLen);
}


//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_string_image_ro
// 
// description : 	Extract real attribute values for string_image_ro acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_string_image_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_string_image_ro(Tango::Attribute &attr) entering... "<< endl;
  attr.set_value(attr_string_image_ro_read, kImagLen, kImagLen);
}


//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_boolean_image
// 
// description : 	Extract real attribute values for boolean_image acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_boolean_image(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_boolean_image(Tango::Attribute &attr) entering... "<< endl;
  attr.set_value(attr_boolean_image_read, dimXBooleanImage, dimYBooleanImage);

}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::write_boolean_image
// 
// description : 	Write boolean_image attribute values to hardware.
//
//-----------------------------------------------------------------------------
void TangoTest::write_boolean_image(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_boolean_image(Tango::WAttribute &attr) entering... "<< endl;

  const bool * p;
  attr.get_write_value(p);

  dimXBooleanImage = attr.get_w_dim_x();
  DEBUG_STREAM << "X :" << dimXBooleanImage << endl;

  dimYBooleanImage = attr.get_w_dim_y();
  DEBUG_STREAM << "Y :" << dimYBooleanImage << endl;

  long len = dimXBooleanImage * dimYBooleanImage;

  len = (len <= kImagLen * kImagLen) ? len : kImagLen * kImagLen;

  ::memcpy(attr_boolean_image_read, p, len * sizeof(Tango::DevBoolean));
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_uchar_image
// 
// description : 	Extract real attribute values for uchar_image acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_uchar_image(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_uchar_image(Tango::Attribute &attr) entering... "<< endl;
  attr.set_value(attr_uchar_image_read, dimXUcharImage, dimYUcharImage);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::write_uchar_image
// 
// description : 	Write uchar_image attribute values to hardware.
//
//-----------------------------------------------------------------------------
void TangoTest::write_uchar_image(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_uchar_image(Tango::WAttribute &attr) entering... "<< endl;

  const unsigned char * p;
  attr.get_write_value(p);

  dimXUcharImage = attr.get_w_dim_x();
  DEBUG_STREAM << "X :" << dimXUcharImage << endl;

  dimYUcharImage = attr.get_w_dim_y();
  DEBUG_STREAM << "Y :" << dimYUcharImage << endl;

  long len = dimXUcharImage * dimYUcharImage;

  len = (len <= kImagLen * kImagLen) ? len : kImagLen * kImagLen;

  ::memcpy(attr_uchar_image_read, p, len * sizeof(Tango::DevUChar));
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_short_image
// 
// description : 	Extract real attribute values for short_image acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_short_image(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_short_image(Tango::Attribute &attr) entering... "<< endl;
    attr.set_value(attr_short_image_read, dimXShortImage, dimYShortImage);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::write_short_image
// 
// description : 	Write short_image attribute values to hardware.
//
//-----------------------------------------------------------------------------
void TangoTest::write_short_image(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_short_image(Tango::WAttribute &attr) entering... "<< endl;

  const short * p;
  attr.get_write_value(p);

  dimXShortImage = attr.get_w_dim_x();
  DEBUG_STREAM << "X :" << dimXShortImage << endl;

  dimYShortImage = attr.get_w_dim_y();
  DEBUG_STREAM << "Y :" << dimYShortImage << endl;

  long len = dimXShortImage * dimYShortImage;

  len = (len <= kImagLen * kImagLen) ? len : kImagLen * kImagLen;

  ::memcpy(attr_short_image_read, p, len * sizeof(Tango::DevShort));
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_ushort_image
// 
// description : 	Extract real attribute values for ushort_image acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_ushort_image(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_ushort_image(Tango::Attribute &attr) entering... "<< endl;
    attr.set_value(attr_ushort_image_read, dimXUshortImage, dimYUshortImage);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::write_ushort_image
// 
// description : 	Write ushort_image attribute values to hardware.
//
//-----------------------------------------------------------------------------
void TangoTest::write_ushort_image(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_ushort_image(Tango::WAttribute &attr) entering... "<< endl;

  const unsigned short * p;
  attr.get_write_value(p);

  dimXUshortImage = attr.get_w_dim_x();
  DEBUG_STREAM << "X :" << dimXUshortImage << endl;

  dimYUshortImage = attr.get_w_dim_y();
  DEBUG_STREAM << "Y :" << dimYUshortImage << endl;

  long len = dimXUshortImage * dimYUshortImage;

  len = (len <= kImagLen * kImagLen) ? len : kImagLen * kImagLen;

  ::memcpy(attr_ushort_image_read, p, len * sizeof(Tango::DevUShort));
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_long_image
// 
// description : 	Extract real attribute values for long_image acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_long_image(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_long_image(Tango::Attribute &attr) entering... "<< endl;
    attr.set_value(attr_long_image_read, kImagLen, kImagLen);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::write_long_image
// 
// description : 	Write long_image attribute values to hardware.
//
//-----------------------------------------------------------------------------
void TangoTest::write_long_image(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_long_image(Tango::WAttribute &attr) entering... "<< endl;

  const long * p;
  attr.get_write_value(p);

  dimXLongImage = attr.get_w_dim_x();
  DEBUG_STREAM << "X :" << dimXLongImage << endl;

  dimYLongImage = attr.get_w_dim_y();
  DEBUG_STREAM << "Y :" << dimYLongImage << endl;

  long len = dimXLongImage * dimYLongImage;

  len = (len <= kImagLen * kImagLen) ? len : kImagLen * kImagLen;

  ::memcpy(attr_long_image_read, p, len * sizeof(Tango::DevLong));
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_float_image
// 
// description : 	Extract real attribute values for float_image acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_float_image(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_float_image(Tango::Attribute &attr) entering... "<< endl;
    attr.set_value(attr_float_image_read, dimXFloatImage, dimYFloatImage);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::write_float_image
// 
// description : 	Write float_image attribute values to hardware.
//
//-----------------------------------------------------------------------------
void TangoTest::write_float_image(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_float_image(Tango::WAttribute &attr) entering... "<< endl;

  const float * p;
  attr.get_write_value(p);

  dimXFloatImage = attr.get_w_dim_x();
  DEBUG_STREAM << "X :" << dimXFloatImage << endl;

  dimYFloatImage = attr.get_w_dim_y();
  DEBUG_STREAM << "Y :" << dimYFloatImage << endl;

  long len = dimXFloatImage * dimYFloatImage;

  len = (len <= kImagLen * kImagLen) ? len : kImagLen * kImagLen;

  ::memcpy(attr_float_image_read, p, len * sizeof(Tango::DevFloat));
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_double_image
// 
// description : 	Extract real attribute values for double_image acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_double_image(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_double_image(Tango::Attribute &attr) entering... "<< endl;
    attr.set_value(attr_double_image_read, dimXDoubleImage, dimYDoubleImage);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::write_double_image
// 
// description : 	Write double_image attribute values to hardware.
//
//-----------------------------------------------------------------------------
void TangoTest::write_double_image(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_double_image(Tango::WAttribute &attr) entering... "<< endl;

  const double * p;
  attr.get_write_value(p);

  dimXDoubleImage = attr.get_w_dim_x();
  DEBUG_STREAM << "X :" << dimXDoubleImage << endl;

  dimYDoubleImage = attr.get_w_dim_y();
  DEBUG_STREAM << "Y :" << dimYDoubleImage << endl;

  long len = dimXDoubleImage * dimYDoubleImage;

  len = (len <= kImagLen * kImagLen) ? len : kImagLen * kImagLen;

  ::memcpy(attr_double_image_read, p, len * sizeof(Tango::DevDouble));
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_uchar_image_ro
// 
// description : 	Extract real attribute values for uchar_image_ro acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_uchar_image_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_uchar_image_ro(Tango::Attribute &attr) entering... "<< endl;
  attr.set_value(attr_uchar_image_ro_read, kImagLen, kImagLen);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_ushort_image_ro
// 
// description : 	Extract real attribute values for ushort_image_ro acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_ushort_image_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_ushort_image_ro(Tango::Attribute &attr) entering... "<< endl;
  attr.set_value(attr_ushort_image_ro_read, uShort_image_ro_size, uShort_image_ro_size);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_float_image_ro
// 
// description : 	Extract real attribute values for float_image_ro acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_float_image_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_float_image_ro(Tango::Attribute &attr) entering... "<< endl;
  attr.set_value(attr_float_image_ro_read, kImagLen, kImagLen);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_short_image_ro
// 
// description : 	Extract real attribute values for short_image_ro acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_short_image_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_short_image_ro(Tango::Attribute &attr) entering... "<< endl;
  attr.set_value(attr_short_image_ro_read, kImagLen, kImagLen);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_long_image_ro
// 
// description : 	Extract real attribute values for long_image_ro acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_long_image_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_long_image_ro(Tango::Attribute &attr) entering... "<< endl;
  attr.set_value(attr_long_image_ro_read, kImagLen, kImagLen);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_double_image_ro
// 
// description : 	Extract real attribute values for double_image_ro acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_double_image_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_double_image_ro(Tango::Attribute &attr) entering... "<< endl;
  attr.set_value(attr_double_image_ro_read, kImagLen, kImagLen);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_boolean_image_ro
// 
// description : 	Extract real attribute values for boolean_image_ro acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_boolean_image_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_boolean_image_ro(Tango::Attribute &attr) entering... "<< endl;
  attr.set_value(attr_boolean_image_ro_read, kImagLen, kImagLen);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_float_spectrum_ro
// 
// description : 	Extract real attribute values for float_spectrum_ro acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_float_spectrum_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_float_spectrum_ro(Tango::Attribute &attr) entering... "<< endl;
  attr.set_value(attr_float_spectrum_ro_read, kSpecLen);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_long_spectrum_ro
// 
// description : 	Extract real attribute values for long_spectrum_ro acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_long_spectrum_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_long_spectrum_ro(Tango::Attribute &attr) entering... "<< endl;
  attr.set_value(attr_long_spectrum_ro_read, kSpecLen);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_double_spectrum_ro
// 
// description : 	Extract real attribute values for double_spectrum_ro acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_double_spectrum_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_double_spectrum_ro(Tango::Attribute &attr) entering... "<< endl;
  attr.set_value(attr_double_spectrum_ro_read, kSpecLen);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_boolean_spectrum_ro
// 
// description : 	Extract real attribute values for boolean_spectrum_ro acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_boolean_spectrum_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_boolean_spectrum_ro(Tango::Attribute &attr) entering... "<< endl;
  attr.set_value(attr_boolean_spectrum_ro_read, kSpecLen);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_uchar_spectrum_ro
// 
// description : 	Extract real attribute values for uchar_spectrum_ro acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_uchar_spectrum_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_uchar_spectrum_ro(Tango::Attribute &attr) entering... "<< endl;
  attr.set_value(attr_uchar_spectrum_ro_read, kSpecLen);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_ushort_spectrum_ro
// 
// description : 	Extract real attribute values for ushort_spectrum_ro acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_ushort_spectrum_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_ushort_spectrum_ro(Tango::Attribute &attr) entering... "<< endl;
  attr.set_value(attr_ushort_spectrum_ro_read, kSpecLen);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_short_spectrum_ro
// 
// description : 	Extract real attribute values for short_spectrum_ro acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_short_spectrum_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_short_spectrum_ro(Tango::Attribute &attr) entering... "<< endl;
  attr.set_value(attr_short_spectrum_ro_read, kSpecLen);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_long_spectrum
// 
// description : 	Extract real attribute values for long_spectrum acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_long_spectrum(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_long_spectrum(Tango::Attribute &attr) entering... "<< endl;

  attr.set_value(attr_long_spectrum_read, dimLongSpectrum);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::write_long_spectrum
// 
// description : 	Write long_spectrum attribute values to hardware.
//
//-----------------------------------------------------------------------------
void TangoTest::write_long_spectrum(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_long_spectrum(Tango::WAttribute &attr) entering... "<< endl;

  const long * p;
  attr.get_write_value(p);

  long len = attr.get_write_value_length();
  DEBUG_STREAM << "Length :" << len << endl;

  len = (len <= kSpecLen) ? len : kSpecLen;

  ::memcpy(attr_long_spectrum_read, p, len * sizeof(Tango::DevLong));

  dimLongSpectrum = len;
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_double_spectrum
// 
// description : 	Extract real attribute values for double_spectrum acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_double_spectrum(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_double_spectrum(Tango::Attribute &attr) entering... "<< endl;
  attr.set_value(attr_double_spectrum_read, dimDoubleSpectrum);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::write_double_spectrum
// 
// description : 	Write double_spectrum attribute values to hardware.
//
//-----------------------------------------------------------------------------
void TangoTest::write_double_spectrum(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_double_spectrum(Tango::WAttribute &attr) entering... "<< endl;
  //attr.get_write_value(attr_double_spectrum_write);

  const double * p;
  attr.get_write_value(p);

  long len = attr.get_write_value_length();
  DEBUG_STREAM << "Length :" << len << endl;

  len = (len <= kSpecLen) ? len : kSpecLen;

  ::memcpy(attr_double_spectrum_read, p, len * sizeof(Tango::DevDouble));

  dimDoubleSpectrum = len;
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_boolean_spectrum
// 
// description : 	Extract real attribute values for boolean_spectrum acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_boolean_spectrum(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_boolean_spectrum(Tango::Attribute &attr) entering... "<< endl;
  attr.set_value(attr_boolean_spectrum_read, dimBooleanSpectrum);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::write_boolean_spectrum
// 
// description : 	Write boolean_spectrum attribute values to hardware.
//
//-----------------------------------------------------------------------------
void TangoTest::write_boolean_spectrum(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_boolean_spectrum(Tango::WAttribute &attr) entering... "<< endl;
  //attr.get_write_value(attr_boolean_spectrum_write);

  const bool * p;
  attr.get_write_value(p);

  long len = attr.get_write_value_length();
  DEBUG_STREAM << "Length :" << len << endl;

  len = (len <= kSpecLen) ? len : kSpecLen;

  ::memcpy(attr_boolean_spectrum_read, p, len * sizeof(Tango::DevBoolean));

  dimBooleanSpectrum = len;
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_uchar_spectrum
// 
// description : 	Extract real attribute values for uchar_spectrum acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_uchar_spectrum(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_uchar_spectrum(Tango::Attribute &attr) entering... "<< endl;
  attr.set_value(attr_uchar_spectrum_read, dimUcharSpectrum);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::write_uchar_spectrum
// 
// description : 	Write uchar_spectrum attribute values to hardware.
//
//-----------------------------------------------------------------------------
void TangoTest::write_uchar_spectrum(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_uchar_spectrum(Tango::WAttribute &attr) entering... "<< endl;
  //attr.get_write_value(attr_uchar_spectrum_write);
  const unsigned char * p;
  attr.get_write_value(p);

  long len = attr.get_write_value_length();
  DEBUG_STREAM << "Length :" << len << endl;

  len = (len <= kSpecLen) ? len : kSpecLen;

  ::memcpy(attr_uchar_spectrum_read, p, len * sizeof(Tango::DevUChar));

  dimUcharSpectrum = len;

}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_ushort_spectrum
// 
// description : 	Extract real attribute values for ushort_spectrum acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_ushort_spectrum(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_ushort_spectrum(Tango::Attribute &attr) entering... "<< endl;
  attr.set_value(attr_ushort_spectrum_read, dimUshortSpectrum);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::write_ushort_spectrum
// 
// description : 	Write ushort_spectrum attribute values to hardware.
//
//-----------------------------------------------------------------------------
void TangoTest::write_ushort_spectrum(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_ushort_spectrum(Tango::WAttribute &attr) entering... "<< endl;
  //attr.get_write_value(attr_ushort_spectrum_write);

  const unsigned short * p;
  attr.get_write_value(p);

  long len = attr.get_write_value_length();
  DEBUG_STREAM << "Length :" << len << endl;

  len = (len <= kSpecLen) ? len : kSpecLen;

  ::memcpy(attr_ushort_spectrum_read, p, len * sizeof(Tango::DevUShort));

  dimUshortSpectrum = len;

}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_float_spectrum
// 
// description : 	Extract real attribute values for float_spectrum acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_float_spectrum(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_float_spectrum(Tango::Attribute &attr) entering... "<< endl;
  attr.set_value(attr_float_spectrum_read, dimFloatSpectrum);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::write_float_spectrum
// 
// description : 	Write float_spectrum attribute values to hardware.
//
//-----------------------------------------------------------------------------
void TangoTest::write_float_spectrum(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_float_spectrum(Tango::WAttribute &attr) entering... "<< endl;
  //attr.get_write_value(attr_float_spectrum_write);

  const float * p;
  attr.get_write_value(p);

  long len = attr.get_write_value_length();
  DEBUG_STREAM << "Length :" << len << endl;

  len = (len <= kSpecLen) ? len : kSpecLen;

  ::memcpy(attr_float_spectrum_read, p, len * sizeof(Tango::DevFloat));

  dimFloatSpectrum = len;
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_short_spectrum
// 
// description : 	Extract real attribute values for short_spectrum acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_short_spectrum(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_short_spectrum(Tango::Attribute &attr) entering... "<< endl;
  attr.set_value(attr_short_spectrum_read, dimShortSpectrum);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::write_short_spectrum
// 
// description : 	Extract real attribute values for short_spectrum acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::write_short_spectrum(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_short_spectrum(Tango::WAttribute &attr) entering... "<< endl;
  
  long len = attr.get_write_value_length();
  DEBUG_STREAM << "Length :" << len << endl;
  
  const short * p;
  attr.get_write_value(p);

  len = attr.get_write_value_length();
  DEBUG_STREAM << "Length from get_write_value_length:" << len << endl;

  len = (len <= kSpecLen) ? len : kSpecLen;

  DEBUG_STREAM << "Final length:" << len << endl;

  ::memcpy(attr_short_spectrum_read, p, len * sizeof(Tango::DevShort));
  dimShortSpectrum = len;

  //::memcpy(attr_short_spectrum_read, p, len * sizeof(Tango::DevShort));
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_uchar_scalar
// 
// description : 	Extract real attribute values for uchar_scalar acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_uchar_scalar(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_uchar_scalar(Tango::Attribute &attr) entering... "<< endl;
	attr.set_value(attr_uchar_scalar_read);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::write_uchar_scalar
// 
// description : 	Write uchar_scalar attribute values to hardware.
//
//-----------------------------------------------------------------------------
void TangoTest::write_uchar_scalar(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_uchar_scalar(Tango::WAttribute &attr) entering... "<< endl;
	attr.get_write_value(attr_uchar_scalar_write);
  DEBUG_STREAM << "attr_uchar_scalar_write = " << attr_uchar_scalar_write << endl;
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_ushort_scalar
// 
// description : 	Extract real attribute values for ushort_scalar acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_ushort_scalar(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_ushort_scalar(Tango::Attribute &attr) entering... "<< endl;
	attr.set_value(attr_ushort_scalar_read);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::write_ushort_scalar
// 
// description : 	Write ushort_scalar attribute values to hardware.
//
//-----------------------------------------------------------------------------
void TangoTest::write_ushort_scalar(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_ushort_scalar(Tango::WAttribute &attr) entering... "<< endl;
	attr.get_write_value(attr_ushort_scalar_write);
  DEBUG_STREAM << "attr_ushort_scalar_write = " << attr_ushort_scalar_write << endl;
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_float_scalar
// 
// description : 	Extract real attribute values for float_scalar acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_float_scalar(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_float_scalar(Tango::Attribute &attr) entering... "<< endl;
	attr.set_value(attr_float_scalar_read);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::write_float_scalar
// 
// description : 	Write float_scalar attribute values to hardware.
//
//-----------------------------------------------------------------------------
void TangoTest::write_float_scalar(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_float_scalar(Tango::WAttribute &attr) entering... "<< endl;
	attr.get_write_value(attr_float_scalar_write);
  DEBUG_STREAM << "attr_float_scalar_write = " << attr_float_scalar_write << endl;
}


//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_boolean_scalar
// 
// description : 	Extract real attribute values for boolean_scalar acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_boolean_scalar(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_boolean_scalar(Tango::Attribute &attr) entering... "<< endl;
	attr.set_value(attr_boolean_scalar_read);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::write_boolean_scalar
// 
// description : 	Write boolean_scalar attribute values to hardware.
//
//-----------------------------------------------------------------------------
void TangoTest::write_boolean_scalar(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_boolean_scalar(Tango::WAttribute &attr) entering... "<< endl;
	attr.get_write_value(attr_boolean_scalar_write);
	*attr_boolean_scalar_read = attr_boolean_scalar_write;
	DEBUG_STREAM << "Read and write attributes were set to the same value" << endl;
    DEBUG_STREAM << "attr_boolean_scalar_write = " << attr_boolean_scalar_write << endl;
	DEBUG_STREAM << "attr_boolean_scalar_read = " << *attr_boolean_scalar_read << endl;
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_short_scalar_ro
// 
// description : 	Extract real attribute values for short_scalar_ro acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_short_scalar_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_short_scalar_ro(Tango::Attribute &attr) entering... "<< endl;
	attr.set_value(attr_short_scalar_ro_read);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_short_scalar
// 
// description : 	Extract real attribute values for short_scalar acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_short_scalar(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_short_scalar(Tango::Attribute &attr) entering... "<< endl;
	attr.set_value(attr_short_scalar_read);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::write_short_scalar
// 
// description : 	Write short_scalar attribute values to hardware.
//
//-----------------------------------------------------------------------------
void TangoTest::write_short_scalar(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_short_scalar(Tango::WAttribute &attr) entering... "<< endl;
	attr.get_write_value(attr_short_scalar_write);
    DEBUG_STREAM << "attr_short_scalar_write = " << attr_short_scalar_write << endl;
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_long_scalar
// 
// description : 	Extract real attribute values for long_scalar acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_long_scalar(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_long_scalar(Tango::Attribute &attr) entering... "<< endl;
	attr.set_value(attr_long_scalar_read);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::write_long_scalar
// 
// description : 	Write long_scalar attribute values to hardware.
//
//-----------------------------------------------------------------------------
void TangoTest::write_long_scalar(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_long_scalar(Tango::WAttribute &attr) entering... "<< endl;
   attr.get_write_value(attr_long_scalar_write);
    DEBUG_STREAM << "attr_long_scalar_write = " << attr_long_scalar_write << endl;
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_double_scalar
// 
// description : 	Extract real attribute values for double_scalar acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_double_scalar(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_double_scalar(Tango::Attribute &attr) entering... "<< endl;
	attr.set_value(attr_double_scalar_read);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::write_double_scalar
// 
// description : 	Write double_scalar attribute values to hardware.
//
//-----------------------------------------------------------------------------
void TangoTest::write_double_scalar(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_double_scalar(Tango::WAttribute &attr) entering... "<< endl;
	attr.get_write_value(attr_double_scalar_write);
    DEBUG_STREAM << "attr_double_scalar_write = " << attr_double_scalar_write << endl;
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_string_scalar
// 
// description : 	Extract real attribute values for string_scalar acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_string_scalar(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_string_scalar(Tango::Attribute &attr) entering... "<< endl;
	attr.set_value(attr_string_scalar_read);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::write_string_scalar
// 
// description : 	Write string_scalar attribute values to hardware.
//
//-----------------------------------------------------------------------------
void TangoTest::write_string_scalar(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_string_scalar(Tango::WAttribute &attr) entering... "<< endl;
    attr.get_write_value(attr_string_scalar_write);
    DEBUG_STREAM << "attr_string_scalar_write = " << attr_string_scalar_write << endl;
    if (*attr_string_scalar_read) {
      delete[] *attr_string_scalar_read;
      size_t len = ::strlen(attr_string_scalar_write) + 1;
      *attr_string_scalar_read = new char[len];
      if (*attr_string_scalar_read) {
        ::memset(*attr_string_scalar_read, 0, len * sizeof(char));
        ::strcpy(*attr_string_scalar_read, attr_string_scalar_write);
      }
    }
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_short_scalar_w
// 
// description : 	Extract real attribute values for short_scalar_w acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_short_scalar_w(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_short_scalar_w(Tango::Attribute &attr) entering... "<< endl;
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::write_short_scalar_w
// 
// description : 	Write short_scalar_w attribute values to hardware.
//
//-----------------------------------------------------------------------------
void TangoTest::write_short_scalar_w(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_short_scalar_w(Tango::WAttribute &attr) entering... "<< endl;
	attr.get_write_value(attr_short_scalar_w_write);
    DEBUG_STREAM << "short_scalar_w = " << attr_short_scalar_w_write << endl;
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_short_scalar_rww
// 
// description : 	Extract real attribute values for short_scalar_rww acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_short_scalar_rww(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_short_scalar_rww(Tango::Attribute &attr) entering... "<< endl;
	attr.set_value(attr_short_scalar_rww_read);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_long_scalar_w
// 
// description : 	Extract real attribute values for long_scalar_w acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_long_scalar_w(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_long_scalar_w(Tango::Attribute &attr) entering... "<< endl;
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::write_long_scalar_w
// 
// description : 	Write long_scalar_w attribute values to hardware.
//
//-----------------------------------------------------------------------------
void TangoTest::write_long_scalar_w(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_long_scalar_w(Tango::WAttribute &attr) entering... "<< endl;
	attr.get_write_value(attr_long_scalar_w_write);
    DEBUG_STREAM << "long_scalar_w = " << attr_long_scalar_w_write << endl;
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_long_scalar_rww
// 
// description : 	Extract real attribute values for long_scalar_rww acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_long_scalar_rww(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_long_scalar_rww(Tango::Attribute &attr) entering... "<< endl;
	attr.set_value(attr_long_scalar_rww_read);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_double_scalar_w
// 
// description : 	Extract real attribute values for double_scalar_w acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_double_scalar_w(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_double_scalar_w(Tango::Attribute &attr) entering... "<< endl;
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::write_double_scalar_w
// 
// description : 	Write double_scalar_w attribute values to hardware.
//
//-----------------------------------------------------------------------------
void TangoTest::write_double_scalar_w(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_double_scalar_w(Tango::WAttribute &attr) entering... "<< endl;
	attr.get_write_value(attr_double_scalar_w_write);
    DEBUG_STREAM << "double_scalar_w = " << attr_double_scalar_w_write << endl;
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_double_scalar_rww
// 
// description : 	Extract real attribute values for double_scalar_rww acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_double_scalar_rww(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_double_scalar_rww(Tango::Attribute &attr) entering... "<< endl;
	attr.set_value(attr_double_scalar_rww_read);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_ampli
// 
// description : 	Extract real attribute values for ampli acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_ampli(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_ampli(Tango::Attribute &attr) entering... "<< endl;
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::write_ampli
// 
// description : 	Write ampli attribute values to hardware.
//
//-----------------------------------------------------------------------------
void TangoTest::write_ampli(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_ampli(Tango::WAttribute &attr) entering... "<< endl;
	attr.get_write_value(attr_ampli_write);
    DEBUG_STREAM << "ampli = " << attr_ampli_write << endl;
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::read_wave
// 
// description : 	Extract real attribute values for wave acquisition result.
//
//-----------------------------------------------------------------------------
void TangoTest::read_wave(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_wave(Tango::Attribute &attr) entering... "<< endl;
	attr.set_value(attr_wave_read, kSpecLen);
}


//+------------------------------------------------------------------
/**
 *	method:	TangoTest::dev_void
 *
 *	description:	method to execute "DevVoid"
 *	A DevVoid comand example
 *
 *
 */
//+------------------------------------------------------------------
void TangoTest::dev_void()
{
	DEBUG_STREAM << "TangoTest::dev_void(): entering... !" << endl;
	//	Add your own code to control device here
}

//+------------------------------------------------------------------
/**
 *	method:	TangoTest::dev_boolean
 *
 *	description:	method to execute "DevBoolean"
 *	A DevBoolean comand example
 *
 * @param	argin	Any boolean value
 * @return	Echo of the argin value
 *
 */
//+------------------------------------------------------------------
Tango::DevBoolean TangoTest::dev_boolean(Tango::DevBoolean argin)
{
	DEBUG_STREAM << "TangoTest::dev_boolean(): entering... !" << endl;
  
  // Tangotest : just send back input argument
	return argin;
}

//+------------------------------------------------------------------
/**
 *	method:	TangoTest::dev_short
 *
 *	description:	method to execute "DevShort"
 *	A DevShort command example
 *
 * @param	argin	Any DevShort value
 * @return	Echo of the argin value
 *
 */
//+------------------------------------------------------------------
Tango::DevShort TangoTest::dev_short(Tango::DevShort argin)
{
	DEBUG_STREAM << "TangoTest::dev_short(): entering... !" << endl;
  
  // Tangotest : just send back input argument
	return argin;
}

//+------------------------------------------------------------------
/**
 *	method:	TangoTest::dev_ushort
 *
 *	description:	method to execute "DevUShort"
 *	A DevUShort command example
 *
 * @param	argin	Any DevUShort value
 * @return	Echo of the argin value
 *
 */
//+------------------------------------------------------------------
Tango::DevUShort TangoTest::dev_ushort(Tango::DevUShort argin)
{
	DEBUG_STREAM << "TangoTest::dev_ushort(): entering... !" << endl;
  
  // Tangotest : just send back input argument
	return argin;
}

//+------------------------------------------------------------------
/**
 *	method:	TangoTest::dev_long
 *
 *	description:	method to execute "DevLong"
 *	A DevLong command example
 *
 * @param	argin	Any DevLong value
 * @return	Echo of the argin value
 *
 */
//+------------------------------------------------------------------
Tango::DevLong TangoTest::dev_long(Tango::DevLong argin)
{
	DEBUG_STREAM << "TangoTest::dev_long(): entering... !" << endl;
  
  // Tangotest : just send back input argument
	return argin;
}

//+------------------------------------------------------------------
/**
 *	method:	TangoTest::dev_ulong
 *
 *	description:	method to execute "DevULong"
 *	A DevULong command example
 *
 * @param	argin	Any DevULong
 * @return	Echo of the argin value
 *
 */
//+------------------------------------------------------------------
Tango::DevULong TangoTest::dev_ulong(Tango::DevULong argin)
{
	DEBUG_STREAM << "TangoTest::dev_ulong(): entering... !" << endl;
  
  // Tangotest : just send back input argument
	return argin;
}

//+------------------------------------------------------------------
/**
 *	method:	TangoTest::dev_float
 *
 *	description:	method to execute "DevFloat"
 *	A DevFloat command example
 *
 * @param	argin	Any DevFloat value
 * @return	Echo of the argin value
 *
 */
//+------------------------------------------------------------------
Tango::DevFloat TangoTest::dev_float(Tango::DevFloat argin)
{
	DEBUG_STREAM << "TangoTest::dev_float(): entering... !" << endl;
  
  // Tangotest : just send back input argument
	return argin;
}

//+------------------------------------------------------------------
/**
 *	method:	TangoTest::dev_double
 *
 *	description:	method to execute "DevDouble"
 *	A DevDouble command example
 *
 * @param	argin	Any DevDouble value
 * @return	Echo of the argin value
 *
 */
//+------------------------------------------------------------------
Tango::DevDouble TangoTest::dev_double(Tango::DevDouble argin)
{
	DEBUG_STREAM << "TangoTest::dev_double(): entering... !" << endl;
  
  // Tangotest : just send back input argument
	return argin;
}

//+------------------------------------------------------------------
/**
 *	method:	TangoTest::dev_string
 *
 *	description:	method to execute "DevString"
 *	none
 *
 * @param	argin	-
 * @return	-
 *
 */
//+------------------------------------------------------------------
Tango::DevString TangoTest::dev_string(Tango::DevString argin)
{
  DEBUG_STREAM << "TangoTest::dev_string(): entering... !" << endl;

  // Allocate argout
  Tango::DevString argout = new char [::strlen(argin) + 1];
  if (argout == 0) {
    TangoSys_OMemStream o;
    o << "Failed to allocate Tango::DevString" << ends;
    LOG_ERROR((o.str()));
    Tango::Except::throw_exception((const char *)"Out of memory error",
						                       o.str(),
						                       (const char *)"TangoTest::dev_string");
  }

  // Tangotest : just send back input argument
	::strcpy(argout, argin);

	return argout;
} 

//+------------------------------------------------------------------
/**
 *	method:	TangoTest::dev_var_char_array
 *
 *	description:	method to execute "DevVarCharArray"
 *	none
 *
 * @param	argin	-
 * @return	-
 *
 */
//+------------------------------------------------------------------
Tango::DevVarCharArray *TangoTest::dev_var_char_array(const Tango::DevVarCharArray *argin)
{
  DEBUG_STREAM << "TangoTest::dev_var_char_array(): entering... !" << endl;

  // Allocate argout
	Tango::DevVarCharArray *argout = new Tango::DevVarCharArray();
  if (argout == 0) {
    TangoSys_OMemStream o;
    o << "Failed to allocate Tango::DevVarCharArray" << ends;
    LOG_ERROR((o.str()));
    Tango::Except::throw_exception((const char *)"Out of memory error",
						                       o.str(),
						                       (const char *)"TangoTest::dev_var_char_array");
  }

  // Tangotest : just send back input argument
  argout->length(argin->length());
  for (unsigned int i = 0; i < argin->length(); i++) {
    (*argout)[i] = (*argin)[i];
  }

  // DO NOT DELETE <argin>
  // See the TANGO programmer's manual section 7.2.3
  // for more info about C++ memory management.

	return argout;
}

//+------------------------------------------------------------------
/**
 *	method:	TangoTest::dev_var_short_array
 *
 *	description:	method to execute "DevVarShortArray"
 *	none
 *
 * @param	argin	-
 * @return	-
 *
 */
//+------------------------------------------------------------------
Tango::DevVarShortArray *TangoTest::dev_var_short_array(const Tango::DevVarShortArray *argin)
{
	DEBUG_STREAM << "TangoTest::dev_var_short_array(): entering... !" << endl;

  // Allocate argout
  Tango::DevVarShortArray	*argout = new Tango::DevVarShortArray();
  if (argout == 0) {
    TangoSys_OMemStream o;
    o << "Failed to allocate Tango::DevVarShortArray" << ends;
    LOG_ERROR((o.str()));
    Tango::Except::throw_exception((const char *)"Out of memory error",
						                       o.str(),
						                       (const char *)"TangoTest::dev_var_short_array");
  }

  // Tangotest : just send back input argument
  argout->length(argin->length());
  for (unsigned int i = 0; i < argin->length(); i++) {
    (*argout)[i] = (*argin)[i];
  }

  // DO NOT DELETE <argin>
  // See the TANGO programmer's manual section 7.2.3
  // for more info about C++ memory management.

	return argout;
}

//+------------------------------------------------------------------
/**
 *	method:	TangoTest::dev_var_ushort_array
 *
 *	description:	method to execute "DevVarUShortArray"
 *	none
 *
 * @param	argin	-
 * @return	-
 *
 */
//+------------------------------------------------------------------
Tango::DevVarUShortArray *TangoTest::dev_var_ushort_array(const Tango::DevVarUShortArray *argin)
{
	DEBUG_STREAM << "TangoTest::dev_var_ushort_array(): entering... !" << endl;

  // Allocate argout
	Tango::DevVarUShortArray	*argout = new Tango::DevVarUShortArray();
  if (argout == 0) {
    TangoSys_OMemStream o;
    o << "Failed to allocate Tango::DevVarUShortArray" << ends;
    LOG_ERROR((o.str()));
    Tango::Except::throw_exception((const char *)"Out of memory error",
						                       o.str(),
						                       (const char *)"TangoTest::dev_var_ushort_array");
  }

  // Tangotest : just send back input argument
  argout->length(argin->length());
  for (unsigned int i = 0; i < argin->length(); i++) {
    (*argout)[i] = (*argin)[i];
  }

  // DO NOT DELETE <argin>
  // See the TANGO programmer's manual section 7.2.3
  // for more info about C++ memory management.

	return argout;
}

//+------------------------------------------------------------------
/**
 *	method:	TangoTest::dev_var_long_array
 *
 *	description:	method to execute "DevVarLongArray"
 *	none
 *
 * @param	argin	-
 * @return	-
 *
 */
//+------------------------------------------------------------------
Tango::DevVarLongArray *TangoTest::dev_var_long_array(const Tango::DevVarLongArray *argin)
{
	DEBUG_STREAM << "TangoTest::dev_var_long_array(): entering... !" << endl;

  // Allocate argout
  Tango::DevVarLongArray	*argout = new Tango::DevVarLongArray();
  if (argout == 0) {
    TangoSys_OMemStream o;
    o << "Failed to allocate Tango::DevVarLongArray" << ends;
    LOG_ERROR((o.str()));
    Tango::Except::throw_exception((const char *)"Out of memory error",
						                       o.str(),
						                       (const char *)"TangoTest::dev_var_long_array");
  }

  // Tangotest : just send back input argument
  argout->length(argin->length());
  for (unsigned int i = 0; i < argin->length(); i++) {
    (*argout)[i] = (*argin)[i];
  }

  // DO NOT DELETE <argin>
  // See the TANGO programmer's manual section 7.2.3
  // for more info about C++ memory management.

	return argout;
}

//+------------------------------------------------------------------
/**
 *	method:	TangoTest::dev_var_ulong_array
 *
 *	description:	method to execute "DevVarULongArray"
 *	none
 *
 * @param	argin	-
 * @return	-
 *
 */
//+------------------------------------------------------------------
Tango::DevVarULongArray *TangoTest::dev_var_ulong_array(const Tango::DevVarULongArray *argin)
{
	DEBUG_STREAM << "TangoTest::dev_var_ulong_array(): entering... !" << endl;

  // Allocate argout
	Tango::DevVarULongArray	*argout = new Tango::DevVarULongArray();
  if (argout == 0) {
    TangoSys_OMemStream o;
    o << "Failed to allocate Tango::DevVarULongArray" << ends;
    LOG_ERROR((o.str()));
    Tango::Except::throw_exception((const char *)"Out of memory error",
						                       o.str(),
						                       (const char *)"TangoTest::dev_var_ulong_array");
  }

  // Tangotest : just send back input argument
  argout->length(argin->length());
  for (unsigned int i = 0; i < argin->length(); i++) {
    (*argout)[i] = (*argin)[i];
  }

  // DO NOT DELETE <argin>
  // See the TANGO programmer's manual section 7.2.3
  // for more info about C++ memory management.

	return argout;
}

//+------------------------------------------------------------------
/**
 *	method:	TangoTest::dev_var_float_array
 *
 *	description:	method to execute "DevVarFloatArray"
 *	none
 *
 * @param	argin	-
 * @return	-
 *
 */
//+------------------------------------------------------------------
Tango::DevVarFloatArray *TangoTest::dev_var_float_array(const Tango::DevVarFloatArray *argin)
{
  DEBUG_STREAM << "TangoTest::dev_var_float_array(): entering... !" << endl;

  // Allocate argout
	Tango::DevVarFloatArray	*argout = new Tango::DevVarFloatArray();
  if (argout == 0) {
    TangoSys_OMemStream o;
    o << "Failed to allocate Tango::DevVarFloatArray" << ends;
    LOG_ERROR((o.str()));
    Tango::Except::throw_exception((const char *)"Out of memory error",
						                       o.str(),
						                       (const char *)"TangoTest::dev_var_float_array");
  }

  // Tangotest : just send back input argument
  argout->length(argin->length());
  for (unsigned int i = 0; i < argin->length(); i++) {
    (*argout)[i] = (*argin)[i];
  }

  // DO NOT DELETE <argin>
  // See the TANGO programmer's manual section 7.2.3
  // for more info about C++ memory management.

	return argout;
}

//+------------------------------------------------------------------
/**
 *	method:	TangoTest::dev_var_double_array
 *
 *	description:	method to execute "DevVarDoubleArray"
 *	none
 *
 * @param	argin	-
 * @return	-
 *
 */
//+------------------------------------------------------------------
Tango::DevVarDoubleArray *TangoTest::dev_var_double_array(const Tango::DevVarDoubleArray *argin)
{
	DEBUG_STREAM << "TangoTest::dev_var_double_array(): entering... !" << endl;

  // Allocate argout
	Tango::DevVarDoubleArray	*argout = new Tango::DevVarDoubleArray();
  if (argout == 0) {
    TangoSys_OMemStream o;
    o << "Failed to allocate Tango::DevVarDoubleArray" << ends;
    LOG_ERROR((o.str()));
    Tango::Except::throw_exception((const char *)"Out of memory error",
						                       o.str(),
						                       (const char *)"TangoTest::dev_var_double_array");
  }

  // Tangotest : just send back input argument
  argout->length(argin->length());
  for (unsigned int i = 0; i < argin->length(); i++) {
    (*argout)[i] = (*argin)[i];
  }

  // DO NOT DELETE <argin>
  // See the TANGO programmer's manual section 7.2.3
  // for more info about C++ memory management.

	return argout;
}

//+------------------------------------------------------------------
/**
 *	method:	TangoTest::dev_var_string_array
 *
 *	description:	method to execute "DevVarStringArray"
 *	none
 *
 * @param	argin	-
 * @return	-
 *
 */
//+------------------------------------------------------------------
Tango::DevVarStringArray *TangoTest::dev_var_string_array(const Tango::DevVarStringArray *argin)
{
  DEBUG_STREAM << "TangoTest::dev_var_string_array(): entering... !" << endl;

  // Allocate argout
	Tango::DevVarStringArray	*argout = new Tango::DevVarStringArray();
  if (argout == 0) {
    TangoSys_OMemStream o;
    o << "Failed to allocate Tango::DevVarStringArray" << ends;
    LOG_ERROR((o.str()));
    Tango::Except::throw_exception((const char *)"Out of memory error",
						                       o.str(),
						                       (const char *)"TangoTest::dev_var_string_array");
  }

  // Tangotest : just send back input argument
  argout->length(argin->length());
  for (unsigned int i = 0; i < argin->length(); i++) {
    (*argout)[i] = CORBA::string_dup((*argin)[i]);
  }

  // DO NOT DELETE <argin>
  // See the TANGO programmer's manual section 7.2.3
  // for more info about C++ memory management.

	return argout;
}

//+------------------------------------------------------------------
/**
 *	method:	TangoTest::dev_var_long_string_array
 *
 *	description:	method to execute "DevVarLongStringArray"
 *	none
 *
 * @param	argin	-
 * @return	-
 *
 */
//+------------------------------------------------------------------
Tango::DevVarLongStringArray *TangoTest::dev_var_long_string_array(const Tango::DevVarLongStringArray *argin)
{
	DEBUG_STREAM << "TangoTest::dev_var_long_string_array(): entering... !" << endl;

  // Allocate argout
	Tango::DevVarLongStringArray	*argout = new Tango::DevVarLongStringArray();
  if (argout == 0) {
    TangoSys_OMemStream o;
    o << "Failed to allocate Tango::DevVarLongStringArray" << ends;
    LOG_ERROR((o.str()));
    Tango::Except::throw_exception((const char *)"Out of memory error",
						                       o.str(),
						                       (const char *)"TangoTest::dev_var_long_string_array");
  }

  // Tangotest : just send back input argument
  argout->lvalue = argin->lvalue;
  argout->svalue.length(argin->svalue.length());
  for (unsigned int i = 0; i < argin->svalue.length(); i++) {
    argout->svalue[i] = CORBA::string_dup(argin->svalue[i]);
  }

  // DO NOT DELETE <argin>
  // See the TANGO programmer's manual section 7.2.3
  // for more info about C++ memory management.

	return argout;
}

//+------------------------------------------------------------------
/**
 *	method:	TangoTest::dev_var_double_string_array
 *
 *	description:	method to execute "DevVarDoubleStringArray"
 *	none
 *
 * @param	argin	-
 * @return	-
 *
 */
//+------------------------------------------------------------------
Tango::DevVarDoubleStringArray *TangoTest::dev_var_double_string_array(const Tango::DevVarDoubleStringArray *argin)
{
	DEBUG_STREAM << "TangoTest::dev_var_double_string_array(): entering... !" << endl;

  // Allocate argout
  Tango::DevVarDoubleStringArray *argout = new Tango::DevVarDoubleStringArray();
  if (argout == 0) {
    TangoSys_OMemStream o;
    o << "Failed to allocate Tango::DevVarDoubleStringArray" << ends;
    LOG_ERROR((o.str()));
    Tango::Except::throw_exception((const char *)"Out of memory error",
						                       o.str(),
						                       (const char *)"TangoTest::dev_var_double_string_array");
  }

  // Tangotest : just send back input argument
  argout->dvalue = argin->dvalue;
  argout->svalue.length(argin->svalue.length());
  for (unsigned int i = 0; i < argin->svalue.length(); i++) {
    argout->svalue[i] = CORBA::string_dup(argin->svalue[i]);
  }

  // DO NOT DELETE <argin>
  // See the TANGO programmer's manual section 7.2.3
  // for more info about C++ memory management.

	return argout;
}

//+------------------------------------------------------------------
/**
 *	method:	TangoTest::switch_states
 *
 *	description:	method to execute "SwitchStates"
 *	This command changes the device state from RUNNING to FAULT or from FAULT to RUNNING
 *
 *
 */
//+------------------------------------------------------------------
void TangoTest::switch_states()
{
	DEBUG_STREAM << "TangoTest::switch_states(): entering... !" << endl;

	//	Add your own code to control device here

	if(get_state() == Tango::RUNNING)
	{
		set_state(Tango::FAULT);
	}
	else
	{
		set_state(Tango::RUNNING);
	}

}

}	//	namespace
