/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.filechooser.FileFilter;

public class MultiExtFileFilter
extends FileFilter {
    protected String prefix;
    protected List<String> extensions;
    protected String description;

    public MultiExtFileFilter(String string, String string2, String ... stringArray) {
        this.prefix = string;
        this.extensions = new ArrayList<String>(1 + stringArray.length);
        this.extensions.add(string2);
        for (String string3 : stringArray) {
            this.extensions.add(string3);
        }
        this.computeDescription();
    }

    public boolean accept(File file) {
        boolean bl = false;
        if (file != null) {
            bl |= file.isDirectory();
            String string = MultiExtFileFilter.getExtension(file);
            if (string != null) {
                bl |= this.isAccepted(string);
            }
        }
        return bl;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isAccepted(String string) {
        boolean bl = false;
        for (String string2 : this.extensions) {
            bl |= string2.equalsIgnoreCase(string);
        }
        return bl;
    }

    public String getDefaultExtension() {
        return this.extensions.get(0);
    }

    protected void computeDescription() {
        StringBuilder stringBuilder = new StringBuilder(this.prefix);
        stringBuilder.append(" (");
        Iterator<String> iterator = this.extensions.iterator();
        do {
            String string = iterator.next();
            stringBuilder.append("*.").append(string);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        } while (iterator.hasNext());
        stringBuilder.append(")");
        this.description = stringBuilder.toString();
    }

    public String toString() {
        return this.description;
    }

    public static String getExtension(File file) {
        String string;
        int n;
        String string2 = null;
        if (file != null && (n = (string = file.getName()).lastIndexOf(46)) > 0 && n < string.length() - 1) {
            string2 = string.substring(n + 1).toLowerCase();
        }
        return string2;
    }
}

