/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.JAutoScrolledTextListener;
import fr.esrf.tangoatk.widget.util.ScrollRun;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;

public class JAutoScrolledText
extends JTextField {
    public static int CENTER_ALIGNMENT = 1;
    public static int LEFT_ALIGNMENT = 2;
    public static int RIGHT_ALIGNMENT = 3;
    public static int CLASSIC_BEHAVIOR = 2;
    public static int MATRIX_BEHAVIOR = 1;
    public static final int SCROLL_TO_SEE_END = 0;
    public static final int SCROLL_LOOP = 1;
    private int maxPos = 0;
    private boolean scrollNeeded = false;
    private boolean lastScroll = false;
    private String text;
    private int off_x = 0;
    private int off_y = 0;
    private int align;
    private int sizingBehavior;
    private Insets margin;
    private int scrollingMode = 0;
    int sleepTime = 0;
    boolean endFlag;
    boolean stopDemand;
    int currentPos = 0;
    int waitTime = 2000;
    EventListenerList listenerList;

    public JAutoScrolledText() {
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.align = CENTER_ALIGNMENT;
        this.stopDemand = false;
        this.endFlag = false;
        this.text = "";
        this.margin = new Insets(2, 3, 2, 3);
        this.sizingBehavior = CLASSIC_BEHAVIOR;
        this.listenerList = new EventListenerList();
    }

    public void setMargin(Insets insets) {
        this.margin = insets;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setWaitTime(int n) {
        this.waitTime = n;
    }

    public void setSizingBehavior(int n) {
        this.sizingBehavior = n;
    }

    public int getSizingBehavior() {
        return this.sizingBehavior;
    }

    public Dimension getPreferredSize() {
        if (this.sizingBehavior == MATRIX_BEHAVIOR) {
            return super.getPreferredSize();
        }
        Dimension dimension = ATKGraphicsUtils.measureString(this.text, this.getFont());
        dimension.width += this.margin.right + this.margin.left;
        dimension.height += this.margin.top + this.margin.bottom;
        return dimension;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setAutoScroll(int n) {
        this.sleepTime = n;
    }

    public int getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(int n) {
        this.sleepTime = n;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setText(String string) {
        this.text = string == null ? "" : string;
        this.currentPos = 0;
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    public void setVerticalOffset(int n) {
        this.off_y = n;
        this.repaint();
    }

    public int getVerticalOffset() {
        return this.off_y;
    }

    public void setHorizontalOffset(int n) {
        this.off_x = n;
        this.repaint();
    }

    public int getHorizontalOffset() {
        return this.off_x;
    }

    public void setValueOffsets(int n, int n2) {
        System.out.println("JAutoScrolledText.setValueOffsets() is deprecated and has no effects.");
    }

    public void setHorizontalAlignment(int n) {
        this.align = n;
    }

    void scrollText() throws InterruptedException {
        if (this.scrollNeeded) {
            ++this.currentPos;
            if (this.currentPos > this.maxPos) {
                this.repaint();
                Thread.sleep(this.waitTime);
                this.currentPos = this.scrollingMode == 0 ? 0 : -this.getWidth();
                this.endFlag = true;
            }
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n, n2);
        }
        graphics.setColor(this.getForeground());
        graphics.setFont(this.getFont());
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Rectangle2D rectangle2D = graphics.getFont().getStringBounds(this.text, fontRenderContext);
        int n3 = (int)(rectangle2D.getWidth() - (double)(n - (this.margin.left + this.margin.right)));
        this.maxPos = this.scrollingMode == 0 ? n3 : (int)rectangle2D.getWidth();
        double d = this.getFont().getLineMetrics(this.text, fontRenderContext).getAscent();
        int n4 = (int)(((double)n2 - rectangle2D.getHeight()) / 2.0 + d);
        boolean bl = this.scrollNeeded = n3 > 0;
        if (this.scrollNeeded) {
            this.fireExceedBounds();
        }
        if (this.lastScroll != this.scrollNeeded && this.sleepTime != 0) {
            if (this.scrollNeeded) {
                this.currentPos = 0;
                this.stopDemand = false;
                this.endFlag = true;
                ScrollRun scrollRun = new ScrollRun(this);
                new Thread(scrollRun).start();
            } else {
                this.stopDemand = true;
            }
        }
        this.lastScroll = this.scrollNeeded;
        if (this.scrollNeeded) {
            graphics.drawString(this.text, this.margin.left + this.off_x - this.currentPos, this.off_y + n4);
        } else {
            int n5 = 0;
            switch (this.align) {
                case 1: {
                    n5 = (int)(((double)n - rectangle2D.getWidth()) / 2.0);
                    break;
                }
                case 2: {
                    n5 = this.margin.left;
                    break;
                }
                case 3: {
                    n5 = (int)((double)n - rectangle2D.getWidth() - (double)this.margin.right);
                }
            }
            graphics.drawString(this.text, n5, this.off_y + n4);
        }
        this.paintBorder(graphics);
    }

    public void addTextListener(JAutoScrolledTextListener jAutoScrolledTextListener) {
        this.listenerList.add(JAutoScrolledTextListener.class, jAutoScrolledTextListener);
    }

    public void removeTextListener(JAutoScrolledTextListener jAutoScrolledTextListener) {
        this.listenerList.remove(JAutoScrolledTextListener.class, jAutoScrolledTextListener);
    }

    private void fireExceedBounds() {
        if (this.listenerList.getListenerCount() > 0) {
            JAutoScrolledTextListener[] jAutoScrolledTextListenerArray = (JAutoScrolledTextListener[])this.listenerList.getListeners(JAutoScrolledTextListener.class);
            for (int i = 0; i < jAutoScrolledTextListenerArray.length; ++i) {
                jAutoScrolledTextListenerArray[i].textExceedBounds(this);
            }
        }
    }

    public int getScrollingMode() {
        return this.scrollingMode;
    }

    public void setScrollingMode(int n) {
        this.scrollingMode = n;
    }

    public static void main(String[] stringArray) throws Exception {
        JFrame jFrame = new JFrame();
        JAutoScrolledText jAutoScrolledText = new JAutoScrolledText();
        jAutoScrolledText.setText("Test JAutoScrolledText , with autoscrolling....");
        jAutoScrolledText.setAutoScroll(30);
        jAutoScrolledText.setFont(new Font("Dialog", 1, 30));
        jFrame.setContentPane(jAutoScrolledText);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

