/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.TableRowModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JOptionPane;

public class EditableTableRowModel
extends TableRowModel {
    public EditableTableRowModel() {
        this.editable = true;
        this.data = new Object[0][0];
        this.colName = new String[2];
        this.colName[0] = "Index";
    }

    public void setEditable(boolean bl) {
    }

    public boolean isEditable() {
        return true;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (!this.editable || this.data == null) {
            return;
        }
        if (n2 < 1) {
            return;
        }
        this.data[n][n2] = object;
        if (n == this.data.length - 1) {
            Object[][] objectArray = new Object[this.data.length + 1][2];
            System.arraycopy(this.data, 0, objectArray, 0, this.data.length);
            double d = this.data.length;
            objectArray[this.data.length][0] = Double.toString(d);
            objectArray[this.data.length][1] = null;
            this.data = objectArray;
            this.fireTableRowsInserted(objectArray.length - 1, objectArray.length - 1);
        }
    }

    public void setAttributeColumnName(String string) {
        this.colName[1] = string;
    }

    void loadDataFile(File file) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "IO Error. Failed to load file: " + file.getAbsolutePath(), "Error", 0);
            return;
        }
        this.readTabbedDataLines(file.getAbsolutePath(), bufferedReader);
    }

    private void readTabbedDataLines(String string, BufferedReader bufferedReader) {
        Object[][] objectArray;
        String string2 = null;
        try {
            string2 = bufferedReader.readLine();
            if (string2 == null) {
                throw new Exception();
            }
            if ("".equals(string2.trim())) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Failed to load file: " + string + "\nNo title line.", "Error", 0);
            return;
        }
        String[] stringArray = string2.split("\t");
        if (stringArray == null || stringArray.length != this.getColumnCount()) {
            JOptionPane.showMessageDialog(null, "Failed to load file: " + string + "\nColumn count error.", "Error", 0);
            return;
        }
        Vector<String[]> vector = new Vector<String[]>();
        while (true) {
            int n;
            String[] stringArray2;
            try {
                string2 = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                break;
            }
            if (string2 == null) break;
            if ("".equals(string2.trim()) || (objectArray = string2.split("\t")).length != (stringArray2 = new String[stringArray.length]).length) continue;
            try {
                double d = Double.parseDouble(objectArray[0].trim());
                stringArray2[0] = objectArray[0].trim();
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            for (n = 1; n < objectArray.length; ++n) {
                try {
                    double d = Double.parseDouble(objectArray[n].trim());
                    stringArray2[n] = objectArray[n].trim();
                }
                catch (NumberFormatException numberFormatException) {
                    if (objectArray[n].trim().equalsIgnoreCase("null")) {
                        stringArray2[n] = "NaN";
                        continue;
                    }
                    if (!objectArray[n].trim().equalsIgnoreCase("NaN")) break;
                    stringArray2[n] = "NaN";
                }
            }
            if (n < objectArray.length) continue;
            vector.add(stringArray2);
        }
        if (vector.isEmpty()) {
            JOptionPane.showMessageDialog(null, "Failed to load file: " + string + "\nRead error occured on one of the lines.", "Error", 0);
            return;
        }
        objectArray = new Object[vector.size()][stringArray.length];
        for (int i = 0; i < vector.size(); ++i) {
            String[] stringArray3 = (String[])vector.get(i);
            for (int j = 0; j < stringArray3.length; ++j) {
                objectArray[i][j] = stringArray3[j];
            }
        }
        this.data = objectArray;
        this.fireTableRowsInserted(0, this.data.length - 1);
    }

    public double[] parseNumberSpectrumData() {
        if (this.getColumnCount() != 2) {
            return null;
        }
        if (this.data == null) {
            return null;
        }
        if (this.data.length == 0) {
            return null;
        }
        if (this.data[0].length != this.getColumnCount()) {
            return null;
        }
        Vector<Double> vector = new Vector<Double>();
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i].length < 2) continue;
            if (this.data[i][1] == null) {
                if (i >= this.data.length - 1) continue;
                vector.add(new Double(Double.NaN));
                continue;
            }
            if (!(this.data[i][1] instanceof String)) continue;
            String string = (String)this.data[i][1];
            try {
                double d = Double.parseDouble(string.trim());
                vector.add(new Double(string.trim()));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                if (!string.trim().equalsIgnoreCase("null") && !string.trim().equalsIgnoreCase("NaN")) continue;
                vector.add(new Double(Double.NaN));
            }
        }
        if (vector.isEmpty()) {
            return null;
        }
        double[] dArray = new double[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            dArray[i] = (Double)vector.get(i);
        }
        return dArray;
    }

    void removeOneRow(int n) {
        Object[][] objectArray = new Object[this.data.length - 1][2];
        if (n == 0) {
            System.arraycopy(this.data, 1, objectArray, 0, this.data.length - 1);
        } else if (n == this.data.length - 1) {
            System.arraycopy(this.data, 0, objectArray, 0, this.data.length - 1);
        } else {
            System.arraycopy(this.data, 0, objectArray, 0, n);
            System.arraycopy(this.data, n + 1, objectArray, n, this.data.length - n - 1);
        }
        this.data = objectArray;
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i][0] = Double.toString(i);
        }
    }
}

