/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.jdraw;

import fr.esrf.tangoatk.widget.jdraw.TangoSynopticHandler;
import fr.esrf.tangoatk.widget.util.ATKDiagnostic;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorHistory;
import fr.esrf.tangoatk.widget.util.Splash;
import fr.esrf.tangoatk.widget.util.jdraw.JDFileFilter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.MissingResourceException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SimpleSynopticAppli
extends JFrame {
    private final Splash splash = new Splash();
    private ErrorHistory errorHistory = new ErrorHistory();
    private boolean standAlone = false;
    private boolean fileLoaded = false;
    private JMenuItem errHistMenuItem;
    private JMenuItem diagtMenuItem;
    private JMenu fileJMenu;
    private JMenuBar jMenuBar1;
    private JPanel jPanel1;
    private JMenuItem quitJMenuItem;
    private TangoSynopticHandler tangoSynopHandler;
    private JMenu viewMenu;

    public SimpleSynopticAppli() {
        this.splash.setTitle("SimpleSynopticAppli  ");
        this.splash.setCopyright("(c) ESRF 2003-2009");
        this.splash.setMessage("Loading synoptic ...");
        this.splash.initProgress();
        this.splash.setMaxProgress(5);
        this.initComponents();
    }

    public SimpleSynopticAppli(String string) {
        this();
        try {
            this.tangoSynopHandler.setSynopticFileName(string);
            this.splash.progress(4);
            this.splash.setMessage("Synoptic file loaded ...");
            this.tangoSynopHandler.setToolTipMode(3);
            this.tangoSynopHandler.setAutoZoom(true);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(null, "Cannot find the synoptic file : " + string + ".\n" + "Check the file name you entered;" + " Application will abort ...\n" + fileNotFoundException, "No such file", 0);
            this.splash.setVisible(false);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(null, "Cannot parse the synoptic file : " + string + ".\n" + "Check if the file is a Jdraw file." + " Application will abort ...\n" + illegalArgumentException, "Cannot parse the file", 0);
            this.splash.setVisible(false);
            return;
        }
        catch (MissingResourceException missingResourceException) {
            JOptionPane.showMessageDialog(null, "Cannot parse the synoptic file : " + string + ".\n" + " Application will abort ...\n" + missingResourceException, "Cannot parse the file", 0);
            this.splash.setVisible(false);
            return;
        }
        this.splash.setVisible(false);
        this.fileLoaded = true;
        this.setTitle(string);
        this.pack();
        this.setVisible(true);
    }

    public SimpleSynopticAppli(String string, boolean bl) {
        this(string);
        this.standAlone = bl;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.tangoSynopHandler = new TangoSynopticHandler();
        this.jMenuBar1 = new JMenuBar();
        this.fileJMenu = new JMenu();
        this.quitJMenuItem = new JMenuItem();
        this.viewMenu = new JMenu();
        this.errHistMenuItem = new JMenuItem();
        this.diagtMenuItem = new JMenuItem();
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SimpleSynopticAppli.this.exitForm(windowEvent);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        if (this.errorHistory != null) {
            try {
                this.tangoSynopHandler.setErrorHistoryWindow(this.errorHistory);
            }
            catch (Exception exception) {
                System.out.println("Cannot set Error History Window");
            }
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.tangoSynopHandler, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.fileJMenu.setText("File");
        this.quitJMenuItem.setText("Quit");
        this.quitJMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimpleSynopticAppli.this.quitJMenuItemActionPerformed(actionEvent);
            }
        });
        this.fileJMenu.add(this.quitJMenuItem);
        this.jMenuBar1.add(this.fileJMenu);
        this.viewMenu.setText("View");
        this.errHistMenuItem.setText("Error History ...");
        this.errHistMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimpleSynopticAppli.this.errHistMenuItemActionPerformed(actionEvent);
            }
        });
        this.viewMenu.add(this.errHistMenuItem);
        this.diagtMenuItem.setText("Diagnostic ...");
        this.diagtMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ATKDiagnostic.showDiagnostic();
            }
        });
        this.viewMenu.add(this.diagtMenuItem);
        this.jMenuBar1.add(this.viewMenu);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void errHistMenuItemActionPerformed(ActionEvent actionEvent) {
        this.errorHistory.setVisible(true);
    }

    private void quitJMenuItemActionPerformed(ActionEvent actionEvent) {
        this.stopSimpleSynopticAppli();
    }

    private void exitForm(WindowEvent windowEvent) {
        this.stopSimpleSynopticAppli();
    }

    public void stopSimpleSynopticAppli() {
        if (this.standAlone) {
            System.exit(0);
        } else {
            this.tangoSynopHandler.getAttributeList().stopRefresher();
            this.dispose();
        }
    }

    public static void main(String[] stringArray) {
        String string = null;
        SimpleSynopticAppli simpleSynopticAppli = null;
        String string2 = null;
        String string3 = null;
        if (stringArray.length >= 2) {
            string2 = stringArray[0];
            string3 = stringArray[1];
            string = string2 == null ? string3 : (string2.length() <= 0 ? string3 : string2 + "/" + string3);
        } else if (stringArray.length == 1) {
            string = stringArray[0];
        }
        if (string == null) {
            JFileChooser jFileChooser = new JFileChooser(".");
            jFileChooser.setDialogTitle("[SimpleSynopticAppli] Open a synoptic file");
            JDFileFilter jDFileFilter = new JDFileFilter("JDraw synoptic", new String[]{"jdw"});
            jFileChooser.addChoosableFileFilter(jDFileFilter);
            int n = jFileChooser.showOpenDialog(null);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                string = file.getAbsolutePath();
            } else {
                System.exit(0);
            }
        }
        simpleSynopticAppli = new SimpleSynopticAppli(string, true);
        if (!simpleSynopticAppli.fileLoaded) {
            System.exit(-1);
        }
        ATKGraphicsUtils.centerFrameOnScreen(simpleSynopticAppli);
    }
}

