/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import com.braju.format.Format;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.AttrManip;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.IImageListener;
import fr.esrf.tangoatk.core.INumberImage;
import fr.esrf.tangoatk.core.NumberImageEvent;
import fr.esrf.tangoatk.widget.attribute.IRoiListener;
import fr.esrf.tangoatk.widget.attribute.RoiEvent;
import fr.esrf.tangoatk.widget.attribute.SimplePropertyFrame;
import fr.esrf.tangoatk.widget.image.LineProfilerViewer;
import fr.esrf.tangoatk.widget.properties.LabelViewer;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKDiagnostic;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.AdvancedImagePlus;
import fr.esrf.tangoatk.widget.util.ErrorHistory;
import fr.esrf.tangoatk.widget.util.Gradient;
import fr.esrf.tangoatk.widget.util.JGradientEditor;
import fr.esrf.tangoatk.widget.util.JGradientViewer;
import fr.esrf.tangoatk.widget.util.JImage;
import fr.esrf.tangoatk.widget.util.JImageJ;
import fr.esrf.tangoatk.widget.util.JSmoothLabel;
import fr.esrf.tangoatk.widget.util.JTableRow;
import fr.esrf.tangoatk.widget.util.MultiExtFileFilter;
import fr.esrf.tangoatk.widget.util.chart.AxisPanel;
import fr.esrf.tangoatk.widget.util.chart.CfFileReader;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawable;
import ij.gui.Line;
import ij.gui.Roi;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;
import javax.swing.filechooser.FileFilter;

public class NumberImageJViewer
extends JPanel
implements IImageListener,
MouseMotionListener,
MouseListener,
MouseWheelListener,
ActionListener,
KeyListener,
JDrawable {
    private static final long serialVersionUID = 1L;
    protected INumberImage model;
    protected double[][] doubleValues = null;
    protected Rectangle oldSelection = null;
    protected int profileMode;
    protected boolean showingMenu;
    protected boolean sigHistogram;
    protected boolean isNegative;
    protected int startHisto;
    protected Gradient gColor;
    protected int[] gColormap;
    protected int iSz;
    protected EventListenerList listenerList;
    protected Insets noMargin = new Insets(0, 0, 0, 0);
    protected boolean autoZoom = false;
    protected boolean firstRefresh = false;
    protected boolean userZoom = false;
    protected int verticalExtent = 1;
    protected String lastConfig = "";
    protected boolean isBestFit;
    protected boolean autoBestFit;
    protected double bfMin = 0.0;
    protected double bfMax = 65536.0;
    protected double autoBfMin;
    protected double autoBfMax;
    protected double bfa0;
    protected double bfa1;
    protected double curSelMin;
    protected double curSelMax;
    protected JImageJ imagePanel;
    protected JPanel buttonPanel;
    protected JButton selectButton;
    protected JButton selectMaxButton;
    protected JButton roiColorsButton;
    protected JPopupMenu roiColorsMenu;
    protected JMenuItem roiColorMenuItem;
    protected JMenuItem selectedRoiColorMenuItem;
    protected JMenuItem innerRoiColorMenuItem;
    protected JMenuItem selectedInnerRoiColorMenuItem;
    protected JMenuItem outerRoiColorMenuItem;
    protected JMenuItem selectedOuterRoiColorMenuItem;
    protected JButton fileButton;
    protected JButton zoomButton;
    protected JButton tableButton;
    protected JButton profileButton;
    protected JButton histoButton;
    protected JButton settingsButton;
    protected JButton axisButton;
    protected JButton loadButton;
    protected JButton saveButton;
    protected JButton printButton;
    protected JScrollPane buttonView;
    protected Font panelFont;
    protected JPanel cfgPanel;
    protected JLabel statusLabel;
    protected JLabel rangeLabel;
    protected JLabel avgLabel;
    protected JLabel selLabel;
    protected JTextField selText;
    protected JPopupMenu imgMenu;
    protected JMenuItem infoMenuItem;
    protected JCheckBoxMenuItem bestFitMenuItem;
    protected JCheckBoxMenuItem negativeMenuItem;
    protected JCheckBoxMenuItem toolbarMenuItem;
    protected JCheckBoxMenuItem statusLineMenuItem;
    protected JCheckBoxMenuItem showGradMenuItem;
    protected JMenuItem selectionMenuItem;
    protected JMenuItem selectionMaxMenuItem;
    protected JMenuItem selectionColorMenuItem;
    protected JMenuItem fileMenuItem;
    protected JMenuItem zoomMenuItem;
    protected JMenuItem tableMenuItem;
    protected JMenuItem lineProfileMenuItem;
    protected JMenuItem histogramMenuItem;
    protected JMenuItem settingsMenuItem;
    protected JMenuItem loadMenuItem;
    protected JMenuItem saveMenuItem;
    protected JMenuItem saveDataFileMenuItem;
    protected JMenuItem printMenuItem;
    protected JCheckBoxMenuItem displayLogMenuItem;
    protected JGradientViewer gradientTool;
    protected LineProfilerViewer lineProfiler = null;
    protected JFrame zoomDialog = null;
    protected JPanel zoomPanel;
    protected JScrollPane zoomView;
    protected JImage zoomImage;
    protected JPanel zoomCfgPanel;
    protected JComboBox zoomCombo;
    protected int zoomFactor;
    protected int zoomXOrg;
    protected int zoomYOrg;
    protected JLabel zoomText;
    protected JDialog settingsDialog = null;
    protected JPanel settingsPanel;
    protected LabelViewer attNameLabel;
    protected JButton propButton;
    protected JCheckBox sigHistogramCheck;
    protected JCheckBox bestFitCheck;
    protected JCheckBox autoBestFitCheck;
    protected JLabel minBestFitLabel;
    protected JTextField minBestFitText;
    protected JLabel maxBestFitLabel;
    protected JTextField maxBestFitText;
    protected JCheckBox negativeCheck;
    protected JComboBox imageSizeCombo;
    protected JLabel imageSizeLabel;
    protected JGradientEditor gradViewer;
    protected JButton gradButton;
    protected JLabel gradLabel;
    protected JButton okButton;
    protected JButton cancelButton;
    protected JDialog axisDialog = null;
    protected JTabbedPane tabPane;
    protected AxisPanel xAxisPanel;
    protected AxisPanel yAxisPanel;
    protected JButton axisCloseButton;
    protected JFrame tableDialog = null;
    protected JTableRow tablePanel;
    SimplePropertyFrame propDialog = null;
    static String[] exts = new String[]{"toolBarVisible", "statusLineVisible", "gradientVisible", "bestFit", "xAxis", "yAxis"};
    protected String lastSnapshotLocation = ".";
    protected FileFilter lastFileFilter = null;
    protected boolean logValues = false;

    public NumberImageJViewer() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        this.initImagePanel();
        this.initButtonPanel();
        this.initGradient();
        this.initStatusLine();
        this.initPopupMenu();
        this.isBestFit = true;
        this.autoBestFit = true;
        this.sigHistogram = false;
        this.isNegative = false;
        this.showingMenu = true;
        this.curSelMin = 65536.0;
        this.curSelMax = 0.0;
        this.startHisto = 0;
        this.zoomFactor = 0;
        this.iSz = 1;
        this.listenerList = new EventListenerList();
    }

    protected void initImagePanel() {
        this.imagePanel = new JImageJ();
        this.imagePanel.setBorder(null);
        this.add((Component)this.imagePanel, "Center");
        this.imagePanel.getImageRenderer().addMouseMotionListener(this);
        this.imagePanel.getImageRenderer().addMouseListener(this);
        this.imagePanel.getImageRenderer().addMouseWheelListener(this);
        this.imagePanel.getImageRenderer().addKeyListener(this);
    }

    protected void initButtonPanel() {
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(null);
        this.buttonPanel.setPreferredSize(new Dimension(60, 530));
        this.buttonView = new JScrollPane(this.buttonPanel);
        this.buttonView.setHorizontalScrollBarPolicy(31);
        this.add((Component)this.buttonView, "West");
        this.buttonView.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent componentEvent) {
                NumberImageJViewer.this.adjustToolbarSize();
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentShown(ComponentEvent componentEvent) {
                NumberImageJViewer.this.adjustToolbarSize();
            }

            public void componentHidden(ComponentEvent componentEvent) {
                NumberImageJViewer.this.adjustToolbarSize();
            }
        });
        this.selectButton = new JButton();
        this.selectButton.setMargin(this.noMargin);
        this.selectButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_select.gif")));
        this.selectButton.setBounds(2, 5, 36, 36);
        this.selectButton.setToolTipText("Free selection");
        this.selectButton.addActionListener(this);
        this.buttonPanel.add(this.selectButton);
        this.selectMaxButton = new JButton();
        this.selectMaxButton.setMargin(this.noMargin);
        this.selectMaxButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_selectmax.gif")));
        this.selectMaxButton.setBounds(2, 40, 36, 36);
        this.selectMaxButton.setToolTipText("Select whole image");
        this.selectMaxButton.addActionListener(this);
        this.buttonPanel.add(this.selectMaxButton);
        this.roiColorsButton = new JButton();
        this.roiColorsButton.setMargin(this.noMargin);
        this.roiColorsButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_select_color.gif")));
        this.roiColorsButton.setBounds(2, 75, 36, 36);
        this.roiColorsButton.setToolTipText("ROI Colors...");
        this.roiColorsButton.addActionListener(this);
        this.buttonPanel.add(this.roiColorsButton);
        this.roiColorsMenu = new JPopupMenu();
        this.roiColorMenuItem = new JMenuItem("ROI default color");
        this.roiColorMenuItem.addActionListener(this);
        this.roiColorsMenu.add(this.roiColorMenuItem);
        this.selectedRoiColorMenuItem = new JMenuItem("ROI default selection color");
        this.selectedRoiColorMenuItem.addActionListener(this);
        this.roiColorsMenu.add(this.selectedRoiColorMenuItem);
        this.innerRoiColorMenuItem = new JMenuItem("Interior ROI color");
        this.innerRoiColorMenuItem.addActionListener(this);
        this.roiColorsMenu.add(this.innerRoiColorMenuItem);
        this.selectedInnerRoiColorMenuItem = new JMenuItem("Interior ROI selection color");
        this.selectedInnerRoiColorMenuItem.addActionListener(this);
        this.roiColorsMenu.add(this.selectedInnerRoiColorMenuItem);
        this.outerRoiColorMenuItem = new JMenuItem("Exterior ROI color");
        this.outerRoiColorMenuItem.addActionListener(this);
        this.roiColorsMenu.add(this.outerRoiColorMenuItem);
        this.selectedOuterRoiColorMenuItem = new JMenuItem("Exterior ROI selection color");
        this.selectedOuterRoiColorMenuItem.addActionListener(this);
        this.roiColorsMenu.add(this.selectedOuterRoiColorMenuItem);
        this.fileButton = new JButton();
        this.fileButton.setMargin(this.noMargin);
        this.fileButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_snapshot.gif")));
        this.fileButton.setBounds(2, 115, 36, 36);
        this.fileButton.setToolTipText("Save snapshot");
        this.fileButton.addActionListener(this);
        this.buttonPanel.add(this.fileButton);
        this.zoomButton = new JButton();
        this.zoomButton.setMargin(this.noMargin);
        this.zoomButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_zoom.gif")));
        this.zoomButton.setBounds(2, 155, 36, 36);
        this.zoomButton.setToolTipText("Zoom selection");
        this.zoomButton.addActionListener(this);
        this.buttonPanel.add(this.zoomButton);
        this.tableButton = new JButton();
        this.tableButton.setMargin(this.noMargin);
        this.tableButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_table.gif")));
        this.tableButton.setBounds(2, 195, 36, 36);
        this.tableButton.setToolTipText("Selection to table");
        this.tableButton.addActionListener(this);
        this.buttonPanel.add(this.tableButton);
        this.profileButton = new JButton();
        this.profileButton.setMargin(this.noMargin);
        this.profileButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_profile.gif")));
        this.profileButton.setBounds(2, 240, 36, 36);
        this.profileButton.setToolTipText("Line profile");
        this.profileButton.addActionListener(this);
        this.buttonPanel.add(this.profileButton);
        this.histoButton = new JButton();
        this.histoButton.setMargin(this.noMargin);
        this.histoButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_histo.gif")));
        this.histoButton.setBounds(2, 275, 36, 36);
        this.histoButton.setToolTipText("Histogram");
        this.histoButton.addActionListener(this);
        this.buttonPanel.add(this.histoButton);
        this.settingsButton = new JButton();
        this.settingsButton.setMargin(this.noMargin);
        this.settingsButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_option.gif")));
        this.settingsButton.setBounds(2, 320, 36, 36);
        this.settingsButton.setToolTipText("Image viewer settings");
        this.settingsButton.addActionListener(this);
        this.buttonPanel.add(this.settingsButton);
        this.axisButton = new JButton();
        this.axisButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_axis.gif")));
        this.axisButton.setMargin(this.noMargin);
        this.axisButton.setBounds(2, 365, 36, 36);
        this.axisButton.setToolTipText("Axis settings");
        this.axisButton.addActionListener(this);
        this.buttonPanel.add(this.axisButton);
        this.loadButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_load_settings.gif")));
        this.loadButton.setToolTipText("Load settings");
        this.loadButton.setMargin(this.noMargin);
        this.loadButton.setBounds(2, 410, 36, 36);
        this.loadButton.addActionListener(this);
        this.buttonPanel.add(this.loadButton);
        this.saveButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_save_settings.gif")));
        this.saveButton.setToolTipText("Save settings");
        this.saveButton.setMargin(this.noMargin);
        this.saveButton.setBounds(2, 445, 36, 36);
        this.saveButton.addActionListener(this);
        this.buttonPanel.add(this.saveButton);
        this.printButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_print.gif")));
        this.printButton.setToolTipText("Print Image");
        this.printButton.setMargin(this.noMargin);
        this.printButton.setBounds(2, 490, 36, 36);
        this.printButton.addActionListener(this);
        this.buttonPanel.add(this.printButton);
    }

    protected void initGradient() {
        this.gradientTool = new JGradientViewer();
        this.gradientTool.getAxis().setMinimum(0.0);
        this.gradientTool.getAxis().setMaximum(65536.0);
        this.add((Component)this.gradientTool, "East");
        this.gColor = new Gradient();
        this.gColor.buildRainbowGradient();
        this.gColormap = this.gColor.buildColorMap(65536);
        this.gradientTool.setGradient(this.gColor);
    }

    protected void initStatusLine() {
        this.cfgPanel = new JPanel();
        this.cfgPanel.setLayout(null);
        this.cfgPanel.setPreferredSize(new Dimension(0, 50));
        this.add((Component)this.cfgPanel, "South");
        this.panelFont = new Font("Dialog", 0, 11);
        this.statusLabel = new JLabel("");
        this.statusLabel.setFont(this.panelFont);
        this.statusLabel.setBounds(5, 3, 220, 20);
        this.cfgPanel.add(this.statusLabel);
        this.rangeLabel = new JLabel("");
        this.rangeLabel.setFont(this.panelFont);
        this.rangeLabel.setBounds(235, 3, 300, 20);
        this.cfgPanel.add(this.rangeLabel);
        this.avgLabel = new JLabel("");
        this.avgLabel.setFont(this.panelFont);
        this.avgLabel.setBounds(235, 25, 300, 20);
        this.cfgPanel.add(this.avgLabel);
        this.selLabel = new JLabel("Selection");
        this.selLabel.setFont(this.panelFont);
        this.selLabel.setBounds(5, 25, 55, 20);
        this.cfgPanel.add(this.selLabel);
        this.selText = new JTextField("None");
        this.selText.setMargin(this.noMargin);
        this.selText.setFont(this.panelFont);
        this.selText.setBounds(65, 25, 160, 20);
        this.selText.addKeyListener(this);
        this.cfgPanel.add(this.selText);
    }

    protected void initPopupMenu() {
        this.imgMenu = new JPopupMenu();
        this.infoMenuItem = new JMenuItem("Image Viewer");
        this.infoMenuItem.setEnabled(false);
        this.bestFitMenuItem = new JCheckBoxMenuItem("Best fit");
        this.bestFitMenuItem.addActionListener(this);
        this.negativeMenuItem = new JCheckBoxMenuItem("Negative image");
        this.negativeMenuItem.addActionListener(this);
        this.toolbarMenuItem = new JCheckBoxMenuItem("Show toolbar");
        this.toolbarMenuItem.addActionListener(this);
        this.statusLineMenuItem = new JCheckBoxMenuItem("Show status line");
        this.statusLineMenuItem.addActionListener(this);
        this.showGradMenuItem = new JCheckBoxMenuItem("Show gradient");
        this.showGradMenuItem.addActionListener(this);
        this.selectionMenuItem = new JMenuItem("Free selection");
        this.selectionMenuItem.addActionListener(this);
        this.selectionMaxMenuItem = new JMenuItem("Select all");
        this.selectionMaxMenuItem.addActionListener(this);
        this.selectionColorMenuItem = new JMenuItem("Selection Color...");
        this.selectionColorMenuItem.addActionListener(this);
        this.lineProfileMenuItem = new JMenuItem("Line profile");
        this.lineProfileMenuItem.addActionListener(this);
        this.histogramMenuItem = new JMenuItem("Histogram");
        this.histogramMenuItem.addActionListener(this);
        this.fileMenuItem = new JMenuItem("Save selection");
        this.fileMenuItem.addActionListener(this);
        this.zoomMenuItem = new JMenuItem("Zoom selection");
        this.zoomMenuItem.addActionListener(this);
        this.settingsMenuItem = new JMenuItem("Settings");
        this.settingsMenuItem.addActionListener(this);
        this.tableMenuItem = new JMenuItem("Selection to table");
        this.tableMenuItem.addActionListener(this);
        this.loadMenuItem = new JMenuItem("Load settings");
        this.loadMenuItem.addActionListener(this);
        this.saveMenuItem = new JMenuItem("Save settings");
        this.saveMenuItem.addActionListener(this);
        this.saveDataFileMenuItem = new JMenuItem("Save data file");
        this.saveDataFileMenuItem.addActionListener(this);
        this.printMenuItem = new JMenuItem("Print image");
        this.printMenuItem.addActionListener(this);
        this.displayLogMenuItem = new JCheckBoxMenuItem("Display log values");
        this.displayLogMenuItem.addActionListener(this);
        this.imgMenu.add(this.infoMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.bestFitMenuItem);
        this.imgMenu.add(this.negativeMenuItem);
        this.imgMenu.add(this.toolbarMenuItem);
        this.imgMenu.add(this.statusLineMenuItem);
        this.imgMenu.add(this.showGradMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.selectionMenuItem);
        this.imgMenu.add(this.selectionMaxMenuItem);
        this.imgMenu.add(this.selectionColorMenuItem);
        this.imgMenu.add(this.fileMenuItem);
        this.imgMenu.add(this.zoomMenuItem);
        this.imgMenu.add(this.tableMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.lineProfileMenuItem);
        this.imgMenu.add(this.histogramMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.settingsMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.loadMenuItem);
        this.imgMenu.add(this.saveMenuItem);
        this.imgMenu.add(this.saveDataFileMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.printMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.displayLogMenuItem);
    }

    public void initForEditing() {
    }

    public JComponent getComponent() {
        return this;
    }

    public String getDescription(String string) {
        if (string.equalsIgnoreCase("toolBarVisible")) {
            return "Displays the left toolbar.";
        }
        if (string.equalsIgnoreCase("statusLineVisible")) {
            return "Displays the bottom status line.";
        }
        if (string.equalsIgnoreCase("gradientVisible")) {
            return "Displays the right gradient scale";
        }
        if (string.equalsIgnoreCase("bestFit")) {
            return "Displays the image using the whole color range";
        }
        if (string.equalsIgnoreCase("xAxis")) {
            return JLAxis.getHelpString();
        }
        if (string.equalsIgnoreCase("yAxis")) {
            return JLAxis.getHelpString();
        }
        return "";
    }

    public String[] getExtensionList() {
        return exts;
    }

    public boolean setExtendedParam(String string, String string2, boolean bl) {
        if (string.equalsIgnoreCase("toolBarVisible")) {
            if (string2.equalsIgnoreCase("true")) {
                this.setToolbarVisible(true);
                return true;
            }
            if (string2.equalsIgnoreCase("false")) {
                this.setToolbarVisible(false);
                return true;
            }
            this.showJdrawError(bl, "toolBarVisible", "Wrong syntax: 'true' or 'false' expected.");
            return false;
        }
        if (string.equalsIgnoreCase("statusLineVisible")) {
            if (string2.equalsIgnoreCase("true")) {
                this.setStatusLineVisible(true);
                return true;
            }
            if (string2.equalsIgnoreCase("false")) {
                this.setStatusLineVisible(false);
                return true;
            }
            this.showJdrawError(bl, "statusLineVisible", "Wrong syntax: 'true' or 'false' expected.");
            return false;
        }
        if (string.equalsIgnoreCase("gradientVisible")) {
            if (string2.equalsIgnoreCase("true")) {
                this.setGradientVisible(true);
                return true;
            }
            if (string2.equalsIgnoreCase("false")) {
                this.setGradientVisible(false);
                return true;
            }
            this.showJdrawError(bl, "gradientVisible", "Wrong syntax: 'true' or 'false' expected.");
            return false;
        }
        if (string.equalsIgnoreCase("bestFit")) {
            if (string2.equalsIgnoreCase("true")) {
                this.setBestFit(true);
                return true;
            }
            if (string2.equalsIgnoreCase("false")) {
                this.setBestFit(false);
                return true;
            }
            this.showJdrawError(bl, "bestFit", "Wrong syntax: 'true' or 'false' expected.");
            return false;
        }
        if (string.equalsIgnoreCase("xAxis")) {
            CfFileReader cfFileReader;
            if (!string2.endsWith("\n")) {
                string2 = string2 + "\n";
            }
            if (!(cfFileReader = new CfFileReader()).parseText(string2)) {
                this.showJdrawError(bl, "xAxis settings", "Failed to parse given config");
                return false;
            }
            this.getXAxis().applyConfiguration("x", cfFileReader);
            return true;
        }
        if (string.equalsIgnoreCase("yAxis")) {
            CfFileReader cfFileReader;
            if (!string2.endsWith("\n")) {
                string2 = string2 + "\n";
            }
            if (!(cfFileReader = new CfFileReader()).parseText(string2)) {
                this.showJdrawError(bl, "yAxis settings", "Failed to parse given config");
                return false;
            }
            this.getYAxis().applyConfiguration("y", cfFileReader);
            return true;
        }
        return false;
    }

    public String getExtendedParam(String string) {
        if (string.equalsIgnoreCase("toolBarVisible")) {
            return this.isToolbarVisible() ? "true" : "false";
        }
        if (string.equalsIgnoreCase("statusLineVisible")) {
            return this.isStatusLineVisible() ? "true" : "false";
        }
        if (string.equalsIgnoreCase("gradientVisible")) {
            return this.isGradientVisible() ? "true" : "false";
        }
        if (string.equalsIgnoreCase("bestFit")) {
            return this.isBestFit() ? "true" : "false";
        }
        if (string.equalsIgnoreCase("xAxis")) {
            return this.getXAxis().getConfiguration("x");
        }
        if (string.equalsIgnoreCase("yAxis")) {
            return this.getYAxis().getConfiguration("y");
        }
        return "";
    }

    protected void showJdrawError(boolean bl, String string, String string2) {
        if (bl) {
            JOptionPane.showMessageDialog(null, "NumberSpectrumViewer: " + string + " incorrect.\n" + string2, "Error", 0);
        }
    }

    public void addRoiListener(IRoiListener iRoiListener) {
        this.listenerList.add(IRoiListener.class, iRoiListener);
    }

    public void removeRoiListener(IRoiListener iRoiListener) {
        this.listenerList.remove(IRoiListener.class, iRoiListener);
    }

    public void fireRoiChange() {
        IRoiListener[] iRoiListenerArray = (IRoiListener[])this.listenerList.getListeners(IRoiListener.class);
        RoiEvent roiEvent = new RoiEvent(this, this.getSelection());
        for (int i = 0; i < iRoiListenerArray.length; ++i) {
            iRoiListenerArray[i].roiChange(roiEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBestFit(boolean bl) {
        this.isBestFit = bl;
        NumberImageJViewer numberImageJViewer = this;
        synchronized (numberImageJViewer) {
            this.convertImage();
            if (this.zoomDialog != null && this.zoomDialog.isVisible()) {
                this.buildZoom();
            }
        }
    }

    public boolean isBestFit() {
        return this.isBestFit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoBestFit(boolean bl) {
        this.autoBestFit = bl;
        NumberImageJViewer numberImageJViewer = this;
        synchronized (numberImageJViewer) {
            this.convertImage();
            if (this.zoomDialog != null && this.zoomDialog.isVisible()) {
                this.buildZoom();
            }
        }
    }

    public boolean isAutoBestFit() {
        return this.autoBestFit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBestFitMinMax(double d, double d2) {
        if (d < d2) {
            this.bfMin = d;
            this.bfMax = d2;
        }
        if (!this.autoBestFit) {
            NumberImageJViewer numberImageJViewer = this;
            synchronized (numberImageJViewer) {
                this.convertImage();
                if (this.zoomDialog != null && this.zoomDialog.isVisible()) {
                    this.buildZoom();
                }
            }
        }
    }

    public double getBestFitMin() {
        return this.bfMin;
    }

    public double getBestFitMax() {
        return this.bfMax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGradient(Gradient gradient) {
        this.gColor = gradient;
        this.gColormap = gradient.buildColorMap(65536);
        this.gradientTool.setGradient(this.gColor);
        this.gradientTool.repaint();
        NumberImageJViewer numberImageJViewer = this;
        synchronized (numberImageJViewer) {
            this.convertImage();
            if (this.zoomDialog != null && this.zoomDialog.isVisible()) {
                this.buildZoom();
            }
        }
    }

    public Gradient getGradient() {
        return this.gColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNegative(boolean bl) {
        this.isNegative = bl;
        NumberImageJViewer numberImageJViewer = this;
        synchronized (numberImageJViewer) {
            this.convertImage();
            if (this.zoomDialog != null && this.zoomDialog.isVisible()) {
                this.buildZoom();
            }
        }
    }

    public boolean isNegative() {
        return this.isNegative;
    }

    public void setToolbarVisible(boolean bl) {
        this.buttonView.setVisible(bl);
    }

    public boolean isToolbarVisible() {
        return this.buttonView.isVisible();
    }

    public void setStatusLineVisible(boolean bl) {
        this.cfgPanel.setVisible(bl);
    }

    public boolean isStatusLineVisible() {
        return this.cfgPanel.isVisible();
    }

    public void setGradientVisible(boolean bl) {
        this.gradientTool.setVisible(bl);
    }

    public boolean isGradientVisible() {
        return this.gradientTool.isVisible();
    }

    public void setShowingMenu(boolean bl) {
        this.showingMenu = bl;
    }

    public void setZoom(int n) {
        switch (n) {
            case 0: {
                this.iSz = -8;
                break;
            }
            case 1: {
                this.iSz = -4;
                break;
            }
            case 2: {
                this.iSz = -2;
                break;
            }
            case 3: {
                this.iSz = 1;
                break;
            }
            case 4: {
                this.iSz = 2;
                break;
            }
            case 5: {
                this.iSz = 4;
                break;
            }
            case 6: {
                this.iSz = 8;
                break;
            }
            default: {
                JOptionPane.showMessageDialog(this, "NumberImageViewer.setZoom():\nInvalid zoom index value. [0..5]", "Error", 0);
                this.iSz = 1;
            }
        }
        this.userZoom = true;
    }

    public int getZoom() {
        int n = 0;
        switch (this.iSz) {
            case -8: {
                n = 0;
                break;
            }
            case -4: {
                n = 1;
                break;
            }
            case -2: {
                n = 2;
                break;
            }
            case 1: {
                n = 3;
                break;
            }
            case 2: {
                n = 4;
                break;
            }
            case 4: {
                n = 5;
                break;
            }
            case 8: {
                n = 6;
            }
        }
        return n;
    }

    public void setAutoZoom(boolean bl) {
        this.autoZoom = bl;
    }

    public boolean getAutoZoom() {
        return this.autoZoom;
    }

    public boolean isShowingMenu() {
        return this.showingMenu;
    }

    public Insets getImageMargin() {
        return this.imagePanel.getMargin();
    }

    public void setImageMargin(Insets insets) {
        this.imagePanel.setMargin(insets);
    }

    public Dimension getCurrentImageSize() {
        if (this.doubleValues == null) {
            return new Dimension(0, 0);
        }
        int n = this.doubleValues.length;
        if (n == 0) {
            return new Dimension(0, 0);
        }
        return new Dimension(this.doubleValues[0].length, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelection(Rectangle rectangle) {
        if (this.imagePanel.getImagePlus() != null) {
            this.imagePanel.getImagePlus().setRoi(rectangle);
        }
        NumberImageJViewer numberImageJViewer = this;
        synchronized (numberImageJViewer) {
            this.refreshComponents();
        }
    }

    public Rectangle getSelection() {
        Rectangle rectangle = null;
        if (this.imagePanel.getImagePlus() != null && this.imagePanel.getImagePlus().getRoi() != null) {
            rectangle = this.imagePanel.getImagePlus().getRoi().getBounds();
        }
        return rectangle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(double[][] dArray) {
        NumberImageJViewer numberImageJViewer = this;
        synchronized (numberImageJViewer) {
            this.doubleValues = dArray;
            this.computeVerticalExtent();
            this.computeAutoZoom();
            this.convertImage();
            this.refreshComponents();
        }
        if (this.doubleValues == null) {
            this.imagePanel.setImage(null);
            this.freePopup();
        }
        this.imagePanel.revalidate();
        this.imagePanel.repaint();
    }

    public void loadImage(String string) throws IOException {
        File file = new File(string);
        BufferedImage bufferedImage = ImageIO.read(file);
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int[] nArray = new int[n];
        double[][] dArray = new double[n2][n];
        for (int i = 0; i < n2; ++i) {
            bufferedImage.getRGB(0, i, n, 1, nArray, 0, n);
            for (int j = 0; j < n; ++j) {
                dArray[i][j] = (nArray[j] & 0xFF00) >> 8;
            }
        }
        this.setData(dArray);
    }

    public JImageJ getImagePanel() {
        return this.imagePanel;
    }

    public JLAxis getXAxis() {
        return this.imagePanel.getXAxis();
    }

    public JLAxis getYAxis() {
        return this.imagePanel.getYAxis();
    }

    public JLAxis getGradientAxis() {
        return this.gradientTool.getAxis();
    }

    public int getImageXCoord(int n) {
        return n - this.imagePanel.getXOrigin();
    }

    public int getImageYCoord(int n) {
        return n - this.imagePanel.getYOrigin();
    }

    public void setVerticalExtent(int n) {
        this.verticalExtent = n;
    }

    protected void adjustToolbarSize() {
        if (this.buttonView.isVisible()) {
            this.buttonView.setPreferredSize(new Dimension(60, 0));
        }
        this.revalidate();
    }

    protected void freePopup() {
        if (this.lineProfiler != null) {
            this.lineProfiler.setData(null);
        }
        if (this.zoomDialog != null) {
            this.zoomImage.setImage(null);
        }
        if (this.tableDialog != null) {
            this.tablePanel.clearData();
        }
    }

    protected double[] buildProfileData() {
        Roi roi = this.imagePanel.getImagePlus().getRoi();
        if (roi != null && roi instanceof Line) {
            return ((Line)roi).getPixels();
        }
        return null;
    }

    protected double[] buildHistogramData() {
        if (this.doubleValues == null) {
            return null;
        }
        double[] dArray = new double[65536];
        this.startHisto = 0;
        Rectangle rectangle = this.imagePanel.getCurrentRoiBounds();
        if (rectangle != null) {
            int n;
            int n2;
            for (n2 = 0; n2 < 65536; ++n2) {
                dArray[n2] = 0.0;
            }
            try {
                for (n2 = rectangle.x; n2 < rectangle.x + rectangle.width; ++n2) {
                    for (n = rectangle.y; n < rectangle.y + rectangle.height; ++n) {
                        int n3 = (int)this.doubleValues[n][n2];
                        dArray[n3] = dArray[n3] + 1.0;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println("NumberImageViewer.buildHistogramData() : Cannot build histogram. One or more value exceed the range [0..65535].");
                return null;
            }
            if (!this.sigHistogram) {
                return dArray;
            }
            n = 0;
            int n4 = 65535;
            boolean bl = false;
            while (n < 65536 && !bl) {
                bl = dArray[n] > 0.0;
                if (bl) continue;
                ++n;
            }
            bl = false;
            while (n4 >= 0 && !bl) {
                bl = dArray[n4] > 0.0;
                if (bl) continue;
                --n4;
            }
            int n5 = n4 - n + 1;
            double[] dArray2 = new double[n5];
            for (n2 = 0; n2 < n5; ++n2) {
                dArray2[n2] = dArray[n + n2];
            }
            this.startHisto = n;
            return dArray2;
        }
        return null;
    }

    protected void refreshLineProfile() {
        if (this.lineProfiler != null && this.lineProfiler.isVisible() && this.profileMode > 0) {
            switch (this.profileMode) {
                case 1: {
                    this.lineProfiler.setData(this.buildProfileData());
                    break;
                }
                case 2: {
                    double[] dArray = this.buildHistogramData();
                    if (dArray != null) {
                        this.lineProfiler.setData(dArray, this.startHisto);
                        break;
                    }
                    this.lineProfiler.setData(null);
                }
            }
        }
    }

    protected void refreshSelectionMinMax() {
        double d;
        int n;
        int n2;
        if (this.doubleValues == null) {
            this.rangeLabel.setText("");
            this.avgLabel.setText("");
            return;
        }
        Rectangle rectangle = this.imagePanel.getCurrentRoiBounds();
        if (rectangle == null) {
            this.rangeLabel.setText("");
            return;
        }
        this.curSelMin = 65536.0;
        this.curSelMax = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        Dimension dimension = this.imagePanel.getImageSize();
        for (n2 = Math.max(rectangle.y, 0); n2 < rectangle.y + rectangle.height && n2 < dimension.height; ++n2) {
            for (n = Math.max(rectangle.x, 0); n < rectangle.x + rectangle.width && n < dimension.width; ++n) {
                d = this.doubleValues[n2][n];
                if (d > this.curSelMax) {
                    this.curSelMax = d;
                }
                if (d < this.curSelMin) {
                    this.curSelMin = d;
                }
                d2 += d;
                d4 += 1.0;
            }
        }
        d5 = d2 / d4;
        for (n2 = Math.max(rectangle.y, 0); n2 < rectangle.y + rectangle.height && n2 < dimension.height; ++n2) {
            for (n = Math.max(rectangle.x, 0); n < rectangle.x + rectangle.width && n < dimension.width; ++n) {
                d = this.doubleValues[n2][n];
                d3 += (d - d5) * (d - d5);
            }
        }
        d6 = Math.sqrt(d3 / d4);
        dimension = null;
        Double d7 = new Double(d5);
        Double d8 = new Double(d6);
        this.avgLabel.setText("Average: " + Format.sprintf((String)"%.2f", (Object[])new Double[]{d7}) + "  Std deviation: " + Format.sprintf((String)"%.2f", (Object[])new Double[]{d8}));
        if (this.curSelMin <= this.curSelMax) {
            this.rangeLabel.setText("Range: " + Double.toString(this.curSelMin) + " , " + Double.toString(this.curSelMax));
        } else {
            this.rangeLabel.setText("");
        }
    }

    protected void refreshComponents() {
        this.refreshSelectionMinMax();
        this.refreshLineProfile();
        if (this.zoomDialog != null && this.zoomDialog.isVisible()) {
            this.buildZoom();
            this.zoomView.revalidate();
            this.zoomPanel.repaint();
        }
        if (this.tableDialog != null && this.tableDialog.isVisible()) {
            this.buildTable();
            this.tablePanel.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selectionChanged() {
        NumberImageJViewer numberImageJViewer = this;
        synchronized (numberImageJViewer) {
            this.refreshComponents();
            this.imagePanel.repaint();
        }
        this.fireRoiChange();
    }

    protected void refreshStatusLine() {
        String string = "None";
        Roi roi = this.imagePanel.getImagePlus().getRoi();
        if (roi != null) {
            string = roi.toString();
        }
        this.selText.setText(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showZoom() {
        this.constructZoomPanel();
        if (this.zoomDialog.isVisible()) {
            this.zoomDialog.setVisible(true);
            return;
        }
        Object object = this;
        synchronized (object) {
            if (!this.buildZoom()) {
                return;
            }
        }
        this.zoomCombo.setSelectedIndex(this.zoomFactor);
        this.zoomText.setText("");
        this.zoomDialog.setTitle("[zoom] ImageViewer");
        this.zoomDialog.pack();
        object = Toolkit.getDefaultToolkit();
        Dimension dimension = ((Toolkit)object).getScreenSize();
        Dimension dimension2 = this.zoomDialog.getPreferredSize();
        this.zoomDialog.setBounds((dimension.width - dimension2.height) / 2, (dimension.height - dimension2.height) / 2, dimension2.width, dimension2.height);
        this.zoomDialog.setVisible(true);
    }

    protected void applySettings() {
        String string = this.minBestFitText.getText();
        String string2 = this.maxBestFitText.getText();
        this.isBestFit = this.bestFitCheck.isSelected();
        this.autoBestFit = this.autoBestFitCheck.isSelected();
        this.isNegative = this.negativeCheck.isSelected();
        this.sigHistogram = this.sigHistogramCheck.isSelected();
        this.setZoom(this.imageSizeCombo.getSelectedIndex());
        if (!this.autoBestFit) {
            try {
                this.bfMin = Double.parseDouble(string);
                this.bfMax = Double.parseDouble(string2);
                if (this.bfMin >= this.bfMax) {
                    JOptionPane.showMessageDialog(null, "maximum  best fit value is lower or equal than minimum!", "Error", 0);
                    this.autoBestFit = true;
                    this.bfMin = 0.0;
                    this.bfMax = 65536.0;
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Invalid syntax for maximum or minimum best fit value", "Error", 0);
                this.autoBestFit = true;
                this.bfMin = 0.0;
                this.bfMax = 65536.0;
            }
        }
        this.settingsDialog.setVisible(false);
    }

    public void saveSetting(String string) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            String string2 = this.getSettings();
            fileWriter.write(string2, 0, string2.length());
            fileWriter.close();
            this.lastConfig = string;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Failed to write " + string, "Error", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSettings() {
        this.constructSettingsPanel();
        this.initSettings();
        String string = "";
        NumberImageJViewer numberImageJViewer = this;
        synchronized (numberImageJViewer) {
            string = string + "minBestFitText:'" + this.minBestFitText.getText() + "'\n";
            string = string + "maxBestFitText:'" + this.maxBestFitText.getText() + "'\n";
            string = string + "isBestFit:'" + this.bestFitCheck.isSelected() + "'\n";
            string = string + "autoBestFit:'" + this.autoBestFitCheck.isSelected() + "'\n";
            string = string + "isNegative:'" + this.negativeCheck.isSelected() + "'\n";
            string = string + "sigHistogram:'" + this.sigHistogramCheck.isSelected() + "'\n";
            string = string + "zoom:'" + this.imageSizeCombo.getSelectedIndex() + "'\n";
            string = string + "toolBarVisible:'" + this.toolbarMenuItem.isSelected() + "'\n";
            string = string + "statusLineVisible:'" + this.statusLineMenuItem.isSelected() + "'\n";
            int n = this.gColor.getEntryNumber();
            string = string + "gradientCount:'" + n + "'\n";
            for (int i = 0; i < n; ++i) {
                Color color = this.gColor.getColorAt(i);
                string = string + "gradientColor_" + i + "_red:'" + color.getRed() + "'\n";
                string = string + "gradientColor_" + i + "_green:'" + color.getGreen() + "'\n";
                string = string + "gradientColor_" + i + "_blue:'" + color.getBlue() + "'\n";
                string = string + "gradientPos_" + i + ":'" + this.gColor.getPosAt(i) + "'\n";
                color = null;
            }
        }
        return string;
    }

    public String loadSetting(String string) {
        CfFileReader cfFileReader = new CfFileReader();
        if (!cfFileReader.readFile(string)) {
            return "Failed to read " + string;
        }
        this.lastConfig = string;
        return this.applySettings(cfFileReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String applySettings(CfFileReader cfFileReader) {
        this.constructSettingsPanel();
        String string = "";
        NumberImageJViewer numberImageJViewer = this;
        synchronized (numberImageJViewer) {
            int n;
            String string2 = this.minBestFitText.getText();
            String string3 = this.maxBestFitText.getText();
            boolean bl = this.bestFitCheck.isSelected();
            boolean bl2 = this.autoBestFitCheck.isSelected();
            boolean bl3 = this.negativeCheck.isSelected();
            boolean bl4 = this.sigHistogramCheck.isSelected();
            int n2 = this.imageSizeCombo.getSelectedIndex();
            boolean bl5 = this.toolbarMenuItem.isSelected();
            boolean bl6 = this.statusLineMenuItem.isSelected();
            int n3 = 0;
            Vector<String> vector = cfFileReader.getParam("minBestFitText");
            if (vector == null) {
                string = string + "Unable to find minBestFitText";
                return string;
            }
            this.minBestFitText.setText(vector.get(0).toString());
            vector = cfFileReader.getParam("maxBestFitText");
            if (vector == null) {
                this.minBestFitText.setText(string2);
                string = string + "Unable to find maxBestFitText";
                return string;
            }
            this.maxBestFitText.setText(vector.get(0).toString());
            vector = cfFileReader.getParam("isBestFit");
            if (vector == null) {
                this.minBestFitText.setText(string2);
                this.maxBestFitText.setText(string3);
                string = string + "Unable to find isBestFit";
                return string;
            }
            this.bestFitCheck.setSelected("true".equalsIgnoreCase(vector.get(0).toString().trim()));
            vector = cfFileReader.getParam("autoBestFit");
            if (vector == null) {
                this.minBestFitText.setText(string2);
                this.maxBestFitText.setText(string3);
                this.bestFitCheck.setSelected(bl);
                string = string + "Unable to find autoBestFit";
                return string;
            }
            this.autoBestFitCheck.setSelected("true".equalsIgnoreCase(vector.get(0).toString().trim()));
            vector = cfFileReader.getParam("isNegative");
            if (vector == null) {
                this.minBestFitText.setText(string2);
                this.maxBestFitText.setText(string3);
                this.bestFitCheck.setSelected(bl);
                this.autoBestFitCheck.setSelected(bl2);
                string = string + "Unable to find isNegative";
                return string;
            }
            this.negativeCheck.setSelected("true".equalsIgnoreCase(vector.get(0).toString().trim()));
            vector = cfFileReader.getParam("sigHistogram");
            if (vector == null) {
                this.minBestFitText.setText(string2);
                this.maxBestFitText.setText(string3);
                this.bestFitCheck.setSelected(bl);
                this.autoBestFitCheck.setSelected(bl2);
                this.negativeCheck.setSelected(bl3);
                string = string + "Unable to find sigHistogram";
                return string;
            }
            this.sigHistogramCheck.setSelected("true".equalsIgnoreCase(vector.get(0).toString().trim()));
            vector = cfFileReader.getParam("zoom");
            if (vector == null) {
                this.minBestFitText.setText(string2);
                this.maxBestFitText.setText(string3);
                this.bestFitCheck.setSelected(bl);
                this.autoBestFitCheck.setSelected(bl2);
                this.negativeCheck.setSelected(bl3);
                this.sigHistogramCheck.setSelected(bl4);
                string = string + "Unable to find zoom";
                return string;
            }
            try {
                n = Integer.parseInt(vector.get(0).toString());
                this.imageSizeCombo.setSelectedIndex(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.minBestFitText.setText(string2);
                this.maxBestFitText.setText(string3);
                this.bestFitCheck.setSelected(bl);
                this.autoBestFitCheck.setSelected(bl2);
                this.negativeCheck.setSelected(bl3);
                this.sigHistogramCheck.setSelected(bl4);
                string = string + "zoom: invalid number\n";
                return string;
            }
            vector = cfFileReader.getParam("toolBarVisible");
            if (vector == null) {
                this.minBestFitText.setText(string2);
                this.maxBestFitText.setText(string3);
                this.bestFitCheck.setSelected(bl);
                this.autoBestFitCheck.setSelected(bl2);
                this.negativeCheck.setSelected(bl3);
                this.sigHistogramCheck.setSelected(bl4);
                this.imageSizeCombo.setSelectedIndex(n2);
                string = string + "Unable to find toolBarVisible";
                return string;
            }
            this.toolbarMenuItem.setSelected("true".equalsIgnoreCase(vector.get(0).toString().trim()));
            vector = cfFileReader.getParam("statusLineVisible");
            if (vector == null) {
                this.minBestFitText.setText(string2);
                this.maxBestFitText.setText(string3);
                this.bestFitCheck.setSelected(bl);
                this.autoBestFitCheck.setSelected(bl2);
                this.negativeCheck.setSelected(bl3);
                this.sigHistogramCheck.setSelected(bl4);
                this.imageSizeCombo.setSelectedIndex(n2);
                this.toolbarMenuItem.setSelected(bl5);
                string = string + "Unable to find statusLineVisible";
                return string;
            }
            this.statusLineMenuItem.setSelected("true".equalsIgnoreCase(vector.get(0).toString().trim()));
            vector = cfFileReader.getParam("gradientCount");
            if (vector == null) {
                this.minBestFitText.setText(string2);
                this.maxBestFitText.setText(string3);
                this.bestFitCheck.setSelected(bl);
                this.autoBestFitCheck.setSelected(bl2);
                this.negativeCheck.setSelected(bl3);
                this.sigHistogramCheck.setSelected(bl4);
                this.imageSizeCombo.setSelectedIndex(n2);
                this.toolbarMenuItem.setSelected(bl5);
                this.statusLineMenuItem.setSelected(bl6);
                string = string + "Unable to find gradientCount";
                return string;
            }
            try {
                n3 = Integer.parseInt(vector.get(0).toString());
            }
            catch (NumberFormatException numberFormatException) {
                this.minBestFitText.setText(string2);
                this.maxBestFitText.setText(string3);
                this.bestFitCheck.setSelected(bl);
                this.autoBestFitCheck.setSelected(bl2);
                this.negativeCheck.setSelected(bl3);
                this.sigHistogramCheck.setSelected(bl4);
                this.imageSizeCombo.setSelectedIndex(n2);
                this.toolbarMenuItem.setSelected(bl5);
                this.statusLineMenuItem.setSelected(bl6);
                string = string + "gradientCount: invalid number";
                return string;
            }
            Color[] colorArray = new Color[n3];
            double[] dArray = new double[n3];
            for (n = 0; n < n3; ++n) {
                double d;
                int n4;
                int n5;
                int n6;
                vector = cfFileReader.getParam("gradientColor_" + n + "_red");
                if (vector == null) {
                    this.minBestFitText.setText(string2);
                    this.maxBestFitText.setText(string3);
                    this.bestFitCheck.setSelected(bl);
                    this.autoBestFitCheck.setSelected(bl2);
                    this.negativeCheck.setSelected(bl3);
                    this.sigHistogramCheck.setSelected(bl4);
                    this.imageSizeCombo.setSelectedIndex(n2);
                    this.toolbarMenuItem.setSelected(bl5);
                    this.statusLineMenuItem.setSelected(bl6);
                    string = string + "Unable to find gradientColor_" + n + "_red";
                    return string;
                }
                try {
                    n6 = Integer.parseInt(vector.get(0).toString());
                }
                catch (NumberFormatException numberFormatException) {
                    this.minBestFitText.setText(string2);
                    this.maxBestFitText.setText(string3);
                    this.bestFitCheck.setSelected(bl);
                    this.autoBestFitCheck.setSelected(bl2);
                    this.negativeCheck.setSelected(bl3);
                    this.sigHistogramCheck.setSelected(bl4);
                    this.imageSizeCombo.setSelectedIndex(n2);
                    this.toolbarMenuItem.setSelected(bl5);
                    this.statusLineMenuItem.setSelected(bl6);
                    string = string + "gradientColor_" + n + "_red: invalid number";
                    return string;
                }
                vector = cfFileReader.getParam("gradientColor_" + n + "_green");
                if (vector == null) {
                    this.minBestFitText.setText(string2);
                    this.maxBestFitText.setText(string3);
                    this.bestFitCheck.setSelected(bl);
                    this.autoBestFitCheck.setSelected(bl2);
                    this.negativeCheck.setSelected(bl3);
                    this.sigHistogramCheck.setSelected(bl4);
                    this.imageSizeCombo.setSelectedIndex(n2);
                    this.toolbarMenuItem.setSelected(bl5);
                    this.statusLineMenuItem.setSelected(bl6);
                    string = string + "Unable to find gradientColor_" + n + "_green";
                    return string;
                }
                try {
                    n5 = Integer.parseInt(vector.get(0).toString());
                }
                catch (NumberFormatException numberFormatException) {
                    this.minBestFitText.setText(string2);
                    this.maxBestFitText.setText(string3);
                    this.bestFitCheck.setSelected(bl);
                    this.autoBestFitCheck.setSelected(bl2);
                    this.negativeCheck.setSelected(bl3);
                    this.sigHistogramCheck.setSelected(bl4);
                    this.imageSizeCombo.setSelectedIndex(n2);
                    this.toolbarMenuItem.setSelected(bl5);
                    this.statusLineMenuItem.setSelected(bl6);
                    string = string + "gradientColor_" + n + "_green: invalid number";
                    return string;
                }
                vector = cfFileReader.getParam("gradientColor_" + n + "_blue");
                if (vector == null) {
                    this.minBestFitText.setText(string2);
                    this.maxBestFitText.setText(string3);
                    this.bestFitCheck.setSelected(bl);
                    this.autoBestFitCheck.setSelected(bl2);
                    this.negativeCheck.setSelected(bl3);
                    this.sigHistogramCheck.setSelected(bl4);
                    this.imageSizeCombo.setSelectedIndex(n2);
                    this.toolbarMenuItem.setSelected(bl5);
                    this.statusLineMenuItem.setSelected(bl6);
                    string = string + "Unable to find gradientColor_" + n + "_blue";
                    return string;
                }
                try {
                    n4 = Integer.parseInt(vector.get(0).toString());
                }
                catch (NumberFormatException numberFormatException) {
                    this.minBestFitText.setText(string2);
                    this.maxBestFitText.setText(string3);
                    this.bestFitCheck.setSelected(bl);
                    this.autoBestFitCheck.setSelected(bl2);
                    this.negativeCheck.setSelected(bl3);
                    this.sigHistogramCheck.setSelected(bl4);
                    this.imageSizeCombo.setSelectedIndex(n2);
                    this.toolbarMenuItem.setSelected(bl5);
                    this.statusLineMenuItem.setSelected(bl6);
                    string = string + "gradientColor_" + n + "_blue: invalid number";
                    return string;
                }
                vector = cfFileReader.getParam("gradientPos_" + n);
                if (vector == null) {
                    this.minBestFitText.setText(string2);
                    this.maxBestFitText.setText(string3);
                    this.bestFitCheck.setSelected(bl);
                    this.autoBestFitCheck.setSelected(bl2);
                    this.negativeCheck.setSelected(bl3);
                    this.sigHistogramCheck.setSelected(bl4);
                    this.imageSizeCombo.setSelectedIndex(n2);
                    this.toolbarMenuItem.setSelected(bl5);
                    this.statusLineMenuItem.setSelected(bl6);
                    string = string + "Unable to find gradientPos_" + n;
                    return string;
                }
                try {
                    d = Double.parseDouble(vector.get(0).toString());
                }
                catch (NumberFormatException numberFormatException) {
                    this.minBestFitText.setText(string2);
                    this.maxBestFitText.setText(string3);
                    this.bestFitCheck.setSelected(bl);
                    this.autoBestFitCheck.setSelected(bl2);
                    this.negativeCheck.setSelected(bl3);
                    this.sigHistogramCheck.setSelected(bl4);
                    this.imageSizeCombo.setSelectedIndex(n2);
                    this.toolbarMenuItem.setSelected(bl5);
                    this.statusLineMenuItem.setSelected(bl6);
                    string = string + "gradientPos_" + n + ": invalid number";
                    return string;
                }
                colorArray[n] = new Color(n6, n5, n4);
                dArray[n] = d;
            }
            this.gColor = new Gradient();
            if (n3 == 5) {
                this.gColor.buildRainbowGradient();
            }
            for (n = 0; n < n3; ++n) {
                this.gColor.setColorAt(n, colorArray[n]);
                this.gColor.setPosAt(n, dArray[n]);
            }
            this.gColormap = this.gColor.buildColorMap(65536);
            this.applySettings();
            this.setToolbarVisible(this.toolbarMenuItem.isSelected());
            this.setStatusLineVisible(this.statusLineMenuItem.isSelected());
            this.convertImage();
            this.refreshComponents();
        }
        return string;
    }

    protected void saveButtonActionPerformed() {
        File file;
        int n;
        int n2 = 0;
        JFileChooser jFileChooser = new JFileChooser(".");
        jFileChooser.addChoosableFileFilter(new MultiExtFileFilter("Text files", "txt", new String[0]));
        if (this.lastConfig.length() > 0) {
            jFileChooser.setSelectedFile(new File(this.lastConfig));
        }
        if ((n = jFileChooser.showSaveDialog(this)) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            if (MultiExtFileFilter.getExtension(file) == null) {
                file = new File(file.getAbsolutePath() + ".txt");
            }
            if (file.exists()) {
                n2 = JOptionPane.showConfirmDialog(this, "Do you want to overwrite " + file.getName() + " ?", "Confirm overwrite", 0);
            }
            if (n2 == 0) {
                this.saveSetting(file.getAbsolutePath());
            }
        }
    }

    protected void loadButtonActionPerformed() {
        String string;
        File file;
        int n;
        boolean bl = false;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.addChoosableFileFilter(new MultiExtFileFilter("Text files", "txt", new String[0]));
        if (this.lastConfig.length() > 0) {
            jFileChooser.setSelectedFile(new File(this.lastConfig));
        }
        if ((n = jFileChooser.showOpenDialog(this)) == 0 && (file = jFileChooser.getSelectedFile()) != null && !bl && (string = this.loadSetting(file.getAbsolutePath())).length() > 0) {
            JOptionPane.showMessageDialog(this, string, "Errors reading " + file.getName(), 0);
        }
    }

    protected void showAxisDialog() {
        if (this.axisDialog == null) {
            Window window = ATKGraphicsUtils.getWindowForComponent(this);
            this.axisDialog = window instanceof Frame ? new JDialog((Frame)window, false) : (window instanceof Dialog ? new JDialog((Dialog)window, false) : new JDialog((Frame)null, false));
            this.axisDialog.setTitle("Axis settings");
            JPanel jPanel = new JPanel(null);
            this.tabPane = new JTabbedPane();
            this.xAxisPanel = new AxisPanel(this.getXAxis(), 3, null);
            this.yAxisPanel = new AxisPanel(this.getYAxis(), 1, null);
            this.tabPane.add("X axis", this.xAxisPanel);
            this.tabPane.add("Y axis", this.yAxisPanel);
            this.tabPane.setBounds(5, 5, 300, 370);
            jPanel.add(this.tabPane);
            this.axisCloseButton = new JButton("Close");
            this.axisCloseButton.setFont(ATKConstant.labelFont);
            this.axisCloseButton.setBounds(225, 380, 80, 25);
            jPanel.add(this.axisCloseButton);
            this.axisCloseButton.addActionListener(this);
            jPanel.setPreferredSize(new Dimension(310, 410));
            this.tabPane.setBounds(5, 5, 300, 370);
            this.axisDialog.setContentPane(jPanel);
            this.axisDialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    super.windowClosing(windowEvent);
                    NumberImageJViewer.this.imagePanel.getImageRenderer().revalidate();
                    NumberImageJViewer.this.imagePanel.revalidate();
                }
            });
        }
        ATKGraphicsUtils.centerDialog(this.axisDialog);
        this.axisDialog.setVisible(true);
    }

    private void initSettings() {
        this.minBestFitText.setText(Double.toString(this.bfMin));
        this.maxBestFitText.setText(Double.toString(this.bfMax));
        this.minBestFitLabel.setEnabled(!this.autoBestFit);
        this.minBestFitText.setEnabled(!this.autoBestFit);
        this.maxBestFitLabel.setEnabled(!this.autoBestFit);
        this.maxBestFitText.setEnabled(!this.autoBestFit);
        this.bestFitCheck.setSelected(this.isBestFit);
        this.autoBestFitCheck.setSelected(this.autoBestFit);
        this.sigHistogramCheck.setSelected(this.sigHistogram);
        this.negativeCheck.setSelected(this.isNegative);
        this.imageSizeCombo.setSelectedIndex(this.getZoom());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showSettings() {
        this.constructSettingsPanel();
        this.initSettings();
        ATKGraphicsUtils.centerDialog(this.settingsDialog);
        this.settingsDialog.setVisible(true);
        NumberImageJViewer numberImageJViewer = this;
        synchronized (numberImageJViewer) {
            this.convertImage();
            this.refreshComponents();
        }
    }

    public double[][] getData(Roi roi) {
        int n;
        int n2;
        double[][] dArray;
        Rectangle rectangle;
        boolean bl = false;
        if (this.doubleValues == null || this.imagePanel == null || this.imagePanel.getImagePlus() == null) {
            return null;
        }
        if (!this.imagePanel.getImagePlus().getInnerRois().contains(roi) && !this.imagePanel.getImagePlus().getOuterRois().contains(roi)) {
            roi = null;
        }
        if (roi == null || this.imagePanel.getImagePlus().getInnerRois().contains(roi)) {
            bl = true;
        } else if (this.imagePanel.getImagePlus().getOuterRois().contains(roi)) {
            bl = false;
        }
        Dimension dimension = this.imagePanel.getImageSize();
        Rectangle rectangle2 = rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        dimension = null;
        if (roi != null) {
            rectangle2 = roi.getBounds();
        }
        int n3 = Math.max(rectangle2.x, 0);
        if (rectangle.width > 0 && n3 > rectangle.width - 1) {
            n3 = rectangle.width - 1;
        }
        int n4 = Math.max(rectangle2.y, 0);
        if (rectangle.height > 0 && n4 > rectangle.height - 1) {
            n4 = rectangle.height - 1;
        }
        int n5 = Math.min(rectangle.width - n3, rectangle2.x + rectangle2.width - n3);
        int n6 = Math.min(rectangle.height - n4, rectangle2.y + rectangle2.height - n4);
        rectangle2.x = n3;
        rectangle2.y = n4;
        rectangle2.width = n5;
        rectangle2.height = n6;
        if (bl ? rectangle2.width <= 0 || rectangle2.height <= 0 : rectangle.width <= 0 || rectangle.height <= 0) {
            return new double[0][0];
        }
        if (bl) {
            dArray = new double[rectangle2.height][rectangle2.width];
            for (n2 = 0; n2 < rectangle2.height; ++n2) {
                for (n = 0; n < rectangle2.width; ++n) {
                    dArray[n2][n] = Double.NaN;
                }
            }
        } else {
            dArray = new double[rectangle.height][rectangle.width];
            for (n2 = 0; n2 < rectangle.height; ++n2) {
                for (n = 0; n < rectangle.width; ++n) {
                    dArray[n2][n] = Double.NaN;
                }
            }
        }
        if (bl) {
            for (n2 = 0; n2 < rectangle2.height; ++n2) {
                for (n = 0; n < rectangle2.width; ++n) {
                    if (roi != null && !roi.contains(rectangle2.x + n, rectangle2.y + n2)) continue;
                    dArray[n2][n] = this.doubleValues[rectangle2.y + n2][rectangle2.x + n];
                }
            }
        } else {
            for (n2 = 0; n2 < rectangle.width; ++n2) {
                for (n = 0; n < rectangle2.y; ++n) {
                    dArray[n][n2] = this.doubleValues[n][n2];
                }
            }
            for (n2 = 0; n2 < rectangle.width; ++n2) {
                for (n = rectangle2.y + rectangle2.height; n < rectangle.height; ++n) {
                    dArray[n][n2] = this.doubleValues[n][n2];
                }
            }
            for (n2 = 0; n2 < rectangle2.x; ++n2) {
                for (n = rectangle2.y; n < rectangle2.y + rectangle2.height; ++n) {
                    dArray[n][n2] = this.doubleValues[n][n2];
                }
            }
            for (n2 = rectangle2.x + rectangle2.width; n2 < rectangle.width; ++n2) {
                for (n = rectangle2.y; n < rectangle2.y + rectangle2.height; ++n) {
                    dArray[n][n2] = this.doubleValues[n][n2];
                }
            }
            for (n2 = 0; n2 < rectangle2.height; ++n2) {
                for (n = 0; n < rectangle2.width; ++n) {
                    int n7 = rectangle2.x + n;
                    int n8 = rectangle2.y + n2;
                    if (roi.contains(n7, n8)) continue;
                    dArray[n2][n] = this.doubleValues[n8][n7];
                }
            }
        }
        return dArray;
    }

    public double[][] getData(Roi roi, double[][] dArray, boolean bl) {
        int n;
        int n2;
        double[][] dArray2;
        int n3 = 0;
        int n4 = 0;
        if (dArray == null) {
            dArray = this.doubleValues;
        }
        if (dArray == null) {
            return null;
        }
        if (dArray.length > 0) {
            n4 = dArray.length;
            n3 = dArray[0].length;
        }
        Rectangle rectangle = new Rectangle(0, 0, n3, n4);
        if (roi != null) {
            rectangle = roi.getBounds();
        }
        int n5 = Math.max(rectangle.x, 0);
        if (n3 > 0 && n5 > n3 - 1) {
            n5 = n3 - 1;
        }
        int n6 = Math.max(rectangle.y, 0);
        if (n4 > 0 && n6 > n4 - 1) {
            n6 = n4 - 1;
        }
        int n7 = Math.min(n3 - n5, rectangle.x + rectangle.width - n5);
        int n8 = Math.min(n4 - n6, rectangle.y + rectangle.height - n6);
        rectangle.x = n5;
        rectangle.y = n6;
        rectangle.width = n7;
        rectangle.height = n8;
        if (bl ? rectangle.width <= 0 || rectangle.height <= 0 : n3 <= 0 || n4 <= 0) {
            return new double[0][0];
        }
        if (bl) {
            dArray2 = new double[rectangle.height][rectangle.width];
            for (n2 = 0; n2 < rectangle.height; ++n2) {
                for (n = 0; n < rectangle.width; ++n) {
                    dArray2[n2][n] = Double.NaN;
                }
            }
        } else {
            dArray2 = new double[n4][n3];
            for (n2 = 0; n2 < n4; ++n2) {
                for (n = 0; n < n3; ++n) {
                    dArray2[n2][n] = Double.NaN;
                }
            }
        }
        if (bl) {
            for (n2 = 0; n2 < rectangle.height; ++n2) {
                for (n = 0; n < rectangle.width; ++n) {
                    if (roi != null && !roi.contains(rectangle.x + n, rectangle.y + n2)) continue;
                    dArray2[n2][n] = dArray[rectangle.y + n2][rectangle.x + n];
                }
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < rectangle.y; ++n) {
                    dArray2[n][n2] = dArray[n][n2];
                }
            }
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = rectangle.y + rectangle.height; n < n4; ++n) {
                    dArray2[n][n2] = dArray[n][n2];
                }
            }
            for (n2 = 0; n2 < rectangle.x; ++n2) {
                for (n = rectangle.y; n < rectangle.y + rectangle.height; ++n) {
                    dArray2[n][n2] = dArray[n][n2];
                }
            }
            for (n2 = rectangle.x + rectangle.width; n2 < n3; ++n2) {
                for (n = rectangle.y; n < rectangle.y + rectangle.height; ++n) {
                    dArray2[n][n2] = dArray[n][n2];
                }
            }
            for (n2 = 0; n2 < rectangle.height; ++n2) {
                for (n = 0; n < rectangle.width; ++n) {
                    int n9 = rectangle.x + n;
                    int n10 = rectangle.y + n2;
                    if (roi.contains(n9, n10)) continue;
                    dArray2[n2][n] = dArray[n10][n9];
                }
            }
        }
        return dArray2;
    }

    protected boolean buildTable() {
        int n;
        int n2;
        Object[][] objectArray;
        Rectangle rectangle;
        boolean bl = false;
        if (this.doubleValues == null || this.imagePanel == null || this.imagePanel.getImagePlus() == null) {
            return false;
        }
        Roi roi = this.imagePanel.getImagePlus().getValidatedRoi();
        if (roi == null) {
            bl = true;
        } else if (this.imagePanel.getImagePlus().getInnerRois().contains(roi)) {
            bl = true;
        } else if (this.imagePanel.getImagePlus().getOuterRois().contains(roi)) {
            bl = false;
        } else {
            roi = null;
            bl = true;
        }
        Dimension dimension = this.imagePanel.getImageSize();
        Rectangle rectangle2 = rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        dimension = null;
        if (roi != null) {
            rectangle2 = roi.getBounds();
        }
        int n3 = Math.max(rectangle2.x, 0);
        if (rectangle.width > 0 && n3 > rectangle.width - 1) {
            n3 = rectangle.width - 1;
        }
        int n4 = Math.max(rectangle2.y, 0);
        if (rectangle.height > 0 && n4 > rectangle.height - 1) {
            n4 = rectangle.height - 1;
        }
        int n5 = Math.min(rectangle.width - n3, rectangle2.x + rectangle2.width - n3);
        int n6 = Math.min(rectangle.height - n4, rectangle2.y + rectangle2.height - n4);
        rectangle2.x = n3;
        rectangle2.y = n4;
        rectangle2.width = n5;
        rectangle2.height = n6;
        if (bl) {
            objectArray = new String[rectangle2.height][rectangle2.width];
            for (n2 = 0; n2 < rectangle2.height; ++n2) {
                for (n = 0; n < rectangle2.width; ++n) {
                    objectArray[n2][n] = "NaN";
                }
            }
        } else {
            objectArray = new String[rectangle.height][rectangle.width];
            for (n2 = 0; n2 < rectangle.height; ++n2) {
                for (n = 0; n < rectangle.width; ++n) {
                    objectArray[n2][n] = "NaN";
                }
            }
        }
        String string = null;
        Object[] objectArray2 = new Double[1];
        if (this.model != null) {
            string = this.model.getFormat();
        }
        if (string != null && string.length() > 0) {
            if (string.indexOf(37) == -1) {
                if (bl) {
                    for (int i = 0; i < rectangle2.height; ++i) {
                        for (int j = 0; j < rectangle2.width; ++j) {
                            if (roi != null && !roi.contains(rectangle2.x + j, rectangle2.y + i)) continue;
                            objectArray2[0] = new Double(this.doubleValues[rectangle2.y + i][rectangle2.x + j]);
                            objectArray[i][j] = objectArray2[0].isNaN() || objectArray2[0].isInfinite() ? ((Double)objectArray2[0]).toString() : AttrManip.format((String)string, (double)((Double)objectArray2[0]));
                        }
                    }
                } else {
                    int n7;
                    int n8;
                    for (n8 = 0; n8 < rectangle.width; ++n8) {
                        for (n7 = 0; n7 < rectangle2.y; ++n7) {
                            objectArray2[0] = new Double(this.doubleValues[n7][n8]);
                            objectArray[n7][n8] = objectArray2[0].isNaN() || objectArray2[0].isInfinite() ? objectArray2[0].toString() : AttrManip.format((String)string, (double)((Double)objectArray2[0]));
                        }
                    }
                    for (n8 = 0; n8 < rectangle.width; ++n8) {
                        for (n7 = rectangle2.y + rectangle2.height; n7 < rectangle.height; ++n7) {
                            objectArray2[0] = new Double(this.doubleValues[n7][n8]);
                            objectArray[n7][n8] = objectArray2[0].isNaN() || ((Double)objectArray2[0]).isInfinite() ? ((Double)objectArray2[0]).toString() : AttrManip.format((String)string, (double)((Double)objectArray2[0]));
                        }
                    }
                    for (n8 = 0; n8 < rectangle2.x; ++n8) {
                        for (n7 = rectangle2.y; n7 < rectangle2.y + rectangle2.height; ++n7) {
                            objectArray2[0] = new Double(this.doubleValues[n7][n8]);
                            objectArray[n7][n8] = ((Double)objectArray2[0]).isNaN() || ((Double)objectArray2[0]).isInfinite() ? ((Double)objectArray2[0]).toString() : AttrManip.format((String)string, (double)((Double)objectArray2[0]));
                        }
                    }
                    for (n8 = rectangle2.x + rectangle2.width; n8 < rectangle.width; ++n8) {
                        for (n7 = rectangle2.y; n7 < rectangle2.y + rectangle2.height; ++n7) {
                            objectArray2[0] = new Double(this.doubleValues[n7][n8]);
                            objectArray[n7][n8] = ((Double)objectArray2[0]).isNaN() || ((Double)objectArray2[0]).isInfinite() ? ((Double)objectArray2[0]).toString() : AttrManip.format((String)string, (double)((Double)objectArray2[0]));
                        }
                    }
                    for (n8 = 0; n8 < rectangle2.height; ++n8) {
                        for (n7 = 0; n7 < rectangle2.width; ++n7) {
                            int n9 = rectangle2.x + n7;
                            int n10 = rectangle2.y + n8;
                            if (roi.contains(n9, n10)) continue;
                            objectArray2[0] = new Double(this.doubleValues[n10][n9]);
                            objectArray[n10][n9] = ((Double)objectArray2[0]).isNaN() || ((Double)objectArray2[0]).isInfinite() ? ((Double)objectArray2[0]).toString() : AttrManip.format((String)string, (double)((Double)objectArray2[0]));
                        }
                    }
                }
            } else if (bl) {
                for (int i = 0; i < rectangle2.height; ++i) {
                    for (int j = 0; j < rectangle2.width; ++j) {
                        if (roi != null && !roi.contains(rectangle2.x + j, rectangle2.y + i)) continue;
                        objectArray2[0] = new Double(this.doubleValues[rectangle2.y + i][rectangle2.x + j]);
                        objectArray[i][j] = objectArray2[0].isNaN() || objectArray2[0].isInfinite() ? ((Double)objectArray2[0]).toString() : Format.sprintf((String)string, (Object[])objectArray2);
                    }
                }
            } else {
                int n11;
                int n12;
                for (n12 = 0; n12 < rectangle.width; ++n12) {
                    for (n11 = 0; n11 < rectangle2.y; ++n11) {
                        objectArray2[0] = new Double(this.doubleValues[n11][n12]);
                        objectArray[n11][n12] = objectArray2[0].isNaN() || objectArray2[0].isInfinite() ? objectArray2[0].toString() : Format.sprintf((String)string, (Object[])objectArray2);
                    }
                }
                for (n12 = 0; n12 < rectangle.width; ++n12) {
                    for (n11 = rectangle2.y + rectangle2.height; n11 < rectangle.height; ++n11) {
                        objectArray2[0] = new Double(this.doubleValues[n11][n12]);
                        objectArray[n11][n12] = objectArray2[0].isNaN() || ((Double)objectArray2[0]).isInfinite() ? ((Double)objectArray2[0]).toString() : Format.sprintf((String)string, (Object[])objectArray2);
                    }
                }
                for (n12 = 0; n12 < rectangle2.x; ++n12) {
                    for (n11 = rectangle2.y; n11 < rectangle2.y + rectangle2.height; ++n11) {
                        objectArray2[0] = new Double(this.doubleValues[n11][n12]);
                        objectArray[n11][n12] = ((Double)objectArray2[0]).isNaN() || ((Double)objectArray2[0]).isInfinite() ? ((Double)objectArray2[0]).toString() : Format.sprintf((String)string, (Object[])objectArray2);
                    }
                }
                for (n12 = rectangle2.x + rectangle2.width; n12 < rectangle.width; ++n12) {
                    for (n11 = rectangle2.y; n11 < rectangle2.y + rectangle2.height; ++n11) {
                        objectArray2[0] = new Double(this.doubleValues[n11][n12]);
                        objectArray[n11][n12] = ((Double)objectArray2[0]).isNaN() || ((Double)objectArray2[0]).isInfinite() ? ((Double)objectArray2[0]).toString() : Format.sprintf((String)string, (Object[])objectArray2);
                    }
                }
                for (n12 = 0; n12 < rectangle2.height; ++n12) {
                    for (n11 = 0; n11 < rectangle2.width; ++n11) {
                        int n13 = rectangle2.x + n11;
                        int n14 = rectangle2.y + n12;
                        if (roi.contains(n13, n14)) continue;
                        objectArray2[0] = new Double(this.doubleValues[n14][n13]);
                        objectArray[n14][n13] = ((Double)objectArray2[0]).isNaN() || ((Double)objectArray2[0]).isInfinite() ? ((Double)objectArray2[0]).toString() : Format.sprintf((String)string, (Object[])objectArray2);
                    }
                }
            }
        } else if (bl) {
            for (int i = 0; i < rectangle2.height; ++i) {
                for (int j = 0; j < rectangle2.width; ++j) {
                    if (roi != null && !roi.contains(rectangle2.x + j, rectangle2.y + i)) continue;
                    objectArray[i][j] = Double.toString(this.doubleValues[rectangle2.y + i][rectangle2.x + j]);
                }
            }
        } else {
            int n15;
            int n16;
            for (n16 = 0; n16 < rectangle.width; ++n16) {
                for (n15 = 0; n15 < rectangle2.y; ++n15) {
                    objectArray[n15][n16] = Double.toString(this.doubleValues[n15][n16]);
                }
            }
            for (n16 = 0; n16 < rectangle.width; ++n16) {
                for (n15 = rectangle2.y + rectangle2.height; n15 < rectangle.height; ++n15) {
                    objectArray[n15][n16] = Double.toString(this.doubleValues[n15][n16]);
                }
            }
            for (n16 = 0; n16 < rectangle2.x; ++n16) {
                for (n15 = rectangle2.y; n15 < rectangle2.y + rectangle2.height; ++n15) {
                    objectArray[n15][n16] = Double.toString(this.doubleValues[n15][n16]);
                }
            }
            for (n16 = rectangle2.x + rectangle2.width; n16 < rectangle.width; ++n16) {
                for (n15 = rectangle2.y; n15 < rectangle2.y + rectangle2.height; ++n15) {
                    objectArray[n15][n16] = Double.toString(this.doubleValues[n15][n16]);
                }
            }
            for (n16 = 0; n16 < rectangle2.height; ++n16) {
                for (n15 = 0; n15 < rectangle2.width; ++n15) {
                    int n17 = rectangle2.x + n15;
                    int n18 = rectangle2.y + n16;
                    if (roi.contains(n17, n18)) continue;
                    objectArray[n16][n15] = Double.toString(this.doubleValues[n18][n17]);
                }
            }
        }
        objectArray2 = null;
        if (bl) {
            this.tablePanel.setData(objectArray, rectangle2.x, rectangle2.y);
        } else {
            this.tablePanel.setData(objectArray, 0, 0);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showTable() {
        this.constructTablePanel();
        if (this.tableDialog.isVisible()) {
            this.tableDialog.setVisible(true);
            return;
        }
        NumberImageJViewer numberImageJViewer = this;
        synchronized (numberImageJViewer) {
            if (!this.buildTable()) {
                return;
            }
        }
        ATKGraphicsUtils.centerFrameOnScreen(this.tableDialog);
        this.tableDialog.setVisible(true);
    }

    protected void showPropertyFrame() {
        if (this.model != null) {
            if (this.propDialog == null) {
                this.propDialog = new SimplePropertyFrame(this.settingsDialog, true);
            }
            this.propDialog.setModel((IAttribute)this.model);
            this.propDialog.setVisible(true);
        }
    }

    protected void showGradientEditor() {
        Gradient gradient = JGradientEditor.showDialog(this.settingsDialog, this.gColor);
        if (gradient != null) {
            this.gColor = gradient;
            this.gColormap = gradient.buildColorMap(65536);
            this.gradViewer.setGradient(this.gColor);
            this.gradViewer.repaint();
            this.gradientTool.setGradient(this.gColor);
            this.gradientTool.repaint();
        }
    }

    protected void constructLineProfiler() {
        if (this.lineProfiler == null) {
            this.lineProfiler = new LineProfilerViewer();
            this.lineProfiler.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    NumberImageJViewer.this.lineProfiler.setData(null);
                    NumberImageJViewer.this.lineProfiler.dispose();
                }
            });
        }
    }

    protected void constructTablePanel() {
        if (this.tableDialog == null) {
            this.tablePanel = new JTableRow();
            this.tableDialog = new JFrame();
            this.tableDialog.setContentPane(this.tablePanel);
            this.tableDialog.setTitle("[table] ImageViewer");
            this.tableDialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    NumberImageJViewer.this.tablePanel.clearData();
                    NumberImageJViewer.this.tableDialog.dispose();
                }
            });
        }
    }

    protected void constructZoomPanel() {
        if (this.zoomDialog == null) {
            this.zoomPanel = new JPanel(new BorderLayout());
            this.zoomImage = new JImage();
            this.zoomImage.setSelectionEnabled(false);
            this.zoomImage.setMargin(new Insets(2, 2, 2, 2));
            this.zoomImage.setImage(null);
            this.zoomView = new JScrollPane(this.zoomImage);
            this.zoomPanel.add((Component)this.zoomView, "Center");
            this.zoomCfgPanel = new JPanel();
            this.zoomCfgPanel.setLayout(null);
            this.zoomCfgPanel.setPreferredSize(new Dimension(0, 25));
            this.zoomCombo = new JComboBox();
            this.zoomCombo.setFont(this.panelFont);
            this.zoomCombo.addItem("Zoom 100%");
            this.zoomCombo.addItem("Zoom 200%");
            this.zoomCombo.addItem("Zoom 300%");
            this.zoomCombo.addItem("Zoom 400%");
            this.zoomCombo.addItem("Zoom 500%");
            this.zoomCombo.addItem("Zoom 600%");
            this.zoomCombo.addItem("Zoom 700%");
            this.zoomCombo.addItem("Zoom 800%");
            this.zoomCombo.setEditable(false);
            this.zoomCombo.setBounds(5, 3, 120, 20);
            this.zoomCombo.addActionListener(this);
            this.zoomCfgPanel.add(this.zoomCombo);
            this.zoomText = new JLabel("");
            this.zoomText.setFont(this.panelFont);
            this.zoomText.setBounds(130, 3, 500, 20);
            this.zoomCfgPanel.add(this.zoomText);
            this.zoomPanel.add((Component)this.zoomCfgPanel, "South");
            this.zoomDialog = new JFrame();
            this.zoomDialog.setContentPane(this.zoomPanel);
            this.zoomDialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    NumberImageJViewer.this.zoomImage.setImage(null);
                    NumberImageJViewer.this.zoomDialog.dispose();
                }
            });
            this.zoomImage.addMouseMotionListener(this);
        }
    }

    protected void constructSettingsPanel() {
        if (this.settingsDialog == null) {
            this.settingsPanel = new JPanel();
            this.settingsPanel.setLayout(null);
            this.settingsPanel.setMinimumSize(new Dimension(290, 245));
            this.settingsPanel.setPreferredSize(new Dimension(290, 245));
            this.attNameLabel = new LabelViewer();
            this.attNameLabel.setOpaque(false);
            this.attNameLabel.setFont(new Font("Dialog", 1, 16));
            this.attNameLabel.setBounds(5, 5, 200, 30);
            this.attNameLabel.setHorizontalAlignment(JSmoothLabel.LEFT_ALIGNMENT);
            this.settingsPanel.add(this.attNameLabel);
            this.attNameLabel.setModel((IAttribute)this.model);
            this.propButton = new JButton();
            this.propButton.setText("?");
            this.propButton.setToolTipText("Edit attribute properties");
            this.propButton.setFont(this.panelFont);
            this.propButton.setMargin(new Insets(0, 0, 0, 0));
            this.propButton.setBounds(250, 5, 30, 30);
            this.propButton.addActionListener(this);
            this.settingsPanel.add(this.propButton);
            JSeparator jSeparator = new JSeparator();
            jSeparator.setBounds(0, 40, 500, 10);
            this.settingsPanel.add(jSeparator);
            this.autoBestFitCheck = new JCheckBox("Best fit");
            this.autoBestFitCheck.setSelected(true);
            this.autoBestFitCheck.setFont(this.panelFont);
            this.autoBestFitCheck.setBounds(5, 50, 100, 20);
            this.autoBestFitCheck.setToolTipText("Generate the best fit display using maximum and minimum value of the image");
            this.autoBestFitCheck.addActionListener(this);
            this.settingsPanel.add(this.autoBestFitCheck);
            this.bestFitCheck = new JCheckBox("Enable fitting");
            this.bestFitCheck.setSelected(false);
            this.bestFitCheck.setFont(this.panelFont);
            this.bestFitCheck.setBounds(120, 50, 105, 20);
            this.bestFitCheck.setToolTipText("Display the image using the whole color range");
            this.settingsPanel.add(this.bestFitCheck);
            this.minBestFitLabel = new JLabel("Fit Min");
            this.minBestFitLabel.setFont(this.panelFont);
            this.minBestFitLabel.setBounds(5, 75, 80, 20);
            this.settingsPanel.add(this.minBestFitLabel);
            this.minBestFitText = new JTextField("");
            this.minBestFitText.setMargin(this.noMargin);
            this.minBestFitText.setFont(this.panelFont);
            this.minBestFitText.setBounds(90, 75, 50, 20);
            this.settingsPanel.add(this.minBestFitText);
            this.maxBestFitLabel = new JLabel("Fit Max");
            this.maxBestFitLabel.setFont(this.panelFont);
            this.maxBestFitLabel.setBounds(145, 75, 80, 20);
            this.maxBestFitLabel.setHorizontalAlignment(0);
            this.settingsPanel.add(this.maxBestFitLabel);
            this.maxBestFitText = new JTextField("");
            this.maxBestFitText.setMargin(this.noMargin);
            this.maxBestFitText.setFont(this.panelFont);
            this.maxBestFitText.setBounds(230, 75, 50, 20);
            this.settingsPanel.add(this.maxBestFitText);
            this.gradLabel = new JLabel("Colormap");
            this.gradLabel.setFont(this.panelFont);
            this.gradLabel.setBounds(5, 100, 70, 20);
            this.settingsPanel.add(this.gradLabel);
            this.gradViewer = new JGradientEditor();
            this.gradViewer.setGradient(this.gColor);
            this.gradViewer.setEditable(false);
            this.gradViewer.setToolTipText("Display the image using this colormap");
            this.gradViewer.setBounds(80, 100, 180, 20);
            this.settingsPanel.add(this.gradViewer);
            this.gradButton = new JButton();
            this.gradButton.setText("...");
            this.gradButton.setToolTipText("Edit colormap");
            this.gradButton.setFont(this.panelFont);
            this.gradButton.setMargin(new Insets(0, 0, 0, 0));
            this.gradButton.setBounds(260, 100, 20, 20);
            this.gradButton.addActionListener(this);
            this.settingsPanel.add(this.gradButton);
            this.negativeCheck = new JCheckBox("Negative image");
            this.negativeCheck.setSelected(false);
            this.negativeCheck.setFont(this.panelFont);
            this.negativeCheck.setBounds(5, 125, 110, 20);
            this.negativeCheck.setToolTipText("Display the negative image");
            this.settingsPanel.add(this.negativeCheck);
            this.imageSizeLabel = new JLabel("Image size");
            this.imageSizeLabel.setFont(this.panelFont);
            this.imageSizeLabel.setBounds(115, 125, 85, 20);
            this.imageSizeLabel.setHorizontalAlignment(0);
            this.settingsPanel.add(this.imageSizeLabel);
            this.imageSizeCombo = new JComboBox();
            this.imageSizeCombo.setFont(this.panelFont);
            this.imageSizeCombo.addItem("800  %");
            this.imageSizeCombo.addItem("400  %");
            this.imageSizeCombo.addItem("200  %");
            this.imageSizeCombo.addItem("100  %");
            this.imageSizeCombo.addItem("50   %");
            this.imageSizeCombo.addItem("25   %");
            this.imageSizeCombo.addItem("12.5 %");
            this.imageSizeCombo.setBounds(200, 125, 80, 22);
            this.settingsPanel.add(this.imageSizeCombo);
            JSeparator jSeparator2 = new JSeparator();
            jSeparator2.setBounds(0, 153, 500, 10);
            this.settingsPanel.add(jSeparator2);
            this.sigHistogramCheck = new JCheckBox("Display significative data for histogram");
            this.sigHistogramCheck.setSelected(false);
            this.sigHistogramCheck.setFont(this.panelFont);
            this.sigHistogramCheck.setBounds(5, 185, 280, 20);
            this.sigHistogramCheck.setToolTipText("Clip the histogram to significative data");
            this.settingsPanel.add(this.sigHistogramCheck);
            this.okButton = new JButton();
            this.okButton.setText("Apply");
            this.okButton.setFont(this.panelFont);
            this.okButton.setBounds(5, 215, 80, 25);
            this.okButton.addActionListener(this);
            this.settingsPanel.add(this.okButton);
            this.cancelButton = new JButton();
            this.cancelButton.setText("Dismiss");
            this.cancelButton.setFont(this.panelFont);
            this.cancelButton.setBounds(205, 215, 80, 25);
            this.cancelButton.addActionListener(this);
            this.settingsPanel.add(this.cancelButton);
            Window window = ATKGraphicsUtils.getWindowForComponent(this);
            this.settingsDialog = window instanceof Frame ? new JDialog((Frame)window, true) : (window instanceof Dialog ? new JDialog((Dialog)window, true) : new JDialog((Frame)null, true));
            this.settingsDialog.setResizable(false);
            this.settingsDialog.setContentPane(this.settingsPanel);
            this.settingsDialog.setTitle("Image viewer settings");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.selectButton || actionEvent.getSource() == this.selectionMenuItem) {
            this.imagePanel.deleteAllROIs();
            this.profileMode = 0;
            this.freePopup();
            NumberImageJViewer numberImageJViewer = this;
            synchronized (numberImageJViewer) {
                this.refreshStatusLine();
                this.refreshSelectionMinMax();
            }
        }
        if (actionEvent.getSource() == this.selectMaxButton || actionEvent.getSource() == this.selectionMaxMenuItem) {
            Dimension dimension = this.imagePanel.getImageSize();
            this.imagePanel.setSelection(0, 0, dimension.width, dimension.height);
            this.selectionChanged();
        } else if (actionEvent.getSource() == this.roiColorsButton) {
            this.roiColorsMenu.show(this.roiColorsButton, this.roiColorsButton.getWidth(), 0);
        } else if (actionEvent.getSource() == this.roiColorMenuItem || actionEvent.getSource() == this.selectionColorMenuItem) {
            this.changeROIColor();
        } else if (actionEvent.getSource() == this.selectedRoiColorMenuItem) {
            this.changeROISelectionColor();
        } else if (actionEvent.getSource() == this.innerRoiColorMenuItem) {
            this.changeInteriorROIColor();
        } else if (actionEvent.getSource() == this.selectedInnerRoiColorMenuItem) {
            this.changeInteriorROISelectionColor();
        } else if (actionEvent.getSource() == this.outerRoiColorMenuItem) {
            this.changeExteriorROIColor();
        } else if (actionEvent.getSource() == this.selectedOuterRoiColorMenuItem) {
            this.changeExteriorROISelectionColor();
        } else if (actionEvent.getSource() == this.fileButton || actionEvent.getSource() == this.fileMenuItem) {
            this.saveFile();
        } else {
            if (actionEvent.getSource() == this.profileButton || actionEvent.getSource() == this.lineProfileMenuItem) {
                Serializable serializable;
                AdvancedImagePlus advancedImagePlus = this.imagePanel.getImagePlus();
                if (advancedImagePlus != null) {
                    serializable = advancedImagePlus.getAllRois();
                    if (serializable != null) {
                        for (int i = 0; i < ((Vector)serializable).size(); ++i) {
                            if (!(((Vector)serializable).get(i) instanceof Line)) continue;
                            advancedImagePlus.setHandledRoi((Roi)((Vector)serializable).get(i));
                            break;
                        }
                        serializable = null;
                    }
                    advancedImagePlus = null;
                }
                this.constructLineProfiler();
                this.lineProfiler.setLineProfileMode();
                this.lineProfiler.setVisible(true);
                this.profileMode = 1;
                serializable = this;
                synchronized (serializable) {
                    this.refreshStatusLine();
                    this.refreshLineProfile();
                }
            }
            if (actionEvent.getSource() == this.histoButton || actionEvent.getSource() == this.histogramMenuItem) {
                this.constructLineProfiler();
                this.lineProfiler.setHistogramMode();
                this.lineProfiler.setVisible(true);
                this.profileMode = 2;
                NumberImageJViewer numberImageJViewer = this;
                synchronized (numberImageJViewer) {
                    this.refreshStatusLine();
                    this.refreshLineProfile();
                }
            }
            if (actionEvent.getSource() == this.bestFitMenuItem) {
                this.setBestFit(!this.isBestFit());
            } else if (actionEvent.getSource() == this.negativeMenuItem) {
                this.setNegative(!this.isNegative());
            } else if (actionEvent.getSource() == this.toolbarMenuItem) {
                this.setToolbarVisible(!this.isToolbarVisible());
            } else if (actionEvent.getSource() == this.statusLineMenuItem) {
                this.setStatusLineVisible(!this.isStatusLineVisible());
            } else if (actionEvent.getSource() == this.showGradMenuItem) {
                this.setGradientVisible(!this.isGradientVisible());
            } else if (actionEvent.getSource() == this.zoomButton || actionEvent.getSource() == this.zoomMenuItem) {
                this.showZoom();
            } else if (actionEvent.getSource() == this.zoomCombo) {
                this.zoomFactor = this.zoomCombo.getSelectedIndex();
                Object object = this;
                synchronized (object) {
                    this.buildZoom();
                }
                this.zoomImage.revalidate();
                this.zoomPanel.revalidate();
                this.zoomView.revalidate();
                this.zoomDialog.pack();
                object = Toolkit.getDefaultToolkit();
                Dimension dimension = ((Toolkit)object).getScreenSize();
                Dimension dimension2 = this.zoomDialog.getPreferredSize();
                this.zoomDialog.setBounds((dimension.width - dimension2.height) / 2, (dimension.height - dimension2.height) / 2, dimension2.width, dimension2.height);
            } else if (actionEvent.getSource() == this.settingsButton || actionEvent.getSource() == this.settingsMenuItem) {
                this.showSettings();
            } else if (actionEvent.getSource() == this.autoBestFitCheck) {
                this.autoBestFit = !this.autoBestFit;
                this.minBestFitLabel.setEnabled(!this.autoBestFit);
                this.minBestFitText.setEnabled(!this.autoBestFit);
                this.maxBestFitLabel.setEnabled(!this.autoBestFit);
                this.maxBestFitText.setEnabled(!this.autoBestFit);
            } else if (actionEvent.getSource() == this.cancelButton) {
                this.settingsDialog.setVisible(false);
            } else if (actionEvent.getSource() == this.axisButton) {
                this.showAxisDialog();
            } else if (actionEvent.getSource() == this.axisCloseButton) {
                this.axisDialog.setVisible(false);
            } else if (actionEvent.getSource() == this.okButton) {
                this.applySettings();
            } else if (actionEvent.getSource() == this.tableButton || actionEvent.getSource() == this.tableMenuItem) {
                this.showTable();
            } else if (actionEvent.getSource() == this.propButton) {
                this.showPropertyFrame();
            } else if (actionEvent.getSource() == this.gradButton) {
                this.showGradientEditor();
            } else if (actionEvent.getSource() == this.loadButton || actionEvent.getSource() == this.loadMenuItem) {
                this.loadButtonActionPerformed();
            } else if (actionEvent.getSource() == this.saveButton || actionEvent.getSource() == this.saveMenuItem) {
                this.saveButtonActionPerformed();
            } else if (actionEvent.getSource() == this.saveDataFileMenuItem) {
                this.saveDataFile();
            } else if (actionEvent.getSource() == this.printButton || actionEvent.getSource() == this.printMenuItem) {
                this.printImage();
            } else if (actionEvent.getSource() == this.displayLogMenuItem) {
                this.setLogValues(this.displayLogMenuItem.isSelected());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.imagePanel.getImageRenderer()) {
            NumberImageJViewer numberImageJViewer = this;
            synchronized (numberImageJViewer) {
                this.refreshStatusLine();
                this.refreshSelectionMinMax();
                this.refreshLineProfile();
            }
        }
        this.mouseMoved(mouseEvent);
    }

    public synchronized void mouseMoved(MouseEvent mouseEvent) {
        Dimension dimension = this.getCurrentImageSize();
        if (this.doubleValues != null) {
            if (mouseEvent.getSource() == this.imagePanel.getImageRenderer()) {
                int n = (int)Math.floor((double)(mouseEvent.getX() - this.imagePanel.getXOrigin()) / this.imagePanel.getZoom());
                int n2 = (int)Math.floor((double)(mouseEvent.getY() - this.imagePanel.getYOrigin()) / this.imagePanel.getZoom());
                if (n >= dimension.width || n2 >= dimension.height || n2 < 0 || n < 0) {
                    this.statusLabel.setText(this.getLabelInfoString());
                } else {
                    this.statusLabel.setText(this.getLabelInfoString() + " (" + n + "," + n2 + ")=" + Double.toString(this.doubleValues[n2][n]));
                }
                this.refreshStatusLine();
            } else if (mouseEvent.getSource() == this.zoomImage) {
                int n = (mouseEvent.getX() - this.zoomImage.getXOrigin()) / (this.zoomFactor + 1) + this.zoomXOrg;
                int n3 = (mouseEvent.getY() - this.zoomImage.getYOrigin()) / (this.zoomFactor + 1) + this.zoomYOrg;
                if (n >= dimension.width || n3 >= dimension.height || n3 < 0 || n < 0) {
                    this.zoomText.setText("");
                } else {
                    this.zoomText.setText("(" + n + "," + n3 + ") " + Double.toString(this.doubleValues[n3][n]));
                }
            }
        } else {
            this.statusLabel.setText("");
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.imagePanel.getImageRenderer()) {
            NumberImageJViewer numberImageJViewer = this;
            synchronized (numberImageJViewer) {
                this.refreshStatusLine();
                this.refreshSelectionMinMax();
                this.refreshLineProfile();
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Rectangle rectangle = this.imagePanel.getCurrentRoiBounds();
        if (rectangle != null) {
            if (this.oldSelection == null) {
                this.selectionChanged();
            } else if (!rectangle.equals(this.oldSelection)) {
                this.selectionChanged();
            }
        }
        this.oldSelection = rectangle;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 3 && this.showingMenu && mouseEvent.getSource() == this.imagePanel.getImageRenderer()) {
            this.bestFitMenuItem.setSelected(this.isBestFit());
            this.negativeMenuItem.setSelected(this.isNegative());
            this.toolbarMenuItem.setSelected(this.isToolbarVisible());
            this.statusLineMenuItem.setSelected(this.isStatusLineVisible());
            this.showGradMenuItem.setSelected(this.isGradientVisible());
            this.imgMenu.show(this.imagePanel.getImageRenderer(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent.getSource() == this.imagePanel.getImageRenderer()) {
            NumberImageJViewer numberImageJViewer = this;
            synchronized (numberImageJViewer) {
                this.statusLabel.setText(this.getLabelInfoString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.selText) {
            if (keyEvent.getKeyCode() == 10) {
                Object object;
                String string = this.selText.getText();
                try {
                    string = string.substring(string.indexOf(40) + 1);
                    object = string.substring(0, string.indexOf(44));
                    string = string.substring(string.indexOf(44) + 1);
                    String string2 = string.substring(0, string.indexOf(41));
                    string = string.substring(string.indexOf(91) + 1);
                    String string3 = string.substring(0, string.indexOf(44));
                    string = string.substring(string.indexOf(44) + 1);
                    String string4 = string.substring(0, string.indexOf(93));
                    int n = Integer.parseInt((String)object);
                    int n2 = Integer.parseInt(string2);
                    int n3 = Integer.parseInt(string3);
                    int n4 = Integer.parseInt(string4);
                    this.imagePanel.setSelection(n, n2, n + n3, n2 + n4);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, "Invalid syntax for selection", "Error", 0);
                }
                object = this.imagePanel.getCurrentRoiBounds();
                if (object != null) {
                    if (this.oldSelection == null) {
                        this.selectionChanged();
                    } else if (!((Rectangle)object).equals(this.oldSelection)) {
                        this.selectionChanged();
                    }
                }
                this.oldSelection = object;
                this.refreshStatusLine();
            }
        } else if (keyEvent.getSource() == this.imagePanel.getImageRenderer()) {
            switch (keyEvent.getKeyCode()) {
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    NumberImageJViewer numberImageJViewer = this;
                    synchronized (numberImageJViewer) {
                        this.refreshStatusLine();
                        this.refreshSelectionMinMax();
                        this.refreshLineProfile();
                        break;
                    }
                }
                case 45: 
                case 107: 
                case 109: 
                case 521: {
                    NumberImageJViewer numberImageJViewer = this;
                    synchronized (numberImageJViewer) {
                        this.statusLabel.setText(this.getLabelInfoString());
                        break;
                    }
                }
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void errorChange(ErrorEvent errorEvent) {
        this.setData(null);
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void imageChange(NumberImageEvent numberImageEvent) {
        if (this.logValues) {
            this.setData(this.computeLog(numberImageEvent.getValue()));
        } else {
            this.setData(numberImageEvent.getValue());
        }
    }

    public void setModel(INumberImage iNumberImage) {
        if (this.settingsDialog != null) {
            this.attNameLabel.setModel((IAttribute)iNumberImage);
        }
        if (this.model != null) {
            this.model.removeImageListener((IImageListener)this);
            this.model = null;
        }
        if (iNumberImage != null) {
            this.imagePanel.setImage(null);
            this.firstRefresh = !this.userZoom;
            this.freePopup();
            this.model = iNumberImage;
            this.model.addImageListener((IImageListener)this);
            this.model.refresh();
        }
    }

    public INumberImage getModel() {
        return this.model;
    }

    public void clearModel() {
        this.setModel(null);
    }

    protected void saveEdf(String string) {
        if (this.doubleValues == null) {
            JOptionPane.showMessageDialog(this, "No data to save.");
            return;
        }
        Dimension dimension = this.getCurrentImageSize();
        Rectangle rectangle = this.imagePanel.getCurrentRoiBounds();
        if (rectangle == null) {
            rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        }
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            JOptionPane.showMessageDialog(this, "No area selected.");
            return;
        }
        try {
            FileWriter fileWriter = new FileWriter(string);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{\n");
            stringBuffer.append("HeaderID       = EH:000001:000000:000000 ;\n");
            stringBuffer.append("Image          = 1 ;\n");
            stringBuffer.append("ByteOrder      = LowByteFirst ;\n");
            stringBuffer.append("DataType       = UnsignedShort ;\n");
            stringBuffer.append("Dim_1          = " + rectangle.width + " ;\n");
            stringBuffer.append("Dim_2          = " + rectangle.height + " ;\n");
            stringBuffer.append("Size           = " + rectangle.width * rectangle.height * 2 + " ;\n");
            stringBuffer.append("count_time     = 0 ;\n");
            stringBuffer.append("point_no       = 0 ;\n");
            stringBuffer.append("preset         = 1.0 ;\n");
            stringBuffer.append("col_end        = " + (rectangle.width - 1) + " ;\n");
            stringBuffer.append("row_end        = " + (rectangle.height - 1) + " ;\n");
            stringBuffer.append("dir            = . ;\n");
            stringBuffer.append("suffix         = edf ;\n");
            stringBuffer.append("prefix         = ;\n");
            stringBuffer.append("run            = 1 ;\n");
            stringBuffer.append("description    = ;\n");
            stringBuffer.append("title          = snapshot ;\n");
            for (int i = stringBuffer.length(); i < 1022; ++i) {
                stringBuffer.append(' ');
            }
            stringBuffer.append("}\n");
            fileWriter.write(stringBuffer.toString());
            char[] cArray = new char[2];
            for (int i = rectangle.y; i < rectangle.y + rectangle.height; ++i) {
                for (int j = rectangle.x; j < rectangle.x + rectangle.width; ++j) {
                    int n = (int)this.doubleValues[i][j];
                    cArray[0] = (char)(n & 0xFF);
                    cArray[1] = (char)(n >> 8 & 0xFF);
                    fileWriter.write(cArray);
                }
            }
            fileWriter.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Error during saving file.\n" + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void constructTable() {
        this.constructTablePanel();
        NumberImageJViewer numberImageJViewer = this;
        synchronized (numberImageJViewer) {
            if (!this.buildTable()) {
                return;
            }
        }
    }

    private void saveDataFile() {
        this.constructTable();
        if (this.tablePanel != null) {
            this.tablePanel.saveDataFile();
        }
    }

    protected String getLabelInfoString() {
        Dimension dimension = this.getCurrentImageSize();
        int n = (int)(100.0 * this.imagePanel.getZoom());
        return n + "% [" + dimension.width + "," + dimension.height + "]";
    }

    protected void computeVerticalExtent() {
        int n;
        int n2;
        if (this.doubleValues == null) {
            return;
        }
        if (this.verticalExtent == 1) {
            return;
        }
        int n3 = this.doubleValues.length;
        if (n3 == 0) {
            return;
        }
        int n4 = this.doubleValues[0].length;
        if (n4 == 0) {
            return;
        }
        double[][] dArray = new double[(n3 - 1) * this.verticalExtent + 1][n4];
        for (n2 = 0; n2 < n3 - 1; ++n2) {
            for (n = 0; n < n4; ++n) {
                for (int i = 0; i < this.verticalExtent; ++i) {
                    double d = this.doubleValues[n2][n];
                    double d2 = this.doubleValues[n2 + 1][n];
                    double d3 = (double)i / (double)this.verticalExtent;
                    dArray[n2 * this.verticalExtent + i][n] = d * (1.0 - d3) + d2 * d3;
                }
            }
        }
        n2 = (n3 - 1) * this.verticalExtent;
        for (n = 0; n < n4; ++n) {
            dArray[n2][n] = this.doubleValues[n3 - 1][n];
        }
        this.doubleValues = dArray;
    }

    protected void computeAutoZoom() {
        int n;
        if (this.doubleValues == null) {
            return;
        }
        if ((this.firstRefresh || this.autoZoom) && this.doubleValues.length > 0 && (n = this.doubleValues.length) > 0) {
            int n2;
            int n3;
            if (n3 > 800 || n > 600) {
                for (n2 = 1; (n3 > 800 || n > 600) && n2 < 8 && n3 % 2 == 0 && n % 2 == 0; n3 /= 2, n /= 2, n2 *= 2) {
                }
                this.iSz = n2;
            } else {
                for (n3 = this.doubleValues[0].length; n3 < 600 && n < 400 && n2 < 4; n3 *= 2, n *= 2, n2 *= 2) {
                }
                this.iSz = n2 != 1 ? -n2 : 1;
            }
            this.firstRefresh = false;
        }
    }

    protected void preComputeBestFit() {
        if (!this.isBestFit) {
            this.gradientTool.getAxis().setMinimum(0.0);
            this.gradientTool.getAxis().setMaximum(65536.0);
            this.gradientTool.repaint();
            return;
        }
        if (this.doubleValues == null) {
            return;
        }
        if (this.autoBestFit) {
            this.autoBfMin = 65536.0;
            this.autoBfMax = 0.0;
            for (int i = 0; i < this.doubleValues.length; ++i) {
                for (int j = 0; j < this.doubleValues[i].length; ++j) {
                    double d = this.doubleValues[i][j];
                    if (Double.isNaN(d) || Double.isInfinite(d)) continue;
                    if (d > this.autoBfMax) {
                        this.autoBfMax = d;
                    }
                    if (!(d < this.autoBfMin)) continue;
                    this.autoBfMin = d;
                }
            }
            if (this.autoBfMin == 65536.0 && this.autoBfMax == 0.0) {
                this.autoBfMin = 0.0;
                this.autoBfMax = 0.0;
            }
            this.bfa0 = -this.autoBfMin;
            if (this.autoBfMax == this.autoBfMin) {
                this.bfa1 = 0.0;
                this.gradientTool.getAxis().setMinimum(this.autoBfMin);
                this.gradientTool.getAxis().setMaximum(this.autoBfMax + 1.0);
                this.gradientTool.repaint();
            } else {
                this.bfa1 = 65536.0 / (this.autoBfMax - this.autoBfMin);
                this.gradientTool.getAxis().setMinimum(this.autoBfMin);
                this.gradientTool.getAxis().setMaximum(this.autoBfMax);
                this.gradientTool.repaint();
            }
        } else {
            this.bfa0 = -this.bfMin;
            this.bfa1 = this.bfMax == this.bfMin ? 0.0 : 65536.0 / (this.bfMax - this.bfMin);
            this.gradientTool.getAxis().setMinimum(this.bfMin);
            this.gradientTool.getAxis().setMaximum(this.bfMax);
            this.gradientTool.repaint();
        }
    }

    protected int bestFit(double d) {
        int n = (int)((this.bfa0 + d) * this.bfa1);
        if (n < 0) {
            return 0;
        }
        if (n > 65535) {
            return 65535;
        }
        return n;
    }

    protected boolean buildZoom() {
        if (this.doubleValues == null) {
            return false;
        }
        Rectangle rectangle = null;
        if (this.imagePanel.getImagePlus().getSelectedRois().size() > 0) {
            rectangle = this.imagePanel.getImagePlus().getSelectedRois().get(this.imagePanel.getImagePlus().getSelectedRois().size() - 1).getBounds();
        }
        if (rectangle == null) {
            return false;
        }
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return false;
        }
        this.zoomXOrg = rectangle.x;
        this.zoomYOrg = rectangle.y;
        int n = this.zoomFactor + 1;
        BufferedImage bufferedImage = new BufferedImage(rectangle.width * n, rectangle.height * n, 1);
        int[] nArray = new int[rectangle.width * n];
        this.preComputeBestFit();
        for (int i = rectangle.y; i < rectangle.y + rectangle.height; ++i) {
            int n2;
            for (n2 = rectangle.x; n2 < rectangle.x + rectangle.width; ++n2) {
                int n3;
                int n4;
                if (this.isNegative) {
                    if (this.isBestFit) {
                        n4 = this.gColormap[~this.bestFit(this.doubleValues[i][n2]) & 0xFFFF];
                        for (n3 = 0; n3 < n; ++n3) {
                            nArray[(n2 - rectangle.x) * n + n3] = n4;
                        }
                        continue;
                    }
                    n4 = this.gColormap[~((int)this.doubleValues[i][n2]) & 0xFFFF];
                    for (n3 = 0; n3 < n; ++n3) {
                        nArray[(n2 - rectangle.x) * n + n3] = n4;
                    }
                    continue;
                }
                if (this.isBestFit) {
                    n4 = this.gColormap[this.bestFit(this.doubleValues[i][n2])];
                    for (n3 = 0; n3 < n; ++n3) {
                        nArray[(n2 - rectangle.x) * n + n3] = n4;
                    }
                    continue;
                }
                n4 = this.gColormap[(int)this.doubleValues[i][n2] & 0xFFFF];
                for (n3 = 0; n3 < n; ++n3) {
                    nArray[(n2 - rectangle.x) * n + n3] = n4;
                }
            }
            for (n2 = 0; n2 < n; ++n2) {
                bufferedImage.setRGB(0, (i - rectangle.y) * n + n2, rectangle.width * n, 1, nArray, 0, rectangle.width * n);
            }
        }
        this.zoomImage.setImage(bufferedImage);
        return true;
    }

    protected void saveFile() {
        File file;
        int n;
        int n2 = 0;
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = MultiExtFileFilter.getExtension(file);
                return string != null && string.equals("edf");
            }

            public String getDescription() {
                return "edf - EDF pictues (Mono 16 Bits)";
            }

            public boolean equals(Object object) {
                if (object == null) {
                    return false;
                }
                if (object instanceof FileFilter) {
                    return this.getDescription().equals(((FileFilter)object).getDescription());
                }
                return false;
            }
        };
        FileFilter fileFilter2 = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = MultiExtFileFilter.getExtension(file);
                return string != null && string.equals("jpg");
            }

            public String getDescription() {
                return "jpg - JPEG pictures (Color 24 Bits)";
            }

            public boolean equals(Object object) {
                if (object == null) {
                    return false;
                }
                if (object instanceof FileFilter) {
                    return this.getDescription().equals(((FileFilter)object).getDescription());
                }
                return false;
            }
        };
        FileFilter fileFilter3 = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = MultiExtFileFilter.getExtension(file);
                return string != null && string.equals("jpg");
            }

            public String getDescription() {
                return "jpg - JPEG pictures (Mono 8 Bits)";
            }

            public boolean equals(Object object) {
                if (object == null) {
                    return false;
                }
                if (object instanceof FileFilter) {
                    return this.getDescription().equals(((FileFilter)object).getDescription());
                }
                return false;
            }
        };
        FileFilter fileFilter4 = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = MultiExtFileFilter.getExtension(file);
                return string != null && string.equals("png");
            }

            public String getDescription() {
                return "png - PNG pictures (Color 24 Bits)";
            }

            public boolean equals(Object object) {
                if (object == null) {
                    return false;
                }
                if (object instanceof FileFilter) {
                    return this.getDescription().equals(((FileFilter)object).getDescription());
                }
                return false;
            }
        };
        FileFilter fileFilter5 = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = MultiExtFileFilter.getExtension(file);
                return string != null && string.equals("png");
            }

            public String getDescription() {
                return "png - PNG pictures (Mono 8 Bits)";
            }

            public boolean equals(Object object) {
                if (object == null) {
                    return false;
                }
                if (object instanceof FileFilter) {
                    return this.getDescription().equals(((FileFilter)object).getDescription());
                }
                return false;
            }
        };
        FileFilter[] fileFilterArray = new FileFilter[]{fileFilter4, fileFilter5, fileFilter2, fileFilter3, fileFilter};
        JFileChooser jFileChooser = new JFileChooser(this.lastSnapshotLocation);
        for (n = 0; n < fileFilterArray.length; ++n) {
            if (fileFilterArray[n].equals(this.lastFileFilter)) continue;
            jFileChooser.addChoosableFileFilter(fileFilterArray[n]);
        }
        if (this.lastFileFilter != null) {
            jFileChooser.addChoosableFileFilter(this.lastFileFilter);
        }
        jFileChooser.setDialogTitle("Save snapshot");
        n = jFileChooser.showSaveDialog(this);
        if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            this.lastSnapshotLocation = file.getParentFile().getAbsolutePath();
            FileFilter fileFilter6 = jFileChooser.getFileFilter();
            if (fileFilter.equals(fileFilter6)) {
                if (MultiExtFileFilter.getExtension(file) == null || !MultiExtFileFilter.getExtension(file).equalsIgnoreCase("edf")) {
                    file = new File(file.getAbsolutePath() + ".edf");
                }
                this.lastFileFilter = fileFilter6;
            } else if (fileFilter2.equals(fileFilter6) || fileFilter3.equals(fileFilter6)) {
                if (MultiExtFileFilter.getExtension(file) == null || !MultiExtFileFilter.getExtension(file).equalsIgnoreCase("jpg")) {
                    file = new File(file.getAbsolutePath() + ".jpg");
                }
                this.lastFileFilter = fileFilter6;
            } else if (fileFilter4.equals(fileFilter6) || fileFilter5.equals(fileFilter6)) {
                if (MultiExtFileFilter.getExtension(file) == null || !MultiExtFileFilter.getExtension(file).equalsIgnoreCase("png")) {
                    file = new File(file.getAbsolutePath() + ".png");
                }
                this.lastFileFilter = fileFilter6;
            } else {
                JOptionPane.showMessageDialog(this, "Please select a valid image format", "Error", 0);
                return;
            }
            if (file.exists()) {
                n2 = JOptionPane.showConfirmDialog(this, "Do you want to overwrite " + file.getName() + " ?", "Confirm overwrite", 0);
            }
            if (n2 == 0) {
                if (fileFilter.equals(fileFilter6)) {
                    this.saveEdf(file.getAbsolutePath());
                } else if (fileFilter2.equals(fileFilter6)) {
                    try {
                        ImageIO.write((RenderedImage)this.imagePanel.getImage(), "jpg", file);
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(this, "File could not be saved", "Error", 0);
                    }
                } else if (fileFilter3.equals(fileFilter6)) {
                    try {
                        ImageIO.write((RenderedImage)this.get8BitImage(), "jpg", file);
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(this, "File could not be saved", "Error", 0);
                    }
                } else if (fileFilter4.equals(fileFilter6)) {
                    try {
                        ImageIO.write((RenderedImage)this.imagePanel.getImage(), "png", file);
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(this, "File could not be saved", "Error", 0);
                    }
                } else if (fileFilter5.equals(fileFilter6)) {
                    try {
                        ImageIO.write((RenderedImage)this.get8BitImage(), "png", file);
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(this, "File could not be saved", "Error", 0);
                    }
                }
            }
        }
        fileFilter4 = null;
        fileFilter5 = null;
        fileFilter2 = null;
        fileFilter3 = null;
        fileFilter = null;
        for (int i = 0; i < fileFilterArray.length; ++i) {
            fileFilterArray[i] = null;
        }
        fileFilterArray = null;
    }

    protected BufferedImage get8BitImage() {
        int n = this.imagePanel.getImage().getWidth();
        int n2 = this.imagePanel.getImage().getHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 10);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage((Image)this.imagePanel.getImage(), 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    protected void convertImage() {
        if (this.doubleValues == null) {
            return;
        }
        if (this.doubleValues.length > 0) {
            int n = this.doubleValues.length;
            if (n > 0) {
                int n2 = this.doubleValues[0].length;
                BufferedImage bufferedImage = this.imagePanel.getImage();
                if (bufferedImage == null || bufferedImage.getHeight() != n || bufferedImage.getWidth() != n2) {
                    bufferedImage = new BufferedImage(n2, n, 1);
                    this.imagePanel.setImage(bufferedImage);
                    this.freePopup();
                    this.statusLabel.setText(this.getLabelInfoString());
                    this.refreshComponents();
                }
                int[] nArray = new int[n2];
                this.preComputeBestFit();
                for (int i = 0; i < n; ++i) {
                    int n3;
                    int n4;
                    if (this.isBestFit) {
                        if (this.isNegative) {
                            for (n4 = 0; n4 < n2; ++n4) {
                                nArray[n4] = n3 = this.gColormap[~this.bestFit(this.doubleValues[i][n4]) & 0xFFFF];
                            }
                        } else {
                            for (n4 = 0; n4 < n2; ++n4) {
                                nArray[n4] = n3 = this.gColormap[this.bestFit(this.doubleValues[i][n4])];
                            }
                        }
                    } else if (this.isNegative) {
                        for (n4 = 0; n4 < n2; ++n4) {
                            nArray[n4] = n3 = this.gColormap[~((int)this.doubleValues[i][n4]) & 0xFFFF];
                        }
                    } else {
                        for (n4 = 0; n4 < n2; ++n4) {
                            nArray[n4] = n3 = this.gColormap[(int)this.doubleValues[i][n4] & 0xFFFF];
                        }
                    }
                    bufferedImage.setRGB(0, i, n2, 1, nArray, 0, n2);
                }
                double d = this.iSz < 0 ? (double)(-this.iSz) : 1.0 / (double)this.iSz;
                this.imagePanel.refreshImage();
                this.imagePanel.setZoom(d);
                return;
            }
            this.doubleValues = null;
        } else {
            this.doubleValues = null;
        }
    }

    public void printImage() {
        ATKGraphicsUtils.printComponent(this.imagePanel, "Print Image", true, 0);
    }

    public boolean isLogValues() {
        return this.logValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogValues(boolean bl) {
        if (bl != this.logValues) {
            NumberImageJViewer numberImageJViewer = this;
            synchronized (numberImageJViewer) {
                if (this.model != null) {
                    try {
                        double[][] dArray = this.model.getValue();
                        if (bl) {
                            this.setData(this.computeLog(dArray));
                        } else {
                            this.setData(dArray);
                        }
                    }
                    catch (DevFailed devFailed) {
                        this.setData(null);
                    }
                }
            }
        }
        this.logValues = bl;
    }

    protected double[][] computeLog(double[][] dArray) {
        if (dArray == null) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        n = dArray.length;
        if (n > 0) {
            n2 = dArray[0].length;
        }
        double[][] dArray2 = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray2[i][j] = Math.log10(dArray[i][j]);
            }
        }
        return dArray2;
    }

    protected void changeROIColor() {
        this.roiColorsMenu.setVisible(false);
        Color color = JColorChooser.showDialog(this, "Choose ROI Color", this.imagePanel.getRoiColor());
        if (color != null) {
            this.imagePanel.setRoiColor(color);
            this.imagePanel.repaint();
        }
    }

    protected void changeROISelectionColor() {
        this.roiColorsMenu.setVisible(false);
        Color color = JColorChooser.showDialog(this, "Choose ROI Selection Color", this.imagePanel.getRoiSelectionColor());
        if (color != null) {
            this.imagePanel.setRoiSelectionColor(color);
            this.imagePanel.repaint();
        }
    }

    protected void changeInteriorROIColor() {
        this.roiColorsMenu.setVisible(false);
        Color color = JColorChooser.showDialog(this, "Choose Interior ROI Color", this.imagePanel.getRoiInsideColor());
        if (color != null) {
            this.imagePanel.setRoiInsideColor(color);
            this.imagePanel.repaint();
        }
    }

    protected void changeInteriorROISelectionColor() {
        this.roiColorsMenu.setVisible(false);
        Color color = JColorChooser.showDialog(this, "Choose Interior ROI Selection Color", this.imagePanel.getRoiInsideSelectionColor());
        if (color != null) {
            this.imagePanel.setRoiInsideSelectionColor(color);
            this.imagePanel.repaint();
        }
    }

    protected void changeExteriorROIColor() {
        this.roiColorsMenu.setVisible(false);
        Color color = JColorChooser.showDialog(this, "Choose Exterior ROI Color", this.imagePanel.getRoiOutsideColor());
        if (color != null) {
            this.imagePanel.setRoiOutsideColor(color);
            this.imagePanel.repaint();
        }
    }

    protected void changeExteriorROISelectionColor() {
        this.roiColorsMenu.setVisible(false);
        Color color = JColorChooser.showDialog(this, "Choose Exterior ROI Selection Color", this.imagePanel.getRoiOutsideSelectionColor());
        if (color != null) {
            this.imagePanel.setRoiOutsideSelectionColor(color);
            this.imagePanel.repaint();
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        JFrame jFrame = new JFrame();
        NumberImageJViewer numberImageJViewer = new NumberImageJViewer();
        AttributeList attributeList = new AttributeList();
        final ErrorHistory errorHistory = new ErrorHistory();
        attributeList.addErrorListener((IErrorListener)errorHistory);
        try {
            object2 = stringArray.length > 0 ? stringArray[0] : "jlp/test/1/att_image";
            object = (INumberImage)attributeList.add((String)object2);
            numberImageJViewer.setModel((INumberImage)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)numberImageJViewer, "Center");
        object = new JPanel();
        object2 = new JButton("Show errors");
        ((AbstractButton)object2).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                errorHistory.setVisible(true);
            }
        });
        ((Container)object).add((Component)object2);
        JButton jButton = new JButton("Show diag");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ATKDiagnostic.showDiagnostic();
            }
        });
        ((Container)object).add(jButton);
        jFrame.getContentPane().add((Component)object, "South");
        jFrame.setDefaultCloseOperation(3);
        jFrame.setTitle("ImageViewer");
        jFrame.pack();
        jFrame.setVisible(true);
        attributeList.setRefreshInterval(1000);
        attributeList.refresh();
    }
}

