/*
 * Decompiled with CFR 0.152.
 */
package pogo.make_util;

import java.util.Date;
import pogo.gene.PogoException;
import pogo.gene.PogoString;
import pogo.gene.PogoUtil;

public class UpdateRevision {
    private static final String declare = "private static String revNumber =";
    private static final String declareTab = "private static String\trevNumber =";
    private String filename = null;
    private String revision = null;
    private PogoString code;

    public UpdateRevision(String[] args) throws Exception {
        this.checkArguments(args);
        System.out.println("filename = " + this.filename + "  revision = " + this.revision);
        this.code = new PogoString(PogoUtil.readFile(this.filename));
        this.updateCode();
        PogoUtil.writeFile(this.filename, this.code.str);
    }

    private void updateCode() throws PogoException {
        int start = this.code.str.indexOf(declare);
        if (start < 0) {
            start = this.code.str.indexOf(declareTab);
        }
        if (start < 0) {
            throw new PogoException("Revision declaration not found !");
        }
        int end = this.code.str.indexOf(";", start);
        if ((start = this.code.str.indexOf("\"", start)) < 0 || end < 0) {
            throw new PogoException("Syntax error in revision declaration !");
        }
        end = this.code.str.lastIndexOf("\"", end);
        if (++start < 0 || end < 0) {
            throw new PogoException("Syntax error in revision declaration !");
        }
        String oldstr = this.code.str.substring(start, end);
        String newstr = this.buildNewRevision();
        System.out.println("Replacing");
        System.out.println(oldstr);
        System.out.println(newstr);
        this.code.replace(oldstr, newstr);
    }

    private String buildNewRevision() {
        Date date = new Date();
        return "Release " + this.revision + "  -  " + date.toString();
    }

    private void checkArguments(String[] args) {
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-?")) {
                    this.displaySyntax();
                    continue;
                }
                if (args[i].equals("-f")) {
                    this.filename = args[++i];
                    continue;
                }
                if (!args[i].equals("-r")) continue;
                this.revision = args[++i];
            }
            if (this.filename == null || this.revision == null) {
                this.displaySyntax();
            }
        }
        catch (Exception e) {
            this.displaySyntax();
        }
    }

    private void displaySyntax() {
        System.out.println("java pogo.gene.UpdateRevision   -f <file name>   -r <revision number>");
        System.exit(0);
    }

    public static void main(String[] args) {
        UpdateRevision client = null;
        try {
            client = new UpdateRevision(args);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

