/*
 * Decompiled with CFR 0.152.
 */
package pogo.class2www;

import java.io.IOException;
import java.util.Vector;
import pogo.class2www.Family;
import pogo.class2www.Module;
import pogo.class2www.Repositories;
import pogo.class2www.Repository;
import pogo.class2www.Utils;
import pogo.gene.PogoUtil;

public class HtmlMainPage {
    public Repositories repositories;
    private String title;
    private String[] repos_names;
    private String[] link_to;

    public HtmlMainPage(String title, Repositories repositories, String[] repos_names, String[] link_to) {
        this.repositories = repositories;
        this.repos_names = repos_names;
        this.link_to = link_to;
        this.title = title;
        if (title == null) {
            this.title = "Repository";
        }
    }

    public void generate() {
        this.generateIndex();
        this.generateList();
        this.generateFamilyPages();
        this.generateAlphabetical();
    }

    private void generateFamilyPages() {
        String header = Utils.readTemplateFile("header.html");
        String footer = Utils.readTemplateFile("footer.html");
        if (header == null) {
            return;
        }
        for (String name : this.repos_names) {
            Repository repository = this.repositories.getRepository(name);
            for (Object o2 : repository.families) {
                Family family = (Family)o2;
                family.generateHtmlPage(header, footer, repository);
            }
        }
    }

    private void generateList() {
        StringBuffer sb = new StringBuffer("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n<HTML>\n<HEAD>\n<Title> Tango Device Server User's Guide </Title>\n   <META NAME=\"GENERATOR\" CONTENT=\"Mozilla/4.08 [en] (X11; I; HP-UX B.10.20 9000/777) [Netscape]\">\n   <TITLE> DS User's Guide </TITLE>\n</HEAD>\n");
        sb.append("<Font Size=+1><b> &nbsp;&nbsp;").append(this.title).append("</b></Font> \n");
        if (this.repos_names.length > 1) {
            int nb = 0;
            for (String name : this.repos_names) {
                nb += this.repositories.getRepository(name).nbClasses();
            }
            sb.append(" <Br><Font Size=-1> &nbsp;&nbsp;").append(nb).append(" Classes</Font><Br>\n");
        }
        for (String name : this.repos_names) {
            sb.append("<Br><Br>\n");
            Repository repository = this.repositories.getRepository(name);
            sb.append("<b> ").append(repository.name).append(":</b><Br>\n");
            sb.append("<Font Size=-1> ").append(repository.nbClasses()).append(" Classes</Font>\n");
            sb.append("<Font Size=-1> \n");
            for (Object o2 : repository.families) {
                sb.append(((Family)o2).getListLine(repository));
            }
            sb.append("</Font> \n");
        }
        sb.append("<Br><Br>").append(this.getBottomList());
        try {
            String path = this.repositories.getRepository((String)this.repos_names[0]).home;
            PogoUtil.writeFile(path + "/" + "ClassList.html", sb.toString());
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    private String getBottomList() {
        StringBuffer sb = new StringBuffer("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n<HTML>\n<HEAD>\n<Title> Tango Device Server User's Guide </Title>\n   <META NAME=\"GENERATOR\" CONTENT=\"Mozilla/4.08 [en] (X11; I; HP-UX B.10.20 9000/777) [Netscape]\">\n   <TITLE> DS User's Guide </TITLE>\n</HEAD>\n");
        String str = "\t<form method=get action=http://www.google.com/custom class=\"google_form\" Target=\"right\">\n\t<input class=\"google_box\" type=text name=q maxlength=\"50\" value=\"\">\n\t<input type=\"submit\" value=\"Search\">\n\t<input type=hidden name=domains value=\"http://www.esrf.eu/computing/cs/tango/tango_doc/\">\n\t<input type=hidden name=sitesearch value=\"http://www.esrf.eu/computing/cs/tango/tango_doc/\" checked >\n\t<input type=hidden name=meta value=\"lr=lang_en\">\n <Br>\t<Li><a href=Alphabetical.html Target=\"right\">\t Alphabetical List</a><Br>\n";
        sb.append(str);
        for (String s : this.link_to) {
            String item = "\t<Li><a href=$LINK Target=\"new\">\t $TEXT</a>\n";
            Repository rep = this.repositories.getRepository(s);
            String link = rep.home + "/" + "index.html";
            item = PogoUtil.strReplace(item, "$LINK", link);
            item = PogoUtil.strReplace(item, "$TEXT", rep.name + " Classes");
            sb.append(item);
        }
        return sb.toString();
    }

    private void generateIndex() {
        StringBuffer sb = new StringBuffer("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n<HTML>\n<HEAD>\n<Title> Tango Device Server User's Guide </Title>\n   <META NAME=\"GENERATOR\" CONTENT=\"Mozilla/4.08 [en] (X11; I; HP-UX B.10.20 9000/777) [Netscape]\">\n   <TITLE> DS User's Guide </TITLE>\n</HEAD>\n");
        String str = "\t<FRAMESET cols=\"20%,80%\">\n\t\t<FRAME src=\"ClassList.html\"   name=\"left\">\n\t\t<FRAME src=\"$PATH/index.html\" name=\"right\">\n\t</FRAMESET>\n";
        Repository repository = this.repositories.getRepository(this.repos_names[0]);
        String path = "";
        if (repository.home.equals(".")) {
            path = repository.name + "/";
        }
        path = path + repository.default_family;
        str = PogoUtil.strReplace(str, "$PATH", path);
        sb.append(str);
        try {
            PogoUtil.writeFile(repository.home + "/" + "index.html", sb.toString());
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    private void generateAlphabetical() {
        Module module;
        Repository repository;
        Vector modules = new Vector();
        for (String rep_name : this.repos_names) {
            repository = this.repositories.getRepository(rep_name);
            for (Object o : repository.families) {
                Family family = (Family)o;
                for (int i = 0; i < family.size(); ++i) {
                    Module module2 = family.getModule(i);
                    if (module2.server == null) continue;
                    modules.add(module2);
                }
            }
        }
        modules = Utils.getInstance().sort(modules);
        String header = Utils.readTemplateFile("header.html");
        StringBuffer sb = new StringBuffer(header);
        sb.append("<Center><h1><u>Tango Device Server Classes List</u></h1></Center><Br /><Br />\n");
        sb.append("<Br /><Br /><HR WIDTH=\"100%\" />\n");
        sb.append("<Center>\n");
        sb.append("Class Index :<Br />\n");
        char previous_start = ' ';
        for (Object o : modules) {
            char new_start;
            module = (Module)o;
            if (module.server == null || (new_start = module.server.class_name.toUpperCase().charAt(0)) == previous_start) continue;
            String ch = "" + new_start;
            sb.append("<a href=\"#").append(ch).append("\"> ").append(ch).append(" </a>\n");
            previous_start = new_start;
        }
        sb.append("</Center>");
        previous_start = 'A';
        sb.append("<A Name=\"").append(previous_start).append("\" />");
        for (Object o : modules) {
            module = (Module)o;
            if (module.server == null) continue;
            char new_start = module.server.class_name.toUpperCase().charAt(0);
            if (new_start != previous_start) {
                sb.append("<A Name=\"").append(new_start).append("\" />");
                previous_start = new_start;
            }
            sb.append(module.getSummary());
        }
        String footer = Utils.readTemplateFile("footer.html");
        sb.append(footer);
        try {
            repository = this.repositories.getRepository(this.repos_names[0]);
            PogoUtil.writeFile(repository.home + "/" + "Alphabetical.html", sb.toString());
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }
}

