/*
 * Decompiled with CFR 0.152.
 */
package pogo.appli;

import app_util.PopupError;
import app_util.PopupMessage;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import pogo.appli.DeviceIdProperties;
import pogo.appli.PogoAppli;
import pogo.gene.DeviceID;
import pogo.gene.PogoException;
import pogo.gene.PogoUtil;

public class DeviceIdDialog
extends JDialog {
    private JFrame parent;
    private int retVal = 0;
    private boolean exit_on_close;
    private String classname = "";
    private static final String HelpMessage = "During TANGO meeting in Kobe (Japan)\nIt has been decided to create a\ndevice class identification for all TANGO classes.\n\nThe goal of this device class identification\nis to sort and find class by key words.\n\nDo not be afraid to be spammed,\nthe email for contact will not appear clearly in html pages";
    private JPanel bottomPanel;
    private JComboBox busComboBox;
    private JLabel busLabel;
    private JButton cancelBtn;
    private JPanel centerPanel;
    private JLabel contactLabel;
    private JTextField contactTxt;
    private JComboBox familyComboBox;
    private JLabel familyLabel;
    private JLabel manufacturerLabel;
    private JTextField manufacturerTxt;
    private JButton okBtn;
    private JComboBox platformComboBox;
    private JLabel platformLabel;
    private JLabel referenceLabel;
    private JTextField referenceTxt;
    private JRadioButton siteButton;
    private JLabel titleLabel;
    private JPanel topPanel;

    public DeviceIdDialog(JFrame parent, String classname, boolean exit_on_close) {
        super((Frame)parent, true);
        this.parent = parent;
        this.classname = classname;
        this.exit_on_close = exit_on_close;
        this.initComponents();
        this.familyComboBox.setModel(new DefaultComboBoxModel<String>(DeviceIdProperties.classFamilies));
        this.platformComboBox.setModel(new DefaultComboBoxModel<String>(DeviceIdProperties.platformNames));
        this.busComboBox.setModel(new DefaultComboBoxModel<String>(DeviceIdProperties.busNames));
        if (DeviceIdProperties.siteName != null && DeviceIdProperties.siteName.length() > 0 && DeviceIdProperties.siteClassFamilies != null && DeviceIdProperties.siteClassFamilies.length > 0) {
            this.siteButton.setText("Specific " + DeviceIdProperties.siteName);
        } else {
            this.siteButton.setVisible(false);
        }
        this.topPanel.add(new JLabel("        "));
        JButton btn = new JButton("Help");
        btn.setBorder(new SoftBevelBorder(0));
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DeviceIdDialog.this.helpBtnActionPerformed(evt);
            }
        });
        this.topPanel.add(btn);
        String mail = System.getenv("EMAIL");
        if (mail != null) {
            this.contactTxt.setText(mail);
        }
        this.manufacturerTxt.setText("none");
        if (classname != null && classname.length() > 0) {
            this.titleLabel.setText(classname + " Class Identification");
        }
        this.pack();
        this.centerWindow();
        this.setReferenceVisible(false);
    }

    public DeviceIdDialog(JFrame parent, DeviceID id, boolean exit_on_close) {
        this(parent, id.classname, exit_on_close);
        if (id != null) {
            if (this.siteButton.isVisible() && DeviceIdProperties.siteName != null && id.site.equals(DeviceIdProperties.siteName)) {
                this.siteButton.setSelected(true);
                this.familyComboBox.setModel(new DefaultComboBoxModel<String>(DeviceIdProperties.siteClassFamilies));
            }
            this.contactTxt.setText(id.contact);
            this.platformComboBox.setSelectedItem(id.platform);
            this.familyComboBox.setSelectedItem(id.family);
            this.busComboBox.setSelectedItem(id.bus);
            this.manufacturerTxt.setText(id.manufacturer);
            this.referenceTxt.setText(id.reference);
            this.setReferenceVisible(id.manufacturer.length() > 0 && !id.manufacturer.equals("none"));
        }
    }

    private void centerWindow() {
        if (this.parent.isVisible()) {
            PogoAppli.centerDialog(this, this.parent);
        } else {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension scrsize = toolkit.getScreenSize();
            Dimension appsize = this.getSize();
            Point p = new Point();
            p.x = (scrsize.width - appsize.width) / 2;
            p.y = (scrsize.height - appsize.height) / 2;
            this.setLocation(p);
        }
    }

    private void setReferenceVisible(boolean b) {
        this.referenceTxt.setVisible(b);
        this.referenceLabel.setVisible(b);
    }

    private void initComponents() {
        this.bottomPanel = new JPanel();
        this.okBtn = new JButton();
        this.cancelBtn = new JButton();
        this.topPanel = new JPanel();
        this.titleLabel = new JLabel();
        this.centerPanel = new JPanel();
        this.contactLabel = new JLabel();
        this.platformLabel = new JLabel();
        this.busLabel = new JLabel();
        this.manufacturerLabel = new JLabel();
        this.referenceLabel = new JLabel();
        this.contactTxt = new JTextField();
        this.manufacturerTxt = new JTextField();
        this.referenceTxt = new JTextField();
        this.platformComboBox = new JComboBox();
        this.busComboBox = new JComboBox();
        this.familyComboBox = new JComboBox();
        this.familyLabel = new JLabel();
        this.siteButton = new JRadioButton();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DeviceIdDialog.this.closeDialog(evt);
            }
        });
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DeviceIdDialog.this.okBtnActionPerformed(evt);
            }
        });
        this.bottomPanel.add(this.okBtn);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DeviceIdDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.bottomPanel.add(this.cancelBtn);
        this.getContentPane().add((Component)this.bottomPanel, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Device Class Identification");
        this.topPanel.add(this.titleLabel);
        this.getContentPane().add((Component)this.topPanel, "North");
        this.centerPanel.setLayout(new GridBagLayout());
        this.contactLabel.setText("Contact email *");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(20, 20, 0, 0);
        this.centerPanel.add((Component)this.contactLabel, gridBagConstraints);
        this.platformLabel.setText("Platform *");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 20, 0, 0);
        this.centerPanel.add((Component)this.platformLabel, gridBagConstraints);
        this.busLabel.setText("Bus *");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 20, 0, 0);
        this.centerPanel.add((Component)this.busLabel, gridBagConstraints);
        this.manufacturerLabel.setText("Manufacturer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 20, 0, 0);
        this.centerPanel.add((Component)this.manufacturerLabel, gridBagConstraints);
        this.referenceLabel.setText("Product Reference");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 20, 20, 0);
        this.centerPanel.add((Component)this.referenceLabel, gridBagConstraints);
        this.contactTxt.setColumns(20);
        this.contactTxt.setFont(new Font("Dialog", 1, 12));
        this.contactTxt.setToolTipText("Programmer or contact email address");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(20, 10, 0, 20);
        this.centerPanel.add((Component)this.contactTxt, gridBagConstraints);
        this.manufacturerTxt.setColumns(20);
        this.manufacturerTxt.setFont(new Font("Dialog", 1, 12));
        this.manufacturerTxt.setToolTipText("manufacturer name");
        this.manufacturerTxt.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                DeviceIdDialog.this.manufacturerTxtKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 20);
        this.centerPanel.add((Component)this.manufacturerTxt, gridBagConstraints);
        this.referenceTxt.setColumns(20);
        this.referenceTxt.setFont(new Font("Dialog", 1, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 20, 20);
        this.centerPanel.add((Component)this.referenceTxt, gridBagConstraints);
        this.platformComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"All Platforms", "Unix Like", "Windows"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 20);
        this.centerPanel.add((Component)this.platformComboBox, gridBagConstraints);
        this.busComboBox.setEditable(true);
        this.busComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"", "Not Applicable", "Compact PCI", "Data Socket", "Ethernet", "FireWire", "GPIB", "Modbus", "PCI", "PCI Express", "Serial Line", "Socket", "TCP/UDP", "USB", "VME"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 20);
        this.centerPanel.add((Component)this.busComboBox, gridBagConstraints);
        this.familyComboBox.setEditable(true);
        this.familyComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Miscellaneous", "AbstractClasses", "Acquisition", "Application", "BeamDiag", "Calculation", "Communication", "Controllers", "InputOutput", "Instrumentation", "Interlock", "Motion", "PowerSupply", "Process", "RadioProtection", "Sequencer", "Simulators", "Training", "Vacuum"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 20);
        this.centerPanel.add((Component)this.familyComboBox, gridBagConstraints);
        this.familyLabel.setText("Class family *");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 20, 0, 0);
        this.centerPanel.add((Component)this.familyLabel, gridBagConstraints);
        this.siteButton.setText("Site");
        this.siteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DeviceIdDialog.this.siteButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.centerPanel.add((Component)this.siteButton, gridBagConstraints);
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.pack();
    }

    private void manufacturerTxtKeyReleased(KeyEvent evt) {
        String s = this.manufacturerTxt.getText();
        this.setReferenceVisible(s.length() > 0 && !s.equals("none"));
    }

    void writeFile(String filename) {
        try {
            PogoUtil.writeFile(filename, this.getInputs().toString());
        }
        catch (Exception e) {
            PopupError.show((Component)this, e);
        }
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        try {
            this.checkInputs();
            if (this.exit_on_close) {
                this.writeFile(DeviceID.getFilename(""));
                PopupMessage.show((Component)this, DeviceID.getFilename("") + "   generated.");
            }
        }
        catch (Exception e) {
            PopupError.show((Component)this, e);
            return;
        }
        this.retVal = 0;
        this.doClose();
    }

    private void helpBtnActionPerformed(ActionEvent evt) {
        PopupMessage.show((Component)this, HelpMessage);
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void siteButtonActionPerformed(ActionEvent evt) {
        String family = (String)this.familyComboBox.getSelectedItem();
        if (this.siteButton.getSelectedObjects() == null) {
            this.familyComboBox.setModel(new DefaultComboBoxModel<String>(DeviceIdProperties.classFamilies));
        } else {
            this.familyComboBox.setModel(new DefaultComboBoxModel<String>(DeviceIdProperties.siteClassFamilies));
        }
        this.familyComboBox.setSelectedItem(family);
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
        if (this.exit_on_close) {
            System.exit(0);
        }
    }

    public int showDialog() {
        this.setVisible(true);
        return this.retVal;
    }

    private void checkInputs() throws PogoException {
        String contact = this.contactTxt.getText().trim();
        int pos = contact.indexOf(64);
        if (pos <= 0) {
            throw new PogoException("email is not available");
        }
        int pos2 = contact.indexOf(46, pos);
        if (pos2 <= 0 || contact.length() - pos2 < 3) {
            throw new PogoException("email is not available");
        }
        String family = (String)this.familyComboBox.getSelectedItem();
        if (family == null || family.trim().length() == 0) {
            throw new PogoException("Class family is not available");
        }
        String bus = (String)this.busComboBox.getSelectedItem();
        if (bus == null || bus.trim().length() == 0) {
            throw new PogoException("Bus is not available");
        }
    }

    public DeviceID getInputs() {
        String platform = (String)this.platformComboBox.getSelectedItem();
        String family = (String)this.familyComboBox.getSelectedItem();
        String bus = (String)this.busComboBox.getSelectedItem();
        String site = "";
        if (this.siteButton.isVisible() && this.siteButton.getSelectedObjects() != null) {
            site = DeviceIdProperties.siteName;
        }
        return new DeviceID(this.classname, this.contactTxt.getText().trim(), family, site, platform, bus, this.manufacturerTxt.getText().trim(), this.referenceTxt.getText().trim());
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Class name ?");
            System.exit(-1);
        }
        try {
            if (new File(DeviceID.getFilename("")).exists()) {
                String code = PogoUtil.readFile(DeviceID.getFilename(""));
                DeviceID id = new DeviceID(code);
                id.classname = args[0];
                new DeviceIdDialog(new JFrame(), id, true).setVisible(true);
            } else {
                new DeviceIdDialog(new JFrame(), args[0], true).setVisible(true);
            }
        }
        catch (Exception e) {
            PopupError.show((Component)new JFrame(), e);
            e.printStackTrace();
        }
    }
}

