/*
 * Decompiled with CFR 0.152.
 */
package explorer;

import explorer.AttributeTable;
import explorer.CommandTable;
import explorer.DeviceAliasDialog;
import explorer.EntityAdapter;
import explorer.EntityAliasDialog;
import explorer.EntityTableModel;
import explorer.MyCellRenderer;
import explorer.Preferences;
import explorer.ViewDialog;
import explorer.ui.Dialog;
import explorer.ui.RunUI;
import explorer.ui.UIDialog;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.IDevice;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.widget.device.SingletonStatusViewer;
import fr.esrf.tangoatk.widget.dnd.DropTargetListener;
import fr.esrf.tangoatk.widget.dnd.IDropHandler;
import fr.esrf.tangoatk.widget.dnd.NodeFactory;
import fr.esrf.tangoatk.widget.properties.PropertyListViewer2;
import fr.esrf.tangoatk.widget.util.HelpWindow;
import fr.esrf.tangoatk.widget.util.IApplicable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public abstract class EntityTable
extends JPanel {
    protected JTable table;
    protected boolean admin = true;
    protected MyCellRenderer entityRenderer;
    protected MyCellRenderer deviceRenderer;
    protected String flavor = NodeFactory.MIME_ENTITY;
    protected Dialog propertyDialog;
    protected PropertyDialog propertyPanel;
    protected JPopupMenu popup;
    protected Preferences preferences;
    protected EntityTableModel model;
    protected Dialog viewDialog;
    protected SingletonStatusViewer statusViewer;
    protected String helpUrl;

    protected EntityTable() {
    }

    public void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    protected void initComponents(EntityTableModel model, boolean isAdmin) {
        this.entityRenderer = new MyCellRenderer();
        this.deviceRenderer = new MyCellRenderer();
        this.table = new JTable(model){

            public void createDefaultColumnsFromModel() {
                EntityTableModel m;
                try {
                    m = (EntityTableModel)this.getModel();
                    if (m == null) {
                        return;
                    }
                }
                catch (ClassCastException e) {
                    return;
                }
                TableColumnModel cm = this.getColumnModel();
                while (cm.getColumnCount() > 0) {
                    cm.removeColumn(cm.getColumn(0));
                }
                TableColumn[] l = new TableColumn[m.getColumnCount()];
                int i = 0;
                while (i < m.getColumnCount()) {
                    String name = m.getColumnName(i);
                    int index = m.getIndex(name, i);
                    if (i == 0 && l.length == 1) {
                        index = i;
                        m.putIndex(name, i);
                    }
                    if (index != -1 && index < l.length) {
                        TableColumn newColumn = EntityTable.this.createTableColumn(name, i);
                        newColumn.setPreferredWidth(EntityTable.this.getPrefWidth(name, 87));
                        l[index] = newColumn;
                    }
                    ++i;
                }
                int i2 = 0;
                while (i2 < l.length) {
                    if (l[i2] != null) {
                        this.addColumn(l[i2]);
                    }
                    ++i2;
                }
            }
        };
        this.table.setRowHeight(18);
        this.table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                EntityTable.this.showPopup(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                EntityTable.this.showPopup(evt);
            }

            public void mouseClicked(MouseEvent evt) {
                EntityTable.this.showPopup(evt);
                EntityTable.this.entityTableMouseClicked(evt);
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                this.manageKey(e);
            }

            public void keyReleased(KeyEvent e) {
                this.manageKey(e);
            }

            public void keyTyped(KeyEvent e) {
                this.manageKey(e);
            }

            private void manageKey(KeyEvent e) {
                if ((e.getKeyCode() == 127 || e.getKeyCode() == 8) && EntityTable.this.isAdmin()) {
                    EntityTable.this.removeEntity(true);
                }
            }
        });
        this.initDnd();
        this.initHelp();
        this.popup = new JPopupMenu();
        UIDialog.getInstance().addComponent(this.popup);
        this.initMenus();
        JMenuItem view = new JMenuItem("View...");
        JMenuItem remove = new JMenuItem("Remove");
        JMenuItem runJive = new JMenuItem("Run jive");
        JMenuItem runAtk = new JMenuItem("Run atkpanel");
        JMenuItem status = new JMenuItem("Status...");
        JMenuItem properties = new JMenuItem("Properties...");
        JMenuItem helpItem = new JMenuItem("Help...");
        remove.setEnabled(isAdmin);
        runJive.setEnabled(RunUI.isJiveAvailable());
        runAtk.setEnabled(RunUI.isATKPanelAvailable());
        this.popup.add(new JSeparator());
        this.popup.add(remove);
        this.popup.add(new JSeparator());
        this.popup.add(status);
        this.popup.add(properties);
        this.popup.add(new JSeparator());
        this.popup.add(runAtk);
        this.popup.add(new JSeparator());
        this.popup.add(helpItem);
        helpItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EntityTable.this.help();
            }
        });
        view.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EntityTable.this.showViewDialog();
            }
        });
        remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EntityTable.this.removeEntity(false);
            }
        });
        runJive.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EntityTable.this.runJive();
            }
        });
        runAtk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EntityTable.this.runAtk();
            }
        });
        status.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EntityTable.this.showStatus();
            }
        });
        properties.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EntityTable.this.showPropertiesDialog();
            }
        });
        GridBagConstraints constraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridy = 0;
        constraints.gridx = 0;
        this.add((Component)new JScrollPane(this.table), constraints);
    }

    protected void initDnd() {
        DropTargetListener dtListener = new DropTargetListener();
        dtListener.setDropHandler(new IDropHandler(){

            public void handleDrop(String object, DataFlavor flavor) {
                EntityTable.this.dtHandleDrop(object, flavor);
            }

            public boolean isDragOn(DataFlavor[] flavors) {
                return EntityTable.this.isDragOn(flavors);
            }
        });
        new DropTarget(this, 1, (java.awt.dnd.DropTargetListener)dtListener);
        new DropTarget(this.table, 1, (java.awt.dnd.DropTargetListener)dtListener);
    }

    protected void createViewDialog(EntityTableModel model) {
        this.viewDialog = new Dialog();
        this.viewDialog.setComponent(new ViewDialog(model));
    }

    public void setModel(EntityTableModel model) {
        this.model = model;
        model.setColumnModel(this.table.getColumnModel());
        this.createViewDialog(model);
        this.initPreferences();
    }

    public void storePreferences() {
        this.model.storePreferences();
        Enumeration<TableColumn> e = this.table.getColumnModel().getColumns();
        while (e.hasMoreElements()) {
            TableColumn c = e.nextElement();
            this.putWidth(c.getHeaderValue().toString(), c.getPreferredWidth());
        }
    }

    protected void removeEntity(boolean confirm) {
        boolean suppress = true;
        if (confirm) {
            String message = "Do you wish to remove these ";
            message = this instanceof AttributeTable ? message + "attributes" : (this instanceof CommandTable ? message + "commands" : message + "entities");
            int ok = JOptionPane.showConfirmDialog(this, message = message + " from table ?", "Deletion Confirmation", 0);
            if (ok != 0) {
                suppress = false;
            }
        }
        while (suppress) {
            int[] rows = this.getSelectedRows();
            if (rows.length == 0) {
                return;
            }
            this.model.removeEntityAt(rows[0]);
        }
    }

    protected void showViewDialog() {
        this.viewDialog.pack();
        this.viewDialog.show();
    }

    protected void showEntityAliasDialog() {
        if (this.getSelectedRow() == -1) {
            return;
        }
        IEntity entity = this.model.getEntityAt(this.getSelectedRow());
        EntityAliasDialog dialog = new EntityAliasDialog(this, entity);
        dialog.show();
    }

    protected void showDeviceAliasDialog() {
        if (this.getSelectedRow() == -1) {
            return;
        }
        Device device = this.model.getEntityAt(this.getSelectedRow()).getDevice();
        DeviceAliasDialog dialog = new DeviceAliasDialog(this, (IDevice)device);
        dialog.show();
    }

    protected void showPropertiesDialog() {
        EntityAdapter adapter = this.model.getAdapterAt(this.getSelectedRow());
        if (this.propertyDialog == null) {
            this.propertyDialog = new Dialog();
            this.propertyPanel = new PropertyDialog();
            this.propertyDialog.setComponent(this.propertyPanel);
        }
        this.propertyPanel.setModel(adapter);
        this.propertyDialog.pack();
        this.propertyDialog.show();
    }

    public void aliasChanged() {
        this.getRootPane().repaint();
    }

    protected void runAtk() {
        int row = this.getSelectedRow();
        IEntity entity = this.model.getEntityAt(row);
        RunUI.runAtkPanel((IDevice)entity.getDevice());
    }

    protected void runJive() {
        RunUI.runJive();
    }

    protected void showStatus() {
        IEntity entity = this.model.getEntityAt(this.getSelectedRow());
        if (this.statusViewer == null) {
            this.statusViewer = SingletonStatusViewer.getInstance();
        }
        this.statusViewer.setModel(entity.getDevice());
        this.statusViewer.show();
    }

    public int getSelectedRow() {
        return this.table.getSelectedRow();
    }

    public int[] getSelectedRows() {
        return this.table.getSelectedRows();
    }

    public int getRowAtPoint(Point point) {
        return this.table.rowAtPoint(point);
    }

    public int getColumnAtPoint(Point point) {
        return this.table.columnAtPoint(point);
    }

    public void setRowSelectionInterval(int start, int end) {
        this.table.setRowSelectionInterval(start, end);
    }

    public Object getValueAt(int row, int column) {
        return this.table.getValueAt(row, column);
    }

    public int getSelectedColumn() {
        return this.table.getSelectedColumn();
    }

    public void help() {
        HelpWindow.getInstance().showUrl(this.getClass().getResource(this.helpUrl));
    }

    protected boolean isDragOn(DataFlavor[] flavors) {
        int i = 0;
        while (i < flavors.length) {
            if (flavors[i].getMimeType().startsWith(this.flavor)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public TableModel getModel() {
        return this.table.getModel();
    }

    protected abstract void initPreferences();

    protected abstract void initHelp();

    protected abstract void initMenus();

    protected abstract void dtHandleDrop(String var1, DataFlavor var2);

    protected abstract void showPopup(MouseEvent var1);

    protected abstract void entityTableMouseClicked(MouseEvent var1);

    protected int getPrefWidth(String name, int def) {
        String pref = this.model.getPreferencePrefix().append(name).append("Width").toString();
        return this.preferences.getInt(pref, def);
    }

    protected void putWidth(String name, int val) {
        String pref = this.model.getPreferencePrefix().append(name).append("Width").toString();
        this.preferences.putInt(pref, val);
    }

    protected TableColumn createTableColumn(String name, int i) {
        return new TableColumn(i);
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    class PropertyDialog
    extends JPanel
    implements IApplicable {
        PropertyListViewer2 propertyPanel;
        EntityAdapter adapter;

        PropertyDialog() {
            this.initComponents();
        }

        public void ok() {
            this.apply();
            this.cancel();
        }

        public void apply() {
            this.propertyPanel.store();
            this.adapter.reloadProperties();
        }

        public void cancel() {
            this.getRootPane().getParent().setVisible(false);
        }

        protected void initComponents() {
            this.propertyPanel = new PropertyListViewer2();
            this.propertyPanel.setEditable(true);
            this.add((Component)this.propertyPanel);
        }

        void setModel(EntityAdapter adapter) {
            this.adapter = adapter;
            this.propertyPanel.setModel(adapter.getEntity().getPropertyMap());
        }
    }
}

