/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.access;

import admin.astor.AstorUtil;
import admin.astor.access.AccessProxy;
import admin.astor.access.AllowedCmdTree;
import admin.astor.access.EditDialog;
import admin.astor.access.UsersTree;
import admin.astor.access.Utils;
import app_util.PopupMessage;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;

public class TangoAccess
extends JFrame {
    private static String revNumber = "Release 1.0  -  Fri Sep 12 13:53:31 CEST 2008";
    String access_devname;
    private UsersTree users_tree = null;
    private AllowedCmdTree cmd_tree = null;
    private AccessProxy access_dev;
    private EditDialog check_dlg = null;
    private JFrame parent;
    private static final Dimension pane_size = new Dimension(350, 500);
    private JMenu actionMenu;
    private JMenuItem checkAccessBtn;
    private JPanel cmdClassPanel;
    private JMenuItem exitBtn;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JLabel jLabel1;
    private JMenuItem principleItem;
    private JRadioButtonMenuItem registerItem;
    private JTabbedPane tabbedPane;
    private JPanel topPanel;
    private JPanel usersPanel;

    public TangoAccess(JFrame jFrame) throws DevFailed {
        this.parent = jFrame;
        try {
            AstorUtil.startSplash("TangoAccess ");
            AstorUtil.increaseSplashProgress(5, "Reading database");
            String string = System.getenv("AccessControl");
            if (string == null) {
                this.getTangoService();
            } else {
                this.access_devname = string;
            }
            this.initComponents();
            this.initOwnComponents();
            AstorUtil.increaseSplashProgress(5, "Finalize GUI");
            ImageIcon imageIcon = Utils.getInstance().getIcon("tango_icon.jpg");
            this.setIconImage(imageIcon.getImage());
            this.setTitle("Tango Access Control Manager");
            boolean bl = false;
            String string2 = System.getProperty("SUPER_TANGO");
            if (string2 != null && string2.toLowerCase().equals("true")) {
                bl = true;
            }
            this.topPanel.setVisible(bl);
            this.pack();
            if (jFrame.getWidth() > 0) {
                Point point = jFrame.getLocationOnScreen();
                point.x += 100;
                point.y += 100;
                this.setLocation(point);
            } else {
                ATKGraphicsUtils.centerFrameOnScreen((Frame)this);
            }
            AstorUtil.stopSplash();
        }
        catch (DevFailed devFailed) {
            AstorUtil.stopSplash();
            throw devFailed;
        }
    }

    private void getTangoService() throws DevFailed {
        String[] stringArray = ApiUtil.get_db_obj().getServices("AccessControl", "tango");
        if (stringArray.length == 0) {
            Except.throw_communication_failed((String)"Service_DoesNotExist", (String)"There is no AccessControl service defined !", (String)"TangoAccess.TangoAccess()");
        }
        this.access_devname = stringArray[0];
    }

    private void initOwnComponents() throws DevFailed {
        this.fileMenu.setMnemonic('F');
        this.checkAccessBtn.setMnemonic('T');
        this.checkAccessBtn.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.exitBtn.setMnemonic('E');
        this.exitBtn.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.actionMenu.setMnemonic('A');
        this.registerItem.setMnemonic('R');
        this.helpMenu.setMnemonic('H');
        this.principleItem.setMnemonic('P');
        this.principleItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.access_dev = new AccessProxy(this.access_devname);
        if (this.access_dev.getAccessControl() == 0) {
            this.checkAccessBtn.setEnabled(false);
            this.actionMenu.setEnabled(false);
        }
        this.tabbedPane.setTitleAt(0, "Users");
        this.tabbedPane.setTitleAt(1, "Allowed Cmd");
        this.users_tree = new UsersTree(this, this.access_dev);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.users_tree);
        this.usersPanel.add((Component)jScrollPane, "Center");
        this.cmd_tree = new AllowedCmdTree(this, this.access_dev);
        jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.cmd_tree);
        this.cmdClassPanel.add((Component)jScrollPane, "Center");
        JLabel jLabel = new JLabel("Devices: ");
        JPanel jPanel = new JPanel();
        jPanel.add(jLabel);
        jLabel = new JLabel("Read/Write");
        jLabel.setIcon(Utils.getInstance().getIcon("greenbal.gif"));
        jPanel.add(jLabel);
        jLabel = new JLabel("Read Only");
        jLabel.setIcon(Utils.getInstance().getIcon("redball.gif"));
        jPanel.add(jLabel);
        this.usersPanel.add((Component)jPanel, "South");
        this.tabbedPane.setPreferredSize(pane_size);
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.usersPanel = new JPanel();
        this.cmdClassPanel = new JPanel();
        this.topPanel = new JPanel();
        this.jLabel1 = new JLabel();
        JMenuBar jMenuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.checkAccessBtn = new JMenuItem();
        this.exitBtn = new JMenuItem();
        this.actionMenu = new JMenu();
        this.registerItem = new JRadioButtonMenuItem();
        this.helpMenu = new JMenu();
        this.principleItem = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TangoAccess.this.exitForm(windowEvent);
            }
        });
        this.usersPanel.setLayout(new BorderLayout());
        this.tabbedPane.addTab("tab1", this.usersPanel);
        this.cmdClassPanel.setLayout(new BorderLayout());
        this.tabbedPane.addTab("tab2", this.cmdClassPanel);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.jLabel1.setText("You are Super User !");
        this.topPanel.add(this.jLabel1);
        this.getContentPane().add((Component)this.topPanel, "First");
        this.fileMenu.setText("File");
        this.checkAccessBtn.setText("Test Tango Acces");
        this.checkAccessBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TangoAccess.this.checkAccessBtnActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.checkAccessBtn);
        this.exitBtn.setText("Exit");
        this.exitBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TangoAccess.this.exitBtnActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.exitBtn);
        jMenuBar.add(this.fileMenu);
        this.actionMenu.setText("Action");
        this.actionMenu.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                TangoAccess.this.actionMenuItemStateChanged(itemEvent);
            }
        });
        this.registerItem.setText("Register Service");
        this.registerItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TangoAccess.this.registerItemActionPerformed(actionEvent);
            }
        });
        this.actionMenu.add(this.registerItem);
        jMenuBar.add(this.actionMenu);
        this.helpMenu.setText("help");
        this.principleItem.setText("On Principle");
        this.principleItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TangoAccess.this.principleItemActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.principleItem);
        jMenuBar.add(this.helpMenu);
        this.setJMenuBar(jMenuBar);
        this.pack();
    }

    private void actionMenuItemStateChanged(ItemEvent itemEvent) {
        if (!this.actionMenu.isSelected()) {
            return;
        }
        try {
            String[] stringArray = ApiUtil.get_db_obj().getServices("AccessControl", "tango");
            this.registerItem.setSelected(stringArray.length != 0);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, (String)"Cannot start TangoAccess class", (DevFailed)devFailed);
        }
    }

    private void registerItemActionPerformed(ActionEvent actionEvent) {
        try {
            boolean bl = this.registerItem.getSelectedObjects() != null;
            this.access_dev.registerService(bl);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, (String)"Cannot start TangoAccess class", (DevFailed)devFailed);
        }
    }

    private void checkAccessBtnActionPerformed(ActionEvent actionEvent) {
        if (this.check_dlg == null) {
            this.check_dlg = new EditDialog(this, this.access_dev);
            this.check_dlg.showDialog();
        } else {
            this.check_dlg.setVisible(true);
        }
    }

    private void exitBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void exitForm(WindowEvent windowEvent) {
        this.doClose();
    }

    private void principleItemActionPerformed(ActionEvent actionEvent) {
        PopupMessage.show((Component)this, "This access management is necessary only if the\n    \"AccessControl/tango\"\n    Tango service has been installed.\n\nBy default all devices are forbiden for all users.\nAnd the rights will be opened for [user, address, device].\n\nThis tool is able to define WRITE access \n    on devices for a TANGO control system\n\nYou can define for a specified user:\n    - Allowed addresses to write devices\n    - Set devices acces to  READ_WRITE or READ_ONLY");
    }

    private void doClose() {
        if (this.parent.getWidth() > 0) {
            this.setVisible(false);
        } else {
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        try {
            new TangoAccess(new JFrame()).setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)new JFrame(), (String)"Cannot start TangoAccess class", (DevFailed)devFailed);
            System.exit(0);
        }
        catch (InternalError internalError) {
            System.out.println(internalError);
        }
        catch (HeadlessException headlessException) {
            System.out.println(headlessException);
        }
    }
}

