/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorDefs;
import admin.astor.AstorUtil;
import admin.astor.LevelTree;
import admin.astor.ListDialog;
import admin.astor.ServerCmdThread;
import admin.astor.ServerPopupMenu;
import admin.astor.TangoHost;
import admin.astor.TangoServer;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.ITangoChangeListener;
import fr.esrf.TangoApi.events.TangoChange;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoEventsAdapter;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.Timer;

public class HostInfoDialog
extends JDialog
implements AstorDefs,
TangoConst {
    public TangoHost host;
    public String name;
    private Astor astor;
    private Color bg = null;
    private String attribute = "Servers";
    private static final int NO_CHANGE = 0;
    private static final int LIST_CHANGED = 1;
    private static final int STATE_CHANGED = 2;
    private static Dimension preferred_size;
    private JScrollPane scrollPane = null;
    private LevelTree[] trees = null;
    private JPanel levelsPanel = null;
    private JPanel[] treePanels;
    private JPanel notifdPanel;
    private ServerPopupMenu notifd_menu;
    private JButton StartAllBtn;
    private JPanel btnPanel;
    private JButton cancelBtn;
    private JPanel centerPanel;
    private JRadioButton displayAllBtn;
    private JPanel jPanel1;
    private JButton startNewBtn;
    private JButton stopAllBtn;
    private JLabel titleLabel;
    private JPanel titlePanel;
    private static String[] filters;
    private ServerEventListener server_listener = null;

    public HostInfoDialog(Astor astor, TangoHost tangoHost) {
        super((Frame)astor, false);
        this.astor = astor;
        this.host = tangoHost;
        this.name = tangoHost.getName();
        this.initComponents();
        this.setTitle((Object)((Object)tangoHost) + "  Control");
        this.displayAllBtn.setSelected(true);
        preferred_size = AstorUtil.getHostDialogPreferredSize();
        this.scrollPane = new JScrollPane();
        new UpdateThread().start();
        this.bg = this.titlePanel.getBackground();
        this.titleLabel.setText("Controlled Servers on " + this.name);
        this.notifd_menu = new ServerPopupMenu(this.astor, this, tangoHost, 2);
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    public Astor getAstorObject() {
        return this.astor;
    }

    public void displayHostInfoDialog(String string) {
        this.astor.tree.displayHostInfoDialog(string);
    }

    void setDialogPreferredSize(Dimension dimension) {
        preferred_size = dimension;
        this.packTheDialog();
    }

    void updatePanel() {
        int n;
        if (this.trees == null) {
            int n2 = AstorUtil.getStarterNbStartupLevels();
            ++n2;
            this.levelsPanel = new JPanel();
            this.levelsPanel.setLayout(new GridBagLayout());
            this.centerPanel.add((Component)this.levelsPanel, "Center");
            if (this.host.check_notifd) {
                this.notifdPanel = new JPanel();
                this.host.notifd_label = new JLabel("Event Notify Daemon");
                this.host.notifd_label.setFont(new Font("Dialog", 1, 12));
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.gridwidth = n2;
                gridBagConstraints.fill = 2;
                this.notifdPanel.add((Component)this.host.notifd_label, gridBagConstraints);
                this.levelsPanel.add((Component)this.notifdPanel, gridBagConstraints);
                this.host.notifd_label.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        HostInfoDialog.this.serverBtnMouseClicked(mouseEvent);
                    }
                });
            }
            this.treePanels = new JPanel[n2];
            this.trees = new LevelTree[n2];
            for (n = 0; n < n2; ++n) {
                this.trees[n] = new LevelTree(this.astor, this, this.host, n);
                this.treePanels[n] = new JPanel();
                this.treePanels[n].add(this.trees[n]);
            }
        } else {
            LevelTree[] levelTreeArray = this.trees;
            n = levelTreeArray.length;
            for (int i = 0; i < n; ++i) {
                LevelTree levelTree = levelTreeArray[i];
                levelTree.checkUpdate();
            }
        }
        int n3 = 0;
        for (n = 1; n < this.trees.length; ++n) {
            n3 += this.trees[n].getNbServers();
        }
        this.titleLabel.setText("" + n3 + " Controlled Servers on " + this.name);
        this.checkActiveLevels();
        this.updateHostState();
        this.packTheDialog();
    }

    void packTheDialog() {
        if (!this.isVisible()) {
            return;
        }
        this.pack();
        int n = this.levelsPanel.getWidth();
        int n2 = this.levelsPanel.getHeight();
        if (n > HostInfoDialog.preferred_size.width || n2 > HostInfoDialog.preferred_size.height) {
            int n3 = 20;
            this.centerPanel.remove(this.levelsPanel);
            Dimension dimension = new Dimension(preferred_size);
            if (n < HostInfoDialog.preferred_size.width - n3) {
                dimension.width = n + n3;
            }
            if (n2 < HostInfoDialog.preferred_size.height - n3) {
                dimension.height = n2 + n3;
            }
            this.scrollPane.setPreferredSize(dimension);
            this.scrollPane.add(this.levelsPanel);
            this.scrollPane.setViewportView(this.levelsPanel);
            this.centerPanel.add((Component)this.scrollPane, "Center");
        } else {
            this.centerPanel.remove(this.scrollPane);
            this.scrollPane.remove(this.levelsPanel);
            this.centerPanel.add((Component)this.levelsPanel, "Center");
        }
        this.pack();
    }

    private void checkActiveLevels() {
        int n;
        this.levelsPanel.removeAll();
        Vector<JPanel> vector = new Vector<JPanel>();
        for (n = 1; n < this.trees.length; ++n) {
            if (this.trees[n].getNbServers() <= 0) continue;
            vector.add(this.treePanels[n]);
        }
        if (this.trees[0].getNbServers() > 0) {
            vector.add(this.treePanels[0]);
        }
        n = 0;
        int n2 = 1;
        int n3 = vector.size() / 2 - 1;
        if (n3 < 2) {
            n3 = 2;
        }
        for (int i = 0; i < vector.size(); ++i) {
            JPanel jPanel = (JPanel)vector.get(i);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = n++;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.insets = new Insets(5, 10, 0, 0);
            gridBagConstraints.fill = 2;
            gridBagConstraints.fill = 3;
            gridBagConstraints.anchor = 17;
            this.levelsPanel.add((Component)jPanel, gridBagConstraints);
            if (i != n3) continue;
            n = 0;
            n2 += 2;
        }
        if (this.host.check_notifd) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = n3 + 1;
            gridBagConstraints.fill = 2;
            this.levelsPanel.add((Component)this.notifdPanel, gridBagConstraints);
        }
    }

    Color getBackgroundColor() {
        return this.startNewBtn.getBackground();
    }

    void updateHostState() {
        if (this.host.state == 4) {
            String string = ApiUtil.stateName((DevState)DevState.MOVING);
            this.titlePanel.setBackground(ATKConstant.getColor4State((String)string));
        } else if (this.host.state == 2) {
            String string = ApiUtil.stateName((DevState)DevState.ALARM);
            this.titlePanel.setBackground(ATKConstant.getColor4State((String)string));
        } else {
            this.titlePanel.setBackground(this.bg);
        }
        if (this.host.check_notifd) {
            this.host.notifd_label.setIcon(AstorUtil.state_icons[this.host.notifyd_state]);
        }
    }

    private void initComponents() {
        this.btnPanel = new JPanel();
        this.cancelBtn = new JButton();
        this.centerPanel = new JPanel();
        this.titlePanel = new JPanel();
        this.titleLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.startNewBtn = new JButton();
        this.StartAllBtn = new JButton();
        this.stopAllBtn = new JButton();
        this.displayAllBtn = new JRadioButton();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                HostInfoDialog.this.closeDialog(windowEvent);
            }
        });
        this.cancelBtn.setText("Dismiss");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HostInfoDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        this.btnPanel.add(this.cancelBtn);
        this.getContentPane().add((Component)this.btnPanel, "South");
        this.centerPanel.setLayout(new BorderLayout());
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.titlePanel.add(this.titleLabel);
        this.centerPanel.add((Component)this.titlePanel, "North");
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.startNewBtn.setText("Start New");
        this.startNewBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HostInfoDialog.this.startNewBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.startNewBtn);
        this.StartAllBtn.setText("Start All");
        this.StartAllBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HostInfoDialog.this.StartAllBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.StartAllBtn);
        this.stopAllBtn.setText("Stop All");
        this.stopAllBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HostInfoDialog.this.stopAllBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.stopAllBtn);
        this.displayAllBtn.setText("Display All");
        this.displayAllBtn.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.displayAllBtn.setMargin(new Insets(0, 0, 0, 0));
        this.displayAllBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HostInfoDialog.this.displayAllBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.displayAllBtn);
        this.getContentPane().add((Component)this.jPanel1, "North");
        this.pack();
    }

    private void serverBtnMouseClicked(MouseEvent mouseEvent) {
        this.notifd_menu.showMenu(mouseEvent, this.host.state);
    }

    private void displayAllBtnActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.displayAllBtn.getSelectedObjects() != null;
        for (LevelTree levelTree : this.trees) {
            if (bl) {
                if (levelTree.getLevelRow() == 0) continue;
                levelTree.expandTree();
                continue;
            }
            levelTree.collapseTree();
        }
    }

    private void stopAllBtnActionPerformed(ActionEvent actionEvent) {
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = this.trees.length - 1; i >= 0; --i) {
            int n = this.trees[i].getLevelRow();
            if (n == 0 || this.trees[i].getNbServers() <= 0 || !this.trees[i].hasRunningServer()) continue;
            vector.add(n);
        }
        new ServerCmdThread((Component)this, this.host, 1, vector).start();
    }

    private void StartAllBtnActionPerformed(ActionEvent actionEvent) {
        Vector<Integer> vector = new Vector<Integer>();
        for (LevelTree levelTree : this.trees) {
            int n = levelTree.getLevelRow();
            if (n == 0 || levelTree.getNbServers() <= 0 || levelTree.getState() == DevState.ON) continue;
            vector.add(n);
        }
        new ServerCmdThread((Component)this, this.host, 0, vector).start();
    }

    private void startNewBtnActionPerformed(ActionEvent actionEvent) {
        ListDialog listDialog = new ListDialog(this);
        Point point = this.getLocationOnScreen();
        point.translate(50, 50);
        listDialog.setLocation(point);
        listDialog.showDialog();
        String string = listDialog.getSelectedItem();
        if (string != null) {
            try {
                this.host.registerServer(string);
                this.host.startOneServer(string);
                TangoServer tangoServer = new TangoServer(string, DevState.OFF);
                tangoServer.startupLevel(this, this.host.getName(), point);
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this.astor, null, (DevFailed)devFailed);
                ErrorPane.showErrorMessage((Component)this.astor, null, (DevFailed)devFailed);
            }
        }
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    void doClose() {
        if (this.astor.getWidth() == 0) {
            System.exit(0);
        }
        this.setVisible(false);
        this.dispose();
    }

    void fireNewTreeSelection(LevelTree levelTree) {
        for (LevelTree levelTree2 : this.trees) {
            if (levelTree2 == levelTree) continue;
            levelTree2.clearSelection();
        }
    }

    void stopLevel(int n) {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(n);
        new ServerCmdThread((Component)this, this.host, 1, vector).start();
    }

    void startLevel(int n) {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(n);
        new ServerCmdThread((Component)this, this.host, 0, vector).start();
    }

    private void manageServersAttribute(DeviceAttribute deviceAttribute) {
        Vector<Server> vector = new Vector<Server>();
        try {
            if (!deviceAttribute.hasFailed()) {
                Object[] objectArray = deviceAttribute.extractStringArray();
                String[] stringArray = objectArray;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String string = stringArray[i];
                    vector.add(new Server(string));
                }
            }
        }
        catch (DevFailed devFailed) {
            Except.print_exception((Exception)((Object)devFailed));
        }
        switch (this.updateHost(vector)) {
            case 1: {
                this.updatePanel();
                break;
            }
            case 0: {
                return;
            }
        }
        for (LevelTree levelTree : this.trees) {
            levelTree.repaint();
        }
    }

    public int updateHost(Vector vector) {
        boolean bl = false;
        boolean bl2 = false;
        for (Object object : vector) {
            Server server = (Server)object;
            TangoServer tangoServer = this.host.getServer(server.name);
            if (tangoServer == null) {
                try {
                    tangoServer = new TangoServer(server.name, server.state);
                }
                catch (DevFailed devFailed) {
                    Except.print_exception((Exception)((Object)devFailed));
                }
                this.host.addServer(tangoServer);
                bl2 = true;
            }
            if (tangoServer == null) continue;
            if (server.state != tangoServer.getState()) {
                tangoServer.setState(server.state);
                bl = true;
            }
            if (!(server.controlled != tangoServer.controlled | server.level != tangoServer.startup_level)) continue;
            tangoServer.controlled = server.controlled;
            tangoServer.startup_level = server.level;
            bl2 = true;
        }
        for (int i = 0; i < this.host.nbServers(); ++i) {
            Object object;
            object = this.host.getServer(i);
            boolean bl3 = false;
            for (int j = 0; !bl3 && j < vector.size(); ++j) {
                Server server = (Server)vector.get(j);
                bl3 = server.name.equals(((TangoServer)object).getName());
            }
            if (bl3) continue;
            this.host.removeServer(((TangoServer)object).getName());
            bl2 = true;
        }
        if (bl2) {
            return 1;
        }
        if (bl) {
            return 2;
        }
        return 0;
    }

    private DevState string2state(String string) {
        for (int i = 0; i < Tango_DevStateName.length; ++i) {
            if (!string.equals(Tango_DevStateName[i])) continue;
            return DevState.from_int((int)i);
        }
        return DevState.UNKNOWN;
    }

    void setSelection(String string) {
        if (this.trees != null) {
            for (LevelTree levelTree : this.trees) {
                TangoServer tangoServer = levelTree.getServer(string);
                if (tangoServer != null) {
                    levelTree.expandTree();
                    levelTree.setSelection(tangoServer);
                    continue;
                }
                levelTree.resetSelection();
            }
        }
    }

    void updateData() {
        this.updatePanel();
    }

    private void subscribeChangeEvent() {
        try {
            if (this.host.supplier == null) {
                this.host.supplier = new TangoEventsAdapter((DeviceProxy)this.host);
            }
        }
        catch (DevFailed devFailed) {
            this.host.use_events = false;
            System.out.println("subscribeChangeServerEvent() for " + this.host.get_name() + " FAILED !");
            Except.print_exception((Exception)((Object)devFailed));
            return;
        }
        catch (Exception exception) {
            this.host.use_events = false;
            System.out.println("subscribeChangeServerEvent() for " + this.host.get_name() + " FAILED !");
            System.out.println(exception);
            return;
        }
        try {
            this.server_listener = new ServerEventListener();
            this.host.supplier.addTangoChangeListener((ITangoChangeListener)this.server_listener, this.attribute, filters);
            System.out.println("subscribeChangeServerEvent() for " + this.host.get_name() + "/" + this.attribute + " OK!");
        }
        catch (DevFailed devFailed) {
            this.host.use_events = false;
            System.out.println("subscribeChangeServerEvent() for " + this.host.get_name() + " FAILED !");
            Except.print_exception((Exception)((Object)devFailed));
        }
        catch (Exception exception) {
            this.host.use_events = false;
            System.out.println("subscribeChangeServerEvent() for " + this.host.get_name() + " FAILED !");
            System.out.println(exception);
        }
    }

    public void unsubscribeServersEvent() {
        if (this.host.supplier != null && this.server_listener != null) {
            try {
                this.host.supplier.removeTangoChangeListener((ITangoChangeListener)this.server_listener, this.attribute);
                System.out.println("unsubscribe event for " + this.host.getName() + "/" + this.attribute);
            }
            catch (DevFailed devFailed) {
                System.out.println("Failed to unsubscribe event for " + this.attribute);
                Except.print_exception((Exception)((Object)devFailed));
            }
        }
    }

    static {
        filters = new String[0];
    }

    class Blink {
        private JComponent obj;
        private int cnt;
        private Timer timer;
        private Color color;
        private long t0 = 0L;
        private int duration;
        private String text = null;

        Blink(JComponent jComponent) {
            this.obj = jComponent;
            this.cnt = 0;
            this.color = jComponent.getBackground();
        }

        Blink(JComponent jComponent, int n) {
            this(jComponent);
            this.duration = n;
            if (jComponent instanceof JLabel) {
                this.text = ((JLabel)jComponent).getText();
            } else {
                this.color = jComponent.getBackground();
            }
            this.t0 = System.currentTimeMillis();
        }

        void blinkPerformer(ActionEvent actionEvent) {
            long l;
            ++this.cnt;
            if (this.cnt % 2 == 0) {
                if (this.obj instanceof JLabel) {
                    ((JLabel)this.obj).setText("-> " + this.text);
                } else {
                    this.obj.setBackground(this.color);
                }
            } else if (this.obj instanceof JLabel) {
                ((JLabel)this.obj).setText(this.text);
            } else {
                this.obj.setBackground(Color.lightGray);
            }
            if (this.duration != 0 && (l = System.currentTimeMillis()) - this.t0 >= (long)(this.duration * 1000)) {
                this.timer.stop();
                if (this.obj instanceof JLabel) {
                    ((JLabel)this.obj).setText(this.text);
                } else {
                    this.obj.setBackground(this.color);
                }
            }
        }

        private void start() {
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Blink.this.blinkPerformer(actionEvent);
                }
            };
            this.timer = new Timer(200, actionListener);
            this.timer.start();
        }
    }

    class ServerEventListener
    implements ITangoChangeListener {
        ServerEventListener() {
        }

        public void change(TangoChangeEvent tangoChangeEvent) {
            System.out.println(" change(TangoChangeEvent event)");
            TangoChange tangoChange = (TangoChange)tangoChangeEvent.getSource();
            String string = tangoChange.getEventSupplier().get_name();
            try {
                DeviceAttribute deviceAttribute = tangoChangeEvent.getValue();
                HostInfoDialog.this.manageServersAttribute(deviceAttribute);
            }
            catch (DevFailed devFailed) {
                if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                    System.out.println("HostStataThread.ServerEventListener" + string + " : API_EventTimeout");
                } else {
                    Except.print_exception((Exception)((Object)devFailed));
                }
            }
            catch (Exception exception) {
                System.out.println("AstorEvent." + string);
                System.out.println(exception);
                System.out.println("HostStateThread.ServerEventListener : could not extract data!");
            }
        }
    }

    class UpdateThread
    extends Thread {
        private int readInfoPeriod = 1000;
        private boolean stop_it = false;

        public void run() {
            if (HostInfoDialog.this.host.use_events) {
                HostInfoDialog.this.subscribeChangeEvent();
            }
            while (!this.stop_it) {
                long l = System.currentTimeMillis();
                if (!HostInfoDialog.this.host.use_events && HostInfoDialog.this.host.do_polling) {
                    this.manageSynchronous();
                }
                this.wait_next_loop(l);
            }
        }

        public synchronized void wait_next_loop(long l) {
            try {
                long l2 = System.currentTimeMillis();
                long l3 = (long)this.readInfoPeriod - (l2 - l);
                if (l3 <= 0L) {
                    l3 = 100L;
                }
                this.wait(l3);
            }
            catch (InterruptedException interruptedException) {
                System.out.println(interruptedException);
            }
        }

        private void manageSynchronous() {
            try {
                DeviceAttribute deviceAttribute = HostInfoDialog.this.host.read_attribute(HostInfoDialog.this.attribute);
                HostInfoDialog.this.manageServersAttribute(deviceAttribute);
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
        }
    }

    class Server {
        String name;
        DevState state;
        boolean controlled = false;
        int level = 0;

        public Server(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            Vector<String> vector = new Vector<String>();
            while (stringTokenizer.hasMoreTokens()) {
                vector.add(stringTokenizer.nextToken());
            }
            if (vector.size() > 0) {
                this.name = (String)vector.get(0);
            }
            if (vector.size() > 1) {
                this.state = HostInfoDialog.this.string2state((String)vector.get(1));
            }
            if (vector.size() > 2) {
                this.controlled = vector.get(2).equals("1");
            }
            if (vector.size() > 3) {
                String string2 = (String)vector.get(3);
                try {
                    this.level = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        public String toString() {
            return this.name + " -> " + ApiUtil.stateName((DevState)this.state) + "\t- " + (this.controlled ? "" : "not ") + "Controlled \tlevel " + this.level;
        }
    }
}

