/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorUtil;
import app_util.PopupError;
import app_util.PopupMessage;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AttributeProxy;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AttMemoDialog
extends JDialog {
    private JDialog parent;
    private DbServer server;
    private boolean from_appli = true;
    private Memorized[] memorized;
    private JLabel[] attLbl;
    private JTextField[] attVal;
    private static final String unknown = " ? ";
    private JLabel titleLabel;
    private JPanel jPanel2;
    private JPanel jPanel1;
    private JButton okBtn;
    private JPanel valuePanel;
    private JButton cancelBtn;

    public AttMemoDialog(JDialog jDialog, DbServer dbServer) throws DevFailed {
        super((Dialog)jDialog, true);
        this.parent = jDialog;
        this.server = dbServer;
        this.initComponents();
        this.buildMemorizedPanel();
        this.titleLabel.setText("Memorized attributes found for " + dbServer.name());
        this.pack();
        if (jDialog.getWidth() == 0) {
            this.from_appli = false;
        }
        if (this.from_appli) {
            AstorUtil.centerDialog((JDialog)this, jDialog);
        }
    }

    private void buildMemorizedPanel() throws DevFailed {
        this.readAttributes();
        this.attLbl = new JLabel[this.memorized.length];
        this.attVal = new JTextField[this.memorized.length];
        for (int i = 0; i < this.memorized.length; ++i) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            int n = 0;
            int n2 = i + 1;
            this.attLbl[i] = new JLabel(this.memorized[i].attname);
            gridBagConstraints.gridx = n++;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.fill = 2;
            this.valuePanel.add((Component)this.attLbl[i], gridBagConstraints);
            gridBagConstraints.gridx = n++;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.fill = 2;
            this.valuePanel.add((Component)new JLabel("  :    "), gridBagConstraints);
            this.attVal[i] = new JTextField(this.memorized[i].value);
            this.attVal[i].setColumns(15);
            gridBagConstraints.gridx = n++;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.fill = 2;
            this.valuePanel.add((Component)this.attVal[i], gridBagConstraints);
            gridBagConstraints.gridx = n++;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.fill = 2;
            this.valuePanel.add((Component)new JLabel("     " + this.memorized[i].min + " < .... < " + this.memorized[i].max), gridBagConstraints);
        }
    }

    private void readAttributes() throws DevFailed {
        int n;
        DeviceProxy[] deviceProxyArray = this.getDevices();
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < deviceProxyArray.length; ++n) {
            String string = deviceProxyArray[n].get_name();
            DeviceData deviceData = new DeviceData();
            String[] stringArray = new String[]{string, "*"};
            deviceData.insert(stringArray);
            DeviceData deviceData2 = ApiUtil.get_db_obj().command_inout("DbGetDeviceAttributeList", deviceData);
            String[] stringArray2 = deviceData2.extractStringArray();
            for (int i = 0; i < stringArray2.length; ++i) {
                DbAttribute dbAttribute = deviceProxyArray[n].get_attribute_property(stringArray2[i]);
                String[] stringArray3 = dbAttribute.get_property_list();
                for (int j = 0; j < stringArray3.length; ++j) {
                    if (!stringArray3[j].equals("__value")) continue;
                    String string2 = unknown;
                    if (!dbAttribute.is_empty("min_value")) {
                        string2 = dbAttribute.get_value("min_value")[0];
                    }
                    String string3 = unknown;
                    if (!dbAttribute.is_empty("max_value")) {
                        string3 = dbAttribute.get_value("max_value")[0];
                    }
                    vector.add(string + "/" + stringArray2[i]);
                    vector.add(dbAttribute.get_string_value(j));
                    vector.add(string2);
                    vector.add(string3);
                }
            }
        }
        this.memorized = new Memorized[vector.size() / 4];
        for (n = 0; n < vector.size(); n += 4) {
            this.memorized[n / 4] = new Memorized((String)vector.elementAt(n), (String)vector.elementAt(n + 1), (String)vector.elementAt(n + 2), (String)vector.elementAt(n + 3));
        }
    }

    private DeviceProxy[] getDevices() throws DevFailed {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = this.server.get_class_list();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = this.server.get_device_name(stringArray[i]);
            for (int j = 0; j < stringArray2.length; ++j) {
                vector.add(stringArray2[j]);
            }
        }
        DeviceProxy[] deviceProxyArray = new DeviceProxy[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            deviceProxyArray[i] = new DeviceProxy((String)vector.elementAt(i));
        }
        return deviceProxyArray;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okBtn = new JButton();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.valuePanel = new JPanel();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AttMemoDialog.this.closeDialog(windowEvent);
            }
        });
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttMemoDialog.this.okBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.okBtn);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttMemoDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.valuePanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.valuePanel, "Center");
        this.pack();
    }

    private boolean writeValues() {
        String string = "";
        for (int i = 0; i < this.attVal.length; ++i) {
            double d;
            String string2 = this.attVal[i].getText();
            Memorized memorized = this.memorized[i];
            if (string2.equals(memorized.value)) continue;
            try {
                d = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                PopupError.show((Component)this.parent, string2 + " is not a number !");
                return false;
            }
            if (!memorized.min.equals(unknown)) {
                double d2;
                try {
                    d2 = Double.parseDouble(memorized.min);
                }
                catch (NumberFormatException numberFormatException) {
                    PopupError.show((Component)this.parent, memorized.min + " is not a number !");
                    return false;
                }
                if (d < d2) {
                    PopupError.show((Component)this.parent, "Incorrect value:\n" + string2 + " is less than " + memorized.min);
                    return false;
                }
            }
            if (!memorized.max.equals(unknown)) {
                double d3;
                try {
                    d3 = Double.parseDouble(memorized.max);
                }
                catch (NumberFormatException numberFormatException) {
                    PopupError.show((Component)this.parent, memorized.max + " is not a number !");
                    return false;
                }
                if (d > d3) {
                    PopupError.show((Component)this.parent, "Incorrect value:\n" + string2 + " is greater than " + memorized.max);
                    return false;
                }
            }
            try {
                DbDatum dbDatum = new DbDatum("__value");
                dbDatum.insert(string2);
                AttributeProxy attributeProxy = new AttributeProxy(this.attLbl[i].getText());
                attributeProxy.put_property(dbDatum);
                memorized.value = string2;
                string = string + this.attLbl[i].getText() + "  set to  " + string2 + "\n";
                continue;
            }
            catch (DevFailed devFailed) {
                PopupError.show((Component)this.parent, devFailed);
                return false;
            }
        }
        if (string.length() > 0) {
            PopupMessage.show((Component)this.parent, string);
        }
        return true;
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        if (this.writeValues()) {
            this.doClose();
        }
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
        if (!this.from_appli) {
            System.exit(0);
        }
    }

    public void showDialog() {
        if (this.memorized.length == 0) {
            PopupError.show((Component)this.parent, "No memorized attribute found for " + this.server.name());
        } else {
            this.setVisible(true);
        }
    }

    public static void main(String[] stringArray) {
        try {
            AttMemoDialog attMemoDialog = new AttMemoDialog(new JDialog(), new DbServer("PowerSupply/pv"));
            attMemoDialog.showDialog();
        }
        catch (DevFailed devFailed) {
            Except.print_exception((Exception)((Object)devFailed));
        }
    }

    class Memorized {
        String attname;
        String value;
        String min;
        String max;

        Memorized(String string, String string2, String string3, String string4) {
            this.attname = string;
            this.value = string2;
            this.min = string3;
            this.max = string4;
        }
    }
}

