/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.dds;

import java.util.Iterator;
import java.util.Vector;
import org.jacorb.dds.DomainParticipantImpl;
import org.jacorb.dds.ThreadSubscriber;
import org.jacorb.events.EventChannelImpl;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.PortableServer.POA;
import org.omg.dds.DomainParticipant;
import org.omg.dds.DomainParticipantFactory;
import org.omg.dds.DomainParticipantFactoryPOA;
import org.omg.dds.DomainParticipantHelper;
import org.omg.dds.DomainParticipantListener;
import org.omg.dds.DomainParticipantQos;
import org.omg.dds.DomainParticipantQosHolder;

public class DomainParticipantFactoryImpl
extends DomainParticipantFactoryPOA {
    private ORB orb;
    private POA poa;
    private DomainParticipantQos defaultqos;
    private ThreadSubscriber Consummer;
    private Vector allParticipant;
    private DomainParticipantFactoryImpl impl;
    private DomainParticipantFactory ref;

    public void setPOA(POA pOA) {
        this.poa = pOA;
    }

    public void setORB(ORB oRB) {
        this.orb = oRB;
    }

    public DomainParticipantFactoryImpl(ORB oRB, POA pOA) {
        this.orb = oRB;
        this.poa = pOA;
        try {
            NamingContextExt namingContextExt = NamingContextExtHelper.narrow(oRB.resolve_initial_references("NameService"));
            EventChannelImpl eventChannelImpl = new EventChannelImpl(oRB, pOA);
            Object object = pOA.servant_to_reference(eventChannelImpl);
            namingContextExt.rebind(namingContextExt.to_name("eventchannel"), object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.allParticipant = new Vector();
        this.Consummer = new ThreadSubscriber(oRB, pOA);
        this.Consummer.start();
    }

    public DomainParticipant create_participant(int n, DomainParticipantQos domainParticipantQos, DomainParticipantListener domainParticipantListener) {
        DomainParticipant domainParticipant = null;
        DomainParticipantImpl domainParticipantImpl = new DomainParticipantImpl(n, domainParticipantQos, domainParticipantListener);
        domainParticipantImpl.setORB(this.orb);
        domainParticipantImpl.setPOA(this.poa);
        try {
            domainParticipant = this.has_domainId(n);
            if (domainParticipant != null) {
                return domainParticipant;
            }
            Object object = this.orb.resolve_initial_references("NameService");
            NamingContextExt namingContextExt = NamingContextExtHelper.narrow(object);
            Object object2 = this.poa.servant_to_reference(domainParticipantImpl);
            domainParticipant = DomainParticipantHelper.narrow(object2);
            if (namingContextExt != null) {
                NameComponent[] nameComponentArray = namingContextExt.to_name(new Integer(n).toString());
                namingContextExt.rebind(nameComponentArray, domainParticipant);
                this.allParticipant.add(domainParticipant);
                this.Consummer.add(domainParticipant);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return domainParticipant;
    }

    public int delete_participant(DomainParticipant domainParticipant) {
        try {
            boolean bl = ((DomainParticipantImpl)this.poa.reference_to_servant(domainParticipant)).isDeletable();
            if (!bl) {
                return 4;
            }
            Object object = this.orb.resolve_initial_references("NameService");
            NamingContextExt namingContextExt = NamingContextExtHelper.narrow(object);
            String string = new Integer(domainParticipant.get_domain_id()).toString();
            NameComponent[] nameComponentArray = namingContextExt.to_name(string);
            namingContextExt.unbind(nameComponentArray);
        }
        catch (Exception exception) {
            System.err.println("ERROR: " + exception);
            exception.printStackTrace(System.out);
        }
        return 0;
    }

    public DomainParticipant has_domainId(int n) {
        Iterator iterator = this.allParticipant.iterator();
        while (iterator.hasNext()) {
            DomainParticipant domainParticipant = (DomainParticipant)iterator.next();
            if (domainParticipant.get_domain_id() != n) continue;
            return domainParticipant;
        }
        return null;
    }

    public DomainParticipant lookup_participant(int n) {
        DomainParticipant domainParticipant = null;
        try {
            Object object = this.orb.resolve_initial_references("NameService");
            NamingContextExt namingContextExt = NamingContextExtHelper.narrow(object);
            domainParticipant = DomainParticipantHelper.narrow(namingContextExt.resolve_str(new Integer(n).toString()));
        }
        catch (Exception exception) {
            System.err.println("ERROR: " + exception);
            exception.printStackTrace(System.out);
        }
        return domainParticipant;
    }

    public int set_default_participant_qos(DomainParticipantQos domainParticipantQos) {
        this.defaultqos = domainParticipantQos;
        return 0;
    }

    public void get_default_participant_qos(DomainParticipantQosHolder domainParticipantQosHolder) {
        domainParticipantQosHolder.value = this.defaultqos;
    }

    public ORB getOrb() {
        return this.orb;
    }

    public POA getPoa() {
        return this.poa;
    }
}

