/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevCmdInfo;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoDs.Except;

public class DevVarCmdArray {
    protected CommandInfo[] cmd_info;
    protected String devname;

    public DevVarCmdArray(String string, DevCmdInfo[] devCmdInfoArray) {
        this.devname = string;
        this.cmd_info = new CommandInfo[devCmdInfoArray.length];
        for (int i = 0; i < devCmdInfoArray.length; ++i) {
            this.cmd_info[i] = new CommandInfo(devCmdInfoArray[i]);
        }
    }

    public DevVarCmdArray(String string, CommandInfo[] commandInfoArray) {
        this.devname = string;
        this.cmd_info = commandInfoArray;
    }

    public int size() {
        return this.cmd_info.length;
    }

    public CommandInfo elementAt(int n) {
        return this.cmd_info[n];
    }

    public CommandInfo[] getInfoArray() {
        return this.cmd_info;
    }

    public int argoutType(String string) throws DevFailed {
        for (CommandInfo commandInfo : this.cmd_info) {
            if (!string.equals(commandInfo.cmd_name)) continue;
            return commandInfo.out_type;
        }
        Except.throw_non_supported_exception("TACO_CMD_UNAVAILABLE", string + " command unknown for device " + this.devname, "DevVarCmdArray.argoutType()");
        return -1;
    }

    public int arginType(String string) throws DevFailed {
        for (CommandInfo commandInfo : this.cmd_info) {
            if (!string.equals(commandInfo.cmd_name)) continue;
            return commandInfo.in_type;
        }
        Except.throw_non_supported_exception("TACO_CMD_UNAVAILABLE", string + " command unknown for device " + this.devname, "DevVarCmdArray.arginType()");
        return -1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (CommandInfo commandInfo : this.cmd_info) {
            stringBuffer.append(commandInfo.cmd_name);
            stringBuffer.append("(").append(commandInfo.in_type);
            stringBuffer.append(", ").append(commandInfo.out_type).append(")\n");
        }
        return stringBuffer.toString();
    }
}

