/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoDs.Attr;
import fr.esrf.TangoDs.AttrProperty;
import fr.esrf.TangoDs.Attribute;
import fr.esrf.TangoDs.DeviceClass;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.TangoDs.Util;
import fr.esrf.TangoDs.WAttribute;
import java.util.Vector;

public class MultiAttribute
implements TangoConst {
    protected Vector attr_list = new Vector();
    protected Vector writable_attr_list = new Vector();
    protected Vector alarm_attr_list = new Vector();
    private static final AttrProperty[] def_opt_prop = new AttrProperty[]{new AttrProperty("label", "No label"), new AttrProperty("description", "No description"), new AttrProperty("unit", "No unit"), new AttrProperty("standard_unit", "No standard unit"), new AttrProperty("display_unit", "No display unit"), new AttrProperty("format", "No format"), new AttrProperty("min_value", "Not specified"), new AttrProperty("max_value", "Not specified"), new AttrProperty("min_alarm", "Not specified"), new AttrProperty("max_alarm", "Not specified"), new AttrProperty("writable_attr_name", "None")};

    public MultiAttribute(String string, DeviceClass deviceClass) throws DevFailed {
        int n;
        Util.out4.println("Entering MultiAttribute class constructor for device " + string);
        Vector vector = deviceClass.get_class_attr().get_attr_list();
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = ((Attr)vector.get(i)).get_name();
        }
        DbAttribute[] dbAttributeArray = new DbAttribute[]{};
        if (Util._UseDb) {
            dbAttributeArray = ApiUtil.get_db_obj().get_device_attribute_property(string, stringArray);
        }
        for (n = 0; n < stringArray.length; ++n) {
            String[] stringArray2;
            Attr attr = deviceClass.get_class_attr().get_attr(((Attr)vector.elementAt(n)).get_name());
            Vector vector2 = attr.get_class_properties();
            Vector vector3 = attr.get_user_default_properties();
            Vector<AttrProperty> vector4 = new Vector<AttrProperty>();
            if (Util._UseDb) {
                stringArray2 = dbAttributeArray[n].get_property_list();
                for (int i = 0; i < stringArray2.length; ++i) {
                    AttrProperty attrProperty = new AttrProperty(stringArray2[i], dbAttributeArray[n].get_value(i));
                    vector4.add(attrProperty);
                }
            }
            stringArray2 = new Vector();
            this.concat(vector4, vector2, (Vector)stringArray2);
            this.add_user_default((Vector)stringArray2, vector3);
            this.add_default((Vector)stringArray2);
            Attribute attribute = attr.get_writable() == AttrWriteType.WRITE || attr.get_writable() == AttrWriteType.READ_WRITE ? new WAttribute((Vector)stringArray2, attr, string) : new Attribute((Vector)stringArray2, attr, string);
            this.attr_list.add(attribute);
            if (attribute.get_writable() == AttrWriteType.WRITE || attribute.get_writable() == AttrWriteType.READ_WRITE) {
                this.writable_attr_list.addElement(n);
            }
            if (attribute.is_alarmed() && attribute.get_writable() != AttrWriteType.WRITE) {
                this.alarm_attr_list.addElement(n);
            }
            Util.out4.println(this.attr_list.elementAt(n));
        }
        for (n = 0; n < vector.size(); ++n) {
            this.check_associated(n, string);
        }
        Util.out4.println("Leaving MultiAttribute class constructor");
    }

    private void concat(Vector vector, Vector vector2, Vector vector3) {
        int n;
        for (n = 0; n < vector.size(); ++n) {
            vector3.addElement(vector.elementAt(n));
        }
        Vector vector4 = (Vector)vector3.clone();
        int n2 = vector2.size();
        for (n = 0; n < n2; ++n) {
            int n3;
            for (n3 = 0; n3 < vector4.size() && !((AttrProperty)vector4.elementAt(n3)).get_name().equals(((AttrProperty)vector2.elementAt(n)).get_name()); ++n3) {
            }
            if (n3 != vector4.size()) continue;
            vector3.addElement(vector2.elementAt(n));
        }
    }

    private void add_default(Vector vector) {
        int n = def_opt_prop.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            String string = def_opt_prop[i].get_name();
            for (n2 = 0; n2 < vector.size() && !((AttrProperty)vector.elementAt(n2)).get_name().equals(string); ++n2) {
            }
            if (n2 != vector.size()) continue;
            vector.addElement(def_opt_prop[i]);
        }
    }

    void add_user_default(Vector vector, Vector vector2) {
        int n = vector2.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            String string = ((AttrProperty)vector2.elementAt(i)).get_name();
            for (n2 = 0; n2 < vector.size() && !((AttrProperty)vector.elementAt(n2)).get_name().equals(string); ++n2) {
            }
            if (n2 != vector.size()) continue;
            vector.addElement(vector2.elementAt(i));
        }
    }

    void check_associated(int n, String string) throws DevFailed {
        Attribute attribute = (Attribute)this.attr_list.elementAt(n);
        if (attribute.get_writable() == AttrWriteType.READ_WITH_WRITE || attribute.get_writable() == AttrWriteType.READ_WRITE) {
            StringBuffer stringBuffer;
            Object object;
            int n2;
            if (attribute.get_data_format().value() != 0) {
                StringBuffer stringBuffer2 = new StringBuffer("Device --> ");
                stringBuffer2.append(string);
                stringBuffer2.append("\nProperty writable_attr_name for attribute ");
                stringBuffer2.append(attribute.get_name());
                stringBuffer2.append(" is defined but this attribute data format is not SCALAR");
                Except.throw_exception("API_AttrOptProp", stringBuffer2.toString(), "MultiAttribute.check_associated");
            }
            int n3 = 0;
            String string2 = attribute.get_assoc_name();
            for (n2 = 0; n2 < this.writable_attr_list.size() && !((Attribute)this.attr_list.elementAt(n3 = ((Integer)this.writable_attr_list.elementAt(n2)).intValue())).get_name().equals(string2); ++n2) {
            }
            if (n2 == this.writable_attr_list.size()) {
                object = new StringBuffer("Device --> ");
                ((StringBuffer)object).append(string);
                ((StringBuffer)object).append("\nProperty writable_attr_name for attribute ");
                ((StringBuffer)object).append(attribute.get_name());
                ((StringBuffer)object).append(" is set to ");
                ((StringBuffer)object).append(string2);
                ((StringBuffer)object).append(", but this attribute does not exists or is not writable");
                Except.throw_exception("API_AttrOptProp", ((StringBuffer)object).toString(), "MultiAttribute.check_associated");
            }
            if (((Attribute)(object = (Attribute)this.attr_list.elementAt(n3))).get_data_format().value() != 0) {
                stringBuffer = new StringBuffer("Device --> ");
                stringBuffer.append(string);
                stringBuffer.append("\nProperty writable_attr_name for attribute ");
                stringBuffer.append(attribute.get_name());
                stringBuffer.append(" is set to ");
                stringBuffer.append(string2);
                stringBuffer.append(", but this attribute is not of the SCALAR data format");
                Except.throw_exception("API_AttrOptProp", stringBuffer.toString(), "MultiAttribute.check_assiocated");
            }
            if (((Attribute)object).get_data_type() != attribute.get_data_type()) {
                stringBuffer = new StringBuffer("Device --> ");
                stringBuffer.append(string);
                stringBuffer.append("\nProperty writable_attr_name for attribute ");
                stringBuffer.append(attribute.get_name());
                stringBuffer.append(" is set to ");
                stringBuffer.append(string2);
                stringBuffer.append(", but these two attributes do not support the same data type");
                Except.throw_exception("API_AttrOptProp", stringBuffer.toString(), "MultiAttribute.check_associated");
            }
            attribute.set_assoc_ind(n3);
        }
    }

    void add_attribute(String string, DeviceClass deviceClass, int n) throws DevFailed {
        String[] stringArray;
        Util.out4.println("Entering MultiAttribute::add_attribute");
        Vector vector = deviceClass.get_class_attr().get_attr_list();
        Attr attr = (Attr)vector.get(n);
        DbAttribute dbAttribute = null;
        if (Util._UseDb) {
            dbAttribute = ApiUtil.get_db_obj().get_device_attribute_property(string, attr.get_name());
        }
        Vector vector2 = attr.get_class_properties();
        Vector vector3 = attr.get_user_default_properties();
        Vector<AttrProperty> vector4 = new Vector<AttrProperty>();
        if (Util._UseDb) {
            assert (dbAttribute != null);
            stringArray = dbAttribute.get_property_list();
            for (int i = 0; i < stringArray.length; ++i) {
                AttrProperty attrProperty = new AttrProperty(stringArray[i], dbAttribute.get_value(i));
                vector4.add(attrProperty);
            }
        }
        stringArray = new Vector();
        this.concat(vector4, vector2, (Vector)stringArray);
        this.add_user_default((Vector)stringArray, vector3);
        this.add_default((Vector)stringArray);
        Attribute attribute = attr.get_writable() == AttrWriteType.WRITE || attr.get_writable() == AttrWriteType.READ_WRITE ? new WAttribute((Vector)stringArray, attr, string) : new Attribute((Vector)stringArray, attr, string);
        this.attr_list.add(attribute);
        if (attribute.get_writable() == AttrWriteType.WRITE || attribute.get_writable() == AttrWriteType.READ_WRITE) {
            this.writable_attr_list.addElement(n);
        }
        if (attribute.is_alarmed() && attribute.get_writable() != AttrWriteType.WRITE) {
            this.alarm_attr_list.addElement(n);
        }
        this.check_associated(this.attr_list.size() - 1, string);
        Util.out4.println("Leaving MultiAttribute::add_attribute");
    }

    public void remove_attribute(String string) throws DevFailed {
        Attribute attribute = this.get_attr_by_name(string);
        this.attr_list.remove(attribute);
    }

    public Attribute get_attr_by_name(String string) throws DevFailed {
        Attribute attribute = null;
        for (int i = 0; i < this.attr_list.size(); ++i) {
            Attribute attribute2 = (Attribute)this.attr_list.elementAt(i);
            if (!attribute2.get_name().equalsIgnoreCase(string)) continue;
            attribute = attribute2;
        }
        if (attribute == null) {
            Util.out3.println("MultiAttribute.get_attr throwing exception");
            Except.throw_exception("API_AttrNotFound", string + " attribute not found", "MultiAttribute.get_attr");
        }
        return attribute;
    }

    public WAttribute get_w_attr_by_name(String string) throws DevFailed {
        Attribute attribute = this.get_attr_by_name(string);
        return (WAttribute)attribute;
    }

    public int get_attr_ind_by_name(String string) throws DevFailed {
        int n;
        int n2 = this.attr_list.size();
        for (n = 0; n < n2 && !((Attribute)this.attr_list.elementAt(n)).get_name().equalsIgnoreCase(string); ++n) {
        }
        if (n == n2) {
            Util.out3.println("MultiAttribute.get_attr_ind_by_name throwing exception");
            Except.throw_exception("API_AttrNotFound", string + " attribute not found", "MultiAttribute.get_attr_ind_by_name");
        }
        return n;
    }

    public boolean check_alarm() throws DevFailed {
        boolean bl = false;
        int n = this.alarm_attr_list.size();
        for (int i = 0; i < n; ++i) {
            boolean bl2 = this.check_alarm((Integer)this.alarm_attr_list.elementAt(i));
            if (!bl2) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean check_alarm(String string) throws DevFailed {
        return this.get_attr_by_name(string).check_alarm();
    }

    public boolean check_alarm(int n) throws DevFailed {
        return this.get_attr_by_ind(n).check_alarm();
    }

    void add_write_value(Attribute attribute) {
        WAttribute wAttribute = this.get_w_attr_by_ind(attribute.get_assoc_ind());
        switch (attribute.get_data_type()) {
            case 1: {
                boolean bl = wAttribute.getBooleanWriteValue();
                attribute.add_write_value(bl);
                break;
            }
            case 2: {
                short s = wAttribute.getShortWriteValue();
                attribute.add_write_value(s);
                break;
            }
            case 6: {
                short s = wAttribute.getShortWriteValue();
                attribute.add_write_value(s);
                break;
            }
            case 3: {
                int n = wAttribute.getLongWriteValue();
                attribute.add_write_value(n);
                break;
            }
            case 7: {
                int n = wAttribute.getLongWriteValue();
                attribute.add_write_value(n);
                break;
            }
            case 23: {
                long l = wAttribute.getLong64WriteValue();
                attribute.add_write_value(l);
                break;
            }
            case 24: {
                long l = wAttribute.getULong64WriteValue();
                attribute.add_write_value(l);
                break;
            }
            case 5: {
                double d = wAttribute.getDoubleWriteValue();
                attribute.add_write_value(d);
                break;
            }
            case 8: {
                String string = wAttribute.getStringWriteValue();
                attribute.add_write_value(string);
            }
        }
    }

    public void read_alarm(StringBuffer stringBuffer) {
        for (int i = 0; i < this.alarm_attr_list.size(); ++i) {
            Attribute attribute = this.get_attr_by_ind((Integer)this.alarm_attr_list.elementAt(i));
            if (attribute.get_quality().value() != 2) continue;
            if (attribute.is_min_alarm()) {
                stringBuffer.append("\nAlarm : Value too low for attribute ");
                stringBuffer.append(attribute.get_name());
            }
            if (!attribute.is_max_alarm()) continue;
            stringBuffer.append("\nAlarm : Value too high for attribute ");
            stringBuffer.append(attribute.get_name());
        }
    }

    public Vector get_alarm_list() {
        return this.alarm_attr_list;
    }

    public int get_attr_nb() {
        return this.attr_list.size();
    }

    public Attribute get_attr_by_ind(int n) {
        return (Attribute)this.attr_list.elementAt(n);
    }

    public WAttribute get_w_attr_by_ind(int n) {
        return (WAttribute)this.attr_list.elementAt(n);
    }
}

