/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.helpers;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DevVarDoubleStringArray;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.StateUtilities;
import fr.esrf.TangoDs.Except;
import java.util.Vector;
import org.omg.CORBA.BAD_PARAM;

public class CommandHelper {
    public static void insert(Object object, DeviceData deviceData, int n) throws DevFailed {
        if (object instanceof Short) {
            CommandHelper.insertFromShort((Short)object, deviceData, n);
        } else if (object instanceof String) {
            CommandHelper.insertFromString((String)object, deviceData, n);
        } else if (object instanceof Integer) {
            CommandHelper.insertFromInteger((Integer)object, deviceData, n);
        } else if (object instanceof Long) {
            CommandHelper.insertFromLong((Long)object, deviceData, n);
        } else if (object instanceof Float) {
            CommandHelper.insertFromFloat((Float)object, deviceData, n);
        } else if (object instanceof Boolean) {
            CommandHelper.insertFromBoolean((Boolean)object, deviceData, n);
        } else if (object instanceof Double) {
            CommandHelper.insertFromDouble((Double)object, deviceData, n);
        } else if (object instanceof DevState) {
            CommandHelper.insertFromDevState((DevState)object, deviceData, n);
        } else if (object instanceof DevVarDoubleStringArray) {
            CommandHelper.insertFromDevVarDoubleStringArray((DevVarDoubleStringArray)object, deviceData, n);
        } else if (object instanceof DevVarLongStringArray) {
            CommandHelper.insertFromDevVarLongStringArray((DevVarLongStringArray)object, deviceData, n);
        } else if (object instanceof Vector) {
            CommandHelper.insertFromArray(((Vector)object).toArray(), deviceData, n);
        } else {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + object.getClass() + " not supported", "CommandHelper.insert(Object value,deviceDataArgin)");
        }
    }

    public static Object extract(DeviceData deviceData) throws DevFailed {
        Object object = null;
        switch (deviceData.getType()) {
            case 2: {
                object = deviceData.extractShort();
                break;
            }
            case 6: {
                object = Integer.valueOf(deviceData.extractUShort()).shortValue();
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "out type Tango_DEV_CHAR not supported", "CommandHelper.extract(deviceDataArgout)");
                break;
            }
            case 22: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "out type Tango_DEV_UCHAR not supported", "CommandHelper.extract(deviceDataArgout)");
                break;
            }
            case 3: {
                object = deviceData.extractLong();
                break;
            }
            case 7: {
                object = deviceData.extractULong();
                break;
            }
            case 23: {
                object = deviceData.extractLong64();
                break;
            }
            case 24: {
                object = deviceData.extractULong64();
                break;
            }
            case 27: {
                object = deviceData.extractLong();
                break;
            }
            case 4: {
                object = Float.valueOf(deviceData.extractFloat());
                break;
            }
            case 5: {
                object = deviceData.extractDouble();
                break;
            }
            case 8: {
                object = deviceData.extractString();
                break;
            }
            case 1: {
                object = deviceData.extractBoolean();
                break;
            }
            case 19: {
                object = deviceData.extractDevState();
                break;
            }
            case 18: {
                object = deviceData.extractDoubleStringArray();
                break;
            }
            case 17: {
                object = deviceData.extractLongStringArray();
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + deviceData.getType() + " not supported", "CommandHelper.extract(Short value,deviceDataArgout)");
            }
        }
        return object;
    }

    public static Object[] extractArray(DeviceData deviceData) throws DevFailed {
        Object[] objectArray = null;
        switch (deviceData.getType()) {
            case 2: {
                objectArray = new Object[]{CommandHelper.extract(deviceData)};
                break;
            }
            case 6: {
                objectArray = new Object[]{CommandHelper.extract(deviceData)};
                break;
            }
            case 21: {
                objectArray = new Object[]{CommandHelper.extract(deviceData)};
                break;
            }
            case 22: {
                objectArray = new Object[]{CommandHelper.extract(deviceData)};
                break;
            }
            case 3: {
                objectArray = new Object[]{CommandHelper.extract(deviceData)};
                break;
            }
            case 7: {
                objectArray = new Object[]{CommandHelper.extract(deviceData)};
                break;
            }
            case 23: {
                objectArray = new Object[]{CommandHelper.extract(deviceData)};
                break;
            }
            case 24: {
                objectArray = new Object[]{CommandHelper.extract(deviceData)};
                break;
            }
            case 27: {
                objectArray = new Object[]{CommandHelper.extract(deviceData)};
                break;
            }
            case 4: {
                objectArray = new Object[]{CommandHelper.extract(deviceData)};
                break;
            }
            case 5: {
                objectArray = new Object[]{deviceData.extractDouble()};
                break;
            }
            case 8: {
                objectArray = new Object[]{CommandHelper.extract(deviceData)};
                break;
            }
            case 1: {
                objectArray = new Object[]{CommandHelper.extract(deviceData)};
                break;
            }
            case 19: {
                objectArray = new Object[]{CommandHelper.extract(deviceData)};
                break;
            }
            case 10: {
                short[] sArray = deviceData.extractShortArray();
                objectArray = new Object[sArray.length];
                for (int i = 0; i < sArray.length; ++i) {
                    objectArray[i] = sArray[i];
                }
                break;
            }
            case 14: {
                int[] nArray = deviceData.extractUShortArray();
                objectArray = new Object[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    objectArray[i] = nArray[i];
                }
                break;
            }
            case 9: {
                byte[] byArray = deviceData.extractByteArray();
                objectArray = new Object[byArray.length];
                for (int i = 0; i < byArray.length; ++i) {
                    objectArray[i] = byArray[i];
                }
                break;
            }
            case 11: {
                int[] nArray = deviceData.extractLongArray();
                objectArray = new Object[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    objectArray[i] = nArray[i];
                }
                break;
            }
            case 15: {
                long[] lArray = deviceData.extractULongArray();
                objectArray = new Object[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    objectArray[i] = lArray[i];
                }
                break;
            }
            case 25: {
                long[] lArray = deviceData.extractLong64Array();
                objectArray = new Object[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    objectArray[i] = lArray[i];
                }
                break;
            }
            case 26: {
                long[] lArray = deviceData.extractULong64Array();
                objectArray = new Object[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    objectArray[i] = lArray[i];
                }
                break;
            }
            case 12: {
                float[] fArray = deviceData.extractFloatArray();
                objectArray = new Object[fArray.length];
                for (int i = 0; i < fArray.length; ++i) {
                    objectArray[i] = Float.valueOf(fArray[i]);
                }
                break;
            }
            case 13: {
                double[] dArray = deviceData.extractDoubleArray();
                objectArray = new Object[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    objectArray[i] = dArray[i];
                }
                break;
            }
            case 16: {
                String[] stringArray = deviceData.extractStringArray();
                objectArray = new Object[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    objectArray[i] = stringArray[i];
                }
                break;
            }
            case 17: {
                objectArray = new Object[]{CommandHelper.extract(deviceData)};
                break;
            }
            case 18: {
                objectArray = new Object[]{CommandHelper.extract(deviceData)};
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + deviceData.getType() + " not supported", "CommandHelper.insertFromShort(Short value,deviceDataArgin)");
            }
        }
        return objectArray;
    }

    public static void insertFromShort(Short s, DeviceData deviceData, int n) throws DevFailed {
        switch (n) {
            case 2: {
                deviceData.insert(s);
                break;
            }
            case 6: {
                deviceData.insert_us(s.intValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "CommandHelper.insertFromShort(Short value,deviceDataArgin)");
                break;
            }
            case 22: {
                deviceData.insert(s);
                break;
            }
            case 3: {
                deviceData.insert(s.intValue());
                break;
            }
            case 7: {
                deviceData.insert_ul(s.longValue());
                break;
            }
            case 23: {
                deviceData.insert(s.intValue());
                break;
            }
            case 24: {
                deviceData.insert_u64(s.longValue());
                break;
            }
            case 27: {
                deviceData.insert(s.intValue());
                break;
            }
            case 4: {
                deviceData.insert(s.floatValue());
                break;
            }
            case 5: {
                deviceData.insert(s.doubleValue());
                break;
            }
            case 8: {
                deviceData.insert(s.toString());
                break;
            }
            case 1: {
                if (s.doubleValue() == 1.0) {
                    deviceData.insert(true);
                    break;
                }
                deviceData.insert(false);
                break;
            }
            case 19: {
                try {
                    deviceData.insert(DevState.from_int(s.intValue()));
                }
                catch (BAD_PARAM bAD_PARAM) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "Cannot sent" + s.intValue() + "for input Tango_DEV_STATE type", "CommandHelper.insertFromShort(Short value,deviceDataArgin)");
                }
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceData.getType() + " not supported", "CommandHelper.insertFromShort(Short value,deviceDataArgin)");
            }
        }
    }

    public static Short extractToShort(DeviceData deviceData) throws DevFailed {
        Object object = CommandHelper.extract(deviceData);
        Short s = null;
        if (object instanceof Short) {
            s = (Short)object;
        } else if (object instanceof String) {
            try {
                s = Short.valueOf((String)object);
            }
            catch (Exception exception) {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + object + " is not a numerical", "CommandHelper.extractToShort(deviceDataArgin)");
            }
        } else if (object instanceof Integer) {
            s = ((Integer)object).shortValue();
        } else if (object instanceof Long) {
            s = ((Long)object).shortValue();
        } else if (object instanceof Float) {
            s = ((Float)object).shortValue();
        } else if (object instanceof Boolean) {
            s = ((Boolean)object).booleanValue() ? Short.valueOf((short)1) : Short.valueOf((short)0);
        } else if (object instanceof Double) {
            s = ((Double)object).shortValue();
        } else if (object instanceof DevState) {
            s = Integer.valueOf(((DevState)object).value()).shortValue();
        } else {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + object.getClass() + " not supported", "CommandHelper.extractToShort(Object value,deviceDataArgin)");
        }
        return s;
    }

    public static String extractToString(DeviceData deviceData) throws DevFailed {
        Object[] objectArray = CommandHelper.extractArray(deviceData);
        Object object = null;
        String string = "";
        if (objectArray.length == 1) {
            object = objectArray[0];
            if (object instanceof DevState) {
                string = StateUtilities.getNameForState((DevState)object);
            } else if (object instanceof DevVarLongStringArray) {
                int[] nArray = ((DevVarLongStringArray)object).lvalue;
                String[] stringArray = ((DevVarLongStringArray)object).svalue;
                for (int i = 0; i < stringArray.length; ++i) {
                    string = string + "DevVarLongStringArray[" + i + "]=(" + nArray[i] + "," + stringArray[i] + ")\n";
                }
            } else if (object instanceof DevVarDoubleStringArray) {
                double[] dArray = ((DevVarDoubleStringArray)object).dvalue;
                String[] stringArray = ((DevVarDoubleStringArray)object).svalue;
                for (int i = 0; i < stringArray.length; ++i) {
                    string = string + "DevVarDoubleStringArray[" + i + "]=(" + dArray[i] + "," + stringArray[i] + ")\n";
                }
            } else {
                string = object.toString();
            }
        } else if (objectArray.length > 1) {
            for (int i = 0; i < objectArray.length; ++i) {
                string = objectArray[i] instanceof DevState ? string + objectArray[i].getClass().getSimpleName() + "[" + i + "]=" + StateUtilities.getNameForState((DevState)objectArray[i]) + "\n" : string + objectArray[i].getClass().getSimpleName() + "[" + i + "]=" + objectArray[i].toString() + "\n";
            }
        } else {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + object.getClass() + " not supported", "CommandHelper.extractToString(Object value,deviceDataArgin)");
        }
        return string;
    }

    public static Integer extractToInteger(DeviceData deviceData) throws DevFailed {
        Object object = CommandHelper.extract(deviceData);
        Integer n = null;
        if (object instanceof Short) {
            n = ((Short)object).intValue();
        } else if (object instanceof String) {
            try {
                n = Integer.valueOf((String)object);
            }
            catch (Exception exception) {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + object + " is not a numerical", "CommandHelper.extractToInteger(deviceDataArgin)");
            }
        } else if (object instanceof Integer) {
            n = (Integer)object;
        } else if (object instanceof Long) {
            n = ((Long)object).intValue();
        } else if (object instanceof Float) {
            n = ((Float)object).intValue();
        } else if (object instanceof Boolean) {
            n = ((Boolean)object).booleanValue() ? Integer.valueOf(1) : Integer.valueOf(0);
        } else if (object instanceof Double) {
            n = ((Double)object).intValue();
        } else if (object instanceof DevState) {
            n = ((DevState)object).value();
        } else {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + object.getClass() + " not supported", "CommandHelper.extractToInteger(Object value,deviceDataArgin)");
        }
        return n;
    }

    public static Long extractToLong(DeviceData deviceData) throws DevFailed {
        Object object = CommandHelper.extract(deviceData);
        Long l = null;
        if (object instanceof Short) {
            l = ((Short)object).longValue();
        } else if (object instanceof String) {
            try {
                l = Long.valueOf((String)object);
            }
            catch (Exception exception) {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + object + " is not a numerical", "CommandHelper.extractToLong(deviceDataArgin)");
            }
        } else if (object instanceof Integer) {
            l = ((Integer)object).longValue();
        } else if (object instanceof Long) {
            l = (long)((Long)object);
        } else if (object instanceof Float) {
            l = ((Float)object).longValue();
        } else if (object instanceof Boolean) {
            l = ((Boolean)object).booleanValue() ? Long.valueOf(1L) : Long.valueOf(0L);
        } else if (object instanceof Double) {
            l = ((Double)object).longValue();
        } else if (object instanceof DevState) {
            l = Integer.valueOf(((DevState)object).value()).longValue();
        } else {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + object.getClass() + " not supported", "CommandHelper.extractToLong(Object value,deviceDataArgin)");
        }
        return l;
    }

    public static Float extractToFloat(DeviceData deviceData) throws DevFailed {
        Object object = CommandHelper.extract(deviceData);
        Float f = null;
        if (object instanceof Short) {
            f = Float.valueOf(((Short)object).floatValue());
        } else if (object instanceof String) {
            try {
                f = Float.valueOf((String)object);
            }
            catch (Exception exception) {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + object + " is not a numerical", "CommandHelper.extractToFloat(deviceDataArgin)");
            }
        } else if (object instanceof Integer) {
            f = Float.valueOf(((Integer)object).floatValue());
        } else if (object instanceof Long) {
            f = Float.valueOf(((Long)object).floatValue());
        } else if (object instanceof Float) {
            f = Float.valueOf(((Float)object).floatValue());
        } else if (object instanceof Boolean) {
            f = ((Boolean)object).booleanValue() ? Float.valueOf(1.0f) : Float.valueOf(0.0f);
        } else if (object instanceof Double) {
            f = Float.valueOf(((Double)object).floatValue());
        } else if (object instanceof DevState) {
            f = Float.valueOf(Integer.valueOf(((DevState)object).value()).floatValue());
        } else {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + object.getClass() + " not supported", "CommandHelper.extractToFloat(Object value,deviceDataArgin)");
        }
        return f;
    }

    public static Boolean extractToBoolean(DeviceData deviceData) throws DevFailed {
        Object object = CommandHelper.extract(deviceData);
        int n = 0;
        Boolean bl = Boolean.FALSE;
        if (object instanceof Short) {
            n = ((Short)object).intValue();
        } else if (object instanceof String) {
            try {
                if (Boolean.getBoolean((String)object)) {
                    n = 1;
                }
            }
            catch (Exception exception) {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + object + " is not a boolean", "CommandHelper.extractToBoolean(deviceDataArgin)");
            }
        } else if (object instanceof Integer) {
            n = (Integer)object;
        } else if (object instanceof Long) {
            n = ((Long)object).intValue();
        } else if (object instanceof Float) {
            n = ((Float)object).intValue();
        } else if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                n = 1;
            }
        } else if (object instanceof Double) {
            n = ((Double)object).intValue();
        } else if (object instanceof DevState) {
            n = ((DevState)object).value();
        } else {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + object.getClass() + " not supported", "CommandHelper.extractToBoolean(Object value,deviceDataArgin)");
        }
        if (n == 1) {
            bl = Boolean.TRUE;
        }
        return bl;
    }

    public static Double extractToDouble(DeviceData deviceData) throws DevFailed {
        Object object = CommandHelper.extract(deviceData);
        Double d = null;
        if (object instanceof Short) {
            d = ((Short)object).doubleValue();
        } else if (object instanceof String) {
            try {
                d = Double.valueOf((String)object);
            }
            catch (Exception exception) {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + object + " is not a numerical", "CommandHelper.extractToFloat(deviceDataArgin)");
            }
        } else if (object instanceof Integer) {
            d = ((Integer)object).doubleValue();
        } else if (object instanceof Long) {
            d = ((Long)object).doubleValue();
        } else if (object instanceof Float) {
            d = ((Float)object).doubleValue();
        } else if (object instanceof Boolean) {
            d = ((Boolean)object).booleanValue() ? Double.valueOf(1.0) : Double.valueOf(0.0);
        } else if (object instanceof Double) {
            d = (Double)object;
        } else if (object instanceof DevState) {
            d = Integer.valueOf(((DevState)object).value()).doubleValue();
        } else {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + object.getClass() + " not supported", "CommandHelper.extractToFloat(Object value,deviceDataArgin)");
        }
        return d;
    }

    public static DevState extractToDevState(DeviceData deviceData) throws DevFailed {
        DevState devState;
        block29: {
            Object object = CommandHelper.extract(deviceData);
            devState = null;
            if (object instanceof Short) {
                try {
                    devState = DevState.from_int(((Short)object).intValue());
                }
                catch (Exception exception) {
                    devState = DevState.UNKNOWN;
                }
            } else if (object instanceof String) {
                devState = StateUtilities.getStateForName((String)object);
            } else if (object instanceof Integer) {
                try {
                    devState = DevState.from_int((Integer)object);
                }
                catch (Exception exception) {
                    devState = DevState.UNKNOWN;
                }
            } else if (object instanceof Long) {
                try {
                    devState = DevState.from_int(((Long)object).intValue());
                }
                catch (Exception exception) {
                    devState = DevState.UNKNOWN;
                }
            } else if (object instanceof Float) {
                try {
                    devState = DevState.from_int(((Float)object).intValue());
                }
                catch (Exception exception) {
                    devState = DevState.UNKNOWN;
                }
            } else if (object instanceof Boolean) {
                try {
                    if (((Boolean)object).booleanValue()) {
                        devState = DevState.from_int(1);
                        break block29;
                    }
                    devState = DevState.from_int(0);
                }
                catch (Exception exception) {
                    devState = DevState.UNKNOWN;
                }
            } else if (object instanceof Double) {
                try {
                    devState = DevState.from_int(((Double)object).intValue());
                }
                catch (Exception exception) {
                    devState = DevState.UNKNOWN;
                }
            } else if (object instanceof DevState) {
                devState = (DevState)object;
            } else {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + object.getClass() + " not supported", "CommandHelper.extractToDevState(Object value,deviceDataArgin)");
            }
        }
        return devState;
    }

    public static short[] extractToShortArray(DeviceData deviceData) throws DevFailed {
        Object[] objectArray = CommandHelper.extractArray(deviceData);
        if (objectArray == null) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output is empty ", "CommandHelper.extractToShortArray(deviceDataArgin)");
        }
        short[] sArray = new short[objectArray.length];
        if (objectArray.length > 0) {
            if (objectArray[0] instanceof Short) {
                for (int i = 0; i < objectArray.length; ++i) {
                    sArray[i] = (Short)objectArray[i];
                }
            } else if (objectArray[0] instanceof String) {
                try {
                    for (int i = 0; i < objectArray.length; ++i) {
                        sArray[i] = Double.valueOf((String)objectArray[i]).shortValue();
                    }
                }
                catch (Exception exception) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type not numerical", "CommandHelper.extractToShortArray(deviceDataArgin)");
                }
            } else if (objectArray[0] instanceof Integer) {
                for (int i = 0; i < objectArray.length; ++i) {
                    sArray[i] = ((Integer)objectArray[i]).shortValue();
                }
            } else if (objectArray[0] instanceof Long) {
                for (int i = 0; i < objectArray.length; ++i) {
                    sArray[i] = ((Long)objectArray[i]).shortValue();
                }
            } else if (objectArray[0] instanceof Float) {
                for (int i = 0; i < objectArray.length; ++i) {
                    sArray[i] = ((Float)objectArray[i]).shortValue();
                }
            } else if (objectArray[0] instanceof Boolean) {
                for (int i = 0; i < objectArray.length; ++i) {
                    sArray[i] = (Boolean)objectArray[i] != false ? (short)1 : 0;
                }
            } else if (objectArray[0] instanceof Double) {
                for (int i = 0; i < objectArray.length; ++i) {
                    sArray[i] = ((Double)objectArray[i]).shortValue();
                }
            } else if (objectArray[0] instanceof Byte) {
                for (int i = 0; i < objectArray.length; ++i) {
                    sArray[i] = ((Byte)objectArray[i]).shortValue();
                }
            } else if (objectArray[0] instanceof DevState) {
                for (int i = 0; i < objectArray.length; ++i) {
                    sArray[i] = Integer.valueOf(((DevState)objectArray[i]).value()).shortValue();
                }
            } else {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + objectArray[0].getClass() + " not supported", "CommandHelper.extractToShortArray(Object value,deviceDataArgin)");
            }
        }
        return sArray;
    }

    public static String[] extractToStringArray(DeviceData deviceData) throws DevFailed {
        Object[] objectArray = CommandHelper.extractArray(deviceData);
        if (objectArray == null) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output is empty ", "CommandHelper.extractToStringArray(deviceDataArgin)");
        }
        String[] stringArray = new String[objectArray.length];
        if (objectArray.length > 0) {
            if (objectArray[0] instanceof Short) {
                for (int i = 0; i < objectArray.length; ++i) {
                    stringArray[i] = ((Short)objectArray[i]).toString();
                }
            } else if (objectArray[0] instanceof String) {
                for (int i = 0; i < objectArray.length; ++i) {
                    stringArray[i] = (String)objectArray[i];
                }
            } else if (objectArray[0] instanceof Integer) {
                for (int i = 0; i < objectArray.length; ++i) {
                    stringArray[i] = ((Integer)objectArray[i]).toString();
                }
            } else if (objectArray[0] instanceof Long) {
                for (int i = 0; i < objectArray.length; ++i) {
                    stringArray[i] = ((Long)objectArray[i]).toString();
                }
            } else if (objectArray[0] instanceof Float) {
                for (int i = 0; i < objectArray.length; ++i) {
                    stringArray[i] = ((Float)objectArray[i]).toString();
                }
            } else if (objectArray[0] instanceof Boolean) {
                for (int i = 0; i < objectArray.length; ++i) {
                    stringArray[i] = ((Boolean)objectArray[i]).toString();
                }
            } else if (objectArray[0] instanceof Double) {
                for (int i = 0; i < objectArray.length; ++i) {
                    stringArray[i] = ((Double)objectArray[i]).toString();
                }
            } else if (objectArray[0] instanceof Byte) {
                for (int i = 0; i < objectArray.length; ++i) {
                    stringArray[i] = ((Byte)objectArray[i]).toString();
                }
            } else if (objectArray[0] instanceof DevState) {
                for (int i = 0; i < objectArray.length; ++i) {
                    stringArray[i] = StateUtilities.getNameForState((DevState)objectArray[0]);
                }
            } else {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + objectArray[0].getClass() + " not supported", "CommandHelper.extractToStringArray(Object value,deviceDataArgin)");
            }
        }
        return stringArray;
    }

    public static int[] extractToIntegerArray(DeviceData deviceData) throws DevFailed {
        Object[] objectArray = CommandHelper.extractArray(deviceData);
        if (objectArray == null) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output is empty ", "CommandHelper.extractToIntegerArray(deviceDataArgin)");
        }
        int[] nArray = new int[objectArray.length];
        if (objectArray.length > 0) {
            if (objectArray[0] instanceof Short) {
                for (int i = 0; i < objectArray.length; ++i) {
                    nArray[i] = ((Short)objectArray[i]).intValue();
                }
            } else if (objectArray[0] instanceof String) {
                try {
                    for (int i = 0; i < objectArray.length; ++i) {
                        nArray[i] = Integer.valueOf((String)objectArray[i]);
                    }
                }
                catch (Exception exception) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type not numerical", "CommandHelper.extractToIntegerArray(deviceDataArgin)");
                }
            } else if (objectArray[0] instanceof Integer) {
                for (int i = 0; i < objectArray.length; ++i) {
                    nArray[i] = (Integer)objectArray[i];
                }
            } else if (objectArray[0] instanceof Long) {
                for (int i = 0; i < objectArray.length; ++i) {
                    nArray[i] = ((Long)objectArray[i]).intValue();
                }
            } else if (objectArray[0] instanceof Float) {
                for (int i = 0; i < objectArray.length; ++i) {
                    nArray[i] = ((Float)objectArray[i]).intValue();
                }
            } else if (objectArray[0] instanceof Boolean) {
                for (int i = 0; i < objectArray.length; ++i) {
                    nArray[i] = (Boolean)objectArray[i] != false ? 1 : 0;
                }
            } else if (objectArray[0] instanceof Double) {
                for (int i = 0; i < objectArray.length; ++i) {
                    nArray[i] = ((Double)objectArray[i]).intValue();
                }
            } else if (objectArray[0] instanceof Byte) {
                for (int i = 0; i < objectArray.length; ++i) {
                    nArray[i] = ((Byte)objectArray[i]).intValue();
                }
            } else if (objectArray[0] instanceof DevState) {
                for (int i = 0; i < objectArray.length; ++i) {
                    nArray[i] = ((DevState)objectArray[i]).value();
                }
            } else {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + objectArray[0].getClass() + " not supported", "CommandHelper.extractToIntegerArray(Object value,deviceDataArgin)");
            }
        }
        return nArray;
    }

    public static long[] extractToLongArray(DeviceData deviceData) throws DevFailed {
        Object[] objectArray = CommandHelper.extractArray(deviceData);
        if (objectArray == null) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output is empty ", "CommandHelper.extractToLongArray(deviceDataArgin)");
        }
        long[] lArray = new long[objectArray.length];
        if (objectArray.length > 0) {
            if (objectArray[0] instanceof Short) {
                for (int i = 0; i < objectArray.length; ++i) {
                    lArray[i] = ((Short)objectArray[i]).longValue();
                }
            } else if (objectArray[0] instanceof String) {
                try {
                    for (int i = 0; i < objectArray.length; ++i) {
                        lArray[i] = Long.valueOf((String)objectArray[i]);
                    }
                }
                catch (Exception exception) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type not numerical", "CommandHelper.extractToLongArray(deviceDataArgin)");
                }
            } else if (objectArray[0] instanceof Integer) {
                for (int i = 0; i < objectArray.length; ++i) {
                    lArray[i] = ((Integer)objectArray[i]).longValue();
                }
            } else if (objectArray[0] instanceof Long) {
                for (int i = 0; i < objectArray.length; ++i) {
                    lArray[i] = (Long)objectArray[i];
                }
            } else if (objectArray[0] instanceof Float) {
                for (int i = 0; i < objectArray.length; ++i) {
                    lArray[i] = ((Float)objectArray[i]).longValue();
                }
            } else if (objectArray[0] instanceof Boolean) {
                for (int i = 0; i < objectArray.length; ++i) {
                    lArray[i] = (Boolean)objectArray[i] != false ? 1L : 0L;
                }
            } else if (objectArray[0] instanceof Double) {
                for (int i = 0; i < objectArray.length; ++i) {
                    lArray[i] = ((Double)objectArray[i]).longValue();
                }
            } else if (objectArray[0] instanceof Byte) {
                for (int i = 0; i < objectArray.length; ++i) {
                    lArray[i] = ((Byte)objectArray[i]).longValue();
                }
            } else if (objectArray[0] instanceof DevState) {
                for (int i = 0; i < objectArray.length; ++i) {
                    lArray[i] = Integer.valueOf(((DevState)objectArray[i]).value()).longValue();
                }
            } else {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + objectArray[0].getClass() + " not supported", "CommandHelper.extractToLongArray(Object value,deviceDataArgin)");
            }
        }
        return lArray;
    }

    public static float[] extractToFloatArray(DeviceData deviceData) throws DevFailed {
        Object[] objectArray = CommandHelper.extractArray(deviceData);
        if (objectArray == null) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output is empty ", "CommandHelper.extractToFloatArray(deviceDataArgin)");
        }
        float[] fArray = new float[objectArray.length];
        if (objectArray.length > 0) {
            if (objectArray[0] instanceof Short) {
                for (int i = 0; i < objectArray.length; ++i) {
                    fArray[i] = ((Short)objectArray[i]).floatValue();
                }
            } else if (objectArray[0] instanceof String) {
                try {
                    for (int i = 0; i < objectArray.length; ++i) {
                        fArray[i] = Float.valueOf((String)objectArray[i]).floatValue();
                    }
                }
                catch (Exception exception) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type not numerical", "CommandHelper.extractToFloatArray(deviceDataArgin)");
                }
            } else if (objectArray[0] instanceof Integer) {
                for (int i = 0; i < objectArray.length; ++i) {
                    fArray[i] = ((Integer)objectArray[i]).floatValue();
                }
            } else if (objectArray[0] instanceof Long) {
                for (int i = 0; i < objectArray.length; ++i) {
                    fArray[i] = ((Long)objectArray[i]).floatValue();
                }
            } else if (objectArray[0] instanceof Float) {
                for (int i = 0; i < objectArray.length; ++i) {
                    fArray[i] = ((Float)objectArray[i]).floatValue();
                }
            } else if (objectArray[0] instanceof Boolean) {
                for (int i = 0; i < objectArray.length; ++i) {
                    fArray[i] = (Boolean)objectArray[i] != false ? 1.0f : 0.0f;
                }
            } else if (objectArray[0] instanceof Double) {
                for (int i = 0; i < objectArray.length; ++i) {
                    fArray[i] = ((Double)objectArray[i]).floatValue();
                }
            } else if (objectArray[0] instanceof Byte) {
                for (int i = 0; i < objectArray.length; ++i) {
                    fArray[i] = ((Byte)objectArray[i]).floatValue();
                }
            } else if (objectArray[0] instanceof DevState) {
                for (int i = 0; i < objectArray.length; ++i) {
                    fArray[i] = Integer.valueOf(((DevState)objectArray[i]).value()).floatValue();
                }
            } else {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + objectArray[0].getClass() + " not supported", "CommandHelper.extractToFloatArray(Object value,deviceDataArgin)");
            }
        }
        return fArray;
    }

    public static boolean[] extractToBooleanArray(DeviceData deviceData) throws DevFailed {
        Object[] objectArray = CommandHelper.extractArray(deviceData);
        if (objectArray == null) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output is empty ", "CommandHelper.extractToBooleanArray(deviceDataArgin)");
        }
        boolean[] blArray = new boolean[objectArray.length];
        if (objectArray.length > 0) {
            if (objectArray[0] instanceof Short) {
                for (int i = 0; i < objectArray.length; ++i) {
                    blArray[i] = ((Short)objectArray[i]).intValue() == 1;
                }
            } else if (objectArray[0] instanceof String) {
                try {
                    for (int i = 0; i < objectArray.length; ++i) {
                        blArray[i] = Boolean.getBoolean((String)objectArray[i]);
                    }
                }
                catch (Exception exception) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type not numerical", "CommandHelper.extractToBooleanArray(deviceDataArgin)");
                }
            } else if (objectArray[0] instanceof Integer) {
                for (int i = 0; i < objectArray.length; ++i) {
                    blArray[i] = (Integer)objectArray[i] == 1;
                }
            } else if (objectArray[0] instanceof Long) {
                for (int i = 0; i < objectArray.length; ++i) {
                    blArray[i] = ((Long)objectArray[i]).intValue() == 1;
                }
            } else if (objectArray[0] instanceof Float) {
                for (int i = 0; i < objectArray.length; ++i) {
                    blArray[i] = ((Float)objectArray[i]).intValue() == 1;
                }
            } else if (objectArray[0] instanceof Boolean) {
                for (int i = 0; i < objectArray.length; ++i) {
                    blArray[i] = (Boolean)objectArray[i];
                }
            } else if (objectArray[0] instanceof Double) {
                for (int i = 0; i < objectArray.length; ++i) {
                    blArray[i] = ((Double)objectArray[i]).intValue() == 1;
                }
            } else if (objectArray[0] instanceof Byte) {
                for (int i = 0; i < objectArray.length; ++i) {
                    blArray[i] = ((Byte)objectArray[i]).intValue() == 1;
                }
            } else if (objectArray[0] instanceof DevState) {
                for (int i = 0; i < objectArray.length; ++i) {
                    blArray[i] = ((DevState)objectArray[i]).value() == 1;
                }
            } else {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + objectArray[0].getClass() + " not supported", "CommandHelper.extractToBooleanArray(Object value,deviceDataArgin)");
            }
        }
        return blArray;
    }

    public static byte[] extractToByteArray(DeviceData deviceData) throws DevFailed {
        Object[] objectArray = CommandHelper.extractArray(deviceData);
        if (objectArray == null) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output is empty ", "CommandHelper.extractToFloatArray(deviceDataArgin)");
        }
        byte[] byArray = new byte[objectArray.length];
        if (objectArray.length > 0) {
            if (objectArray[0] instanceof Short) {
                for (int i = 0; i < objectArray.length; ++i) {
                    byArray[i] = ((Short)objectArray[i]).byteValue();
                }
            } else if (objectArray[0] instanceof String) {
                try {
                    for (int i = 0; i < objectArray.length; ++i) {
                        byArray[i] = Float.valueOf((String)objectArray[i]).byteValue();
                    }
                }
                catch (Exception exception) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type not numerical", "CommandHelper.extractToFloatArray(deviceDataArgin)");
                }
            } else if (objectArray[0] instanceof Integer) {
                for (int i = 0; i < objectArray.length; ++i) {
                    byArray[i] = ((Integer)objectArray[i]).byteValue();
                }
            } else if (objectArray[0] instanceof Long) {
                for (int i = 0; i < objectArray.length; ++i) {
                    byArray[i] = ((Long)objectArray[i]).byteValue();
                }
            } else if (objectArray[0] instanceof Float) {
                for (int i = 0; i < objectArray.length; ++i) {
                    byArray[i] = ((Float)objectArray[i]).byteValue();
                }
            } else if (objectArray[0] instanceof Boolean) {
                for (int i = 0; i < objectArray.length; ++i) {
                    byArray[i] = (Boolean)objectArray[i] != false ? (byte)1 : 0;
                }
            } else if (objectArray[0] instanceof Double) {
                for (int i = 0; i < objectArray.length; ++i) {
                    byArray[i] = ((Double)objectArray[i]).byteValue();
                }
            } else if (objectArray[0] instanceof Byte) {
                for (int i = 0; i < objectArray.length; ++i) {
                    byArray[i] = (Byte)objectArray[i];
                }
            } else if (objectArray[0] instanceof DevState) {
                for (int i = 0; i < objectArray.length; ++i) {
                    byArray[i] = Integer.valueOf(((DevState)objectArray[i]).value()).byteValue();
                }
            } else {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + objectArray[0].getClass() + " not supported", "CommandHelper.extractToFloatArray(Object value,deviceDataArgin)");
            }
        }
        return byArray;
    }

    public static double[] extractToDoubleArray(DeviceData deviceData) throws DevFailed {
        Object[] objectArray = CommandHelper.extractArray(deviceData);
        if (objectArray == null) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output is empty ", "CommandHelper.extractToDoubleArray(deviceDataArgin)");
        }
        double[] dArray = new double[objectArray.length];
        if (objectArray.length > 0) {
            if (objectArray[0] instanceof Short) {
                for (int i = 0; i < objectArray.length; ++i) {
                    dArray[i] = ((Short)objectArray[i]).doubleValue();
                }
            } else if (objectArray[0] instanceof String) {
                try {
                    for (int i = 0; i < objectArray.length; ++i) {
                        dArray[i] = Double.valueOf((String)objectArray[i]);
                    }
                }
                catch (Exception exception) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type not numerical", "CommandHelper.extractToDoubleArray(deviceDataArgin)");
                }
            } else if (objectArray[0] instanceof Integer) {
                for (int i = 0; i < objectArray.length; ++i) {
                    dArray[i] = ((Integer)objectArray[i]).doubleValue();
                }
            } else if (objectArray[0] instanceof Long) {
                for (int i = 0; i < objectArray.length; ++i) {
                    dArray[i] = ((Long)objectArray[i]).doubleValue();
                }
            } else if (objectArray[0] instanceof Float) {
                for (int i = 0; i < objectArray.length; ++i) {
                    dArray[i] = ((Float)objectArray[i]).doubleValue();
                }
            } else if (objectArray[0] instanceof Boolean) {
                for (int i = 0; i < objectArray.length; ++i) {
                    dArray[i] = (Boolean)objectArray[i] != false ? 1.0 : 0.0;
                }
            } else if (objectArray[0] instanceof Double) {
                for (int i = 0; i < objectArray.length; ++i) {
                    dArray[i] = (Double)objectArray[i];
                }
            } else if (objectArray[0] instanceof Byte) {
                for (int i = 0; i < objectArray.length; ++i) {
                    dArray[i] = ((Byte)objectArray[i]).doubleValue();
                }
            } else if (objectArray[0] instanceof DevState) {
                for (int i = 0; i < objectArray.length; ++i) {
                    dArray[i] = Integer.valueOf(((DevState)objectArray[i]).value()).doubleValue();
                }
            } else {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + objectArray[0].getClass() + " not supported", "CommandHelper.extractToDoubleArray(Object value,deviceDataArgin)");
            }
        }
        return dArray;
    }

    public static DevState[] extractToDevStateArray(DeviceData deviceData) throws DevFailed {
        Object[] objectArray = CommandHelper.extractArray(deviceData);
        if (objectArray == null) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output is empty ", "CommandHelper.extractToFloatArray(deviceDataArgin)");
        }
        DevState[] devStateArray = new DevState[objectArray.length];
        if (objectArray.length > 0) {
            if (objectArray[0] instanceof Short) {
                for (int i = 0; i < objectArray.length; ++i) {
                    try {
                        devStateArray[i] = DevState.from_int(((Short)objectArray[i]).intValue());
                        continue;
                    }
                    catch (Exception exception) {
                        devStateArray[i] = DevState.UNKNOWN;
                    }
                }
            } else if (objectArray[0] instanceof String) {
                for (int i = 0; i < objectArray.length; ++i) {
                    devStateArray[i] = StateUtilities.getStateForName((String)objectArray[i]);
                }
            } else if (objectArray[0] instanceof Integer) {
                for (int i = 0; i < objectArray.length; ++i) {
                    try {
                        devStateArray[i] = DevState.from_int((Integer)objectArray[i]);
                        continue;
                    }
                    catch (Exception exception) {
                        devStateArray[i] = DevState.UNKNOWN;
                    }
                }
            } else if (objectArray[0] instanceof Long) {
                for (int i = 0; i < objectArray.length; ++i) {
                    try {
                        devStateArray[i] = DevState.from_int(((Long)objectArray[i]).intValue());
                        continue;
                    }
                    catch (Exception exception) {
                        devStateArray[i] = DevState.UNKNOWN;
                    }
                }
            } else if (objectArray[0] instanceof Float) {
                for (int i = 0; i < objectArray.length; ++i) {
                    try {
                        devStateArray[i] = DevState.from_int(((Float)objectArray[i]).intValue());
                        continue;
                    }
                    catch (Exception exception) {
                        devStateArray[i] = DevState.UNKNOWN;
                    }
                }
            } else if (objectArray[0] instanceof Boolean) {
                for (int i = 0; i < objectArray.length; ++i) {
                    try {
                        if (((Boolean)objectArray[i]).booleanValue()) {
                            devStateArray[i] = DevState.from_int(1);
                            continue;
                        }
                        devStateArray[i] = DevState.from_int(0);
                        continue;
                    }
                    catch (Exception exception) {
                        devStateArray[i] = DevState.UNKNOWN;
                    }
                }
            } else if (objectArray[0] instanceof Double) {
                for (int i = 0; i < objectArray.length; ++i) {
                    try {
                        devStateArray[i] = DevState.from_int(((Double)objectArray[i]).intValue());
                        continue;
                    }
                    catch (Exception exception) {
                        devStateArray[i] = DevState.UNKNOWN;
                    }
                }
            } else if (objectArray[0] instanceof Byte) {
                for (int i = 0; i < objectArray.length; ++i) {
                    try {
                        devStateArray[i] = DevState.from_int(((Byte)objectArray[i]).intValue());
                        continue;
                    }
                    catch (Exception exception) {
                        devStateArray[i] = DevState.UNKNOWN;
                    }
                }
            } else if (objectArray[0] instanceof DevState) {
                for (int i = 0; i < objectArray.length; ++i) {
                    devStateArray[i] = (DevState)objectArray[i];
                }
            } else {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + objectArray[0].getClass() + " not supported", "CommandHelper.extractToFloatArray(Object value,deviceDataArgin)");
            }
        }
        return devStateArray;
    }

    public static void insertFromShortArray(short[] sArray, DeviceData deviceData, int n) throws DevFailed {
        Double d = new Double(0.0);
        for (int i = 0; i < sArray.length; ++i) {
            d = d + (double)sArray[i];
        }
        switch (n) {
            case 2: {
                deviceData.insert(d.shortValue());
                break;
            }
            case 6: {
                deviceData.insert_us(d.intValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "CommandHelper.insertFromShortArray(short[] values,deviceDataArgin)");
                break;
            }
            case 22: {
                deviceData.insert(d.shortValue());
                break;
            }
            case 3: {
                deviceData.insert(d.intValue());
                break;
            }
            case 7: {
                deviceData.insert_ul(d.longValue());
                break;
            }
            case 23: {
                deviceData.insert(d.intValue());
                break;
            }
            case 24: {
                deviceData.insert_u64(d.longValue());
                break;
            }
            case 27: {
                deviceData.insert(d.intValue());
                break;
            }
            case 4: {
                deviceData.insert(d.floatValue());
                break;
            }
            case 5: {
                deviceData.insert(d);
                break;
            }
            case 8: {
                deviceData.insert(d.toString());
                break;
            }
            case 1: {
                if (d == 1.0) {
                    deviceData.insert(true);
                    break;
                }
                deviceData.insert(false);
                break;
            }
            case 19: {
                DevState devState = DevState.UNKNOWN;
                if (sArray.length > 0) {
                    try {
                        devState = DevState.from_int(Short.valueOf(sArray[0]).intValue());
                    }
                    catch (BAD_PARAM bAD_PARAM) {
                        devState = DevState.UNKNOWN;
                    }
                }
                deviceData.insert(devState);
                break;
            }
            case 10: {
                deviceData.insert(sArray);
                break;
            }
            case 14: {
                deviceData.insert_us(sArray);
                break;
            }
            case 9: {
                byte[] byArray = new byte[sArray.length];
                for (int i = 0; i < sArray.length; ++i) {
                    byArray[i] = Short.valueOf(sArray[i]).byteValue();
                }
                deviceData.insert(byArray);
                break;
            }
            case 11: {
                int[] nArray = new int[sArray.length];
                for (int i = 0; i < sArray.length; ++i) {
                    nArray[i] = Short.valueOf(sArray[i]).intValue();
                }
                deviceData.insert(nArray);
                break;
            }
            case 15: {
                long[] lArray = new long[sArray.length];
                for (int i = 0; i < sArray.length; ++i) {
                    lArray[i] = Short.valueOf(sArray[i]).longValue();
                }
                deviceData.insert_ul(lArray);
                break;
            }
            case 25: {
                int[] nArray = new int[sArray.length];
                for (int i = 0; i < sArray.length; ++i) {
                    nArray[i] = Short.valueOf(sArray[i]).intValue();
                }
                deviceData.insert(nArray);
                break;
            }
            case 26: {
                long[] lArray = new long[sArray.length];
                for (int i = 0; i < sArray.length; ++i) {
                    lArray[i] = Short.valueOf(sArray[i]).longValue();
                }
                deviceData.insert_u64(lArray);
                break;
            }
            case 12: {
                float[] fArray = new float[sArray.length];
                for (int i = 0; i < sArray.length; ++i) {
                    fArray[i] = Short.valueOf(sArray[i]).floatValue();
                }
                deviceData.insert(fArray);
                break;
            }
            case 13: {
                double[] dArray = new double[sArray.length];
                for (int i = 0; i < sArray.length; ++i) {
                    dArray[i] = Short.valueOf(sArray[i]).doubleValue();
                }
                deviceData.insert(dArray);
                break;
            }
            case 16: {
                String[] stringArray = new String[sArray.length];
                for (int i = 0; i < sArray.length; ++i) {
                    stringArray[i] = Short.valueOf(sArray[i]).toString();
                }
                deviceData.insert(stringArray);
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceData.getType() + " not supported", "CommandHelper.insertFromShortArray(short[] values,deviceDataArgin)");
            }
        }
    }

    public static void insertFromStringArray(String[] stringArray, DeviceData deviceData, int n) throws DevFailed {
        String string = "";
        Double d = Double.NaN;
        try {
            d = Double.valueOf(string);
        }
        catch (Exception exception) {
            d = Double.NaN;
        }
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        switch (n) {
            case 2: {
                if (!d.isNaN()) {
                    deviceData.insert(d.shortValue());
                    break;
                }
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", string + " is not a Tango_DEV_SHORT", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                break;
            }
            case 6: {
                if (!d.isNaN()) {
                    deviceData.insert_us(d.shortValue());
                    break;
                }
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", string + " is not a Tango_DEV_USHORT", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                break;
            }
            case 21: {
                deviceData.insert(d.byteValue());
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                break;
            }
            case 22: {
                if (!d.isNaN()) {
                    deviceData.insert(d.shortValue());
                    break;
                }
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", string + " is not a Tango_DEV_UCHAR", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                break;
            }
            case 3: {
                if (!d.isNaN()) {
                    deviceData.insert(d.intValue());
                    break;
                }
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", string + " is not a Tango_DEV_LONG", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                break;
            }
            case 7: {
                if (!d.isNaN()) {
                    deviceData.insert_ul(d.longValue());
                    break;
                }
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", string + " is not a Tango_DEV_ULONG", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                break;
            }
            case 23: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_LONG64 not supported", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                break;
            }
            case 24: {
                if (!d.isNaN()) {
                    deviceData.insert_u64(d.longValue());
                    break;
                }
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", string + " is not a Tango_DEV_ULONG64", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                break;
            }
            case 27: {
                if (!d.isNaN()) {
                    deviceData.insert(d.intValue());
                    break;
                }
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", string + " is not a Tango_DEV_INT", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                break;
            }
            case 4: {
                if (!d.isNaN()) {
                    deviceData.insert(d.floatValue());
                    break;
                }
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", string + " is not a Tango_DEV_FLOAT", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                break;
            }
            case 5: {
                if (!d.isNaN()) {
                    deviceData.insert(d);
                    break;
                }
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", string + " is not a Tango_DEV_DOUBLE", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                break;
            }
            case 8: {
                deviceData.insert(string);
                break;
            }
            case 1: {
                if (!d.isNaN()) {
                    if (d == 1.0) {
                        deviceData.insert(true);
                        break;
                    }
                    deviceData.insert(false);
                    break;
                }
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", string + " is not a Tango_DEV_BOOLEAN", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                break;
            }
            case 19: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "Tango_DEV_STATE is not supported", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                break;
            }
            case 10: {
                short[] sArray = new short[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        sArray[i] = Double.valueOf(stringArray[i]).shortValue();
                        continue;
                    }
                    catch (Exception exception) {
                        Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input is not a Tango_DEVVAR_SHORTARRAY", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                    }
                }
                deviceData.insert(sArray);
                break;
            }
            case 14: {
                short[] sArray = new short[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        sArray[i] = Double.valueOf(stringArray[i]).shortValue();
                        continue;
                    }
                    catch (Exception exception) {
                        Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input is not a Tango_DEVVAR_USHORTARRAY", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                    }
                }
                deviceData.insert_us(sArray);
                break;
            }
            case 9: {
                byte[] byArray = new byte[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        byArray[i] = Double.valueOf(stringArray[i]).byteValue();
                        continue;
                    }
                    catch (Exception exception) {
                        Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input is not a Tango_DEVVAR_CHARARRAY", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                    }
                }
                deviceData.insert(byArray);
                break;
            }
            case 11: {
                int[] nArray = new int[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        nArray[i] = Double.valueOf(stringArray[i]).intValue();
                        continue;
                    }
                    catch (Exception exception) {
                        Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input is not a Tango_DEVVAR_LONGARRAY", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                    }
                }
                deviceData.insert(nArray);
                break;
            }
            case 15: {
                long[] lArray = new long[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        lArray[i] = Double.valueOf(stringArray[i]).longValue();
                        continue;
                    }
                    catch (Exception exception) {
                        Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input is not a Tango_DEVVAR_LONGARRAY", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                    }
                }
                deviceData.insert_ul(lArray);
                break;
            }
            case 25: {
                int[] nArray = new int[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        nArray[i] = Double.valueOf(stringArray[i]).intValue();
                        continue;
                    }
                    catch (Exception exception) {
                        Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input is not a Tango_DEVVAR_LONGARRAY", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                    }
                }
                deviceData.insert(nArray);
                break;
            }
            case 26: {
                long[] lArray = new long[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        lArray[i] = Double.valueOf(stringArray[i]).longValue();
                        continue;
                    }
                    catch (Exception exception) {
                        Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input is not a Tango_DEVVAR_LONGARRAY", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                    }
                }
                deviceData.insert_u64(lArray);
                break;
            }
            case 12: {
                float[] fArray = new float[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        fArray[i] = Double.valueOf(stringArray[i]).floatValue();
                        continue;
                    }
                    catch (Exception exception) {
                        Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input is not a Tango_DEVVAR_FLOATARRAY", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                    }
                }
                deviceData.insert(fArray);
                break;
            }
            case 13: {
                double[] dArray = new double[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        dArray[i] = Double.valueOf(stringArray[i]);
                        continue;
                    }
                    catch (Exception exception) {
                        Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input is not a Tango_DEVVAR_DOUBLEARRAY", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                    }
                }
                deviceData.insert(dArray);
                break;
            }
            case 16: {
                deviceData.insert(stringArray);
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceData.getType() + " not supported", "CommandHelper.insertFromStringArray(String[] value,deviceDataArgin)");
            }
        }
    }

    public static void insertFromIntegerArray(int[] nArray, DeviceData deviceData, int n) throws DevFailed {
        Double d = new Double(0.0);
        for (int i = 0; i < nArray.length; ++i) {
            d = d + (double)nArray[i];
        }
        switch (n) {
            case 2: {
                deviceData.insert(d.shortValue());
                break;
            }
            case 6: {
                deviceData.insert_us(d.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "CommandHelper.insertFromIntegerArray(int[] values,deviceDataArgin)");
                break;
            }
            case 22: {
                deviceData.insert(d.shortValue());
                break;
            }
            case 3: {
                deviceData.insert(d.intValue());
                break;
            }
            case 7: {
                deviceData.insert_ul(d.longValue());
                break;
            }
            case 23: {
                deviceData.insert(d.intValue());
                break;
            }
            case 24: {
                deviceData.insert_u64(d.longValue());
                break;
            }
            case 27: {
                deviceData.insert(d.intValue());
                break;
            }
            case 4: {
                deviceData.insert(d.floatValue());
                break;
            }
            case 5: {
                deviceData.insert(d);
                break;
            }
            case 8: {
                deviceData.insert(d.toString());
                break;
            }
            case 1: {
                if (d == 1.0) {
                    deviceData.insert(true);
                    break;
                }
                deviceData.insert(false);
                break;
            }
            case 19: {
                DevState devState = DevState.UNKNOWN;
                if (nArray.length > 0) {
                    try {
                        devState = DevState.from_int(nArray[0]);
                    }
                    catch (BAD_PARAM bAD_PARAM) {
                        devState = DevState.UNKNOWN;
                    }
                }
                deviceData.insert(devState);
                break;
            }
            case 10: {
                short[] sArray = new short[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    sArray[i] = Integer.valueOf(nArray[i]).shortValue();
                }
                deviceData.insert(sArray);
                break;
            }
            case 14: {
                short[] sArray = new short[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    sArray[i] = Integer.valueOf(nArray[i]).shortValue();
                }
                deviceData.insert_us(sArray);
                break;
            }
            case 9: {
                byte[] byArray = new byte[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    byArray[i] = Integer.valueOf(nArray[i]).byteValue();
                }
                deviceData.insert(byArray);
                break;
            }
            case 11: {
                deviceData.insert(nArray);
                break;
            }
            case 15: {
                long[] lArray = new long[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    lArray[i] = Integer.valueOf(nArray[i]).longValue();
                }
                deviceData.insert_ul(lArray);
                break;
            }
            case 25: {
                int[] nArray2 = new int[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray2[i] = nArray[i];
                }
                deviceData.insert_ul(nArray2);
                break;
            }
            case 26: {
                long[] lArray = new long[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    lArray[i] = Integer.valueOf(nArray[i]).longValue();
                }
                deviceData.insert_u64(lArray);
                break;
            }
            case 12: {
                float[] fArray = new float[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    fArray[i] = Integer.valueOf(nArray[i]).floatValue();
                }
                deviceData.insert(fArray);
                break;
            }
            case 13: {
                double[] dArray = new double[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    dArray[i] = Integer.valueOf(nArray[i]).doubleValue();
                }
                deviceData.insert(dArray);
                break;
            }
            case 16: {
                String[] stringArray = new String[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    stringArray[i] = Integer.valueOf(nArray[i]).toString();
                }
                deviceData.insert(stringArray);
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceData.getType() + " not supported", "CommandHelper.insertFromIntegerArray(int[] values,deviceDataArgin)");
            }
        }
    }

    public static void insertFromLongArray(long[] lArray, DeviceData deviceData, int n) throws DevFailed {
        Double d = new Double(0.0);
        for (int i = 0; i < lArray.length; ++i) {
            d = d + (double)lArray[i];
        }
        switch (n) {
            case 2: {
                deviceData.insert(d.shortValue());
                break;
            }
            case 6: {
                deviceData.insert_us(d.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "CommandHelper.insertFromLongArray(long[] values,deviceDataArgin)");
                break;
            }
            case 22: {
                deviceData.insert(d.shortValue());
                break;
            }
            case 3: {
                deviceData.insert(d.intValue());
                break;
            }
            case 7: {
                deviceData.insert_ul(d.longValue());
                break;
            }
            case 23: {
                deviceData.insert(d.intValue());
                break;
            }
            case 24: {
                deviceData.insert_u64(d.longValue());
                break;
            }
            case 27: {
                deviceData.insert(d.intValue());
                break;
            }
            case 4: {
                deviceData.insert(d.floatValue());
                break;
            }
            case 5: {
                deviceData.insert(d);
                break;
            }
            case 8: {
                deviceData.insert(d.toString());
                break;
            }
            case 1: {
                if (d == 1.0) {
                    deviceData.insert(true);
                    break;
                }
                deviceData.insert(false);
                break;
            }
            case 19: {
                DevState devState = DevState.UNKNOWN;
                if (lArray.length > 0) {
                    try {
                        devState = DevState.from_int(Long.valueOf(lArray[0]).intValue());
                    }
                    catch (BAD_PARAM bAD_PARAM) {
                        devState = DevState.UNKNOWN;
                    }
                }
                deviceData.insert(devState);
                break;
            }
            case 10: {
                short[] sArray = new short[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    sArray[i] = Long.valueOf(lArray[i]).shortValue();
                }
                deviceData.insert(sArray);
                break;
            }
            case 14: {
                short[] sArray = new short[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    sArray[i] = Long.valueOf(lArray[i]).shortValue();
                }
                deviceData.insert_us(sArray);
                break;
            }
            case 9: {
                byte[] byArray = new byte[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    byArray[i] = Long.valueOf(lArray[i]).byteValue();
                }
                deviceData.insert(byArray);
                break;
            }
            case 11: {
                int[] nArray = new int[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    nArray[i] = Long.valueOf(lArray[i]).intValue();
                }
                deviceData.insert(nArray);
                break;
            }
            case 15: {
                deviceData.insert_ul(lArray);
                break;
            }
            case 25: {
                int[] nArray = new int[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    nArray[i] = Long.valueOf(lArray[i]).intValue();
                }
                deviceData.insert(nArray);
                break;
            }
            case 26: {
                deviceData.insert_u64(lArray);
                break;
            }
            case 12: {
                float[] fArray = new float[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    fArray[i] = Long.valueOf(lArray[i]).floatValue();
                }
                deviceData.insert(fArray);
                break;
            }
            case 13: {
                double[] dArray = new double[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    dArray[i] = Long.valueOf(lArray[i]).doubleValue();
                }
                deviceData.insert(dArray);
                break;
            }
            case 16: {
                String[] stringArray = new String[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    stringArray[i] = Long.valueOf(lArray[i]).toString();
                }
                deviceData.insert(stringArray);
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceData.getType() + " not supported", "CommandHelper.insertFromLongArray(long[] values,deviceDataArgin)");
            }
        }
    }

    public static void insertFromFloatArray(float[] fArray, DeviceData deviceData, int n) throws DevFailed {
        Double d = new Double(0.0);
        for (int i = 0; i < fArray.length; ++i) {
            d = d + (double)fArray[i];
        }
        switch (n) {
            case 2: {
                deviceData.insert(d.shortValue());
                break;
            }
            case 6: {
                deviceData.insert_us(d.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "CommandHelper.insertFromFloatArray(float[] values,deviceDataArgin)");
                break;
            }
            case 22: {
                deviceData.insert(d.shortValue());
                break;
            }
            case 3: {
                deviceData.insert(d.intValue());
                break;
            }
            case 7: {
                deviceData.insert_ul(d.longValue());
                break;
            }
            case 23: {
                deviceData.insert_ul(d.intValue());
                break;
            }
            case 24: {
                deviceData.insert_u64(d.longValue());
                break;
            }
            case 27: {
                deviceData.insert(d.intValue());
                break;
            }
            case 4: {
                deviceData.insert(d.floatValue());
                break;
            }
            case 5: {
                deviceData.insert(d);
                break;
            }
            case 8: {
                deviceData.insert(d.toString());
                break;
            }
            case 1: {
                if (d == 1.0) {
                    deviceData.insert(true);
                    break;
                }
                deviceData.insert(false);
                break;
            }
            case 19: {
                DevState devState = DevState.UNKNOWN;
                if (fArray.length > 0) {
                    try {
                        devState = DevState.from_int(Float.valueOf(fArray[0]).intValue());
                    }
                    catch (BAD_PARAM bAD_PARAM) {
                        devState = DevState.UNKNOWN;
                    }
                }
                deviceData.insert(devState);
                break;
            }
            case 10: {
                short[] sArray = new short[fArray.length];
                for (int i = 0; i < fArray.length; ++i) {
                    sArray[i] = Float.valueOf(fArray[i]).shortValue();
                }
                deviceData.insert(sArray);
                break;
            }
            case 14: {
                short[] sArray = new short[fArray.length];
                for (int i = 0; i < fArray.length; ++i) {
                    sArray[i] = Float.valueOf(fArray[i]).shortValue();
                }
                deviceData.insert(sArray);
                break;
            }
            case 9: {
                byte[] byArray = new byte[fArray.length];
                for (int i = 0; i < fArray.length; ++i) {
                    byArray[i] = Float.valueOf(fArray[i]).byteValue();
                }
                deviceData.insert(byArray);
                break;
            }
            case 11: {
                int[] nArray = new int[fArray.length];
                for (int i = 0; i < fArray.length; ++i) {
                    nArray[i] = Float.valueOf(fArray[i]).intValue();
                }
                deviceData.insert(nArray);
                break;
            }
            case 15: {
                long[] lArray = new long[fArray.length];
                for (int i = 0; i < fArray.length; ++i) {
                    lArray[i] = Float.valueOf(fArray[i]).longValue();
                }
                deviceData.insert_ul(lArray);
                break;
            }
            case 25: {
                int[] nArray = new int[fArray.length];
                for (int i = 0; i < fArray.length; ++i) {
                    nArray[i] = Float.valueOf(fArray[i]).intValue();
                }
                deviceData.insert(nArray);
                break;
            }
            case 26: {
                long[] lArray = new long[fArray.length];
                for (int i = 0; i < fArray.length; ++i) {
                    lArray[i] = Float.valueOf(fArray[i]).longValue();
                }
                deviceData.insert_u64(lArray);
                break;
            }
            case 12: {
                deviceData.insert(fArray);
                break;
            }
            case 13: {
                double[] dArray = new double[fArray.length];
                for (int i = 0; i < fArray.length; ++i) {
                    dArray[i] = Float.valueOf(fArray[i]).doubleValue();
                }
                deviceData.insert(dArray);
                break;
            }
            case 16: {
                String[] stringArray = new String[fArray.length];
                for (int i = 0; i < fArray.length; ++i) {
                    stringArray[i] = Float.valueOf(fArray[i]).toString();
                }
                deviceData.insert(stringArray);
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceData.getType() + " not supported", "insertFromFloatArray.insertFromLongArray(float[] values,deviceDataArgin)");
            }
        }
    }

    public static void insertFromBooleanArray(boolean[] blArray, DeviceData deviceData, int n) throws DevFailed {
        boolean bl = false;
        if (blArray.length > 0) {
            bl = blArray[0];
        }
        Integer n2 = new Integer(0);
        if (bl) {
            n2 = new Integer(1);
        }
        switch (n) {
            case 2: {
                deviceData.insert(n2.shortValue());
                break;
            }
            case 6: {
                deviceData.insert_us(n2.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "CommandHelper.insertFromBooleanArray(boolean[] values,deviceDataArgin)");
                break;
            }
            case 22: {
                deviceData.insert(n2.shortValue());
                break;
            }
            case 3: {
                deviceData.insert(n2);
                break;
            }
            case 7: {
                deviceData.insert_ul(n2.longValue());
                break;
            }
            case 23: {
                deviceData.insert(n2);
                break;
            }
            case 24: {
                deviceData.insert_u64(n2.longValue());
                break;
            }
            case 27: {
                deviceData.insert(n2);
                break;
            }
            case 4: {
                deviceData.insert(n2.floatValue());
                break;
            }
            case 5: {
                deviceData.insert(n2.doubleValue());
                break;
            }
            case 8: {
                deviceData.insert(n2.toString());
                break;
            }
            case 1: {
                deviceData.insert(bl);
                break;
            }
            case 19: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_STATE not supported", "CommandHelper.insertFromBooleanArray(boolean[] values,deviceDataArgin)");
                break;
            }
            case 10: {
                short[] sArray = new short[blArray.length];
                for (int i = 0; i < blArray.length; ++i) {
                    sArray[i] = blArray[i] ? (short)1 : 0;
                }
                deviceData.insert(sArray);
                break;
            }
            case 14: {
                short[] sArray = new short[blArray.length];
                for (int i = 0; i < blArray.length; ++i) {
                    sArray[i] = blArray[i] ? (short)1 : 0;
                }
                deviceData.insert(sArray);
                break;
            }
            case 9: {
                byte[] byArray = new byte[blArray.length];
                for (int i = 0; i < blArray.length; ++i) {
                    byArray[i] = blArray[i] ? Short.valueOf((short)1).byteValue() : Short.valueOf((short)0).byteValue();
                }
                deviceData.insert(byArray);
                break;
            }
            case 11: {
                int[] nArray = new int[blArray.length];
                for (int i = 0; i < blArray.length; ++i) {
                    nArray[i] = blArray[i] ? 1 : 0;
                }
                deviceData.insert(nArray);
                break;
            }
            case 15: {
                long[] lArray = new long[blArray.length];
                for (int i = 0; i < blArray.length; ++i) {
                    lArray[i] = blArray[i] ? 1L : 0L;
                }
                deviceData.insert_ul(lArray);
                break;
            }
            case 25: {
                int[] nArray = new int[blArray.length];
                for (int i = 0; i < blArray.length; ++i) {
                    nArray[i] = blArray[i] ? 1 : 0;
                }
                deviceData.insert(nArray);
                break;
            }
            case 26: {
                long[] lArray = new long[blArray.length];
                for (int i = 0; i < blArray.length; ++i) {
                    lArray[i] = blArray[i] ? 1L : 0L;
                }
                deviceData.insert_u64(lArray);
                break;
            }
            case 12: {
                float[] fArray = new float[blArray.length];
                for (int i = 0; i < blArray.length; ++i) {
                    fArray[i] = blArray[i] ? 1.0f : 0.0f;
                }
                deviceData.insert(fArray);
                break;
            }
            case 13: {
                double[] dArray = new double[blArray.length];
                for (int i = 0; i < blArray.length; ++i) {
                    dArray[i] = blArray[i] ? 1.0 : 0.0;
                }
                deviceData.insert(dArray);
                break;
            }
            case 16: {
                String[] stringArray = new String[blArray.length];
                for (int i = 0; i < blArray.length; ++i) {
                    stringArray[i] = Boolean.valueOf(blArray[i]).toString();
                }
                deviceData.insert(stringArray);
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceData.getType() + " not supported", "insertFromBooleanArray.insertFromLongArray(boolean[] values,deviceDataArgin)");
            }
        }
    }

    public static void insertFromDoubleArray(double[] dArray, DeviceData deviceData, int n) throws DevFailed {
        Double d = new Double(0.0);
        for (int i = 0; i < dArray.length; ++i) {
            d = d + dArray[i];
        }
        switch (n) {
            case 2: {
                deviceData.insert(d.shortValue());
                break;
            }
            case 6: {
                deviceData.insert_us(d.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "CommandHelper.insertFromDoubleArray(double[] values,deviceDataArgin)");
                break;
            }
            case 22: {
                deviceData.insert(d.shortValue());
                break;
            }
            case 3: {
                deviceData.insert(d.intValue());
                break;
            }
            case 7: {
                deviceData.insert_ul(d.longValue());
                break;
            }
            case 23: {
                deviceData.insert(d.intValue());
                break;
            }
            case 24: {
                deviceData.insert_u64(d.longValue());
                break;
            }
            case 27: {
                deviceData.insert(d.intValue());
                break;
            }
            case 4: {
                deviceData.insert(d.floatValue());
                break;
            }
            case 5: {
                deviceData.insert(d);
                break;
            }
            case 8: {
                deviceData.insert(d.toString());
                break;
            }
            case 1: {
                if (d == 1.0) {
                    deviceData.insert(true);
                    break;
                }
                deviceData.insert(false);
                break;
            }
            case 19: {
                DevState devState = DevState.UNKNOWN;
                if (dArray.length > 0) {
                    try {
                        devState = DevState.from_int(Double.valueOf(dArray[0]).intValue());
                    }
                    catch (BAD_PARAM bAD_PARAM) {
                        devState = DevState.UNKNOWN;
                    }
                }
                deviceData.insert(devState);
                break;
            }
            case 10: {
                short[] sArray = new short[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    sArray[i] = Double.valueOf(dArray[i]).shortValue();
                }
                deviceData.insert(sArray);
                break;
            }
            case 14: {
                short[] sArray = new short[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    sArray[i] = Double.valueOf(dArray[i]).shortValue();
                }
                deviceData.insert_us(sArray);
                break;
            }
            case 9: {
                byte[] byArray = new byte[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    byArray[i] = Double.valueOf(dArray[i]).byteValue();
                }
                deviceData.insert(byArray);
                break;
            }
            case 11: {
                int[] nArray = new int[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    nArray[i] = Double.valueOf(dArray[i]).intValue();
                }
                deviceData.insert(nArray);
                break;
            }
            case 15: {
                long[] lArray = new long[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    lArray[i] = Double.valueOf(dArray[i]).longValue();
                }
                deviceData.insert_ul(lArray);
                break;
            }
            case 25: {
                int[] nArray = new int[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    nArray[i] = Double.valueOf(dArray[i]).intValue();
                }
                deviceData.insert(nArray);
                break;
            }
            case 26: {
                long[] lArray = new long[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    lArray[i] = Double.valueOf(dArray[i]).longValue();
                }
                deviceData.insert_u64(lArray);
                break;
            }
            case 12: {
                float[] fArray = new float[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    fArray[i] = Double.valueOf(dArray[i]).floatValue();
                }
                deviceData.insert(fArray);
                break;
            }
            case 13: {
                deviceData.insert(dArray);
                break;
            }
            case 16: {
                String[] stringArray = new String[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    stringArray[i] = Double.valueOf(dArray[i]).toString();
                }
                deviceData.insert(stringArray);
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceData.getType() + " not supported", "insertFromFloatArray.insertFromDoubleArray(double[] values,deviceDataArgin)");
            }
        }
    }

    public static void insertFromString(String string, DeviceData deviceData, int n) throws DevFailed {
        Double d = Double.NaN;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = Double.NaN;
        }
        if (d.isNaN() && n != 8) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "Cannot insert " + string + " as a numerical value.", "CommandHelper.insertFromString(String value,deviceDataArgin)");
        }
        switch (n) {
            case 2: {
                if (d.isNaN()) break;
                deviceData.insert(d.shortValue());
                break;
            }
            case 6: {
                if (d.isNaN()) break;
                deviceData.insert_us(d.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "CommandHelper.insertFromString(String value,deviceDataArgin)");
                break;
            }
            case 22: {
                if (d.isNaN()) break;
                deviceData.insert(d.shortValue());
                break;
            }
            case 3: {
                if (d.isNaN()) break;
                deviceData.insert(d.intValue());
                break;
            }
            case 7: {
                deviceData.insert_ul(d.longValue());
                break;
            }
            case 23: {
                deviceData.insert(d.intValue());
                break;
            }
            case 24: {
                if (d.isNaN()) break;
                deviceData.insert_u64(d.longValue());
                break;
            }
            case 27: {
                if (d.isNaN()) break;
                deviceData.insert(d.intValue());
                break;
            }
            case 4: {
                if (d.isNaN()) break;
                deviceData.insert(d.floatValue());
                break;
            }
            case 5: {
                if (d.isNaN()) break;
                deviceData.insert(d);
                break;
            }
            case 8: {
                deviceData.insert(string);
                break;
            }
            case 1: {
                if (d.isNaN()) break;
                if (d == 1.0) {
                    deviceData.insert(true);
                    break;
                }
                deviceData.insert(false);
                break;
            }
            case 19: {
                if (d.isNaN()) break;
                DevState devState = StateUtilities.getStateForName(string);
                deviceData.insert(devState);
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceData.getType() + " not supported", "CommandHelper.insertFromString(String value,deviceDataArgin)");
            }
        }
    }

    public static void insertFromInteger(Integer n, DeviceData deviceData, int n2) throws DevFailed {
        switch (n2) {
            case 2: {
                deviceData.insert(n.shortValue());
                break;
            }
            case 6: {
                deviceData.insert_us(n.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "CommandHelper.insertFromInteger(Integer value,deviceDataArgin)");
                break;
            }
            case 22: {
                deviceData.insert(n.shortValue());
                break;
            }
            case 3: {
                deviceData.insert(n);
                break;
            }
            case 7: {
                deviceData.insert_ul(n.longValue());
                break;
            }
            case 23: {
                deviceData.insert(n);
                break;
            }
            case 24: {
                deviceData.insert_u64(n.longValue());
                break;
            }
            case 27: {
                deviceData.insert(n);
                break;
            }
            case 4: {
                deviceData.insert(n.floatValue());
                break;
            }
            case 5: {
                deviceData.insert(n.doubleValue());
                break;
            }
            case 8: {
                deviceData.insert(n.toString());
                break;
            }
            case 1: {
                if (n.doubleValue() == 1.0) {
                    deviceData.insert(true);
                    break;
                }
                deviceData.insert(false);
                break;
            }
            case 19: {
                try {
                    deviceData.insert(DevState.from_int(n));
                }
                catch (BAD_PARAM bAD_PARAM) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "Cannot sent" + n + "for input Tango_DEV_STATE type", "CommandHelper.insertFromInteger(Integer value,deviceDataArgin)");
                }
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceData.getType() + " not supported", "CommandHelper.insertFromInteger(Integer value,deviceDataArgin)");
            }
        }
    }

    public static void insertFromLong(Long l, DeviceData deviceData, int n) throws DevFailed {
        switch (n) {
            case 2: {
                deviceData.insert(l.shortValue());
                break;
            }
            case 6: {
                deviceData.insert_us(l.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "CommandHelper.insertFromLong(Long value,deviceDataArgin)");
                break;
            }
            case 22: {
                deviceData.insert(l.shortValue());
                break;
            }
            case 3: {
                deviceData.insert(l.intValue());
                break;
            }
            case 7: {
                deviceData.insert_ul(l);
                break;
            }
            case 23: {
                deviceData.insert(l.intValue());
                break;
            }
            case 24: {
                deviceData.insert_u64(l);
                break;
            }
            case 27: {
                deviceData.insert(l.intValue());
                break;
            }
            case 4: {
                deviceData.insert(l.floatValue());
                break;
            }
            case 5: {
                deviceData.insert(l.doubleValue());
                break;
            }
            case 8: {
                deviceData.insert(l.toString());
                break;
            }
            case 1: {
                if (l.doubleValue() == 1.0) {
                    deviceData.insert(true);
                    break;
                }
                deviceData.insert(false);
                break;
            }
            case 19: {
                try {
                    deviceData.insert(DevState.from_int(l.intValue()));
                }
                catch (BAD_PARAM bAD_PARAM) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "Cannot sent" + l.intValue() + "for input Tango_DEV_STATE type", "CommandHelper.insertFromLong(Long value,deviceDataArgin)");
                }
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceData.getType() + " not supported", "CommandHelper.insertFromLong(Long value,deviceDataArgin)");
            }
        }
    }

    public static void insertFromFloat(Float f, DeviceData deviceData, int n) throws DevFailed {
        switch (n) {
            case 2: {
                deviceData.insert(f.shortValue());
                break;
            }
            case 6: {
                deviceData.insert_us(f.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "CommandHelper.insertFromFloat(Float value,deviceDataArgin)");
                break;
            }
            case 22: {
                deviceData.insert(f.shortValue());
                break;
            }
            case 3: {
                deviceData.insert(f.intValue());
                break;
            }
            case 7: {
                deviceData.insert_ul(f.longValue());
                break;
            }
            case 23: {
                deviceData.insert_ul(f.intValue());
                break;
            }
            case 24: {
                deviceData.insert_u64(f.longValue());
                break;
            }
            case 27: {
                deviceData.insert(f.intValue());
                break;
            }
            case 4: {
                deviceData.insert(f.floatValue());
                break;
            }
            case 5: {
                deviceData.insert(f.doubleValue());
                break;
            }
            case 8: {
                deviceData.insert(f.toString());
                break;
            }
            case 1: {
                if (f.doubleValue() == 1.0) {
                    deviceData.insert(true);
                    break;
                }
                deviceData.insert(false);
                break;
            }
            case 19: {
                try {
                    deviceData.insert(DevState.from_int(f.intValue()));
                }
                catch (BAD_PARAM bAD_PARAM) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "Cannot sent" + f.intValue() + "for input Tango_DEV_STATE type", "CommandHelper.insertFromFloat(Float value,deviceDataArgin)");
                }
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceData.getType() + " not supported", "CommandHelper.insertFromFloat(Float value,deviceDataArgin)");
            }
        }
    }

    public static void insertFromByteArray(byte[] byArray, DeviceData deviceData, int n) throws DevFailed {
        Double d = new Double(0.0);
        for (int i = 0; i < byArray.length; ++i) {
            d = d + Byte.valueOf(byArray[i]).doubleValue();
        }
        switch (n) {
            case 2: {
                deviceData.insert(d.shortValue());
                break;
            }
            case 6: {
                deviceData.insert_us(d.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "CommandHelper.insertFromByteArray(float[] values,deviceDataArgin)");
                break;
            }
            case 22: {
                deviceData.insert(d.shortValue());
                break;
            }
            case 3: {
                deviceData.insert(d.intValue());
                break;
            }
            case 7: {
                deviceData.insert_ul(d.longValue());
                break;
            }
            case 23: {
                deviceData.insert(d.intValue());
                break;
            }
            case 24: {
                deviceData.insert_u64(d.longValue());
                break;
            }
            case 27: {
                deviceData.insert(d.intValue());
                break;
            }
            case 4: {
                deviceData.insert(d.floatValue());
                break;
            }
            case 5: {
                deviceData.insert(d);
                break;
            }
            case 8: {
                deviceData.insert(d.toString());
                break;
            }
            case 1: {
                if (d == 1.0) {
                    deviceData.insert(true);
                    break;
                }
                deviceData.insert(false);
                break;
            }
            case 19: {
                DevState devState = DevState.UNKNOWN;
                if (byArray.length > 0) {
                    try {
                        devState = DevState.from_int(Byte.valueOf(byArray[0]).intValue());
                    }
                    catch (BAD_PARAM bAD_PARAM) {
                        devState = DevState.UNKNOWN;
                    }
                }
                deviceData.insert(devState);
                break;
            }
            case 10: {
                short[] sArray = new short[byArray.length];
                for (int i = 0; i < byArray.length; ++i) {
                    sArray[i] = Byte.valueOf(byArray[i]).shortValue();
                }
                deviceData.insert(sArray);
                break;
            }
            case 14: {
                short[] sArray = new short[byArray.length];
                for (int i = 0; i < byArray.length; ++i) {
                    sArray[i] = Byte.valueOf(byArray[i]).shortValue();
                }
                deviceData.insert(sArray);
                break;
            }
            case 9: {
                deviceData.insert(byArray);
                break;
            }
            case 11: {
                int[] nArray = new int[byArray.length];
                for (int i = 0; i < byArray.length; ++i) {
                    nArray[i] = Byte.valueOf(byArray[i]).intValue();
                }
                deviceData.insert(nArray);
                break;
            }
            case 15: {
                long[] lArray = new long[byArray.length];
                for (int i = 0; i < byArray.length; ++i) {
                    lArray[i] = Byte.valueOf(byArray[i]).longValue();
                }
                deviceData.insert_ul(lArray);
                break;
            }
            case 25: {
                int[] nArray = new int[byArray.length];
                for (int i = 0; i < byArray.length; ++i) {
                    nArray[i] = Byte.valueOf(byArray[i]).intValue();
                }
                deviceData.insert(nArray);
                break;
            }
            case 26: {
                long[] lArray = new long[byArray.length];
                for (int i = 0; i < byArray.length; ++i) {
                    lArray[i] = Byte.valueOf(byArray[i]).longValue();
                }
                deviceData.insert_u64(lArray);
                break;
            }
            case 12: {
                float[] fArray = new float[byArray.length];
                for (int i = 0; i < byArray.length; ++i) {
                    fArray[i] = Byte.valueOf(byArray[i]).longValue();
                }
                deviceData.insert(fArray);
                break;
            }
            case 13: {
                double[] dArray = new double[byArray.length];
                for (int i = 0; i < byArray.length; ++i) {
                    dArray[i] = Byte.valueOf(byArray[i]).doubleValue();
                }
                deviceData.insert(dArray);
                break;
            }
            case 16: {
                String[] stringArray = new String[byArray.length];
                for (int i = 0; i < byArray.length; ++i) {
                    stringArray[i] = Byte.valueOf(byArray[i]).toString();
                }
                deviceData.insert(stringArray);
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceData.getType() + " not supported", "insertFromFloatArray.insertFromLongArray(float[] values,deviceDataArgin)");
            }
        }
    }

    public static void insertFromBoolean(Boolean bl, DeviceData deviceData, int n) throws DevFailed {
        Integer n2 = 0;
        if (bl.booleanValue()) {
            n2 = 1;
        }
        switch (n) {
            case 2: {
                deviceData.insert(n2.shortValue());
                break;
            }
            case 6: {
                deviceData.insert_us(n2.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "CommandHelper.insertFromBoolean(Boolean value,deviceDataArgin)");
                break;
            }
            case 22: {
                deviceData.insert(n2.shortValue());
                break;
            }
            case 3: {
                deviceData.insert(n2);
                break;
            }
            case 7: {
                deviceData.insert_ul(n2.longValue());
                break;
            }
            case 23: {
                deviceData.insert_ul(n2);
                break;
            }
            case 24: {
                deviceData.insert_u64(n2.longValue());
                break;
            }
            case 27: {
                deviceData.insert(n2);
                break;
            }
            case 4: {
                deviceData.insert(n2.floatValue());
                break;
            }
            case 5: {
                deviceData.insert(n2.doubleValue());
                break;
            }
            case 8: {
                deviceData.insert(Boolean.toString(bl));
                break;
            }
            case 1: {
                deviceData.insert(bl);
                break;
            }
            case 19: {
                deviceData.insert(DevState.from_int(n2));
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceData.getType() + " not supported", "CommandHelper.insertFromBoolean(Boolean value,deviceDataArgin)");
            }
        }
    }

    public static void insertFromDouble(Double d, DeviceData deviceData, int n) throws DevFailed {
        switch (n) {
            case 2: {
                deviceData.insert(d.shortValue());
                break;
            }
            case 6: {
                deviceData.insert_us(d.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "CommandHelper.insertFromDouble(Double value,deviceDataArgin)");
                break;
            }
            case 22: {
                deviceData.insert(d.shortValue());
                break;
            }
            case 3: {
                deviceData.insert(d.intValue());
                break;
            }
            case 7: {
                deviceData.insert_ul(d.longValue());
                break;
            }
            case 23: {
                deviceData.insert(d.intValue());
                break;
            }
            case 24: {
                deviceData.insert_u64(d.longValue());
                break;
            }
            case 27: {
                deviceData.insert(d.intValue());
                break;
            }
            case 4: {
                deviceData.insert(d.floatValue());
                break;
            }
            case 5: {
                deviceData.insert(d);
                break;
            }
            case 8: {
                deviceData.insert(d.toString());
                break;
            }
            case 1: {
                if (d == 1.0) {
                    deviceData.insert(true);
                    break;
                }
                deviceData.insert(false);
                break;
            }
            case 19: {
                try {
                    deviceData.insert(DevState.from_int(d.intValue()));
                }
                catch (BAD_PARAM bAD_PARAM) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "Cannot sent" + d.intValue() + "for input Tango_DEV_STATE type", "CommandHelper.insertFromDouble(Double value,deviceDataArgin)");
                }
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceData.getType() + " not supported", "CommandHelper.insertFromDouble(Double value,deviceDataArgin)");
            }
        }
    }

    public static void insertFromDevState(DevState devState, DeviceData deviceData, int n) throws DevFailed {
        Integer n2 = devState.value();
        switch (deviceData.getType()) {
            case 2: {
                deviceData.insert(n2.shortValue());
                break;
            }
            case 6: {
                deviceData.insert_us(n2.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "CommandHelper.insertFromDevState(DevState value,deviceDataArgin)");
                break;
            }
            case 22: {
                deviceData.insert(n2.shortValue());
                break;
            }
            case 3: {
                deviceData.insert(n2);
                break;
            }
            case 7: {
                deviceData.insert_ul(n2.longValue());
                break;
            }
            case 23: {
                deviceData.insert(n2);
                break;
            }
            case 24: {
                deviceData.insert_u64(n2.longValue());
                break;
            }
            case 27: {
                deviceData.insert(n2);
                break;
            }
            case 4: {
                deviceData.insert(n2.floatValue());
                break;
            }
            case 5: {
                deviceData.insert(n2.doubleValue());
                break;
            }
            case 8: {
                deviceData.insert(n2.toString());
                break;
            }
            case 1: {
                if (n2.doubleValue() == 1.0) {
                    deviceData.insert(true);
                    break;
                }
                deviceData.insert(false);
                break;
            }
            case 19: {
                deviceData.insert(devState);
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceData.getType() + " not supported", "CommandHelper.insertFromDevState(DevState value,deviceDataArgin)");
            }
        }
    }

    public static void insertFromDevVarDoubleStringArray(DevVarDoubleStringArray devVarDoubleStringArray, DeviceData deviceData, int n) throws DevFailed {
        if (n == 18) {
            deviceData.insert(devVarDoubleStringArray);
        } else {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceData.getType() + " not supported", "CommandHelper.insertFromDevVarDoubleStringArray(DevVarDoubleStringArray value,deviceDataArgin)");
        }
    }

    public static void insertFromDevVarLongStringArray(DevVarLongStringArray devVarLongStringArray, DeviceData deviceData, int n) throws DevFailed {
        if (n == 17) {
            deviceData.insert(devVarLongStringArray);
        } else {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceData.getType() + " not supported", "CommandHelper.insertFromDevVarLongStringArray(DevVarLongStringArray value,deviceDataArgin)");
        }
    }

    public static void insertFromArray(Object[] objectArray, DeviceData deviceData, int n) throws DevFailed {
        if (objectArray.length > 0) {
            Object object = objectArray[0];
            if (object instanceof Short) {
                short[] sArray = new short[objectArray.length];
                for (int i = 0; i < sArray.length; ++i) {
                    sArray[i] = (Short)objectArray[i];
                }
                CommandHelper.insertFromShortArray(sArray, deviceData, n);
            } else if (object instanceof String) {
                String[] stringArray = new String[objectArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = (String)objectArray[i];
                }
                CommandHelper.insertFromStringArray(stringArray, deviceData, n);
            } else if (object instanceof Integer) {
                int[] nArray = new int[objectArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = (Integer)objectArray[i];
                }
                CommandHelper.insertFromIntegerArray(nArray, deviceData, n);
            } else if (object instanceof Long) {
                long[] lArray = new long[objectArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    lArray[i] = ((Long)objectArray[i]).intValue();
                }
                CommandHelper.insertFromLongArray(lArray, deviceData, n);
            } else if (object instanceof Float) {
                float[] fArray = new float[objectArray.length];
                for (int i = 0; i < fArray.length; ++i) {
                    fArray[i] = ((Float)objectArray[i]).floatValue();
                }
                CommandHelper.insertFromFloatArray(fArray, deviceData, n);
            } else if (object instanceof Byte) {
                byte[] byArray = new byte[objectArray.length];
                for (int i = 0; i < byArray.length; ++i) {
                    byArray[i] = (Byte)objectArray[i];
                }
                CommandHelper.insertFromByteArray(byArray, deviceData, n);
            } else if (object instanceof Boolean) {
                boolean[] blArray = new boolean[objectArray.length];
                for (int i = 0; i < blArray.length; ++i) {
                    blArray[i] = (Boolean)objectArray[i];
                }
                CommandHelper.insertFromBooleanArray(blArray, deviceData, n);
            } else if (object instanceof Double) {
                double[] dArray = new double[objectArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = (Double)objectArray[i];
                }
                CommandHelper.insertFromDoubleArray(dArray, deviceData, n);
            }
        }
    }
}

