/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.helpers;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.StateUtilities;
import fr.esrf.TangoDs.Attribute;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.WAttribute;
import java.util.Vector;
import org.omg.CORBA.BAD_PARAM;

public class AttributeHelper {
    public static void insert(Object object, DeviceAttribute deviceAttribute) throws DevFailed {
        if (object instanceof Short) {
            AttributeHelper.insertFromShort((Short)object, deviceAttribute);
        } else if (object instanceof String) {
            AttributeHelper.insertFromString((String)object, deviceAttribute);
        } else if (object instanceof Integer) {
            AttributeHelper.insertFromInteger((Integer)object, deviceAttribute);
        } else if (object instanceof Long) {
            AttributeHelper.insertFromLong((Long)object, deviceAttribute);
        } else if (object instanceof Float) {
            AttributeHelper.insertFromFloat((Float)object, deviceAttribute);
        } else if (object instanceof Boolean) {
            AttributeHelper.insertFromBoolean((Boolean)object, deviceAttribute);
        } else if (object instanceof Double) {
            AttributeHelper.insertFromDouble((Double)object, deviceAttribute);
        } else if (object instanceof DevState) {
            AttributeHelper.insertFromDevState((DevState)object, deviceAttribute);
        } else if (object instanceof WAttribute) {
            AttributeHelper.insertFromWAttribute((WAttribute)object, deviceAttribute);
        } else if (object instanceof Vector) {
            AttributeHelper.insertFromArray(((Vector)object).toArray(), deviceAttribute, deviceAttribute.getWrittenDimX(), deviceAttribute.getWrittenDimY());
        } else {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + object.getClass() + " not supported", "AttributeHelper.insert(Object value,deviceAttributeWritten)");
        }
    }

    public static void set_value(Object object, Attribute attribute) throws DevFailed {
        try {
            if (object instanceof Short) {
                attribute.set_value((Short)object);
            } else if (object instanceof Byte) {
                attribute.set_value(((Byte)object).shortValue());
            } else if (object instanceof String) {
                attribute.set_value((String)object);
            } else if (object instanceof Integer) {
                attribute.set_value((Integer)object);
            } else if (object instanceof Long) {
                attribute.set_value((Long)object);
            } else if (object instanceof Float) {
                attribute.set_value(((Float)object).doubleValue());
            } else if (object instanceof Boolean) {
                attribute.set_value((Boolean)object);
            } else if (object instanceof Double) {
                attribute.set_value((Double)object);
            } else if (object instanceof DevState) {
                attribute.set_value((DevState)object);
            } else {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + object.getClass() + " not supported", "AttributeHelper.insert(Object value,deviceAttributeWritten)");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void set_value(Object[] objectArray, Attribute attribute, int n, int n2) throws DevFailed {
        if (objectArray.length > 0 && n == 1 && n2 == 0) {
            AttributeHelper.set_value(objectArray[0], attribute);
        } else if (objectArray.length > 1) {
            Object object = objectArray[0];
            if (object instanceof Short) {
                short[] sArray = new short[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    sArray[i] = (Short)objectArray[i];
                }
                if (n2 == 0) {
                    attribute.set_value(sArray, sArray.length);
                }
                if (n2 > 0) {
                    attribute.set_value(sArray, sArray.length / n2, n2);
                }
            } else if (object instanceof String) {
                String[] stringArray = new String[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    stringArray[i] = (String)objectArray[i];
                }
                if (n2 == 0) {
                    attribute.set_value(stringArray, stringArray.length);
                }
                if (n2 > 0) {
                    attribute.set_value(stringArray, stringArray.length - n2, n2);
                }
            } else if (object instanceof Integer) {
                int[] nArray = new int[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    nArray[i] = (Integer)objectArray[i];
                }
                if (n2 == 0) {
                    attribute.set_value(nArray, nArray.length);
                }
                if (n2 > 0) {
                    attribute.set_value(nArray, nArray.length / n2, n2);
                }
            } else if (object instanceof Long) {
                long[] lArray = new long[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    lArray[i] = (Long)objectArray[i];
                }
                if (n2 == 0) {
                    attribute.set_value(lArray, lArray.length);
                }
                if (n2 > 0) {
                    attribute.set_value(lArray, lArray.length / n2, n2);
                }
            } else if (object instanceof Float) {
                double[] dArray = new double[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    dArray[i] = ((Float)objectArray[i]).doubleValue();
                }
                if (n2 == 0) {
                    attribute.set_value(dArray, dArray.length);
                }
                if (n2 > 0) {
                    attribute.set_value(dArray, dArray.length / n2, n2);
                }
            } else if (object instanceof Boolean) {
                boolean[] blArray = new boolean[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    blArray[i] = (Boolean)objectArray[i];
                }
                if (n2 == 0) {
                    attribute.set_value(blArray, blArray.length);
                }
                if (n2 > 0) {
                    attribute.set_value(blArray, blArray.length - n2, n2);
                }
            } else if (object instanceof Double) {
                double[] dArray = new double[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    dArray[i] = (Double)objectArray[i];
                }
                if (n2 == 0) {
                    attribute.set_value(dArray, dArray.length);
                }
                if (n2 > 0) {
                    attribute.set_value(dArray, dArray.length / n2, n2);
                }
            } else if (object instanceof Byte) {
                short[] sArray = new short[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    sArray[i] = ((Byte)objectArray[i]).shortValue();
                }
                if (n2 == 0) {
                    attribute.set_value(sArray, sArray.length);
                }
                if (n2 > 0) {
                    attribute.set_value(sArray, sArray.length / n2, n2);
                }
            } else if (object instanceof DevState) {
                DevState[] devStateArray = new DevState[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    devStateArray[i] = (DevState)objectArray[i];
                }
                if (n2 == 0) {
                    attribute.set_value(devStateArray, devStateArray.length);
                }
                if (n2 > 0) {
                    attribute.set_value(devStateArray, devStateArray.length / n2, n2);
                }
            } else {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + object.getClass() + " not supported", "AttributeHelper.insert(Object value,deviceAttributeWritten)");
            }
        }
    }

    public static void insert(Object object, DeviceAttribute deviceAttribute, int n, int n2) throws DevFailed {
        if (object instanceof Short) {
            AttributeHelper.insertFromShort((Short)object, deviceAttribute);
        } else if (object instanceof String) {
            AttributeHelper.insertFromString((String)object, deviceAttribute);
        } else if (object instanceof Integer) {
            AttributeHelper.insertFromInteger((Integer)object, deviceAttribute);
        } else if (object instanceof Long) {
            AttributeHelper.insertFromLong((Long)object, deviceAttribute);
        } else if (object instanceof Float) {
            AttributeHelper.insertFromFloat((Float)object, deviceAttribute);
        } else if (object instanceof Boolean) {
            AttributeHelper.insertFromBoolean((Boolean)object, deviceAttribute);
        } else if (object instanceof Double) {
            AttributeHelper.insertFromDouble((Double)object, deviceAttribute);
        } else if (object instanceof DevState) {
            AttributeHelper.insertFromDevState((DevState)object, deviceAttribute);
        } else if (object instanceof WAttribute) {
            AttributeHelper.insertFromWAttribute((WAttribute)object, deviceAttribute);
        } else if (object instanceof Vector) {
            AttributeHelper.insertFromArray(((Vector)object).toArray(), deviceAttribute, n, n2);
        } else {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + object.getClass() + " not supported", "AttributeHelper.insert(Object value,deviceAttributeWritten)");
        }
    }

    public static Object extract(DeviceAttribute deviceAttribute) throws DevFailed {
        Object object = null;
        if (deviceAttribute.getDimX() != 1 || deviceAttribute.getDimY() != 0) {
            object = AttributeHelper.extractArray(deviceAttribute);
        } else {
            switch (deviceAttribute.getType()) {
                case 2: {
                    object = deviceAttribute.extractShort();
                    break;
                }
                case 6: {
                    object = Integer.valueOf(deviceAttribute.extractUShort()).shortValue();
                    break;
                }
                case 21: {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "out type Tango_DEV_CHAR not supported", "AttributeHelper.extract(deviceAttributeWritten)");
                    break;
                }
                case 22: {
                    object = deviceAttribute.extractUChar();
                    break;
                }
                case 3: {
                    object = deviceAttribute.extractLong();
                    break;
                }
                case 7: {
                    object = deviceAttribute.extractULong();
                    break;
                }
                case 23: {
                    object = deviceAttribute.extractLong64();
                    break;
                }
                case 24: {
                    object = deviceAttribute.extractULong64();
                    break;
                }
                case 27: {
                    object = deviceAttribute.extractLong();
                    break;
                }
                case 4: {
                    object = Float.valueOf(deviceAttribute.extractFloat());
                    break;
                }
                case 5: {
                    object = deviceAttribute.extractDouble();
                    break;
                }
                case 8: {
                    object = deviceAttribute.extractString();
                    break;
                }
                case 1: {
                    object = deviceAttribute.extractBoolean();
                    break;
                }
                case 19: {
                    object = deviceAttribute.extractDevState();
                    break;
                }
                default: {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + deviceAttribute.getType() + " not supported", "AttributeHelper.extract(Short value,deviceAttributeWritten)");
                }
            }
        }
        return object;
    }

    public static Object[] extractArray(DeviceAttribute deviceAttribute) throws DevFailed {
        Object[] objectArray = null;
        switch (deviceAttribute.getType()) {
            case 2: {
                short[] sArray = deviceAttribute.extractShortArray();
                objectArray = new Object[sArray.length];
                for (int i = 0; i < sArray.length; ++i) {
                    objectArray[i] = sArray[i];
                }
                break;
            }
            case 6: {
                int[] nArray = deviceAttribute.extractUShortArray();
                objectArray = new Object[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    objectArray[i] = nArray[i];
                }
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type Tango_DEV_CHAR not supported", "AttributeHelper.extractArray(deviceAttributeWritten)");
                break;
            }
            case 22: {
                byte[] byArray = deviceAttribute.extractCharArray();
                objectArray = new Object[byArray.length];
                for (int i = 0; i < byArray.length; ++i) {
                    objectArray[i] = byArray[i];
                }
                break;
            }
            case 3: {
                int[] nArray = deviceAttribute.extractLongArray();
                objectArray = new Object[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    objectArray[i] = nArray[i];
                }
                break;
            }
            case 7: {
                long[] lArray = deviceAttribute.extractULongArray();
                objectArray = new Object[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    objectArray[i] = lArray[i];
                }
                break;
            }
            case 23: {
                long[] lArray = deviceAttribute.extractLong64Array();
                objectArray = new Object[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    objectArray[i] = lArray[i];
                }
                break;
            }
            case 24: {
                long[] lArray = deviceAttribute.extractULong64Array();
                objectArray = new Object[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    objectArray[i] = lArray[i];
                }
                break;
            }
            case 27: {
                int[] nArray = deviceAttribute.extractLongArray();
                objectArray = new Object[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    objectArray[i] = nArray[i];
                }
                break;
            }
            case 4: {
                float[] fArray = deviceAttribute.extractFloatArray();
                objectArray = new Object[fArray.length];
                for (int i = 0; i < fArray.length; ++i) {
                    objectArray[i] = Float.valueOf(fArray[i]);
                }
                break;
            }
            case 5: {
                double[] dArray = deviceAttribute.extractDoubleArray();
                objectArray = new Object[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    objectArray[i] = dArray[i];
                }
                break;
            }
            case 8: {
                String[] stringArray = deviceAttribute.extractStringArray();
                objectArray = new Object[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    objectArray[i] = stringArray[i];
                }
                break;
            }
            case 1: {
                boolean[] blArray = deviceAttribute.extractBooleanArray();
                objectArray = new Object[blArray.length];
                for (int i = 0; i < blArray.length; ++i) {
                    objectArray[i] = blArray[i];
                }
                break;
            }
            case 19: {
                objectArray = new Object[]{deviceAttribute.extractDevState()};
                break;
            }
            case 10: {
                short[] sArray = deviceAttribute.extractShortArray();
                objectArray = new Object[sArray.length];
                for (int i = 0; i < sArray.length; ++i) {
                    objectArray[i] = sArray[i];
                }
                break;
            }
            case 14: {
                int[] nArray = deviceAttribute.extractUShortArray();
                objectArray = new Object[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    objectArray[i] = nArray[i];
                }
                break;
            }
            case 9: {
                byte[] byArray = deviceAttribute.extractCharArray();
                objectArray = new Object[byArray.length];
                for (int i = 0; i < byArray.length; ++i) {
                    objectArray[i] = byArray[i];
                }
                break;
            }
            case 11: {
                int[] nArray = deviceAttribute.extractLongArray();
                objectArray = new Object[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    objectArray[i] = nArray[i];
                }
                break;
            }
            case 15: {
                long[] lArray = deviceAttribute.extractULongArray();
                objectArray = new Object[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    objectArray[i] = lArray[i];
                }
                break;
            }
            case 25: {
                long[] lArray = deviceAttribute.extractLong64Array();
                objectArray = new Object[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    objectArray[i] = lArray[i];
                }
                break;
            }
            case 26: {
                long[] lArray = deviceAttribute.extractULong64Array();
                objectArray = new Object[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    objectArray[i] = lArray[i];
                }
                break;
            }
            case 12: {
                float[] fArray = deviceAttribute.extractFloatArray();
                objectArray = new Object[fArray.length];
                for (int i = 0; i < fArray.length; ++i) {
                    objectArray[i] = Float.valueOf(fArray[i]);
                }
                break;
            }
            case 13: {
                double[] dArray = deviceAttribute.extractDoubleArray();
                objectArray = new Object[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    objectArray[i] = dArray[i];
                }
                break;
            }
            case 16: {
                String[] stringArray = deviceAttribute.extractStringArray();
                objectArray = new Object[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    objectArray[i] = stringArray[i];
                }
                break;
            }
            case 17: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type Tango_DEVVAR_LONGSTRINGARRAY not supported", "AttributeHelper.insertFromShortArray(short[] values,deviceAttributeWritten)");
                break;
            }
            case 18: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type Tango_DEVVAR_DOUBLESTRINGARRAY not supported", "AttributeHelper.insertFromShortArray(short[] values,deviceAttributeWritten)");
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + deviceAttribute.getType() + " not supported", "AttributeHelper.insertFromShort(Short value,deviceAttributeWritten)");
            }
        }
        return objectArray;
    }

    public static void insertFromShort(Short s, DeviceAttribute deviceAttribute) throws DevFailed {
        switch (deviceAttribute.getType()) {
            case 2: {
                deviceAttribute.insert(s);
                break;
            }
            case 6: {
                deviceAttribute.insert_us(s);
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "AttributeHelper.insertFromShort(Short value,deviceAttributeWritten)");
                break;
            }
            case 22: {
                deviceAttribute.insert_uc(s);
                break;
            }
            case 3: {
                deviceAttribute.insert(s.intValue());
                break;
            }
            case 7: {
                deviceAttribute.insert_ul(s.longValue());
                break;
            }
            case 23: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_LONG64 not supported", "AttributeHelper.insertFromShort(Short value,deviceAttributeWritten)");
                break;
            }
            case 24: {
                deviceAttribute.insert_u64(s.longValue());
                break;
            }
            case 27: {
                deviceAttribute.insert(s.intValue());
                break;
            }
            case 4: {
                deviceAttribute.insert(s.floatValue());
                break;
            }
            case 5: {
                deviceAttribute.insert(s.doubleValue());
                break;
            }
            case 8: {
                deviceAttribute.insert(s.toString());
                break;
            }
            case 1: {
                if (s.doubleValue() == 1.0) {
                    deviceAttribute.insert(true);
                    break;
                }
                deviceAttribute.insert(false);
                break;
            }
            case 19: {
                try {
                    deviceAttribute.insert(DevState.from_int(s.intValue()));
                }
                catch (BAD_PARAM bAD_PARAM) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "Cannot sent" + s.intValue() + "for input Tango_DEV_STATE type", "AttributeHelper.insertFromShort(Short value,deviceAttributeWritten)");
                }
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceAttribute.getType() + " not supported", "AttributeHelper.insertFromShort(Short value,deviceAttributeWritten)");
            }
        }
    }

    public static Short extractToShort(DeviceAttribute deviceAttribute) throws DevFailed {
        Object object = AttributeHelper.extract(deviceAttribute);
        Short s = null;
        if (object instanceof Short) {
            s = (Short)object;
        } else if (object instanceof String) {
            try {
                s = Short.valueOf((String)object);
            }
            catch (Exception exception) {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + object + " is not a numerical", "AttributeHelper.extractToShort(deviceAttributeWritten)");
            }
        } else if (object instanceof Integer) {
            s = ((Integer)object).shortValue();
        } else if (object instanceof Long) {
            s = ((Long)object).shortValue();
        } else if (object instanceof Float) {
            s = ((Float)object).shortValue();
        } else if (object instanceof Boolean) {
            s = ((Boolean)object).booleanValue() ? Short.valueOf((short)1) : Short.valueOf((short)0);
        } else if (object instanceof Double) {
            s = ((Double)object).shortValue();
        } else if (object instanceof DevState) {
            s = Integer.valueOf(((DevState)object).value()).shortValue();
        } else {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + object.getClass() + " not supported", "AttributeHelper.extractToShort(Object value,deviceAttributeWritten)");
        }
        return s;
    }

    public static String extractToString(DeviceAttribute deviceAttribute) throws DevFailed {
        Object object = AttributeHelper.extract(deviceAttribute);
        String string = null;
        if (object instanceof Short) {
            string = ((Short)object).toString();
        } else if (object instanceof String) {
            string = (String)object;
        } else if (object instanceof Integer) {
            string = ((Integer)object).toString();
        } else if (object instanceof Long) {
            string = ((Long)object).toString();
        } else if (object instanceof Float) {
            string = ((Float)object).toString();
        } else if (object instanceof Boolean) {
            string = ((Boolean)object).toString();
        } else if (object instanceof Double) {
            string = ((Double)object).toString();
        } else if (object instanceof DevState) {
            string = StateUtilities.getNameForState((DevState)object);
        } else {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + object.getClass() + " not supported", "AttributeHelper.extractToString(Object value,deviceAttributeWritten)");
        }
        return string;
    }

    public static Integer extractToInteger(DeviceAttribute deviceAttribute) throws DevFailed {
        Object object = AttributeHelper.extract(deviceAttribute);
        Integer n = null;
        if (object instanceof Short) {
            n = ((Short)object).intValue();
        } else if (object instanceof String) {
            try {
                n = Integer.valueOf((String)object);
            }
            catch (Exception exception) {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + object + " is not a numerical", "AttributeHelper.extractToInteger(deviceAttributeWritten)");
            }
        } else if (object instanceof Integer) {
            n = (Integer)object;
        } else if (object instanceof Long) {
            n = ((Long)object).intValue();
        } else if (object instanceof Float) {
            n = ((Float)object).intValue();
        } else if (object instanceof Boolean) {
            n = ((Boolean)object).booleanValue() ? Integer.valueOf(1) : Integer.valueOf(0);
        } else if (object instanceof Double) {
            n = ((Double)object).intValue();
        } else if (object instanceof DevState) {
            n = ((DevState)object).value();
        } else {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + object.getClass() + " not supported", "AttributeHelper.extractToInteger(Object value,deviceAttributeWritten)");
        }
        return n;
    }

    public static Long extractToLong(DeviceAttribute deviceAttribute) throws DevFailed {
        Object object = AttributeHelper.extract(deviceAttribute);
        Long l = null;
        if (object instanceof Short) {
            l = ((Short)object).longValue();
        } else if (object instanceof String) {
            try {
                l = Long.valueOf((String)object);
            }
            catch (Exception exception) {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + object + " is not a numerical", "AttributeHelper.extractToLong(deviceAttributeWritten)");
            }
        } else if (object instanceof Integer) {
            l = ((Integer)object).longValue();
        } else if (object instanceof Long) {
            l = (long)((Long)object);
        } else if (object instanceof Float) {
            l = ((Float)object).longValue();
        } else if (object instanceof Boolean) {
            l = ((Boolean)object).booleanValue() ? Long.valueOf(1L) : Long.valueOf(0L);
        } else if (object instanceof Double) {
            l = ((Double)object).longValue();
        } else if (object instanceof DevState) {
            l = Integer.valueOf(((DevState)object).value()).longValue();
        } else {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + object.getClass() + " not supported", "AttributeHelper.extractToLong(Object value,deviceAttributeWritten)");
        }
        return l;
    }

    public static Float extractToFloat(DeviceAttribute deviceAttribute) throws DevFailed {
        Object object = AttributeHelper.extract(deviceAttribute);
        Float f = null;
        if (object instanceof Short) {
            f = Float.valueOf(((Short)object).floatValue());
        } else if (object instanceof String) {
            try {
                f = Float.valueOf((String)object);
            }
            catch (Exception exception) {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + object + " is not a numerical", "AttributeHelper.extractToFloat(deviceAttributeWritten)");
            }
        } else if (object instanceof Integer) {
            f = Float.valueOf(((Integer)object).floatValue());
        } else if (object instanceof Long) {
            f = Float.valueOf(((Long)object).floatValue());
        } else if (object instanceof Float) {
            f = Float.valueOf(((Float)object).floatValue());
        } else if (object instanceof Boolean) {
            f = ((Boolean)object).booleanValue() ? Float.valueOf(1.0f) : Float.valueOf(0.0f);
        } else if (object instanceof Double) {
            f = Float.valueOf(((Double)object).floatValue());
        } else if (object instanceof DevState) {
            f = Float.valueOf(Integer.valueOf(((DevState)object).value()).floatValue());
        } else {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + object.getClass() + " not supported", "AttributeHelper.extractToFloat(Object value,deviceAttributeWritten)");
        }
        return f;
    }

    public static Boolean extractToBoolean(DeviceAttribute deviceAttribute) throws DevFailed {
        Object object = AttributeHelper.extract(deviceAttribute);
        int n = 0;
        Boolean bl = Boolean.FALSE;
        if (object instanceof Short) {
            n = ((Short)object).intValue();
        } else if (object instanceof String) {
            try {
                if (Boolean.getBoolean((String)object)) {
                    n = 1;
                }
            }
            catch (Exception exception) {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + object + " is not a boolean", "AttributeHelper.extractToBoolean(deviceAttributeWritten)");
            }
        } else if (object instanceof Integer) {
            n = (Integer)object;
        } else if (object instanceof Long) {
            n = ((Long)object).intValue();
        } else if (object instanceof Float) {
            n = ((Float)object).intValue();
        } else if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                n = 1;
            }
        } else if (object instanceof Double) {
            n = ((Double)object).intValue();
        } else if (object instanceof DevState) {
            n = ((DevState)object).value();
        } else {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + object.getClass() + " not supported", "AttributeHelper.extractToBoolean(Object value,deviceAttributeWritten)");
        }
        if (n == 1) {
            bl = Boolean.TRUE;
        }
        return bl;
    }

    public static Double extractToDouble(DeviceAttribute deviceAttribute) throws DevFailed {
        Object object = AttributeHelper.extract(deviceAttribute);
        Double d = null;
        if (object instanceof Short) {
            d = ((Short)object).doubleValue();
        } else if (object instanceof String) {
            try {
                d = Double.valueOf((String)object);
            }
            catch (Exception exception) {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + object + " is not a numerical", "AttributeHelper.extractToFloat(deviceAttributeWritten)");
            }
        } else if (object instanceof Integer) {
            d = ((Integer)object).doubleValue();
        } else if (object instanceof Long) {
            d = ((Long)object).doubleValue();
        } else if (object instanceof Float) {
            d = ((Float)object).doubleValue();
        } else if (object instanceof Boolean) {
            d = ((Boolean)object).booleanValue() ? Double.valueOf(1.0) : Double.valueOf(0.0);
        } else if (object instanceof Double) {
            d = (Double)object;
        } else if (object instanceof DevState) {
            d = Integer.valueOf(((DevState)object).value()).doubleValue();
        } else {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + object.getClass() + " not supported", "AttributeHelper.extractToFloat(Object value,deviceAttributeWritten)");
        }
        return d;
    }

    public static DevState extractToDevState(DeviceAttribute deviceAttribute) throws DevFailed {
        DevState devState;
        block29: {
            Object object = AttributeHelper.extract(deviceAttribute);
            devState = null;
            if (object instanceof Short) {
                try {
                    devState = DevState.from_int(((Short)object).intValue());
                }
                catch (Exception exception) {
                    devState = DevState.UNKNOWN;
                }
            } else if (object instanceof String) {
                devState = StateUtilities.getStateForName((String)object);
            } else if (object instanceof Integer) {
                try {
                    devState = DevState.from_int((Integer)object);
                }
                catch (Exception exception) {
                    devState = DevState.UNKNOWN;
                }
            } else if (object instanceof Long) {
                try {
                    devState = DevState.from_int(((Long)object).intValue());
                }
                catch (Exception exception) {
                    devState = DevState.UNKNOWN;
                }
            } else if (object instanceof Float) {
                try {
                    devState = DevState.from_int(((Float)object).intValue());
                }
                catch (Exception exception) {
                    devState = DevState.UNKNOWN;
                }
            } else if (object instanceof Boolean) {
                try {
                    if (((Boolean)object).booleanValue()) {
                        devState = DevState.from_int(1);
                        break block29;
                    }
                    devState = DevState.from_int(0);
                }
                catch (Exception exception) {
                    devState = DevState.UNKNOWN;
                }
            } else if (object instanceof Double) {
                try {
                    devState = DevState.from_int(((Double)object).intValue());
                }
                catch (Exception exception) {
                    devState = DevState.UNKNOWN;
                }
            } else if (object instanceof DevState) {
                devState = (DevState)object;
            } else {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + object.getClass() + " not supported", "AttributeHelper.extractToDevState(Object value,deviceAttributeWritten)");
            }
        }
        return devState;
    }

    public static short[] extractToShortArray(DeviceAttribute deviceAttribute) throws DevFailed {
        Object[] objectArray = AttributeHelper.extractArray(deviceAttribute);
        if (objectArray == null) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output is empty ", "AttributeHelper.extractToShortArray(deviceAttributeWritten)");
        }
        short[] sArray = new short[objectArray.length];
        if (objectArray.length > 0) {
            if (objectArray[0] instanceof Short) {
                for (int i = 0; i < objectArray.length; ++i) {
                    sArray[i] = (Short)objectArray[i];
                }
            } else if (objectArray[0] instanceof String) {
                try {
                    for (int i = 0; i < objectArray.length; ++i) {
                        sArray[i] = Double.valueOf((String)objectArray[i]).shortValue();
                    }
                }
                catch (Exception exception) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type not numerical", "AttributeHelper.extractToShortArray(deviceAttributeWritten)");
                }
            } else if (objectArray[0] instanceof Integer) {
                for (int i = 0; i < objectArray.length; ++i) {
                    sArray[i] = ((Integer)objectArray[i]).shortValue();
                }
            } else if (objectArray[0] instanceof Long) {
                for (int i = 0; i < objectArray.length; ++i) {
                    sArray[i] = ((Long)objectArray[i]).shortValue();
                }
            } else if (objectArray[0] instanceof Float) {
                for (int i = 0; i < objectArray.length; ++i) {
                    sArray[i] = ((Float)objectArray[i]).shortValue();
                }
            } else if (objectArray[0] instanceof Boolean) {
                for (int i = 0; i < objectArray.length; ++i) {
                    sArray[i] = (Boolean)objectArray[i] != false ? (short)1 : 0;
                }
            } else if (objectArray[0] instanceof Double) {
                for (int i = 0; i < objectArray.length; ++i) {
                    sArray[i] = ((Double)objectArray[i]).shortValue();
                }
            } else if (objectArray[0] instanceof Byte) {
                for (int i = 0; i < objectArray.length; ++i) {
                    sArray[i] = ((Byte)objectArray[i]).shortValue();
                }
            } else if (objectArray[0] instanceof DevState) {
                for (int i = 0; i < objectArray.length; ++i) {
                    sArray[i] = Integer.valueOf(((DevState)objectArray[i]).value()).shortValue();
                }
            } else {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + objectArray[0].getClass() + " not supported", "AttributeHelper.extractToShortArray(Object value,deviceAttributeWritten)");
            }
        }
        return sArray;
    }

    public static String[] extractToStringArray(DeviceAttribute deviceAttribute) throws DevFailed {
        Object[] objectArray = AttributeHelper.extractArray(deviceAttribute);
        if (objectArray == null) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output is empty ", "AttributeHelper.extractToStringArray(deviceAttributeWritten)");
        }
        String[] stringArray = new String[objectArray.length];
        if (objectArray.length > 0) {
            if (objectArray[0] instanceof Short) {
                for (int i = 0; i < objectArray.length; ++i) {
                    stringArray[i] = ((Short)objectArray[i]).toString();
                }
            } else if (objectArray[0] instanceof String) {
                for (int i = 0; i < objectArray.length; ++i) {
                    stringArray[i] = (String)objectArray[i];
                }
            } else if (objectArray[0] instanceof Integer) {
                for (int i = 0; i < objectArray.length; ++i) {
                    stringArray[i] = ((Integer)objectArray[i]).toString();
                }
            } else if (objectArray[0] instanceof Long) {
                for (int i = 0; i < objectArray.length; ++i) {
                    stringArray[i] = ((Long)objectArray[i]).toString();
                }
            } else if (objectArray[0] instanceof Float) {
                for (int i = 0; i < objectArray.length; ++i) {
                    stringArray[i] = ((Float)objectArray[i]).toString();
                }
            } else if (objectArray[0] instanceof Boolean) {
                for (int i = 0; i < objectArray.length; ++i) {
                    stringArray[i] = ((Boolean)objectArray[i]).toString();
                }
            } else if (objectArray[0] instanceof Double) {
                for (int i = 0; i < objectArray.length; ++i) {
                    stringArray[i] = ((Double)objectArray[i]).toString();
                }
            } else if (objectArray[0] instanceof Byte) {
                for (int i = 0; i < objectArray.length; ++i) {
                    stringArray[i] = ((Byte)objectArray[i]).toString();
                }
            } else if (objectArray[0] instanceof DevState) {
                for (int i = 0; i < objectArray.length; ++i) {
                    stringArray[i] = StateUtilities.getNameForState((DevState)objectArray[0]);
                }
            } else {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + objectArray[0].getClass() + " not supported", "AttributeHelper.extractToStringArray(Object value,deviceAttributeWritten)");
            }
        }
        return stringArray;
    }

    public static int[] extractToIntegerArray(DeviceAttribute deviceAttribute) throws DevFailed {
        Object[] objectArray = AttributeHelper.extractArray(deviceAttribute);
        if (objectArray == null) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output is empty ", "AttributeHelper.extractToIntegerArray(deviceAttributeWritten)");
        }
        int[] nArray = new int[objectArray.length];
        if (objectArray.length > 0) {
            if (objectArray[0] instanceof Short) {
                for (int i = 0; i < objectArray.length; ++i) {
                    nArray[i] = ((Short)objectArray[i]).intValue();
                }
            } else if (objectArray[0] instanceof String) {
                try {
                    for (int i = 0; i < objectArray.length; ++i) {
                        nArray[i] = Integer.valueOf((String)objectArray[i]);
                    }
                }
                catch (Exception exception) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type not numerical", "AttributeHelper.extractToIntegerArray(deviceAttributeWritten)");
                }
            } else if (objectArray[0] instanceof Integer) {
                for (int i = 0; i < objectArray.length; ++i) {
                    nArray[i] = (Integer)objectArray[i];
                }
            } else if (objectArray[0] instanceof Long) {
                for (int i = 0; i < objectArray.length; ++i) {
                    nArray[i] = ((Long)objectArray[i]).intValue();
                }
            } else if (objectArray[0] instanceof Float) {
                for (int i = 0; i < objectArray.length; ++i) {
                    nArray[i] = ((Float)objectArray[i]).intValue();
                }
            } else if (objectArray[0] instanceof Boolean) {
                for (int i = 0; i < objectArray.length; ++i) {
                    nArray[i] = (Boolean)objectArray[i] != false ? 1 : 0;
                }
            } else if (objectArray[0] instanceof Double) {
                for (int i = 0; i < objectArray.length; ++i) {
                    nArray[i] = ((Double)objectArray[i]).intValue();
                }
            } else if (objectArray[0] instanceof Byte) {
                for (int i = 0; i < objectArray.length; ++i) {
                    nArray[i] = ((Byte)objectArray[i]).intValue();
                }
            } else if (objectArray[0] instanceof DevState) {
                for (int i = 0; i < objectArray.length; ++i) {
                    nArray[i] = ((DevState)objectArray[i]).value();
                }
            } else {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + objectArray[0].getClass() + " not supported", "AttributeHelper.extractToIntegerArray(Object value,deviceAttributeWritten)");
            }
        }
        return nArray;
    }

    public static long[] extractToLongArray(DeviceAttribute deviceAttribute) throws DevFailed {
        Object[] objectArray = AttributeHelper.extractArray(deviceAttribute);
        if (objectArray == null) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output is empty ", "AttributeHelper.extractToLongArray(deviceAttributeWritten)");
        }
        long[] lArray = new long[objectArray.length];
        if (objectArray.length > 0) {
            if (objectArray[0] instanceof Short) {
                for (int i = 0; i < objectArray.length; ++i) {
                    lArray[i] = ((Short)objectArray[i]).longValue();
                }
            } else if (objectArray[0] instanceof String) {
                try {
                    for (int i = 0; i < objectArray.length; ++i) {
                        lArray[i] = Long.valueOf((String)objectArray[i]);
                    }
                }
                catch (Exception exception) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type not numerical", "AttributeHelper.extractToLongArray(deviceAttributeWritten)");
                }
            } else if (objectArray[0] instanceof Integer) {
                for (int i = 0; i < objectArray.length; ++i) {
                    lArray[i] = ((Integer)objectArray[i]).longValue();
                }
            } else if (objectArray[0] instanceof Long) {
                for (int i = 0; i < objectArray.length; ++i) {
                    lArray[i] = (Long)objectArray[i];
                }
            } else if (objectArray[0] instanceof Float) {
                for (int i = 0; i < objectArray.length; ++i) {
                    lArray[i] = ((Float)objectArray[i]).longValue();
                }
            } else if (objectArray[0] instanceof Boolean) {
                for (int i = 0; i < objectArray.length; ++i) {
                    lArray[i] = (Boolean)objectArray[i] != false ? 1L : 0L;
                }
            } else if (objectArray[0] instanceof Double) {
                for (int i = 0; i < objectArray.length; ++i) {
                    lArray[i] = ((Double)objectArray[i]).longValue();
                }
            } else if (objectArray[0] instanceof Byte) {
                for (int i = 0; i < objectArray.length; ++i) {
                    lArray[i] = ((Byte)objectArray[i]).longValue();
                }
            } else if (objectArray[0] instanceof DevState) {
                for (int i = 0; i < objectArray.length; ++i) {
                    lArray[i] = Integer.valueOf(((DevState)objectArray[i]).value()).longValue();
                }
            } else {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + objectArray[0].getClass() + " not supported", "AttributeHelper.extractToLongArray(Object value,deviceAttributeWritten)");
            }
        }
        return lArray;
    }

    public static float[] extractToFloatArray(DeviceAttribute deviceAttribute) throws DevFailed {
        Object[] objectArray = AttributeHelper.extractArray(deviceAttribute);
        if (objectArray == null) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output is empty ", "AttributeHelper.extractToFloatArray(deviceAttributeWritten)");
        }
        float[] fArray = new float[objectArray.length];
        if (objectArray.length > 0) {
            if (objectArray[0] instanceof Short) {
                for (int i = 0; i < objectArray.length; ++i) {
                    fArray[i] = ((Short)objectArray[i]).floatValue();
                }
            } else if (objectArray[0] instanceof String) {
                try {
                    for (int i = 0; i < objectArray.length; ++i) {
                        fArray[i] = Float.valueOf((String)objectArray[i]).floatValue();
                    }
                }
                catch (Exception exception) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type not numerical", "AttributeHelper.extractToFloatArray(deviceAttributeWritten)");
                }
            } else if (objectArray[0] instanceof Integer) {
                for (int i = 0; i < objectArray.length; ++i) {
                    fArray[i] = ((Integer)objectArray[i]).floatValue();
                }
            } else if (objectArray[0] instanceof Long) {
                for (int i = 0; i < objectArray.length; ++i) {
                    fArray[i] = ((Long)objectArray[i]).floatValue();
                }
            } else if (objectArray[0] instanceof Float) {
                for (int i = 0; i < objectArray.length; ++i) {
                    fArray[i] = ((Float)objectArray[i]).floatValue();
                }
            } else if (objectArray[0] instanceof Boolean) {
                for (int i = 0; i < objectArray.length; ++i) {
                    fArray[i] = (Boolean)objectArray[i] != false ? 1.0f : 0.0f;
                }
            } else if (objectArray[0] instanceof Double) {
                for (int i = 0; i < objectArray.length; ++i) {
                    fArray[i] = ((Double)objectArray[i]).floatValue();
                }
            } else if (objectArray[0] instanceof Byte) {
                for (int i = 0; i < objectArray.length; ++i) {
                    fArray[i] = ((Byte)objectArray[i]).floatValue();
                }
            } else if (objectArray[0] instanceof DevState) {
                for (int i = 0; i < objectArray.length; ++i) {
                    fArray[i] = Integer.valueOf(((DevState)objectArray[i]).value()).floatValue();
                }
            } else {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + objectArray[0].getClass() + " not supported", "AttributeHelper.extractToFloatArray(Object value,deviceAttributeWritten)");
            }
        }
        return fArray;
    }

    public static boolean[] extractToBooleanArray(DeviceAttribute deviceAttribute) throws DevFailed {
        Object[] objectArray = AttributeHelper.extractArray(deviceAttribute);
        if (objectArray == null) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output is empty ", "AttributeHelper.extractToBooleanArray(deviceAttributeWritten)");
        }
        boolean[] blArray = new boolean[objectArray.length];
        if (objectArray.length > 0) {
            if (objectArray[0] instanceof Short) {
                for (int i = 0; i < objectArray.length; ++i) {
                    blArray[i] = ((Short)objectArray[i]).intValue() == 1;
                }
            } else if (objectArray[0] instanceof String) {
                try {
                    for (int i = 0; i < objectArray.length; ++i) {
                        blArray[i] = Boolean.getBoolean((String)objectArray[i]);
                    }
                }
                catch (Exception exception) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type not numerical", "AttributeHelper.extractToBooleanArray(deviceAttributeWritten)");
                }
            } else if (objectArray[0] instanceof Integer) {
                for (int i = 0; i < objectArray.length; ++i) {
                    blArray[i] = (Integer)objectArray[i] == 1;
                }
            } else if (objectArray[0] instanceof Long) {
                for (int i = 0; i < objectArray.length; ++i) {
                    blArray[i] = ((Long)objectArray[i]).intValue() == 1;
                }
            } else if (objectArray[0] instanceof Float) {
                for (int i = 0; i < objectArray.length; ++i) {
                    blArray[i] = ((Float)objectArray[i]).intValue() == 1;
                }
            } else if (objectArray[0] instanceof Boolean) {
                for (int i = 0; i < objectArray.length; ++i) {
                    blArray[i] = (Boolean)objectArray[i];
                }
            } else if (objectArray[0] instanceof Double) {
                for (int i = 0; i < objectArray.length; ++i) {
                    blArray[i] = ((Double)objectArray[i]).intValue() == 1;
                }
            } else if (objectArray[0] instanceof Byte) {
                for (int i = 0; i < objectArray.length; ++i) {
                    blArray[i] = ((Byte)objectArray[i]).intValue() == 1;
                }
            } else if (objectArray[0] instanceof DevState) {
                for (int i = 0; i < objectArray.length; ++i) {
                    blArray[i] = ((DevState)objectArray[i]).value() == 1;
                }
            } else {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + objectArray[0].getClass() + " not supported", "AttributeHelper.extractToBooleanArray(Object value,deviceAttributeWritten)");
            }
        }
        return blArray;
    }

    public static byte[] extractToByteArray(DeviceAttribute deviceAttribute) throws DevFailed {
        Object[] objectArray = AttributeHelper.extractArray(deviceAttribute);
        if (objectArray == null) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output is empty ", "AttributeHelper.extractToFloatArray(deviceAttributeWritten)");
        }
        byte[] byArray = new byte[objectArray.length];
        if (objectArray.length > 0) {
            if (objectArray[0] instanceof Short) {
                for (int i = 0; i < objectArray.length; ++i) {
                    byArray[i] = ((Short)objectArray[i]).byteValue();
                }
            } else if (objectArray[0] instanceof String) {
                try {
                    for (int i = 0; i < objectArray.length; ++i) {
                        byArray[i] = Float.valueOf((String)objectArray[i]).byteValue();
                    }
                }
                catch (Exception exception) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type not numerical", "AttributeHelper.extractToFloatArray(deviceAttributeWritten)");
                }
            } else if (objectArray[0] instanceof Integer) {
                for (int i = 0; i < objectArray.length; ++i) {
                    byArray[i] = ((Integer)objectArray[i]).byteValue();
                }
            } else if (objectArray[0] instanceof Long) {
                for (int i = 0; i < objectArray.length; ++i) {
                    byArray[i] = ((Long)objectArray[i]).byteValue();
                }
            } else if (objectArray[0] instanceof Float) {
                for (int i = 0; i < objectArray.length; ++i) {
                    byArray[i] = ((Float)objectArray[i]).byteValue();
                }
            } else if (objectArray[0] instanceof Boolean) {
                for (int i = 0; i < objectArray.length; ++i) {
                    byArray[i] = (Boolean)objectArray[i] != false ? (byte)1 : 0;
                }
            } else if (objectArray[0] instanceof Double) {
                for (int i = 0; i < objectArray.length; ++i) {
                    byArray[i] = ((Double)objectArray[i]).byteValue();
                }
            } else if (objectArray[0] instanceof Byte) {
                for (int i = 0; i < objectArray.length; ++i) {
                    byArray[i] = (Byte)objectArray[i];
                }
            } else if (objectArray[0] instanceof DevState) {
                for (int i = 0; i < objectArray.length; ++i) {
                    byArray[i] = Integer.valueOf(((DevState)objectArray[i]).value()).byteValue();
                }
            } else {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + objectArray[0].getClass() + " not supported", "AttributeHelper.extractToFloatArray(Object value,deviceAttributeWritten)");
            }
        }
        return byArray;
    }

    public static double[] extractToDoubleArray(DeviceAttribute deviceAttribute) throws DevFailed {
        Object[] objectArray = AttributeHelper.extractArray(deviceAttribute);
        if (objectArray == null) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output is empty ", "AttributeHelper.extractToDoubleArray(deviceAttributeWritten)");
        }
        double[] dArray = new double[objectArray.length];
        if (objectArray.length > 0) {
            if (objectArray[0] instanceof Short) {
                for (int i = 0; i < objectArray.length; ++i) {
                    dArray[i] = ((Short)objectArray[i]).doubleValue();
                }
            } else if (objectArray[0] instanceof String) {
                try {
                    for (int i = 0; i < objectArray.length; ++i) {
                        dArray[i] = Double.valueOf((String)objectArray[i]);
                    }
                }
                catch (Exception exception) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type not numerical", "AttributeHelper.extractToDoubleArray(deviceAttributeWritten)");
                }
            } else if (objectArray[0] instanceof Integer) {
                for (int i = 0; i < objectArray.length; ++i) {
                    dArray[i] = ((Integer)objectArray[i]).doubleValue();
                }
            } else if (objectArray[0] instanceof Long) {
                for (int i = 0; i < objectArray.length; ++i) {
                    dArray[i] = ((Long)objectArray[i]).doubleValue();
                }
            } else if (objectArray[0] instanceof Float) {
                for (int i = 0; i < objectArray.length; ++i) {
                    dArray[i] = ((Float)objectArray[i]).doubleValue();
                }
            } else if (objectArray[0] instanceof Boolean) {
                for (int i = 0; i < objectArray.length; ++i) {
                    dArray[i] = (Boolean)objectArray[i] != false ? 1.0 : 0.0;
                }
            } else if (objectArray[0] instanceof Double) {
                for (int i = 0; i < objectArray.length; ++i) {
                    dArray[i] = (Double)objectArray[i];
                }
            } else if (objectArray[0] instanceof Byte) {
                for (int i = 0; i < objectArray.length; ++i) {
                    dArray[i] = ((Byte)objectArray[i]).doubleValue();
                }
            } else if (objectArray[0] instanceof DevState) {
                for (int i = 0; i < objectArray.length; ++i) {
                    dArray[i] = Integer.valueOf(((DevState)objectArray[i]).value()).doubleValue();
                }
            } else {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + objectArray[0].getClass() + " not supported", "AttributeHelper.extractToDoubleArray(Object value,deviceAttributeWritten)");
            }
        }
        return dArray;
    }

    public static DevState[] extractToDevStateArray(DeviceAttribute deviceAttribute) throws DevFailed {
        Object[] objectArray = AttributeHelper.extractArray(deviceAttribute);
        if (objectArray == null) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output is empty ", "AttributeHelper.extractToFloatArray(deviceAttributeWritten)");
        }
        DevState[] devStateArray = new DevState[objectArray.length];
        if (objectArray.length > 0) {
            if (objectArray[0] instanceof Short) {
                for (int i = 0; i < objectArray.length; ++i) {
                    try {
                        devStateArray[i] = DevState.from_int(((Short)objectArray[i]).intValue());
                        continue;
                    }
                    catch (Exception exception) {
                        devStateArray[i] = DevState.UNKNOWN;
                    }
                }
            } else if (objectArray[0] instanceof String) {
                for (int i = 0; i < objectArray.length; ++i) {
                    devStateArray[i] = StateUtilities.getStateForName((String)objectArray[i]);
                }
            } else if (objectArray[0] instanceof Integer) {
                for (int i = 0; i < objectArray.length; ++i) {
                    try {
                        devStateArray[i] = DevState.from_int((Integer)objectArray[i]);
                        continue;
                    }
                    catch (Exception exception) {
                        devStateArray[i] = DevState.UNKNOWN;
                    }
                }
            } else if (objectArray[0] instanceof Long) {
                for (int i = 0; i < objectArray.length; ++i) {
                    try {
                        devStateArray[i] = DevState.from_int(((Long)objectArray[i]).intValue());
                        continue;
                    }
                    catch (Exception exception) {
                        devStateArray[i] = DevState.UNKNOWN;
                    }
                }
            } else if (objectArray[0] instanceof Float) {
                for (int i = 0; i < objectArray.length; ++i) {
                    try {
                        devStateArray[i] = DevState.from_int(((Float)objectArray[i]).intValue());
                        continue;
                    }
                    catch (Exception exception) {
                        devStateArray[i] = DevState.UNKNOWN;
                    }
                }
            } else if (objectArray[0] instanceof Boolean) {
                for (int i = 0; i < objectArray.length; ++i) {
                    try {
                        if (((Boolean)objectArray[i]).booleanValue()) {
                            devStateArray[i] = DevState.from_int(1);
                            continue;
                        }
                        devStateArray[i] = DevState.from_int(0);
                        continue;
                    }
                    catch (Exception exception) {
                        devStateArray[i] = DevState.UNKNOWN;
                    }
                }
            } else if (objectArray[0] instanceof Double) {
                for (int i = 0; i < objectArray.length; ++i) {
                    try {
                        devStateArray[i] = DevState.from_int(((Double)objectArray[i]).intValue());
                        continue;
                    }
                    catch (Exception exception) {
                        devStateArray[i] = DevState.UNKNOWN;
                    }
                }
            } else if (objectArray[0] instanceof Byte) {
                for (int i = 0; i < objectArray.length; ++i) {
                    try {
                        devStateArray[i] = DevState.from_int(((Byte)objectArray[i]).intValue());
                        continue;
                    }
                    catch (Exception exception) {
                        devStateArray[i] = DevState.UNKNOWN;
                    }
                }
            } else if (objectArray[0] instanceof DevState) {
                for (int i = 0; i < objectArray.length; ++i) {
                    devStateArray[i] = (DevState)objectArray[i];
                }
            } else {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + objectArray[0].getClass() + " not supported", "AttributeHelper.extractToFloatArray(Object value,deviceAttributeWritten)");
            }
        }
        return devStateArray;
    }

    public static void insertFromShortArray(short[] sArray, DeviceAttribute deviceAttribute, int n, int n2) throws DevFailed {
        Double d = new Double(0.0);
        for (int i = 0; i < sArray.length; ++i) {
            d = d + (double)sArray[i];
        }
        if (sArray.length > n * n2) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "size of array " + sArray.length + " is too great", "AttributeHelper.insertFromShortArray(short[] values,deviceAttributeWritten)");
        }
        switch (deviceAttribute.getType()) {
            case 2: {
                deviceAttribute.insert(d.shortValue());
                break;
            }
            case 6: {
                deviceAttribute.insert_us(d.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "AttributeHelper.insertFromShortArray(short[] values,deviceAttributeWritten)");
                break;
            }
            case 22: {
                deviceAttribute.insert_uc(d.shortValue());
                break;
            }
            case 3: {
                deviceAttribute.insert(d.intValue());
                break;
            }
            case 7: {
                deviceAttribute.insert_ul(d.longValue());
                break;
            }
            case 23: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_LONG64 not supported", "AttributeHelper.insertFromShort(short[] values,deviceAttributeWritten)");
                break;
            }
            case 24: {
                deviceAttribute.insert_u64(d.longValue());
                break;
            }
            case 27: {
                deviceAttribute.insert(d.intValue());
                break;
            }
            case 4: {
                deviceAttribute.insert(d.floatValue());
                break;
            }
            case 5: {
                deviceAttribute.insert(d);
                break;
            }
            case 8: {
                deviceAttribute.insert(d.toString());
                break;
            }
            case 1: {
                if (d == 1.0) {
                    deviceAttribute.insert(true);
                    break;
                }
                deviceAttribute.insert(false);
                break;
            }
            case 19: {
                DevState[] devStateArray = new DevState[sArray.length];
                for (int i = 0; i < sArray.length; ++i) {
                    try {
                        devStateArray[i] = DevState.from_int(Short.valueOf(sArray[i]).intValue());
                        continue;
                    }
                    catch (BAD_PARAM bAD_PARAM) {
                        devStateArray[i] = DevState.UNKNOWN;
                    }
                }
                deviceAttribute.insert(devStateArray);
                break;
            }
            case 10: {
                if (n2 == 0) {
                    deviceAttribute.insert(sArray);
                    break;
                }
                deviceAttribute.insert(sArray, n, n2);
                break;
            }
            case 14: {
                if (n2 == 0) {
                    deviceAttribute.insert_uc(sArray);
                    break;
                }
                deviceAttribute.insert_uc(sArray, n, n2);
                break;
            }
            case 9: {
                byte[] byArray = new byte[sArray.length];
                for (int i = 0; i < sArray.length; ++i) {
                    byArray[i] = Short.valueOf(sArray[i]).byteValue();
                }
                deviceAttribute.insert_uc(byArray, n, n2);
                break;
            }
            case 11: {
                int[] nArray = new int[sArray.length];
                for (int i = 0; i < sArray.length; ++i) {
                    nArray[i] = Short.valueOf(sArray[i]).intValue();
                }
                if (n2 == 0) {
                    deviceAttribute.insert(nArray);
                    break;
                }
                deviceAttribute.insert(nArray, n, n2);
                break;
            }
            case 15: {
                long[] lArray = new long[sArray.length];
                for (int i = 0; i < sArray.length; ++i) {
                    lArray[i] = Short.valueOf(sArray[i]).longValue();
                }
                if (n2 == 0) {
                    deviceAttribute.insert_ul(lArray);
                    break;
                }
                deviceAttribute.insert_ul(lArray, n, n2);
                break;
            }
            case 25: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEVVAR_LONG64ARRAY not supported", "AttributeHelper.insertFromShortArray(short[] values,deviceAttributeWritten)");
                break;
            }
            case 26: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEVVAR_ULONG64ARRAY not supported", "AttributeHelper.insertFromShortArray(short[] values,deviceAttributeWritten)");
                break;
            }
            case 12: {
                float[] fArray = new float[sArray.length];
                for (int i = 0; i < sArray.length; ++i) {
                    fArray[i] = Short.valueOf(sArray[i]).floatValue();
                }
                if (n2 == 0) {
                    deviceAttribute.insert(fArray);
                    break;
                }
                deviceAttribute.insert(fArray, n, n2);
                break;
            }
            case 13: {
                double[] dArray = new double[sArray.length];
                for (int i = 0; i < sArray.length; ++i) {
                    dArray[i] = Short.valueOf(sArray[i]).doubleValue();
                }
                if (n2 == 0) {
                    deviceAttribute.insert(dArray);
                    break;
                }
                deviceAttribute.insert(dArray, n, n2);
                break;
            }
            case 16: {
                String[] stringArray = new String[sArray.length];
                for (int i = 0; i < sArray.length; ++i) {
                    stringArray[i] = Short.valueOf(sArray[i]).toString();
                }
                if (n2 == 0) {
                    deviceAttribute.insert(stringArray);
                    break;
                }
                deviceAttribute.insert(stringArray, n, n2);
                break;
            }
            case 17: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEVVAR_LONGSTRINGARRAY not supported", "AttributeHelper.insertFromShortArray(short[] values,deviceAttributeWritten)");
                break;
            }
            case 18: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEVVAR_DOUBLESTRINGARRAY not supported", "AttributeHelper.insertFromShortArray(short[] values,deviceAttributeWritten)");
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceAttribute.getType() + " not supported", "AttributeHelper.insertFromShortArray(short[] values,deviceAttributeWritten)");
            }
        }
    }

    public static void insertFromStringArray(String[] stringArray, DeviceAttribute deviceAttribute, int n, int n2) throws DevFailed {
        String string = "";
        Double d = Double.NaN;
        try {
            d = Double.valueOf(string);
        }
        catch (Exception exception) {
            d = Double.NaN;
        }
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        if (stringArray.length > n * n2) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "size of array " + stringArray.length + " is too great", "AttributeHelper.insertFromShortArray(String[] values,deviceAttributeWritten)");
        }
        switch (deviceAttribute.getType()) {
            case 2: {
                if (!d.isNaN()) {
                    deviceAttribute.insert(d.shortValue());
                    break;
                }
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", string + " is not a Tango_DEV_SHORT", "AttributeHelper.insertFromStringArray(String[] values,deviceAttributeWritten)");
                break;
            }
            case 6: {
                if (!d.isNaN()) {
                    deviceAttribute.insert_us(d.shortValue());
                    break;
                }
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", string + " is not a Tango_DEV_USHORT", "AttributeHelper.insertFromStringArray(String[] values,deviceAttributeWritten)");
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "AttributeHelper.insertFromStringArray(String[] values,deviceAttributeWritten)");
                break;
            }
            case 22: {
                if (!d.isNaN()) {
                    deviceAttribute.insert_uc(d.shortValue());
                    break;
                }
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", string + " is not a Tango_DEV_UCHAR", "AttributeHelper.insertFromStringArray(String[] values,deviceAttributeWritten)");
                break;
            }
            case 3: {
                if (!d.isNaN()) {
                    deviceAttribute.insert(d.intValue());
                    break;
                }
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", string + " is not a Tango_DEV_LONG", "AttributeHelper.insertFromStringArray(String[] values,deviceAttributeWritten)");
                break;
            }
            case 7: {
                if (!d.isNaN()) {
                    deviceAttribute.insert_ul(d.longValue());
                    break;
                }
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", string + " is not a Tango_DEV_ULONG", "AttributeHelper.insertFromStringArray(String[] values,deviceAttributeWritten)");
                break;
            }
            case 23: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_LONG64 not supported", "AttributeHelper.insertFromStringArray(String[] values,deviceAttributeWritten)");
                break;
            }
            case 24: {
                if (!d.isNaN()) {
                    deviceAttribute.insert_u64(d.longValue());
                    break;
                }
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", string + " is not a Tango_DEV_ULONG64", "AttributeHelper.insertFromStringArray(String[] values,deviceAttributeWritten)");
                break;
            }
            case 27: {
                if (!d.isNaN()) {
                    deviceAttribute.insert(d.intValue());
                    break;
                }
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", string + " is not a Tango_DEV_INT", "AttributeHelper.insertFromStringArray(String[] values,deviceAttributeWritten)");
                break;
            }
            case 4: {
                if (!d.isNaN()) {
                    deviceAttribute.insert(d.floatValue());
                    break;
                }
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", string + " is not a Tango_DEV_FLOAT", "AttributeHelper.insertFromStringArray(String[] values,deviceAttributeWritten)");
                break;
            }
            case 5: {
                if (!d.isNaN()) {
                    deviceAttribute.insert(d);
                    break;
                }
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", string + " is not a Tango_DEV_DOUBLE", "AttributeHelper.insertFromStringArray(String[] values,deviceAttributeWritten)");
                break;
            }
            case 8: {
                deviceAttribute.insert(string);
                break;
            }
            case 1: {
                if (!d.isNaN()) {
                    if (d == 1.0) {
                        deviceAttribute.insert(true);
                        break;
                    }
                    deviceAttribute.insert(false);
                    break;
                }
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", string + " is not a Tango_DEV_BOOLEAN", "AttributeHelper.insertFromStringArray(String[] values,deviceAttributeWritten)");
                break;
            }
            case 19: {
                if (!d.isNaN()) {
                    DevState[] devStateArray = new DevState[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        try {
                            devStateArray[i] = DevState.from_int(Short.valueOf(stringArray[i]).intValue());
                            continue;
                        }
                        catch (BAD_PARAM bAD_PARAM) {
                            devStateArray[i] = DevState.UNKNOWN;
                        }
                    }
                    deviceAttribute.insert(devStateArray);
                    break;
                }
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", string + " is not a Tango_DEV_STATE", "AttributeHelper.insertFromStringArray(String[] values,deviceAttributeWritten)");
                break;
            }
            case 10: {
                short[] sArray = new short[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        sArray[i] = Double.valueOf(stringArray[i]).shortValue();
                        continue;
                    }
                    catch (Exception exception) {
                        Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input is not a Tango_DEVVAR_SHORTARRAY", "AttributeHelper.insertFromStringArray(String[] values,deviceAttributeWritten)");
                    }
                }
                if (n2 == 0) {
                    deviceAttribute.insert(sArray);
                    break;
                }
                deviceAttribute.insert(sArray, n, n2);
                break;
            }
            case 14: {
                short[] sArray = new short[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        sArray[i] = Double.valueOf(stringArray[i]).shortValue();
                        continue;
                    }
                    catch (Exception exception) {
                        Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input is not a Tango_DEVVAR_USHORTARRAY", "AttributeHelper.insertFromStringArray(String[] values,deviceAttributeWritten)");
                    }
                }
                if (n2 == 0) {
                    deviceAttribute.insert_uc(sArray);
                    break;
                }
                deviceAttribute.insert_uc(sArray, n, n2);
                break;
            }
            case 9: {
                byte[] byArray = new byte[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        byArray[i] = Double.valueOf(stringArray[i]).byteValue();
                        continue;
                    }
                    catch (Exception exception) {
                        Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input is not a Tango_DEVVAR_CHARARRAY", "AttributeHelper.insertFromStringArray(String[] values,deviceAttributeWritten)");
                    }
                }
                deviceAttribute.insert_uc(byArray, n, n2);
                break;
            }
            case 11: {
                int[] nArray = new int[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        nArray[i] = Double.valueOf(stringArray[i]).intValue();
                        continue;
                    }
                    catch (Exception exception) {
                        Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input is not a Tango_DEVVAR_LONGARRAY", "AttributeHelper.insertFromStringArray(String[] values,deviceAttributeWritten)");
                    }
                }
                if (n2 == 0) {
                    deviceAttribute.insert(nArray);
                    break;
                }
                deviceAttribute.insert(nArray, n, n2);
                break;
            }
            case 15: {
                long[] lArray = new long[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        lArray[i] = Double.valueOf(stringArray[i]).longValue();
                        continue;
                    }
                    catch (Exception exception) {
                        Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input is not a Tango_DEVVAR_LONGARRAY", "AttributeHelper.insertFromStringArray(String[] values,deviceAttributeWritten)");
                    }
                }
                if (n2 == 0) {
                    deviceAttribute.insert_ul(lArray);
                    break;
                }
                deviceAttribute.insert_ul(lArray, n, n2);
                break;
            }
            case 25: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEVVAR_LONG64ARRAY not supported", "AttributeHelper.insertFromStringArray(String[] values,deviceAttributeWritten)");
                break;
            }
            case 26: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEVVAR_ULONG64ARRAY not supported", "AttributeHelper.insertFromStringArray(String[] values,deviceAttributeWritten)");
                break;
            }
            case 12: {
                float[] fArray = new float[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        fArray[i] = Double.valueOf(stringArray[i]).floatValue();
                        continue;
                    }
                    catch (Exception exception) {
                        Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input is not a Tango_DEVVAR_FLOATARRAY", "AttributeHelper.insertFromStringArray(String[] values,deviceAttributeWritten)");
                    }
                }
                if (n2 == 0) {
                    deviceAttribute.insert(fArray);
                    break;
                }
                deviceAttribute.insert(fArray, n, n2);
                break;
            }
            case 13: {
                double[] dArray = new double[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        dArray[i] = Double.valueOf(stringArray[i]);
                        continue;
                    }
                    catch (Exception exception) {
                        Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input is not a Tango_DEVVAR_DOUBLEARRAY", "AttributeHelper.insertFromStringArray(String[] values,deviceAttributeWritten)");
                    }
                }
                if (n2 == 0) {
                    deviceAttribute.insert(dArray);
                    break;
                }
                deviceAttribute.insert(dArray, n, n2);
                break;
            }
            case 16: {
                if (n2 == 0) {
                    deviceAttribute.insert(stringArray);
                    break;
                }
                deviceAttribute.insert(stringArray, n, n2);
                break;
            }
            case 17: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEVVAR_LONGSTRINGARRAY not supported", "AttributeHelper.insertFromStringArray(String[] values,deviceAttributeWritten)");
                break;
            }
            case 18: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEVVAR_DOUBLESTRINGARRAY not supported", "AttributeHelper.insertFromStringArray(String[] values,deviceAttributeWritten)");
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceAttribute.getType() + " not supported", "AttributeHelper.insertFromStringArray(String[] value,deviceAttributeWritten)");
            }
        }
    }

    public static void insertFromIntegerArray(int[] nArray, DeviceAttribute deviceAttribute, int n, int n2) throws DevFailed {
        Double d = new Double(0.0);
        for (int i = 0; i < nArray.length; ++i) {
            d = d + (double)nArray[i];
        }
        if (nArray.length > n * n2) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "size of array " + nArray.length + " is too great", "AttributeHelper.insertFromIntegerArray(int[] values,deviceAttributeWritten)");
        }
        switch (deviceAttribute.getType()) {
            case 2: {
                deviceAttribute.insert(d.shortValue());
                break;
            }
            case 6: {
                deviceAttribute.insert_us(d.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "AttributeHelper.insertFromIntegerArray(int[] values,deviceAttributeWritten)");
                break;
            }
            case 22: {
                deviceAttribute.insert_uc(d.shortValue());
                break;
            }
            case 3: {
                deviceAttribute.insert(d.intValue());
                break;
            }
            case 7: {
                deviceAttribute.insert_ul(d.longValue());
                break;
            }
            case 23: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_LONG64 not supported", "AttributeHelper.insertFromIntegerArray(int[] values,deviceAttributeWritten)");
                break;
            }
            case 24: {
                deviceAttribute.insert_u64(d.longValue());
                break;
            }
            case 27: {
                deviceAttribute.insert(d.intValue());
                break;
            }
            case 4: {
                deviceAttribute.insert(d.floatValue());
                break;
            }
            case 5: {
                deviceAttribute.insert(d);
                break;
            }
            case 8: {
                deviceAttribute.insert(d.toString());
                break;
            }
            case 1: {
                if (d == 1.0) {
                    deviceAttribute.insert(true);
                    break;
                }
                deviceAttribute.insert(false);
                break;
            }
            case 19: {
                DevState[] devStateArray = new DevState[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    try {
                        devStateArray[i] = DevState.from_int(nArray[i]);
                        continue;
                    }
                    catch (BAD_PARAM bAD_PARAM) {
                        devStateArray[i] = DevState.UNKNOWN;
                    }
                }
                deviceAttribute.insert(devStateArray);
                break;
            }
            case 10: {
                short[] sArray = new short[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    sArray[i] = Integer.valueOf(nArray[i]).shortValue();
                }
                if (n2 == 0) {
                    deviceAttribute.insert(sArray);
                    break;
                }
                deviceAttribute.insert(sArray, n, n2);
                break;
            }
            case 14: {
                short[] sArray = new short[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    sArray[i] = Integer.valueOf(nArray[i]).shortValue();
                }
                if (n2 == 0) {
                    deviceAttribute.insert_uc(sArray);
                    break;
                }
                deviceAttribute.insert_uc(sArray, n, n2);
                break;
            }
            case 9: {
                byte[] byArray = new byte[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    byArray[i] = Integer.valueOf(nArray[i]).byteValue();
                }
                deviceAttribute.insert_uc(byArray, n, n2);
                break;
            }
            case 11: {
                long[] lArray = new long[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    lArray[i] = Integer.valueOf(nArray[i]).longValue();
                }
                if (n2 == 0) {
                    deviceAttribute.insert(lArray);
                    break;
                }
                deviceAttribute.insert(lArray, n, n2);
                break;
            }
            case 15: {
                int[] nArray2 = new int[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray2[i] = nArray[i];
                }
                if (n2 == 0) {
                    deviceAttribute.insert_ul(nArray2);
                    break;
                }
                deviceAttribute.insert_ul(nArray2, n, n2);
                break;
            }
            case 25: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEVVAR_LONG64ARRAY not supported", "AttributeHelper.insertFromShortArray(int[] value,deviceAttributeWritten)");
                break;
            }
            case 26: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEVVAR_ULONG64ARRAY not supported", "AttributeHelper.insertFromIntegerArray(int[] values,deviceAttributeWritten)");
                break;
            }
            case 12: {
                float[] fArray = new float[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    fArray[i] = Integer.valueOf(nArray[i]).floatValue();
                }
                if (n2 == 0) {
                    deviceAttribute.insert(fArray);
                    break;
                }
                deviceAttribute.insert(fArray, n, n2);
                break;
            }
            case 13: {
                double[] dArray = new double[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    dArray[i] = Integer.valueOf(nArray[i]).doubleValue();
                }
                if (n2 == 0) {
                    deviceAttribute.insert(dArray);
                    break;
                }
                deviceAttribute.insert(dArray, n, n2);
                break;
            }
            case 16: {
                String[] stringArray = new String[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    stringArray[i] = Integer.valueOf(nArray[i]).toString();
                }
                if (n2 == 0) {
                    deviceAttribute.insert(stringArray);
                    break;
                }
                deviceAttribute.insert(stringArray, n, n2);
                break;
            }
            case 17: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEVVAR_LONGSTRINGARRAY not supported", "AttributeHelper.insertFromIntegerArray(int[] values,deviceAttributeWritten)");
                break;
            }
            case 18: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEVVAR_DOUBLESTRINGARRAY not supported", "AttributeHelper.insertFromIntegerArray(int[] values,deviceAttributeWritten)");
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceAttribute.getType() + " not supported", "AttributeHelper.insertFromIntegerArray(int[] values,deviceAttributeWritten)");
            }
        }
    }

    public static void insertFromLongArray(long[] lArray, DeviceAttribute deviceAttribute, int n, int n2) throws DevFailed {
        Double d = new Double(0.0);
        for (int i = 0; i < lArray.length; ++i) {
            d = d + (double)lArray[i];
        }
        if (lArray.length > n * n2) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "size of array " + lArray.length + " is too great", "AttributeHelper.insertFromLongArray(long[] values,deviceAttributeWritten)");
        }
        switch (deviceAttribute.getType()) {
            case 2: {
                deviceAttribute.insert(d.shortValue());
                break;
            }
            case 6: {
                deviceAttribute.insert_us(d.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "AttributeHelper.insertFromLongArray(long[] values,deviceAttributeWritten)");
                break;
            }
            case 22: {
                deviceAttribute.insert_uc(d.shortValue());
                break;
            }
            case 3: {
                deviceAttribute.insert(d.intValue());
                break;
            }
            case 7: {
                deviceAttribute.insert_ul(d.longValue());
                break;
            }
            case 23: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_LONG64 not supported", "AttributeHelper.insertFromIntegerArray(long[] values,deviceAttributeWritten)");
                break;
            }
            case 24: {
                deviceAttribute.insert_u64(d.longValue());
                break;
            }
            case 27: {
                deviceAttribute.insert(d.intValue());
                break;
            }
            case 4: {
                deviceAttribute.insert(d.floatValue());
                break;
            }
            case 5: {
                deviceAttribute.insert(d);
                break;
            }
            case 8: {
                deviceAttribute.insert(d.toString());
                break;
            }
            case 1: {
                if (d == 1.0) {
                    deviceAttribute.insert(true);
                    break;
                }
                deviceAttribute.insert(false);
                break;
            }
            case 19: {
                DevState[] devStateArray = new DevState[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    try {
                        devStateArray[i] = DevState.from_int(Long.valueOf(lArray[i]).intValue());
                        continue;
                    }
                    catch (BAD_PARAM bAD_PARAM) {
                        devStateArray[i] = DevState.UNKNOWN;
                    }
                }
                deviceAttribute.insert(devStateArray);
                break;
            }
            case 10: {
                short[] sArray = new short[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    sArray[i] = Long.valueOf(lArray[i]).shortValue();
                }
                if (n2 == 0) {
                    deviceAttribute.insert(sArray);
                    break;
                }
                deviceAttribute.insert(sArray, n, n2);
                break;
            }
            case 14: {
                short[] sArray = new short[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    sArray[i] = Long.valueOf(lArray[i]).shortValue();
                }
                if (n2 == 0) {
                    deviceAttribute.insert_uc(sArray);
                    break;
                }
                deviceAttribute.insert_uc(sArray, n, n2);
                break;
            }
            case 9: {
                byte[] byArray = new byte[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    byArray[i] = Long.valueOf(lArray[i]).byteValue();
                }
                deviceAttribute.insert_uc(byArray, n, n2);
                break;
            }
            case 11: {
                int[] nArray = new int[lArray.length];
                if (n2 == 0) {
                    deviceAttribute.insert(nArray);
                    break;
                }
                deviceAttribute.insert(nArray, n, n2);
                break;
            }
            case 15: {
                if (n2 == 0) {
                    deviceAttribute.insert_ul(lArray);
                    break;
                }
                deviceAttribute.insert_ul(lArray, n, n2);
                break;
            }
            case 25: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEVVAR_LONG64ARRAY not supported", "AttributeHelper.insertFromLongArray(long[] values,deviceAttributeWritten)");
                break;
            }
            case 26: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEVVAR_ULONG64ARRAY not supported", "AttributeHelper.insertFromLongArray(long[] values,deviceAttributeWritten)");
                break;
            }
            case 12: {
                float[] fArray = new float[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    fArray[i] = Long.valueOf(lArray[i]).floatValue();
                }
                if (n2 == 0) {
                    deviceAttribute.insert(fArray);
                    break;
                }
                deviceAttribute.insert(fArray, n, n2);
                break;
            }
            case 13: {
                double[] dArray = new double[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    dArray[i] = Long.valueOf(lArray[i]).doubleValue();
                }
                if (n2 == 0) {
                    deviceAttribute.insert(dArray);
                    break;
                }
                deviceAttribute.insert(dArray, n, n2);
                break;
            }
            case 16: {
                String[] stringArray = new String[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    stringArray[i] = Long.valueOf(lArray[i]).toString();
                }
                if (n2 == 0) {
                    deviceAttribute.insert(stringArray);
                    break;
                }
                deviceAttribute.insert(stringArray, n, n2);
                break;
            }
            case 17: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEVVAR_LONGSTRINGARRAY not supported", "AttributeHelper.insertFromLongArray(long[] values,deviceAttributeWritten)");
                break;
            }
            case 18: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEVVAR_DOUBLESTRINGARRAY not supported", "AttributeHelper.insertFromLongArray(long[] values,deviceAttributeWritten)");
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceAttribute.getType() + " not supported", "AttributeHelper.insertFromLongArray(long[] values,deviceAttributeWritten)");
            }
        }
    }

    public static void insertFromFloatArray(float[] fArray, DeviceAttribute deviceAttribute, int n, int n2) throws DevFailed {
        Double d = new Double(0.0);
        for (int i = 0; i < fArray.length; ++i) {
            d = d + (double)fArray[i];
        }
        if (fArray.length > n * n2) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "size of array " + fArray.length + " is too great", "AttributeHelper.insertFromFloatArray(float[] values,deviceAttributeWritten)");
        }
        switch (deviceAttribute.getType()) {
            case 2: {
                deviceAttribute.insert(d.shortValue());
                break;
            }
            case 6: {
                deviceAttribute.insert_us(d.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "AttributeHelper.insertFromFloatArray(float[] values,deviceAttributeWritten)");
                break;
            }
            case 22: {
                deviceAttribute.insert_uc(d.shortValue());
                break;
            }
            case 3: {
                deviceAttribute.insert(d.intValue());
                break;
            }
            case 7: {
                deviceAttribute.insert_ul(d.longValue());
                break;
            }
            case 23: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_LONG64 not supported", "AttributeHelper.insertFromFloatArray(float[] values,deviceAttributeWritten)");
                break;
            }
            case 24: {
                deviceAttribute.insert_u64(d.longValue());
                break;
            }
            case 27: {
                deviceAttribute.insert(d.intValue());
                break;
            }
            case 4: {
                deviceAttribute.insert(d.floatValue());
                break;
            }
            case 5: {
                deviceAttribute.insert(d);
                break;
            }
            case 8: {
                deviceAttribute.insert(d.toString());
                break;
            }
            case 1: {
                if (d == 1.0) {
                    deviceAttribute.insert(true);
                    break;
                }
                deviceAttribute.insert(false);
                break;
            }
            case 19: {
                DevState[] devStateArray = new DevState[fArray.length];
                for (int i = 0; i < fArray.length; ++i) {
                    try {
                        devStateArray[i] = DevState.from_int(Float.valueOf(fArray[i]).intValue());
                        continue;
                    }
                    catch (BAD_PARAM bAD_PARAM) {
                        devStateArray[i] = DevState.UNKNOWN;
                    }
                }
                deviceAttribute.insert(devStateArray);
                break;
            }
            case 10: {
                short[] sArray = new short[fArray.length];
                for (int i = 0; i < fArray.length; ++i) {
                    sArray[i] = Float.valueOf(fArray[i]).shortValue();
                }
                if (n2 == 0) {
                    deviceAttribute.insert(sArray);
                    break;
                }
                deviceAttribute.insert(sArray, n, n2);
                break;
            }
            case 14: {
                short[] sArray = new short[fArray.length];
                for (int i = 0; i < fArray.length; ++i) {
                    sArray[i] = Float.valueOf(fArray[i]).shortValue();
                }
                if (n2 == 0) {
                    deviceAttribute.insert_uc(sArray);
                    break;
                }
                deviceAttribute.insert_uc(sArray, n, n2);
                break;
            }
            case 9: {
                byte[] byArray = new byte[fArray.length];
                for (int i = 0; i < fArray.length; ++i) {
                    byArray[i] = Float.valueOf(fArray[i]).byteValue();
                }
                deviceAttribute.insert_uc(byArray, n, n2);
                break;
            }
            case 11: {
                int[] nArray = new int[fArray.length];
                for (int i = 0; i < fArray.length; ++i) {
                    nArray[i] = Float.valueOf(fArray[i]).intValue();
                }
                if (n2 == 0) {
                    deviceAttribute.insert(nArray);
                    break;
                }
                deviceAttribute.insert(nArray, n, n2);
                break;
            }
            case 15: {
                long[] lArray = new long[fArray.length];
                for (int i = 0; i < fArray.length; ++i) {
                    lArray[i] = Float.valueOf(fArray[i]).longValue();
                }
                if (n2 == 0) {
                    deviceAttribute.insert_ul(lArray);
                    break;
                }
                deviceAttribute.insert_ul(lArray, n, n2);
                break;
            }
            case 25: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEVVAR_LONG64ARRAY not supported", "AttributeHelper.insertFromFloatArray(float[] values,deviceAttributeWritten)");
                break;
            }
            case 26: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEVVAR_ULONG64ARRAY not supported", "AttributeHelper.insertFromFloatArray(long[] values,deviceAttributeWritten)");
                break;
            }
            case 12: {
                if (n2 == 0) {
                    deviceAttribute.insert(fArray);
                    break;
                }
                deviceAttribute.insert(fArray, n, n2);
                break;
            }
            case 13: {
                double[] dArray = new double[fArray.length];
                for (int i = 0; i < fArray.length; ++i) {
                    dArray[i] = Float.valueOf(fArray[i]).doubleValue();
                }
                if (n2 == 0) {
                    deviceAttribute.insert(dArray);
                    break;
                }
                deviceAttribute.insert(dArray, n, n2);
                break;
            }
            case 16: {
                String[] stringArray = new String[fArray.length];
                for (int i = 0; i < fArray.length; ++i) {
                    stringArray[i] = Float.valueOf(fArray[i]).toString();
                }
                if (n2 == 0) {
                    deviceAttribute.insert(stringArray);
                    break;
                }
                deviceAttribute.insert(stringArray, n, n2);
                break;
            }
            case 17: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEVVAR_LONGSTRINGARRAY not supported", "AttributeHelper.insertFromFloatArray(float[] values,deviceAttributeWritten)");
                break;
            }
            case 18: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEVVAR_DOUBLESTRINGARRAY not supported", "AttributeHelper.insertFromFloatArray(float[] values,deviceAttributeWritten)");
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceAttribute.getType() + " not supported", "insertFromFloatArray.insertFromLongArray(float[] values,deviceAttributeWritten)");
            }
        }
    }

    public static void insertFromBooleanArray(boolean[] blArray, DeviceAttribute deviceAttribute, int n, int n2) throws DevFailed {
        boolean bl = false;
        if (blArray.length > 0) {
            bl = blArray[0];
        }
        Integer n3 = new Integer(0);
        if (bl) {
            n3 = new Integer(1);
        }
        if (blArray.length > n * n2) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "size of array " + blArray.length + " is too great", "AttributeHelper.insertFromBooleanArray(boolean[] values,deviceAttributeWritten)");
        }
        switch (deviceAttribute.getType()) {
            case 2: {
                deviceAttribute.insert(n3.shortValue());
                break;
            }
            case 6: {
                deviceAttribute.insert_us(n3.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "AttributeHelper.insertFromBooleanArray(boolean[] values,deviceAttributeWritten)");
                break;
            }
            case 22: {
                deviceAttribute.insert_uc(n3.shortValue());
                break;
            }
            case 3: {
                deviceAttribute.insert(n3);
                break;
            }
            case 7: {
                deviceAttribute.insert_ul(n3.longValue());
                break;
            }
            case 23: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_LONG64 not supported", "AttributeHelper.insertFromBooleanArray(boolean[] values,deviceAttributeWritten)");
                break;
            }
            case 24: {
                deviceAttribute.insert_u64(n3.longValue());
                break;
            }
            case 27: {
                deviceAttribute.insert(n3);
                break;
            }
            case 4: {
                deviceAttribute.insert(n3.floatValue());
                break;
            }
            case 5: {
                deviceAttribute.insert(n3.doubleValue());
                break;
            }
            case 8: {
                deviceAttribute.insert(n3.toString());
                break;
            }
            case 1: {
                deviceAttribute.insert(bl);
                break;
            }
            case 19: {
                DevState[] devStateArray = new DevState[blArray.length];
                for (int i = 0; i < blArray.length; ++i) {
                    try {
                        if (blArray[i]) {
                            devStateArray[i] = DevState.from_int(1);
                            continue;
                        }
                        devStateArray[i] = DevState.from_int(0);
                        continue;
                    }
                    catch (BAD_PARAM bAD_PARAM) {
                        devStateArray[i] = DevState.UNKNOWN;
                    }
                }
                deviceAttribute.insert(devStateArray);
                break;
            }
            case 10: {
                short[] sArray = new short[blArray.length];
                for (int i = 0; i < blArray.length; ++i) {
                    sArray[i] = blArray[i] ? (short)1 : 0;
                }
                if (n2 == 0) {
                    deviceAttribute.insert(sArray);
                    break;
                }
                deviceAttribute.insert(sArray, n, n2);
                break;
            }
            case 14: {
                short[] sArray = new short[blArray.length];
                for (int i = 0; i < blArray.length; ++i) {
                    sArray[i] = blArray[i] ? (short)1 : 0;
                }
                if (n2 == 0) {
                    deviceAttribute.insert_uc(sArray);
                    break;
                }
                deviceAttribute.insert_uc(sArray, n, n2);
                break;
            }
            case 9: {
                byte[] byArray = new byte[blArray.length];
                for (int i = 0; i < blArray.length; ++i) {
                    byArray[i] = blArray[i] ? Short.valueOf((short)1).byteValue() : Short.valueOf((short)0).byteValue();
                }
                deviceAttribute.insert_uc(byArray, n, n2);
                break;
            }
            case 11: {
                int[] nArray = new int[blArray.length];
                for (int i = 0; i < blArray.length; ++i) {
                    nArray[i] = blArray[i] ? 1 : 0;
                }
                if (n2 == 0) {
                    deviceAttribute.insert(nArray);
                    break;
                }
                deviceAttribute.insert(nArray, n, n2);
                break;
            }
            case 15: {
                long[] lArray = new long[blArray.length];
                for (int i = 0; i < blArray.length; ++i) {
                    lArray[i] = blArray[i] ? 1L : 0L;
                }
                if (n2 == 0) {
                    deviceAttribute.insert_ul(lArray);
                    break;
                }
                deviceAttribute.insert_ul(lArray, n, n2);
                break;
            }
            case 25: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEVVAR_LONG64ARRAY not supported", "AttributeHelper.insertFromBooleanArray(boolean[] values,deviceAttributeWritten)");
                break;
            }
            case 26: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEVVAR_ULONG64ARRAY not supported", "AttributeHelper.insertFromBooleanArray(boolean[] values,deviceAttributeWritten)");
                break;
            }
            case 12: {
                float[] fArray = new float[blArray.length];
                for (int i = 0; i < blArray.length; ++i) {
                    fArray[i] = blArray[i] ? 1.0f : 0.0f;
                }
                if (n2 == 0) {
                    deviceAttribute.insert(fArray);
                    break;
                }
                deviceAttribute.insert(fArray, n, n2);
                break;
            }
            case 13: {
                double[] dArray = new double[blArray.length];
                for (int i = 0; i < blArray.length; ++i) {
                    dArray[i] = blArray[i] ? 1.0 : 0.0;
                }
                if (n2 == 0) {
                    deviceAttribute.insert(dArray);
                    break;
                }
                deviceAttribute.insert(dArray, n, n2);
                break;
            }
            case 16: {
                String[] stringArray = new String[blArray.length];
                for (int i = 0; i < blArray.length; ++i) {
                    stringArray[i] = Boolean.valueOf(blArray[i]).toString();
                }
                if (n2 == 0) {
                    deviceAttribute.insert(stringArray);
                    break;
                }
                deviceAttribute.insert(stringArray, n, n2);
                break;
            }
            case 17: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEVVAR_LONGSTRINGARRAY not supported", "AttributeHelper.insertFromBooleanArray(boolean[] values,deviceAttributeWritten)");
                break;
            }
            case 18: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEVVAR_DOUBLESTRINGARRAY not supported", "AttributeHelper.insertFromBooleanArray(boolean[] values,deviceAttributeWritten)");
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceAttribute.getType() + " not supported", "insertFromBooleanArray.insertFromLongArray(boolean[] values,deviceAttributeWritten)");
            }
        }
    }

    public static void insertFromDoubleArray(double[] dArray, DeviceAttribute deviceAttribute, int n, int n2) throws DevFailed {
        Double d = new Double(0.0);
        for (int i = 0; i < dArray.length; ++i) {
            d = d + dArray[i];
        }
        if (dArray.length > n * n2) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "size of array " + dArray.length + " is too great", "AttributeHelper.insertFromDoubleArray(double[] values,deviceAttributeWritten)");
        }
        switch (deviceAttribute.getType()) {
            case 2: {
                deviceAttribute.insert(d.shortValue());
                break;
            }
            case 6: {
                deviceAttribute.insert_us(d.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "AttributeHelper.insertFromDoubleArray(double[] values,deviceAttributeWritten)");
                break;
            }
            case 22: {
                deviceAttribute.insert_uc(d.shortValue());
                break;
            }
            case 3: {
                deviceAttribute.insert(d.intValue());
                break;
            }
            case 7: {
                deviceAttribute.insert_ul(d.longValue());
                break;
            }
            case 23: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_LONG64 not supported", "AttributeHelper.insertFromDoubleArray(double[] values,deviceAttributeWritten)");
                break;
            }
            case 24: {
                deviceAttribute.insert_u64(d.longValue());
                break;
            }
            case 27: {
                deviceAttribute.insert(d.intValue());
                break;
            }
            case 4: {
                deviceAttribute.insert(d.floatValue());
                break;
            }
            case 5: {
                deviceAttribute.insert(d);
                break;
            }
            case 8: {
                deviceAttribute.insert(d.toString());
                break;
            }
            case 1: {
                if (d == 1.0) {
                    deviceAttribute.insert(true);
                    break;
                }
                deviceAttribute.insert(false);
                break;
            }
            case 19: {
                DevState[] devStateArray = new DevState[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    try {
                        devStateArray[i] = DevState.from_int(Double.valueOf(dArray[i]).intValue());
                        continue;
                    }
                    catch (BAD_PARAM bAD_PARAM) {
                        devStateArray[i] = DevState.UNKNOWN;
                    }
                }
                deviceAttribute.insert(devStateArray);
                break;
            }
            case 10: {
                short[] sArray = new short[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    sArray[i] = Double.valueOf(dArray[i]).shortValue();
                }
                if (n2 == 0) {
                    deviceAttribute.insert(sArray);
                    break;
                }
                deviceAttribute.insert(sArray, n, n2);
                break;
            }
            case 14: {
                short[] sArray = new short[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    sArray[i] = Double.valueOf(dArray[i]).shortValue();
                }
                if (n2 == 0) {
                    deviceAttribute.insert_uc(sArray);
                    break;
                }
                deviceAttribute.insert_uc(sArray, n, n2);
                break;
            }
            case 9: {
                byte[] byArray = new byte[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    byArray[i] = Double.valueOf(dArray[i]).byteValue();
                }
                deviceAttribute.insert_uc(byArray, n, n2);
                break;
            }
            case 11: {
                int[] nArray = new int[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    nArray[i] = Double.valueOf(dArray[i]).intValue();
                }
                if (n2 == 0) {
                    deviceAttribute.insert(nArray);
                    break;
                }
                deviceAttribute.insert(nArray, n, n2);
                break;
            }
            case 15: {
                long[] lArray = new long[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    lArray[i] = Double.valueOf(dArray[i]).longValue();
                }
                if (n2 == 0) {
                    deviceAttribute.insert_ul(lArray);
                    break;
                }
                deviceAttribute.insert_ul(lArray, n, n2);
                break;
            }
            case 25: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEVVAR_LONG64ARRAY not supported", "AttributeHelper.insertFromDoubleArray(double[] values,deviceAttributeWritten)");
                break;
            }
            case 26: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEVVAR_ULONG64ARRAY not supported", "AttributeHelper.insertFromDoubleArray(double[] values,deviceAttributeWritten)");
                break;
            }
            case 12: {
                float[] fArray = new float[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    fArray[i] = Double.valueOf(dArray[i]).floatValue();
                }
                if (n2 == 0) {
                    deviceAttribute.insert(fArray);
                    break;
                }
                deviceAttribute.insert(fArray, n, n2);
                break;
            }
            case 13: {
                if (n2 == 0) {
                    deviceAttribute.insert(dArray);
                    break;
                }
                deviceAttribute.insert(dArray, n, n2);
                break;
            }
            case 16: {
                String[] stringArray = new String[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    stringArray[i] = Double.valueOf(dArray[i]).toString();
                }
                if (n2 == 0) {
                    deviceAttribute.insert(stringArray);
                    break;
                }
                deviceAttribute.insert(stringArray, n, n2);
                break;
            }
            case 17: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEVVAR_LONGSTRINGARRAY not supported", "AttributeHelper.insertFromDoubleArray(double[] values,deviceAttributeWritten)");
                break;
            }
            case 18: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEVVAR_DOUBLESTRINGARRAY not supported", "AttributeHelper.insertFromDoubleArray(double[] values,deviceAttributeWritten)");
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceAttribute.getType() + " not supported", "insertFromFloatArray.insertFromDoubleArray(double[] values,deviceAttributeWritten)");
            }
        }
    }

    public static void insertFromString(String string, DeviceAttribute deviceAttribute) throws DevFailed {
        Double d = Double.NaN;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = Double.NaN;
        }
        if (d.isNaN() && deviceAttribute.getType() != 8) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "Cannot insert " + string + " as a numerical value.", "AttributeHelper.insertFromString(String value,deviceAttributeWritten)");
        }
        switch (deviceAttribute.getType()) {
            case 2: {
                if (d.isNaN()) break;
                deviceAttribute.insert(d.shortValue());
                break;
            }
            case 6: {
                if (d.isNaN()) break;
                deviceAttribute.insert_us(d.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "AttributeHelper.insertFromString(String value,deviceAttributeWritten)");
                break;
            }
            case 22: {
                if (d.isNaN()) break;
                deviceAttribute.insert_uc(d.shortValue());
                break;
            }
            case 3: {
                if (d.isNaN()) break;
                deviceAttribute.insert(d.intValue());
                break;
            }
            case 7: {
                deviceAttribute.insert_ul(d.longValue());
                break;
            }
            case 23: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_LONG64 not supported", "AttributeHelper.insertFromString(String value,deviceAttributeWritten)");
                break;
            }
            case 24: {
                if (d.isNaN()) break;
                deviceAttribute.insert_u64(d.longValue());
                break;
            }
            case 27: {
                if (d.isNaN()) break;
                deviceAttribute.insert(d.intValue());
                break;
            }
            case 4: {
                if (d.isNaN()) break;
                deviceAttribute.insert(d.floatValue());
                break;
            }
            case 5: {
                if (d.isNaN()) break;
                deviceAttribute.insert(d);
                break;
            }
            case 8: {
                deviceAttribute.insert(string);
                break;
            }
            case 1: {
                if (d.isNaN()) break;
                if (d == 1.0) {
                    deviceAttribute.insert(true);
                    break;
                }
                deviceAttribute.insert(false);
                break;
            }
            case 19: {
                if (d.isNaN()) break;
                DevState devState = StateUtilities.getStateForName(string);
                deviceAttribute.insert(devState);
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceAttribute.getType() + " not supported", "AttributeHelper.insertFromString(String value,deviceAttributeWritten)");
            }
        }
    }

    public static void insertFromInteger(Integer n, DeviceAttribute deviceAttribute) throws DevFailed {
        switch (deviceAttribute.getType()) {
            case 2: {
                deviceAttribute.insert(n.shortValue());
                break;
            }
            case 6: {
                deviceAttribute.insert_us(n.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "AttributeHelper.insertFromInteger(Integer value,deviceAttributeWritten)");
                break;
            }
            case 22: {
                deviceAttribute.insert_uc(n.shortValue());
                break;
            }
            case 3: {
                deviceAttribute.insert(n);
                break;
            }
            case 7: {
                deviceAttribute.insert_ul(n.longValue());
                break;
            }
            case 23: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_LONG64 not supported", "AttributeHelper.insertFromInteger(Integer value,deviceAttributeWritten)");
                break;
            }
            case 24: {
                deviceAttribute.insert_u64(n.longValue());
                break;
            }
            case 27: {
                deviceAttribute.insert(n);
                break;
            }
            case 4: {
                deviceAttribute.insert(n.floatValue());
                break;
            }
            case 5: {
                deviceAttribute.insert(n.doubleValue());
                break;
            }
            case 8: {
                deviceAttribute.insert(n.toString());
                break;
            }
            case 1: {
                if (n.doubleValue() == 1.0) {
                    deviceAttribute.insert(true);
                    break;
                }
                deviceAttribute.insert(false);
                break;
            }
            case 19: {
                try {
                    deviceAttribute.insert(DevState.from_int(n));
                }
                catch (BAD_PARAM bAD_PARAM) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "Cannot sent" + n + "for input Tango_DEV_STATE type", "AttributeHelper.insertFromInteger(Integer value,deviceAttributeWritten)");
                }
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceAttribute.getType() + " not supported", "AttributeHelper.insertFromInteger(Integer value,deviceAttributeWritten)");
            }
        }
    }

    public static void insertFromLong(Long l, DeviceAttribute deviceAttribute) throws DevFailed {
        switch (deviceAttribute.getType()) {
            case 2: {
                deviceAttribute.insert(l.shortValue());
                break;
            }
            case 6: {
                deviceAttribute.insert_us(l.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "AttributeHelper.insertFromLong(Long value,deviceAttributeWritten)");
                break;
            }
            case 22: {
                deviceAttribute.insert_uc(l.shortValue());
                break;
            }
            case 3: {
                deviceAttribute.insert(l.intValue());
                break;
            }
            case 7: {
                deviceAttribute.insert_ul(l);
                break;
            }
            case 23: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_LONG64 not supported", "AttributeHelper.insertFromLong(Long value,deviceAttributeWritten)");
                break;
            }
            case 24: {
                deviceAttribute.insert_u64(l);
                break;
            }
            case 27: {
                deviceAttribute.insert(l.intValue());
                break;
            }
            case 4: {
                deviceAttribute.insert(l.floatValue());
                break;
            }
            case 5: {
                deviceAttribute.insert(l.doubleValue());
                break;
            }
            case 8: {
                deviceAttribute.insert(l.toString());
                break;
            }
            case 1: {
                if (l.doubleValue() == 1.0) {
                    deviceAttribute.insert(true);
                    break;
                }
                deviceAttribute.insert(false);
                break;
            }
            case 19: {
                try {
                    deviceAttribute.insert(DevState.from_int(l.intValue()));
                }
                catch (BAD_PARAM bAD_PARAM) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "Cannot sent" + l.intValue() + "for input Tango_DEV_STATE type", "AttributeHelper.insertFromLong(Long value,deviceAttributeWritten)");
                }
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceAttribute.getType() + " not supported", "AttributeHelper.insertFromLong(Long value,deviceAttributeWritten)");
            }
        }
    }

    public static void insertFromFloat(Float f, DeviceAttribute deviceAttribute) throws DevFailed {
        switch (deviceAttribute.getType()) {
            case 2: {
                deviceAttribute.insert(f.shortValue());
                break;
            }
            case 6: {
                deviceAttribute.insert_us(f.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "AttributeHelper.insertFromFloat(Float value,deviceAttributeWritten)");
                break;
            }
            case 22: {
                deviceAttribute.insert_uc(f.shortValue());
                break;
            }
            case 3: {
                deviceAttribute.insert(f.intValue());
                break;
            }
            case 7: {
                deviceAttribute.insert_ul(f.longValue());
                break;
            }
            case 23: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_LONG64 not supported", "AttributeHelper.insertFromFloat(Float value,deviceAttributeWritten)");
                break;
            }
            case 24: {
                deviceAttribute.insert_u64(f.longValue());
                break;
            }
            case 27: {
                deviceAttribute.insert(f.intValue());
                break;
            }
            case 4: {
                deviceAttribute.insert(f.floatValue());
                break;
            }
            case 5: {
                deviceAttribute.insert(f.doubleValue());
                break;
            }
            case 8: {
                deviceAttribute.insert(f.toString());
                break;
            }
            case 1: {
                if (f.doubleValue() == 1.0) {
                    deviceAttribute.insert(true);
                    break;
                }
                deviceAttribute.insert(false);
                break;
            }
            case 19: {
                try {
                    deviceAttribute.insert(DevState.from_int(f.intValue()));
                }
                catch (BAD_PARAM bAD_PARAM) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "Cannot sent" + f.intValue() + "for input Tango_DEV_STATE type", "AttributeHelper.insertFromFloat(Float value,deviceAttributeWritten)");
                }
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceAttribute.getType() + " not supported", "AttributeHelper.insertFromFloat(Float value,deviceAttributeWritten)");
            }
        }
    }

    public static void insertFromBoolean(Boolean bl, DeviceAttribute deviceAttribute) throws DevFailed {
        Integer n = 0;
        if (bl.booleanValue()) {
            n = 1;
        }
        switch (deviceAttribute.getType()) {
            case 2: {
                deviceAttribute.insert(n.shortValue());
                break;
            }
            case 6: {
                deviceAttribute.insert_us(n.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "AttributeHelper.insertFromBoolean(Boolean value,deviceAttributeWritten)");
                break;
            }
            case 22: {
                deviceAttribute.insert_uc(n.shortValue());
                break;
            }
            case 3: {
                deviceAttribute.insert(n);
                break;
            }
            case 7: {
                deviceAttribute.insert_ul(n.longValue());
                break;
            }
            case 23: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_LONG64 not supported", "AttributeHelper.insertFromBoolean(Boolean value,deviceAttributeWritten)");
                break;
            }
            case 24: {
                deviceAttribute.insert_u64(n.longValue());
                break;
            }
            case 27: {
                deviceAttribute.insert(n);
                break;
            }
            case 4: {
                deviceAttribute.insert(n.floatValue());
                break;
            }
            case 5: {
                deviceAttribute.insert(n.doubleValue());
                break;
            }
            case 8: {
                deviceAttribute.insert(Boolean.toString(bl));
                break;
            }
            case 1: {
                deviceAttribute.insert(bl);
                break;
            }
            case 19: {
                deviceAttribute.insert(DevState.from_int(n));
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceAttribute.getType() + " not supported", "AttributeHelper.insertFromBoolean(Boolean value,deviceAttributeWritten)");
            }
        }
    }

    public static void insertFromDouble(Double d, DeviceAttribute deviceAttribute) throws DevFailed {
        switch (deviceAttribute.getType()) {
            case 2: {
                deviceAttribute.insert(d.shortValue());
                break;
            }
            case 6: {
                deviceAttribute.insert_us(d.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "AttributeHelper.insertFromDouble(Double value,deviceAttributeWritten)");
                break;
            }
            case 22: {
                deviceAttribute.insert_uc(d.shortValue());
                break;
            }
            case 3: {
                deviceAttribute.insert(d.intValue());
                break;
            }
            case 7: {
                deviceAttribute.insert_ul(d.longValue());
                break;
            }
            case 23: {
                deviceAttribute.insert(d.longValue());
                break;
            }
            case 24: {
                deviceAttribute.insert_u64(d.longValue());
                break;
            }
            case 27: {
                deviceAttribute.insert(d.intValue());
                break;
            }
            case 4: {
                deviceAttribute.insert(d.floatValue());
                break;
            }
            case 5: {
                deviceAttribute.insert(d);
                break;
            }
            case 8: {
                deviceAttribute.insert(d.toString());
                break;
            }
            case 1: {
                if (d == 1.0) {
                    deviceAttribute.insert(true);
                    break;
                }
                deviceAttribute.insert(false);
                break;
            }
            case 19: {
                try {
                    deviceAttribute.insert(DevState.from_int(d.intValue()));
                }
                catch (BAD_PARAM bAD_PARAM) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "Cannot sent" + d.intValue() + "for input Tango_DEV_STATE type", "AttributeHelper.insertFromDouble(Double value,deviceAttributeWritten)");
                }
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceAttribute.getType() + " not supported", "AttributeHelper.insertFromDouble(Double value,deviceAttributeWritten)");
            }
        }
    }

    public static void insertFromWAttribute(WAttribute wAttribute, DeviceAttribute deviceAttribute) throws DevFailed {
        Object object = null;
        switch (wAttribute.get_data_type()) {
            case 2: {
                object = wAttribute.getShortWriteValue();
                break;
            }
            case 6: {
                object = wAttribute.getUShortWriteValue();
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "AttributeHelper.insertFromWAttribute(WAttribute wAttributeValue,deviceAttributeWritten)");
                break;
            }
            case 22: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_UCHAR not supported", "AttributeHelper.insertFromWAttribute(WAttribute wAttributeValue,deviceAttributeWritten)");
                break;
            }
            case 3: {
                object = wAttribute.getLongWriteValue();
                break;
            }
            case 7: {
                object = wAttribute.getULongWriteValue();
                break;
            }
            case 23: {
                object = wAttribute.getLong64WriteValue();
                break;
            }
            case 24: {
                object = wAttribute.getULong64WriteValue();
                break;
            }
            case 27: {
                object = wAttribute.getLongWriteValue();
                break;
            }
            case 4: {
                object = Float.valueOf(Double.valueOf(wAttribute.getDoubleWriteValue()).floatValue());
                break;
            }
            case 5: {
                object = wAttribute.getDoubleWriteValue();
                break;
            }
            case 8: {
                object = wAttribute.getStringWriteValue();
                break;
            }
            case 1: {
                object = wAttribute.getBooleanWriteValue();
                break;
            }
            case 19: {
                object = wAttribute.getStateWriteValue();
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceAttribute.getType() + " not supported", "AttributeHelper.insertFromDouble(Double value,deviceAttributeWritten)");
            }
        }
        AttributeHelper.insert(object, deviceAttribute);
    }

    public static void insertFromDevState(DevState devState, DeviceAttribute deviceAttribute) throws DevFailed {
        Integer n = devState.value();
        switch (deviceAttribute.getType()) {
            case 2: {
                deviceAttribute.insert(n.shortValue());
                break;
            }
            case 6: {
                deviceAttribute.insert_us(n.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "AttributeHelper.insertFromDevState(DevState value,deviceAttributeWritten)");
                break;
            }
            case 22: {
                deviceAttribute.insert_uc(n.shortValue());
                break;
            }
            case 3: {
                deviceAttribute.insert(n);
                break;
            }
            case 7: {
                deviceAttribute.insert_ul(n.longValue());
                break;
            }
            case 23: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_LONG64 not supported", "AttributeHelper.insertFromDevState(DevState value,deviceAttributeWritten)");
                break;
            }
            case 24: {
                deviceAttribute.insert_u64(n.longValue());
                break;
            }
            case 27: {
                deviceAttribute.insert(n);
                break;
            }
            case 4: {
                deviceAttribute.insert(n.floatValue());
                break;
            }
            case 5: {
                deviceAttribute.insert(n.doubleValue());
                break;
            }
            case 8: {
                deviceAttribute.insert(n.toString());
                break;
            }
            case 1: {
                if (n.doubleValue() == 1.0) {
                    deviceAttribute.insert(true);
                    break;
                }
                deviceAttribute.insert(false);
                break;
            }
            case 19: {
                deviceAttribute.insert(devState);
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceAttribute.getType() + " not supported", "AttributeHelper.insertFromDevState(DevState value,deviceAttributeWritten)");
            }
        }
    }

    public static void insertFromArray(Object[] objectArray, DeviceAttribute deviceAttribute, int n, int n2) throws DevFailed {
        if (objectArray.length > 0) {
            Object object = objectArray[0];
            if (object instanceof Short) {
                short[] sArray = new short[objectArray.length];
                for (int i = 0; i < sArray.length; ++i) {
                    sArray[i] = (Short)objectArray[i];
                }
                AttributeHelper.insertFromShortArray(sArray, deviceAttribute, n, n2);
            } else if (object instanceof String) {
                String[] stringArray = new String[objectArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = (String)objectArray[i];
                }
                AttributeHelper.insertFromStringArray(stringArray, deviceAttribute, n, n2);
            } else if (object instanceof Integer) {
                int[] nArray = new int[objectArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = (Integer)objectArray[i];
                }
                AttributeHelper.insertFromIntegerArray(nArray, deviceAttribute, n, n2);
            } else if (object instanceof Long) {
                long[] lArray = new long[objectArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    lArray[i] = ((Long)objectArray[i]).intValue();
                }
                AttributeHelper.insertFromLongArray(lArray, deviceAttribute, n, n2);
            } else if (object instanceof Float) {
                float[] fArray = new float[objectArray.length];
                for (int i = 0; i < fArray.length; ++i) {
                    fArray[i] = ((Float)objectArray[i]).floatValue();
                }
                AttributeHelper.insertFromFloatArray(fArray, deviceAttribute, n, n2);
            } else if (object instanceof Boolean) {
                boolean[] blArray = new boolean[objectArray.length];
                for (int i = 0; i < blArray.length; ++i) {
                    blArray[i] = (Boolean)objectArray[i];
                }
                AttributeHelper.insertFromBooleanArray(blArray, deviceAttribute, n, n2);
            } else if (object instanceof Double) {
                double[] dArray = new double[objectArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = (Double)objectArray[i];
                }
                AttributeHelper.insertFromDoubleArray(dArray, deviceAttribute, n, n2);
            }
        }
    }

    public static final void fillDbDatumFromDeviceAttribute(DbDatum dbDatum, DeviceAttribute deviceAttribute) throws DevFailed {
        switch (deviceAttribute.getType()) {
            case 0: {
                break;
            }
            case 1: {
                dbDatum.insert(deviceAttribute.extractBoolean());
                break;
            }
            case 2: {
                dbDatum.insert(deviceAttribute.extractShort());
                break;
            }
            case 6: {
                dbDatum.insert(deviceAttribute.extractUShort());
                break;
            }
            case 4: {
                dbDatum.insert(deviceAttribute.extractFloat());
                break;
            }
            case 5: {
                dbDatum.insert(deviceAttribute.extractDouble());
                break;
            }
            case 8: {
                dbDatum.insert(deviceAttribute.extractString());
                break;
            }
            case 10: {
                dbDatum.insert(deviceAttribute.extractShortArray());
                break;
            }
            case 14: {
                dbDatum.insert(deviceAttribute.extractUShortArray());
                break;
            }
            case 11: {
                dbDatum.insert(deviceAttribute.extractLongArray());
                break;
            }
            case 12: {
                dbDatum.insert(deviceAttribute.extractFloatArray());
                break;
            }
            case 13: {
                dbDatum.insert(deviceAttribute.extractDoubleArray());
                break;
            }
            case 16: {
                dbDatum.insert(deviceAttribute.extractStringArray());
                break;
            }
            case 17: {
                dbDatum.insert(deviceAttribute.extractLongArray());
                dbDatum.insert(deviceAttribute.extractStringArray());
                break;
            }
            case 18: {
                dbDatum.insert(deviceAttribute.extractDoubleArray());
                dbDatum.insert(deviceAttribute.extractStringArray());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Tango_DEVVAR_CHARARRAY, Tango_DEVVAR_ULONGARRAY, Tango_DEV_LONG, Tango_DEV_ULONG  are not supported by DbDatum or DeviceAttribute");
            }
        }
    }

    public static final void fillDeviceAttributeFromDbDatum(DeviceAttribute deviceAttribute, DbDatum dbDatum) throws DevFailed {
        switch (deviceAttribute.getType()) {
            case 0: {
                break;
            }
            case 1: {
                deviceAttribute.insert(dbDatum.extractBoolean());
                break;
            }
            case 2: {
                deviceAttribute.insert(dbDatum.extractShort());
                break;
            }
            case 6: {
                deviceAttribute.insert(dbDatum.extractLong());
                break;
            }
            case 4: {
                deviceAttribute.insert(dbDatum.extractFloat());
                break;
            }
            case 5: {
                deviceAttribute.insert(dbDatum.extractDouble());
                break;
            }
            case 8: {
                deviceAttribute.insert(dbDatum.extractString());
                break;
            }
            case 10: {
                deviceAttribute.insert(dbDatum.extractShortArray());
                break;
            }
            case 14: {
                deviceAttribute.insert(dbDatum.extractLongArray());
                break;
            }
            case 11: {
                deviceAttribute.insert(dbDatum.extractLongArray());
                break;
            }
            case 12: {
                deviceAttribute.insert(dbDatum.extractFloatArray());
                break;
            }
            case 13: {
                deviceAttribute.insert(dbDatum.extractDoubleArray());
                break;
            }
            case 16: {
                deviceAttribute.insert(dbDatum.extractStringArray());
                break;
            }
            case 17: {
                deviceAttribute.insert(dbDatum.extractLongArray());
                deviceAttribute.insert(dbDatum.extractStringArray());
                break;
            }
            case 18: {
                deviceAttribute.insert(dbDatum.extractDoubleArray());
                deviceAttribute.insert(dbDatum.extractStringArray());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Tango_DEVVAR_CHARARRAY, Tango_DEVVAR_ULONGARRAY, Tango_DEV_LONG, Tango_DEV_ULONG  are not supported by DbDatum or DeviceAttribute");
            }
        }
    }
}

