/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class TangORBversion
implements Serializable {
    public String Tango = null;
    public String api = null;
    public String JacORB = null;
    public String logkit = null;
    public String avalon = null;
    public String jarfile;
    private static final String[] packages = new String[]{"API", "Tango", "JacORB", "logkit", "avalon_framework"};

    public TangORBversion() throws DevFailed, IOException {
        String classpath = System.getProperty("java.class.path");
        String separator = System.getProperty("path.separator");
        String target = "TangORB";
        int start = classpath.indexOf(target);
        if (start < 0) {
            Except.throw_exception("TangORB_NotFound", "TangORB jar file not found in CLASSPATH", "TangORBversion.TangORBversion()");
        }
        start = (start = classpath.lastIndexOf(separator, start)) < 0 ? 0 : ++start;
        int end = classpath.indexOf(separator, start);
        this.jarfile = end < 0 ? classpath.substring(start) : classpath.substring(start, end);
        this.initObject();
    }

    public TangORBversion(String filename) throws DevFailed, IOException {
        this.jarfile = filename;
        this.initObject();
    }

    private void initObject() throws DevFailed, IOException {
        if (!new File(this.jarfile).exists()) {
            Except.throw_exception("FileNotFoundException", this.jarfile + " No such file or directory", "TangORBversion.initObject()");
        }
        JarFile jf = new JarFile(this.jarfile);
        Manifest manif = jf.getManifest();
        Attributes attr = manif.getMainAttributes();
        int max_length = 0;
        for (String pack : packages) {
            if (pack.length() <= max_length) continue;
            max_length = pack.length();
        }
        block8: for (int i = 0; i < packages.length; ++i) {
            String target = packages[i] + "-Version";
            String vers = attr.getValue(target);
            switch (i) {
                case 0: {
                    this.api = vers.trim();
                    continue block8;
                }
                case 1: {
                    this.Tango = vers.trim();
                    continue block8;
                }
                case 2: {
                    this.JacORB = vers.trim();
                    continue block8;
                }
                case 3: {
                    this.logkit = vers.trim();
                    continue block8;
                }
                case 4: {
                    this.avalon = vers.trim();
                }
            }
        }
    }

    public String toString() {
        int max_length = 0;
        for (String pack : packages) {
            if (pack.length() <= max_length) continue;
            max_length = pack.length();
        }
        String versStr = " version";
        max_length += versStr.length() + 3;
        String str = "";
        for (int i = 0; i < packages.length; ++i) {
            str = str + packages[i] + versStr;
            for (int j = packages[i].length() + versStr.length(); j < max_length; ++j) {
                str = str + ".";
            }
            switch (i) {
                case 0: {
                    str = str + this.api;
                    break;
                }
                case 1: {
                    str = str + this.Tango;
                    break;
                }
                case 2: {
                    str = str + this.JacORB;
                    break;
                }
                case 3: {
                    str = str + this.logkit;
                    break;
                }
                case 4: {
                    str = str + this.avalon;
                }
            }
            if (i >= packages.length - 1) continue;
            str = str + "\n";
        }
        return str;
    }

    public static void main(String[] args) {
        try {
            TangORBversion tangORB = args.length > 0 ? new TangORBversion(args[0]) : new TangORBversion();
            System.out.println(tangORB);
        }
        catch (DevFailed e) {
            Except.print_exception(e);
        }
        catch (IOException e) {
            System.out.println(e);
            System.exit(-1);
        }
        System.exit(0);
    }
}

