/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.AttrValUnion;
import fr.esrf.Tango.AttributeDim;
import fr.esrf.Tango.AttributeValue;
import fr.esrf.Tango.AttributeValue_3;
import fr.esrf.Tango.AttributeValue_4;
import fr.esrf.Tango.DevEncoded;
import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.TimeVal;
import fr.esrf.TangoApi.DeviceAttribute_3;
import fr.esrf.TangoApi.DeviceAttribute_3DAODefaultImpl;
import fr.esrf.TangoApi.IDeviceAttributeDAO;
import fr.esrf.TangoApi.WrongData;
import fr.esrf.TangoDs.Except;
import org.omg.CORBA.BAD_PARAM;

public class DeviceAttributeDAODefaultImpl
implements IDeviceAttributeDAO {
    private AttributeValue_4 attrval = new AttributeValue_4();
    private DeviceAttribute_3 devAtt_3 = null;
    private boolean use_union = true;

    private void buildAttributeValueObject(String string) {
        this.attrval.name = string;
        this.attrval.quality = AttrQuality.ATTR_VALID;
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.time = new TimeVal();
        this.attrval.r_dim = new AttributeDim();
        this.attrval.w_dim = new AttributeDim();
        this.attrval.r_dim.dim_x = 1;
        this.attrval.r_dim.dim_y = 0;
        this.attrval.w_dim.dim_x = 0;
        this.attrval.w_dim.dim_y = 0;
        this.attrval.value = new AttrValUnion();
        long l = System.currentTimeMillis();
        this.attrval.time.tv_sec = (int)(l / 1000L);
        this.attrval.time.tv_usec = (int)(l - (long)(this.attrval.time.tv_sec * 1000)) * 1000;
        this.attrval.time.tv_nsec = 0;
        this.attrval.err_list = new DevError[0];
    }

    public void init(AttributeValue_4 attributeValue_4) {
        this.attrval = attributeValue_4;
    }

    public void init(AttributeValue_3 attributeValue_3) {
        this.setAttributeValue(attributeValue_3);
    }

    public void init(AttributeValue attributeValue) {
        this.setAttributeValue(attributeValue);
    }

    public void init(String string) {
        this.buildAttributeValueObject(string);
    }

    public void init(String string, int n, int n2) {
        this.buildAttributeValueObject(string);
        this.attrval.r_dim.dim_x = n;
        this.attrval.r_dim.dim_y = n2;
    }

    public void init(String string, boolean bl) {
        this.buildAttributeValueObject(string);
        this.insert(bl);
    }

    public void init(String string, DevState devState) {
        this.buildAttributeValueObject(string);
        this.insert(devState);
    }

    public void init(String string, boolean[] blArray, int n, int n2) {
        this.buildAttributeValueObject(string);
        this.insert(blArray, n, n2);
    }

    public void init(String string, byte by) {
        this.buildAttributeValueObject(string);
        this.insert_uc(by);
    }

    public void init(String string, byte[] byArray, int n, int n2) {
        this.buildAttributeValueObject(string);
        this.insert_uc(byArray, n, n2);
    }

    public void init(String string, short s) {
        this.buildAttributeValueObject(string);
        this.insert(s);
    }

    public void init(String string, short[] sArray, int n, int n2) {
        this.buildAttributeValueObject(string);
        this.insert(sArray, n, n2);
    }

    public void init(String string, int n) {
        this.buildAttributeValueObject(string);
        this.insert(n);
    }

    public void init(String string, int[] nArray, int n, int n2) {
        this.buildAttributeValueObject(string);
        this.insert(nArray, n, n2);
    }

    public void init(String string, long l) {
        this.buildAttributeValueObject(string);
        this.insert(l);
    }

    public void init(String string, long[] lArray, int n, int n2) {
        this.buildAttributeValueObject(string);
        this.insert(lArray, n, n2);
    }

    public void init(String string, float f) {
        this.buildAttributeValueObject(string);
        this.insert(f);
    }

    public void init(String string, float[] fArray, int n, int n2) {
        this.buildAttributeValueObject(string);
        this.insert(fArray, n, n2);
    }

    public void init(String string, double d) {
        this.buildAttributeValueObject(string);
        this.insert(d);
    }

    public void init(String string, double[] dArray, int n, int n2) {
        this.buildAttributeValueObject(string);
        this.insert(dArray, n, n2);
    }

    public void init(String string, String string2) {
        this.buildAttributeValueObject(string);
        this.insert(string2);
    }

    public void init(String string, String[] stringArray, int n, int n2) {
        this.buildAttributeValueObject(string);
        this.insert(stringArray, n, n2);
    }

    public boolean hasFailed() {
        return this.attrval.err_list != null && this.attrval.err_list.length > 0;
    }

    public DevError[] getErrStack() {
        return this.attrval.err_list;
    }

    public void setAttributeValue(AttributeValue_4 attributeValue_4) {
        this.attrval = attributeValue_4;
    }

    public void setAttributeValue(AttributeValue_3 attributeValue_3) {
        this.devAtt_3 = new DeviceAttribute_3(attributeValue_3);
        this.use_union = false;
        this.attrval.name = attributeValue_3.name;
        this.attrval.quality = attributeValue_3.quality;
        this.attrval.time = attributeValue_3.time;
        this.attrval.r_dim = attributeValue_3.r_dim;
        this.attrval.w_dim = attributeValue_3.w_dim;
        this.attrval.err_list = attributeValue_3.err_list;
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
    }

    public void setAttributeValue(AttributeValue attributeValue) {
        this.devAtt_3 = new DeviceAttribute_3(attributeValue);
        this.use_union = false;
        this.attrval.name = attributeValue.name;
        this.attrval.quality = attributeValue.quality;
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.time = attributeValue.time;
        this.attrval.r_dim = new AttributeDim();
        this.attrval.w_dim = new AttributeDim();
        this.attrval.r_dim.dim_x = attributeValue.dim_x;
        this.attrval.r_dim.dim_y = attributeValue.dim_y;
        this.attrval.w_dim.dim_x = 0;
        this.attrval.w_dim.dim_y = 0;
        this.attrval.err_list = null;
    }

    public AttributeDim getReadAttributeDim() {
        return this.attrval.r_dim;
    }

    public AttributeDim getWriteAttributeDim() {
        return this.attrval.w_dim;
    }

    public void insert(DevState devState) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        DevState[] devStateArray = new DevState[]{devState};
        this.attrval.w_dim.dim_x = 1;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.state_att_value(devStateArray);
        } else {
            this.devAtt_3.insert(devState);
        }
    }

    public void insert(DevState[] devStateArray) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = devStateArray.length;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.state_att_value(devStateArray);
        } else {
            this.devAtt_3.insert(devStateArray);
        }
    }

    public void insert(DevState[] devStateArray, int n, int n2) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = n;
        this.attrval.w_dim.dim_y = n2;
        if (this.use_union) {
            this.attrval.value.state_att_value(devStateArray);
        } else {
            this.devAtt_3.insert(devStateArray);
        }
    }

    public void insert(boolean bl) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        boolean[] blArray = new boolean[]{bl};
        this.attrval.w_dim.dim_x = 1;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.bool_att_value(blArray);
        } else {
            this.devAtt_3.insert(bl);
        }
    }

    public void insert(boolean[] blArray) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = blArray.length;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.bool_att_value(blArray);
        } else {
            this.devAtt_3.insert(blArray);
        }
    }

    public void insert(boolean[] blArray, int n, int n2) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = n;
        this.attrval.w_dim.dim_y = n2;
        if (this.use_union) {
            this.attrval.value.bool_att_value(blArray);
        } else {
            this.devAtt_3.insert(blArray);
        }
    }

    public void insert_uc(byte by) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        byte[] byArray = new byte[]{by};
        this.attrval.w_dim.dim_x = 1;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.uchar_att_value(byArray);
        } else {
            this.devAtt_3.insert_uc(by);
        }
    }

    public void insert_uc(byte[] byArray) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = byArray.length;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.uchar_att_value(byArray);
        } else {
            this.devAtt_3.insert_uc(byArray);
        }
    }

    public void insert_uc(short s) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        byte[] byArray = new byte[]{(byte)(s & 0xFF)};
        this.attrval.w_dim.dim_x = 1;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.uchar_att_value(byArray);
        } else {
            this.devAtt_3.insert_uc(s);
        }
    }

    public void insert_uc(short[] sArray) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        byte[] byArray = new byte[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            byArray[i] = (byte)(sArray[i] & 0xFF);
        }
        this.attrval.w_dim.dim_x = sArray.length;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.uchar_att_value(byArray);
        } else {
            this.devAtt_3.insert_uc(sArray);
        }
    }

    public void insert_uc(short[] sArray, int n, int n2) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        byte[] byArray = new byte[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            byArray[i] = (byte)(sArray[i] & 0xFF);
        }
        this.attrval.w_dim.dim_x = n;
        this.attrval.w_dim.dim_y = n2;
        if (this.use_union) {
            this.attrval.value.uchar_att_value(byArray);
        } else {
            this.devAtt_3.insert_uc(sArray);
        }
    }

    public void insert_uc(byte[] byArray, int n, int n2) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = n;
        this.attrval.w_dim.dim_y = n2;
        if (this.use_union) {
            this.attrval.value.uchar_att_value(byArray);
        } else {
            this.devAtt_3.insert_uc(byArray);
        }
    }

    public void insert(short s) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = 1;
        this.attrval.w_dim.dim_y = 0;
        this.insert(new short[]{s});
    }

    public void insert(short[] sArray) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = sArray.length;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.short_att_value(sArray);
        } else {
            this.devAtt_3.insert(sArray);
        }
    }

    public void insert(short[] sArray, int n, int n2) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = n;
        this.attrval.w_dim.dim_y = n2;
        if (this.use_union) {
            this.attrval.value.short_att_value(sArray);
        } else {
            this.devAtt_3.insert(sArray);
        }
    }

    public void insert_us(short s) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        short[] sArray = new short[]{s};
        this.attrval.w_dim.dim_x = 1;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.ushort_att_value(sArray);
        } else {
            this.devAtt_3.insert_us(s);
        }
    }

    public void insert_us(int n) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        short[] sArray = new short[]{(short)(n & 0xFFFF)};
        this.attrval.w_dim.dim_x = 1;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.ushort_att_value(sArray);
        } else {
            this.devAtt_3.insert_us(n);
        }
    }

    public void insert_us(short[] sArray) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = sArray.length;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.ushort_att_value(sArray);
        } else {
            this.devAtt_3.insert_us(sArray);
        }
    }

    public void insert_us(int[] nArray) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        short[] sArray = new short[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            sArray[i] = (short)(nArray[i] & 0xFFFF);
        }
        this.attrval.w_dim.dim_x = nArray.length;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.ushort_att_value(sArray);
        } else {
            this.devAtt_3.insert_us(nArray);
        }
    }

    public void insert_us(short[] sArray, int n, int n2) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = n;
        this.attrval.w_dim.dim_y = n2;
        if (this.use_union) {
            this.attrval.value.ushort_att_value(sArray);
        } else {
            this.devAtt_3.insert_us(sArray);
        }
    }

    public void insert_us(int[] nArray, int n, int n2) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        short[] sArray = new short[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            sArray[i] = (short)(nArray[i] & 0xFFFF);
        }
        this.attrval.w_dim.dim_x = n;
        this.attrval.w_dim.dim_y = n2;
        if (this.use_union) {
            this.attrval.value.ushort_att_value(sArray);
        } else {
            this.devAtt_3.insert_us(nArray);
        }
    }

    public void insert(int n) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = 1;
        this.attrval.w_dim.dim_y = 0;
        this.insert(new int[]{n});
    }

    public void insert(int[] nArray) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = nArray.length;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.long_att_value(nArray);
        } else {
            this.devAtt_3.insert(nArray);
        }
    }

    public void insert(int[] nArray, int n, int n2) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = n;
        this.attrval.w_dim.dim_y = n2;
        if (this.use_union) {
            this.attrval.value.long_att_value(nArray);
        } else {
            this.devAtt_3.insert(nArray);
        }
    }

    public void insert(long l) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = 1;
        this.attrval.w_dim.dim_y = 0;
        this.insert(new long[]{l});
    }

    public void insert(long[] lArray) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = lArray.length;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.long64_att_value(lArray);
        } else {
            this.devAtt_3.insert(lArray);
        }
    }

    public void insert(long[] lArray, int n, int n2) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = n;
        this.attrval.w_dim.dim_y = n2;
        if (this.use_union) {
            this.attrval.value.long64_att_value(lArray);
        } else {
            this.devAtt_3.insert(lArray);
        }
    }

    public void insert_ul(int n) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        int[] nArray = new int[]{n};
        this.attrval.w_dim.dim_x = 1;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.ulong_att_value(nArray);
        } else {
            this.devAtt_3.insert_ul(n);
        }
    }

    public void insert_ul(long l) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        int[] nArray = new int[]{(int)l};
        this.attrval.w_dim.dim_x = 1;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.ulong_att_value(nArray);
        } else {
            this.devAtt_3.insert_ul(l);
        }
    }

    public void insert_ul(int[] nArray) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = nArray.length;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.ulong_att_value(nArray);
        } else {
            this.devAtt_3.insert_ul(nArray);
        }
    }

    public void insert_ul(long[] lArray) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        int[] nArray = new int[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            nArray[i] = (int)lArray[i];
        }
        this.attrval.w_dim.dim_x = lArray.length;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.ulong_att_value(nArray);
        } else {
            this.devAtt_3.insert_ul(lArray);
        }
    }

    public void insert_ul(int[] nArray, int n, int n2) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = n;
        this.attrval.w_dim.dim_y = n2;
        if (this.use_union) {
            this.attrval.value.ulong_att_value(nArray);
        } else {
            this.devAtt_3.insert_ul(nArray);
        }
    }

    public void insert_ul(long[] lArray, int n, int n2) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        int[] nArray = new int[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            nArray[i] = (int)lArray[i];
        }
        this.attrval.w_dim.dim_x = n;
        this.attrval.w_dim.dim_y = n2;
        if (this.use_union) {
            this.attrval.value.ulong_att_value(nArray);
        } else {
            this.devAtt_3.insert_ul(lArray);
        }
    }

    public void insert_u64(long l) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        long[] lArray = new long[]{l};
        this.attrval.w_dim.dim_x = 1;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.ulong64_att_value(lArray);
        } else {
            this.devAtt_3.insert_u64(l);
        }
    }

    public void insert_u64(long[] lArray) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = lArray.length;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.ulong64_att_value(lArray);
        } else {
            this.devAtt_3.insert_u64(lArray);
        }
    }

    public void insert_u64(long[] lArray, int n, int n2) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = n;
        this.attrval.w_dim.dim_y = n2;
        if (this.use_union) {
            this.attrval.value.ulong64_att_value(lArray);
        } else {
            this.devAtt_3.insert_u64(lArray);
        }
    }

    public void insert(float f) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = 1;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.float_att_value(new float[]{f});
        } else {
            this.devAtt_3.insert(f);
        }
    }

    public void insert(float[] fArray) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = fArray.length;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.float_att_value(fArray);
        } else {
            this.devAtt_3.insert(fArray);
        }
    }

    public void insert(float[] fArray, int n, int n2) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = n;
        this.attrval.w_dim.dim_y = n2;
        if (this.use_union) {
            this.attrval.value.float_att_value(fArray);
        } else {
            this.devAtt_3.insert(fArray);
        }
    }

    public void insert(double d) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = 1;
        this.attrval.w_dim.dim_y = 0;
        this.insert(new double[]{d});
    }

    public void insert(double[] dArray) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = dArray.length;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.double_att_value(dArray);
        } else {
            this.devAtt_3.insert(dArray);
        }
    }

    public void insert(double[] dArray, int n, int n2) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = n;
        this.attrval.w_dim.dim_y = n2;
        if (this.use_union) {
            this.attrval.value.double_att_value(dArray);
        } else {
            this.devAtt_3.insert(dArray);
        }
    }

    public void insert(String string) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = 1;
        this.attrval.w_dim.dim_y = 0;
        this.insert(new String[]{string});
    }

    public void insert(String[] stringArray) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = stringArray.length;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.string_att_value(stringArray);
        } else {
            this.devAtt_3.insert(stringArray);
        }
    }

    public void insert(String[] stringArray, int n, int n2) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = n;
        this.attrval.w_dim.dim_y = n2;
        if (this.use_union) {
            this.attrval.value.string_att_value(stringArray);
        } else {
            this.devAtt_3.insert(stringArray);
        }
    }

    public void insert(DevEncoded devEncoded) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.err_list = new DevError[0];
        this.attrval.w_dim.dim_x = 1;
        this.attrval.w_dim.dim_y = 0;
        this.attrval.value.encoded_att_value(new DevEncoded[]{devEncoded});
    }

    private void manageExceptions(String string) throws DevFailed {
        if (this.attrval.err_list != null && this.attrval.err_list.length > 0) {
            throw new WrongData(this.attrval.err_list);
        }
        if (this.attrval.quality == AttrQuality.ATTR_INVALID) {
            Except.throw_wrong_data_exception("AttrQuality_ATTR_INVALID", "Attribute quality factor is INVALID", "DeviceAttribute." + string + "()");
        }
    }

    public DevState[] extractDevStateArray() throws DevFailed {
        this.manageExceptions("extractDevStateArray()");
        try {
            if (this.use_union) {
                if (this.attrval.value.discriminator().value() == 12) {
                    return new DevState[]{this.attrval.value.dev_state_att()};
                }
                return this.attrval.value.state_att_value();
            }
            return this.devAtt_3.extractDevStateArray();
        }
        catch (BAD_PARAM bAD_PARAM) {
            Except.throw_wrong_data_exception(bAD_PARAM.toString(), "Exception catched : " + bAD_PARAM.toString() + "\n" + "Maybe the attribute value has not been initialized", "DeviceAttribute.extractDevStateArray()");
            return new DevState[0];
        }
    }

    public DevState extractDevState() throws DevFailed {
        this.manageExceptions("extractDevState");
        if (this.use_union) {
            if (this.attrval.value.discriminator().value() == 12) {
                return this.attrval.value.dev_state_att();
            }
            return this.attrval.value.state_att_value()[0];
        }
        return this.devAtt_3.extractDevState();
    }

    public boolean extractBoolean() throws DevFailed {
        this.manageExceptions("extractBoolean()");
        if (this.use_union) {
            return this.attrval.value.bool_att_value()[0];
        }
        return this.devAtt_3.extractBoolean();
    }

    public boolean[] extractBooleanArray() throws DevFailed {
        this.manageExceptions("extractBooleanArray()");
        if (this.use_union) {
            return this.attrval.value.bool_att_value();
        }
        return this.devAtt_3.extractBooleanArray();
    }

    public short extractUChar() throws DevFailed {
        this.manageExceptions("extractUChar");
        if (this.use_union) {
            return this.attrval.value.uchar_att_value()[0];
        }
        return this.devAtt_3.extractUChar();
    }

    public short[] extractUCharArray() throws DevFailed {
        this.manageExceptions("extractUCharArray()");
        if (this.use_union) {
            byte[] byArray = this.attrval.value.uchar_att_value();
            short[] sArray = new short[byArray.length];
            int n = 255;
            for (int i = 0; i < byArray.length; ++i) {
                sArray[i] = (short)(n & byArray[i]);
            }
            return sArray;
        }
        return this.devAtt_3.extractUCharArray();
    }

    public byte[] extractCharArray() throws DevFailed {
        this.manageExceptions("extractCharArray()");
        if (this.use_union) {
            return this.attrval.value.uchar_att_value();
        }
        return this.devAtt_3.extractCharArray();
    }

    public short extractShort() throws DevFailed {
        this.manageExceptions("extractShort()");
        if (this.use_union) {
            return this.attrval.value.short_att_value()[0];
        }
        return this.devAtt_3.extractShort();
    }

    public short[] extractShortArray() throws DevFailed {
        this.manageExceptions("extractShortArray");
        if (this.use_union) {
            return this.attrval.value.short_att_value();
        }
        return this.devAtt_3.extractShortArray();
    }

    public int extractUShort() throws DevFailed {
        this.manageExceptions("extractUShort");
        if (this.use_union) {
            return this.attrval.value.ushort_att_value()[0];
        }
        return this.devAtt_3.extractUShort();
    }

    public int[] extractUShortArray() throws DevFailed {
        this.manageExceptions("extractUShortArray");
        if (this.use_union) {
            short[] sArray = this.attrval.value.ushort_att_value();
            int[] nArray = new int[sArray.length];
            for (int i = 0; i < sArray.length; ++i) {
                nArray[i] = 0xFFFF & sArray[i];
            }
            return nArray;
        }
        return this.devAtt_3.extractUShortArray();
    }

    public int extractLong() throws DevFailed {
        this.manageExceptions("extractLong");
        if (this.use_union) {
            return this.attrval.value.long_att_value()[0];
        }
        return this.devAtt_3.extractLong();
    }

    public int[] extractLongArray() throws DevFailed {
        this.manageExceptions("extractLongArray");
        if (this.use_union) {
            return this.attrval.value.long_att_value();
        }
        return this.devAtt_3.extractLongArray();
    }

    public long extractULong() throws DevFailed {
        this.manageExceptions("extractULong");
        if (this.use_union) {
            int[] nArray = this.attrval.value.ulong_att_value();
            long l = Integer.MAX_VALUE;
            return (l += 0x80000000L) & (long)nArray[0];
        }
        return this.devAtt_3.extractULong();
    }

    public long[] extractULongArray() throws DevFailed {
        this.manageExceptions("extractULong");
        if (this.use_union) {
            int[] nArray = this.attrval.value.ulong_att_value();
            long l = Integer.MAX_VALUE;
            l += 0x80000000L;
            long[] lArray = new long[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                lArray[i] = l & (long)nArray[i];
            }
            return lArray;
        }
        return this.devAtt_3.extractULongArray();
    }

    public long extractLong64() throws DevFailed {
        this.manageExceptions("extractLong64");
        if (this.use_union) {
            return this.extractLong64Array()[0];
        }
        return this.devAtt_3.extractLong64();
    }

    public long[] extractLong64Array() throws DevFailed {
        this.manageExceptions("extractLong64Array");
        if (this.use_union) {
            return this.attrval.value.long64_att_value();
        }
        return this.devAtt_3.extractLong64Array();
    }

    public long extractULong64() throws DevFailed {
        this.manageExceptions("extractULong64");
        return this.extractULong64Array()[0];
    }

    public long[] extractULong64Array() throws DevFailed {
        this.manageExceptions("extractULong64Array");
        if (this.use_union) {
            return this.attrval.value.ulong64_att_value();
        }
        return this.devAtt_3.extractULong64Array();
    }

    public float extractFloat() throws DevFailed {
        this.manageExceptions("extractFloat");
        return this.extractFloatArray()[0];
    }

    public float[] extractFloatArray() throws DevFailed {
        this.manageExceptions("extractFloatArray");
        if (this.use_union) {
            return this.attrval.value.float_att_value();
        }
        return this.devAtt_3.extractFloatArray();
    }

    public double extractDouble() throws DevFailed {
        this.manageExceptions("extractDouble");
        return this.extractDoubleArray()[0];
    }

    public double[] extractDoubleArray() throws DevFailed {
        this.manageExceptions("extractDoubleArray");
        if (this.use_union) {
            return this.attrval.value.double_att_value();
        }
        return this.devAtt_3.extractDoubleArray();
    }

    public DevState extractState() throws DevFailed {
        this.manageExceptions("extractState");
        return this.extractDevState();
    }

    public String extractString() throws DevFailed {
        this.manageExceptions("extractString");
        return this.extractStringArray()[0];
    }

    public String[] extractStringArray() throws DevFailed {
        this.manageExceptions("extractStringArray");
        if (this.use_union) {
            return this.attrval.value.string_att_value();
        }
        return this.devAtt_3.extractStringArray();
    }

    public DevEncoded extractDevEncoded() throws DevFailed {
        this.manageExceptions("extractDevEncoded");
        if (this.attrval.value.encoded_att_value() == null) {
            Except.throw_exception("BAD_PARAM", "DevEcoded object is null", "DeviceAttribute.extractDevEncoded()");
        }
        return this.attrval.value.encoded_att_value()[0];
    }

    public DevEncoded[] extractDevEncodedArray() throws DevFailed {
        this.manageExceptions("extractDevEncoded");
        if (this.attrval.value.encoded_att_value() == null) {
            Except.throw_exception("BAD_PARAM", "DevEcoded object is null", "DeviceAttribute.extractDevEncoded()");
        }
        return this.attrval.value.encoded_att_value();
    }

    public AttrQuality getQuality() throws DevFailed {
        this.manageExceptions("getQuality");
        return this.attrval.quality;
    }

    public AttrDataFormat getDataFormat() throws DevFailed {
        return this.attrval.data_format;
    }

    public TimeVal getTimeVal() throws DevFailed {
        this.manageExceptions("getTimeVal");
        return this.attrval.time;
    }

    public long getTimeValSec() throws DevFailed {
        this.manageExceptions("getTimeValSec");
        return this.attrval.time.tv_sec;
    }

    public long getTimeValMillisSec() throws DevFailed {
        this.manageExceptions("getTimeValMillisSec");
        return (long)this.attrval.time.tv_sec * 1000L + (long)this.attrval.time.tv_usec / 1000L;
    }

    public String getName() throws DevFailed {
        return this.attrval.name;
    }

    private int DIM_MINI(int n) {
        return n == 0 ? 1 : n;
    }

    public int getNbRead() throws DevFailed {
        this.manageExceptions("getNbRead");
        return this.attrval.r_dim.dim_x * this.DIM_MINI(this.attrval.r_dim.dim_y);
    }

    public int getNbWritten() throws DevFailed {
        this.manageExceptions("getNbWritten");
        return this.attrval.w_dim.dim_x * this.DIM_MINI(this.attrval.w_dim.dim_y);
    }

    public int getDimX() throws DevFailed {
        this.manageExceptions("getDimX");
        return this.attrval.r_dim.dim_x;
    }

    public int getDimY() throws DevFailed {
        this.manageExceptions("getDimY");
        return this.attrval.r_dim.dim_y;
    }

    public int getWrittenDimX() throws DevFailed {
        this.manageExceptions("getWrittenDimX");
        return this.attrval.w_dim.dim_x;
    }

    public int getWrittenDimY() throws DevFailed {
        this.manageExceptions("getWrittenDimY");
        return this.attrval.w_dim.dim_y;
    }

    public AttributeValue getAttributeValueObject_2() {
        DeviceAttribute_3DAODefaultImpl deviceAttribute_3DAODefaultImpl = new DeviceAttribute_3DAODefaultImpl();
        deviceAttribute_3DAODefaultImpl.setAttributeValue(this);
        AttributeValue attributeValue = deviceAttribute_3DAODefaultImpl.getAttributeValueObject_2();
        return attributeValue;
    }

    public AttributeValue_3 getAttributeValueObject_3() {
        DeviceAttribute_3 deviceAttribute_3 = new DeviceAttribute_3();
        deviceAttribute_3.setAttributeValue(this);
        return deviceAttribute_3.getAttributeValueObject_3();
    }

    public AttributeValue_4 getAttributeValueObject_4() {
        return this.attrval;
    }

    public long getTime() throws DevFailed {
        this.manageExceptions("getTime");
        return (long)this.attrval.time.tv_sec * 1000L + (long)(this.attrval.time.tv_usec / 1000);
    }

    public int getType() throws DevFailed {
        if (!this.use_union) {
            return this.devAtt_3.getType();
        }
        if (this.attrval.value == null || this.attrval.value.discriminator() == null) {
            Except.throw_exception("AttributeTypeNotSet", "Attribute " + this.attrval.name + " Value Has Not Been Set", "DeviceAttribute.getType()");
        }
        int n = -1;
        try {
            switch (this.attrval.value.discriminator().value()) {
                case 0: {
                    n = 1;
                    break;
                }
                case 1: {
                    n = 2;
                    break;
                }
                case 2: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 23;
                    break;
                }
                case 4: {
                    n = 4;
                    break;
                }
                case 5: {
                    n = 5;
                    break;
                }
                case 6: {
                    n = 22;
                    break;
                }
                case 7: {
                    n = 6;
                    break;
                }
                case 8: {
                    n = 7;
                    break;
                }
                case 9: {
                    n = 24;
                    break;
                }
                case 10: {
                    n = 8;
                    break;
                }
                case 11: 
                case 12: {
                    n = 19;
                    break;
                }
                case 13: {
                    n = 28;
                    break;
                }
                case 14: {
                    n = 0;
                    break;
                }
                default: {
                    Except.throw_exception("AttributeTypeNotSupported", "Attribute Type (" + this.attrval.value.discriminator().value() + ") Not Supported", "DeviceAttribute.getType()");
                    break;
                }
            }
        }
        catch (BAD_PARAM bAD_PARAM) {
            Except.throw_exception("Api_TypeCodePackage.BadKind", "Bad or unknown type ", "DeviceAttribute.getType()");
        }
        return n;
    }

    void setValueAsAny(DeviceAttribute_3DAODefaultImpl deviceAttribute_3DAODefaultImpl) throws DevFailed {
        switch (this.getType()) {
            case 1: {
                deviceAttribute_3DAODefaultImpl.insert(this.extractBooleanArray());
                break;
            }
            case 2: {
                deviceAttribute_3DAODefaultImpl.insert(this.extractShortArray());
                break;
            }
            case 3: {
                deviceAttribute_3DAODefaultImpl.insert(this.extractLongArray());
                break;
            }
            case 23: {
                deviceAttribute_3DAODefaultImpl.insert(this.extractLong64Array());
                break;
            }
            case 4: {
                deviceAttribute_3DAODefaultImpl.insert(this.extractFloatArray());
                break;
            }
            case 5: {
                deviceAttribute_3DAODefaultImpl.insert(this.extractDoubleArray());
                break;
            }
            case 22: {
                deviceAttribute_3DAODefaultImpl.insert_uc(this.extractUCharArray());
                break;
            }
            case 6: {
                deviceAttribute_3DAODefaultImpl.insert_us(this.extractUShortArray());
                break;
            }
            case 7: {
                deviceAttribute_3DAODefaultImpl.insert_ul(this.extractULongArray());
                break;
            }
            case 24: {
                deviceAttribute_3DAODefaultImpl.insert_u64(this.extractULong64Array());
                break;
            }
            case 8: {
                deviceAttribute_3DAODefaultImpl.insert(this.extractStringArray());
                break;
            }
            case 19: {
                deviceAttribute_3DAODefaultImpl.insert(this.extractDevStateArray());
            }
        }
    }
}

