/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.AccessProxy;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Connection;
import fr.esrf.TangoApi.ConnectionDAODefaultImpl;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevExportInfo;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbDevInfo;
import fr.esrf.TangoApi.DbHistory;
import fr.esrf.TangoApi.DbServInfo;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceInfo;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.IDatabaseDAO;
import fr.esrf.TangoApi.events.DbEventImportInfo;
import fr.esrf.TangoDs.Except;
import java.util.StringTokenizer;
import java.util.Vector;

public class DatabaseDAODefaultImpl
extends ConnectionDAODefaultImpl
implements IDatabaseDAO {
    private boolean access_service_read = false;

    public void init(Database database) throws DevFailed {
        super.init(database);
    }

    public void init(Database database, String string, String string2) throws DevFailed {
        super.init((Connection)database, string, string2);
    }

    public String toString(Database database) {
        return database.url.host + ":" + database.url.port;
    }

    private String stringArray2String(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private void checkAccess(Database database) {
        if (database.check_access && !database.isAccess_checked()) {
            database.access = this.checkAccessControl(database, database.devname);
            database.setAccess_checked(true);
            ApiUtil.getReconnectionDelay();
        }
    }

    public String get_info(Database database) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = this.command_inout(database, "DbInfo");
        String[] stringArray = deviceData.extractStringArray();
        return this.stringArray2String(stringArray);
    }

    public String[] get_host_list(Database database) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert("*");
        DeviceData deviceData2 = this.command_inout(database, "DbGetHostList", deviceData);
        return deviceData2.extractStringArray();
    }

    public String[] get_host_list(Database database, String string) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout(database, "DbGetHostList", deviceData);
        return deviceData2.extractStringArray();
    }

    public String[] get_server_class_list(Database database, String string) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout(database, "DbGetDeviceServerClassList", deviceData);
        String[] stringArray = deviceData2.extractStringArray();
        int n = stringArray.length == 0 ? 0 : stringArray.length - 1;
        String[] stringArray2 = new String[n];
        int n2 = 0;
        for (int i = 0; i < stringArray.length && n2 < n; ++i) {
            if (stringArray[i].equals("DServer")) continue;
            stringArray2[n2++] = stringArray[i];
        }
        return stringArray2;
    }

    public String[] get_server_name_list(Database database) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert("*");
        DeviceData deviceData2 = this.command_inout(database, "DbGetServerNameList", deviceData);
        return deviceData2.extractStringArray();
    }

    public String[] get_instance_name_list(Database database, String string) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout(database, "DbGetInstanceNameList", deviceData);
        return deviceData2.extractStringArray();
    }

    public String[] get_server_list(Database database) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert("*");
        DeviceData deviceData2 = this.command_inout(database, "DbGetServerList", deviceData);
        return deviceData2.extractStringArray();
    }

    public String[] get_server_list(Database database, String string) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout(database, "DbGetServerList", deviceData);
        return deviceData2.extractStringArray();
    }

    public String[] get_host_server_list(Database database, String string) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout(database, "DbGetHostServerList", deviceData);
        return deviceData2.extractStringArray();
    }

    public DbServInfo get_server_info(Database database, String string) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout(database, "DbGetServerInfo", deviceData);
        String[] stringArray = deviceData2.extractStringArray();
        return new DbServInfo(stringArray);
    }

    public void put_server_info(Database database, DbServInfo dbServInfo) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] stringArray = new String[]{dbServInfo.name, dbServInfo.host, dbServInfo.controlled ? "1" : "0", Integer.toString(dbServInfo.startup_level)};
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray);
        this.command_inout(database, "DbPutServerInfo", deviceData);
    }

    public void delete_server_info(Database database, String string) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        this.command_inout(database, "DbDeleteServerInfo", deviceData);
    }

    public void add_device(Database database, DbDevInfo dbDevInfo) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(dbDevInfo.toStringArray());
        this.command_inout(database, "DbAddDevice", deviceData);
    }

    public void add_device(Database database, String string, String string2, String string3) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DbDevInfo dbDevInfo = new DbDevInfo(string, string2, string3);
        DeviceData deviceData = new DeviceData();
        deviceData.insert(dbDevInfo.toStringArray());
        this.command_inout(database, "DbAddDevice", deviceData);
    }

    public void delete_device(Database database, String string) throws DevFailed {
        Object object;
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        boolean bl = true;
        try {
            object = new DeviceProxy(string);
            ((Connection)object).ping();
            bl = false;
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        if (bl) {
            object = new DeviceData();
            ((DeviceData)object).insert(string);
            this.command_inout(database, "DbDeleteDevice", (DeviceData)object);
        } else {
            Except.throw_connection_failed("TangoApi_DEVICE_ALIVE", "Cannot delete a device which is ALIVE.", "delete_device()");
        }
    }

    public DeviceInfo get_device_info(Database database, String string) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout(database, "DbGetDeviceInfo", deviceData);
        DevVarLongStringArray devVarLongStringArray = deviceData2.extractLongStringArray();
        return new DeviceInfo(devVarLongStringArray);
    }

    public String[] get_device_list(Database database, String string) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout(database, "DbGetDeviceWideList", deviceData);
        return deviceData2.extractStringArray();
    }

    public DbDevImportInfo import_device(Database database, String string) throws DevFailed {
        int n = database.access;
        database.access = 1;
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout(database, "DbImportDevice", deviceData);
        DevVarLongStringArray devVarLongStringArray = deviceData2.extractLongStringArray();
        database.access = n;
        return new DbDevImportInfo(devVarLongStringArray);
    }

    public void unexport_device(Database database, String string) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        this.command_inout(database, "DbUnExportDevice", deviceData);
    }

    public void export_device(Database database, DbDevExportInfo dbDevExportInfo) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] stringArray = dbDevExportInfo.toStringArray();
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray);
        this.command_inout(database, "DbExportDevice", deviceData);
    }

    public String[] get_device_class_list(Database database, String string) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout(database, "DbGetDeviceClassList", deviceData);
        return deviceData2.extractStringArray();
    }

    public String[] get_device_name(Database database, String string, String string2) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] stringArray = new String[]{string, string2};
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray);
        DeviceData deviceData2 = this.command_inout(database, "DbGetDeviceList", deviceData);
        return deviceData2.extractStringArray();
    }

    public String[] get_device_domain(Database database, String string) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout(database, "DbGetDeviceDomainList", deviceData);
        return deviceData2.extractStringArray();
    }

    public String[] get_device_family(Database database, String string) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout(database, "DbGetDeviceFamilyList", deviceData);
        return deviceData2.extractStringArray();
    }

    public String[] get_device_member(Database database, String string) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout(database, "DbGetDeviceMemberList", deviceData);
        return deviceData2.extractStringArray();
    }

    public void add_server(Database database, String string, DbDevInfo[] dbDevInfoArray) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] stringArray = new String[1 + 2 * dbDevInfoArray.length];
        stringArray[0] = string;
        for (int i = 0; i < dbDevInfoArray.length; ++i) {
            stringArray[2 * i + 1] = dbDevInfoArray[i].name;
            stringArray[2 * i + 2] = dbDevInfoArray[i]._class;
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray);
        this.command_inout(database, "DbAddServer", deviceData);
    }

    public void delete_server(Database database, String string) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        this.command_inout(database, "DbDeleteServer", deviceData);
    }

    public void export_server(Database database, DbDevExportInfo[] dbDevExportInfoArray) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] stringArray = new String[6 * dbDevExportInfoArray.length];
        for (int i = 0; i < dbDevExportInfoArray.length; ++i) {
            String[] stringArray2 = dbDevExportInfoArray[i].toStringArray();
            for (int j = 0; j < 6; ++j) {
                stringArray[6 * i + j] = stringArray2[j];
            }
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray);
        this.command_inout(database, "DbExportServer", deviceData);
    }

    public void unexport_server(Database database, String string) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        this.command_inout(database, "DbUnExportServer", deviceData);
    }

    private String[] dbdatum2StringArray(String string, DbDatum[] dbDatumArray) {
        int n = 2;
        for (DbDatum stringArray : dbDatumArray) {
            n += 2;
            n += stringArray.size();
        }
        Object[] objectArray = new String[n];
        objectArray[0] = string;
        objectArray[1] = String.valueOf(dbDatumArray.length);
        int n2 = 2;
        for (int i = 0; i < dbDatumArray.length; ++i) {
            String[] stringArray;
            for (String string2 : stringArray = dbDatumArray[i].toStringArray()) {
                objectArray[n2++] = string2;
            }
        }
        return objectArray;
    }

    private DbDatum[] stringArray2DbDatum(String[] stringArray) {
        int n = Integer.parseInt(stringArray[1]);
        DbDatum[] dbDatumArray = new DbDatum[n];
        int n2 = 2;
        int n3 = 0;
        while (n2 < stringArray.length - 1) {
            int n4 = Integer.parseInt(stringArray[n2 + 1]);
            int n5 = n2 + 2;
            int n6 = n2 + 2 + n4;
            if (n4 > 0) {
                dbDatumArray[n3++] = new DbDatum(stringArray[n2], stringArray, n5, n6);
            } else {
                String string;
                dbDatumArray[n3++] = new DbDatum(stringArray[n2]);
                if (n5 + 1 < stringArray.length && ((string = stringArray[n5]).length() == 0 || string.equals(" "))) {
                    n6 = n5 + 1;
                }
            }
            n2 = n6;
        }
        return dbDatumArray;
    }

    private DbDatum[] get_obj_property(Database database, String string, String string2, DbDatum[] dbDatumArray) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] stringArray = new String[dbDatumArray.length];
        for (int i = 0; i < dbDatumArray.length; ++i) {
            stringArray[i] = dbDatumArray[i].name;
        }
        return this.get_obj_property(database, string, string2, stringArray);
    }

    private DbDatum get_obj_property(Database database, String string, String string2, String string3) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] stringArray = new String[]{string3};
        DbDatum[] dbDatumArray = this.get_obj_property(database, string, string2, stringArray);
        return dbDatumArray[0];
    }

    private DbDatum[] get_obj_property(Database database, String string, String string2, String[] stringArray) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] stringArray2 = new String[1 + stringArray.length];
        stringArray2[0] = string;
        for (int i = 1; i < stringArray.length + 1; ++i) {
            stringArray2[i] = stringArray[i - 1];
        }
        String string3 = "DbGet" + string2 + "Property";
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray2);
        DeviceData deviceData2 = this.command_inout(database, string3, deviceData);
        String[] stringArray3 = deviceData2.extractStringArray();
        return this.stringArray2DbDatum(stringArray3);
    }

    private void delete_obj_property(Database database, String string, String string2, DbDatum[] dbDatumArray) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] stringArray = new String[dbDatumArray.length];
        for (int i = 0; i < dbDatumArray.length; ++i) {
            stringArray[i] = dbDatumArray[i].name;
        }
        this.delete_obj_property(database, string, string2, stringArray);
    }

    private void delete_obj_property(Database database, String string, String string2, String string3) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] stringArray = new String[]{string3};
        this.delete_obj_property(database, string, string2, stringArray);
    }

    private void delete_obj_property(Database database, String string, String string2, String[] stringArray) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = string;
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        String string3 = "DbDelete" + string2 + "Property";
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray2);
        this.command_inout(database, string3, deviceData);
    }

    public String[] get_object_list(Database database, String string) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout(database, "DbGetObjectList", deviceData);
        return deviceData2.extractStringArray();
    }

    public String[] get_object_property_list(Database database, String string, String string2) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] stringArray = new String[]{string, string2};
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray);
        DeviceData deviceData2 = this.command_inout(database, "DbGetPropertyList", deviceData);
        return deviceData2.extractStringArray();
    }

    public DbDatum[] get_property(Database database, String string, String[] stringArray) throws DevFailed {
        String string2 = "";
        return this.get_obj_property(database, string, string2, stringArray);
    }

    public DbDatum get_property(Database database, String string, String string2) throws DevFailed {
        String string3 = "";
        return this.get_obj_property(database, string, string3, string2);
    }

    public DbDatum get_property(Database database, String string, String string2, boolean bl) throws DevFailed {
        int n = database.access;
        if (bl) {
            database.access = 1;
        }
        DbDatum dbDatum = null;
        try {
            String[] stringArray = new String[]{string, string2};
            DeviceData deviceData = new DeviceData();
            deviceData.insert(stringArray);
            DeviceData deviceData2 = this.command_inout(database, "DbGetProperty", deviceData);
            String[] stringArray2 = deviceData2.extractStringArray();
            dbDatum = this.stringArray2DbDatum(stringArray2)[0];
            database.access = n;
        }
        catch (DevFailed devFailed) {
            database.access = n;
            throw devFailed;
        }
        return dbDatum;
    }

    public DbDatum[] get_property(Database database, String string, DbDatum[] dbDatumArray) throws DevFailed {
        String string2 = "";
        return this.get_obj_property(database, string, string2, dbDatumArray);
    }

    public void put_property(Database database, String string, DbDatum[] dbDatumArray) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] stringArray = this.dbdatum2StringArray(string, dbDatumArray);
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray);
        this.command_inout(database, "DbPutProperty", deviceData);
    }

    public void delete_property(Database database, String string, String[] stringArray) throws DevFailed {
        String string2 = "";
        this.delete_obj_property(database, string, string2, stringArray);
    }

    public void delete_property(Database database, String string, String string2) throws DevFailed {
        String string3 = "";
        this.delete_obj_property(database, string, string3, string2);
    }

    public void delete_property(Database database, String string, DbDatum[] dbDatumArray) throws DevFailed {
        String string2 = "";
        this.delete_obj_property(database, string, string2, dbDatumArray);
    }

    public String[] get_class_property_list(Database database, String string, String string2) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout(database, "DbGetClassPropertyList", deviceData);
        return deviceData2.extractStringArray();
    }

    public String[] get_device_property_list(Database database, String string, String string2) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] stringArray = new String[]{string, string2};
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray);
        DeviceData deviceData2 = this.command_inout(database, "DbGetDevicePropertyList", deviceData);
        return deviceData2.extractStringArray();
    }

    public String get_class_for_device(Database database, String string) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout(database, "DbGetClassForDevice", deviceData);
        return deviceData2.extractString();
    }

    public String[] get_class_inheritance_for_device(Database database, String string) throws DevFailed {
        String[] stringArray;
        block3: {
            if (!database.isAccess_checked()) {
                this.checkAccess(database);
            }
            stringArray = new String[]{"Device_3Impl"};
            try {
                DeviceData deviceData = new DeviceData();
                deviceData.insert(string);
                DeviceData deviceData2 = this.command_inout(database, "DbGetClassInheritanceForDevice", deviceData);
                stringArray = deviceData2.extractStringArray();
            }
            catch (DevFailed devFailed) {
                if (devFailed.errors[0].reason.equals("API_CommandNotFound")) break block3;
                throw devFailed;
            }
        }
        return stringArray;
    }

    public DbDatum[] get_device_property(Database database, String string, String[] stringArray) throws DevFailed {
        String string2 = "Device";
        return this.get_obj_property(database, string, string2, stringArray);
    }

    public DbDatum get_device_property(Database database, String string, String string2) throws DevFailed {
        String string3 = "Device";
        return this.get_obj_property(database, string, string3, string2);
    }

    public DbDatum[] get_device_property(Database database, String string, DbDatum[] dbDatumArray) throws DevFailed {
        String string2 = "Device";
        return this.get_obj_property(database, string, string2, dbDatumArray);
    }

    public void put_device_property(Database database, String string, DbDatum[] dbDatumArray) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] stringArray = this.dbdatum2StringArray(string, dbDatumArray);
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray);
        this.command_inout(database, "DbPutDeviceProperty", deviceData);
    }

    public void delete_device_property(Database database, String string, String[] stringArray) throws DevFailed {
        String string2 = "Device";
        this.delete_obj_property(database, string, string2, stringArray);
    }

    public void delete_device_property(Database database, String string, String string2) throws DevFailed {
        String string3 = "Device";
        this.delete_obj_property(database, string, string3, string2);
    }

    public void delete_device_property(Database database, String string, DbDatum[] dbDatumArray) throws DevFailed {
        String string2 = "Device";
        this.delete_obj_property(database, string, string2, dbDatumArray);
    }

    public String[] get_device_attribute_list(Database database, String string) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(new String[]{string, "*"});
        DeviceData deviceData2 = this.command_inout(database, "DbGetDeviceAttributeList", deviceData);
        return deviceData2.extractStringArray();
    }

    public DbAttribute[] get_device_attribute_property(Database database, String string, String[] stringArray) throws DevFailed {
        DeviceData deviceData;
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData2 = new DeviceData();
        int n = 2;
        try {
            deviceData2.insert(ApiUtil.toStringArray(string, stringArray));
            deviceData = this.command_inout(database, "DbGetDeviceAttributeProperty2", deviceData2);
        }
        catch (DevFailed devFailed) {
            if (devFailed.errors[0].reason.equals("API_CommandNotFound")) {
                deviceData = this.command_inout(database, "DbGetDeviceAttributeProperty", deviceData2);
                n = 1;
            }
            throw devFailed;
        }
        return ApiUtil.toDbAttributeArray(deviceData.extractStringArray(), n);
    }

    public DbAttribute get_device_attribute_property(Database database, String string, String string2) throws DevFailed {
        String[] stringArray = new String[]{string2};
        return this.get_device_attribute_property(database, string, stringArray)[0];
    }

    public void put_device_attribute_property(Database database, String string, DbAttribute[] dbAttributeArray) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        try {
            deviceData.insert(ApiUtil.toStringArray(string, dbAttributeArray, 2));
            this.command_inout(database, "DbPutDeviceAttributeProperty2", deviceData);
        }
        catch (DevFailed devFailed) {
            if (devFailed.errors[0].reason.equals("API_CommandNotFound")) {
                deviceData.insert(ApiUtil.toStringArray(string, dbAttributeArray, 1));
                this.command_inout(database, "DbPutDeviceAttributeProperty", deviceData);
            }
            throw devFailed;
        }
    }

    public void put_device_attribute_property(Database database, String string, DbAttribute dbAttribute) throws DevFailed {
        DbAttribute[] dbAttributeArray = new DbAttribute[]{dbAttribute};
        this.put_device_attribute_property(database, string, dbAttributeArray);
    }

    public void delete_device_attribute_property(Database database, String string, DbAttribute dbAttribute) throws DevFailed {
        this.delete_device_attribute_property(database, string, dbAttribute.name, dbAttribute.get_property_list());
    }

    public void delete_device_attribute_property(Database database, String string, DbAttribute[] dbAttributeArray) throws DevFailed {
        for (DbAttribute dbAttribute : dbAttributeArray) {
            this.delete_device_attribute_property(database, string, dbAttribute.name, dbAttribute.get_property_list());
        }
    }

    public void delete_device_attribute_property(Database database, String string, String string2, String[] stringArray) throws DevFailed {
        if (stringArray.length == 0) {
            return;
        }
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] stringArray2 = new String[2 + stringArray.length];
        stringArray2[0] = string;
        stringArray2[1] = string2;
        System.arraycopy(stringArray, 0, stringArray2, 2, stringArray.length);
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray2);
        this.command_inout(database, "DbDeleteDeviceAttributeProperty", deviceData);
    }

    public void delete_device_attribute_property(Database database, String string, String string2, String string3) throws DevFailed {
        String[] stringArray = new String[]{string3};
        this.delete_device_attribute_property(database, string, string2, stringArray);
    }

    public void delete_device_attribute(Database database, String string, String string2) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] stringArray = new String[]{string, string2};
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray);
        this.command_inout(database, "DbDeleteDeviceAttribute", deviceData);
    }

    public String[] get_class_list(Database database, String string) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout(database, "DbGetClassList", deviceData);
        return deviceData2.extractStringArray();
    }

    public DbDatum[] get_class_property(Database database, String string, String[] stringArray) throws DevFailed {
        String string2 = "Class";
        return this.get_obj_property(database, string, string2, stringArray);
    }

    public DbDatum get_class_property(Database database, String string, String string2) throws DevFailed {
        String string3 = "Class";
        return this.get_obj_property(database, string, string3, string2);
    }

    public DbDatum[] get_class_property(Database database, String string, DbDatum[] dbDatumArray) throws DevFailed {
        String string2 = "Class";
        return this.get_obj_property(database, string, string2, dbDatumArray);
    }

    public void put_class_property(Database database, String string, DbDatum[] dbDatumArray) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] stringArray = this.dbdatum2StringArray(string, dbDatumArray);
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray);
        this.command_inout(database, "DbPutClassProperty", deviceData);
    }

    public void delete_class_property(Database database, String string, String[] stringArray) throws DevFailed {
        String string2 = "Class";
        this.delete_obj_property(database, string, string2, stringArray);
    }

    public void delete_class_property(Database database, String string, String string2) throws DevFailed {
        String string3 = "Class";
        this.delete_obj_property(database, string, string3, string2);
    }

    public void delete_class_property(Database database, String string, DbDatum[] dbDatumArray) throws DevFailed {
        String string2 = "Class";
        this.delete_obj_property(database, string, string2, dbDatumArray);
    }

    public String[] get_class_attribute_list(Database database, String string, String string2) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(ApiUtil.toStringArray(string, string2));
        DeviceData deviceData2 = this.command_inout(database, "DbGetClassAttributeList", deviceData);
        return deviceData2.extractStringArray();
    }

    public DbAttribute get_class_attribute_property(Database database, String string, String string2) throws DevFailed {
        String[] stringArray = new String[]{string2};
        return this.get_class_attribute_property(database, string, stringArray)[0];
    }

    public DbAttribute[] get_class_attribute_property(Database database, String string, String[] stringArray) throws DevFailed {
        DeviceData deviceData;
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData2 = new DeviceData();
        int n = 2;
        try {
            deviceData2.insert(ApiUtil.toStringArray(string, stringArray));
            deviceData = this.command_inout(database, "DbGetClassAttributeProperty2", deviceData2);
        }
        catch (DevFailed devFailed) {
            if (devFailed.errors[0].reason.equals("API_CommandNotFound")) {
                deviceData = this.command_inout(database, "DbGetClassAttributeProperty", deviceData2);
                n = 1;
            }
            throw devFailed;
        }
        return ApiUtil.toDbAttributeArray(deviceData.extractStringArray(), n);
    }

    public void put_class_attribute_property(Database database, String string, DbAttribute[] dbAttributeArray) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(ApiUtil.toStringArray(string, dbAttributeArray, 2));
        this.command_inout(database, "DbPutClassAttributeProperty2", deviceData);
    }

    public void put_class_attribute_property(Database database, String string, DbAttribute dbAttribute) throws DevFailed {
        DbAttribute[] dbAttributeArray = new DbAttribute[]{dbAttribute};
        this.put_class_attribute_property(database, string, dbAttributeArray);
    }

    public void delete_class_attribute_property(Database database, String string, String string2, String string3) throws DevFailed {
        String[] stringArray = new String[]{string3};
        this.delete_class_attribute_property(database, string, string2, stringArray);
    }

    public void delete_class_attribute_property(Database database, String string, String string2, String[] stringArray) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] stringArray2 = new String[2 + stringArray.length];
        stringArray2[0] = string;
        stringArray2[1] = string2;
        System.arraycopy(stringArray, 0, stringArray2, 2, stringArray.length);
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray2);
        this.command_inout(database, "DbDeleteClassAttributeProperty", deviceData);
    }

    public String[] get_device_exported(Database database, String string) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout(database, "DbGetDeviceExportedList", deviceData);
        return deviceData2.extractStringArray();
    }

    public String[] get_device_exported_for_class(Database database, String string) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout(database, "DbGetExportdDeviceListForClass", deviceData);
        return deviceData2.extractStringArray();
    }

    public String[] get_device_alias_list(Database database, String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout(database, "DbGetDeviceAliasList", deviceData);
        return deviceData2.extractStringArray();
    }

    public String get_device_alias(Database database, String string) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout(database, "DbGetDeviceAlias", deviceData);
        return deviceData2.extractString();
    }

    public String get_alias_device(Database database, String string) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout(database, "DbGetAliasDevice", deviceData);
        return deviceData2.extractString();
    }

    public void put_device_alias(Database database, String string, String string2) throws DevFailed {
        String[] stringArray = new String[]{string, string2};
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray);
        this.command_inout(database, "DbPutDeviceAlias", deviceData);
    }

    public void delete_device_alias(Database database, String string) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        this.command_inout(database, "DbDeleteDeviceAlias", deviceData);
    }

    public String[] get_attribute_alias_list(Database database, String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout(database, "DbGetAttributeAliasList", deviceData);
        return deviceData2.extractStringArray();
    }

    public String get_attribute_alias(Database database, String string) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout(database, "DbGetAttributeAlias", deviceData);
        return deviceData2.extractString();
    }

    public void put_attribute_alias(Database database, String string, String string2) throws DevFailed {
        String[] stringArray = new String[]{string, string2};
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray);
        this.command_inout(database, "DbPutAttributeAlias", deviceData);
    }

    public void delete_attribute_alias(Database database, String string) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        this.command_inout(database, "DbDeleteAttributeAlias", deviceData);
    }

    public String[] getDevices(Database database, String string) throws DevFailed {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        if (vector.size() < 3) {
            Except.throw_exception("TangoApi_DeviceNameNotValid", "Device name not valid", "ATangoApi.Database.getDevices()");
        }
        String string2 = (String)vector.elementAt(0);
        String string3 = (String)vector.elementAt(1);
        String string4 = (String)vector.elementAt(2);
        vector.clear();
        String[] stringArray = this.get_device_domain(database, string2);
        if (stringArray.length == 0) {
            stringArray = new String[]{string2};
        }
        for (String string5 : stringArray) {
            String string6 = string5 + "/";
            String[] stringArray2 = this.get_device_family(database, string6 + string3);
            if (stringArray2.length == 0) {
                stringArray2 = new String[]{string3};
            }
            for (String string7 : stringArray2) {
                String[] stringArray3;
                String string8 = string6 + string7 + "/";
                for (String string9 : stringArray3 = this.get_device_member(database, string8 + string4)) {
                    vector.add(string8 + string9);
                }
            }
        }
        String[] stringArray4 = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray4[i] = (String)vector.elementAt(i);
        }
        return stringArray4;
    }

    public DbEventImportInfo import_event(Database database, String string) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout(database, "DbImportEvent", deviceData);
        DevVarLongStringArray devVarLongStringArray = deviceData2.extractLongStringArray();
        return new DbEventImportInfo(devVarLongStringArray);
    }

    private DbHistory[] convertPropertyHistory(String[] stringArray, boolean bl) throws DevFailed {
        Object[] objectArray;
        int n;
        int n2;
        Vector<DbHistory> vector = new Vector<DbHistory>();
        int n3 = 0;
        String string = "";
        for (n = 0; n < stringArray.length; n += n3 + n2) {
            String string2;
            String string3;
            String string4;
            if (bl) {
                string = stringArray[n];
                string4 = stringArray[n + 1];
                string3 = stringArray[n + 2];
                string2 = stringArray[n + 3];
                n2 = 4;
            } else {
                string4 = stringArray[n];
                string3 = stringArray[n + 1];
                string2 = stringArray[n + 2];
                n2 = 3;
            }
            try {
                n3 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Except.throw_exception("TangoApi_HisotryInvalid", "History format is invalid", "ATangoApi.Database.convertPropertyHistory()");
            }
            objectArray = new String[n3];
            for (int i = 0; i < n3; ++i) {
                objectArray[i] = stringArray[n + n2 + i];
            }
            if (bl) {
                vector.add(new DbHistory(string, string4, string3, (String[])objectArray));
                continue;
            }
            vector.add(new DbHistory(string4, string3, (String[])objectArray));
        }
        objectArray = new DbHistory[vector.size()];
        for (n = 0; n < objectArray.length; ++n) {
            objectArray[n] = (DbHistory)vector.get(n);
        }
        return objectArray;
    }

    public DbHistory[] get_device_property_history(Database database, String string, String string2) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(new String[]{string, string2});
        DeviceData deviceData2 = this.command_inout(database, "DbGetDevicePropertyHist", deviceData);
        return this.convertPropertyHistory(deviceData2.extractStringArray(), false);
    }

    public DbHistory[] get_device_attribute_property_history(Database database, String string, String string2, String string3) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(new String[]{string, string2, string3});
        DeviceData deviceData2 = this.command_inout(database, "DbGetDeviceAttributePropertyHist", deviceData);
        return this.convertPropertyHistory(deviceData2.extractStringArray(), true);
    }

    public DbHistory[] get_class_property_history(Database database, String string, String string2) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(new String[]{string, string2});
        DeviceData deviceData2 = this.command_inout(database, "DbGetClassPropertyHist", deviceData);
        return this.convertPropertyHistory(deviceData2.extractStringArray(), false);
    }

    public DbHistory[] get_class_attribute_property_history(Database database, String string, String string2, String string3) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(new String[]{string, string2, string3});
        DeviceData deviceData2 = this.command_inout(database, "DbGetClassAttributePropertyHist", deviceData);
        return this.convertPropertyHistory(deviceData2.extractStringArray(), true);
    }

    public DbHistory[] get_property_history(Database database, String string, String string2) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(new String[]{string, string2});
        DeviceData deviceData2 = this.command_inout(database, "DbGetPropertyHist", deviceData);
        return this.convertPropertyHistory(deviceData2.extractStringArray(), false);
    }

    public String[] getServices(Database database, String string, String string2) throws DevFailed {
        String[] stringArray;
        Vector<String> vector = new Vector<String>();
        DbDatum dbDatum = this.get_property(database, "CtrlSystem", "Services", true);
        if (!dbDatum.is_empty()) {
            int n;
            stringArray = dbDatum.extractStringArray();
            String string3 = string.toLowerCase();
            if (!string2.equals("*")) {
                string3 = string3 + "/" + string2.toLowerCase();
                n = 58;
            } else {
                n = 47;
            }
            for (String string4 : stringArray) {
                String string5;
                int n2 = string4.indexOf(n);
                if (n2 <= 0 || !(string5 = string4.substring(0, n2).toLowerCase()).equals(string3)) continue;
                vector.add(string4.substring(string4.indexOf(58) + 1));
            }
        }
        stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.get(i);
        }
        return stringArray;
    }

    public void registerService(Database database, String string, String string2, String string3) throws DevFailed {
        String[] stringArray = new String[]{};
        DbDatum dbDatum = this.get_property(database, "CtrlSystem", "Services");
        if (!dbDatum.is_empty()) {
            stringArray = dbDatum.extractStringArray();
        }
        String string4 = string + "/" + string2;
        String string5 = string4.toLowerCase();
        string4 = string4 + ":" + string3;
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        for (String string6 : stringArray) {
            String string7 = string6.toLowerCase();
            int n = string7.indexOf(58);
            if (n > 0) {
                string7 = string7.substring(0, n);
            }
            if (string7.equals(string5)) {
                bl = true;
                vector.add(string4);
                continue;
            }
            vector.add(string6);
        }
        if (!bl) {
            vector.add(string4);
        }
        stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.get(i);
        }
        dbDatum = new DbDatum("Services");
        dbDatum.insert(stringArray);
        this.put_property(database, "CtrlSystem", new DbDatum[]{dbDatum});
    }

    public void unregisterService(Database database, String string, String string2, String string3) throws DevFailed {
        String[] stringArray = new String[]{};
        DbDatum dbDatum = this.get_property(database, "CtrlSystem", "Services");
        if (!dbDatum.is_empty()) {
            stringArray = dbDatum.extractStringArray();
        }
        String string4 = string + "/" + string2;
        string4 = string4.toLowerCase();
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        for (String string5 : stringArray) {
            String string6 = string5.toLowerCase();
            int n = string6.indexOf(58);
            if (n > 0) {
                string6 = string6.substring(0, n);
            }
            if (string6.equals(string4)) {
                bl = true;
                continue;
            }
            vector.add(string5);
        }
        if (bl) {
            stringArray = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                stringArray[i] = (String)vector.get(i);
            }
            dbDatum = new DbDatum("Services");
            dbDatum.insert(stringArray);
            this.put_property(database, "CtrlSystem", new DbDatum[]{dbDatum});
        }
    }

    public int checkAccessControl(Database database, String string) {
        if (database.devname == null) {
            database.devname = database.device.name();
        }
        if (string.equals(database.devname) && database.isAccess_checked()) {
            return database.access;
        }
        int n = 1;
        try {
            if (!database.isAccess_checked() && database.getAccess_proxy() == null) {
                String string2 = ApiUtil.getAccessDevname();
                if (string2 == null || string2.length() == 0) {
                    if (this.access_service_read && !database.check_access) {
                        return 1;
                    }
                    String[] stringArray = this.getServices(database, "AccessControl", "*");
                    if (stringArray.length > 0) {
                        string2 = stringArray[0];
                    } else {
                        database.check_access = false;
                        this.access_service_read = true;
                        return 1;
                    }
                }
                database.setAccess_proxy(new AccessProxy(string2));
            }
            if (database.getAccess_proxy() != null) {
                n = database.getAccess_proxy().checkAccessControl(string);
            }
            if (!database.isAccess_checked() && !string.equals(database.device.name())) {
                this.checkAccess(database);
            }
        }
        catch (DevFailed devFailed) {
            n = 0;
            if (devFailed.errors.length > 1 && devFailed.errors[1].reason.equals("TangoApi_CANNOT_IMPORT_DEVICE")) {
                devFailed.errors[0].desc = devFailed.errors[0].desc + "\nControlled access service defined in Db but unreachable --> Read Only access given to all devices...";
            }
            database.setAccess_devfailed(devFailed);
            Except.print_exception(devFailed);
        }
        return n;
    }

    public boolean isCommandAllowed(Database database, String string, String string2) throws DevFailed {
        if (database.getAccess_proxy() == null) {
            if (!database.isAccess_checked()) {
                this.checkAccess(database);
            }
            return !database.check_access;
        }
        return database.getAccess_proxy().isCommandAllowed(string, string2);
    }
}

