/*
 * Decompiled with CFR 0.152.
 */
package tool_panels.spectrum_histo;

import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import tool_panels.spectrum_histo.AttributeBrowserTree;

public class AttributeBrowser
extends JDialog {
    private Component parent;
    private JMenuItem exitItem;
    private JMenu fileMenu;
    private JPanel jPanel1;
    private JMenuBar menuBar;
    private JTextArea textArea;
    private JScrollPane textScrollPane;
    private JScrollPane treeScrollPane;

    public AttributeBrowser(JFrame parent) {
        super((Frame)parent, true);
        this.parent = parent;
        this.buildAttributeBrowser();
    }

    public AttributeBrowser(JDialog parent) {
        super((Dialog)parent, true);
        this.parent = parent;
        this.buildAttributeBrowser();
    }

    public void buildAttributeBrowser() {
        this.initComponents();
        try {
            AttributeBrowserTree tree = new AttributeBrowserTree(this);
            this.treeScrollPane.setViewportView(tree);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
        this.fileMenu.setMnemonic('F');
        this.exitItem.setMnemonic('E');
        this.exitItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.textScrollPane = new JScrollPane();
        this.textArea = new JTextArea();
        this.treeScrollPane = new JScrollPane();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.exitItem = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                AttributeBrowser.this.exitForm(evt);
            }
        });
        this.jPanel1.setLayout(new BorderLayout());
        this.textScrollPane.setPreferredSize(new Dimension(400, 400));
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("Courier New", 1, 12));
        this.textScrollPane.setViewportView(this.textArea);
        this.jPanel1.add((Component)this.textScrollPane, "Center");
        this.treeScrollPane.setPreferredSize(new Dimension(300, 400));
        this.jPanel1.add((Component)this.treeScrollPane, "West");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.fileMenu.setText("File");
        this.exitItem.setText("Exit");
        this.exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttributeBrowser.this.exitItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitItem);
        this.menuBar.add(this.fileMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void exitItemActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void exitForm(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        if (this.parent.getWidth() > 0) {
            this.setVisible(false);
            this.dispose();
        } else {
            System.exit(0);
        }
    }

    void setText(String str) {
        this.textArea.setText(str);
        this.textArea.setCaretPosition(0);
    }

    public static void main(String[] args) {
        try {
            AttributeBrowser db = new AttributeBrowser(new JFrame());
            db.setVisible(true);
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)new JFrame(), null, (Exception)e);
        }
    }
}

