/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import fr.esrf.TangoDs.TangoConst;
import pogo.gene.PogoDefs;
import pogo.gene.PogoString;

public class TangoTypes
implements TangoConst,
PogoDefs {
    public int code;
    public String cpp_code_str;
    public String java_code_str;
    public String cpp;
    public String java;
    public String description;
    public boolean is_array;
    public boolean need_constr;
    public boolean need_2constr;

    public TangoTypes(String type, String desc) {
        this(type);
        if (desc != null) {
            this.description = desc;
        }
    }

    public TangoTypes(String type) {
        if (type.indexOf("Tango_") >= 0) {
            type = this.to_cpp_code_str(type);
        }
        if (type.equals("Tango::DevVoid")) {
            this.createType("Tango::DEV_VOID");
        } else if (type.equals("Tango::DevBoolean") || type.equals("boolean")) {
            this.createType("Tango::DEV_BOOLEAN");
        } else if (type.equals("Tango::DEV_UCHAR") || type.equals("byte")) {
            this.createType("Tango::DEV_UCHAR");
        } else if (type.equals("Tango::DevShort") || type.equals("short")) {
            this.createType("Tango::DEV_SHORT");
        } else if (type.equals("Tango::DevLong") || type.equals("int")) {
            this.createType("Tango::DEV_LONG");
        } else if (type.equals("Tango::DevLong64") || type.equals("long")) {
            this.createType("Tango::DEV_LONG64");
        } else if (type.equals("Tango::DevUShort")) {
            this.createType("Tango::DEV_USHORT");
        } else if (type.equals("Tango::DevULong")) {
            this.createType("Tango::DEV_ULONG");
        } else if (type.equals("Tango::DevULong64")) {
            this.createType("Tango::DEV_ULONG64");
        } else if (type.equals("Tango::DevFloat") || type.equals("float")) {
            this.createType("Tango::DEV_FLOAT");
        } else if (type.equals("Tango::DevDouble") || type.equals("double")) {
            this.createType("Tango::DEV_DOUBLE");
        } else if (type.equals("Tango::DevEncoded")) {
            this.createType("Tango::DEV_ENCODED");
        } else if (type.equals("Tango::DevVarCharArray") || type.equals("char[]")) {
            this.createType("Tango::DEVVAR_CHARARRAY");
        } else if (type.equals("Tango::DevVarShortArray") || type.equals("short[]")) {
            this.createType("Tango::DEVVAR_SHORTARRAY");
        } else if (type.equals("Tango::DevVarLongArray") || type.equals("int[]")) {
            this.createType("Tango::DEVVAR_LONGARRAY");
        } else if (type.equals("Tango::DevVarLong64Array") || type.equals("long[]")) {
            this.createType("Tango::DEVVAR_LONG64ARRAY");
        } else if (type.equals("Tango::DevVarFloatArray") || type.equals("float[]")) {
            this.createType("Tango::DEVVAR_FLOATARRAY");
        } else if (type.equals("Tango::DevVarDoubleArray") || type.equals("double[]")) {
            this.createType("Tango::DEVVAR_DOUBLEARRAY");
        } else if (type.equals("Tango::DevVarULongArray")) {
            this.createType("Tango::DEVVAR_ULONGARRAY");
        } else if (type.equals("Tango::DevVarULong64Array")) {
            this.createType("Tango::DEVVAR_ULONG64ARRAY");
        } else if (type.equals("Tango::DevVarUShortArray")) {
            this.createType("Tango::DEVVAR_USHORTARRAY");
        } else if (type.equals("Tango::ConstDevString")) {
            this.createType("Tango::CONST_DEV_STRING");
        } else if (type.equals("Tango::DevString") || type.equals("string")) {
            this.createType("Tango::DEV_STRING");
        } else if (type.equals("Tango::DevVarStringArray") || type.equals("string[]")) {
            this.createType("Tango::DEVVAR_STRINGARRAY");
        } else if (type.equals("Tango::DevVarLongStringArray")) {
            this.createType("Tango::DEVVAR_LONGSTRINGARRAY");
        } else if (type.equals("Tango::DevVarDoubleStringArray")) {
            this.createType("Tango::DEVVAR_DOUBLESTRINGARRAY");
        } else {
            this.createType(type);
        }
    }

    String pyType() {
        if (this.cpp.equals("void")) {
            return "PyTango.DevVoid";
        }
        if (this.cpp.indexOf("vector") >= 0) {
            String type = this.cpp.substring(this.cpp.indexOf(60) + 1, this.cpp.indexOf(62));
            type = type.substring(0, 1).toUpperCase() + type.substring(1);
            return "PyTango.DevVar" + type + "Array";
        }
        int idx = this.cpp.indexOf("::");
        return "PyTango." + this.cpp.substring(idx + 2);
    }

    private void createType(String type) {
        this.cpp_code_str = type;
        this.java_code_str = this.to_java_code_str();
        if (type.equals("Tango::DEV_VOID")) {
            this.code = 0;
            this.cpp = "void";
            this.java = "void";
            this.is_array = false;
            this.need_constr = false;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEV_BOOLEAN")) {
            this.code = 1;
            this.cpp = "Tango::DevBoolean";
            this.java = "boolean";
            this.is_array = false;
            this.need_constr = false;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEV_SHORT")) {
            this.code = 2;
            this.cpp = "Tango::DevShort";
            this.java = "short";
            this.is_array = false;
            this.need_constr = false;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEV_LONG")) {
            this.code = 3;
            this.cpp = "Tango::DevLong";
            this.java = "int";
            this.is_array = false;
            this.need_constr = false;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEV_LONG64")) {
            this.code = 23;
            this.cpp = "Tango::DevLong64";
            this.java = "long";
            this.is_array = false;
            this.need_constr = false;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEV_FLOAT")) {
            this.code = 4;
            this.cpp = "Tango::DevFloat";
            this.java = "float";
            this.is_array = false;
            this.need_constr = false;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEV_DOUBLE")) {
            this.code = 5;
            this.cpp = "Tango::DevDouble";
            this.java = "double";
            this.is_array = false;
            this.need_constr = false;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEV_UCHAR")) {
            this.code = 6;
            this.cpp = "Tango::DevUChar";
            this.java = "byte";
            this.is_array = false;
            this.need_constr = false;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEV_USHORT")) {
            this.code = 6;
            this.cpp = "Tango::DevUShort";
            this.java = "int";
            this.is_array = false;
            this.need_constr = false;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEV_ULONG")) {
            this.code = 7;
            this.cpp = "Tango::DevULong";
            this.java = "int";
            this.is_array = false;
            this.need_constr = false;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEV_ULONG64")) {
            this.code = 24;
            this.cpp = "Tango::DevULong64";
            this.java = "long";
            this.is_array = false;
            this.need_constr = false;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEV_ENCODED")) {
            this.code = 28;
            this.cpp = "Tango::DevEncoded";
            this.java = "DevEncoded";
            this.is_array = false;
            this.need_constr = true;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEVVAR_CHARARRAY")) {
            this.code = 9;
            this.cpp = "Tango::DevVarCharArray";
            this.java = "byte[]";
            this.is_array = true;
            this.need_constr = true;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEVVAR_SHORTARRAY")) {
            this.code = 10;
            this.cpp = "Tango::DevVarShortArray";
            this.java = "short[]";
            this.is_array = true;
            this.need_constr = true;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEVVAR_LONGARRAY")) {
            this.code = 11;
            this.cpp = "Tango::DevVarLongArray";
            this.java = "int[]";
            this.is_array = true;
            this.need_constr = true;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEVVAR_LONG64ARRAY")) {
            this.code = 25;
            this.cpp = "Tango::DevVarLong64Array";
            this.java = "long[]";
            this.is_array = true;
            this.need_constr = true;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEVVAR_ULONG64ARRAY")) {
            this.code = 25;
            this.cpp = "Tango::DevVarULong64Array";
            this.java = "long[]";
            this.is_array = true;
            this.need_constr = true;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEVVAR_FLOATARRAY")) {
            this.code = 12;
            this.cpp = "Tango::DevVarFloatArray";
            this.java = "float[]";
            this.is_array = true;
            this.need_constr = true;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEVVAR_DOUBLEARRAY")) {
            this.code = 13;
            this.cpp = "Tango::DevVarDoubleArray";
            this.java = "double[]";
            this.is_array = true;
            this.need_constr = true;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEVVAR_USHORTARRAY")) {
            this.code = 14;
            this.cpp = "Tango::DevVarUShortArray";
            this.java = "short[]";
            this.is_array = true;
            this.need_constr = true;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEVVAR_ULONGARRAY")) {
            this.code = 15;
            this.cpp = "Tango::DevVarULongArray";
            this.java = "int[]";
            this.is_array = true;
            this.need_constr = true;
        } else if (type.equals("Tango::DEVVAR_ULONG64ARRAY")) {
            this.code = 26;
            this.cpp = "Tango::DevVarULong64Array";
            this.java = "long[]";
            this.is_array = true;
            this.need_constr = true;
        } else if (type.equals("Tango::CONST_DEV_STRING")) {
            this.code = -2;
            this.cpp = "Tango::ConstDevString";
            this.java = "String";
            this.is_array = false;
            this.need_constr = false;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEV_STRING")) {
            this.code = 8;
            this.cpp = "Tango::DevString";
            this.java = "String";
            this.is_array = false;
            this.need_constr = true;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEVVAR_STRINGARRAY")) {
            this.code = 16;
            this.cpp = "Tango::DevVarStringArray";
            this.java = "String[]";
            this.is_array = true;
            this.need_constr = true;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEVVAR_LONGSTRINGARRAY")) {
            this.code = 17;
            this.cpp = "Tango::DevVarLongStringArray";
            this.java = "DevVarLongStringArray";
            this.is_array = true;
            this.need_constr = true;
            this.need_2constr = true;
        } else if (type.equals("Tango::DEVVAR_DOUBLESTRINGARRAY")) {
            this.code = 18;
            this.cpp = "Tango::DevVarDoubleStringArray";
            this.java = "DevVarDoubleStringArray";
            this.is_array = true;
            this.need_constr = true;
            this.need_2constr = true;
        } else if (type.equals("Tango::DEV_STATE")) {
            this.code = 19;
            this.cpp = "Tango::DevState";
            this.java = "DevState";
            this.is_array = false;
            this.need_constr = false;
            this.need_2constr = false;
        } else if (type.equals("string") || type.equals("String")) {
            this.code = 8;
            this.cpp_code_str = "string";
            this.cpp = "string";
            this.java = "String";
            this.is_array = true;
            this.need_constr = true;
            this.need_2constr = false;
        } else if (type.equals("Array of short") || type.equals("vector<short>") || type.equals("short[]")) {
            this.code = 10;
            this.cpp_code_str = "Array of short";
            this.cpp = "vector<short>";
            this.java = "short[]";
            this.is_array = true;
            this.need_constr = true;
            this.need_2constr = false;
        } else if (type.equals("Array of long") || type.equals("vector<long>") || type.equals("int[]")) {
            this.code = 11;
            this.cpp_code_str = "Array of long";
            this.cpp = "vector<long>";
            this.java = "int[]";
            this.is_array = true;
            this.need_constr = true;
            this.need_2constr = false;
        } else if (type.equals("Array of float") || type.equals("vector<float>") || type.equals("float[]")) {
            this.code = 12;
            this.cpp_code_str = "Array of float";
            this.cpp = "vector<float>";
            this.java = "float[]";
            this.is_array = true;
            this.need_constr = true;
            this.need_2constr = false;
        } else if (type.equals("Array of double") || type.equals("vector<double>") || type.equals("double[]")) {
            this.code = 13;
            this.cpp_code_str = "Array of double";
            this.cpp = "vector<double>";
            this.java = "double[]";
            this.is_array = true;
            this.need_constr = true;
            this.need_2constr = false;
        } else if (type.equals("Array of string") || type.equals("vector<string>") || type.equals("String[]")) {
            this.code = 16;
            this.cpp_code_str = "Array of string";
            this.cpp = "vector<string>";
            this.java = "String[]";
            this.is_array = true;
            this.need_constr = true;
            this.need_2constr = true;
        } else {
            System.out.println("WARNING: Tango type (" + type + ") Unknown !");
            this.code = -1;
            this.cpp = type;
            this.java = type;
            this.is_array = false;
            this.need_constr = false;
            this.need_2constr = false;
        }
    }

    public void setDescription(String str) {
        this.description = str;
    }

    public String javaExtract() {
        String cpp_namespace = "::";
        int start = this.cpp.indexOf(cpp_namespace);
        String s = start > 0 ? this.cpp.substring(start + cpp_namespace.length()) : this.cpp;
        return "extract_" + s;
    }

    private String to_java_code_str() {
        if (this.cpp_code_str.indexOf("Tango::") < 0) {
            return this.cpp_code_str;
        }
        StringBuffer sb = new StringBuffer("Tango_");
        int start = this.cpp_code_str.indexOf("Tango::") + "Tango::".length();
        sb.append(this.cpp_code_str.substring(start));
        return sb.toString();
    }

    private String to_cpp_code_str(String code_str) {
        String java_begin = "Tango_";
        if (code_str.indexOf(java_begin) < 0) {
            return code_str;
        }
        StringBuffer sb = new StringBuffer("Tango::");
        int start = code_str.indexOf(java_begin) + java_begin.length();
        sb.append(code_str.substring(start));
        return sb.toString();
    }

    public String extract_java_method() {
        String str = "extract";
        if (this.code == 3 || this.code == 11) {
            str = str + "Long";
            if (this.is_array) {
                str = str + "Array";
            }
        } else {
            str = str + this.java.substring(0, 1).toUpperCase();
            PogoString pg = new PogoString(this.java.substring(1));
            pg.replace("[]", "Array");
            str = str + pg.str;
        }
        return str + "()";
    }

    public String extract_method() {
        StringBuffer sb = new StringBuffer("extract");
        String target = "DevVar";
        int start = this.cpp.indexOf(target);
        if (start > 0) {
            sb.append(this.cpp.substring(start + target.length()));
        } else {
            target = "Dev";
            start = this.cpp.indexOf(target);
            if (start > 0) {
                sb.append(this.cpp.substring(start + target.length()));
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.cpp_code_str + "\t" + this.cpp + "\t" + this.java + "\n");
        if (this.is_array) {
            sb.append("Is an Array and ");
        } else {
            sb.append("Is Not an Array and ");
        }
        if (this.need_constr) {
            sb.append("Needs Constructor");
        } else {
            sb.append("Doesn't Needs Constructor\n");
        }
        return sb.toString();
    }
}

