/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import fr.esrf.TangoDs.TangoConst;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import pogo.gene.Attrib;
import pogo.gene.Cmd;
import pogo.gene.DeviceID;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoGene;
import pogo.gene.PogoString;
import pogo.gene.PogoUtil;

public class PogoGenePython
extends PogoGene
implements PogoDefs,
TangoConst {
    private String new_code;
    private String read_code = "";

    public PogoGenePython(PogoClass pogo) {
        super(pogo);
        for (int i = 0; i < pogo.commands.size(); ++i) {
            Cmd cmd = pogo.commands.cmdAt(i);
            cmd.exec_method = cmd.name.equals("Status") ? "dev_status" : (cmd.name.equals("State") ? "dev_state" : cmd.name);
        }
    }

    private void addHeaderTables() {
        String target;
        int start;
        String empty_line = "#\n";
        String tables = "#==================================================================\n" + this.pogo.buildPyDescription() + empty_line + "#==================================================================\n";
        if (this.pogo.states.size() > 0) {
            tables = tables + this.pogo.states.toStringComments(2) + "#==================================================================\n";
        }
        if ((start = this.new_code.indexOf(target = "class " + this.pogo.class_name + "(PyTango.Device_" + 4 + "Impl):")) < 0) {
            return;
        }
        start = this.new_code.lastIndexOf("\n", start);
        this.new_code = this.new_code.substring(0, start) + tables + "\n" + this.new_code.substring(start);
    }

    private void addReadAttributeMethods() throws FileNotFoundException, SecurityException, IOException, PogoException {
        String template = PogoUtil.readFile(this.pogo.templates_dir + "/python/Attribute.py");
        this.new_code = this.pogo.attributes.updatePyAttributes(this.new_code, this.read_code, template, this.pogo.class_name);
    }

    private void addCommandExecMethods() throws FileNotFoundException, SecurityException, IOException, PogoException {
        String template = PogoUtil.readFile(this.pogo.templates_dir + "/python/Command.py");
        this.new_code = this.pogo.commands.updatePyCommands(this.new_code, this.read_code, template, this.pogo.class_name);
    }

    static int pyEndMethod(String str) {
        return PogoGenePython.pyEndMethod(str, 0);
    }

    static int pyEndMethod(String str, int idx) {
        for (int i = idx; i < str.length(); ++i) {
            if (str.charAt(i) != '\n' || str.charAt(i + 1) == ' ' || str.charAt(i + 1) == '\t') continue;
            return i + 1;
        }
        return -1;
    }

    private void addFactories() throws SecurityException, PogoException {
        String class_prop_list = this.pogo.class_properties.buildPyFactory();
        String dev_prop_list = this.pogo.dev_properties.buildPyFactory();
        String cmd_list = this.pogo.commands.buildCommandFactoryMethod(2);
        String att_list = this.pogo.attributes.buildFactory(2);
        int start = -1;
        for (int i = 0; start < 0 && i < PogoUtil.py_target.length; ++i) {
            start = this.new_code.indexOf(PogoUtil.py_target[i]);
        }
        if (start < 0) {
            throw new PogoException("Template Syntax error on DeviceClass definition");
        }
        String target = "class_property_list = {";
        start = this.new_code.indexOf(target, start);
        start = this.new_code.indexOf("\n", start) + 1;
        this.new_code = this.new_code.substring(0, start) + class_prop_list + this.new_code.substring(start);
        target = "device_property_list = {";
        start = this.new_code.indexOf(target, start);
        start = this.new_code.indexOf("\n", start) + 1;
        this.new_code = this.new_code.substring(0, start) + dev_prop_list + this.new_code.substring(start);
        target = "cmd_list = {";
        start = this.new_code.indexOf(target, start);
        start = this.new_code.indexOf("\n", start) + 1;
        this.new_code = this.new_code.substring(0, start) + cmd_list + this.new_code.substring(start);
        target = "attr_list = {";
        start = this.new_code.indexOf(target, start);
        start = this.new_code.indexOf("\n", start) + 1;
        this.new_code = this.new_code.substring(0, start) + att_list + this.new_code.substring(start);
    }

    private Vector getGeneratedMethods() {
        int i;
        Vector<String> v = new Vector<String>();
        v.add("def init_device(self):");
        for (i = 0; i < this.pogo.commands.size(); ++i) {
            Cmd cmd = this.pogo.commands.cmdAt(i);
            if (cmd.virtual_method && cmd.override_method == 0) continue;
            v.add(cmd.buildPyExecCmdMethodSignature());
            if (cmd.virtual_method) continue;
            v.add("def is_" + cmd.name + "_allowed(self):");
        }
        for (i = 0; i < this.pogo.attributes.size(); ++i) {
            Attrib attr = this.pogo.attributes.attributeAt(i);
            v.add("def read_" + attr.name + "(self, attr):");
            if (attr.rwType == 1 || attr.rwType == 2) {
                v.add("def write_" + attr.name + "(self, attr):");
            }
            v.add("def is_" + attr.name + "_allowed(self, req_type):");
        }
        return v;
    }

    private Vector getOtherMethods(String[] existing_methods, Vector generated_methods) {
        Vector<String> methods = new Vector<String>();
        for (String existing_method : existing_methods) {
            boolean found = false;
            for (int j = 0; !found && j < generated_methods.size(); ++j) {
                String s = (String)generated_methods.get(j);
                found = existing_method.startsWith(s);
            }
            if (found) continue;
            methods.add(existing_method);
        }
        return methods;
    }

    private void updateClassOtherMethods() {
        if (this.read_code.equals("")) {
            return;
        }
        int start = this.read_code.indexOf("class " + this.pogo.class_name + "(");
        start = this.read_code.indexOf("class " + this.pogo.class_name + "Class(", start);
        int end = this.read_code.indexOf("if __name__ == '__main__':", start);
        String[] existing_methods = PogoUtil.getPyMethodList(this.read_code.substring(start, end));
        Vector<String> generated_methods = new Vector<String>();
        generated_methods.add("def __init__(self, name):");
        Vector meth_sig = this.getOtherMethods(existing_methods, generated_methods);
        for (Object aMeth_sig : meth_sig) {
            String method = PogoUtil.pythonMethod(this.read_code, (String)aMeth_sig);
            int insert_idx = this.new_code.indexOf("def __init__(self, name):", start);
            insert_idx = PogoUtil.endOfPythonMethod(this.new_code, insert_idx);
            this.new_code = this.new_code.substring(0, insert_idx) + "\n\n" + method + "\n" + this.new_code.substring(insert_idx);
        }
    }

    private void updateOtherMethods() {
        if (this.read_code.equals("")) {
            return;
        }
        int start = this.read_code.indexOf("class " + this.pogo.class_name + "(");
        int end = this.read_code.indexOf("class " + this.pogo.class_name + "Class(", start);
        String[] existing_methods = PogoUtil.getPyMethodList(this.read_code.substring(start, end));
        Vector generated_methods = this.getGeneratedMethods();
        Vector meth_sig = this.getOtherMethods(existing_methods, generated_methods);
        for (int i = meth_sig.size() - 1; i >= 0; --i) {
            String method = PogoUtil.pythonMethod(this.read_code, (String)meth_sig.get(i));
            String dummy_method = PogoUtil.pythonMethod(this.new_code, (String)meth_sig.get(i));
            if (dummy_method != null) {
                start = this.new_code.indexOf(dummy_method);
                end = start + dummy_method.length();
                this.new_code = this.new_code.substring(0, start) + method + this.new_code.substring(end);
                continue;
            }
            int insert_idx = this.new_code.indexOf("def always_executed_hook(self):");
            if (insert_idx < 0) {
                insert_idx = this.new_code.indexOf("def always_excuted_hook(self):");
            }
            insert_idx = insert_idx < 0 ? this.new_code.length() - 1 : PogoUtil.endOfPythonMethod(this.new_code, insert_idx);
            if (method.startsWith("def ")) {
                method = '\t' + method;
            }
            this.new_code = this.new_code.substring(0, insert_idx) + "\n\n" + method + "\n" + this.new_code.substring(insert_idx);
        }
    }

    private void checkMainMethod() {
        if (this.read_code.equals("")) {
            return;
        }
        String meth_sig = "if __name__ == '__main__':";
        String read_method = PogoUtil.pythonMethod(this.read_code, meth_sig) + "\n";
        if (read_method != null && !read_method.equals("")) {
            int idx = this.new_code.indexOf(meth_sig);
            this.new_code = this.new_code.substring(0, idx) + read_method;
        }
    }

    private void addHeader() {
        if (this.read_code.equals("")) {
            return;
        }
        int end = this.read_code.indexOf(this.pogo.class_name + " Class Description:");
        if (end < 0) {
            return;
        }
        int idx = end;
        if ((end = this.read_code.lastIndexOf("#==============", end)) < 0) {
            end = this.read_code.lastIndexOf(10, idx - 1);
            end = this.read_code.lastIndexOf(10, end - 1);
        }
        String read_header = this.read_code.substring(0, end);
        end = this.new_code.indexOf("class " + this.pogo.class_name + "(");
        if (end < 0) {
            return;
        }
        end = this.new_code.lastIndexOf(10, end);
        end = this.new_code.lastIndexOf(10, end);
        String templ_header = this.new_code.substring(0, end);
        PogoString pgs = new PogoString(this.new_code);
        pgs.replace(templ_header, read_header);
        int start = this.read_code.indexOf("Add you global variables here");
        if (start < 0) {
            this.new_code = pgs.str;
            return;
        }
        start = this.read_code.lastIndexOf(10, start);
        end = this.read_code.indexOf("Device constructor", start);
        end = this.read_code.lastIndexOf(10, end);
        String read_declaration = this.read_code.substring(start, end);
        start = pgs.str.indexOf("Add you global variables here");
        if (start < 0) {
            this.new_code = pgs.str;
            return;
        }
        start = pgs.str.lastIndexOf(10, start);
        end = pgs.str.indexOf("Device constructor", start);
        end = pgs.str.lastIndexOf(10, end);
        String templ_declaration = pgs.str.substring(start, end);
        pgs.replace(templ_declaration, read_declaration);
        this.new_code = pgs.str;
    }

    private void manageInit() {
        if (this.read_code.equals("")) {
            return;
        }
        String old_method = PogoUtil.pythonMethod(this.read_code, "def init_device(self):");
        String new_method = PogoUtil.pythonMethod(this.new_code, "def init_device(self):");
        PogoString pgs = new PogoString(this.new_code);
        pgs.replace(new_method, old_method);
        this.new_code = pgs.str;
    }

    public void generate() throws FileNotFoundException, SecurityException, IOException, PogoException {
        String server = this.pogo.projectFiles.getPath() + "/" + this.pogo.class_name + ".py";
        this.strTrace = "python source code generation:\n\n";
        if (this.writeDeviceIdFile()) {
            this.strTrace = this.strTrace + DeviceID.getFilename(server) + "     Created\n";
        }
        if (new File(server).exists()) {
            this.read_code = new PogoString((String)PogoUtil.readFile((String)server)).str;
        }
        this.new_code = PogoUtil.removeLogMessages((PogoString)new PogoString((String)PogoUtil.readFile((String)new StringBuilder().append((String)this.pogo.templates_dir).append((String)"/python/DevServ.py").toString(), (String)"TemplateDevServ", (String)this.pogo.class_name))).str;
        this.addHeader();
        this.manageInit();
        this.addFactories();
        this.addCommandExecMethods();
        this.addReadAttributeMethods();
        this.addHeaderTables();
        this.updateOtherMethods();
        this.updateClassOtherMethods();
        this.checkMainMethod();
        this.updateDeviceImpl();
        String save = System.getProperty("SAVE");
        if (save == null || save.equals("true")) {
            PogoUtil.writeFile(server, this.new_code);
        }
        this.strTrace = this.strTrace + server + "   generated.";
    }

    private void updateDeviceImpl() {
        int start;
        String new_str = "Device_4Impl";
        String old_str = "Device_3Impl";
        while ((start = this.new_code.indexOf(old_str)) > 0) {
            this.new_code = this.new_code.substring(0, start) + new_str + this.new_code.substring(start + old_str.length());
        }
        new_str = "Util";
        old_str = "PyUtil";
        while ((start = this.new_code.indexOf(old_str)) > 0) {
            this.new_code = this.new_code.substring(0, start) + new_str + this.new_code.substring(start + old_str.length());
        }
        new_str = "DeviceClass";
        old_str = "pyDeviceClass";
        while ((start = this.new_code.indexOf(old_str)) > 0) {
            this.new_code = this.new_code.substring(0, start) + new_str + this.new_code.substring(start + old_str.length());
        }
    }

    public void changeClassName() throws FileNotFoundException, SecurityException, IOException, PogoException {
        String old_classname = this.pogo.projectFiles.getOriginalClassName();
        String old_server = this.pogo.projectFiles.getPath() + "/" + old_classname + ".py";
        PogoString code = new PogoString(PogoUtil.readFile(old_server));
        int idx = 0;
        while ((idx = code.indexOf(old_classname, idx)) > 0) {
            code.replace(idx, old_classname, this.pogo.class_name);
            ++idx;
        }
        String new_server = this.pogo.projectFiles.getPath() + "/" + this.pogo.class_name + ".py";
        PogoUtil.writeFile(new_server, code.str);
    }
}

