/*
 * Decompiled with CFR 0.152.
 */
package pogo.class2www;

import java.io.IOException;
import java.util.Date;
import java.util.Vector;
import pogo.class2www.Module;
import pogo.class2www.Repository;
import pogo.class2www.Utils;
import pogo.gene.PogoUtil;

public class Family
extends Vector {
    public String name;

    public Family(String name) {
        this.name = name;
    }

    public Module getModule(int i) {
        return (Module)this.get(i);
    }

    public Module getModule(String name) {
        for (Object o : this) {
            if (!((Module)o).name.equals(name)) continue;
            return (Module)o;
        }
        return null;
    }

    public void sort() {
        Utils.getInstance().sort(this);
    }

    public int nbClasses() {
        int nb = 0;
        for (Object o : this) {
            Module module = (Module)o;
            if (module.server == null) continue;
            ++nb;
        }
        return nb;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.name);
        sb.append("\n");
        for (Object o : this) {
            sb.append("\t").append(o).append("\n");
        }
        return sb.toString();
    }

    public void generateHtmlPage(String header, String footer, Repository repos) {
        StringBuffer sb = new StringBuffer(header);
        sb.append("<Center><b>\nWARNING:\nThese classes have been developped for a specific usage\nand are not guaranteed for all platforms.\n</Center></b>\n<Br>\n<Br>\n\n");
        String str = this.buildTableHeader(repos.name);
        sb.append(str);
        for (Object o : this) {
            Module module = (Module)o;
            str = module.getTableLine();
            sb.append(str);
        }
        str = this.buildTableFooter();
        sb.append(str);
        sb.append(footer);
        try {
            PogoUtil.writeFile(repos.name + "/" + this.name + "/" + "index.html", sb.toString());
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public String getListLine(Repository repository) {
        String link = "";
        if (repository.home.equals(".")) {
            link = repository.name + "/";
        }
        link = link + this.name + "/" + "index.html";
        String line = "<li> <a href=\"$LINK\" Target=\"right\">\t$TEXT </a>\n";
        line = PogoUtil.strReplace(line, "$LINK", link);
        line = PogoUtil.strReplace(line, "$TEXT", this.name);
        return line;
    }

    private String buildTableHeader(String repos_name) {
        String str = "<Table Border=2 Cellpadding=3 CELLSPACING=0 WIDTH=\"100%\">\n<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\n<Td COLSPAN=4> <Font Size=+2><Center><b> $NUMBER $FAMILY  Classes  hosted by $REPOSITORY</b></td></Font></Center>\n<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\n<Td><Center><b>Class Name</b></td></Center>\n<Td><Center><Font Size=-1> <b>Lang</b></Font></td></Center>\n<Td><Center><Font Size=-1><b>Repos</b></Font></td></Center>\n\n<Td><Center><b>Description</b></td></Center>\n\n";
        str = PogoUtil.strReplace(str, "$NUMBER", Integer.toString(this.nbClasses()));
        str = PogoUtil.strReplace(str, "$FAMILY", this.name);
        str = PogoUtil.strReplace(str, "$REPOSITORY", repos_name);
        return str;
    }

    private String buildTableFooter() {
        String str = "</Table>\n<br>\n\n<br>\n<br>\n<Center>\nLast Update: $DATE\n</Center>\n";
        str = PogoUtil.strReplace(str, "$DATE", new Date().toString());
        return str;
    }
}

