/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.frame.ContrastAdjuster;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

public class CompositeImage
extends ImagePlus {
    int[] awtImagePixels;
    boolean newPixels;
    MemoryImageSource imageSource;
    ColorModel imageColorModel;
    Image awtImage;
    int[][] pixels;
    ImageProcessor[] cip;
    Color[] colors = new Color[]{Color.red, Color.green, Color.blue, Color.white, Color.cyan, Color.magenta, Color.yellow};
    int currentChannel = 0;
    static int count;
    boolean singleChannel;

    public CompositeImage(ImagePlus imp, int channels) {
        boolean isRGB = imp.getBitDepth() == 24;
        ImageStack stack2 = isRGB ? this.getRGBStack(imp) : imp.getStack();
        int stackSize = stack2.getSize();
        if (channels < 2 || stackSize % channels != 0) {
            throw new IllegalArgumentException("channels<2 or stacksize not multiple of channels");
        }
        this.compositeImage = true;
        this.setDimensions(channels, stackSize / channels, 1);
        this.setup(channels, stack2);
        this.setStack(imp.getTitle(), stack2);
        this.setCalibration(imp.getCalibration());
        Object info = imp.getProperty("Info");
        if (info != null) {
            this.setProperty("Info", imp.getProperty("Info"));
        }
    }

    public Image getImage() {
        if (this.img == null) {
            this.updateImage();
        }
        return this.img;
    }

    public void updateChannelAndDraw() {
        this.singleChannel = true;
        this.updateAndDraw();
    }

    public ImageProcessor getChannelProcessor() {
        return this.cip[this.currentChannel];
    }

    void setup(int channels, ImageStack stack2) {
        this.cip = new ImageProcessor[channels];
        for (int i = 0; i < channels; ++i) {
            this.cip[i] = stack2.getProcessor(i + 1);
            this.cip[i].resetMinAndMax();
            this.cip[i].setColorModel(CompositeImage.createModelFromColor(this.colors[i]));
        }
    }

    public void updateImage() {
        block34: {
            int nChannels;
            int imageSize;
            block33: {
                imageSize = this.width * this.height;
                nChannels = this.getNChannels();
                int slice = this.getCurrentSlice();
                if (nChannels == 1) {
                    this.pixels = null;
                    this.awtImagePixels = null;
                    if (this.ip != null) {
                        this.img = this.ip.createImage();
                    }
                    return;
                }
                if (this.cip != null && this.cip[0].getWidth() != this.width || this.cip[0].getHeight() != this.height || this.pixels != null && this.pixels.length != nChannels) {
                    this.setup(nChannels, this.getStack());
                    this.pixels = null;
                    this.awtImagePixels = null;
                    if (slice > nChannels) {
                        this.setSlice(1);
                        slice = 1;
                    }
                }
                if (slice > nChannels) {
                    slice = nChannels;
                }
                if (slice - 1 != this.currentChannel) {
                    this.currentChannel = slice - 1;
                    this.getProcessor().setMinAndMax(this.cip[this.currentChannel].getMin(), this.cip[this.currentChannel].getMax());
                    ContrastAdjuster.update();
                }
                if (this.awtImagePixels == null) {
                    this.awtImagePixels = new int[imageSize];
                    this.newPixels = true;
                    this.imageSource = null;
                }
                if (this.pixels == null || this.pixels.length != nChannels || this.pixels[0].length != imageSize) {
                    this.pixels = new int[nChannels][];
                    for (int i = 0; i < nChannels; ++i) {
                        this.pixels[i] = new int[imageSize];
                    }
                }
                ImageProcessor ip = this.getProcessor();
                this.cip[this.currentChannel].setMinAndMax(ip.getMin(), ip.getMax());
                if (this.singleChannel) {
                    PixelGrabber pg = new PixelGrabber(this.cip[this.currentChannel].createImage(), 0, 0, this.width, this.height, this.pixels[this.currentChannel], 0, this.width);
                    try {
                        pg.grabPixels();
                    }
                    catch (InterruptedException e) {}
                } else {
                    for (int i = 0; i < nChannels; ++i) {
                        PixelGrabber pg = new PixelGrabber(this.cip[i].createImage(), 0, 0, this.width, this.height, this.pixels[i], 0, this.width);
                        try {
                            pg.grabPixels();
                            continue;
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                }
                if (!this.singleChannel || nChannels > 3) break block33;
                switch (this.currentChannel) {
                    case 0: {
                        for (int i = 0; i < imageSize; ++i) {
                            int redValue = this.pixels[0][i] >> 16 & 0xFF;
                            this.awtImagePixels[i] = this.awtImagePixels[i] & 0xFF00FFFF | redValue << 16;
                        }
                        break block34;
                    }
                    case 1: {
                        for (int i = 0; i < imageSize; ++i) {
                            int greenValue = this.pixels[1][i] >> 8 & 0xFF;
                            this.awtImagePixels[i] = this.awtImagePixels[i] & 0xFFFF00FF | greenValue << 8;
                        }
                        break block34;
                    }
                    case 2: {
                        for (int i = 0; i < imageSize; ++i) {
                            int blueValue = this.pixels[2][i] & 0xFF;
                            this.awtImagePixels[i] = this.awtImagePixels[i] & 0xFFFFFF00 | blueValue;
                        }
                        break;
                    }
                }
                break block34;
            }
            for (int i = 0; i < imageSize; ++i) {
                int redValue = 0;
                int greenValue = 0;
                int blueValue = 0;
                for (int j = 0; j < nChannels; ++j) {
                    greenValue += this.pixels[j][i] >> 8 & 0xFF;
                    blueValue += this.pixels[j][i] & 0xFF;
                    if ((redValue += this.pixels[j][i] >> 16 & 0xFF) > 255) {
                        redValue = 255;
                    }
                    if (greenValue > 255) {
                        greenValue = 255;
                    }
                    if (blueValue <= 255) continue;
                    blueValue = 255;
                }
                this.awtImagePixels[i] = redValue << 16 | greenValue << 8 | blueValue;
            }
        }
        if (this.imageSource == null) {
            this.imageColorModel = new DirectColorModel(32, 0xFF0000, 65280, 255);
            this.imageSource = new MemoryImageSource(this.width, this.height, this.imageColorModel, this.awtImagePixels, 0, this.width);
            this.imageSource.setAnimated(true);
            this.imageSource.setFullBufferUpdates(true);
            this.awtImage = Toolkit.getDefaultToolkit().createImage(this.imageSource);
            this.newPixels = false;
        } else if (this.newPixels) {
            this.imageSource.newPixels(this.awtImagePixels, this.imageColorModel, 0, this.width);
            this.newPixels = false;
        } else {
            this.imageSource.newPixels();
        }
        if (this.img == null && this.awtImage != null) {
            this.img = this.awtImage;
        }
        this.singleChannel = false;
    }

    ImageStack getRGBStack(ImagePlus imp) {
        ImageProcessor ip = imp.getProcessor();
        int w = ip.getWidth();
        int h = ip.getHeight();
        int size = w * h;
        byte[] r = new byte[size];
        byte[] g = new byte[size];
        byte[] b2 = new byte[size];
        ((ColorProcessor)ip).getRGB(r, g, b2);
        ImageStack stack = new ImageStack(w, h);
        stack.addSlice("Red", r);
        stack.addSlice("Green", g);
        stack.addSlice("Blue", b2);
        stack.setColorModel(ip.getDefaultColorModel());
        return stack;
    }

    public static IndexColorModel createModelFromColor(Color color) {
        byte[] rLut = new byte[256];
        byte[] gLut = new byte[256];
        byte[] bLut = new byte[256];
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        double rIncr = (double)red / 255.0;
        double gIncr = (double)green / 255.0;
        double bIncr = (double)blue / 255.0;
        for (int i = 0; i < 256; ++i) {
            rLut[i] = (byte)((double)i * rIncr);
            gLut[i] = (byte)((double)i * gIncr);
            bLut[i] = (byte)((double)i * bIncr);
        }
        return new IndexColorModel(8, 256, rLut, gLut, bLut);
    }

    public Color getChannelColor() {
        int index = this.getCurrentSlice() - 1;
        if (index < this.colors.length && this.colors[index] != Color.white) {
            return this.colors[index];
        }
        return Color.black;
    }

    public ImageProcessor getProcessor(int channel) {
        if (this.cip == null || channel > this.cip.length) {
            return null;
        }
        return this.cip[channel - 1];
    }

    public double getMin(int channel) {
        if (this.cip == null || channel > this.cip.length) {
            return 0.0;
        }
        return this.cip[channel - 1].getMin();
    }

    public double getMax(int channel) {
        if (this.cip == null || channel > this.cip.length) {
            return 0.0;
        }
        return this.cip[channel - 1].getMax();
    }
}

