/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.attribute.ANumberSpectrumHelper;

public class UShortSpectrumHelper
extends ANumberSpectrumHelper {
    public UShortSpectrumHelper(IAttribute iAttribute) {
        this.init(iAttribute);
    }

    void insert(double[] dArray) {
        double d = 1.0;
        int[] nArray = new int[dArray.length];
        d = this.attribute.getDisplayUnitFactor();
        DeviceAttribute deviceAttribute = this.attribute.getAttribute();
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (int)(dArray[i] / d);
        }
        deviceAttribute.insert_us(nArray);
    }

    void setMinAlarm(double d) {
        this.setProperty("min_alarm", new Short((short)d));
    }

    void setMaxAlarm(double d) {
        this.setProperty("max_alarm", new Short((short)d));
    }

    void setMinValue(double d) {
        this.setProperty("min_value", new Short((short)d));
    }

    void setMaxValue(double d) {
        this.setProperty("max_value", new Short((short)d));
    }

    void setMinAlarm(double d, boolean bl) {
        this.setProperty("min_alarm", new Short((short)d), bl);
    }

    void setMinWarning(double d) {
        this.setProperty("min_warning", new Short((short)d));
    }

    void setMaxWarning(double d) {
        this.setProperty("max_warning", new Short((short)d));
    }

    void setDeltaT(double d) {
        this.setProperty("delta_t", new Short((short)d));
    }

    void setDeltaVal(double d) {
        this.setProperty("delta_val", new Short((short)d));
    }

    void setMinWarning(double d, boolean bl) {
        this.setProperty("min_warning", new Short((short)d), bl);
    }

    void setMaxWarning(double d, boolean bl) {
        this.setProperty("max_warning", new Short((short)d), bl);
    }

    void setDeltaT(double d, boolean bl) {
        this.setProperty("delta_t", new Short((short)d), bl);
    }

    void setDeltaVal(double d, boolean bl) {
        this.setProperty("delta_val", new Short((short)d), bl);
    }

    void setMaxAlarm(double d, boolean bl) {
        this.setProperty("max_alarm", new Short((short)d), bl);
    }

    void setMinValue(double d, boolean bl) {
        this.setProperty("min_value", new Short((short)d), bl);
    }

    void setMaxValue(double d, boolean bl) {
        this.setProperty("max_value", new Short((short)d), bl);
    }

    double[] getNumberSpectrumValue(DeviceAttribute deviceAttribute) throws DevFailed {
        int[] nArray = deviceAttribute.extractUShortArray();
        int n = deviceAttribute.getNbRead();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = nArray[i];
        }
        return dArray;
    }

    double[] getNumberSpectrumSetPoint(DeviceAttribute deviceAttribute) throws DevFailed {
        int n;
        int[] nArray = deviceAttribute.extractUShortArray();
        int n2 = nArray.length - (n = deviceAttribute.getNbRead());
        if (n2 <= 0) {
            return this.getNumberSpectrumValue(deviceAttribute);
        }
        double[] dArray = new double[n2];
        int n3 = 0;
        for (int i = n; i < nArray.length; ++i) {
            dArray[n3] = nArray[i];
            ++n3;
        }
        return dArray;
    }

    double[] getNumberSpectrumDisplayValue(DeviceAttribute deviceAttribute) throws DevFailed {
        int[] nArray = deviceAttribute.extractUShortArray();
        double d = this.attribute.getDisplayUnitFactor();
        int n = deviceAttribute.getNbRead();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = (double)nArray[i] * d;
        }
        return dArray;
    }

    double[] getNumberSpectrumDisplaySetPoint(DeviceAttribute deviceAttribute) throws DevFailed {
        int[] nArray = deviceAttribute.extractUShortArray();
        int n = deviceAttribute.getNbRead();
        int n2 = nArray.length - n;
        double d = this.attribute.getDisplayUnitFactor();
        if (n2 <= 0) {
            return this.getNumberSpectrumDisplayValue(deviceAttribute);
        }
        double[] dArray = new double[n2];
        int n3 = 0;
        for (int i = n; i < nArray.length; ++i) {
            dArray[n3] = (double)nArray[i] * d;
            ++n3;
        }
        return dArray;
    }

    public String getVersion() {
        return "$Id: UShortSpectrumHelper.java,v 1.11 2009/06/25 18:06:50 poncet Exp $";
    }
}

