/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IDevStateScalarListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import java.io.Serializable;

class DevStateScalarHelper
implements Serializable {
    IAttribute attribute;
    EventSupport propChanges;

    public DevStateScalarHelper(IAttribute iAttribute) {
        this.init(iAttribute);
    }

    void init(IAttribute iAttribute) {
        this.setAttribute(iAttribute);
        this.propChanges = ((AAttribute)iAttribute).getPropChanges();
    }

    public void setAttribute(IAttribute iAttribute) {
        this.attribute = iAttribute;
    }

    public IAttribute getAttribute() {
        return this.attribute;
    }

    protected void setProperty(String string, Number number) {
        this.attribute.setProperty(string, number);
        this.attribute.storeConfig();
    }

    protected void setProperty(String string, Number number, boolean bl) {
        this.attribute.setProperty(string, number, bl);
    }

    void fireValueChanged(String string, long l) {
        this.propChanges.fireDevStateScalarEvent((IDevStateScalar)this.attribute, string, l);
    }

    String extract() throws DevFailed {
        return Device.toString(this.attribute.getAttribute().extractState());
    }

    void addDevStateScalarListener(IDevStateScalarListener iDevStateScalarListener) {
        this.propChanges.addDevStateScalarListener(iDevStateScalarListener);
    }

    void removeDevStateScalarListener(IDevStateScalarListener iDevStateScalarListener) {
        this.propChanges.removeDevStateScalarListener(iDevStateScalarListener);
    }

    public String getVersion() {
        return "$Id: DevStateScalarHelper.java,v 1.2 2009/01/26 17:54:51 poncet Exp $";
    }
}

