/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IBooleanScalarListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import java.io.Serializable;

class BooleanScalarHelper
implements Serializable {
    IAttribute attribute;
    EventSupport propChanges;

    public BooleanScalarHelper(IAttribute iAttribute) {
        this.init(iAttribute);
    }

    void init(IAttribute iAttribute) {
        this.setAttribute(iAttribute);
        this.propChanges = ((AAttribute)iAttribute).getPropChanges();
    }

    public void setAttribute(IAttribute iAttribute) {
        this.attribute = iAttribute;
    }

    public IAttribute getAttribute() {
        return this.attribute;
    }

    protected void setProperty(String string, Number number) {
        this.attribute.setProperty(string, number);
        this.attribute.storeConfig();
    }

    protected void setProperty(String string, Number number, boolean bl) {
        this.attribute.setProperty(string, number, bl);
    }

    void fireValueChanged(boolean bl, long l) {
        this.propChanges.fireBooleanScalarEvent((IBooleanScalar)this.attribute, bl, l);
    }

    void insert(boolean bl) {
        this.attribute.getAttribute().insert(bl);
    }

    boolean extract() throws DevFailed {
        return this.attribute.getAttribute().extractBoolean();
    }

    void addBooleanScalarListener(IBooleanScalarListener iBooleanScalarListener) {
        this.propChanges.addBooleanScalarListener(iBooleanScalarListener);
    }

    void removeBooleanScalarListener(IBooleanScalarListener iBooleanScalarListener) {
        this.propChanges.removeBooleanScalarListener(iBooleanScalarListener);
    }

    public boolean getBooleanScalarSetPoint(DeviceAttribute deviceAttribute) throws DevFailed {
        boolean[] blArray = null;
        blArray = deviceAttribute.extractBooleanArray();
        if (blArray == null) {
            return false;
        }
        if (blArray.length < 1) {
            return false;
        }
        if (blArray.length > 1) {
            return blArray[1];
        }
        return blArray[0];
    }

    public String getVersion() {
        return "$Id: BooleanScalarHelper.java,v 1.2 2009/01/26 17:54:51 poncet Exp $";
    }
}

